<style>
    input[type=range] {
        -webkit-appearance: none;
        width: 100%;
        background: transparent;
    }

    input[type=range]::-webkit-slider-thumb {
        -webkit-appearance: none;
    }

    input[type=range]:focus {
        outline: none;
    }

    input[type=range]::-ms-track {
        width: 100%;
        cursor: pointer;
        background: transparent;
        border-color: transparent;
        color: transparent;
    }

    input[type=range]::-webkit-slider-thumb {
        -webkit-appearance: none;
        box-shadow: -1px -1px 8px rgba(0, 0, 0, 0.2), 1px 1px 8px rgba(200, 0, 0, 0.2);
        border: none;
        height: 20px;
        width: 20px;
        border-radius: 100%;
        background: #ffffff;
        cursor: pointer;
        margin-top: -6px;
    }

    input[type=range]::-moz-range-thumb {
        box-shadow: -1px -1px 8px rgba(0, 0, 0, 0.2), 1px 1px 8px rgba(200, 0, 0, 0.2);
        border: none;
        height: 20px;
        width: 20px;
        border-radius: 100%;
        background: #ffffff;
        cursor: pointer;
    }

    input[type=range]::-webkit-slider-runnable-track {
        width: 100%;
        height: 8px;
        cursor: pointer;
        background: #6861CE;
        border: none;
        border-radius: 1px;
    }

    input[type=range]:focus::-webkit-slider-runnable-track {
        background: #367ebd;
    }

    input[type=range]::-moz-range-track {
        width: 100%;
        height: 8px;
        cursor: pointer;
        background: #6861CE;
        border: none;
        border-radius: 1px;
    }
</style>
<div class="container" id="appSMS" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Mensajes</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('sms') ?>">SMS/EMAIL</a>
                </li>
            </ul>
            <div class="ml-md-auto" style="display: flex;">
                <div class="btn-group" role="group" aria-label="Button group with nested dropdown" style="box-shadow: 2px 6px 15px 0px rgba(69, 65, 78, 0.1);">
                    <button type="button" class="btn btn-light" @click="obtenertodosmsj()" id="cronSMS">
                        <i class="far fa-paper-plane"></i> SMS
                    </button>
                    <button type="button" class="btn btn-light" @click="cronEMAIL" id="obtenertodosemail()">
                        <i class="far fa-envelope"></i> Email
                    </button>
                    <div class="btn-group" role="group">
                        <button id="dropdownMenuButton" type="button" class="btn btn-light dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="fas fa-cog"></i> Configuración
                        </button>
                        <div class="dropdown-menu" aria-labelledby="btnGroupDrop1">
                            <a class="dropdown-item" href="#" @click="modalSMS()">Crear SMS</a>
                            <a class="dropdown-item" href="#" @click="modalEMAIL()">Crear email</a>
                            <a class="dropdown-item" href="#" data-toggle="modal" data-target="#modalCliente">Cliente / Mensaje</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row row-card-no-pd">
            <div class="col-12 col-md-2">
                <div class="nav flex-column nav-pills nav-secondary nav-pills-no-bd nav-pills-icons" id="v-pills-tab-with-icon" role="tablist">
                    <a class="nav-link active" data-toggle="pill" href="#sms" role="tab" aria-controls="sms" aria-selected="true">
                        SMS ({{ sms.length }})
                    </a>
                    <a class="nav-link" data-toggle="pill" href="#email" role="tab" aria-controls="email" aria-selected="false">
                        EMAIL ({{ email.length }})
                    </a>
                     <a class="nav-link" data-toggle="pill" href="#whatsapp" role="tab" aria-controls="email" aria-selected="false">
                        WHATSAPP (0)
                    </a>
                    <a class="nav-link" data-toggle="pill" href="#clientes" role="tab" aria-controls="clientes" aria-selected="false" @click="obtenerContactosMensajes">
                        Clientes
                    </a>
                    <a class="nav-link" data-toggle="pill" href="#bitacora" role="tab" aria-controls="bitacora" aria-selected="false" @click="obtenerBitacora">
                        Bitacora
                    </a>
                </div>
            </div>
            <div class="col-12 col-md-10">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="sms">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_sms">
                                <thead>
                                    <tr>
                                        <th>Titulo</th>
                                        <th>Mensaje</th>
                                        <th>Módulo</th>
                                        <th class="text-center">Estatus</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in sms">
                                        <td>{{ row.titulo }}</a></td>
                                        <td>{{ row.cuerpo }}</td>
                                        <td><span>{{ tipoModulo(row.modulo) }} </span></td>
                                        <td class="text-center">
                                            <div v-if="row.estatus === true" class="btn text-success" @click="cambiarEstatusSMS(row)">
                                                ACTIVO
                                            </div>
                                            <div v-else class="btn text-warning" @click="cambiarEstatusSMS(row)">
                                                INACTIVO
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <div class="form-button-action">
                                                <button type="button" title="Editar" class="btn btn-link btn-primary" @click="verSMS(row)">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                                <button type="button" title="Eliminar" class="btn btn-link text-dark" @click="eliminarSMS(row)">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="email">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_email">
                                <thead>
                                    <tr>
                                        <th>Titulo</th>
                                        <th>Mensaje</th>
                                        <th>Módulo</th>
                                        <th class="text-center">Estatus</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in email">
                                        <td>{{ row.titulo }}</a></td>
                                        <td>{{ row.cuerpo }}</td>
                                        <td><span>{{ tipoModulo(row.modulo) }} </span></td>
                                        <td class="text-center">
                                            <div v-if="row.estatus === true" class="btn text-success" @click="cambiarEstatusEMAIL(row)">
                                                ACTIVO
                                            </div>
                                            <div v-else class="btn text-warning" @click="cambiarEstatusEMAIL(row)">
                                                INACTIVO
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <div class="form-button-action">
                                                <button type="button" title="Editar" class="btn btn-link btn-primary" @click="verEMAIL(row)">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                                <button type="button" title="Eliminar" class="btn btn-link text-dark" @click="eliminarEMAIL(row)">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="whatsapp">
                        
                    </div>
                    <div class="tab-pane fade" id="clientes">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_clientes" style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th>Cliente</th>
                                        <th>Contacto</th>
                                        <th>Cargo</th>
                                        <th>telefono</th>
                                        <th>Correo</th>
                                        <th>Mensaje</th>
                                        <th>Tipo</th>
                                        <th>Modulo</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in clientes">
                                        <td><a target="_blank" :href="'<?= ruta_base() ?>clientes/ver/' + row.id_cliente">{{ row.cliente }}</a></td>
                                        <td>{{ row.cto_nombre }}</td>
                                        <td>{{ row.cto_cargo }}</td>
                                        <td>{{ row.cto_tlf }}</td>
                                        <td>{{ row.cto_email }}</td>
                                        <td>{{ row.msj_titulo }}</td>
                                        <td class="text-center">
                                            <i :title="row.msj_tipo == '1' ? 'SMS' : 'EMAIL'" :class="row.msj_tipo == '1' ? 'far fa-paper-plane' : 'far fa-envelope'"></i>
                                        </td>
                                        <td><span>{{ tipoModulo(row.msj_modulo) }} </span></td>
                                        <td class="text-center">
                                            <div class="form-button-action">
                                                <button type="button" title="Editar" class="btn btn-link btn-primary" @click="verMensajeContacto(row)">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                                <button type="button" title="Eliminar" class="btn btn-link text-dark" @click="eliminarContactoMensaje(row)">
                                                    <i class="fa fa-trash"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="bitacora">
                        <div class="table-responsive">
                            <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_bitacora" style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th>Cliente</th>
                                        <th>Contacto</th>
                                        <th>telefono</th>
                                        <th>Correo</th>
                                        <th>Fecha</th>
                                        <th>Tipo</th>
                                        <th>Estatus</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in bitacora">
                                        <td>{{ row.cliente }}</td>
                                        <td>{{ row.contacto }}</td>
                                        <td>{{ row.telefono }}</td>
                                        <td>{{ row.correo }}</td>
                                        <td>{{ row.fecha }}</td>
                                        <td>{{ row.tipo }}</td>
                                        <td>{{ row.estatus }}</td>
                                        <td class="text-center">
                                            <div class="form-button-action">
                                                <button type="button" title="Ver" class="btn btn-link btn-primary" @click="verDetalleMensaje(row)">
                                                    <i class="fa fa-eye"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php include 'configuracion/modalsms.php' ?>
    <?php include 'configuracion/modalemail.php' ?>
    <?php include 'configuracion/modalcliente.php' ?>
    <?php include 'modalDetalle.php' ?>
</div> 
<script src="<?= asset('assets/moment.min.js') ?>"></script>
<link rel="stylesheet" href="<?= asset('assets/vue-select.css') ?>">
<script src="<?= asset('assets/vue-select.js') ?>"></script>
<script src="<?= asset('assets/underscore-min.js') ?>"></script>
<script src="<?= asset('assetsvuejs/sms/index.js') ?>"></script>