<?php

namespace App\Modelos;

use Core\Database;

class SmsContactosModel extends Database
{
    protected $table = 'app_sms_cliente';
    protected $id    = 'sc_id';

    public function contactosMensajes()
    {
        return $this->consultar("SELECT cs.sc_id id, c.cli_id id_cliente, c.cli_razon_social cliente, s.sms_id msj_id, s.sms_titulo msj_titulo, s.sms_tipo msj_tipo, s.sms_modulo msj_modulo, cc.ccon_id cto_id, cc.ccon_nombre cto_nombre, cc.ccon_cargo cto_cargo, cc.ccon_telefono cto_tlf, cc.ccon_email cto_email
        FROM app_sms_cliente cs
        JOIN app_clientes_contactos cc ON cs.cs_cconid = cc.ccon_id
        JOIN app_sms s ON s.sms_id = cs.cs_smsid
        JOIN app_clientes c ON c.cli_id = cc.ccon_cliid")->all();
    }

    public function obtenerMensajeContacoSimple(int $sc_id)
    {
        return $this->consultar("SELECT cs.sc_id, cc.ccon_cliid, s.sms_id, s.sms_tipo, s.sms_modulo, cc.ccon_id, cs.sc_fecha_desde fecha_desde, cs.sc_fecha_hasta fecha_hasta, cs.sc_intervalo intervalo
        FROM app_sms_cliente cs 
        JOIN app_clientes_contactos cc ON cs.cs_cconid = cc.ccon_id
        JOIN app_sms s ON s.sms_id = cs.cs_smsid 
        JOIN app_clientes c ON c.cli_id = cc.ccon_cliid 
        WHERE cs.sc_id=$sc_id")->row();
    }

    public function obtenerMensajeContacoSimplemsj(int $sc_id)
    {
        return $this->consultar("SELECT cs.sc_id id, c.cli_id idcliente,c.cli_razon_social cliente, cc.ccon_nombre cto_nombre, cc.ccon_cargo cto_cargo, cc.ccon_telefono cto_tlf, cc.ccon_email cto_email,cc.ccon_cliid, s.sms_titulo msj_titulo, s.sms_id msj_id,s.sms_cuerpo msj_cuerpo,s.sms_modulo msj_modulo, cs.sc_fecha_desde fecha_desde, cs.sc_fecha_hasta fecha_hasta, cs.sc_intervalo intervalo, cs.sc_ultimo_envio ultimo_envio 
        FROM app_sms_cliente cs 
        JOIN app_clientes_contactos cc ON cs.cs_cconid = cc.ccon_id
        JOIN app_sms s ON s.sms_id = cs.cs_smsid 
        JOIN app_clientes c ON c.cli_id = cc.ccon_cliid 
        WHERE cs.sc_id=$sc_id")->row();
    }

    public function obtenerMensajesContacos(int $id_tipo_mensaje,int $modulo)
    {
        return $this->consultar("SELECT cs.sc_id id, c.cli_id idcliente,c.cli_razon_social cliente, cc.ccon_nombre cto_nombre, cc.ccon_cargo cto_cargo, cc.ccon_telefono cto_tlf, cc.ccon_email cto_email,cc.ccon_cliid, s.sms_titulo msj_titulo, s.sms_id msj_id,s.sms_cuerpo msj_cuerpo,s.sms_modulo msj_modulo, cs.sc_fecha_desde fecha_desde, cs.sc_fecha_hasta fecha_hasta, cs.sc_intervalo intervalo, cs.sc_ultimo_envio ultimo_envio 
        FROM app_sms_cliente cs
        JOIN app_clientes_contactos cc ON cs.cs_cconid = cc.ccon_id
        JOIN app_sms s ON s.sms_id = cs.cs_smsid
        JOIN app_clientes c ON c.cli_id = cc.ccon_cliid
        WHERE sms_tipo = $id_tipo_mensaje AND sms_modulo = $modulo AND sms_estatus=1 
        AND (((DATE(sc_fecha_desde) <= DATE(CURRENT_DATE)) AND (DATE(sc_fecha_hasta) >= DATE(CURRENT_DATE))) OR sc_fecha_hasta IS NULL)")->all();
    }

    public function obtenerMensajesContacServicios(int $id_tipo_mensaje)
    {
        return $this->consultar("SELECT cs.sc_id id,c.cli_id idcliente, c.cli_razon_social cliente, cc.ccon_nombre cto_nombre, cc.ccon_cargo cto_cargo, cc.ccon_telefono cto_tlf, cc.ccon_email cto_email, s.sms_titulo msj_titulo, s.sms_cuerpo msj_cuerpo,s.sms_modulo msj_modulo, cs.sc_fecha_desde fecha_desde, cs.sc_fecha_hasta fecha_hasta, cs.sc_intervalo intervalo, cs.sc_ultimo_envio ultimo_envio 
        FROM app_sms_cliente cs
        JOIN app_clientes_contactos cc ON cs.cs_cconid = cc.ccon_id
        JOIN app_sms s ON s.sms_id = cs.cs_smsid
        JOIN app_clientes c ON c.cli_id = cc.ccon_cliid
        WHERE sms_tipo = $id_tipo_mensaje AND sms_modulo = 2  
        AND DATE(sc_fecha_desde) <= DATE(CURRENT_DATE) AND (DATE(sc_fecha_hasta) >= DATE(CURRENT_DATE) OR sc_fecha_hasta IS NULL)")->all();
    }

    public function obtenerMensajesContacDocumentos(int $id_tipo_mensaje)
    {
        return $this->consultar("SELECT cs.sc_id id,c.cli_id idcliente, c.cli_razon_social cliente, cc.ccon_nombre cto_nombre, cc.ccon_cargo cto_cargo, cc.ccon_telefono cto_tlf, cc.ccon_email cto_email, s.sms_titulo msj_titulo, s.sms_cuerpo msj_cuerpo,s.sms_modulo msj_modulo, cs.sc_fecha_desde fecha_desde, cs.sc_fecha_hasta fecha_hasta, cs.sc_intervalo intervalo, cs.sc_ultimo_envio ultimo_envio 
        FROM app_sms_cliente cs
        JOIN app_clientes_contactos cc ON cs.cs_cconid = cc.ccon_id
        JOIN app_sms s ON s.sms_id = cs.cs_smsid
        JOIN app_clientes c ON c.cli_id = cc.ccon_cliid
        WHERE sms_tipo = $id_tipo_mensaje AND sms_modulo = 3   
        AND DATE(sc_fecha_desde) <= DATE(CURRENT_DATE) AND (DATE(sc_fecha_hasta) >= DATE(CURRENT_DATE) OR sc_fecha_hasta IS NULL)")->all();
    }
    
    public function obtenerMensajesContacosTodos(int $id_tipo_mensaje)
    {
        return $this->consultar("SELECT cs.sc_id id, c.cli_id idcliente,c.cli_razon_social cliente, cc.ccon_nombre cto_nombre, cc.ccon_cargo cto_cargo, cc.ccon_telefono cto_tlf, cc.ccon_email cto_email,cc.ccon_cliid, s.sms_titulo msj_titulo, s.sms_id msj_id,s.sms_cuerpo msj_cuerpo,s.sms_modulo msj_modulo, cs.sc_fecha_desde fecha_desde, cs.sc_fecha_hasta fecha_hasta, cs.sc_intervalo intervalo, cs.sc_ultimo_envio ultimo_envio 
        FROM app_sms_cliente cs
        JOIN app_clientes_contactos cc ON cs.cs_cconid = cc.ccon_id
        JOIN app_sms s ON s.sms_id = cs.cs_smsid
        JOIN app_clientes c ON c.cli_id = cc.ccon_cliid
        WHERE sms_tipo = $id_tipo_mensaje AND sms_estatus=1 
        AND (((DATE(sc_fecha_desde) <= DATE(CURRENT_DATE)) AND (DATE(sc_fecha_hasta) >= DATE(CURRENT_DATE))) OR sc_fecha_hasta IS NULL)")->all();
    }
}
