<?php

namespace App\Modelos;

use Core\Database;
use DateTime;

class BitacoraMensajesModel extends Database
{
    protected $table    = 'app_bitacora_mensajes';
    protected $id       = 'bitmen_id';

    public function obtenerBitacora()
    {
        return $this->consultar("SELECT bitmen_cliente, bitmen_contacto, bitmen_telefono, bitmen_correo, bitmen_titulo, bitmen_cuerpo, DATE_FORMAT(bitmen_fecha, '%d-%m-%Y %h:%i %p') fecha, bitmen_estatus, bitmen_tipo,c.*  
        FROM app_bitacora_mensajes b 
        LEFT JOIN app_clientes c ON c.cli_id=b.bitmen_cliente
        ORDER BY bitmen_id DESC")->all();
    }

    public function obtenerNumBitacoramensaje($cliente,$mensaje)
    {
        $fecha   = new DateTime(date('Y-m-d'));
        return $this->consultar("SELECT *  
        FROM app_bitacora_mensajes WHERE bitmen_cliente=$cliente AND bitmen_idmsj=$mensaje AND bitmen_estatus='Enviado' AND ((DATE(bitmen_fecha) <= DATE(CURRENT_DATE)) AND (DATE(bitmen_fecha) >= DATE(CURRENT_DATE)))")->count();
    }
}
