<?php

namespace App\Controladores;

use App\Modelos\BitacoraMensajesModel;
use App\Modelos\ClienteContactos;
use App\Modelos\Ingresosegresos;
use App\Modelos\PlanillaPreOrden;
use App\Modelos\SmsContactosModel;
use App\Modelos\SmsModel;
use App\Modelos\TablerosListas;
use Core\Controller;
use Core\Helpers\Moneda;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Librerias\SMS;
use Core\Vista;
use DateInterval;
use DateTime;
use Exception;
use PHPMailer\PHPMailer\PHPMailer;

final class SmsControlador extends Controller
{
    private $array_errors = [];
    private $module;
    private $newSMS;

    public function __construct()
    {
        parent::__construct();
        $this->module = new Module('sms');
        $this->newSMS = new SmsModel();
    }

    public function index()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {
            return Vista::view('sms/index');
        }
    }

    public function obtenerSMS()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $sms = $this->newSMS->obtenerMsjEmail(1);
            $lista = [];
            if (is_countable($sms) && count($sms)) {
                foreach ($sms as $row) {
                    $lista[] = [
                        'id' => $row['sms_id'],
                        'titulo' => $row['sms_titulo'],
                        'cuerpo' => $row['sms_cuerpo'],
                        'modulo' => $row['sms_modulo'],
                        'estatus' => $row['sms_estatus'] ? true : false
                    ];
                }
            }
            Http::json_response($lista);
        }
    }

    public function obtenerEMAIL()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $sms = $this->newSMS->obtenerMsjEmail(2);
            $lista = [];
            if (is_countable($sms) && count($sms)) {
                foreach ($sms as $row) {
                    $lista[] = [
                        'id' => $row['sms_id'],
                        'titulo' => $row['sms_titulo'],
                        'cuerpo' => html_entity_decode($row['sms_cuerpo']),
                        'modulo' => $row['sms_modulo'],
                        'estatus' => $row['sms_estatus'] ? true : false
                    ];
                }
            }
            Http::json_response($lista);
        }
    }

    public function guardarSMS()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['smsTitulo']))
                Http::json_response(['errors' => ['EL campo Titulo es obligatorio']]);
            if (empty($_POST['smsCuerpo']))
                Http::json_response(['errors' => ['EL campo Mensaje es obligatorio']]);
            if (empty($_POST['smsModulo']))
                Http::json_response(['errors' => ['EL campo Módulo es obligatorio']]);

            $dataForm = [
                'sms_titulo'    => $this->solicitud->sanitize($_POST['smsTitulo'], FILTER_SANITIZE_STRING),
                'sms_cuerpo'    => $this->solicitud->sanitize($_POST['smsCuerpo'], FILTER_SANITIZE_STRING),
                'sms_modulo'    => $this->solicitud->sanitize($_POST['smsModulo'], FILTER_SANITIZE_NUMBER_INT),
                'sms_tipo'      => 1
            ];

            if (strlen($dataForm['sms_titulo']) > 100)
                Http::json_response(['errors' => ['EL campo Título del Mensaje solo permite 100 caracteres']]);

            if (strlen($dataForm['sms_cuerpo']) > 160)
                Http::json_response(['errors' => ['EL campo Cuerpo del Mensaje solo permite 160 caracteres']]);

            if (empty($_POST['smsID'])) {
                Http::json_response($this->newSMS->guardar($dataForm, true));
            } else {
                $id = filter_input(INPUT_POST, 'smsID', FILTER_SANITIZE_NUMBER_INT);
                Http::json_response($this->newSMS->editar($id, $dataForm));
            }
        }
    }

    public function guardarEMAIL()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['emailTitulo']))
                Http::json_response(['errors' => ['EL campo Titulo es obligatorio']]);
            if (empty($_POST['emailCuerpo']))
                Http::json_response(['errors' => ['EL campo Mensaje es obligatorio']]);
            if (empty($_POST['emailModulo']))
                Http::json_response(['errors' => ['EL campo Módulo es obligatorio']]);

            $dataForm = [
                'sms_titulo'    => $this->solicitud->sanitize($_POST['emailTitulo'], FILTER_SANITIZE_STRING),
                'sms_cuerpo'    => $this->solicitud->sanitize($_POST['emailCuerpo'], FILTER_SANITIZE_STRING),
                'sms_modulo'    => $this->solicitud->sanitize($_POST['emailModulo'], FILTER_SANITIZE_NUMBER_INT),
                'sms_tipo'      => 2
            ];

            if (strlen($dataForm['sms_titulo']) > 100)
                Http::json_response(['errors' => ['EL campo Título del Mensaje solo permite 100 caracteres']]);

            if (empty($_POST['emailID'])) {
                Http::json_response($this->newSMS->guardar($dataForm, true));
            } else {
                $id = filter_input(INPUT_POST, 'emailID', FILTER_SANITIZE_NUMBER_INT);
                Http::json_response($this->newSMS->editar($id, $dataForm));
            }
        }
    }

    public function cambiarEstatusSMS(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);
            $data_sms = $this->newSMS->obtener($id);
            Http::json_response($this->newSMS->editar($id, [
                'sms_estatus' => $data_sms['sms_estatus'] == 1 ? 0 : 1
            ]));
        }
    }

    public function cambiarEstatusEMAIL(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);
            $data_email = $this->newSMS->obtener($id);
            Http::json_response($this->newSMS->editar($id, [
                'sms_estatus' => $data_email['email_estatus'] == 1 ? 0 : 1
            ]));
        }
    }

    public function eliminarSMS(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);
            Http::json_response($this->newSMS->editar($id, ["sms_estatus" => 3]));
        }
    }

    public function buscarCliente()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            if (!empty($_GET['buscar'])) {
                $buscar = $this->solicitud->sanitize($_GET['buscar']);
                $buscar = strtolower($buscar);
                Http::json_response($this->newSMS->buscarCliente($buscar));
            } else {
                Http::json_response([]);
            }
        }
    }

    public function obtenerContactos(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id_cliente = filter_var($id_cliente, FILTER_SANITIZE_NUMBER_INT);
            $newCliContactos = new ClienteContactos();
            Http::json_response($newCliContactos->obtenerContactos($id_cliente));
        }
    }

    public function buscarMensajesSegunTipo()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newSMS = new SmsModel();

            $id_tipo = filter_input(INPUT_GET, 'tipo', FILTER_SANITIZE_NUMBER_INT);
            $id_modulo = filter_input(INPUT_GET, 'modulo', FILTER_SANITIZE_NUMBER_INT);

            if (empty($id_tipo) || empty($id_modulo)) {
                Http::json_response([]);
            }

            $lista = [];

            if ($id_tipo == 1) {
                $sms = $newSMS->where(['sms_estatus' => 1, 'sms_tipo' => 1, 'sms_modulo' => $id_modulo]);
            } else {
                $sms = $newSMS->where(['sms_estatus' => 1, 'sms_tipo' => 2, 'sms_modulo' => $id_modulo]);
            }

            if (is_countable($sms) && count($sms)) {
                foreach ($sms as $row) {
                    $lista[] = [
                        'id' => $row['sms_id'],
                        'titulo' => $row['sms_titulo']
                    ];
                }
            }

            Http::json_response($lista);
        }
    }

    public function obtenerContactosMensajes()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newContactoSMS =  new SmsContactosModel();
            Http::json_response($newContactoSMS->contactosMensajes());
        }
    }

    public function guardarContactoMensaje()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newContactoSMS = new SmsContactosModel();

            if (empty($_POST['cliContacto']) || empty($_POST['cliMensaje']))
                Http::json_response(['errors' => ['Acción prohiida']]);

            $fecha_desde    = filter_input(INPUT_POST, 'cliFechaDesde', FILTER_SANITIZE_STRING);
            $fecha_hasta    = filter_input(INPUT_POST, 'cliFechaHasta', FILTER_SANITIZE_STRING);
            $intervalo      = filter_input(INPUT_POST, 'cliIntervalo', FILTER_SANITIZE_NUMBER_INT);

            if ($_POST['cliModulo'] == 2) {
                $fecha_desde    = NULL;
                $fecha_hasta    = NULL;
                $intervalo      = NULL;
            } else {
                if (empty($fecha_desde)) {
                    Http::json_response(['errors' => ['La fecha desde es obligatoria']]);
                } else {
                    if (!validateDate($fecha_desde, 'Y-m-d'))
                        Http::json_response(['errors' => ['Fecha desde invalida']]);
                }
                if (!empty($fecha_hasta)) {
                    if (!validateDate($fecha_hasta, 'Y-m-d'))
                        Http::json_response(['errors' => ['Fecha hasta invalida']]);
                } else {
                    $fecha_hasta = NULL;
                }
                if (empty($intervalo)) {
                    $intervalo = 1;
                } else {
                    if (!is_numeric($intervalo) && $intervalo < 1)
                        Http::json_response(['errors' => ['Intervalo invalido']]);
                }
            }

            $dataForm = [
                'cs_cconid'         => filter_input(INPUT_POST, 'cliContacto', FILTER_SANITIZE_NUMBER_INT),
                'cs_smsid'          => filter_input(INPUT_POST, 'cliMensaje', FILTER_SANITIZE_NUMBER_INT),
                'sc_fecha_desde'    => $fecha_desde,
                'sc_fecha_hasta'    => $fecha_hasta,
                'sc_intervalo'      => $intervalo
            ];

            if (empty($_POST['cliID'])) {

                if ($newContactoSMS->where(['cs_cconid' => $dataForm['cs_cconid'], 'cs_smsid' => $dataForm['cs_smsid']], true))
                    Http::json_response(['errors' => ['El contacto ya tiene asigando este menasje']]);

                Http::json_response($newContactoSMS->guardar($dataForm, true));
            } else {

                $id = filter_input(INPUT_POST, 'cliID', FILTER_SANITIZE_NUMBER_INT);

                if ($newContactoSMS->where([
                    'sc_id!=' => $id,
                    'cs_cconid' => $dataForm['cs_cconid'],
                    'cs_smsid' => $dataForm['cs_smsid']
                ], true))
                    Http::json_response(['errors' => ['El contacto ya tiene asigando este menasje']]);

                Http::json_response($newContactoSMS->editar($id, $dataForm));
            }
        }
    }

    public function eliminarContactoMensaje(int $msjcli)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $msjcli = filter_var($msjcli, FILTER_SANITIZE_NUMBER_INT);
            $newContactoSMS = new SmsContactosModel();
            Http::json_response($newContactoSMS->eliminar($msjcli));
        }
    }

    public function verMensajeContacto(int $msjcli)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $msjcli = filter_var($msjcli, FILTER_SANITIZE_NUMBER_INT);

            $newContactoSMS = new SmsContactosModel();
            $newCliContactos = new ClienteContactos();

            if (!$newContactoSMS->existe('sc_id', $msjcli))
                Http::json_response([]);

            $data_msj_cto = $newContactoSMS->obtenerMensajeContacoSimple($msjcli);

            $cliente = $GLOBALS['newDBIni']->consultar("SELECT cli_id id , cli_dni dni, cli_razon_social cliente
             FROM app_clientes WHERE cli_id = {$data_msj_cto['ccon_cliid']}")->all();

            $contactos = $newCliContactos->obtenerContactos($data_msj_cto['ccon_cliid']);
            $mensajes = $this->newSMS->obtenerSMSTipo($data_msj_cto['sms_tipo']);

            Http::json_response([
                'cliente'       => $cliente,
                'mensajes'      => $mensajes,
                'contactos'     => $contactos,
                'id_contacto'   => $data_msj_cto['ccon_id'],
                'id_tipo'       => $data_msj_cto['sms_tipo'],
                'id_mensaje'    => $data_msj_cto['sms_id'],
                'modulo'        => $data_msj_cto['sms_modulo'],
                'fecha_desde'   => $data_msj_cto['fecha_desde'],
                'fecha_hasta'   => $data_msj_cto['fecha_hasta'],
                'intervalo'     => $data_msj_cto['intervalo']
            ]);
        }
    }

    public function obtenerMensajesTodos()
    {

        $newSMSContact  = new SmsContactosModel();

        $mensajes = $newSMSContact->obtenerMensajesContacos(1, 1);
        $servicios = $newSMSContact->obtenerMensajesContacos(1, 2);
        $documentos = $newSMSContact->obtenerMensajesContacos(1, 3);

        http::json_response([
            'mensajes' => $mensajes,
            'servicios' => $servicios,
            'documentos' => $documentos,
        ]);
    }

    public function obtenerEmailTodos()
    {

        $newSMSContact  = new SmsContactosModel();

        $mensajes       = $newSMSContact->obtenerMensajesContacos(2, 1);
        $servicios       = $newSMSContact->obtenerMensajesContacos(2, 2);
        $documentos       = $newSMSContact->obtenerMensajesContacos(2, 3);

        http::json_response([
            'mensajes' => $mensajes,
            'servicios' => $servicios,
            'documentos' => $documentos,
        ]);
    }

    public function cronSMS()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newSMS = new SMS(constant('SMS_USER'), constant('SMS_PASSWORD'));

            if ($newSMS->obtenerEstatus() != 'Activa')
                Http::json_response(['errors' => ['Lo siento el estatus de su Mensajeria se encuentra Inactiva']]);

            if ($newSMS->obtenerCreditos() <= 0)
                Http::json_response(['errors' => ['Lo siento no posee creditos suficientes verifique su proveedor de Mensajeria']]);

            $newSMSContact  = new SmsContactosModel();
            $newBitacora    = new BitacoraMensajesModel();
            $newListas = new TablerosListas();

            $mensajes = $newSMSContact->obtenerMensajesContacos(1, 1);
            $servicios = $newSMSContact->obtenerMensajesContacos(1, 2);
            $documentos = $newSMSContact->obtenerMensajesContacos(1, 3);

            if (is_countable($mensajes) && count($mensajes)) {

                foreach ($mensajes as $row) {

                    if (!is_null($row['fecha_hasta'])) {
                        $fecha_hasta    = new DateTime($row['fecha_hasta']);
                        //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                        $fecha   = new DateTime(date('Y-m-d'));
                        //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                        $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

                        $tele = str_replace('(', '', $row['cto_tlf']);
                        $tele = str_replace(')', '', $tele);
                        $tele = str_replace(' ', '', $tele);
                        $tele=str_replace('-','',$tele);
                        $msj = str_replace(' ', '+', $row['msj_cuerpo']);
                        $msj = str_replace('-', '/', $msj);
                        $msj = str_replace('_', '.', $msj);
                        $msj = str_replace('$', 'USD', $msj);

                        if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

                            // http::json_response($msj);
                            $estatus = $newSMS->enviarMensaje($tele, $msj);

                            //$estatus = "";
                            switch ($estatus) {
                                case "200 / 1":
                                    $estatus_condicion = 'Enviado';
                                    $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                                    break;
                                case '200 / 0':
                                    $estatus_condicion = 'Error al enviar';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '401':
                                    $estatus_condicion = 'Autenticación Inválida';
                                    Http::json_response(['errors' => [$estatus_condicion . $estatus]]);
                                    break;
                                case '402':
                                    $estatus_condicion = 'Créditos Insuficientes';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '403':
                                    $estatus_condicion = 'Cuenta Inactiva';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '405':
                                    $estatus_condicion = 'Falta Destinatario';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '501':
                                    $estatus_condicion = 'Tipo de Cuenta Inválida';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '502':
                                    $estatus_condicion = 'Petición Sobrecargada';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                default:
                                    $estatus_condicion = $estatus;
                            }


                            $newBitacora->guardar([
                                'bitmen_cliente' => $row['idcliente'],
                                'bitmen_contacto' => $row['cto_nombre'],
                                'bitmen_telefono' => $row['cto_tlf'],
                                'bitmen_correo' => $row['cto_email'],
                                'bitmen_idmsj'  => $row['msj_id'],
                                'bitmen_titulo' => $row['msj_titulo'],
                                'bitmen_cuerpo' => $msj,
                                'bitmen_estatus' => $estatus_condicion,
                                'bitmen_tipo' => 'SMS'
                            ], true);
                        }
                    }
                }
            }

            if (is_countable($servicios) && count($servicios)) {

                foreach ($servicios as $row) {

                    if (!is_null($row['fecha_hasta'])) {
                        $fecha_hasta    = new DateTime($row['fecha_hasta']);
                        //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                        $fecha   = new DateTime(date('Y-m-d'));
                        //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                        $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

                        $tele = str_replace('(', '', $row['cto_tlf']);
                        $tele = str_replace(')', '', $tele);
                        $tele = str_replace(' ', '', $tele);
                        $tele=str_replace('-','',$tele);
                        $msj = str_replace(' ', '+', $row['msj_cuerpo']);
                        $msj = str_replace('-', '/', $msj);
                        $msj = str_replace('_', '.', $msj);


                        $servicios_msj = '/';
                        $estatus_msj = '/';
                        $servicioss = $newListas->consultar("SELECT * FROM app_tableros_listas_tareas tr 
                        LEFT JOIN app_tableros_listas lt ON tr.tar_listid=lt.tablist_id 
                        WHERE lt.tablist_tabid=13 AND tr.tar_cliente ={$row['ccon_cliid']}")->all();

                        if (is_countable($servicioss) && count($servicioss)) {
                            foreach ($servicioss as $row1) {
                                $servicios_msj = $servicios_msj . 'SERV:' . $row1['tar_descripcion'] . '/';
                                $estatus_msj = $servicios_msj . $row1['tablist_nombre'] . '/';
                            }
                        }

                        $msj = str_replace('$servicio', $servicios_msj, $msj);
                        $msj = str_replace(' ', '+', $msj);
                        $msj = str_replace('-', '/', $msj);
                        $msj = str_replace('$estatus_nuevo', $estatus_msj, $msj);
                        $msj = str_replace('$', 'USD', $msj);

                        if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {
                            $estatus = $newSMS->enviarMensaje($tele, $msj);

                            switch ($estatus) {
                                case '200 / 1':
                                    $estatus_condicion = 'Enviado';
                                    $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                                    /*case '200 / 0':
                                    $estatus_condicion = 'Error al enviar';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    //case '400':
                                    //  $estatus_condicion = 'Falta Texto';
                                    //   Http::json_response(['errors' => [$estatus_condicion]]);
                                    //   break;*/
                                case '401':
                                    $estatus_condicion = 'Autenticación Inválida';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '402':
                                    $estatus_condicion = 'Créditos Insuficientes';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '403':
                                    $estatus_condicion = 'Cuenta Inactiva';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '405':
                                    $estatus_condicion = 'Falta Destinatario';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '501':
                                    $estatus_condicion = 'Tipo de Cuenta Inválida';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '502':
                                    $estatus_condicion = 'Petición Sobrecargada';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                default:
                                    $estatus_condicion = $estatus;
                            }
                            $newBitacora->guardar([
                                'bitmen_cliente' => $row['idcliente'],
                                'bitmen_contacto' => $row['cto_nombre'],
                                'bitmen_telefono' => $row['cto_tlf'],
                                'bitmen_correo' => $row['cto_email'],
                                'bitmen_idmsj'  => $row['msj_id'],
                                'bitmen_titulo' => $row['msj_titulo'],
                                'bitmen_cuerpo' => $msj,
                                'bitmen_estatus' => $estatus_condicion,
                                'bitmen_tipo' => 'SMS'
                            ], true);
                        }
                    }
                }
            }

            if (is_countable($documentos) && count($documentos)) {
                foreach ($documentos as $row) {

                    if (!is_null($row['fecha_hasta'])) {
                        $fecha_hasta    = new DateTime($row['fecha_hasta']);
                        //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                        $fecha   = new DateTime(date('Y-m-d'));
                        //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                        $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);


                        $tele = str_replace('(', '', $row['cto_tlf']);
                        $tele = str_replace(')', '', $tele);
                        $tele = str_replace(' ', '', $tele);
                        $tele=str_replace('-','',$tele);
                        $tele=str_replace('-','',$tele);
                        $msj = str_replace(' ', '+', $row['msj_cuerpo']);
                        $msj = str_replace('-', '/', $msj);
                        $msj = str_replace('_', '.', $msj);

                        $factura_msj = '/';
                        $factura_conteo = 0;
                        $factura_monto = 0;
                        $nota_msj = '/';
                        $orden_msj = '/';

                        $facturas = $newListas->consultar("SELECT * FROM app_factura_master fm WHERE (fm.fm_estatus=0 OR fm.fm_estatus=2) AND fm.fm_cliid={$row['ccon_cliid']}")->all();
                        $notas = $newListas->consultar("SELECT * FROM app_notas_de_entrega ne WHERE (ne.ne_estatus=0 OR ne.ne_estatus=2) AND ne.ne_cliid={$row['ccon_cliid']}")->all();
                        $orden = $newListas->consultar("SELECT * FROM app_orden_de_entrega n WHERE (n.n_estatus=0 OR n.n_estatus=2) AND n.n_cliid={$row['ccon_cliid']}")->all();

                        $div_master = Moneda::Predeterminada();

                        if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

                            if (is_countable($facturas) && count($facturas)) {

                                foreach ($facturas as $row1) {

                                    $factura_msj .= '+FACV' . $row1['fm_correlativo'] . '/';
                                    $factura_conteo += 1;
                                    $factor = 1;

                                    $newPreOrden = new PlanillaPreOrden();
                                    if ($div_master['id'] != $row1['fm_divid']) {
                                        $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['fm_divid'], $div_master['id']);
                                        $factor = $factor_div['df_factor'];
                                    }

                                    $factura_monto += $row1['fm_total'] * $factor;
                                }
                            }

                            if (is_countable($notas) && count($notas)) {

                                foreach ($notas as $row1) {

                                    $nota_msj .= '+NEV' . $row1['ne_correlativo'] . '/';
                                    $factura_conteo += 1;
                                    $factor = 1;

                                    $newPreOrden = new PlanillaPreOrden();
                                    if ($div_master['id'] != $row1['ne_divid']) {
                                        $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['ne_divid'], $div_master['id']);
                                        $factor = $factor_div['df_factor'];
                                    }

                                    $factura_monto += $row1['ne_total'] * $factor;
                                }
                            }

                            if (is_countable($orden) && count($orden)) {

                                foreach ($orden as $row1) {

                                    $orden_msj .= '+ORDENV' . $row1['n_correlativo'] . '/';
                                    $factura_conteo += 1;
                                    $factor = 1;

                                    $newPreOrden = new PlanillaPreOrden();
                                    if ($div_master['id'] != $row1['n_divid']) {
                                        $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['n_divid'], $div_master['id']);
                                        $factor = $factor_div['df_factor'];
                                    }

                                    $factura_monto += $row1['n_total'] * $factor;
                                }
                            }

                            $combinacion = $factura_msj . $nota_msj . $orden_msj;
                            $mont = Moneda::moneda($factura_monto, $div_master['locale'], $div_master['symbol'], $div_master['precision']);
                            $msj = str_replace('$documentos', $combinacion, $msj);
                            $msj = str_replace('$monto', $mont, $msj);
                            $msj = str_replace('$total_documentos', $mont, $msj);
                            $msj = str_replace('$', 'USD', $msj);

                            $estatus = $newSMS->enviarMensaje($tele, $msj);

                            switch ($estatus) {
                                case '200 / 1':
                                    $estatus_condicion = 'Enviado';
                                    $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                                    /* case '200 / 0':
                                    $estatus_condicion = 'Error al enviar';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    //case '400':
                                    //$estatus_condicion = 'Falta Texto';
                                    //Http::json_response(['errors' => [$estatus_condicion]]);
                                    //break;*/
                                case '401':
                                    $estatus_condicion = 'Autenticación Inválida';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '402':
                                    $estatus_condicion = 'Créditos Insuficientes';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '403':
                                    $estatus_condicion = 'Cuenta Inactiva';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '405':
                                    $estatus_condicion = 'Falta Destinatario';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '501':
                                    $estatus_condicion = 'Tipo de Cuenta Inválida';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                case '502':
                                    $estatus_condicion = 'Petición Sobrecargada';
                                    Http::json_response(['errors' => [$estatus_condicion]]);
                                    break;
                                default:
                                    $estatus_condicion = $estatus;
                            }

                            $newBitacora->guardar([
                                'bitmen_cliente' => $row['idcliente'],
                                'bitmen_contacto' => $row['cto_nombre'],
                                'bitmen_telefono' => $row['cto_tlf'],
                                'bitmen_correo' => $row['cto_email'],
                                'bitmen_idmsj'  => $row['msj_id'],
                                'bitmen_titulo' => $row['msj_titulo'],
                                'bitmen_cuerpo' => $msj,
                                'bitmen_estatus' => $estatus_condicion,
                                'bitmen_tipo' => 'SMS'
                            ], true);
                        }
                    }
                }
            }
        }
    }

    public function cronSMSservicios(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newSMS = new SMS(constant('SMS_USER'), constant('SMS_PASSWORD'));

            $msjcli = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($newSMS->obtenerEstatus() != 'Activa')
                Http::json_response(['errors' => ['Lo siento el estatus de su Mensajeria se encuentra Inactiva']]);

            if ($newSMS->obtenerCreditos() <= 0)
                Http::json_response(['errors' => ['Lo siento no posee creditos suficientes verifique su proveedor de Mensajeria']]);

            $newSMSContact  = new SmsContactosModel();
            $newBitacora    = new BitacoraMensajesModel();
            $newListas = new TablerosListas();

            $row = $newSMSContact->obtenerMensajeContacoSimplemsj($msjcli);
            $b = 0;

            //if (!is_null($row['fecha_hasta'])) {
            $fecha_hasta    = new DateTime($row['fecha_hasta']);
            //$ultimo_envio   = new DateTime($row['ultimo_envio']);
            $fecha   = new DateTime(date('Y-m-d'));
            //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

            $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

            $tele = str_replace('(', '', $row['cto_tlf']);
            $tele = str_replace(')', '', $tele);
            $tele = str_replace(' ', '', $tele);
            $tele=str_replace('-','',$tele);
            $msj = str_replace(' ', '+', $row['msj_cuerpo']);
            $msj = str_replace('-', '/', $msj);
            $msj = str_replace('_', '.', $msj);


            $servicios_msj = '/';
            $estatus_msj = '/';
            $servicioss = $newListas->consultar("SELECT * FROM app_tableros_listas_tareas tr 
                LEFT JOIN app_tableros_listas lt ON tr.tar_listid=lt.tablist_id 
                WHERE lt.tablist_tabid=13 AND tr.tar_cliente ={$row['ccon_cliid']}")->all();

            if (is_countable($servicioss) && count($servicioss)) {
                foreach ($servicioss as $row1) {
                    $servicios_msj = $servicios_msj . 'SERV:' . $row1['tar_descripcion'] . '/';
                    $estatus_msj = $servicios_msj . $row1['tablist_nombre'] . '/';
                }
            }

            $msj = str_replace('$servicio', $servicios_msj, $msj);
            $msj = str_replace(' ', '+', $msj);
            $msj = str_replace('-', '/', $msj);
            $msj = str_replace('$estatus_nuevo', $estatus_msj, $msj);
            $msj = str_replace('$', 'USD', $msj);

            // if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {
            if (strlen($servicios_msj) > 6) {

                $estatus = $newSMS->enviarMensaje($tele, $msj);

                switch ($estatus) {
                   case '200 / 1':
                            $estatus_condicion = 'Enviado';
                            $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                            break;
                         case '200 / 0':
                            $estatus_condicion = 'Error al enviar';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                             ///$estatus_condicion = 'Enviado';
                             //$newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                             break;
                        case '400':
                             $estatus_condicion = 'Falta Texto';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                           // break;
                            //$estatus_condicion = 'Enviado';
                            //$newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                            break;
                        case '401':
                            $estatus_condicion = 'Autenticación Inválida';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                            //break;
                             //$estatus_condicion = 'Enviado';
                            // $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                             break;
                    case '402':
                        $estatus_condicion = 'Créditos Insuficientes';
                        Http::json_response(['errors' => [$estatus_condicion]]);
                        break;
                    case '403':
                        $estatus_condicion = 'Cuenta Inactiva';
                        Http::json_response(['errors' => [$estatus_condicion]]);
                        break;
                    case '405':
                        $estatus_condicion = 'Falta Destinatario';
                        Http::json_response(['errors' => [$estatus_condicion]]);
                        break;
                    case '501':
                        $estatus_condicion = 'Tipo de Cuenta Inválida';
                        Http::json_response(['errors' => [$estatus_condicion]]);
                        break;
                    case '502':
                        $estatus_condicion = 'Petición Sobrecargada';
                        Http::json_response(['errors' => [$estatus_condicion]]);
                        break;
                    default:
                        $estatus_condicion = $estatus;
                }

                $newBitacora->guardar([
                    'bitmen_cliente' => $row['idcliente'],
                    'bitmen_contacto' => $row['cto_nombre'],
                    'bitmen_telefono' => $row['cto_tlf'],
                    'bitmen_correo' => $row['cto_email'],
                    'bitmen_idmsj'  => $row['msj_id'],
                    'bitmen_titulo' => $row['msj_titulo'],
                    'bitmen_cuerpo' => $msj,
                    'bitmen_estatus' => $estatus_condicion,
                    'bitmen_tipo' => 'SMS'
                ], true);

                Http::json_response(true);
            }

            Http::json_response(['errors' => ['Lo siento no hay servicios pendientes']]);
            //}
            //}
        }
    }

    public function cronSMSdocumentos(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newSMS = new SMS(constant('SMS_USER'), constant('SMS_PASSWORD'));

            $msjcli = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($newSMS->obtenerEstatus() != 'Activa')
                Http::json_response(['errors' => ['Lo siento el estatus de su Mensajeria se encuentra Inactiva']]);

            if ($newSMS->obtenerCreditos() <= 0)
                Http::json_response(['errors' => ['Lo siento no posee creditos suficientes verifique su proveedor de Mensajeria']]);

            $newSMSContact  = new SmsContactosModel();
            $newBitacora    = new BitacoraMensajesModel();
            $newListas = new TablerosListas();

            $row = $newSMSContact->obtenerMensajeContacoSimplemsj($msjcli);
            $b = 0;

            if (!is_null($row['fecha_hasta'])) {
                $fecha_hasta    = new DateTime($row['fecha_hasta']);
                //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                $fecha   = new DateTime(date('Y-m-d'));
                //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);


                $tele = str_replace('(', '', $row['cto_tlf']);
                $tele = str_replace(')', '', $tele);
                $tele = str_replace(' ', '', $tele);
                $msj = str_replace(' ', '+', $row['msj_cuerpo']);
                $msj = str_replace('-', '/', $msj);
                $msj = str_replace('_', '.', $msj);

                $factura_msj = '/';
                $factura_conteo = 0;
                $factura_monto = 0;
                $nota_msj = '/';
                $orden_msj = '/';
                $acumulado_t = 0;
                $pendiente = 0;

                $facturas = $newListas->consultar("SELECT * FROM app_factura_master fm WHERE (fm.fm_estatus=0 OR fm.fm_estatus=2) AND fm.fm_cliid={$row['ccon_cliid']}")->all();
                $notas = $newListas->consultar("SELECT * FROM app_notas_de_entrega ne WHERE (ne.ne_estatus=0 OR ne.ne_estatus=2) AND ne.ne_cliid={$row['ccon_cliid']}")->all();
                $orden = $newListas->consultar("SELECT * FROM app_orden_de_entrega n WHERE (n.n_estatus=0 OR n.n_estatus=2) AND n.n_cliid={$row['ccon_cliid']}")->all();

                $div_master = Moneda::Predeterminada();
                $newingreso = new Ingresosegresos();

                if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

                    if (is_countable($facturas) && count($facturas)) {

                        foreach ($facturas as $row1) {
                            
                            $acumulado = $newingreso->obtenerAcumulado($row['fm_id'], 2);

                            $factura_msj .= ' FACV' . $row1['fm_correlativo'] . '/';
                            $factura_conteo += 1;
                            $factor = 1;

                            $newPreOrden = new PlanillaPreOrden();
                            
                            if ($div_master['id'] != $row1['fm_divid']) {
                                $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['fm_divid'], $div_master['id']);
                                $factor = $factor_div['df_factor'];
                                $row1['fm_total'] = $row1['fm_total'] * $factor;
                                $acumulado['total'] = round($acumulado['total'] * $factor_div['df_factor'], 2);
                            }
                            $acumulado_total = ($acumulado['total']) ?? 0;
                            
                            $acumulado_t += $acumulado_total;
                            $pendiente += $row1['fm_total'] - $acumulado_total;

                            //$factura_monto += $row1['fm_total'] * $factor;
                            $factura_monto += round($pendiente, 2);
                        }
                    }

                    if (is_countable($notas) && count($notas)) {

                        foreach ($notas as $row1) {
                            
                            $acumulado = $newingreso->obtenerAcumulado($row['ne_id'], 1);

                            $nota_msj .= ' NEV' . $row1['ne_correlativo'] . '/';
                            $factura_conteo += 1;
                            $factor = 1;

                            $newPreOrden = new PlanillaPreOrden();
                            if ($div_master['id'] != $row1['ne_divid']) {
                                $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['ne_divid'], $div_master['id']);
                                $factor = $factor_div['df_factor'];
                                $row1['ne_total'] = $row1['ne_total'] * $factor;
                                $acumulado['total'] = round($acumulado['total'] * $factor_div['df_factor'], 2);
                            }
                            $acumulado_total = ($acumulado['total']) ?? 0;
                            
                            $acumulado_t += $acumulado_total;
                            $pendiente += $row1['ne_total'] - $acumulado_total;

                            //$factura_monto += $row1['ne_total'] * $factor;
                            $factura_monto += round($pendiente, 2);
                        }
                    }

                    if (is_countable($orden) && count($orden)) {

                        foreach ($orden as $row1) {
                            
                            $acumulado = $newingreso->obtenerAcumulado($row['n_id'], 12);

                            $orden_msj .= ' ORDENV' . $row1['n_correlativo'] . '/';
                            $factura_conteo += 1;
                            $factor = 1;

                            $newPreOrden = new PlanillaPreOrden();
                            if ($div_master['id'] != $row1['n_divid']) {
                                $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['n_divid'], $div_master['id']);
                                $factor = $factor_div['df_factor'];
                                $row1['n_total'] = $row1['n_total'] * $factor;
                                $acumulado['total'] = round($acumulado['total'] * $factor_div['df_factor'], 2);
                            }
                            $acumulado_total = ($acumulado['total']) ?? 0;
                            
                            $acumulado_t += $acumulado_total;
                            $pendiente += $row1['n_total'] - $acumulado_total;

                            //$factura_monto += $row1['n_total'] * $factor;
                            $factura_monto += round($pendiente, 2);
                        }
                    }

                    if($factura_monto>0){
                        $combinacion = $factura_msj . $nota_msj . $orden_msj;
                    $mont = Moneda::moneda($factura_monto, $div_master['locale'], $div_master['symbol'], $div_master['precision']);
                    $msj = str_replace('$documentos', $combinacion, $msj);
                    $msj = str_replace('$monto', $mont, $msj);
                    $msj = str_replace('$total_documentos', $mont, $msj);
                    $msj = str_replace('$', 'USD', $msj);
                    $tele=str_replace('-','',$tele);

                    $estatus = $newSMS->enviarMensaje($tele, $msj);

                    switch ($estatus) {
                        case '200 / 1':
                            $estatus_condicion = 'Enviado';
                            $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                            break;
                         case '200 / 0':
                            $estatus_condicion = 'Error al enviar';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                             ///$estatus_condicion = 'Enviado';
                             //$newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                             break;
                        case '400':
                             $estatus_condicion = 'Falta Texto';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                           // break;
                            //$estatus_condicion = 'Enviado';
                            //$newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                            break;
                        case '401':
                            $estatus_condicion = 'Autenticación Inválida';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                            //break;
                             //$estatus_condicion = 'Enviado';
                            // $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                             break;
                        case '402':
                            $estatus_condicion = 'Créditos Insuficientes';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                            break;
                        case '403':
                            $estatus_condicion = 'Cuenta Inactiva';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                            break;
                        case '405':
                            $estatus_condicion = 'Falta Destinatario';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                            break;
                        case '501':
                            $estatus_condicion = 'Tipo de Cuenta Inválida';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                            break;
                        case '502':
                            $estatus_condicion = 'Petición Sobrecargada';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                            break;
                        default:
                            $estatus_condicion = $estatus;
                    }

                    $newBitacora->guardar([
                        'bitmen_cliente' => $row['idcliente'],
                        'bitmen_contacto' => $row['cto_nombre'],
                        'bitmen_telefono' => $row['cto_tlf'],
                        'bitmen_correo' => $row['cto_email'],
                        'bitmen_idmsj'  => $row['msj_id'],
                        'bitmen_titulo' => $row['msj_titulo'],
                        'bitmen_cuerpo' => $msj,
                        'bitmen_estatus' => $estatus_condicion,
                        'bitmen_tipo' => 'SMS'
                    ], true);

                    Http::json_response(true);
                    
                    }else{
                        Http::json_response(['errors' => ['Lo siento sin documentos pendiente']]);
                    }
                    
                }else{
                    Http::json_response(['errors' => ['Lo siento ya llego a su limite este mensaje']]);
                }
            }
        }
    }

    public function cronSMSmensajes(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newSMS = new SMS(constant('SMS_USER'), constant('SMS_PASSWORD'));

            $msjcli = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($newSMS->obtenerEstatus() != 'Activa')
                Http::json_response(['errors' => ['Lo siento el estatus de su Mensajeria se encuentra Inactiva']]);

            if ($newSMS->obtenerCreditos() <= 0)
                Http::json_response(['errors' => ['Lo siento no posee creditos suficientes verifique su proveedor de Mensajeria']]);

            $newSMSContact  = new SmsContactosModel();
            $newBitacora    = new BitacoraMensajesModel();
            $newListas = new TablerosListas();

            $row = $newSMSContact->obtenerMensajeContacoSimplemsj($msjcli);
            $b = 0;

            if (!is_null($row['fecha_hasta'])) {
                $fecha_hasta    = new DateTime($row['fecha_hasta']);
                //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                $fecha   = new DateTime(date('Y-m-d'));
                //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

                $tele = str_replace('(', '', $row['cto_tlf']);
                $tele = str_replace(')', '', $tele);
                $tele = str_replace(' ', '', $tele);
                $tele=str_replace('-','',$tele);
                $msj = str_replace(' ', '+', $row['msj_cuerpo']);
                $msj = str_replace('-', '/', $msj);
                $msj = str_replace('_', '.', $msj);
                $msj = str_replace('$', 'USD', $msj);

                // if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {
                if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

                    // http::json_response($msj);
                    $estatus = $newSMS->enviarMensaje($tele, $msj);

                    $estatus = "";
                    switch ($estatus) {
                       case '200 / 1':
                            $estatus_condicion = 'Enviado';
                            $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                            break;
                         case '200 / 0':
                            $estatus_condicion = 'Error al enviar';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                             ///$estatus_condicion = 'Enviado';
                             //$newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                             break;
                        case '400':
                             $estatus_condicion = 'Falta Texto';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                           // break;
                            //$estatus_condicion = 'Enviado';
                            //$newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                            break;
                        case '401':
                            $estatus_condicion = 'Autenticación Inválida';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                            //break;
                             //$estatus_condicion = 'Enviado';
                            // $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                             break;
                        case '402':
                            $estatus_condicion = 'Créditos Insuficientes';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                            break;
                        case '403':
                            $estatus_condicion = 'Cuenta Inactiva';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                            break;
                        case '405':
                            $estatus_condicion = 'Falta Destinatario';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                            break;
                        case '501':
                            $estatus_condicion = 'Tipo de Cuenta Inválida';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                            break;
                        case '502':
                            $estatus_condicion = 'Petición Sobrecargada';
                            Http::json_response(['errors' => [$estatus_condicion]]);
                            break;
                        default:
                            $estatus_condicion = $estatus;
                    }


                    $newBitacora->guardar([
                        'bitmen_cliente' => $row['idcliente'],
                        'bitmen_contacto' => $row['cto_nombre'],
                        'bitmen_telefono' => $row['cto_tlf'],
                        'bitmen_correo' => $row['cto_email'],
                        'bitmen_idmsj'  => $row['msj_id'],
                        'bitmen_titulo' => $row['msj_titulo'],
                        'bitmen_cuerpo' => $msj,
                        'bitmen_estatus' => $estatus_condicion,
                        'bitmen_tipo' => 'SMS'
                    ], true);

                    Http::json_response(true);
                } else {
                    Http::json_response(['errors' => ['Lo siento ya llego a su limite este mensaje']]);
                }
            }
        }
    }

    public function cronEMAIL()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (
                !trim(constant('EMP_CORREO')) ||
                !trim(constant('EMP_CORREO_PASSWORD')) ||
                !trim(constant('EMP_CORREO_HOST')) ||
                !trim(constant('EMP_CORREO_PORT'))
            )
                Http::json_response(['errors' => ['Debe configurar todos los parametros para poder enviar correos']]);

            $mail           = new PHPMailer(true);
            $newSMSContact  = new SmsContactosModel();
            $newBitacora    = new BitacoraMensajesModel();
            $newListas = new TablerosListas();
            $div_master = Moneda::Predeterminada();
            $mensajes       = $newSMSContact->obtenerMensajesContacos(2, 1);
            $servicios       = $newSMSContact->obtenerMensajesContacos(2, 2);
            $documentos       = $newSMSContact->obtenerMensajesContacos(2, 3);
            $error = '';

            if (is_countable($mensajes) && count($mensajes)) {

                foreach ($mensajes as $row) {

                    /*if (!is_null($row['ultimo_envio'])) {
                        $fecha_hasta    = new DateTime($row['fecha_hasta']);
                        $ultimo_envio   = new DateTime($row['ultimo_envio']);
                        $ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));
                        if ($ultimo_envio > $fecha_hasta) continue;
                    }*/
                    if (!is_null($row['fecha_hasta'])) {
                        $fecha_hasta    = new DateTime($row['fecha_hasta']);
                        //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                        $fecha   = new DateTime(date('Y-m-d'));
                        //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                        $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

                        if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

                            try {
                                $mail->isSMTP();
                                $mail->Host       = constant('EMP_CORREO_HOST');
                                $mail->SMTPAuth   = true;
                                $mail->Username   = constant('EMP_CORREO');
                                $mail->Password   = constant('EMP_CORREO_PASSWORD');
                                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                                $mail->Port       = constant('EMP_CORREO_PORT');

                                $mail->setFrom($mail->Username);
                                $mail->addAddress($row['cto_email']);
                                $mail->addReplyTo($mail->Username, constant('EMP_NOMBRE'));
                                $mail->isHTML(true);

                                $mail->Subject = utf8_decode($row['msj_titulo']);
                                $mail->Body    = html_entity_decode($row['msj_cuerpo']);

                                $mail->send();
                            } catch (Exception $e) {
                                $error = "No se pudo enviar el mensaje. Error de envío: {$mail->ErrorInfo}.";
                            }



                            $data_envio = [
                                'bitmen_cliente'    => $row['idcliente'],
                                'bitmen_contacto'   => $row['cto_nombre'],
                                'bitmen_telefono'   => $row['cto_tlf'],
                                'bitmen_correo'     => $row['cto_email'],
                                'bitmen_idmsj'      => $row['msj_id'],
                                'bitmen_titulo'     => $row['msj_titulo'],
                                'bitmen_cuerpo'     => $msj,
                                'bitmen_tipo'       => 'EMAIL'
                            ];

                            if ($error == '') {
                                $data_envio['bitmen_estatus'] = 'Enviado';
                                $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                            } else {
                                $data_envio['bitmen_estatus'] = $error;
                            }

                            $newBitacora->guardar($data_envio, true);
                        }
                    }
                }
            }

            if (is_countable($servicios) && count($servicios)) {

                foreach ($servicios as $row) {


                    if (!is_null($row['fecha_hasta'])) {
                        $fecha_hasta    = new DateTime($row['fecha_hasta']);
                        //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                        $fecha   = new DateTime(date('Y-m-d'));
                        //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                        $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

                        if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

                            $msj = $row['msj_cuerpo'];
                            $servicios_msj = '/';
                            $estatus_msj = '/';

                            $servicioss = $newListas->consultar("SELECT * FROM app_tableros_listas_tareas tr 
                            LEFT JOIN app_tableros_listas lt ON tr.tar_listid=lt.tablist_id 
                            WHERE lt.tablist_tabid=13 AND tr.tar_cliente ={$row['ccon_cliid']}")->all();

                            if (is_countable($servicioss) && count($servicioss)) {
                                foreach ($servicioss as $row1) {
                                    $servicios_msj += 'SERV:' . $row1['tar_descripcion'] . '/';
                                    $estatus_msj += $row1['tablist_nombre'] . '/';
                                }
                            }

                            $msj = str_replace('$servicio', $servicios_msj, $msj);
                            $msj = str_replace('$estatus_nuevo', $estatus_msj, $msj);

                            try {
                                $mail->isSMTP();
                                $mail->Host       = constant('EMP_CORREO_HOST');
                                $mail->SMTPAuth   = true;
                                $mail->Username   = constant('EMP_CORREO');
                                $mail->Password   = constant('EMP_CORREO_PASSWORD');
                                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                                $mail->Port       = constant('EMP_CORREO_PORT');

                                $mail->setFrom($mail->Username);
                                $mail->addAddress($row['cto_email']);
                                $mail->addReplyTo($mail->Username, constant('EMP_NOMBRE'));
                                $mail->isHTML(true);

                                $mail->Subject = utf8_decode($row['msj_titulo']);
                                $mail->Body    = html_entity_decode($msj);

                                $mail->send();
                            } catch (Exception $e) {
                                $error = "No se pudo enviar el mensaje. Error de envío: {$mail->ErrorInfo}.";
                            }

                            $data_envio = [
                                'bitmen_cliente'    => $row['idcliente'],
                                'bitmen_contacto'   => $row['cto_nombre'],
                                'bitmen_telefono'   => $row['cto_tlf'],
                                'bitmen_correo'     => $row['cto_email'],
                                'bitmen_idmsj'      => $row['msj_id'],
                                'bitmen_titulo'     => $row['msj_titulo'],
                                'bitmen_cuerpo'     => $msj,
                                'bitmen_tipo'       => 'EMAIL'
                            ];

                            if ($error == '') {
                                $data_envio['bitmen_estatus'] = 'Enviado';
                                $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                            } else {
                                $data_envio['bitmen_estatus'] = $error;
                            }

                            $newBitacora->guardar($data_envio, true);
                        }
                    }
                }
            }

            if (is_countable($documentos) && count($documentos)) {
                foreach ($documentos as $row) {

                    if (!is_null($row['fecha_hasta'])) {
                        $fecha_hasta    = new DateTime($row['fecha_hasta']);
                        //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                        $fecha   = new DateTime(date('Y-m-d'));
                        //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                        $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

                        if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

                            $msj = $row['msj_cuerpo'];
                            $factura_msj = '';
                            $nota_msj = '';
                            $orden_msj = '';
                            $factura_conteo = 0;
                            $factura_monto = 0;

                            $facturas = $newListas->consultar("SELECT * FROM app_factura_master fm WHERE (fm.fm_estatus=0 OR fm.fm_estatus=2) AND fm.fm_cliid={$row['ccon_cliid']}")->all();
                            $notas = $newListas->consultar("SELECT * FROM app_notas_de_entrega ne WHERE (ne.ne_estatus=0 OR ne.ne_estatus=2) AND ne.ne_cliid={$row['ccon_cliid']}")->all();
                            $orden = $newListas->consultar("SELECT * FROM app_orden_de_entrega n WHERE (n.n_estatus=0 OR n.n_estatus=2) AND n.n_cliid={$row['ccon_cliid']}")->all();

                            if (is_countable($facturas) && count($facturas)) {

                                foreach ($facturas as $row1) {

                                    $factura_msj .= ' FACV' . $row1['fm_correlativo'] . '/ ';
                                    $factor = 1;
                                    $factura_conteo += 1;
                                    $newPreOrden = new PlanillaPreOrden();
                                    if ($div_master['id'] != $row1['fm_divid']) {
                                        $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['fm_divid'], $div_master['id']);
                                        $factor = $factor_div['df_factor'];
                                    }

                                    $factura_monto += $row1['fm_total'] * $factor;
                                }
                            }

                            if (is_countable($notas) && count($notas)) {

                                foreach ($notas as $row1) {

                                    $nota_msj .= ' NEV' . $row1['ne_correlativo'] . '/ ';
                                    $factor = 1;
                                    $factura_conteo += 1;
                                    $newPreOrden = new PlanillaPreOrden();
                                    if ($div_master['id'] != $row1['ne_divid']) {
                                        $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['ne_divid'], $div_master['id']);
                                        $factor = $factor_div['df_factor'];
                                    }

                                    $factura_monto += $row1['ne_total'] * $factor;
                                }
                            }

                            if (is_countable($orden) && count($orden)) {

                                foreach ($orden as $row1) {

                                    $orden_msj .= ' ORDENV' . $row1['n_correlativo'] . '/ ';

                                    $factor = 1;
                                    $factura_conteo += 1;
                                    $newPreOrden = new PlanillaPreOrden();
                                    if ($div_master['id'] != $row1['n_divid']) {
                                        $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['n_divid'], $div_master['id']);
                                        $factor = $factor_div['df_factor'];
                                    }

                                    $factura_monto += $row1['n_total'] * $factor;
                                }
                            }

                            $combinacion = $factura_msj . $nota_msj . $orden_msj;
                            $mont = Moneda::moneda($factura_monto, $div_master['locale'], $div_master['symbol'], $div_master['precision']);
                            $msj = str_replace('$documentos', $combinacion, $msj);
                            $msj = str_replace('$monto', $mont, $msj);
                            $msj = str_replace('$total_documentos', $factura_conteo, $msj);

                            try {
                                $mail->isSMTP();
                                $mail->Host       = constant('EMP_CORREO_HOST');
                                $mail->SMTPAuth   = true;
                                $mail->Username   = constant('EMP_CORREO');
                                $mail->Password   = constant('EMP_CORREO_PASSWORD');
                                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                                $mail->Port       = constant('EMP_CORREO_PORT');

                                $mail->setFrom($mail->Username);
                                $mail->addAddress($row['cto_email']);
                                $mail->addReplyTo($mail->Username, constant('EMP_NOMBRE'));
                                $mail->isHTML(true);

                                $mail->Subject = utf8_decode($row['msj_titulo']);
                                $mail->Body    = html_entity_decode($msj);

                                $mail->send();
                            } catch (Exception $e) {
                                $error = "No se pudo enviar el mensaje. Error de envío: {$mail->ErrorInfo}.";
                            }

                            $data_envio = [
                                'bitmen_cliente'    => $row['idcliente'],
                                'bitmen_contacto'   => $row['cto_nombre'],
                                'bitmen_telefono'   => $row['cto_tlf'],
                                'bitmen_correo'     => $row['cto_email'],
                                'bitmen_idmsj'      => $row['msj_id'],
                                'bitmen_titulo'     => $row['msj_titulo'],
                                'bitmen_cuerpo'     => $msj,
                                'bitmen_tipo'       => 'EMAIL'
                            ];

                            if ($error == '') {
                                $data_envio['bitmen_estatus'] = 'Enviado';
                                $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                            } else {
                                $data_envio['bitmen_estatus'] = $error;
                            }

                            $newBitacora->guardar($data_envio, true);
                        }
                    }
                }
            }

            $error = ($error == '') ? 'Enviado' : ['errors' => [$error]];
            Http::json_response($error);
        }
    }

    public function cronEMAILmensajes(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (
                !trim(constant('EMP_CORREO')) ||
                !trim(constant('EMP_CORREO_PASSWORD')) ||
                !trim(constant('EMP_CORREO_HOST')) ||
                !trim(constant('EMP_CORREO_PORT'))
            )
                Http::json_response(['errors' => ['Debe configurar todos los parametros para poder enviar correos']]);

            $mail           = new PHPMailer(true);
            $newSMSContact  = new SmsContactosModel();
            $newBitacora    = new BitacoraMensajesModel();
            $newListas = new TablerosListas();
            $div_master = Moneda::Predeterminada();
            $msjcli = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            $row = $newSMSContact->obtenerMensajeContacoSimplemsj($msjcli);

            $error = '';

            //if (is_countable($mensajes) && count($mensajes)) {

            //foreach ($mensajes as $row) {

            /*if (!is_null($row['ultimo_envio'])) {
                        $fecha_hasta    = new DateTime($row['fecha_hasta']);
                        $ultimo_envio   = new DateTime($row['ultimo_envio']);
                        $ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));
                        if ($ultimo_envio > $fecha_hasta) continue;
                    }*/
            if (!is_null($row['fecha_hasta'])) {
                $fecha_hasta    = new DateTime($row['fecha_hasta']);
                //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                $fecha   = new DateTime(date('Y-m-d'));
                //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

                if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

                    try {
                        $mail->isSMTP();
                        $mail->Host       = constant('EMP_CORREO_HOST');
                        $mail->SMTPAuth   = true;
                        $mail->Username   = constant('EMP_CORREO');
                        $mail->Password   = constant('EMP_CORREO_PASSWORD');
                        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                        $mail->Port       = constant('EMP_CORREO_PORT');

                        $mail->setFrom($mail->Username);
                        $mail->addAddress($row['cto_email']);
                        $mail->addReplyTo($mail->Username, constant('EMP_NOMBRE'));
                        $mail->isHTML(true);

                        $mail->Subject = utf8_decode($row['msj_titulo']);
                        $mail->Body    = html_entity_decode($row['msj_cuerpo']);

                        $mail->send();
                    } catch (Exception $e) {
                        $error = "No se pudo enviar el mensaje. Error de envío: {$mail->ErrorInfo}.";
                    }

                    $data_envio = [
                        'bitmen_cliente'    => $row['idcliente'],
                        'bitmen_contacto'   => $row['cto_nombre'],
                        'bitmen_telefono'   => $row['cto_tlf'],
                        'bitmen_correo'     => $row['cto_email'],
                        'bitmen_idmsj'      => $row['msj_id'],
                        'bitmen_titulo'     => $row['msj_titulo'],
                        'bitmen_cuerpo'     => $msj,
                        'bitmen_tipo'       => 'EMAIL'
                    ];

                    if ($error == '') {
                        $data_envio['bitmen_estatus'] = 'Enviado';
                        $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                    } else {
                        $data_envio['bitmen_estatus'] = $error;
                    }

                    $newBitacora->guardar($data_envio, true);
                }else{
                    Http::json_response(['errors' => ['Lo siento ya llego a su limite este mensaje']]);
                }
            }
            //}
            //}

            $error = ($error == '') ? true : ['errors' => [$error]];
            Http::json_response($error);
        }
    }

    public function cronEMAILservicios(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (
                !trim(constant('EMP_CORREO')) ||
                !trim(constant('EMP_CORREO_PASSWORD')) ||
                !trim(constant('EMP_CORREO_HOST')) ||
                !trim(constant('EMP_CORREO_PORT'))
            )
                Http::json_response(['errors' => ['Debe configurar todos los parametros para poder enviar correos']]);

            $mail           = new PHPMailer(true);
            $newSMSContact  = new SmsContactosModel();
            $newBitacora    = new BitacoraMensajesModel();
            $newListas = new TablerosListas();
            $div_master = Moneda::Predeterminada();

            $msjcli = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            $row = $newSMSContact->obtenerMensajeContacoSimplemsj($msjcli);
            $error = '';

            //if (is_countable($servicios) && count($servicios)) {

            //foreach ($servicios as $row) {


            //if (!is_null($row['fecha_hasta'])) {
            $fecha_hasta    = new DateTime($row['fecha_hasta']);
            //$ultimo_envio   = new DateTime($row['ultimo_envio']);
            $fecha   = new DateTime(date('Y-m-d'));
            //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

            $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

            //if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

            $msj = $row['msj_cuerpo'];
            $servicios_msj = '/';
            $estatus_msj = '/';

            $servicioss = $newListas->consultar("SELECT * FROM app_tableros_listas_tareas tr 
                            LEFT JOIN app_tableros_listas lt ON tr.tar_listid=lt.tablist_id 
                            WHERE lt.tablist_tabid=13 AND tr.tar_cliente ={$row['ccon_cliid']}")->all();

            if (is_countable($servicioss) && count($servicioss)) {
                foreach ($servicioss as $row1) {
                    $servicios_msj += 'SERV:' . $row1['tar_descripcion'] . '/';
                    $estatus_msj += $row1['tablist_nombre'] . '/';
                }
            }

            $msj = str_replace('$servicio', $servicios_msj, $msj);
            $msj = str_replace('$estatus_nuevo', $estatus_msj, $msj);
            if (strlen($servicios_msj) > 6) {

                try {
                    $mail->isSMTP();
                    $mail->Host       = constant('EMP_CORREO_HOST');
                    $mail->SMTPAuth   = true;
                    $mail->Username   = constant('EMP_CORREO');
                    $mail->Password   = constant('EMP_CORREO_PASSWORD');
                    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                    $mail->Port       = constant('EMP_CORREO_PORT');

                    $mail->setFrom($mail->Username);
                    $mail->addAddress($row['cto_email']);
                    $mail->addReplyTo($mail->Username, constant('EMP_NOMBRE'));
                    $mail->isHTML(true);

                    $mail->Subject = utf8_decode($row['msj_titulo']);
                    $mail->Body    = html_entity_decode($msj);

                    $mail->send();
                } catch (Exception $e) {
                    $error = "No se pudo enviar el mensaje. Error de envío: {$mail->ErrorInfo}.";
                }

                $data_envio = [
                    'bitmen_cliente'    => $row['idcliente'],
                    'bitmen_contacto'   => $row['cto_nombre'],
                    'bitmen_telefono'   => $row['cto_tlf'],
                    'bitmen_correo'     => $row['cto_email'],
                    'bitmen_idmsj'      => $row['msj_id'],
                    'bitmen_titulo'     => $row['msj_titulo'],
                    'bitmen_cuerpo'     => $msj,
                    'bitmen_tipo'       => 'EMAIL'
                ];

                if ($error == '') {
                    $data_envio['bitmen_estatus'] = 'Enviado';
                    $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                } else {
                    $data_envio['bitmen_estatus'] = $error;
                }

                $newBitacora->guardar($data_envio, true);
            }
            //}
            //}
            //}

            $error = ($error == '') ? 'Enviado' : ['errors' => [$error]];
            Http::json_response($error);
        }
    }

    public function cronEMAILdocumentos(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (
                !trim(constant('EMP_CORREO')) ||
                !trim(constant('EMP_CORREO_PASSWORD')) ||
                !trim(constant('EMP_CORREO_HOST')) ||
                !trim(constant('EMP_CORREO_PORT'))
            )
                Http::json_response(['errors' => ['Debe configurar todos los parametros para poder enviar correos']]);

            $mail           = new PHPMailer(true);
            $newSMSContact  = new SmsContactosModel();
            $newBitacora    = new BitacoraMensajesModel();
            $newListas = new TablerosListas();
            $div_master = Moneda::Predeterminada();

            $msjcli = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            $row = $newSMSContact->obtenerMensajeContacoSimplemsj($msjcli);
            $error = '';

            if (!is_null($row['fecha_hasta'])) {
                $fecha_hasta    = new DateTime($row['fecha_hasta']);
                //$ultimo_envio   = new DateTime($row['ultimo_envio']);
                $fecha   = new DateTime(date('Y-m-d'));
                //$ultimo_envio->add(new DateInterval("P{$row['intervalo']}D"));

                $numBitacora = $newBitacora->obtenerNumBitacoramensaje($row['idcliente'], $row['msj_id']);

                if (($fecha_hasta >= $fecha) && ($row['intervalo'] > $numBitacora)) {

                    $msj = $row['msj_cuerpo'];
                    $factura_msj = '';
                    $nota_msj = '';
                    $orden_msj = '';
                    $factura_conteo = 0;
                    $factura_monto = 0;

                    $facturas = $newListas->consultar("SELECT * FROM app_factura_master fm WHERE (fm.fm_estatus=0 OR fm.fm_estatus=2) AND fm.fm_cliid={$row['ccon_cliid']}")->all();
                    $notas = $newListas->consultar("SELECT * FROM app_notas_de_entrega ne WHERE (ne.ne_estatus=0 OR ne.ne_estatus=2) AND ne.ne_cliid={$row['ccon_cliid']}")->all();
                    $orden = $newListas->consultar("SELECT * FROM app_orden_de_entrega n WHERE (n.n_estatus=0 OR n.n_estatus=2) AND n.n_cliid={$row['ccon_cliid']}")->all();

                    if (is_countable($facturas) && count($facturas)) {

                        foreach ($facturas as $row1) {

                            $factura_msj .= ' FACV' . $row1['fm_correlativo'] . '/ ';
                            $factor = 1;
                            $factura_conteo += 1;
                            $newPreOrden = new PlanillaPreOrden();
                            if ($div_master['id'] != $row1['fm_divid']) {
                                $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['fm_divid'], $div_master['id']);
                                $factor = $factor_div['df_factor'];
                            }

                            $factura_monto += $row1['fm_total'] * $factor;
                        }
                    }

                    if (is_countable($notas) && count($notas)) {

                        foreach ($notas as $row1) {

                            $nota_msj .= ' NEV' . $row1['ne_correlativo'] . '/ ';
                            $factor = 1;
                            $factura_conteo += 1;
                            $newPreOrden = new PlanillaPreOrden();
                            if ($div_master['id'] != $row1['ne_divid']) {
                                $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['ne_divid'], $div_master['id']);
                                $factor = $factor_div['df_factor'];
                            }

                            $factura_monto += $row1['ne_total'] * $factor;
                        }
                    }

                    if (is_countable($orden) && count($orden)) {

                        foreach ($orden as $row1) {

                            $orden_msj .= ' ORDENV' . $row1['n_correlativo'] . '/ ';

                            $factor = 1;
                            $factura_conteo += 1;
                            $newPreOrden = new PlanillaPreOrden();
                            if ($div_master['id'] != $row1['n_divid']) {
                                $factor_div = $newPreOrden->obtenerDivisaAlCambio($row1['n_divid'], $div_master['id']);
                                $factor = $factor_div['df_factor'];
                            }

                            $factura_monto += $row1['n_total'] * $factor;
                        }
                    }

                      if($factura_monto>0){
                        $combinacion = $factura_msj . $nota_msj . $orden_msj;
                        $mont = Moneda::moneda($factura_monto, $div_master['locale'], $div_master['symbol'], $div_master['precision']);
                        $msj = str_replace('$documentos', $combinacion, $msj);
                        $msj = str_replace('$monto', $mont, $msj);
                        $msj = str_replace('$total_documentos', $factura_conteo, $msj);
    
                        try {
                            $mail->isSMTP();
                            $mail->Host       = constant('EMP_CORREO_HOST');
                            $mail->SMTPAuth   = true;
                            $mail->Username   = constant('EMP_CORREO');
                            $mail->Password   = constant('EMP_CORREO_PASSWORD');
                            $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                            $mail->Port       = constant('EMP_CORREO_PORT');
    
                            $mail->setFrom($mail->Username);
                            $mail->addAddress($row['cto_email']);
                            $mail->addReplyTo($mail->Username, constant('EMP_NOMBRE'));
                            $mail->isHTML(true);
    
                            $mail->Subject = utf8_decode($row['msj_titulo']);
                            $mail->Body    = html_entity_decode($msj);
    
                            $mail->send();
                        } catch (Exception $e) {
                            $error = "No se pudo enviar el mensaje. Error de envío: {$mail->ErrorInfo}.";
                        }
    
                        $data_envio = [
                            'bitmen_cliente'    => $row['idcliente'],
                            'bitmen_contacto'   => $row['cto_nombre'],
                            'bitmen_telefono'   => $row['cto_tlf'],
                            'bitmen_correo'     => $row['cto_email'],
                            'bitmen_idmsj'      => $row['msj_id'],
                            'bitmen_titulo'     => $row['msj_titulo'],
                            'bitmen_cuerpo'     => $msj,
                            'bitmen_tipo'       => 'EMAIL'
                        ];
    
                        if ($error == '') {
                            $data_envio['bitmen_estatus'] = 'Enviado';
                            $newSMSContact->editar($row['id'], ['sc_ultimo_envio' => date('Y-m-d')]);
                        } else {
                            $data_envio['bitmen_estatus'] = $error;
                        }
    
                        $newBitacora->guardar($data_envio, true);
                    }else{
                        Http::json_response(['errors' => ['Lo siento sin documento pendiente']]);
                    }
                }else{
                    Http::json_response(['errors' => ['Lo siento ya llego a su limite este mensaje']]);
                }
            }

            $error = ($error == '') ? 'Enviado' : ['errors' => [$error]];
            Http::json_response($error);
        }
    }

    public function bitacora()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newBitacora = new BitacoraMensajesModel();
            $historial = $newBitacora->obtenerBitacora();
            $lista = [];
            if (is_countable($historial) && count($historial)) {
                foreach ($historial as $row) {
                    $lista[] = [
                        'cliente'   => $row['cli_razon_social'],
                        'contacto'  => $row['bitmen_contacto'],
                        'telefono'  => $row['bitmen_telefono'],
                        'correo'    => $row['bitmen_correo'],
                        'titulo'    => $row['bitmen_titulo'],
                        'cuerpo'    => $row['bitmen_cuerpo'],
                        'fecha'     => $row['fecha'],
                        'estatus'   => $row['bitmen_estatus'],
                        'tipo'      => $row['bitmen_tipo']
                    ];
                }
            }
            Http::json_response($lista);
        }
    }
}
