<div class="modal fade" id="modalTarjeta" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header border-0">
                <h5 class="modal-title" style="font-size: 20px;">
                    <i class="far fa-file-alt"></i>
                    <span class="fw-mediumbold">
                        Tarjeta: {{ tarea.nombre_tarea }}</span>
                    <span class="text-muted">
                        de la lista <span style="color: <?= $color ?>;"><b>{{ tarea.nombre_lista }}</b></span>
                    </span>
                </h5>

                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">×</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-9">
                        <div class="row">
                            <div class="col-12">
                                <br><small class="text-warning" v-if="cliente!=false">Cliente: {{ cliente.nombre }}</small>
                                <br>Creado por: <small class="text-info"> {{tarea.creado}}</small>
                                <hr>
                                <div class="form-group">
                                    <h6 class="card-title mb-2"><i class="fas fa-keyboard"></i> Descripción</h6>
                                    <div v-if="tarea.descripcion == null">
                                        <textarea @click="activarTexareaDescripcion" :id="'texaera_descripcion_tarea' +  tarea.id_tarea" class="form-control" style="display: block;" placeholder="Añadir una descripción mas detallada" @keydown.prevent.enter="actualizarDescripcionTarea($event)"></textarea>
                                    </div>
                                    <div v-else>
                                        <span :id="'span_descripcion_tarea' +  tarea.id_tarea" style="display: block; background-color: #f6f6f6; padding: 10px; border-radius: 5px" @click="preEditarDescripcion">{{ tarea.descripcion }}</span>
                                        <textarea :id="'texaera_descripcion_tarea' +  tarea.id_tarea" style="display: none" class="form-control" v-model="tarea.descripcion" placeholder="Añadir una descripción mas detallada" @keydown.prevent.enter="actualizarDescripcionTarea($event)"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mb-0 pb-0">
                            <div class="col-12" v-if="adjuntos.enlaces.length > 0 || adjuntos.archivos.length > 0">
                                <div class="form-group">
                                    <h6 class="card-title"><i class="fas fa-paperclip"></i> Adjunto </h6>
                                    <div class="card-body">
                                        <div class="d-flex" v-for="row in adjuntos.enlaces">
                                            <div class="avatar">
                                                <span class="avatar-title rounded-circle border border-white bg-info"><span class="fas fa-link"></span></span>
                                            </div>
                                            <div class="flex-1 ml-3 pt-1">
                                                <a :href="row.enlace" target="_blank" rel="noopener noreferrer">
                                                    <h5 class="text-uppercase fw-bold mb-1">{{ row.enlace_nombre }}</h5>
                                                </a>
                                            </div>
                                            <div class="float-right pt-1">
                                                <small class="text-muted">{{ fechaNormal(row.creado) }}</small>
                                            </div>
                                        </div>
                                        <div class="d-flex" v-for="row in adjuntos.archivos">
                                            <div class="avatar">
                                                <a :href="'<?= constant('IMG_URI') ?>adjuntosservicios/' + row.archivo" :download="row.archivo">
                                                    <img v-if="row.imagen" :src="'<?= constant('IMG_URI') ?>adjuntosservicios/' + row.archivo" alt="" class="avatar-img rounded-circle border border-white" width="150" height="150">
                                                    <span v-else class="avatar-title rounded-circle border border-white bg-info"><span class="far fa-file-archive"></span></span>
                                                </a>
                                            </div>
                                            <div class="flex-1 ml-3 pt-1">
                                                <a :href="'<?= constant('IMG_URI') ?>adjuntosservicios/' + row.archivo" :download="row.archivo">{{ row.nombre }}</a>
                                            </div>
                                            <div class="float-right pt-1">
                                                <small class="text-muted">{{ fechaCalendario(row.creado) }}</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mb-0 pb-0">
                            <div class="col-12 mb-0 pb-0" v-for="row in checklist">
                                <div class="form-group mb-0 pb-0">
                                    <div class="progress-card mb-2 pb-2">
                                        <div class="progress-status">
                                            <span style="cursor: pointer;" :id="'titulo_checklist' + row.id" @click="preEditarChecklist(row)">
                                                <h6 class="card-title mb-2"> <i class="fas fa-tasks"></i> {{ row.nombre }}</h6>
                                            </span>
                                            <input type="text" class="form-control" style="display: none; padding: 5px 10px;" :value="row.nombre" :id="'titulo_checklist_hidden' + row.id" @keyup.enter="editarChecklist(row)">
                                            <span class="text-muted fw-bold"> <span :id="'titleProgress'+row.id"> 0%</span> <button class="btn btn-sm" @click.prevent="eliminarChecklist(row.id)" style="background-color: #D9534F; color: white;">Eliminar</button></span>
                                        </div>
                                        <div class="progress" style="height:5px">
                                            <div class="progress-bar bg-info" :id="'progressbar'+row.id" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" data-toggle="tooltip" data-placement="top" title="" data-original-title="0"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group" v-for="item in row.items">
                                    <div class="row">
                                        <div class="col-1 pr-0 mr-0" style="display: flex; align-items: start; padding-top: 16px">
                                            <label class="custom-checkbox custom-control checkbox-secondary">
                                                <input type="checkbox" class="custom-control-input" v-model="item.estatus" @change.prevent="modificarEstatusItem(item.id, $event)">
                                                <span class="custom-control-label"> </span>
                                            </label>
                                        </div>
                                        <div class="col-10 pl-0 ml-0">
                                            <div class="row">
                                                <div class="col-12">
                                                    <div v-if="item.descripcion == null">
                                                        <textarea :id="'textarea_item' +  item.id" class="form-control" style="display: block;" placeholder="Añada un elemento"></textarea>
                                                        <button class="btn btn-sm mt-2 pull-right" @click="agregarItem(row.id, item)" style="background-color: <?= $color ?>;color:white;">Guardar Elemento</button>
                                                    </div>
                                                    <div v-else>
                                                        <span :id="'span_textarea_item' +  item.id" style="display: block; background-color: #f6f6f6; padding: 5px 10px; border-radius: 5px;" @click="preEditarItem(item.id)">
                                                            <pre style="font-family: Verdana, Geneva, Tahoma, sans-serif; white-space:pre-wrap; Word-wrap:break-Word">{{ item.descripcion }}</pre>
                                                            <div class="text-right">
                                                                <small class="text-muted" style="font-size: 10px;">{{ fechaCalendario(item.actualizado) }}</small>
                                                            </div>
                                                        </span>
                                                        <div :id="'div_textarea_item' +  item.id" style="display: none">
                                                            <textarea class="form-control" :id="'textarea_item' +  item.id" v-model="item.descripcion" placeholder="Añada un elemento"></textarea>
                                                            <button :id="'btn-item' + item.id" class="btn btn-sm pull-right mt-2" @click="agregarItem(row.id, item)" style="background-color: <?= $color ?>;color:white;">Guardar Cambios</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-1 p-0 m-0" style="display: flex; align-items: center;">
                                            <button class="btn btn-sm btn-icon btn-round" title="Eliminar" @click.prevent="eliminarItem(row.id, item.id)"><i class="fa fa-trash" style="color: #D9534F;"></i></button>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-1 pr-0 mr-0"></div>
                                        <div class="col pl-0 ml-0">
                                            <button class="btn" style="background-color: #f6f6f6; padding: 5px 16px" @click.prevent="preAgregarItem(row.id)">Añada un elemento</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h6 class="card-title mb-2" style="padding-left: 15px;padding-top: 10px;"><i class="fas fa-comment-alt"></i> Comentarios</h6>
                            </div>
                            <div class="col-12">
                                <div class="list-group list-group-messages list-group-flush" style="margin-left: 10px;margin-right: 10px;">
                                    <div class="list-group-item unread comentario" style="background-color: #f6f6f6; padding:5px 10px 5px 0px; margin-bottom: 10px;border: none; border-radius: 5px;" v-for="(row, index) in comentarios" :key="index">
                                        <div class="list-group-item-body pl-3">
                                            <div class="row" :id="'comentario'+row.id" @click="preeditarComentario(row)">
                                                <div class="col-12 col-lg-12">
                                                    <p class="list-group-item-text " style="color:#2A2F5B"> {{ row.descripcion }}</p>
                                                    <div class="col-12 text-lg-right text-muted" style="padding:0px; font-size:10px;">
                                                        <span class="list-group-item-title" style="color:<?= $color ?>">
                                                            {{ row.empleado }}
                                                        </span>
                                                        el {{ row.fecha }}
                                                        <p class="list-group-item-text"> </p>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row" :id="'comentario_hidden'+row.id" style="display: none">
                                                <div class="col-12">
                                                    <textarea class="form-control" :id="'textarea_comentario' + row.id">{{ row.descripcion }}</textarea>
                                                    <button :id="'btn-comentario' + row.id" class="btn btn-sm pull-right mt-2" @click.prevent="editarComentario(row)" style="background-color: <?= $color ?>;color:white;">Guardar Cambios</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <textarea id="agregar_comentario" class="form-control" placeholder="Escribe y agrega un nuevo comentario" @keydown.prevent.enter="agregarComentario($event)"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-sm-3">
                        <h6 class="card-title mb-2" style="padding-top: 10px;"><i class="fas fa-cogs"></i> Acciones </h6>
                        <div class="nav flex-column nav-pills nav-secondary " id="v-pills-tab-with-icon" role="tablist" aria-orientation="vertical">
                            <a class="nav-link" style="background-color: #f6f6f6;" onmouseover="this.style.color='#fff'; this.style.background='<?= $color ?>';" onmouseout="this.style.color='#585c5d'; this.style.backgroundColor='#f6f6f6';" :href="'<?= ruta_base() ?>servicios/imprimirTarea/' + tarea.id_tarea" target="_blank">
                                <i class="flaticon-file" style="font-size: 22px;"></i>
                                Imprimir
                            </a>
                            <a class="nav-link" style="background-color: #f6f6f6;" onmouseover="this.style.color='#fff'; this.style.background='<?= $color ?>';" onmouseout="this.style.color='#585c5d'; this.style.backgroundColor='#f6f6f6';" @click="imprimirTicket(tarea.id_tarea)">
                                <i class="fas fa-print" style="font-size: 22px;"></i>
                                Ticket
                            </a>
                            <a class="nav-link" style="background-color: #f6f6f6;" onmouseover="this.style.color='#fff'; this.style.background='<?= $color ?>';" onmouseout="this.style.color='#585c5d'; this.style.backgroundColor='#f6f6f6';" @click.prevent="modalCorreo(tarea.id_tarea)" href="">
                                <i class="flaticon-envelope" style="font-size: 22px;"></i>
                                Enviar correo
                            </a>
                            <a href="" class="nav-link" style="background-color: #f6f6f6;" onmouseover="this.style.color='#fff'; this.style.background='<?= $color ?>';" onmouseout="this.style.color='#585c5d'; this.style.backgroundColor='#f6f6f6';" @click.prevent="modalMiembros" id="tabmiembros">
                                <i class="flaticon-user-5" style="font-size: 22px;"></i>
                                Miembros
                            </a>
                            <a href="" class="nav-link" style="background-color: #f6f6f6;" onmouseover="this.style.color='#fff'; this.style.background='<?= $color ?>';" onmouseout="this.style.color='#585c5d'; this.style.backgroundColor='#f6f6f6';" @click.prevent="modalClientes" id="tabcliente">
                                <i class="flaticon-user-6" style="font-size: 22px;"></i>
                                Cliente
                            </a>
                            <a href="" class="nav-link" style="background-color: #f6f6f6;" onmouseover="this.style.color='#fff'; this.style.background='<?= $color ?>';" onmouseout="this.style.color='#585c5d'; this.style.backgroundColor='#f6f6f6';" @click.prevent="modalcheck()" id="checklist">
                                <i class="flaticon-interface-1" style="font-size: 22px;"></i>
                                Checklist
                            </a>
                            <a href="" class="nav-link" style="background-color: #f6f6f6;" onmouseover="this.style.color='#fff'; this.style.background='<?= $color ?>';" onmouseout="this.style.color='#585c5d'; this.style.backgroundColor='#f6f6f6';" @click.prevent="modalVencimiento" id="tabvencimiento">
                                <i class="flaticon-clock" style="font-size: 22px;"></i>
                                Vencimiento
                            </a>
                            <a href="" class="nav-link" style="background-color: #f6f6f6;" onmouseover="this.style.color='#fff'; this.style.background='<?= $color ?>';" onmouseout="this.style.color='#585c5d'; this.style.backgroundColor='#f6f6f6';" @click.prevent="modalAdjunto" id="tabadjunto">
                                <i class="flaticon-tool" style="font-size: 22px;"></i>
                                Adjunto
                            </a>
                            <a href="" v-if="Object.keys(cliente).length > 0" class="nav-link" style="background-color: #f6f6f6;" onmouseover="this.style.color='#fff'; this.style.background='<?= $color ?>';" onmouseout="this.style.color='#585c5d'; this.style.backgroundColor='#f6f6f6';" @click.prevent="modalDocumento" id="tabdocumento">
                                <i class="flaticon-plus" style="font-size: 22px;"></i>
                                Documento
                            </a>
                        </div>

                        <br>
                        <h6 class="card-title mb-2" style="padding-top: 10px;"><i class="fas fa-file-invoice"></i> Documentos </h6>
                        <div class="nav flex-column nav-pills nav-secondary " id="v-pills-tab-with-icon" role="tablist" aria-orientation="vertical">
                            <a v-for="list in listafn" class="nav-link" style="background-color: #f6f6f6;" onmouseover="this.style.color='#fff'; this.style.background='<?= $color ?>';" onmouseout="this.style.color='#585c5d'; this.style.backgroundColor='#f6f6f6';" :href="list.url" target="_blank">
                                {{ list.tipo }}{{list.id}}
                            </a>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="alert alert-warning" role="alert" v-for="error in errorForm">
                            {{ error }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="board" style="position: absolute; z-index: 100; margin: 0 0; padding: 0; display: none" id="popup">
        <div class="kanban-board">
            <header class="kanban-board-header text-center">
                <div class="kanban-title-board">Añadir Checklist</div>
                <div class="kanban-title-button d-inline-flex">
                    <button class="mr-2" onclick="cerrarPopup()"><i class="fas fa-times"></i></button>
                </div>
            </header>
            <main class="kanban-drag">
                <select class="form-control" id="inputChecklist">
                    <option value="" disabled>Seleccionar un elemento</option>
                    <option value="0">Checklist vacio</option>
                    <?php foreach ($plantillas as $row) : ?>
                        <option value="<?= $row['cat_id'] ?>"><?= $row['cat_nombre'] ?></option>
                    <?php endforeach; ?>
                </select>
                <br>
                <button class="btn" @click.prevent="agregarChecklist" style="background-color: <?= $color ?>; padding: 5px 16px">Añadir</button>
            </main>
        </div>
    </div>
    <div class="board" style="position: absolute; z-index: 100; margin: 0 0; padding: 0; display: none" id="popupMiembros">
        <div class="kanban-board">
            <header class="kanban-board-header text-center">
                <div class="kanban-title-board">Añadir Miembros</div>
                <div class="kanban-title-button d-inline-flex">
                    <button class="mr-2" onclick="cerrarPopup()"> <i class="fas fa-times"></i></button>
                </div>
            </header>
            <main class="kanban-drag">
                <div class="form-group">
                    <div class="input-icon">
                        <input type="text" class="form-control" id="inputMiembros" placeholder="Buscar miembros" @keyup="buscarMiembros($event)">
                        <span class="input-icon-addon">
                            <i class="fa fa-search"></i>
                        </span>
                    </div>
                    <ul class="list-group" v-if="searchMiembros.length">
                        <a class="list-group-item list-group-item-action list-group-item-secondary d-flex justify-content-between align-items-center" v-for="row in searchMiembros" @click.prevent="agregarMiembro(row.id)">
                            {{ row.nombre }}
                        </a>
                    </ul>
                    <br>
                    <ul class="list-group" v-if="miembros.length">
                        <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center" v-for="row in miembros">
                            {{ row.nombre }}
                            <i class="fa fa-times text-danger" style="cursor: pointer" @click="eliminarMiembro(row.id)"></i>
                        </li>
                    </ul>
                </div>
            </main>
        </div>
    </div>
    <div class="board" style="position: absolute; z-index: 100; margin: 0 0; padding: 0; display: none;width: 320px;overflow-x: hidden;" id="popupVencimiento">
        <div class="kanban-board">
            <header class="kanban-board-header text-center">
                <div class="kanban-title-board">Agregar fecha de vencimiento</div>
                <div class="kanban-title-button d-inline-flex">
                    <button class="mr-2" onclick="cerrarPopup()"><i class="fas fa-times"></i></button>
                </div>
            </header>
            <main class="kanban-drag">
                <div class="form-group">
                    <label for="fecha">Fecha</label>
                    <input type="date" class="form-control" v-model="fecha" id="fecha_ven">
                </div>
                <div class="form-group">
                    <label for="fecha">hora</label>
                    <input type="text" class="form-control" v-model="hora" v-mask="'##:##'">
                </div>
                <div class="form-group">
                    <label for="fecha">Recordatorio</label>
                    <select class="form-control" v-model="recordatorio">
                        <option value="">Ninguno</option>
                        <option value="1">1 día antes</option>
                        <option value="2">2 días antes</option>
                    </select>
                </div>
                <br>
                <button class="btn" @click.prevent="guardarVencimiento" style="background-color: <?= $color ?>; padding: 5px 16px">Guardar</button>
            </main>
        </div>
    </div>
    <div class="board" style="position: absolute; z-index: 100; margin: 0 0; padding: 0; display: none;" id="popupCliente">
        <div class="kanban-board">
            <header class="kanban-board-header text-center">
                <div class="kanban-title-board">Añadir cliente</div>
                <div class="kanban-title-button d-inline-flex">
                    <button class="mr-2" onclick="cerrarPopup()"> <i class="fas fa-times"></i></button>
                </div>
            </header>
            <main class="kanban-drag">
                <button type="button" class="btn btn-success btn-sm" style="box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;" @click="Addcliente(clientem)"><i class="flaticon-plus"> Nuevo cliente</i></button>
                <div class="row" v-if="clientem==true">
                    <div class="col-sm-11">
                        <div class="form-group">
                            <label for="razon_social">Tipo de documento</label>
                            <select class="form-control" id="cli_tipodoc" name="cli_tipodoc" v-model="tipoci" @change="formatearSelect()">
                                <option value="" disabled>selecione un documento</option>
                                <?php foreach ($tipos_de_documentos as $row) : ?>
                                    <option value="<?= $row['tipodoc_id'] ?>"><?= $row['tipodoc_codigo'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="razon_social">Nº de documento</label>
                            <input type="text" id="cli_dni" v-if="tipoci==2" name="cli_dni" class="form-control" v-mask="'V########'" v-model="clidni" @keyup="clidni=clidni.toUpperCase()">
                            <input type="text" id="cli_dni" v-else name="cli_dni" class="form-control" v-mask="'A#########'" v-model="clidni" @keyup="clidni=clidni.toUpperCase()">
                        </div>
                        <div class="form-group">
                            <label for="razon_social">Razón social</label>
                            <input type="text" id="cli_razon_social" name="cli_razon_social" class="form-control" maxlength="150" onkeyup="this.value=this.value.toUpperCase()">
                        </div>
                        <div class="form-group">
                            <label for="razon_social">Teléfono</label>
                            <input type="tel" v-mask="'(####) ###-####'" id="cli_telefono" name="cli_telefono" class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="razon_social">Correo electrónico</label>
                            <input type="text" id="cli_email" name="cli_email" class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="razon_social">Dirección</label>
                            <input type="text" id="cli_direccion" name="cli_direccion" class="form-control">
                        </div>
                        <div class="form-check">
                            <label class="form-check-label" for="natural">
                                <input class="form-check-input" id="cli_natural" name="cli_natural" type="checkbox" checked>
                                <span class="form-check-sign">Persona natural (no jurídica)</span>
                            </label>
                        </div>
                        <div class="text-center"><button type="button" class="btn btn-primary" @click="guardarCliente()">Guardar</button></div>
                    </div>
                </div>
                <div class="form-group" v-if="clientem==false">
                    <div class="input-icon">
                        <input type="text" class="form-control" id="inputClientes" placeholder="Buscar cliente" @keyup="buscarClientes($event)">
                        <span class="input-icon-addon">
                            <i class="fa fa-search"></i>
                        </span>
                    </div>
                </div>
                <ul class="list-group" v-if="searchClientes.length" v-if="clientem==false">
                    <a class="list-group-item list-group-item-action list-group-item-secondary d-flex justify-content-between align-items-center" v-for="row in searchClientes" @click.prevent="agregarCliente(row.id)">
                        {{ row.nombre }}
                    </a>
                </ul>
                <br>
                <ul class="list-group" v-if="Object.keys(cliente).length > 0 && clientem==false">
                    <li class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                        {{ cliente.nombre }}
                        <i class="fa fa-times text-danger" style="cursor: pointer" @click="eliminarCliente"></i>
                    </li>
                </ul>
        </div>
        </main>
    </div>
    <div class="board" style="position: absolute; z-index: 100; margin: 0 0; padding: 0; display: none;width: 320px;overflow-x: hidden;" id="popupAdjunto">
        <div class="kanban-board">
            <header class="kanban-board-header text-center">
                <div class="kanban-title-board">Adjuntar</div>
                <div class="kanban-title-button d-inline-flex">
                    <button class="mr-2" onclick="cerrarPopup()"> <i class="fas fa-times"></i></button>
                </div>
            </header>
            <main class="kanban-drag">
                <div class="upload-btn-wrapper" :class="upload_imagen">
                    <button class="btn btn-block btn-sm" style="background-color: <?= $color ?>;">Ordenador</button>
                    <input type="file" style="cursor: pointer;" ref="file" @change="handleFileUpload()" accept=".jpg,.jpeg,.png,.gif,.pdf,.zip,.rar,.doc,.docx,.odt,.ods,.csv,.xlsx,.xls">
                </div>
                <div class="form-group">
                    <label for="">Enlace</label>
                    <input type="text" class="form-control" placeholder="Pegue un vinculo aqui" id="inputEnlace">
                </div>
                <div class="form-group">
                    <label for="">Nombre del enlace (opcional)</label>
                    <input type="text" class="form-control" id="inputEnlaceNombre">
                </div>
                <button class="btn" @click.prevent="guardarEnlace" style="background-color: <?= $color ?>; padding: 5px 16px">Guardar</button>
            </main>
        </div>
    </div>
    <div class="board" style="position: absolute; z-index: 100; margin: 0 0; padding: 0; display: none;width: 320px;overflow-x: hidden;" id="popupDocumento">
        <div class="kanban-board">
            <header class="kanban-board-header text-center">
                <div class="kanban-title-board">Generar documento</div>
                <div class="kanban-title-button d-inline-flex">
                    <button class="mr-2" onclick="cerrarPopup()"> <i class="fas fa-times"></i></button>
                </div>
            </header>
            <main class="kanban-drag">
                <div class="form-group">
                    <label for="documento">Documento</label>
                    <select class="form-control" v-model="seleccion_documento">
                        <option value="">Seleccione un documento</option>
                        <option value="notasdeentrega">Nota de Entrega</option>
                        <option value="pos">Factura</option>
                    </select>
                </div>
                <button class="btn" @click.prevent="generarDocumento" style="background-color: <?= $color ?>; padding: 5px 16px">Guardar</button>
            </main>
        </div>
    </div>
</div>