<style>
    .content-colors {
        width: 100%;
        position: relative;
        text-align: center;
    }

    .content-colors>label {
        display: inline-block;
        margin: 5px;
        opacity: 0.7;
    }
</style>
<div class="container" id="AppTableros" v-cloak>
    <div class="page-inner">
        <div class="page-header">
            <h4 class="page-title">Gestión de Proyectos | Incidencias</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('clientes') ?>">Gestión de Proyectos | Incidencias</a>
                </li>
            </ul>
        </div>
        <div class="row">
            <div class="col-md-2">
                <div class="nav flex-column nav-pills nav-secondary nav-pills-no-bd nav-pills-icons" id="v-pills-tab-with-icon" role="tablist" aria-orientation="vertical">
                    <a class="nav-link active" id="v-pills-profile-tab-icons" data-toggle="pill" href="#tab_incidencias" role="tab" aria-controls="tab_incidencias" aria-selected="true">
                        Incidencias
                    </a>
                    <a class="nav-link " id="v-pills-home-tab-icons" data-toggle="pill" href="#tab_tableros" role="tab" aria-controls="tab_tableros" aria-selected="false">
                        Tableros ( {{ tableros.length }} )
                    </a>
                    <a class="nav-link" id="v-pills-profile-tab-icons" data-toggle="pill" href="#tab_plantillas" role="tab" aria-controls="tab_plantillas" aria-selected="false">
                        Plantillas ( {{ plantillas.length }} )
                    </a>
                    
                    <a class="nav-link" id="v-pills-profile-tab-icons" data-toggle="pill" href="#tab_historico" role="tab" aria-controls="tab_historico" aria-selected="false" @click.prevent="obtenerHistorico">
                        Histórico
                    </a>
                    <a class="nav-link" id="v-pills-profile-tab-icons" data-toggle="pill" href="#tab_vencimiento" role="tab" aria-controls="tab_vencimiento" aria-selected="false">
                        Vencimiento
                    </a>
                </div>
            </div>
            <div class="col-md-10" :class="loader">
                <div class="tab-content">
                    <div class="tab-pane fade show active" id="tab_tableros" role="tabpanel">
                        <h2 class="fw-bold">
                            Tableros
                            <button title="Nuevo tablero" type="button" class="btn btn-icon btn-round m-3" @click="modalTablero" data-toggle="tooltip" data-original-title="Subir archivo">
                                <i class="fa fa-plus"></i>
                            </button>
                        </h2>

                        <div v-if="favorito.length > 0">
                            <h3>
                                <i class="far fa-star text-secondary" style="font-size: 25px;"></i>
                                Tableros favoritos
                            </h3>
                            <hr>
                            <div class="row row-projects">
                                <div class="col-sm-6 col-lg-3" v-for="row in favorito">
                                    <div class="card" style="min-height: 140px;">
                                        <div class="card-body pt-2">
                                            <a :href="row.uri" style="text-decoration: none;">
                                                <h5 class="mb-1 fw-bold" :style="'text-transform: uppercase; color: ' + row.color">{{ row.nombre }}</h5>
                                                <p class="small mb-2 text-muted" style="font-size: 12px;line-height: inherit;">Ultima modificación: <br> {{ fechaCalendario(row.modificacion) }}</p>
                                            </a>
                                            <div class="avatar-group">
                                                <div class="avatar avatar-sm" v-for="empleado in row.grupos">
                                                    <span :title="empleado.nombre + ' ' + empleado.apellido" class="avatar-title rounded-circle border border-white bg-info">{{ empleado.nombre.charAt() }}</span>
                                                </div>
                                                <div class="avatar avatar-sm">
                                                    <span :title="'Agregar Administrador'" class="avatar-title rounded-circle border border-white" @click="modalAdministrador(row.id)" style="cursor: pointer;"><i class="fas fa-user-plus"></i></span>
                                                </div>
                                                <div class="avatar avatar-sm">
                                                    <span :title="'Eliminar Tablero'" class="avatar-title rounded-circle border border-white" @click="eliminarTablero(row)" style="cursor: pointer; background-color: #000"><i class="fas fa-trash"></i></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <h3>
                                Tableros personales
                            </h3>
                            <hr>
                        </div>

                        <div class="row row-projects">
                            <div class="col-sm-6 col-lg-3" v-for="row in tableros">
                                <div class="card" style="min-height: 140px;">
                                    <div class="card-body pt-2">
                                        <a :href="row.uri" style="text-decoration: none;">
                                            <h5 class="mb-1 fw-bold" :style="'text-transform: uppercase; color: ' + row.color">{{ row.nombre }}</h5>
                                            <p class="small mb-2 text-muted" style="font-size: 12px;line-height: inherit;">Ultima modificación: <br> {{ fechaCalendario(row.modificacion) }}</p>
                                        </a>
                                        <div class="avatar-group">
                                            <div class="avatar avatar-sm" v-for="empleado in row.grupos">
                                                <span :title="empleado.nombre + ' ' + empleado.apellido" class="avatar-title rounded-circle border border-white bg-info">{{ empleado.nombre.charAt() }}</span>
                                            </div>
                                            <div class="avatar avatar-sm">
                                                <span :title="'Agregar Administrador'" class="avatar-title rounded-circle border border-white" @click="modalAdministrador(row.id)" style="cursor: pointer;"><i class="fas fa-user-plus"></i></span>
                                            </div>
                                            <div class="avatar avatar-sm">
                                                <span :title="'Eliminar Tablero'" class="avatar-title rounded-circle border border-white" @click="eliminarTablero(row)" style="cursor: pointer; background-color: #000"><i class="fas fa-trash"></i></span>
                                            </div>
                                        </div>
                                        <i v-if="row.favorito" class="fas fa-star text-secondary" style="font-size: 10px;"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="tab_plantillas" role="tabpanel">
                        <h2 class="fw-bold"> Plantillas
                            <button title="Nueva Plantilla" type="button" class="btn btn-icon btn-round m-3" @click="modalPlantilla" data-toggle="tooltip" data-original-title="Subir archivo">
                                <i class="fa fa-plus"></i>
                            </button>
                        </h2>

                        <div class="row row-projects">
                            <div class="col-sm-6 col-lg-12" v-for="row in plantillas">
                                <div class="card" style="margin-bottom: 15px;">
                                    <div class="card-body pt-3" style="padding-bottom:0px;">
                                        <a href="#" style="text-decoration: none;">
                                            <h5 @click.prevent="editModalPlantilla(row)" class="mb-1 fw-bold" style="color: #3498db;text-transform: uppercase;width:40%;float:left;padding-right: 10px;">{{ row.categoria }}</h5>
                                            <p class="small mb-2 text-muted" style="width:20%;float:left;padding-right: 5px;">Creado por: {{ row.empleado }}</p>
                                            <p class="small mb-2 text-muted" style="width:30%;float:left;padding-right: 5px;">Ultima modificación: {{ row.modificacion }}</p>
                                            <p style="width:10%;float:left;padding-right: 5px;">
                                                <button class="btn btn-icon btn-round" @click="eliminarPlantilla(row)"><i class="fa fa-trash"></i></button>
                                            </p>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade show active" id="tab_incidencias" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_incidencias">
                                        <thead>
                                            <tr>
                                                <th>Título</th>
                                                <th>Cliente</th>
                                                <th>Tablero</th>
                                                <th>Fecha</th>
                                                <th>Estatus</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (count($incidencias) > 0) : ?>
                                                <?php foreach ($incidencias as $row) : ?>
                                                    <tr>
                                                        <td><a target="_new" href="<?= url("servicios/tablista?tablero=$row[tablero_id]&tarea=$row[tarea_id]") ?>"><?= $row['tarea'] ?></a></td>
                                                        <td style="text-align: center;"><?= $row['cliente'] ?></td>
                                                        <td style="text-align: center;"><?= $row['tablero'] ?></td>
                                                        <td style="text-align: center;"><?= $row['fecha'] ?></td>
                                                        <td style="text-align: center;"><span class="badge  <?= ($row['orden'] == 0 ? 'badge-light' : '') ?>  <?= ($row['orden'] == 1 ? 'badge-dark' : '') ?> <?= ($row['orden'] == 2 ? 'badge-secondary' : '') ?> <?= ($row['orden'] == 3 ? 'badge-primary' : '') ?>"><?= $row['estatus'] ?></span></td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="tab_historico" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_historico">
                                        <thead>
                                            <tr>
                                                <th style="width: 205px;">Tablero</th>
                                                <th style="width: 462px;">Descripción</th>
                                                <th style="width: 150px;">Empleado</th>
                                                <th style="width: 206px;">Fecha del Cambio</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="row in historico">
                                                <td><a :href="row.uri">{{ row.tablero }}</a></td>
                                                <td style="font-size: 12px; text-align: justify;">{{ row['descripcion'] }}</td>
                                                <td style="text-align: center;">{{ row['empleado'] }}</td>
                                                <td style="text-align: center;">{{ row['fecha'] }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="tab_vencimiento" role="tabpanel">
                        <div class="card">
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_vencimiento">
                                        <thead>
                                            <tr>
                                                <th>Titulo</th>
                                                <th>Tablero</th>
                                                <th>Creado</th>
                                                <th>Vencimiento</th>
                                                <th>Estatus</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="(row, index) in vencimientos">
                                                <td><a :href="'tablista/' + row.tablero_id">{{ row.tarea }}</a></td>
                                                <td style="text-align: center;">{{ row.tablero }}</td>
                                                <td style="text-align: center;">{{ fechaNormal(row.creado) }}</td>
                                                <td class="text-center">
                                                    <div>{{ relativeTime(row.vencimiento) }}</div>
                                                    <div><small>{{ row.vencimiento }}</small></div>
                                                </td>
                                                <td style="text-align: center;">
                                                    <span class="badge" :class="[row.orden == 0 ? 'badge-light' : '', row.orden == 1 ? 'badge-dark' : '', row.orden == 2 ? 'badge-secondary' : '', row.orden == 3 ? 'badge-primary' : '']">{{ row.estatus }}</span>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <form @submit.prevent="guardarTablero">
        <div class="modal fade" id="modalTablero">
            <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="nombre">Nuevo tablero</label>
                            <input type="text" class="form-control" id="nombre" v-model="dataFormTablero.nombre" maxlength="50">
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="content-colors selectgroup-pills">
                                    <label class="selectgroup-item text-center" v-for="row in colores">
                                        <input type="radio" name="icon-input" :value="row" class="selectgroup-input" v-model="selectedColor">
                                        <span class="selectgroup-button selectgroup-button-icon" :style="'background-color:' + row"><br></span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer border-0">
                        <button type="submit" class="btn btn-secondary btn-sm btn-block" id="btn_st" disabled>Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <form @submit.prevent="guardarPlantilla">
        <div class="modal fade" id="modalPlantilla">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header border-0">
                        <h5 class="modal-title">
                            <i class="fas fa-clipboard-list" style="font-size: 23px;"></i>
                            <span class="fw-mediumbold">
                                Nueva</span>
                            <span class="text-muted">
                                plantilla
                            </span>
                        </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group form-group-default">
                            <label for="categoria_plantilla">Categoria/Nombre</label>
                            <input type="text" class="form-control" id="categoria_plantilla">
                        </div>
                        <div class="form-group form-group-default">
                            <label for="item_plantilla">Descripción</label>
                            <textarea class="form-control" id="item_plantilla" placeholder="Descripción del item" rows="3" @keydown.prevent.enter="agregarItemPlantilla"></textarea>
                        </div>
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Items</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody id="items">
                                <tr v-for="(row, index) in item_plantilla" :key="row.descripcion">
                                    <td @click="editarItemPlantilla(index)">{{ row.descripcion }}</td>
                                    <td width="20%" class="text-center"><i class="fa fa-times text-danger" style="cursor: pointer;" @click="eliminarItemPlantilla(index)"></i></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer border-0">
                        <button type="submit" class="btn btn-secondary btn-sm btn-block" id="btn_pla">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <form @submit.prevent="editarPlantilla">
        <div class="modal fade" id="editModalPlantilla">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header border-0">
                        <h5 class="modal-title">
                            <i class="fas fa-clipboard-list" style="font-size: 23px;"></i>
                            <span class="fw-mediumbold">
                                Editar</span>
                            <span class="text-muted">
                                plantilla
                            </span>
                        </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group form-group-default">
                            <label for="edit_categoria_plantilla">Categoria/Nombre</label>
                            <input type="text" class="form-control" id="edit_categoria_plantilla">
                        </div>
                        <div class="form-group form-group-default">
                            <label for="edit_item_plantilla">Descripción</label>
                            <textarea class="form-control" id="edit_item_plantilla" placeholder="Descripción del item" rows="3" @keydown.prevent.enter="agregarItemPlantilla"></textarea>
                        </div>
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Items</th>
                                    <th></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody id="edit_items">
                                <tr v-for="(row, index) in item_plantilla" :key="row.descripcion">
                                    <td @click="editarItemPlantilla(index)">{{ row.descripcion }}</td>
                                    <td width="20%" class="text-center"><i class="fa fa-times text-danger" style="cursor: pointer;" @click="eliminarItemPlantilla(index)"></i></td>
                                    <td width="20%" class="text-center"><i class="fa fa-edit text-primary" style="cursor: pointer;" @click="editarItemPlant(index)"></i></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer border-0">
                        <button type="submit" class="btn btn-secondary btn-sm btn-block" id="edit_btn_pla">Guardar cambios</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <?php include 'modal_buscar_empleados.php' ?>
</div>
<script src="<?= asset('assets/moment.min.js') ?>"></script>
<script src="<?= asset('assets/underscore-min.js') ?>"></script>
<script src="<?= asset('assets/js/plugin/sortable/sortable.min.js') ?>"></script>
<script src="<?= asset('assetsvuejs/proyectos/tableros.js') ?>"></script>