<?php

namespace App\Modelos;

use Core\Database;

class TablerosListasTareasMiembros extends Database
{
    protected $table    = 'app_tableros_listas_tareas_miembros';
    protected $id       = 'miemb_id';

    public function obtenerMiembros(int $id_tar)
    {
        return $this->consultar("SELECT miemb_id, emp_id, einfo_id, einfo_nombres, einfo_apellidos
        FROM app_tableros_listas_tareas_miembros miemb
        JOIN app_empleados_info aei ON aei.einfo_id = miemb.miemb_empid_miembro         
        JOIN app_empleados e ON aei.einfo_id = e.emp_edatosid
        WHERE miemb_tarid = $id_tar
        ORDER BY einfo_nombres")->all();
    }

    public function chequearMiembro(int $tab_id,  int $einfo_id)
    {
        return $this->consultar("SELECT *
        FROM app_tableros tab
        JOIN app_tableros_listas list ON list.tablist_tabid = tab.tab_id 
        JOIN app_tableros_listas_tareas tar ON tar.tar_listid = list.tablist_id 
        JOIN app_tableros_listas_tareas_miembros m ON m.miemb_tarid = tar.tar_id 
        WHERE m.miemb_empid_miembro = $einfo_id AND tab.tab_id = $tab_id")->row();
    }


    public function chequearMiembroTarea(int $tar_id,  int $einfo_id)
    {
        return $this->consultar("SELECT *        
        FROM app_tableros_listas_tareas tar 
        JOIN app_tableros_listas_tareas_miembros m ON m.miemb_tarid = tar.tar_id 
        WHERE m.miemb_empid_miembro = $einfo_id AND tar.tar_id = $tar_id")->row();
    }
}
