<?php

namespace App\Modelos;

use Core\Database;

class TablerosCategorias extends Database
{
    protected $table    = 'app_tableros_categorias';
    protected $id       = 'cat_id';

    public function obtenerPlantillas()
    {
        $this->consultar("SET lc_time_names = 'es_ES'")->run();
        return $this->consultar("SELECT cat_id, cat_nombre, cat_empid, DATE_FORMAT(cat_actualizado, '%W %d | %h-%i') as modificacion, einfo_nombres, einfo_apellidos
        FROM app_tableros_categorias 
        JOIN app_empleados_info ON einfo_id = cat_empid
        ORDER BY cat_nombre")->all();
    }
}
