<?php

namespace App\Controladores;

use App\Modelos\BitacoraMensajesModel;
use App\Modelos\Cliente;
use App\Modelos\ClienteContactos;
use App\Modelos\Clientedireccionenvios;
use App\Modelos\Facturacion;
use App\Modelos\Tableros;
use App\Modelos\TablerosCategorias;
use App\Modelos\TablerosCategoriasPlantillas;
use App\Modelos\TablerosGrupos;
use App\Modelos\TablerosHistoricos;
use App\Modelos\TablerosListas;
use App\Modelos\TablerosListasTareas;
use App\Modelos\TablerosListasTareasArchivos;
use App\Modelos\TablerosListasTareasCheckList;
use App\Modelos\TablerosListasTareasCheckListItem;
use App\Modelos\TablerosListasTareasComentarios;
use App\Modelos\TablerosListasTareasEnlaces;
use App\Modelos\TablerosListasTareasMiembros;
use Core\Controller;
use Core\Librerias\CarritoVentasEditar;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Librerias\SMS;
use Core\Vista;
use Exception;
use PHPMailer\PHPMailer\PHPMailer;
use Verot\Upload\Upload;

final class ServiciosControlador extends Controller
{
    private $array_errors = [];
    private $tableros;
    private $module;
    private $newTabHis;

    public function __construct()
    {
        parent::__construct();
        $this->module = new Module('servicios');
        $this->tableros = new Tableros();
        $this->newTabHis = new TablerosHistoricos();
    }

    public function obtenerHistorico()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $new_miembros = new TablerosListasTareasMiembros();
            $new_grupos = new TablerosGrupos();

            $historico = $this->newTabHis->obtenerHistorico();
            $lista = [];

            if (is_countable($historico) && count($historico)) {
                foreach ($historico as $row) {
                    $miembro = $new_miembros->chequearMiembro($row['tabhis_tabid'], $_SESSION['user_data']['einfo_id']);
                    $administrador = $new_grupos->chequearAdministrador($row['tabhis_tabid'], $_SESSION['user_data']['emp_id']);
                    if ($miembro || $administrador) {
                        $lista[] = [
                            'id'            => $row['tabhis_id'],
                            'tablero_id'    => $row['tabhis_tabid'],
                            'tablero'       => $row['tab_nombre'],
                            'descripcion'   => $row['tabhis_descripcion'],
                            'fecha'         => date('d/m/Y h:i A', strtotime($row['tabhis_fecha'])),
                            'empleado'      => $row['einfo_nombres'] . ' ' . $row['einfo_apellidos'],
                            'uri'           => ruta_base() .  'servicios/tablista?tablero=' . $row['tabhis_tabid']
                        ];
                    }
                }
            }

            Http::json_response($lista);
        }
    }

    public function index()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {

            $new_miembros = new TablerosListasTareasMiembros();
            $new_grupos = new TablerosGrupos();

            $incidencias = $this->tableros->obtenerIncidencias();
            $list_incidencias = [];

            if (is_countable($incidencias) && count($incidencias)) {
                foreach ($incidencias as $row) {
                    $miembro = $new_miembros->chequearMiembro($row['tab_id'], $_SESSION['user_data']['einfo_id']);
                    $administrador = $new_grupos->chequearAdministrador($row['tab_id'], $_SESSION['user_data']['emp_id']);
                    if ($miembro || $administrador) {
                        $list_incidencias[] = [
                            'tablero_id' => $row['tab_id'],
                            'tablero' => $row['tab_nombre'],
                            'estatus' => $row['tablist_nombre'],
                            'fecha' => $row['fecha'],
                            'tarea_id' => $row['tar_id'],
                            'tarea' => $row['tar_nombre'],
                            'orden' => $row['tablist_orden'],
                            'cliente' => $row['cli_razon_social'],
                        ];
                    }
                }
            }

            return Vista::view('servicios/index', ['incidencias' => $list_incidencias]);
        }
    }

    public function obtenerHistoricoTablero(int $id_tablero)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $list_historico = [];

            if (!empty($id_tablero)) {

                $id_tablero = $this->solicitud->sanitize($id_tablero, FILTER_SANITIZE_NUMBER_INT);

                $fechas = $this->newTabHis->fechasHistoricosTablero($id_tablero);

                if (is_countable($fechas) && count($fechas)) {

                    foreach ($fechas as $fecha) {

                        $list_actividades = [];

                        $historico = $this->newTabHis->obtenerHistoricoTablero($id_tablero, $fecha['fecha']);

                        foreach ($historico as $row) {
                            $list_actividades[] = [
                                'id'            => $row['tabhis_id'],
                                'tablero_id'    => $row['tabhis_tabid'],
                                'tablero'       => $row['tab_nombre'],
                                'descripcion'   => $row['tabhis_descripcion'],
                                'fecha'         => $row['tabhis_fecha'],
                                'emp_nombre'    => $row['einfo_nombres'],
                                'emp_apellido'  => $row['einfo_apellidos']
                            ];
                        }

                        $list_historico[] = [
                            'fecha' => $fecha['tiempo'],
                            'actividades' => $list_actividades
                        ];
                    }
                }
            }

            Http::json_response($list_historico);
        }
    }

    public function obtenerVencimientos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $new_miembros = new TablerosListasTareasMiembros();

            $vencimientos = $this->tableros->obtenerVencimientos();

            $new_grupos = new TablerosGrupos();

            $list_vencimiento = [];

            if (is_countable($vencimientos) && count($vencimientos)) {
                foreach ($vencimientos as $row) {
                    $miembro =  $new_miembros->chequearMiembro($row['tab_id'], $_SESSION['user_data']['einfo_id']);
                    $administrador = $new_grupos->chequearAdministrador($row['tab_id'], $_SESSION['user_data']['emp_id']);
                    if ($miembro ||  $administrador) {
                        $list_vencimiento[] = [
                            'tablero_id' => $row['tab_id'],
                            'tablero' => $row['tab_nombre'],
                            'estatus' => $row['tablist_nombre'],
                            'creado' => $row['tar_creado'],
                            'actualizado' => $row['tar_actualizado'],
                            'tarea' => $row['tar_nombre'],
                            'orden' => $row['tablist_orden'],
                            'vencimiento' => $row['tar_fecha_vencimiento']
                        ];
                    }
                }
            }

            header('Content-Type: application/json');
            echo json_encode($list_vencimiento);
            exit();
        }
    }

    public function obtenerTableros()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $list_tableros = [];
            $tableros = $this->tableros->obtenerTableros();
            $new_grupos =  new TablerosGrupos();

            $new_miembros = new TablerosListasTareasMiembros();

            if (is_countable($tableros) && count($tableros)) {

                $new_grupos = new TablerosGrupos();

                foreach ($tableros as $row) {

                    $miembro =  $new_miembros->chequearMiembro($row['tab_id'], $_SESSION['user_data']['einfo_id']);
                    $administrador = $new_grupos->chequearAdministrador($row['tab_id'], $_SESSION['user_data']['emp_id']);

                    if ($miembro || $administrador) {

                        $grupos = $new_grupos->obtenerGrupo($row['tab_id']);

                        $list_tableros[] = [
                            'id' => $row['tab_id'],
                            'nombre' => ucwords($row['tab_nombre']),
                            'empleado' => $row['tab_empid'],
                            'color' => $row['tab_color'],
                            'modificacion' => ucfirst($row['modificacion']),
                            'uri' => ruta_base() . 'servicios/tablista?tablero=' . $row['tab_id'],
                            'favorito' => $row['tab_favorite'] ? true : false,
                            'grupos' => $grupos ?? []
                        ];
                    }
                }
            }

            header('Content-Type: application/json');
            echo json_encode($list_tableros);
            exit();
        }
    }

    public function obtenerFactNota(int $id_tarea)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($id_tarea)) {

                $tarea = $this->solicitud->sanitize($id_tarea, FILTER_SANITIZE_NUMBER_INT);

                $newTarea = new TablerosListasTareas();
                $listaFactNota = $newTarea->rutaDocumento($tarea);

                $lista_fn = [];

                if (is_countable($listaFactNota) && count($listaFactNota)) {
                    foreach ($listaFactNota as $row) {

                        if ($row['rd_docid_conversion'] == 2) {
                            $url = ruta_base() . 'poseditar/verFactura/' . $row['rd_facid_conversion'];
                        } else {
                            $url = ruta_base() . 'notasdeentregaeditar/verFactura/' . $row['rd_facid_conversion'];
                        }

                        $lista_fn[] = [
                            'id'   => $row['rd_facid_conversion'],
                            'tipo' => $row['doc_prefijo'],
                            'url'  => $url
                        ];
                    }
                }

                header('Content-Type: application/json');
                echo json_encode($lista_fn);
                exit();
            }
        }
    }

    public function guardarTablero()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('servicios', 'crear', $_SESSION['user_data']['emp_id'])) {

                $data = json_decode(file_get_contents('php://input'), true);

                if (!empty($data['nombre'])) {

                    if (empty($data['color'])) {
                        $data['color'] = '#1abc9c';
                    }

                    $tar_nombre = $this->solicitud->sanitize($data['nombre'], FILTER_SANITIZE_STRING);
                    $tar_color = $this->solicitud->sanitize($data['color'], FILTER_SANITIZE_STRING);

                    $tab_list = new TablerosListas();

                    $tab_id = $this->tableros->guardar([
                        'tab_nombre' => $tar_nombre,
                        'tab_color' => $tar_color,
                        'tab_empid' => $_SESSION['user_data']['einfo_id'],
                    ]);

                    if ($tab_id) {

                        $tab_list->guardar([
                            'tablist_tabid'     => $tab_id,
                            'tablist_nombre'    => 'Nuevo',
                            'tablist_empid'     => $_SESSION['user_data']['einfo_id'],
                            'tablist_orden'     => 0
                        ]);

                        $tab_list->guardar([
                            'tablist_tabid'     => $tab_id,
                            'tablist_nombre'    => 'Pendiente',
                            'tablist_empid'     => $_SESSION['user_data']['einfo_id'],
                            'tablist_orden'     => 1
                        ]);

                        $tab_list->guardar([
                            'tablist_tabid'     => $tab_id,
                            'tablist_nombre'    => 'En proceso',
                            'tablist_empid'     => $_SESSION['user_data']['einfo_id'],
                            'tablist_orden'     => 2
                        ]);

                        $tab_list->guardar([
                            'tablist_tabid'     => $tab_id,
                            'tablist_nombre'    => 'Terminado',
                            'tablist_empid'     => $_SESSION['user_data']['einfo_id'],
                            'tablist_orden'     => 3
                        ]);

                        $this->newTabHis->guardar([
                            'tabhis_tabid' => $tab_id,
                            'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                            'tabhis_descripcion' => "Ha creado tablero <strong>$tar_nombre</strong>"
                        ]);

                        $uri = ruta_base() . 'servicios/tablista/?tablero=' . $tab_id;

                        header('Content-Type: application/json');
                        echo json_encode($uri);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    $this->array_errors[] = 'Los campo nombre es obligatorio.';
                }

                header('Content-Type: application/json');
                echo json_encode(['errors' => $this->array_errors]);
                exit();
            } else {
                header('Content-Type: application/json');
                echo json_encode(['errors' => ['No posee permisos para crear tableros']]);
                exit();
            }
        }
    }

    public function tablista()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {

            if (!empty($_GET['tablero'])) {

                $tab_id = $this->solicitud->sanitize($_GET['tablero'], FILTER_SANITIZE_NUMBER_INT);

                $tar_id = null;
                $modalpres = 0;

                if (!empty($_GET['tarea'])) {
                    $tar_id = $this->solicitud->sanitize($_GET['tarea'], FILTER_SANITIZE_NUMBER_INT);
                }

                if (isset($_GET['modalpres'])) {
                    $modalpres = $this->solicitud->sanitize($_GET['modalpres'], FILTER_SANITIZE_NUMBER_INT);
                }

                $new_plantillas = new TablerosCategorias();

                $plantillas = $new_plantillas->obtenerPlantillas();

                $tablero = $this->tableros->obtener($tab_id);

                $factu = new Facturacion();

                return Vista::view('servicios/listas', [
                    'id' => $tablero['tab_id'],
                    'nombre' => ucfirst($tablero['tab_nombre']),
                    'favorite' => $tablero['tab_favorite'],
                    'color' => $tablero['tab_color'],
                    'plantillas' => $plantillas,
                    'tarea' => $tar_id,
                    'modalpres' => $modalpres,
                    'tipos_de_documentos' => $factu->obtenerTiposdeDocumentos(),
                ]);
            } else {
                header('Location: ' . ruta_base() . 'servicios');
            }
        }
    }

    public function guardarCliente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newCliContacto = new ClienteContactos();
            $cliente_direccion_envio_model = new Clientedireccionenvios();
            $cliente_model = new Cliente();

            $cli_tipodoc    = $this->solicitud->sanitize($_POST['cli_tipodoc'], FILTER_SANITIZE_NUMBER_INT);
            $cli_dni        = $this->solicitud->sanitize($_POST['cli_dni'], FILTER_SANITIZE_STRING);
            $razon_social   = $this->solicitud->sanitize($_POST['cli_razon_social'], FILTER_SANITIZE_STRING);
            $cli_telefono   = $this->solicitud->sanitize($_POST['cli_telefono'], FILTER_SANITIZE_STRING);
            $cli_direccion  = $this->solicitud->sanitize($_POST['cli_direccion'], FILTER_SANITIZE_STRING);
            $cli_natural    = ('true' == $this->solicitud->sanitize($_POST['cli_natural'])) ? 1 : 0;
           
            if (empty($cli_tipodoc))
                $this->array_errors[] = "El campo cedula de identidad es obligatorio.";
            if (empty($cli_dni))
                $this->array_errors[] = "El campo Tipo de documento es obligatorio.";
            if (empty($razon_social))
                $this->array_errors[] = "El campo Razón social es obligatorio.";
            if (empty($cli_telefono))
                $this->array_errors[] = "El campo Telefono es obligatorio.";
            if (empty($cli_direccion))
                $this->array_errors[] = "El campo Direccion es obligatorio.";

            if (empty($this->array_errors)) {

                if (empty($_POST['cli_email'])) {
                    $cli_email = NULL;
                } else {
                    $cli_email = filter_input(INPUT_POST, 'cli_email', FILTER_VALIDATE_EMAIL);
                    if (!$cli_email)
                        $this->array_errors[] = 'Correo invalido';
                    if ($cliente_model->existe('cli_email', $cli_email))
                        $this->array_errors[] = "El correo electronico $cli_email ya se encuentra en uso";
                }

                if (empty($cli_telefono)) {
                    $cli_telefono = NULL;
                } else {
                    if (strlen($cli_telefono) < 15 || strlen($cli_telefono) > 50)
                        $this->array_errors[] = 'El número de telefono es incorrecto';
                }

                if ($cliente_model->existe('cli_dni', $cli_dni))
                    $this->array_errors[] = "La cedula de identidad $cli_dni ya se encuentra en uso";

                //if (valida_email($cli_email) == false)
                //array_push($this->array_errors, "La correo $cli_email no es correcto");
                if (empty($this->array_errors) && empty($this->array_errors)) {
                    $data_id = $cliente_model->guardar([
                        'cli_tipodocid'     => $cli_tipodoc,
                        'cli_dni'           => $cli_dni,
                        'cli_razon_social'  => $razon_social,
                        'cli_email'         => $cli_email,
                        'cli_telefono'      => $cli_telefono,
                        'cli_direccion'     => $cli_direccion,
                        'cli_contribuyente' => 1,
                        'cli_fecha_reg'     => date('Y-m-d H:i:s'),
                        'cli_natural'       => $cli_natural
                    ]);
                    if ($data_id) {

                        $newCliContacto->guardar([
                            'ccon_cliid'    => $data_id,
                            'ccon_nombre'   => $razon_social,
                            'ccon_cargo'    => 'Personal',
                            'ccon_telefono' => $cli_telefono,
                            'ccon_email'    => $cli_email,
                        ], true);

                        $cliente_direccion_envio_model->guardar([
                            'cde_cliid'     => $data_id,
                            'cde_direccion' => $cli_direccion
                        ]);

                        Http::json_response([
                            'estatus' => true,
                            'id' => $data_id
                        ]);
                    } else {
                        Http::json_response(false);
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerTabListas(int $tab_id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax() && !empty($tab_id)) {
            $tab_id = filter_var($tab_id, FILTER_SANITIZE_NUMBER_INT);
            if ($this->tableros->existe('tab_id', $tab_id)) {

                $tab_list       = new TablerosListas();
                $tab_list_tarea = new TablerosListasTareas();

                $list_tableros = [];

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($tab_id, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = 0;
                    }
                }

                $new_miembro = new TablerosListasTareasMiembros();
                $newCometarios = new TablerosListasTareasComentarios();

                $tableros = $tab_list->obtenerListas($tab_id);

                if (is_countable($tableros) && count($tableros)) {

                    foreach ($tableros as $row) {

                        $list_tareas = [];

                        $tareas = $tab_list_tarea->obtenerTareas($row['tablist_id']);

                        if (is_countable($tareas) && count($tareas)) {

                            foreach ($tareas as $tar) {

                                $cliente = $tab_list_tarea->obtenerCliente($tar['tar_id']);
                                $cliente_data = [];

                                if ($cliente) {
                                    $cliente_data = [
                                        'id' => $cliente['cli_id'],
                                        'dni' => $cliente['cli_dni'],
                                        'nombre' => ucwords(strtolower($cliente['cli_razon_social']))
                                    ];
                                }

                                $total_comentarios = $newCometarios->cantidadDeComentarios($tar['tar_id']);

                                $permiso = $new_miembro->chequearMiembroTarea($tar['tar_id'], $_SESSION['user_data']['einfo_id']);

                                if ($permiso || $_SESSION['user_data']['einfo_id'] == 1 || $_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                                    $total = 0;
                                    $total_listos = 0;
                                    $items = $tab_list_tarea->obtenerTotalesItem($tar['tar_id']);

                                    if (count($items) > 0) {
                                        foreach ($items as $item) {
                                            $total += $item['total'];
                                            if ($item['item_estatus'] == 1) {
                                                $total_listos = $item['total'];
                                            }
                                        }
                                    }

                                    $list_tareas[] = [
                                        'id' => $tar['tar_id'],
                                        'nombre' => $tar['tar_nombre'],
                                        'orden' => $tar['tar_orden'],
                                        'descripcion' => $tar['tar_descripcion'],
                                        'fecha_ven' => $tar['tar_fecha_vencimiento'],
                                        'hora_ven' => $tar['tar_hora_vencimiento'],
                                        'recordatorio' => $tar['tar_recordatorio'],
                                        'check' => [
                                            'total' => $total,
                                            'listos' => $total_listos
                                        ],
                                        'total_comentarios' => $total_comentarios ?? 0,
                                        'cliente' => $cliente_data
                                    ];
                                }
                            }
                        }

                        $list_tableros[] = [
                            'id' => $row['tablist_id'],
                            'nombre' => $row['tablist_nombre'],
                            'orden' => $row['tablist_orden'],
                            'tareas' => $list_tareas
                        ];
                    }
                }


                header('Content-Type: application/json');
                echo json_encode($list_tableros);
                exit();
            }
        }
    }

    public function agregarLista()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $data = json_decode(file_get_contents('php://input'), true);

            if (!empty($data['id']) && !empty($data['nombre'])) {

                $tab_id = $this->solicitud->sanitize($data['id'], FILTER_SANITIZE_NUMBER_INT);

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($tab_id, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    $listas = new TablerosListas();

                    $tablist_nombre = $this->solicitud->sanitize($data['nombre'], FILTER_SANITIZE_STRING);

                    $id = $listas->guardar([
                        'tablist_tabid' => filter_var($data['id'], FILTER_SANITIZE_NUMBER_INT),
                        'tablist_nombre' => $tablist_nombre,
                        'tablist_orden' => filter_var($data['orden'], FILTER_SANITIZE_NUMBER_INT) ?? 0,
                        'tablist_empid' => $_SESSION['user_data']['einfo_id']
                    ]);

                    if ($id) {

                        $this->tableros->editar($data['id'], [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);

                        $this->newTabHis->guardar([
                            'tabhis_tabid' => $tab_id,
                            'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                            'tabhis_descripcion' => "Creada lista <strong>$tablist_nombre</strong>"
                        ]);

                        header('Content-Type: application/json');
                        echo json_encode($id);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }
        }
    }

    public function agregarTarea()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $data = json_decode(file_get_contents('php://input'), true);

            if (!empty($data['id_tab']) && !empty($data['id']) && !empty($data['nombre'])) {

                $id_lista = $this->solicitud->sanitize($data['id'], FILTER_SANITIZE_NUMBER_INT);
                $id_tablero = $this->solicitud->sanitize($data['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $nombre = $this->solicitud->sanitize($data['nombre'], FILTER_SANITIZE_STRING);

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    $tareas = new TablerosListasTareas();
                    $newLista = new TablerosListas();

                    $id = $tareas->guardar([
                        'tar_listid' => $id_lista,
                        'tar_nombre' => $nombre,
                        'tar_orden' => filter_var($data['orden'], FILTER_SANITIZE_NUMBER_INT) ?? 0,
                        'tar_empcreado' => $_SESSION['user_data']['einfo_nombres'] . ' ' . $_SESSION['user_data']['einfo_apellidos'],
                    ]);

                    if ($id) {

                        $newSMS = new SMS(constant('SMS_USER'), constant('SMS_PASSWORD'));

                        $newSMS->enviarMensaje('04245196793', 'nuevo soporte - ' . $nombre);

                        $newSMS->enviarMensaje('04126007107', 'nuevo soporte - ' . $nombre);

                        $data_lista = $newLista->obtener($id_lista);

                        $this->tableros->editar($id_tablero, [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);

                        $this->newTabHis->guardar([
                            'tabhis_tabid' => $id_tablero,
                            'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                            'tabhis_descripcion' => "Creada tarea <strong>$nombre</strong> en la lista {$data_lista['tablist_nombre']}"
                        ]);

                        header('Content-Type: application/json');
                        echo json_encode($id);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }
        }
    }

    public function editarTarea()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $data = json_decode(file_get_contents('php://input'), true);

            if (!empty($data['id_tab']) && !empty($data['tarea']) && !empty($data['nombre'])) {

                $id_tablero = $this->solicitud->sanitize($data['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $tarea = $this->solicitud->sanitize($data['tarea'], FILTER_SANITIZE_NUMBER_INT);
                $nombre = $this->solicitud->sanitize($data['nombre'], FILTER_SANITIZE_STRING);

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    $newTareas = new TablerosListasTareas();

                    $data_tarea = $newTareas->obtener($tarea);

                    if ($newTareas->editar($tarea, [
                        'tar_nombre' => $nombre
                    ])) {

                        $this->tableros->editar($id_tablero, [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);

                        $this->newTabHis->guardar([
                            'tabhis_tabid' => $id_tablero,
                            'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                            'tabhis_descripcion' => "Actualizado nombre de tarea <strong>{$data_tarea['tar_nombre']} a <strong>$nombre</strong>"
                        ]);

                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }
        }
    }
    public function eliminarTarea()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_GET['id_tab']) && !empty($_GET['id_tarea'])) {

                $id_tarea = $this->solicitud->sanitize($_GET['id_tarea'], FILTER_SANITIZE_NUMBER_INT);
                $id_tablero = $this->solicitud->sanitize($_GET['id_tab'], FILTER_SANITIZE_NUMBER_INT);

                $new_grupos = new TablerosGrupos();
                $newTareas = new TablerosListasTareas();

                $data_tarea = $newTareas->obtener($id_tarea);

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    $data_tarea = $newTareas->obtener($id_tarea);
                    $newLista = new TablerosListas();
                    $data_lista = $newLista->obtener($data_tarea['tar_listid']);

                    try {

                        $newTareas->transactionBegin();

                        $newTareas->eliminar($id_tarea);

                        $tareas = $newTareas->consultar("SELECT * FROM app_tableros_listas_tareas WHERE tar_listid = {$data_tarea['tar_listid']}")->all();

                        if (is_countable($tareas) && count($tareas)) {
                            $i = 0;
                            foreach ($tareas as $row) {
                                $newTareas->editar($row['tar_id'], [
                                    'tar_orden' => $i++
                                ]);
                            }
                        }

                        $newTareas->transactionCommit();
                    } catch (\Throwable $th) {
                        $newTareas->transactionRollBack();
                        $this->array_errors[] = 'Error de transaccion';
                    }

                    if (empty($this->array_errors)) {
                        $this->newTabHis->guardar([
                            'tabhis_tabid' => $id_tablero,
                            'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                            'tabhis_descripcion' => "Ha eliminado la tarea <strong>{$data_tarea['tar_nombre']} de la lista {$data_lista['tablist_nombre']}"
                        ]);
                        Http::json_response(true);
                    } else {
                        Http::json_response(false);
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }

            Http::json_response(false);
        }
    }

    public function generarDocumento()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $_POST = json_decode(file_get_contents('php://input'), true);

            if (!empty($_POST['id_tab']) && !empty($_POST['seleccion']) && !empty($_POST['cliente'])) {

                $id_tablero = $this->solicitud->sanitize($_POST['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $seleccion = $this->solicitud->sanitize($_POST['seleccion'], FILTER_SANITIZE_NUMBER_INT);
                $cliente = $this->solicitud->sanitize($_POST['cliente'], FILTER_SANITIZE_NUMBER_INT);

                if (empty($array_errors)) {


                    header('Content-Type: application/json');
                    echo json_encode(true);
                    exit();
                }

                header('Content-Type: application/json');
                echo json_encode(['errors' => $this->array_errors]);
                exit();
            } else {
                header('Content-Type: application/json');
                echo json_encode(['errors' => ['Debe seleccionar un documento']]);
                exit();
            }
        }
    }

    public function guardarEnlace()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $data = json_decode(file_get_contents('php://input'), true);

            if (!empty($data['id_tab']) && !empty($data['tarea']) && !empty($data['enlace'])) {

                $id_tablero = $this->solicitud->sanitize($data['id_tab'], FILTER_SANITIZE_STRING);
                $tarea = $this->solicitud->sanitize($data['tarea'], FILTER_SANITIZE_STRING);
                $enlace = $this->solicitud->sanitize($data['enlace'], FILTER_SANITIZE_STRING);
                $enlace_nombre = $this->solicitud->sanitize($data['enlace_nombre'], FILTER_SANITIZE_STRING);

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador && $_SESSION['user_data']['emp_id'] == 1) {
                    $administrador['grup_empid'] = 1;
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    $new_enlaces = new TablerosListasTareasEnlaces();

                    if ($new_enlaces->guardar([
                        'enl_tarid' => $tarea,
                        'enl_enlace' => $enlace,
                        'enl_enlace_nombre' => $enlace_nombre
                    ], true)) {

                        $this->tableros->editar($id_tablero, [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);

                        $newTareas = new TablerosListasTareas();

                        $data_tarea = $newTareas->obtener($tarea);

                        $this->newTabHis->guardar([
                            'tabhis_tabid' => $id_tablero,
                            'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                            'tabhis_descripcion' => "Ha agregado un nuevo enlace a la tarea <strong>{$data_tarea['tar_nombre']}</strong> <a href='$enlace'>$enlace_nombre</a>"
                        ]);

                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }
        }
    }

    public function subirArchivoTarea()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_POST['id_tab']) && !empty($_POST['tarea']) && !empty($_FILES['archivo'])) {

                $id_tablero = $this->solicitud->sanitize($_POST['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $tarea = $this->solicitud->sanitize($_POST['tarea'], FILTER_SANITIZE_NUMBER_INT);

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                $new_miembro = new TablerosListasTareasMiembros();

                $permiso = $new_miembro->chequearMiembro($id_tablero, $_SESSION['user_data']['einfo_id']);

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid'] || $permiso) {

                    $new_archivos = new TablerosListasTareasArchivos();

                    $fileTmpPath    = $_FILES['archivo']['tmp_name'];
                    $fileName       = $_FILES['archivo']['name'];
                    $fileSize       = $_FILES['archivo']['size'];
                    $extenciones    = ['jpg', 'jpeg', 'png', 'gif', 'pdf', 'zip', 'rar', 'doc', 'docx', 'odt', 'ods', 'csv', 'xlsx', 'xls'];

                    if ($_FILES['archivo']['error'] === UPLOAD_ERR_OK) {

                        $handle = new Upload($_FILES['archivo']);

                        $fileNameCmps = explode(".", basename($_FILES['archivo']['name']));
                        $fileExtension = strtolower(end($fileNameCmps));

                        if ($fileSize < 5048576) {

                            if (in_array($fileExtension, $extenciones)) {

                                if ($handle->uploaded) {

                                    $time  = time();
                                    $handle->file_new_name_body = $time;
                                    $file_img                   = $time . '.' . $handle->file_src_name_ext;

                                    $handle->process(constant('UPLOADS_URI') . 'adjuntosservicios');

                                    if ($handle->processed) {

                                        if ($new_archivos->guardar([
                                            'arch_tarid' => $tarea,
                                            'arch_archivo' => $file_img,
                                            'arch_nombre' => $_FILES['archivo']['name']
                                        ], true)) {

                                            $this->tableros->editar($id_tablero, [
                                                'tab_actualizado' => date('Y-m-d H:i:s')
                                            ]);

                                            $newTareas = new TablerosListasTareas();

                                            $data_tarea = $newTareas->obtener($tarea);

                                            $this->newTabHis->guardar([
                                                'tabhis_tabid' => $id_tablero,
                                                'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                                                'tabhis_descripcion' => "Añadido nuevo archivo adjunto a la tarea <strong>{$data_tarea['tar_nombre']}</strong> <a href='" . constant('IMG_URI') . "adjuntosservicios/$file_img' download='$file_img'>{$_FILES['archivo']['name']}</a>"
                                            ]);

                                            header('Content-Type: application/json');
                                            echo json_encode(true);
                                            exit();
                                        } else {
                                            header('Content-Type: application/json');
                                            echo json_encode(false);
                                            exit();
                                        }

                                        $handle->clean();
                                    } else {
                                        $this->array_errors[] = "Se produjo un error al subir el archivo";
                                    }
                                }
                            } else {
                                $this->array_errors[] = "Solo archivos con formato PNG, JPG, JPEG, GIF, ZIP, RAR, DOC, DOCX, ODT, CSV, XLS, XLSX, ODS";
                            }
                        } else {
                            $this->array_errors[] = "EL archivo supera el limite de 1MB";
                        }
                    } else {
                        $this->array_errors[] = 'Acceso prohibido no posee permisos para editar productos.';
                    }

                    header('Content-Type: application/json');
                    echo json_encode(['errors' => $this->array_errors]);
                    exit();
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    public function editarChecklist()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $data = json_decode(file_get_contents('php://input'), true);

            if (!empty($data['id_tab']) && !empty($data['checklist']) && !empty($data['nombre'])) {

                $id_tablero = $this->solicitud->sanitize($data['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $checklist = $this->solicitud->sanitize($data['checklist'], FILTER_SANITIZE_NUMBER_INT);
                $nombre = $this->solicitud->sanitize($data['nombre'], FILTER_SANITIZE_STRING);

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    $new_checklist = new TablerosListasTareasCheckList();

                    $data_checklist = $new_checklist->obtener($checklist);

                    if ($new_checklist->editar($checklist, [
                        'checklist_nombre' => $nombre
                    ])) {

                        $this->tableros->editar($id_tablero, [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);

                        $newTareas = new TablerosListasTareas();

                        $data_tarea = $newTareas->obtener($data_checklist['checklist_tarid']);

                        $this->newTabHis->guardar([
                            'tabhis_tabid' => $id_tablero,
                            'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                            'tabhis_descripcion' => "Ha actualizado el nombre de checklist <strong>{$data_checklist['checklist_nombre']}</strong> por <strong>$nombre</strong> de la tarea <strong>{$data_tarea['tar_nombre']}</strong>"
                        ]);

                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }
        }
    }

    public function eliminarLista(int $id_lista)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax() && !empty($id_lista)) {
            $id_lista = $this->solicitud->sanitize($id_lista, FILTER_SANITIZE_NUMBER_INT);
            $new_grupos = new TablerosGrupos();
            $new_listas = new TablerosListas();
            $data_lista = $new_listas->obtener($id_lista);
            $id_tablero = $data_lista['tablist_tabid'];
            $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);
            //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
            if (!$administrador) {
                if ($_SESSION['user_data']['emp_id'] == 1) {
                    $administrador['grup_empid'] = 1;
                } else {
                    $administrador['grup_empid'] = '';
                }
            }
            $new_miembro = new TablerosListasTareasMiembros();
            $permiso = $new_miembro->chequearMiembro($id_tablero, $_SESSION['user_data']['einfo_id']);
            if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid'] || $permiso) {


                if ($new_listas->eliminar($id_lista)) {

                    $this->tableros->editar($id_tablero, [
                        'tab_actualizado' => date('Y-m-d H:i:s')
                    ]);

                    $this->newTabHis->guardar([
                        'tabhis_tabid' => $id_tablero,
                        'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                        'tabhis_descripcion' => "Eliminada lista <strong>{$data_lista['tablist_nombre']}</strong>"
                    ]);

                    header('Content-Type: application/json');
                    echo json_encode(true);
                    exit();
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(false);
                    exit();
                }
            } else {
                header('Content-Type: application/json');
                echo json_encode(['errors' => ['No posee permisos de administrador']]);
                exit();
            }
        }
    }

    public function editarLista()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $data = json_decode(file_get_contents('php://input'), true);

            if (!empty($data['lista']) && !empty($data['nombre'])) {

                $lista = $this->solicitud->sanitize($data['lista'], FILTER_SANITIZE_NUMBER_INT);
                $nombre = $this->solicitud->sanitize($data['nombre'], FILTER_SANITIZE_STRING);

                $new_grupos = new TablerosGrupos();
                $new_listas = new TablerosListas();

                $data_lista = $new_listas->obtener($lista);
                $id_tablero = $data_lista['tablist_tabid'];

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    if ($new_listas->editar($lista, [
                        'tablist_nombre' => $nombre
                    ])) {

                        $this->tableros->editar($id_tablero, [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);

                        $this->newTabHis->guardar([
                            'tabhis_tabid' => $id_tablero,
                            'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                            'tabhis_descripcion' => "Editado el nombre de lista <strong>{$data_lista['tablist_nombre']}</strong> a $nombre"
                        ]);

                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }
        }
    }

    public function guardarPosicionListas()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $data = json_decode(file_get_contents('php://input'), true);

            if (!empty($data['id_tab']) && is_countable($data['listas']) && count($data['listas'])) {

                $tab_list = new TablerosListas();
                $new_grupos = new TablerosGrupos();

                $id_tablero = $this->solicitud->sanitize($data['id_tab']);

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    foreach ($data['listas'] as $row) {
                        $tab_list->editar($row['id'], [
                            'tablist_orden' => $row['orden']
                        ]);
                    }

                    $this->tableros->editar($id_tablero, [
                        'tab_actualizado' => date('Y-m-d H:i:s')
                    ]);

                    header('Content-Type: application/json');
                    echo json_encode(true);
                    exit();
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    public function guardarPosicionTareas()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $data = json_decode(file_get_contents('php://input'), true);

            if (!empty($data['id_tab']) && is_countable($data['tareas']) && count($data['tareas'])) {

                $id_tablero = $this->solicitud->sanitize($data['id_tab']);

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    $tab_list = new TablerosListasTareas();

                    foreach ($data['tareas'] as $row) {
                        $tab_list->editar($row['id'], [
                            'tar_orden' => $row['orden']
                        ]);
                    }

                    $this->tableros->editar($id_tablero, [
                        'tab_actualizado' => date('Y-m-d H:i:s')
                    ]);

                    header('Content-Type: application/json');
                    echo json_encode(true);
                    exit();
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    public function guardarMovimientoTareas()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $tarea = new TablerosListasTareas();

            $data = json_decode(file_get_contents('php://input'), true);

            if (!empty($data['id_tab']) && !empty($data['list_id']) && is_countable($data['tareas']) && count($data['tareas'])) {

                $id_tablero = $this->solicitud->sanitize($data['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $list_id = $this->solicitud->sanitize($data['list_id'], FILTER_SANITIZE_NUMBER_INT);
                $tarea_nuevo_estatus = [];

                foreach ($data['tareas'] as $row) {

                    $data_tarea = $tarea->consultar("SELECT tar_listid, tar_nombre, tar_cliente FROM app_tableros_listas_tareas WHERE tar_id = {$row['id']}")->row();

                    if ($data_tarea) {

                        if ($data_tarea['tar_listid'] != $list_id) {

                            $data_lista_from = $tarea->consultar("SELECT tablist_nombre FROM app_tableros_listas WHERE tablist_id = {$data_tarea['tar_listid']}")->row();
                            $data_lista_to = $tarea->consultar("SELECT tablist_nombre FROM app_tableros_listas WHERE tablist_id = $list_id")->row();

                            if ($this->newTabHis->guardar([
                                'tabhis_tabid' => $id_tablero,
                                'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                                'tabhis_descripcion' => "Ha movido la tarea <strong>{$data_tarea['tar_nombre']}</strong> de lista <strong>{$data_lista_from['tablist_nombre']}</strong> a <strong>{$data_lista_to['tablist_nombre']}</strong>"
                            ], true)) {
                                /*if (!is_null($data_tarea['tar_cliente'])) {
                                    $contacto = $tarea->consultar("SELECT ccon_id, ccon_nombre, ccon_telefono, ccon_email, cli_razon_social FROM app_clientes_contactos JOIN app_clientes ON ccon_cliid = cli_id WHERE ccon_cliid = {$data_tarea['tar_cliente']}")->row();
                                    $mensaje = $tarea->consultar("SELECT sms_tipo, sms_modulo, sms_titulo, sms_cuerpo FROM app_sms_cliente JOIN app_sms ON sms_id = cs_smsid WHERE cs_cconid = {$contacto['ccon_id']} AND sms_estatus = 1 AND sms_modulo = 2")->row();
                                    if ($contacto) {
                                        if (
                                            ($mensaje['sms_tipo'] == 1 && !is_null($contacto['ccon_telefono'])) ||
                                            ($mensaje['sms_tipo'] == 2 && !is_null($contacto['ccon_email']))
                                        ) {
                                            $tarea_nuevo_estatus = [
                                                'cliente'           => $contacto['cli_razon_social'],
                                                'contacto'          => $contacto['ccon_nombre'],
                                                'titulo'            => $mensaje['sms_titulo'],
                                                'cuerpo'            => $mensaje['sms_cuerpo'],
                                                'tipo'              => $mensaje['sms_tipo'],
                                                'telefono'          => $contacto['ccon_telefono'],
                                                'correo'            => $contacto['ccon_email'],
                                                'id_tarea'          => $id_tablero,
                                                'nombre_tarea'      => $data_tarea['tar_nombre'],
                                                'estatus_anterior'  => $data_lista_from['tablist_nombre'],
                                                'estatus_nuevo'     => $data_lista_to['tablist_nombre']
                                            ];
                                        }
                                    }
                                }*/
                            }
                        }

                        $tarea->editar($row['id'], [
                            'tar_listid' => $list_id,
                            'tar_orden' => $row['orden'],
                        ]);
                    }
                }

                $this->tableros->editar($id_tablero, [
                    'tab_actualizado' => date('Y-m-d H:i:s')
                ]);

                if ($tarea_nuevo_estatus) {
                    $this->enviarMensaje(
                        $tarea_nuevo_estatus['cliente'],
                        $tarea_nuevo_estatus['contacto'],
                        $tarea_nuevo_estatus['telefono'],
                        $tarea_nuevo_estatus['correo'],
                        $tarea_nuevo_estatus['titulo'],
                        $tarea_nuevo_estatus['cuerpo'],
                        $tarea_nuevo_estatus['tipo'],
                        $tarea_nuevo_estatus
                    );
                }

                header('Content-Type: application/json');
                echo json_encode(true);
                exit();
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    private function enviarMensaje(string $cliente, string $contacto, string $telefono, string $correo, string $titulo, string $cuerpo, int $tipo_de_mensaje, array $data)
    {
        $newBitacora = new BitacoraMensajesModel();

        //inicio de variables
        $servicio = $data['nombre_tarea'];
        $estatus_anterior = $data['estatus_anterior'];
        $estatus_nuevo = $data['estatus_nuevo'];
        //fin de variables

        if ($tipo_de_mensaje == 1) {

            $newSMS = new SMS(constant('SMS_USER'), constant('SMS_PASSWORD'));

            if ($newSMS->obtenerEstatus() != 'Activa')
                return false;

            if ($newSMS->obtenerCreditos() <= 0)
                return false;

            $cuerpo = str_ireplace('$servicio', $servicio, $cuerpo);
            $cuerpo = str_ireplace('$estatus_anterior', $estatus_anterior, $cuerpo);
            $cuerpo = str_ireplace('$estatus_nuevo', $estatus_nuevo, $cuerpo);

            $estatus = $newSMS->enviarMensaje($telefono, $cuerpo);

            switch ($estatus) {
                case '400':
                    $estatus_condicion = 'Falta Texto';
                    break;
                case '401':
                    $estatus_condicion = 'Autenticación Inválida';
                    break;
                case '402':
                    $estatus_condicion = 'Créditos Insuficientes';
                    break;
                case '403':
                    $estatus_condicion = 'Cuenta Inactiva';
                    break;
                case '405':
                    $estatus_condicion = 'Falta Destinatario';
                    break;
                case '501':
                    $estatus_condicion = 'Tipo de Cuenta Inválida';
                    break;
                case '502':
                    $estatus_condicion = 'Petición Sobrecargada';
                    break;
                default:
                    $estatus_condicion = $estatus;
            }

            $newBitacora->guardar([
                'bitmen_cliente'    => $cliente,
                'bitmen_contacto'   => $contacto,
                'bitmen_telefono'   => $telefono,
                'bitmen_correo'     => $correo,
                'bitmen_titulo'     => $titulo,
                'bitmen_cuerpo'     => $cuerpo,
                'bitmen_estatus'    => $estatus_condicion,
                'bitmen_tipo'       => 'SMS'
            ], true);
        } else {

            if (
                !trim(constant('EMP_CORREO')) ||
                !trim(constant('EMP_CORREO_PASSWORD')) ||
                !trim(constant('EMP_CORREO_HOST')) ||
                !trim(constant('EMP_CORREO_PORT'))
            )
                return false;

            $mail = new PHPMailer(true);
            $error = '';

            try {
                $mail->isSMTP();
                $mail->Host       = constant('EMP_CORREO_HOST');
                $mail->SMTPAuth   = true;
                $mail->Username   = constant('EMP_CORREO');
                $mail->Password   = constant('EMP_CORREO_PASSWORD');
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                $mail->Port       = constant('EMP_CORREO_PORT');

                $mail->setFrom($mail->Username);
                $mail->addAddress($correo);
                $mail->addReplyTo($mail->Username, constant('EMP_NOMBRE'));
                $mail->isHTML(true);

                $cuerpo = html_entity_decode($cuerpo);

                $cuerpo = str_ireplace('$servicio', $servicio, $cuerpo);
                $cuerpo = str_ireplace('$estatus_anterior', $estatus_anterior, $cuerpo);
                $cuerpo = str_ireplace('$estatus_nuevo', $estatus_nuevo, $cuerpo);

                $mail->Subject = utf8_decode($titulo);
                $mail->Body    = $cuerpo;

                $mail->send();
            } catch (Exception $e) {
                $error = "No se pudo enviar el mensaje. Error de envío: {$mail->ErrorInfo}.";
            }

            $data_envio = [
                'bitmen_cliente'    => $cliente,
                'bitmen_contacto'   => $contacto,
                'bitmen_telefono'   => $telefono,
                'bitmen_correo'     => $correo,
                'bitmen_titulo'     => $titulo,
                'bitmen_cuerpo'     => $cuerpo,
                'bitmen_tipo'       => 'SMS'
            ];

            if ($error == '') {
                $data_envio['bitmen_estatus'] = 'Enviado';
            } else {
                $data_envio['bitmen_estatus'] = $error;
            }

            $newBitacora->guardar($data_envio, true);
        }
    }

    public function obtenerChecklist(int $tar_id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax() && !empty($tar_id)) {
            $id = $this->solicitud->sanitize($tar_id, FILTER_SANITIZE_NUMBER_INT);
            $newListas = new TablerosListas();
            $newTarea = new TablerosListasTareas();
            $data_tarea = $newTarea->obtener($tar_id);
            $data_lista = $newListas->obtener($data_tarea['tar_listid']);
            $new_checklist = new TablerosListasTareasCheckList();
            $new_item = new TablerosListasTareasCheckListItem();
            $list_checklist = [];
            $checklist = $new_checklist->where(['checklist_tarid' => $id]);
            if (count($checklist) > 0) {

                foreach ($checklist as $row) {

                    $list_items = [];

                    $items = $new_item->where(['item_checklistid' => $row['checklist_id']]);

                    if (count($items) > 0) {
                        foreach ($items as $item) {
                            $list_items[] = [
                                'id' => $item['item_id'],
                                'descripcion' => $item['item_descripcion'],
                                'estatus' => $item['item_estatus'] ? true : false,
                                'orden'  => $item['item_orden'],
                                'creado' => $item['item_creado'],
                                'actualizado' => $item['item_actualizado'],
                            ];
                        }
                    }

                    $list_checklist[] = [
                        'id' => $row['checklist_id'],
                        'nombre' => $row['checklist_nombre'],
                        'orden' => $row['checklist_orden'],
                        'items' => $list_items
                    ];
                }
            }
            header('Content-Type: application/json');
            echo json_encode([
                'lista_id' => $data_lista['tablist_id'],
                'lista_nombre' => $data_lista['tablist_nombre'],
                'tarea_id' => $data_tarea['tar_id'],
                'tarea_nombre' => $data_tarea['tar_nombre'],
                'tarea_empcreado' => $data_tarea['tar_empcreado'],
                'tarea_descripcion' => $data_tarea['tar_descripcion'],
                'tarea_fecha_ven' => $data_tarea['tar_fecha_vencimiento'],
                'tarea_hora_ven' => $data_tarea['tar_hora_vencimiento'],
                'tarea_recordatorio' => $data_tarea['tar_recordatorio'],
                'checklist' => $list_checklist
            ]);
            exit();
        }
    }

    public function modificarDescripcionTarea()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $data = json_decode(file_get_contents('php://input'), true);

            if (!empty($data['id_tab']) && !empty($data['id']) && !empty($data['descripcion'])) {

                $id_tarea = $this->solicitud->sanitize($data['id'], FILTER_SANITIZE_NUMBER_INT);
                $descripcion = $this->solicitud->sanitize($data['descripcion'], FILTER_SANITIZE_STRING);

                $tarea = new TablerosListasTareas();

                $id_tablero = $this->solicitud->sanitize($data['id_tab'], FILTER_SANITIZE_NUMBER_INT);

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador && $_SESSION['user_data']['emp_id'] == 1) {
                    $administrador['grup_empid'] = 1;
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    $data_tarea = $tarea->obtener($id_tarea);

                    if ($tarea->editar($id_tarea, [
                        'tar_descripcion' => $descripcion,
                    ])) {

                        $this->tableros->editar($id_tablero, [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);

                        $this->newTabHis->guardar([
                            'tabhis_tabid' => $id_tablero,
                            'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                            'tabhis_descripcion' => "Actualizada descripcion de la tarea <strong>{$data_tarea['tar_nombre']}</strong>"
                        ]);

                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    public function obtenerItems(int $tar_id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($tar_id, FILTER_SANITIZE_NUMBER_INT);

            if (!empty($id)) {

                $item = new TablerosListasTareasCheckListItem();

                $list_item = [];

                $items = $item->where(['item_tarid' => $id]);

                if (count($items) > 0) {
                    foreach ($items as $row) {
                        $list_item[] = [
                            'id' => $row['item_id'],
                            'descripcion' => $row['item_descripcion'],
                            'estatus' => $row['item_estatus']  ? true : false,
                            'orden' => $row['item_orden']
                        ];
                    }
                }

                header('Content-Type: application/json');
                echo json_encode($list_item);
                exit();
            }
        }
    }

    public function agregarChecklist()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $data = json_decode(file_get_contents('php://input'), true);

            if (!empty($data['id_tab']) && !empty($data['nombre']) && !empty($data['tarea'])) {

                $id_tablero = $this->solicitud->sanitize($data['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $nombre = $this->solicitud->sanitize($data['nombre'], FILTER_SANITIZE_STRING);
                $orden = $this->solicitud->sanitize($data['orden'], FILTER_SANITIZE_NUMBER_INT);
                $tarea = $this->solicitud->sanitize($data['tarea'], FILTER_SANITIZE_NUMBER_INT);

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                $new_miembro = new TablerosListasTareasMiembros();

                $permiso = $new_miembro->chequearMiembro($id_tablero, $_SESSION['user_data']['einfo_id']);

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid'] || $permiso) {

                    $new_checklist = new TablerosListasTareasCheckList();

                    $id = $new_checklist->guardar([
                        'checklist_tarid' => $tarea,
                        'checklist_nombre' => $nombre,
                        'checklist_orden' => $orden,
                        'checklist_empid' => $_SESSION['user_data']['einfo_id']
                    ]);

                    if ($id) {

                        $newTareas = new TablerosListasTareas();
                        $data_tarea = $newTareas->obtener($tarea);

                        $this->tableros->editar($id_tablero, [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);

                        $this->newTabHis->guardar([
                            'tabhis_tabid' => $id_tablero,
                            'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                            'tabhis_descripcion' => "Añadido checklist <strong>$nombre</strong> a la tarea <strong>{$data_tarea['tar_nombre']}<strong>"
                        ]);

                        header('Content-Type: application/json');
                        echo json_encode($id);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    public function agregarPlantilla()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $data = json_decode(file_get_contents('php://input'), true);

            if (!empty($data['tarea']) && !empty($data['plantilla'])) {

                $id_tablero = $this->solicitud->sanitize($data['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $plantilla = $this->solicitud->sanitize($data['plantilla'], FILTER_SANITIZE_NUMBER_INT);
                $tarea = $this->solicitud->sanitize($data['tarea'], FILTER_SANITIZE_NUMBER_INT);
                $cate = $this->solicitud->sanitize($data['nombre'], FILTER_SANITIZE_NUMBER_INT);
                $orden = $this->solicitud->sanitize($data['orden']) ?? 0;

                $new_tarea = new TablerosListasTareas();

                $lista = $new_tarea->obtener($tarea);

                $new_lista = new TablerosListas();

                $_tablero = $new_lista->obtener($lista['tar_listid']);

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($_tablero['tablist_tabid'], $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    $new_plantilla = new TablerosCategoriasPlantillas();
                    $new_pcate = new TablerosCategorias();
                    $plantillas = $new_plantilla->obtenerPlantillas($plantilla);

                    if (count($plantillas) > 0) {
                        $new_checklist = new TablerosListasTareasCheckList();
                        $newTareas = new TablerosListasTareas();
                        $nombre = $new_pcate->obtener($cate);
                        $id_checklist = $new_checklist->guardar([
                            'checklist_tarid' => $tarea,
                            'checklist_nombre' => $nombre['cat_nombre'],
                            'checklist_orden' => $orden,
                            'checklist_empid' => $_SESSION['user_data']['einfo_id']
                        ]);

                        if ($id_checklist) {

                            $this->tableros->editar($_tablero['tablist_tabid'], [
                                'tab_actualizado' => date('Y-m-d H:i:s')
                            ]);

                            $data_tarea = $newTareas->obtener($tarea);

                            $this->newTabHis->guardar([
                                'tabhis_tabid' => $id_tablero,
                                'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                                'tabhis_descripcion' => "Añadida nueva plantilla a la tarea <strong>{$data_tarea['tar_nombre']}</strong>"
                            ]);

                            $plantillas = $new_plantilla->obtenerPlantillas($plantilla);

                            $new_item = new TablerosListasTareasCheckListItem();

                            foreach ($plantillas as $row) {
                                $new_item->guardar([
                                    'item_checklistid' => $id_checklist,
                                    'item_descripcion' => $row['pla_descripcion'],
                                    'item_orden' => $row['pla_orden'],
                                    'item_empid' => $_SESSION['user_data']['einfo_id']
                                ]);
                            }

                            $id = $tarea;

                            $new_checklist = new TablerosListasTareasCheckList();
                            $new_item = new TablerosListasTareasCheckListItem();

                            $list_checklist = [];

                            $checklist = $new_checklist->where(['checklist_tarid' => $id]);

                            if (count($checklist) > 0) {

                                foreach ($checklist as $row) {

                                    $list_items = [];

                                    $items = $new_item->where(['item_checklistid' => $row['checklist_id']]);

                                    if (count($items) > 0) {
                                        foreach ($items as $item) {
                                            $list_items[] = [
                                                'id' => $item['item_id'],
                                                'descripcion' => $item['item_descripcion'],
                                                'estatus' => $item['item_estatus'] ? true : false,
                                                'orden'  => $item['item_orden'],
                                            ];
                                        }
                                    }

                                    $list_checklist[] = [
                                        'id' => $row['checklist_id'],
                                        'nombre' => $row['checklist_nombre'],
                                        'orden' => $row['checklist_orden'],
                                        'items' => $list_items
                                    ];
                                }
                            }

                            header('Content-Type: application/json');
                            echo json_encode($list_checklist);
                            exit();
                        }
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    public function eliminarChecklist()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_GET['id_tab']) && !empty($_GET['checklist_id'])) {

                $new_checklist = new TablerosListasTareasCheckList();
                $new_grupos = new TablerosGrupos();

                $id_tablero = $this->solicitud->sanitize($_GET['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $checklist_id = $this->solicitud->sanitize($_GET['checklist_id'], FILTER_SANITIZE_NUMBER_INT);

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    $data_checklist = $new_checklist->obtener($checklist_id);

                    if ($new_checklist->eliminar($checklist_id)) {

                        $newTareas = new TablerosListasTareas();
                        $data_tarea = $newTareas->obtener($data_checklist['checklist_tarid']);

                        $this->tableros->editar($id_tablero, [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);

                        $this->newTabHis->guardar([
                            'tabhis_tabid' => $id_tablero,
                            'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                            'tabhis_descripcion' => "Eliminado checklist de la tarea <strong>{$data_tarea['tar_nombre']}</strong>"
                        ]);

                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    public function agregarItem()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $data = json_decode(file_get_contents('php://input'), true);

            if (!empty($data['id_tab']) && !empty($data['checklist_id']) && !empty($data['item']) && (is_countable($data['item']) && count($data['item']))) {
                $item = new TablerosListasTareasCheckListItem();
                $new_grupos = new TablerosGrupos();
                $id_tablero = $this->solicitud->sanitize($data['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $item_checklistid = $this->solicitud->sanitize($data['checklist_id'], FILTER_SANITIZE_NUMBER_INT);
                $item_id = $this->solicitud->sanitize($data['item']['id'], FILTER_SANITIZE_NUMBER_INT);
                $item_descripcion = $this->solicitud->sanitize($data['item']['descripcion'], FILTER_SANITIZE_STRING);
                $item_estatus = ('true' == $this->solicitud->sanitize($data['item']['estatus'])) ? 1 : 0;
                $item_orden = $this->solicitud->sanitize($data['item']['orden'], FILTER_SANITIZE_NUMBER_INT);
                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);
                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }
                $new_miembro = new TablerosListasTareasMiembros();
                $permiso = $new_miembro->chequearMiembro($id_tablero, $_SESSION['user_data']['einfo_id']);
                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid'] || $permiso) {

                    if (empty($item_id)) {

                        $id = $item->guardar([
                            'item_checklistid' => $item_checklistid,
                            'item_descripcion' => $item_descripcion,
                            'item_estatus' => $item_estatus,
                            'item_orden' => $item_orden,
                            'item_empid' => $_SESSION['user_data']['einfo_id']
                        ]);

                        if ($id) {

                            $newChecklist = new TablerosListasTareasCheckList();
                            $newTareas = new TablerosListasTareas();

                            $data_checklist = $newChecklist->obtener($item_checklistid);
                            $data_tarea = $newTareas->obtener($data_checklist['checklist_tarid']);

                            $this->tableros->editar($id_tablero, [
                                'tab_actualizado' => date('Y-m-d H:i:s')
                            ]);

                            $data_item = $item->obtener($id);

                            $this->newTabHis->guardar([
                                'tabhis_tabid' => $id_tablero,
                                'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                                'tabhis_descripcion' => "Ha agregado el nuevo item <strong>{$data_item['item_descripcion']}</strong> al checklist <strong>{$data_checklist['checklist_nombre']} de la tarea <strong>{$data_tarea['tar_nombre']}</strong>"
                            ]);

                            header('Content-Type: application/json');
                            echo json_encode([
                                'id' => $data_item['item_id'],
                                'descripcion' => $data_item['item_descripcion'],
                                'estatus' => $data_item['item_estatus'],
                                'orden' => $data_item['item_orden'],
                                'creado' => $data_item['item_creado'],
                                'actualizado' => $data_item['item_actualizado'],
                            ]);
                            exit();
                        } else {
                            header('Content-Type: application/json');
                            echo json_encode(false);
                            exit();
                        }
                    } else {

                        if ($item->editar($item_id, [
                            'item_descripcion' => $item_descripcion,
                            'item_estatus' => $item_estatus,
                            'item_orden' => $item_orden,
                            'item_empid' => $_SESSION['user_data']['einfo_id']
                        ])) {

                            $data_item = $item->obtener($item_id);

                            header('Content-Type: application/json');
                            echo json_encode([
                                'id' => $data_item['item_id'],
                                'descripcion' => $data_item['item_descripcion'],
                                'estatus' => $data_item['item_estatus'],
                                'orden' => $data_item['item_orden'],
                                'creado' => $data_item['item_creado'],
                                'actualizado' => $data_item['item_actualizado'],
                            ]);
                            exit();
                        } else {
                            header('Content-Type: application/json');
                            echo json_encode(false);
                            exit();
                        }
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    public function modificarEstatusItem()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $data = json_decode(file_get_contents('php://input'), true);

            if (!empty($data['id_tab']) && !empty($data['id'])) {

                $item = new TablerosListasTareasCheckListItem();

                $id_tablero = $this->solicitud->sanitize($data['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $id = $this->solicitud->sanitize($data['id'], FILTER_SANITIZE_NUMBER_INT);
                $estatus = $this->solicitud->sanitize($data['estatus']);

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = 0;
                    }
                }

                $new_miembro = new TablerosListasTareasMiembros();

                $permiso = $new_miembro->chequearMiembro($id_tablero, $_SESSION['user_data']['einfo_id']);

                if (($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) || $permiso || ($_SESSION['user_data']['einfo_id'] == 1)) {

                    if ($item->editar($id, [
                        'item_estatus' => ($estatus == true) ? 1 : 0,
                    ])) {

                        $data_item = $item->obtener($id);
                        $newChecklist = new TablerosListasTareasCheckList();
                        $newTareas = new TablerosListasTareas();

                        $data_checklist = $newChecklist->obtener($data_item['item_checklistid']);
                        $data_tarea = $newTareas->obtener($data_checklist['checklist_tarid']);

                        $this->tableros->editar($id_tablero, [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);

                        $this->newTabHis->guardar([
                            'tabhis_tabid' => $id_tablero,
                            'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                            'tabhis_descripcion' => "Ha completado <strong>{$data_item['item_descripcion']}</strong> del checklist <strong>{$data_checklist['checklist_nombre']}</strong> de la tarea <strong>{$data_tarea['tar_nombre']}</strong>"
                        ]);

                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['Lo sinto no posee permisos de administrador o no es miembro de esta incidencia']]);
                    exit();
                }
            }
        }
    }

    public function eliminarItem()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_GET['id_tab']) && !empty($_GET['id_item'])) {

                $item = new TablerosListasTareasCheckListItem();
                $new_grupos = new TablerosGrupos();

                $id_tablero = $this->solicitud->sanitize($_GET['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $id_item = $this->solicitud->sanitize($_GET['id_item'], FILTER_SANITIZE_NUMBER_INT);

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    $data_item = $item->obtener($id_item);

                    if ($item->eliminar($id_item)) {

                        $this->tableros->editar($id_tablero, [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);

                        $newChecklist = new TablerosListasTareasCheckList();
                        $data_checklist = $newChecklist->obtener($data_item['item_checklistid']);
                        $newTareas = new TablerosListasTareas();
                        $data_tarea = $newTareas->obtener($data_checklist['checklist_tarid']);

                        $this->newTabHis->guardar([
                            'tabhis_tabid' => $id_tablero,
                            'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                            'tabhis_descripcion' => "Eliminado item del checklist <strong>{$data_checklist['checklist_nombre']}</strong> de la tarea <strong>{$data_tarea['tar_nombre']}</strong>"
                        ]);

                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    public function obtenerAdministrador(int $id_tablero)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_tablero = $this->solicitud->sanitize($id_tablero, FILTER_SANITIZE_NUMBER_INT);

            $new_grupos = new TablerosGrupos();

            $list_admin = [];
            $grup_empleados = $new_grupos->obtenerGrupo($id_tablero);

            if (is_countable($grup_empleados) && count($grup_empleados)) {
                foreach ($grup_empleados as $row) {
                    $list_admin[] = [
                        'id' => $row['grup_id'],
                        'emp_id' => $row['grup_empid'],
                        'nombre' => ucwords(strtolower($row['nombre']) . ' ' . strtolower($row['apellido']))
                    ];
                }
            }

            header('Content-Type: application/json');
            echo json_encode($list_admin);
            exit();
        }
    }

    public function guardarAdministrador()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('servicios', 'add_admin', $_SESSION['user_data']['emp_id'])) {

                if (!empty($_GET['id_tab']) && !empty($_GET['id_emp'])) {

                    $new_grupo = new TablerosGrupos();

                    $id_tablero = $this->solicitud->sanitize($_GET['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                    $id_empleado = $this->solicitud->sanitize($_GET['id_emp'], FILTER_SANITIZE_NUMBER_INT);

                    if ($new_grupo->guardar([
                        'grup_empid' => $id_empleado,
                        'grup_tabid' => $id_tablero,
                    ], true)) {
                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                }
            } else {
                header('Content-Type: application/json');
                echo json_encode(['errors' => ['No posee permisos para agregar administradores']]);
                exit();
            }
        }
    }

    public function eliminarAdministrador(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('servicios', 'delete_admin', $_SESSION['user_data']['emp_id'])) {

                if (!empty($id)) {

                    $new_grupo = new TablerosGrupos();

                    $id = $this->solicitud->sanitize($id, FILTER_SANITIZE_NUMBER_INT);

                    if ($new_grupo->eliminar($id)) {
                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                }
            } else {
                header('Content-Type: application/json');
                echo json_encode(['errors' => ['No posee permisos para eliminar administradores']]);
                exit();
            }
        }
    }

    public function eliminarTablero(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('servicios', 'delete_tablero', $_SESSION['user_data']['emp_id'])) {

                if (!empty($id)) {

                    $id = $this->solicitud->sanitize($id, FILTER_SANITIZE_NUMBER_INT);

                    $data_tablero = $this->tableros->obtener($id);

                    if ($data_tablero) {
                        if ($this->tableros->editar($id, [
                            'tab_eliminado' => 1
                        ])) {
                            $this->newTabHis->guardar([
                                'tabhis_tabid' => $id,
                                'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                                'tabhis_descripcion' => "Ha eliminado tablero <strong>{$data_tablero['tab_nombre']}</strong>"
                            ]);
                            header('Content-Type: application/json');
                            echo json_encode(true);
                            exit();
                        } else {
                            header('Content-Type: application/json');
                            echo json_encode(false);
                            exit();
                        }
                    }
                }
            } else {
                header('Content-Type: application/json');
                echo json_encode(['errors' => ['No posee permisos para eliminar tableros']]);
                exit();
            }
        }
    }

    public function buscarEmpleados(string $buscar)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $buscar = $this->solicitud->sanitize($buscar, FILTER_SANITIZE_STRING);
            $buscar = urldecode($buscar);

            if (!empty($buscar)) {

                $list_emp = [];

                $clientes = $this->tableros->buscarEmpleados($buscar);

                if (count($clientes) > 0) {
                    foreach ($clientes as $row) {
                        $list_emp[] = [
                            'id' => $row['emp_id'],
                            'nombre' => ucwords(strtolower($row['einfo_nombres']) . ' ' . strtolower($row['einfo_apellidos']))
                        ];
                    }
                }

                header('Content-Type: application/json');
                echo json_encode($list_emp);
                exit();
            }
        }
    }

    public function buscarMiembros()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax() && (!empty($_GET['buscar']) && !empty($_GET['tarea']))) {
            $buscar = $this->solicitud->sanitize($_GET['buscar'], FILTER_SANITIZE_STRING);
            $tar_id = $this->solicitud->sanitize($_GET['tarea'], FILTER_SANITIZE_NUMBER_INT);
            $list_miembros = [];
            $miembros = $this->tableros->buscarMiembros($buscar, $tar_id);
            if (count($miembros) > 0) {
                foreach ($miembros as $row) {
                    $list_miembros[] = [
                        'id' => $row['einfo_id'],
                        'nombre' => ucwords(strtolower($row['einfo_nombres'] . ' ' . $row['einfo_apellidos']))
                    ];
                }
            }
            header('Content-Type: application/json');
            echo json_encode($list_miembros);
            exit();
        }
    }

    public function agregarMiembro()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $_POST = json_decode(file_get_contents('php://input'), true);

            if (!empty($_POST['id_tab']) && !empty($_POST['tarea']) && !empty($_POST['miembro'])) {

                $id_tablero = $this->solicitud->sanitize($_POST['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $tarea = $this->solicitud->sanitize($_POST['tarea'], FILTER_SANITIZE_NUMBER_INT);
                $miembro = $this->solicitud->sanitize($_POST['miembro'], FILTER_SANITIZE_NUMBER_INT);

                $miembros = new TablerosListasTareasMiembros();
                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    if ($miembros->guardar([
                        'miemb_tarid' => $tarea,
                        'miemb_empid_miembro' => $miembro,
                        'miemb_empid' => $_SESSION['user_data']['einfo_id']
                    ], true)) {
                        $this->tableros->editar($id_tablero, [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);
                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    public function obtenerMiembros(int $id_tarea)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $new_miembros = new TablerosListasTareasMiembros();

            $list_miembros = [];

            $miembros = $new_miembros->obtenerMiembros($id_tarea);

            foreach ($miembros as $row) {
                $list_miembros[] = [
                    'id' => $row['miemb_id'],
                    'nombre' => ucwords(strtolower($row['einfo_nombres'] . ' ' . $row['einfo_apellidos']))
                ];
            }

            header('Content-Type: application/json');
            echo json_encode($list_miembros);
            exit();
        }
    }

    public function eliminarMiembro()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_GET['id_tab']) && !empty($_GET['id_miembro'])) {

                $id_miembro = $this->solicitud->sanitize($_GET['id_miembro'], FILTER_SANITIZE_NUMBER_INT);
                $id_tablero = $this->solicitud->sanitize($_GET['id_tab'], FILTER_SANITIZE_NUMBER_INT);

                $new_miembros = new TablerosListasTareasMiembros();

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador && $_SESSION['user_data']['emp_id'] == 1) {
                    $administrador['grup_empid'] = 1;
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    if ($new_miembros->eliminar($id_miembro)) {
                        $this->tableros->editar($id_tablero, [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);
                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    public function buscarClientes()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $buscar = filter_input(INPUT_GET, 'buscar', FILTER_SANITIZE_STRING);
            $clientes = $this->tableros->buscarClientes($buscar);
            $list_clientes = [];
            if (is_countable($clientes) && count($clientes)) {
                foreach ($clientes as $row) {
                    $list_clientes[] = [
                        'id' => $row['cli_id'],
                        'nombre' => ucwords(strtolower($row['cli_razon_social']))
                    ];
                }
            }
            header('Content-Type: application/json');
            echo json_encode($list_clientes);
            exit();
        }
    }

    public function agregarCliente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $_POST = json_decode(file_get_contents('php://input'), true);

            if (!empty($_POST['tarea']) && !empty($_POST['cliente'])) {

                $id_tablero = $this->solicitud->sanitize($_POST['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $tarea = $this->solicitud->sanitize($_POST['tarea'], FILTER_SANITIZE_NUMBER_INT);
                $cliente = $this->solicitud->sanitize($_POST['cliente'], FILTER_SANITIZE_NUMBER_INT);

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador) {
                    if ($_SESSION['user_data']['emp_id'] == 1) {
                        $administrador['grup_empid'] = 1;
                    } else {
                        $administrador['grup_empid'] = '';
                    }
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    $new_tareas = new TablerosListasTareas();

                    if ($new_tareas->editar($tarea, [
                        'tar_cliente' => $cliente
                    ])) {
                        $this->tableros->editar($id_tablero, [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);
                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    public function obtenerCliente(int $id_tarea)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $new_cliente = new TablerosListasTareas();

            $cliente = $new_cliente->obtenerCliente($id_tarea);

            if ($cliente) {
                header('Content-Type: application/json');
                echo json_encode([
                    'id' => $cliente['cli_id'],
                    'dni' => $cliente['cli_dni'],
                    'nombre' => ucwords(strtolower($cliente['cli_razon_social']))
                ]);
                exit();
            } else {
                header('Content-Type: application/json');
                echo json_encode(false);
                exit();
            }
        }
    }

    public function eliminarCliente()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_GET['id_tab']) && !empty($_GET['id_tarea'])) {

                $id_tablero = $this->solicitud->sanitize($_GET['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $id_tarea = $this->solicitud->sanitize($_GET['id_tarea'], FILTER_SANITIZE_NUMBER_INT);

                $new_tareas = new TablerosListasTareas();

                $new_grupos = new TablerosGrupos();

                $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                if (!$administrador && $_SESSION['user_data']['emp_id'] == 1) {
                    $administrador['grup_empid'] = 1;
                }

                if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {

                    if ($new_tareas->editar($id_tarea, [
                        'tar_cliente' => NULL
                    ])) {
                        $this->tableros->editar($id_tablero, [
                            'tab_actualizado' => date('Y-m-d H:i:s')
                        ]);
                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    } else {
                        header('Content-Type: application/json');
                        echo json_encode(false);
                        exit();
                    }
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(['errors' => ['No posee permisos de administrador']]);
                    exit();
                }
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    public function guardarVencimiento()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $_POST = json_decode(file_get_contents('php://input'), true);

            if (!empty($_POST['id_tab']) && !empty($_POST['fecha']) && !empty($_POST['tarea'])) {

                $new_tarea = new TablerosListasTareas();

                $id_tablero = $this->solicitud->sanitize($_POST['id_tab'], FILTER_SANITIZE_NUMBER_INT);
                $tarea = $this->solicitud->sanitize($_POST['tarea'], FILTER_SANITIZE_NUMBER_INT);
                $fecha = $this->solicitud->sanitize($_POST['fecha'], FILTER_SANITIZE_STRING);
                $hora = $this->solicitud->sanitize($_POST['hora'], FILTER_SANITIZE_STRING);
                $recordatorio = $this->solicitud->sanitize($_POST['recordatorio'], FILTER_SANITIZE_NUMBER_INT);

                if (!validateDate($fecha, 'Y-m-d')) {
                    $this->array_errors[] = 'Fecha incorrecta';
                }

                if (!empty($hora) && !validateDate($hora, 'H:i')) {
                    $this->array_errors[] = 'Hora incorrecta';
                }

                if (empty($this->array_errors)) {

                    $new_grupos = new TablerosGrupos();

                    $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                    //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                    if (!$administrador) {
                        if ($_SESSION['user_data']['emp_id'] == 1) {
                            $administrador['grup_empid'] = 1;
                        } else {
                            $administrador['grup_empid'] = '';
                        }
                    }

                    $data_tarea = $new_tarea->obtener($tarea);

                    if ($_SESSION['user_data']['emp_id'] == $administrador['grup_empid']) {
                        if ($new_tarea->editar($tarea, [
                            'tar_fecha_vencimiento' => $fecha,
                            'tar_hora_vencimiento' => $hora,
                            'tar_recordatorio' => $recordatorio
                        ])) {

                            $this->tableros->editar($id_tablero, [
                                'tab_actualizado' => date('Y-m-d H:i:s')
                            ]);

                            $this->newTabHis->guardar([
                                'tabhis_tabid' => $id_tablero,
                                'tabhis_empid' => $_SESSION['user_data']['einfo_id'],
                                'tabhis_descripcion' => 'Ha cambiado la fecha de vencimiento de la tarea <strong>' . $data_tarea['tar_nombre'] . '</strong> a <strong>' . date('d-m-Y', strtotime($fecha)) . ', ' . $hora . '</strong>'
                            ]);

                            header('Content-Type: application/json');
                            echo json_encode(true);
                            exit();
                        } else {
                            header('Content-Type: application/json');
                            echo json_encode(false);
                            exit();
                        }
                    } else {
                        $this->array_errors[] = 'No posee permisos de administrador';
                    }
                }

                header('Content-Type: application/json');
                echo json_encode(['errors' => $this->array_errors]);
                exit();
            }

            header('Content-Type: application/json');
            echo json_encode(false);
            exit();
        }
    }

    public function obtenerPlantillas()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $new_plantillas = new TablerosCategorias();

            $list_plantillas = [];
            $plantillas = [];

            if ($this->module->has_module_action_permission('servicios', 'crear_plantillas', $_SESSION['user_data']['emp_id'])) {
                $plantillas = $new_plantillas->obtenerPlantillas();
            }

            if (count($plantillas) > 0) {
                foreach ($plantillas as $row) {
                    $list_plantillas[] = [
                        'id' => $row['cat_id'],
                        'categoria' => $row['cat_nombre'],
                        'modificacion' => ucfirst($row['modificacion']),
                        'empleado' => ucwords(strtolower($row['einfo_nombres'] . ' ' . $row['einfo_apellidos']))
                    ];
                }
            }

            header('Content-Type: application/json');
            echo json_encode($list_plantillas);
            exit();
        }
    }

    public function eliminarPlantilla(int $id_plantilla)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('servicios', 'delete_plantilla', $_SESSION['user_data']['emp_id'])) {

                $new_plantillas = new TablerosCategorias();

                if ($new_plantillas->existe('cat_id', $id_plantilla)) {
                    Http::json_response($new_plantillas->eliminar($id_plantilla));
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            } else {
                $this->array_errors[] = 'No posee permisos para eliminar plantillas';
            }

            header('Content-Type: application/json');
            echo json_encode(['errors' => $this->array_errors]);
            exit();
        }
    }

    public function guardarPlantilla()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('servicios', 'crear_plantillas', $_SESSION['user_data']['emp_id'])) {

                $data = json_decode(file_get_contents('php://input'), true);

                if (!empty($data['items']) && !empty($data['categoria']) && (is_countable($data['items']) && count($data['items']))) {
                    $categoria = $this->solicitud->sanitize($data['categoria'], FILTER_SANITIZE_STRING);
                    $new_categorias = new TablerosCategorias();
                    $id_cat = $new_categorias->guardar([
                        'cat_nombre' => $categoria,
                        'cat_empid' => $_SESSION['user_data']['einfo_id']
                    ]);
                    if ($id_cat) {

                        $new_plantillas = new TablerosCategoriasPlantillas();

                        $i = 0;

                        foreach ($data['items'] as $row) {
                            $new_plantillas->guardar([
                                'pla_categoria' => $id_cat,
                                'pla_descripcion' => $this->solicitud->sanitize($row['descripcion'], FILTER_SANITIZE_STRING),
                                'pla_orden' => $i++,
                                'pla_empid' => $_SESSION['user_data']['einfo_id']
                            ]);
                        }

                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    }
                }

                header('Content-Type: application/json');
                echo json_encode(false);
                exit();
            } else {
                header('Content-Type: application/json');
                echo json_encode(['errors' => ['No posee permisos para crear plantillas']]);
                exit();
            }
        }
    }

    public function obtenerPlantilla(int $id_cat)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_cat  = $this->solicitud->sanitize($id_cat, FILTER_SANITIZE_NUMBER_INT);

            $new_plantillas = new TablerosCategoriasPlantillas();

            $list_plantilla = [];

            $items = $new_plantillas->obtenerPlantillas($id_cat);

            if (count($items) > 0) {
                foreach ($items as $row) {
                    $list_plantilla[] = [
                        'descripcion' => $row['pla_descripcion']
                    ];
                }
            }

            header('Content-Type: application/json');
            echo json_encode($list_plantilla);
            exit();
        }
    }

    public function editarPlantilla()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('servicios', 'crear_plantillas', $_SESSION['user_data']['emp_id'])) {

                $data = json_decode(file_get_contents('php://input'), true);

                if (!empty($data['id_cat']) && !empty($data['items']) && !empty($data['categoria']) && (is_countable($data['items']) && count($data['items']))) {
                    $id_cat = $this->solicitud->sanitize($data['id_cat'], FILTER_SANITIZE_NUMBER_INT);
                    $categoria = $this->solicitud->sanitize($data['categoria'], FILTER_SANITIZE_STRING);
                    $new_categorias = new TablerosCategorias();
                    if ($new_categorias->editar($id_cat, [
                        'cat_nombre' => $categoria,
                        'cat_empid' => $_SESSION['user_data']['einfo_id']
                    ])) {

                        $new_plantillas = new TablerosCategoriasPlantillas();

                        $new_plantillas->consultar("DELETE FROM app_tableros_categorias_plantillas WHERE pla_categoria = $id_cat")->run();

                        $i = 0;

                        foreach ($data['items'] as $row) {
                            $new_plantillas->guardar([
                                'pla_categoria' => $id_cat,
                                'pla_descripcion' => $this->solicitud->sanitize($row['descripcion'], FILTER_SANITIZE_STRING),
                                'pla_orden' => $i++,
                                'pla_empid' => $_SESSION['user_data']['einfo_id']
                            ]);
                        }

                        header('Content-Type: application/json');
                        echo json_encode(true);
                        exit();
                    }
                }

                header('Content-Type: application/json');
                echo json_encode(false);
                exit();
            } else {
                header('Content-Type: application/json');
                echo json_encode(['errors' => ['No posee permisos para crear plantillas']]);
                exit();
            }
        }
    }

    public function enviarCorreo()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_tarea = $this->solicitud->sanitize($_POST['id'], FILTER_SANITIZE_NUMBER_INT);
            $para   = $this->solicitud->sanitize($_POST['para'], FILTER_SANITIZE_EMAIL);

            $newTarea = new TablerosListasTareas();
            $tarea = $this->tableros->consultar("SELECT tab.tab_nombre, tab.tab_color, lis.tablist_nombre, tar.tar_id, tar.tar_orden, tar.tar_descripcion, tar.tar_nombre, DATE_FORMAT(tar.tar_creado, '%d-%m-%Y') as creado, DATE_FORMAT(tar.tar_fecha_vencimiento, '%d-%m-%Y') as vencimiento, cli_razon_social, cli_dni 
            FROM app_tableros tab 
            JOIN app_tableros_listas lis ON lis.tablist_tabid =  tab.tab_id 
            JOIN app_tableros_listas_tareas tar ON tar.tar_listid = lis.tablist_id 
            LEFT JOIN app_clientes c ON c.cli_id = tar.tar_cliente
            WHERE tar.tar_id = $id_tarea")->row();

            $Adjunto = $this->obtenerAdjuntosTarea($id_tarea);

            $empresa_data       = $this->tableros->consultar('SELECT * FROM app_empresas WHERE emp_id=1')->row();

            $mpdf = $this->imprimirpdf($id_tarea);
            $content = $mpdf['mpdf']->Output('', 'S');

            $mail = new PHPMailer(true);

            try {

                $mail->isSMTP();
                $mail->Host       = "{$empresa_data['emp_host_correo']}";
                $mail->SMTPAuth   = true;
                $mail->Username   = "{$empresa_data['emp_email']}";
                $mail->Password   = "{$empresa_data['emp_email_password']}";
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                $mail->Port       = $empresa_data['emp_port_correo'];

                $mail->setFrom("{$empresa_data['emp_email']}");
                $mail->addAddress($para);
                $mail->addReplyTo("{$empresa_data['emp_email']}", 'Empresa');

                if (is_countable($Adjunto) && count($Adjunto)) {
                    foreach ($Adjunto as $row) {
                        $img = constant('IMG_URI') . 'adjuntosservicios/' . $row['archivo'];
                        $mail->addStringAttachment(file_get_contents($img), $row['archivo']);
                    }
                }

                $mail->addStringAttachment($content, "{$mpdf['mascara']}");

                $mail->isHTML(true);
                $mail->Subject = 'SERVICIO';
                $mail->Body    = "Informacion sobre el servicio " . $tarea['tar_nombre'];

                $mail->send();

                Http::json_response("Envio de servicio exitosa");
            } catch (Exception $e) {
                $this->array_errors[] = "Message could not be sent. Mailer Error: {$mail->ErrorInfo}.";
            }
            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerAdjuntosTarea($id_tarea)
    {
        $id_tarea  = $this->solicitud->sanitize($id_tarea, FILTER_SANITIZE_NUMBER_INT);

        $new_enlaces = new TablerosListasTareasEnlaces();
        $new_archivos = new TablerosListasTareasArchivos();

        $list_enlaces = [];
        $list_archivos = [];
        $enlaces = $new_enlaces->where(['enl_tarid' => $id_tarea]);
        $archivos = $new_archivos->where(['arch_tarid' => $id_tarea]);

        if (is_countable($enlaces) && count($enlaces)) {
            foreach ($enlaces as $row) {
                $list_enlaces[] = [
                    'enlace' => $row['enl_enlace'],
                    'enlace_nombre' => $row['enl_enlace_nombre'] ?? $row['enl_enlace'],
                    'creado' => $row['enl_creado'],
                    'actualizado' => $row['enl_actualizado']
                ];
            }
        }

        $extenciones = array('jpg', 'jpeg', 'png', 'gif');

        if (is_countable($archivos) && count($archivos)) {

            foreach ($archivos as $row) {

                $fileNameCmps = explode(".", basename($row['arch_archivo']));
                $fileExtension = strtolower(end($fileNameCmps));

                $imagen = (in_array($fileExtension, $extenciones)) ? true : false;

                $list_archivos[] = [
                    'imagen' => $imagen,
                    'archivo' => $row['arch_archivo'],
                    'nombre' => $row['arch_nombre'],
                    'creado' => $row['arch_creado'],
                    'actualizado' => $row['arch_actualizado']
                ];
            }
        }
        return $list_archivos;
    }


    public function obtenerAdjuntos(int $id_tarea)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_tarea = $this->solicitud->sanitize($id_tarea, FILTER_SANITIZE_NUMBER_INT);

            $new_enlaces = new TablerosListasTareasEnlaces();
            $new_archivos = new TablerosListasTareasArchivos();

            $list_enlaces = [];
            $list_archivos = [];
            $enlaces = $new_enlaces->where(['enl_tarid' => $id_tarea]);
            $archivos = $new_archivos->where(['arch_tarid' => $id_tarea]);

            if (is_countable($enlaces) && count($enlaces)) {
                foreach ($enlaces as $row) {
                    $list_enlaces[] = [
                        'enlace' => $row['enl_enlace'],
                        'enlace_nombre' => $row['enl_enlace_nombre'] ?? $row['enl_enlace'],
                        'creado' => $row['enl_creado'],
                        'actualizado' => $row['enl_actualizado']
                    ];
                }
            }

            $extenciones = array('jpg', 'jpeg', 'png', 'gif');

            if (is_countable($archivos) && count($archivos)) {

                foreach ($archivos as $row) {

                    $fileNameCmps = explode(".", basename($row['arch_archivo']));
                    $fileExtension = strtolower(end($fileNameCmps));

                    $imagen = (in_array($fileExtension, $extenciones)) ? true : false;

                    $list_archivos[] = [
                        'imagen' => $imagen,
                        'archivo' => $row['arch_archivo'],
                        'nombre' => $row['arch_nombre'],
                        'creado' => $row['arch_creado'],
                        'actualizado' => $row['arch_actualizado']
                    ];
                }
            }

            header('Content-Type: application/json');
            echo json_encode([
                'enlaces' => $list_enlaces,
                'archivos' => $list_archivos
            ]);
            exit();
        }
    }

    public function imprimirpdf($id_tarea)
    {
        $id_tarea = $this->solicitud->sanitize($id_tarea, FILTER_SANITIZE_NUMBER_INT);

        $empresa_data = $this->tableros->consultar('SELECT * FROM app_empresas WHERE emp_id=1')->row();

        $tarea = $this->tableros->consultar("SELECT tab.tab_nombre, tab.tab_color, list.tablist_nombre, tar.tar_id, tar.tar_orden, tar.tar_descripcion, DATE_FORMAT(tar.tar_creado, '%d-%m-%Y') as creado, DATE_FORMAT(tar.tar_fecha_vencimiento, '%d-%m-%Y') as vencimiento, cli_razon_social, cli_dni 
            FROM app_tableros tab 
            JOIN app_tableros_listas list ON list.tablist_tabid =  tab.tab_id 
            JOIN app_tableros_listas_tareas tar ON tar.tar_listid = list.tablist_id 
            LEFT JOIN app_clientes c ON c.cli_id = tar.tar_cliente
            WHERE tar.tar_id = $id_tarea")->row();

        if ($tarea) {

            $list_checklist = [];

            $checklist = $this->tableros->consultar("SELECT checklist_id, checklist_nombre,	checklist_orden, checklist_empid, DATE_FORMAT(checklist_creado, '%d-%m-%Y') creado, DATE_FORMAT(checklist_actualizado, '%d-%m-%Y') actualizado 
                FROM app_tableros_listas_tareas_checklist
                WHERE checklist_tarid = {$tarea['tar_id']} 
                ORDER BY checklist_orden")->all();

            if (is_countable($checklist) && count($checklist)) {

                foreach ($checklist as $row) {

                    $items = $this->tableros->consultar("SELECT item_descripcion, item_estatus, DATE_FORMAT(item_creado, '%d-%m-%Y') as creado, DATE_FORMAT(item_actualizado, '%d-%m-%Y') as actualizado 
                        FROM app_tableros_listas_tareas_checklist_items 
                        WHERE item_checklistid = {$row['checklist_id']}
                        ORDER BY item_orden")->all();

                    $item_mas = [];

                    if (is_countable($items) && count($items)) {
                        foreach ($items as $item) {
                            $item_mas[] = [
                                'descripcion' => $item['item_descripcion'],
                                'estatus' => $item['item_estatus'] ? true : false,
                                'creado' => $item['creado'],
                                'actualizado' => $item['actualizado']
                            ];
                        }
                    }

                    $list_checklist[] = [
                        'checklist_nombre' => $row['checklist_nombre'],
                        'checklist_orden' => $row['checklist_orden'],
                        'checklist_creado' => $row['creado'],
                        'checklist_actualizado' => $row['actualizado'],
                        'items' => $item_mas
                    ];
                }
            }

            $mpdf = new \Mpdf\Mpdf([
                'mode'              => 'utf-8',
                'margin_left'       => 15,
                'margin_right'      => 15,
                'margin_top'        => 35,
                'margin_bottom'     => 15,
                'margin_header'     => 15,
                'margin_footer'     => 15,
                'format'            => 'A4',
                'orientation'       => 'P',
                'default_font_size' => 8,
                'default_font'      => 'helvetica'
            ]);

            $mpdf->SetTitle('Incidencias');
            $mpdf->SetAuthor($empresa_data['emp_nombre']);
            $mpdf->SetCreator($empresa_data['emp_nombre']);
            $mpdf->SetSubject('Incidencias');

            $html_header = Vista::viewPDF('servicios/header_pdf.php', [
                'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
                'emp_rif'       => $empresa_data['emp_rif'] ?? '',
                'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
                'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
                'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
                'emp_estado'    => $empresa_data['emp_estado'] ?? '',
                'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
            ]);

            $mpdf->SetHTMLHeader($html_header);

            $html_footer = Vista::viewPDF('servicios/footer_pdf.php');

            $mpdf->SetHTMLFooter($html_footer);

            $html_body = Vista::viewPDF('servicios/body_pdf.php', [
                'tarea' => $tarea,
                'checklist' => $list_checklist
            ]);

            $mpdf->WriteHTML($html_body);

            return [
                'mpdf'      => $mpdf,
                'mascara'   => 'Inidencias.pdf',
                'empresa'   => $empresa_data,
            ];
        }
    }

    public function imprimirTicket()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            $id_tarea = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);
            $empresa_data = $this->tableros->consultar('SELECT * FROM app_empresas WHERE emp_id=1')->row();

            $tarea = $this->tableros->consultar("SELECT tab.tab_nombre, tab.tab_color, list.tablist_nombre, tar.tar_id, tar.tar_orden,tar.tar_nombre,tar.tar_empcreado, tar.tar_descripcion, DATE_FORMAT(tar.tar_creado, '%d-%m-%Y') as creado, DATE_FORMAT(tar.tar_fecha_vencimiento, '%d-%m-%Y') as vencimiento, cli_razon_social, cli_dni 
            FROM app_tableros tab 
            JOIN app_tableros_listas list ON list.tablist_tabid =  tab.tab_id 
            JOIN app_tableros_listas_tareas tar ON tar.tar_listid = list.tablist_id 
            LEFT JOIN app_clientes c ON c.cli_id = tar.tar_cliente 
            WHERE tar.tar_id = $id_tarea")->row();


            if ($tarea) {

                $list_checklist = [];
                $item_mas = [];

                $checklist = $this->tableros->consultar("SELECT checklist_id, checklist_nombre,	checklist_orden, checklist_empid, DATE_FORMAT(checklist_creado, '%d-%m-%Y') creado, DATE_FORMAT(checklist_actualizado, '%d-%m-%Y') actualizado 
                FROM app_tableros_listas_tareas_checklist
                WHERE checklist_tarid = {$tarea['tar_id']} 
                ORDER BY checklist_orden")->all();

                if (is_countable($checklist) && count($checklist)) {

                    foreach ($checklist as $row) {
                        $items = $this->tableros->consultar("SELECT item_descripcion, item_estatus, DATE_FORMAT(item_creado, '%d-%m-%Y') as creado, DATE_FORMAT(item_actualizado, '%d-%m-%Y') as actualizado 
                        FROM app_tableros_listas_tareas_checklist_items 
                        WHERE item_checklistid = {$row['checklist_id']}
                        ORDER BY item_orden")->all();

                        if (is_countable($items) && count($items)) {
                            foreach ($items as $item) {
                                $item_mas[] = [
                                    'descripcion' => $item['item_descripcion'],
                                    'estatus' =>  $item['item_estatus'] ? 'Finalizado' : 'Pendiente',
                                    'fecha' => $item['creado']
                                ];
                            }
                        }
                    }
                }

                $data_final = [
                    'command'           => 'generate_ticket_incidencias_servicio',
                    'args' => [[
                        'empresa'            => $empresa_data['emp_nombre'],
                        'direccion'            => $empresa_data['emp_direccion'],
                        'rif'            => $empresa_data['emp_rif'],
                        'razon'            => $tarea['cli_razon_social'],
                        'documento'            => $tarea['cli_dni'],
                        'departamento'            => $tarea['tab_nombre'],
                        'titulo'            => $tarea['tar_nombre'],
                        'user'            => $tarea['tar_empcreado'],
                        'fecha'            => $tarea['creado'],
                        'descripcion'            => $tarea['tar_descripcion'],
                        'vencimiento'            => $tarea['vencimiento'] != NULL ? $tarea['vencimiento'] : " ",
                        'actividades'              => $item_mas
                    ]]
                ];

                $impresora = $this->tableros->consultar("SELECT imp_tipo,imp_codigo, CONCAT(imp_ip, ':', imp_puerto) ip_puerto,imp_limite,imp_redondear, imp_usd,imp_descripcion_final      
        FROM app_impresoras WHERE imp_id = 1")->row();


                Http::json_response([
                    'ip_puerto' => protocolo() . $impresora['ip_puerto'],
                    'data'      => $data_final
                ]);
            }
        }
    }

    public function imprimirTarea(int $id_tarea)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {

            $id_tarea = $this->solicitud->sanitize($id_tarea, FILTER_SANITIZE_NUMBER_INT);

            $empresa_data = $this->tableros->consultar('SELECT * FROM app_empresas WHERE emp_id=1')->row();

            $tarea = $this->tableros->consultar("SELECT tab.tab_nombre, tab.tab_color, list.tablist_nombre, tar.tar_id, tar.tar_orden, tar.tar_descripcion, DATE_FORMAT(tar.tar_creado, '%d-%m-%Y') as creado, DATE_FORMAT(tar.tar_fecha_vencimiento, '%d-%m-%Y') as vencimiento, cli_razon_social, cli_dni 
            FROM app_tableros tab 
            JOIN app_tableros_listas list ON list.tablist_tabid =  tab.tab_id 
            JOIN app_tableros_listas_tareas tar ON tar.tar_listid = list.tablist_id 
            LEFT JOIN app_clientes c ON c.cli_id = tar.tar_cliente
            WHERE tar.tar_id = $id_tarea")->row();

            if ($tarea) {

                $list_checklist = [];

                $checklist = $this->tableros->consultar("SELECT checklist_id, checklist_nombre,	checklist_orden, checklist_empid, DATE_FORMAT(checklist_creado, '%d-%m-%Y') creado, DATE_FORMAT(checklist_actualizado, '%d-%m-%Y') actualizado 
                FROM app_tableros_listas_tareas_checklist
                WHERE checklist_tarid = {$tarea['tar_id']} 
                ORDER BY checklist_orden")->all();

                if (is_countable($checklist) && count($checklist)) {

                    foreach ($checklist as $row) {

                        $items = $this->tableros->consultar("SELECT item_descripcion, item_estatus, DATE_FORMAT(item_creado, '%d-%m-%Y') as creado, DATE_FORMAT(item_actualizado, '%d-%m-%Y') as actualizado 
                        FROM app_tableros_listas_tareas_checklist_items 
                        WHERE item_checklistid = {$row['checklist_id']}
                        ORDER BY item_orden")->all();

                        $item_mas = [];

                        if (is_countable($items) && count($items)) {
                            foreach ($items as $item) {
                                $item_mas[] = [
                                    'descripcion' => $item['item_descripcion'],
                                    'estatus' => $item['item_estatus'] ? true : false,
                                    'creado' => $item['creado'],
                                    'actualizado' => $item['actualizado']
                                ];
                            }
                        }

                        $list_checklist[] = [
                            'checklist_nombre' => $row['checklist_nombre'],
                            'checklist_orden' => $row['checklist_orden'],
                            'checklist_creado' => $row['creado'],
                            'checklist_actualizado' => $row['actualizado'],
                            'items' => $item_mas
                        ];
                    }
                }

                $mpdf = new \Mpdf\Mpdf([
                    'mode'              => 'utf-8',
                    'margin_left'       => 15,
                    'margin_right'      => 15,
                    'margin_top'        => 35,
                    'margin_bottom'     => 15,
                    'margin_header'     => 15,
                    'margin_footer'     => 15,
                    'format'            => 'A4',
                    'orientation'       => 'P',
                    'default_font_size' => 8,
                    'default_font'      => 'helvetica'
                ]);

                $mpdf->SetTitle('Incidencias');
                $mpdf->SetAuthor($empresa_data['emp_nombre']);
                $mpdf->SetCreator($empresa_data['emp_nombre']);
                $mpdf->SetSubject('Incidencias');

                $html_header = Vista::viewPDF('servicios/header_pdf.php', [
                    'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
                    'emp_rif'       => $empresa_data['emp_rif'] ?? '',
                    'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
                    'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
                    'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
                    'emp_estado'    => $empresa_data['emp_estado'] ?? '',
                    'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
                ]);

                $mpdf->SetHTMLHeader($html_header);

                $html_footer = Vista::viewPDF('servicios/footer_pdf.php');

                $mpdf->SetHTMLFooter($html_footer);

                $html_body = Vista::viewPDF('servicios/body_pdf.php', [
                    'tarea' => $tarea,
                    'checklist' => $list_checklist
                ]);

                $mpdf->WriteHTML($html_body);

                $mpdf->Output("Inidencias.pdf", \Mpdf\Output\Destination::INLINE);
                exit;
            }
        }
    }

    public function guardarComentario()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $_POST = json_decode(file_get_contents('php://input'), true);

            if (!empty($_POST['comentario']) && !empty($_POST['tarea'])) {

                $comentario = $this->solicitud->sanitize($_POST['comentario'], FILTER_SANITIZE_STRING);
                $tarea = $this->solicitud->sanitize($_POST['tarea'], FILTER_SANITIZE_NUMBER_INT);

                $newComentarios = new TablerosListasTareasComentarios();

                if ($newComentarios->guardar([
                    'com_tarid' => $tarea,
                    'com_descripcion' => $comentario,
                    'com_empid' => $_SESSION['user_data']['einfo_id'],
                ], true)) {
                    header('Content-Type: application/json');
                    echo json_encode(true);
                    exit();
                } else {
                    header('Content-Type: application/json');
                    echo json_encode(false);
                    exit();
                }
            } else {
                header('Content-Type: application/json');
                echo json_encode(false);
                exit();
            }
        }
    }

    public function editarComentario()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $_POST = json_decode(file_get_contents('php://input'), true);

            if (empty($_POST['id_tab']) || empty($_POST['id_com']))
                $this->array_errors[] = 'Acción prohibida';
            if (empty($_POST['descripcion']))
                $this->array_errors[] = 'La descripcion des requerida';

            if (empty($this->array_errors)) {

                $id_tablero = filter_var($_POST['id_tab'], FILTER_VALIDATE_INT);
                $id_comentario = filter_var($_POST['id_com'], FILTER_VALIDATE_INT);
                $descripcion = $this->solicitud->sanitize($_POST['descripcion'], FILTER_SANITIZE_STRING);

                if ($id_tablero && $id_comentario) {

                    $new_grupos = new TablerosGrupos();
                    $administrador = $new_grupos->chequearAdministrador($id_tablero, $_SESSION['user_data']['emp_id']);

                    //SI EL TABLERO NO POSEE ADMINSTRADOR CHUEQUEAR SI EL USUARIO ES ADMINSTRADOR
                    if (!$administrador) {
                        if ($_SESSION['user_data']['emp_id'] == 1) {
                            $administrador['grup_empid'] = 1;
                        } else {
                            $administrador['grup_empid'] = '';
                        }
                    }

                    $newComentarios = new TablerosListasTareasComentarios();
                    $comentario = $newComentarios->obtener($id_comentario);

                    if ($comentario) {
                        if ($administrador['grup_empid'] !== '' || $comentario['com_empid'] == $_SESSION['user_data']['emp_id']) {
                            if ($newComentarios->editar($id_comentario, [
                                'com_descripcion' => $descripcion
                            ])) {
                                $comentario = $newComentarios->obtener($id_comentario);
                                Http::json_response([
                                    'fecha' => date('d/m/Y', strtotime($comentario['com_actualizado'])) . ' a las ' . date('h:i A', strtotime($comentario['com_actualizado']))
                                ]);
                            } else {
                                Http::json_response(false);
                            }
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerComentarios(int $id_tarea)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($id_tarea)) {

                $tarea = $this->solicitud->sanitize($id_tarea, FILTER_SANITIZE_NUMBER_INT);

                $newComentarios = new TablerosListasTareasComentarios();

                $list_comentario = [];

                $data = $newComentarios->obtenerComentarios($tarea);

                if (is_countable($data) && count($data)) {
                    foreach ($data as $row) {
                        $list_comentario[] = [
                            'id' => $row['com_id'],
                            'descripcion' => $row['com_descripcion'],
                            'fecha' => $row['actualizado'],
                            'empleado' => $row['einfo_nombres'] . ' ' .  $row['einfo_apellidos']
                        ];
                    }
                }

                header('Content-Type: application/json');
                echo json_encode($list_comentario);
                exit();
            } else {
                header('Content-Type: application/json');
                echo json_encode(false);
                exit();
            }
        }
    }

    public function editarFavorito()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $_POST = json_decode(file_get_contents('php://input'), true);

            $id  = filter_var($_POST['id_tab'], FILTER_SANITIZE_NUMBER_INT);
            $favorite = filter_var($_POST['favorite'], FILTER_SANITIZE_NUMBER_INT);

            if ($this->tableros->existe('tab_id', $id)) {
                if ($this->tableros->editar($id, [
                    'tab_favorite' => $favorite
                ])) {
                    Http::json_response(true);
                } else {
                    $this->array_errors[] = 'Error de operacion.';
                }
            } else {
                $this->array_errors[] = 'Error.';
            }
        }
    }

    public function obtenerFavorito()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $list_tableros = [];
            $tableros = $this->tableros->obtenerFavorito();
            $new_grupos =  new TablerosGrupos();

            $new_miembros = new TablerosListasTareasMiembros();

            if (is_countable($tableros) && count($tableros)) {

                $new_grupos = new TablerosGrupos();

                foreach ($tableros as $row) {

                    $miembro =  $new_miembros->chequearMiembro($row['tab_id'], $_SESSION['user_data']['einfo_id']);
                    $administrador = $new_grupos->chequearAdministrador($row['tab_id'], $_SESSION['user_data']['emp_id']);

                    if ($miembro || $_SESSION['user_data']['einfo_id'] == 1 || $administrador) {

                        $grupos = $new_grupos->obtenerGrupo($row['tab_id']);

                        $list_tableros[] = [
                            'id' => $row['tab_id'],
                            'nombre' => ucwords($row['tab_nombre']),
                            'empleado' => $row['tab_empid'],
                            'color' => $row['tab_color'],
                            'modificacion' => ucfirst($row['modificacion']),
                            'uri' => ruta_base() . 'servicios/tablista?tablero=' . $row['tab_id'],
                            'grupos' => $grupos ?? []
                        ];
                    }
                }
            }

            header('Content-Type: application/json');
            echo json_encode($list_tableros);
            exit();
        }
    }
}
