<?php

namespace App\Controladores;

use App\Modelos\Series;
use App\Modelos\Sucursal;
use Core\Controller;
use Core\Vista;

final class SeriesControlador extends Controller
{
    private $series;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->series = new Series();
    }

    public function index()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $sucursal = new Sucursal();
            return Vista::viewAJAX('series/index', [
                'sucursales' => $sucursal->todos()
            ]);
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($_SESSION['user_data']['emp_id'] == 1) {

                $ser_impuesto       = filter_input(INPUT_POST, 'mascara', FILTER_SANITIZE_STRING) ?? 0;
                $ser_codigo         = filter_input(INPUT_POST, 'codigo', FILTER_SANITIZE_STRING);
                $ser_descripcion    = filter_input(INPUT_POST, 'nombre', FILTER_SANITIZE_STRING);
                $ser_sucursal       = filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_STRING);

                if (empty($ser_codigo))
                    $this->array_errors[] = "El campo Codigo es obligatorio.";
                if (empty($ser_descripcion))
                    $this->array_errors[] = "El campo Nombre es obligatorio.";
                if (empty($ser_sucursal))
                    $this->array_errors[] = "El campo Sucursal es obligatorio.";

                if (empty($this->array_errors)) {

                    if (empty($_POST['id'])) {
                        if ($this->series->where(['ser_codigo' => $ser_codigo], true))
                            $this->array_errors[] = "El codigo $ser_codigo ya se encuentra en uso";
                    } else {
                        $ser_id = filter_var($_POST['id'], FILTER_SANITIZE_NUMBER_INT);
                        if ($this->series->where(['ser_codigo' => $ser_codigo, 'ser_id!=' => $ser_id], true))
                            $this->array_errors[] = "El codigo $ser_codigo ya se encuentra en uso";
                    }

                    if (empty($this->array_errors)) {
                        if (empty($_POST['id'])) {
                            header('Content-Type: application/json', true);
                            echo json_encode($this->series->guardar([
                                'ser_impuesto'     => $ser_impuesto,
                                'ser_codigo'       => $ser_codigo,
                                'ser_descripcion'  => $ser_descripcion,
                                'ser_sucursal'     => $ser_sucursal
                            ], true));
                            exit;
                        } else {
                            header('Content-Type: application/json', true);
                            echo json_encode($this->series->editar($ser_id, [
                                'ser_impuesto'     => $ser_impuesto,
                                'ser_codigo'       => $ser_codigo,
                                'ser_descripcion'  => $ser_descripcion,
                                'ser_sucursal'     => $ser_sucursal
                            ]));
                            exit;
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Usted no es administrador';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function eliminar(int $id_serie)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_serie = filter_var($id_serie, FILTER_SANITIZE_NUMBER_INT);

            if ($this->series->existe('ser_id', $id_serie)) {
                if ($this->series->chequearForanea($id_serie)) {
                    $this->array_errors[] = "La serie no se puede ELIMINAR ya que se encuentra en uso";
                } else {
                    header('Content-Type: application/json', true);
                    echo json_encode($this->series->eliminar($id_serie));
                    exit;
                }
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function obtenerSeries()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->series->obtenerSeries());
            exit;
        }
    }
}
