<form autocomplete="off" @submit.prevent="buscarLineas" id="form_modal_lineas">
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal_lineas">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Buscar en detalles de Facturas</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text bg-white"><i class="fa fa-search"></i></span>
                            </div>
                            <input type="text" id="input_buscar_lineas" class="form-control" placeholder="Buscar..." @keyup="buscarLineas($event)" style="margin-right: 3px;">
                            <div class="input-group-append">
                                <button class="btn btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Filtrar por...</button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="#" @click.prevent="filtrarPor(1)">En espera</a>
                                    <a class="dropdown-item" href="#" @click.prevent="filtrarPor(2)">Pagadas</a>
                                    <a class="dropdown-item" href="#" @click.prevent="filtrarPor(3)">Artículo</a>
                                    <a class="dropdown-item" href="#" @click.prevent="filtrarPor(4)">Cliente</a>
                                    <a class="dropdown-item" href="#" @click.prevent="filtrarPor(5)">Observaciones</a>
                                </div>
                            </div>

                        </div>
                        <small class="form-text text-muted">{{ lineas.length }} resultados en <span id="mostrar_nombre_filtro">En espera</span> </small>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-hover table-striped" :class="cargando_lineas">
                            <thead>
                                <tr>
                                    <th class="text-left" style="width: 35%;">Documento + Cliente</th>
                                    <th class="text-center" style="width: 10%;">Cantidad</th>
                                    <th class="text-left" style="width: 30%;">Artículo</th>
                                    <th class="text-center" style="width: 10%;">Total</th>
                                    <th class="text-center" style="width: 15%;">Fecha</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="row in lineas">
                                    <td class="text-left"><a :href="row.ruta_documento" rel="noopener noreferrer">{{ row.correlativo }}</a> {{ row.cliente }}</td>
                                    <td class="text-center">{{ row.cantidad }}</td>
                                    <td class="text-left"><a :href="row.ruta_producto" target="_blank" rel="noopener noreferrer">{{ row.art_codigo }}</a> {{ row.art_nombre }}</td>
                                    <td class="text-right">{{ row.total }}</td>
                                    <td class="text-right">{{ row.fecha }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-sm btn-secondary" data-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>
</form>