<!-- Modal adjunto -->
<div class="modal fade" id="modal_adjunto" tabindex="-1" aria-labelledby="modal_adjunto" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Documentos</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="#" enctype="multipart/form-data" autocomplete="off" @submit.prevent="enviarDocumento">
                    <div class="form-group">
                        <label for="doc_descripcion">Descripción</label>
                        <input type="text" class="form-control" placeholder="Descripcion" maxlength="50" v-model="formDocumentos.descripcion">
                    </div>
                    <div class="form-group">
                        <label for="doc_archivo">Documento</label>
                        <input type="file" class="form-control" id="file" ref="file" v-on:change="handleFileUpload()" accept=".jpg,.png,.pdf">
                        <small class="form-text text-muted">Solo archivos con formato PDF, PNG o JPG y maximo de 1MB</small>
                    </div>
                    <div class="form-group">
                        <button type="button" class="btn btn-info btn-border" disabled v-if="cargando_documento">
                            <span class="btn-label"><i class="loader loader-info"></i></span>
                        </button>
                        <button v-else type="submit" class="btn btn-info btn-border">Enviar</button>
                    </div>
                </form>
                <div class="row">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Descripción</th>
                                <th>Documento</th>
                                <th>Fecha</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in documentosAdjunto">
                                <td>{{ row.descripcion }}</td>
                                <td>
                                    <a v-if="documento==1" :href="'<?= constant('IMG_URI') ?>documentos_ventas/notas_de_entrega/' + row.archivo" :download="row.archivo">
                                        <img v-if="row.imagen" :src="'<?= constant('IMG_URI') ?>documentos_ventas/notas_de_entrega/' + row.archivo" alt="" class="rounded-circle border border-white" width="50" height="50">
                                        <span v-else class="text-info"><span class="far fa-file-archive"></span></span>
                                        {{row.archivo}}
                                    </a>
                                    <a v-if="documento==2" :href="'<?= constant('IMG_URI') ?>documentos_ventas/facturas/' + row.archivo" :download="row.archivo">
                                        <img v-if="row.imagen" :src="'<?= constant('IMG_URI') ?>documentos_ventas/facturas/' + row.archivo" alt="" class="rounded-circle border border-white" width="50" height="50">
                                        <span v-else class="text-info" ><span class="far fa-file-archive"></span></span>
                                        {{row.archivo}}
                                    </a>
                                </td>
                                <td>{{ row.fecha }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>