<?php

namespace App\Controladores;

use App\Modelos\CarritoVentasModel;
use App\Modelos\Cliente;
use App\Modelos\Clientedireccionenvios;
use App\Modelos\Convertirdocumento;
use App\Modelos\Empleado;
use App\Modelos\EmpleadoAgente;
use App\Modelos\EmpleadoInfo;
use App\Modelos\EmpleadosComisionesEmplAgente;
use App\Modelos\EmpleadoSucursales;
use App\Modelos\FacturaDocumentos;
use App\Modelos\MovimientoModel;
use App\Modelos\Notadecredito;
use App\Modelos\NotadeCreditoDetalles;
use Core\Controller;
use Core\Vista;
use App\Modelos\Notasdeentrega;
use App\Modelos\NotasdeentregaArticulos;
use App\Modelos\NotasdeentregaDocumentos;
use App\Modelos\Pedidos;
use App\Modelos\PedidosArticulos;
use App\Modelos\VentasHistoricoEmail;
use App\Modelos\Pos;
use App\Modelos\PosArticulos;
use App\Modelos\ProductosCompuestos;
use App\Modelos\Presupuesto;
use App\Modelos\PresupuestoArticulos;
use App\Modelos\PresupuestoDocumentos;
use Core\Librerias\Module;
use Core\Helpers\Moneda;
use Core\Helpers\Notifica;
use Core\Librerias\Http;
use Core\Librerias\CarritoPtv;
use Core\Librerias\CarritoPtvEditar;
use Core\Librerias\Seguridad;
use DateTime;
use DateTimeZone;
use Exception;
use PHPMailer\PHPMailer\PHPMailer;

final class PtvControlador extends Controller
{
    private $array_errors = [];
    private $carritoVentas;

    public function __construct()
    {
        parent::__construct();
        $this->module   = new Module('ptv');
        $this->carritoVentas = new CarritoPtv();
        $this->carritoVentasEditar = new CarritoPtvEditar();
    }

    public function index()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {

            if (isset($_GET['factura'])) {
                $id_factura = filter_var($_GET['factura'], FILTER_SANITIZE_NUMBER_INT);
                $tipo = filter_var($_GET['tipo'], FILTER_SANITIZE_NUMBER_INT);


                $tipod = "";
                if ($tipo == 1) {
                    $this->notas_entrega_model = new Notasdeentrega();
                    $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    $impresoras = $this->notas_entrega_model->consultar("SELECT imp_id id, imp_descripcion impresora, imp_tipo tipo FROM app_impresoras WHERE imp_tipo = 2 AND imp_estatus = 1")->all();
                    $imp_ticket = $this->notas_entrega_model->consultar("SELECT imp_id id, imp_descripcion impresora FROM app_impresoras WHERE imp_estatus = 1 AND imp_tipo = 2")->all();
                    $tipod = "ne";
                }
                if ($tipo == 2) {
                    $this->notas_entrega_model = new Pos();
                    $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    $impresoras = $this->notas_entrega_model->consultar("SELECT imp_id id, imp_descripcion impresora FROM app_impresoras WHERE imp_estatus = 1 AND imp_tipo = 1")->all();
                    $imp_ticket = $this->notas_entrega_model->consultar("SELECT imp_id id, imp_descripcion impresora FROM app_impresoras WHERE imp_estatus = 1 AND imp_tipo = 2")->all();
                    $tipod = "fm";
                }
                if ($tipo == 3) {
                    $this->notas_entrega_model = new Presupuesto();
                    $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    $impresoras = [];
                    $imp_ticket = [];
                    $tipod = "pre";
                }
                if ($tipo == 4) {
                    $this->notas_entrega_model = new Pedidos();
                    $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    $impresoras = [];
                    $imp_ticket = [];
                    $tipod = "pe";
                }

                $factor = 0;
                $not_model = new Notasdeentrega();
                if ($this->module->has_module_action_permission('ptv', 'precio_dolar_bs', $_SESSION['user_data']['emp_id'])) {
                    $divisa_factor = $this->notas_entrega_model->obtenerDivisaAlCambio(2, 1);
                    if ($divisa_factor) {
                        $factor = Moneda::moneda($divisa_factor['df_factor'], 'de-DE', 'Bs');
                    }
                }

                return Vista::viewPtv('ptv/index', [
                    'id'                    => $id_factura,
                    'impresoras'            => $impresoras,
                    'dollar'                => $factor,
                    'imp_ticket'            => $imp_ticket,
                    'tipo_doc'              => $tipo,
                    'permiso_dollar'        => $this->module->has_module_action_permission('ptv', 'precio_dolar_bs', $_SESSION['user_data']['emp_id']),
                    'cambiar_factor'        => $this->module->has_module_action_permission('facturacion', 'cambiar_factor', $_SESSION['user_data']['emp_id']),
                    'anular_doc'            => $this->module->has_module_action_permission('facturacion', 'anular_doc', $_SESSION['user_data']['emp_id']),
                    'seleccionar_agente'    => $this->module->has_module_action_permission('ptv', 'seleccionar_agente', $_SESSION['user_data']['emp_id']),
                    'total_costo'           => $this->module->has_module_action_permission('ptv', 'total_costo', $_SESSION['user_data']['emp_id']),
                    'eliminar_pago'         => $this->module->has_module_action_permission('facturacion', 'eliminar_pagos', $_SESSION['user_data']['emp_id']),
                    'cambiar_precio'         => $this->module->has_module_action_permission('facturacion', 'cambiar_precio', $_SESSION['user_data']['emp_id']),
                    'auth_descuento'         => $this->module->has_module_action_permission('empleados', 'auth_descuento', $_SESSION['user_data']['emp_id']),
                    'per_pagar'             => $this->module->has_module_action_permission('facturacion', 'pagar', $_SESSION['user_data']['emp_id']),
                    'menu_imagen'            => $this->module->has_module_action_permission('ptv', 'menu_imagen', $_SESSION['user_data']['emp_id']),
                    'crear_nota'            => $this->module->has_module_action_permission('ptv', 'crear_nota', $_SESSION['user_data']['emp_id']),
                    'crear_factura'         => $this->module->has_module_action_permission('ptv', 'crear_factura', $_SESSION['user_data']['emp_id']),
                    'categorias'            => $this->carritoVentas->obtenerTodasCategorias(),
                    'categoria_cinc'        => $this->carritoVentas->obtenerCincoMejoresCategorias(),
                    'almacenes'             => $this->carritoVentas->obtenerAlmacenes(),
                    'series'                => $this->carritoVentas->obtenerSeries(),
                    'divisas'               => $this->carritoVentasEditar->obtenerDivisasParaFacturar(),
                    'empleados'             => $this->carritoVentas->obtenerEmpleados(),
                    'empleados_agentes'     => $this->carritoVentasEditar->obtenerAgentesdeVenta(),
                    'empresa'               => $this->carritoVentas->obtenerDatosEmpresa(),
                    'tipos_de_documentos'   => $this->carritoVentas->obternerTiposDeDocumentos(),
                    'cuentaCompraBolivares' => $not_model->obtenerCuentasDiferenteUsd(),
                    'cliente'               => $this->carritoVentas->obtenerCliente($factura[$tipod . '_cliid']),
                ]);
            } else {
                //$serie = $this->carritoVentas->obtenerSeriesEmpleado();
                $this->notas_entrega_model = new Notasdeentrega();
                $factor = 0;
                if ($this->module->has_module_action_permission('ptv', 'precio_dolar_bs', $_SESSION['user_data']['emp_id'])) {
                    $divisa_factor = $this->notas_entrega_model->obtenerDivisaAlCambio(2, 1);
                    if ($divisa_factor) {
                        $factor = Moneda::moneda($divisa_factor['df_factor'], 'de-DE', 'Bs');
                    }
                }


                return Vista::viewPtv('ptv/index', [
                    'id'               => 0,
                    'tipo_doc'         => 0,
                    'dollar'                => $factor,
                    'permiso_dollar'        => $this->module->has_module_action_permission('ptv', 'precio_dolar_bs', $_SESSION['user_data']['emp_id']),
                    'cambiar_factor'        => $this->module->has_module_action_permission('facturacion', 'cambiar_factor', $_SESSION['user_data']['emp_id']),
                    'anular_doc'            => $this->module->has_module_action_permission('facturacion', 'anular_doc', $_SESSION['user_data']['emp_id']),
                    'eliminar_pago'         => $this->module->has_module_action_permission('facturacion', 'eliminar_pagos', $_SESSION['user_data']['emp_id']),
                    'seleccionar_agente'     => $this->module->has_module_action_permission('ptv', 'seleccionar_agente', $_SESSION['user_data']['emp_id']),
                    'total_costo'            => $this->module->has_module_action_permission('ptv', 'total_costo', $_SESSION['user_data']['emp_id']),
                    'cambiar_precio'         => $this->module->has_module_action_permission('facturacion', 'cambiar_precio', $_SESSION['user_data']['emp_id']),
                    'auth_descuento'         => $this->module->has_module_action_permission('empleados', 'auth_descuento', $_SESSION['user_data']['emp_id']),
                    'per_pagar'             => $this->module->has_module_action_permission('facturacion', 'pagar', $_SESSION['user_data']['emp_id']),
                    'menu_imagen'            => $this->module->has_module_action_permission('ptv', 'menu_imagen', $_SESSION['user_data']['emp_id']),
                    'crear_nota'            => $this->module->has_module_action_permission('ptv', 'crear_nota', $_SESSION['user_data']['emp_id']),
                    'crear_factura'            => $this->module->has_module_action_permission('ptv', 'crear_factura', $_SESSION['user_data']['emp_id']),
                    'categorias'            => $this->carritoVentas->obtenerTodasCategorias(),
                    'categoria_cinc'        => $this->carritoVentas->obtenerCincoMejoresCategorias(),
                    'almacenes'             => $this->carritoVentas->obtenerAlmacenesEmpleado(),
                    'series'                => $this->carritoVentas->obtenerSeriesEmpleado(),
                    'empleados_agentes'     => $this->carritoVentasEditar->obtenerAgentesdeVenta(),
                    'divisas'               => $this->carritoVentas->obtenerDivisasParaFacturar(),
                    'empleados'             => $this->carritoVentas->obtenerEmpleados(),
                    'tipos_de_documentos'   => $this->carritoVentas->obternerTiposDeDocumentos(),
                    'cuentaCompraBolivares' => $this->notas_entrega_model->obtenerCuentasSegunMetodo(4),
                ]);
            }
        }
        // return Vista::viewPtv('ptv/index');
    }

    public function obtenerAgenteCliente(int $id)
    {
        $new_agente = new EmpleadoInfo();

        if ($new_agente->existe('einfo_id', $id)) {

            $agente = $new_agente->obtener($id);

            Http::json_response($agente);
        } else {
            Http::json_response(false);
        }
    }

    public function chequearAgente()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            $id_cliente = filter_input(INPUT_POST, 'id_cliente', FILTER_SANITIZE_NUMBER_INT);
            $id_agente = filter_input(INPUT_POST, 'id_agente', FILTER_SANITIZE_NUMBER_INT);
            $factura = filter_input(INPUT_POST, 'factura', FILTER_SANITIZE_NUMBER_INT);
            $tipo = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);

            $newAgent = new EmpleadoAgente();

            $agent = $newAgent->consultar("SELECT * FROM app_empleados_agentes WHERE empagent_empid = {$id_agente} AND empagent_clientid = {$id_cliente} AND empagent_docid={$factura} AND empagent_tipo=$tipo")->row();

            if (!$agent && $newAgent->guardar([
                'empagent_empid' => $id_agente,
                'empagent_clientid'  => $id_cliente,
                'empagent_captado' => '',
                'empagent_tipo' => $tipo,
                'empagent_docid' => $factura
            ], true)) {
                $result = '';
                if ($tipo == 1) {
                    $this->notas_entrega_model = new Notasdeentrega();
                    $result = $this->notas_entrega_model->editar($factura, [
                        'ne_empagente'          => $id_agente,
                    ]);
                    if ($result && $this->carritoVentasEditar->recalcularComisiones($factura, 1)) {
                        Http::json_response(true);
                    } else {
                        Http::json_response(false);
                    }
                }
            } else {
                Http::json_response(false);
            }
        }
    }

    public function actualizar_agente()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            $id_cliente = filter_input(INPUT_POST, 'id_cliente', FILTER_SANITIZE_NUMBER_INT);
            $id_agente = filter_input(INPUT_POST, 'id_agente', FILTER_SANITIZE_NUMBER_INT);
            $agente_anterior = filter_input(INPUT_POST, 'agente_anterior', FILTER_SANITIZE_NUMBER_INT);
            $factura = filter_input(INPUT_POST, 'factura', FILTER_SANITIZE_NUMBER_INT);
            $tipo = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);

            $this->array_errors=[];
            $newAgent = new EmpleadoAgente();

            if ($this->esEditable($factura,$tipo)) {
                $agent = $newAgent->consultar("SELECT * FROM app_empleados_agentes WHERE empagent_empid = {$agente_anterior} AND empagent_clientid = {$id_cliente} AND empagent_docid={$factura} AND empagent_tipo={$tipo}")->row();

                if ($agent) {
                    $id = $agent['empagent_id'];
                    $comisiones = $newAgent->consultar("SELECT * FROM app_comisiones_agente_fn WHERE comagentefn_fnempagente={$agente_anterior} AND comagentefn_fnid={$factura} AND comagentefn_fntipo=1")->row();

                    if ($comisiones && $comisiones['comagentefn_estatus'] == 0) {
                        $newAgent->consultar("DELETE FROM app_comisiones_agente_fn WHERE comagentefn_fnempagente={$agente_anterior} AND comagentefn_fnid={$factura} AND comagentefn_fntipo=1")->run();
                        if ($newAgent->editar($id, [
                            'empagent_empid' => $id_agente
                        ], true)) {
                            $this->notas_entrega_model->editar($factura, [
                                'ne_empagente'          => $id_agente
                            ]);

                            $this->carritoVentasEditar->recalcularComisiones($factura,$tipo);

                            Http::json_response(true);
                        } else {
                            Http::json_response(false);
                        }
                    } else {
                        if (!$comisiones) {
                            if ($newAgent->editar($id, [
                                'empagent_empid' => $id_agente
                            ], true)) {
                                $this->notas_entrega_model->editar($factura, [
                                    'ne_empagente'          => $id_agente
                                ]);

                                $this->carritoVentasEditar->recalcularComisiones($factura, $tipo);

                                Http::json_response(true);
                            } else {
                                Http::json_response(false);
                            }
                        } else {
                            $this->array_errors[] = 'Comision ya pagada en su totalidad';
                        }
                    }
                } else {
                    Http::json_response(false);
                }
            } else {
                $this->array_errors[] = 'El documento no puede ser editado';
                Http::json_response(['errors' => $this->array_errors]);
            }
        }
    }

    public function obtenerSeriesAlmacenesEmpleado(int $sucursales)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $sucursales = filter_var($sucursales, FILTER_SANITIZE_NUMBER_INT);

            $series = $this->carritoVentas->obtenerSeriesEmpleadoSucursales($sucursales);
            $almacenes = $this->carritoVentas->obtenerAlmacenesEmpleadoSucursales($sucursales);

            $idser = '';
            foreach ($series as $row) {
                if ($row['empser_predeterminado'] == 1) {
                    $idser = $row['empser_serid'];
                }
            }

            $idalm = '';
            foreach ($almacenes as $row) {
                if ($row['empalm_predeterminado'] == 1) {
                    $idalm = $row['empalm_almid'];
                }
            }

            if ($idalm == "" && count($almacenes) > 0) {
                $idalm = $almacenes[0]['empalm_almid'];
            }

            if ($idser == "" && count($series) > 0) {
                $idser = $series[0]['empser_serid'];
            }

            Http::json_response([
                'series' => $series,
                'id_ser' => $idser,
                'almacenes' => $almacenes,
                'id_alm' => $idalm
            ]);
        }
    }

    public function pdfpre()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD']) {
            $id = filter_var($_GET['factura'], FILTER_SANITIZE_NUMBER_INT);
            $tipo = filter_var($_GET['tipo'], FILTER_SANITIZE_NUMBER_INT);

            if ($tipo == 3) {
                $this->notas_entrega_model = new Presupuesto();
                $factura_data = $this->notas_entrega_model->obtenerFacturaCompleta($id);
                if (!$factura_data) {
                    Http::notFound();
                }

                $tipod = "pre";
                $articulos_model    = new PresupuestoArticulos();
                $url = 'pdffacturas/presupuesto/';
            }
            if ($tipo == 4) {
                $this->notas_entrega_model = new Pedidos();
                $factura_data = $this->notas_entrega_model->obtenerFacturaCompleta($id);
                if (!$factura_data) {
                    Http::notFound();
                }
                $tipod = "pe";
                $articulos_model    = new PedidosArticulos();
                $url = 'pdffacturas/pedidos/';
            }

            $articulos_data     = $articulos_model->articulos($factura_data[$tipod . '_id']);
            $cliente_data       = $this->carritoVentasEditar->obtenerCliente($factura_data[$tipod . '_cliid']);
            $empresa_data       = $this->carritoVentasEditar->obtenerDatosEmpresa();
            $documento_data     = $this->carritoVentasEditar->obtenerDocumento($tipo);
            $sucursal = $this->notas_entrega_model->obtenerSucursal($factura_data[$tipod . '_surcid']);
            $factCompra =  $factCompra = $empresa_data['emp_iva'];
            // nota de entrega
            $mascara = mascara_correlativo($documento_data['doc_prefijo'], $factura_data['ser_impuesto'], $factura_data[$tipod . '_correlativo']);
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'margin_left'   => 15,
                'margin_right'  => 15,
                'margin_top'    => 35,
                'margin_bottom' => 30,
                'margin_header' => 15,
                'margin_footer' => 30,
                'format' => 'A4',
                'orientation' => 'P',
                'default_font_size' => 8,
                'default_font' => 'helvetica'
            ]);
            $mpdf->SetTitle($mascara);
            $mpdf->SetAuthor($empresa_data['emp_nombre']);
            $mpdf->SetCreator($empresa_data['emp_nombre']);
            $mpdf->SetSubject($mascara);
            $html_header = Vista::viewPDF('pdffacturas/factura/header', [
                'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
                'emp_rif'       => $empresa_data['emp_rif'] ?? '',
                'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
                'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
                'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
                'emp_estado'    => $empresa_data['emp_estado'] ?? '',
                'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
            ]);
            $mpdf->SetHTMLHeader($html_header);
            $html_body = Vista::viewPDF($url . 'body', [
                'factura'       => $mascara,
                'sucursal'      => $sucursal['su_nombre'] . '-' . $sucursal['su_direccion'],
                'iva_integrado' => $factCompra,
                'cliente'       => $cliente_data['cli_razon_social'],
                'direccion'     => $cliente_data['cli_direccion'],
                'fecha'         => date('Y-m-d', strtotime($factura_data[$tipod . '_fecha'])),
                'cedularif'     => $cliente_data['tipodoc_codigo'] . '' . $cliente_data['cli_dni'],
                'telefono'      => $cliente_data['cli_telefono'],
                'div_locale'    => $factura_data['div_locale'],
                'div_simbolo'  => $factura_data['div_simbolo'],
                'articulos'     => $articulos_data,
                'observaciones' => $factura_data[$tipod . '_observaciones']
            ]);
            $mpdf->WriteHTML($html_body);

            if ($tipo == 3) {
                if ($factCompra) {
                    $subtotal = 0;
                    $neto = 0;
                    $total = 0;
                    foreach ($articulos_data as $row) {
                        $iv = convertir_a_float($row['preart_proprecio'] + ($row['preart_proprecio'] * ($row['imp_valor'] / 100))) ?? 0;
                        $descuentoprod = convertir_a_float(($row['preart_procantidad'] * $iv) * ($row['preart_prodescuento'] / 100)) ?? 0;
                        $subtotal += convertir_a_float(($row['preart_procantidad'] * $iv) - $descuentoprod);
                        $neto += convertir_a_float(($row['preart_procantidad'] * $iv) - $descuentoprod);
                        $total += convertir_a_float(($row['preart_procantidad'] * $iv) - $descuentoprod);
                    }
                    $descuento = convertir_a_float(($total * ($factura_data['pre_descuento'] / 100))) ?? 0;
                    $html_footer = Vista::viewPDF($url . 'footer', [
                        'div_locale'    => $factura_data['div_locale'],
                        'div_simbolo'  => $factura_data['div_simbolo'],
                        'iva_integrado' => $factCompra,
                        'total'         => $total - $descuento,
                        'iva'           => $factura_data['pre_iva'],
                        'neto'          => $neto,
                        'descuento'     => $factura_data['pre_descuento']
                    ]);
                } else {
                    $html_footer = Vista::viewPDF($url . 'footer', [
                        'div_locale'    => $factura_data['div_locale'],
                        'div_simbolo'  => $factura_data['div_simbolo'],
                        'iva_integrado' => $factCompra,
                        'total'         => $factura_data['pre_total'],
                        'iva'           => $factura_data['pre_iva'],
                        'neto'          => $factura_data['pre_neto'],
                        'descuento'     => $factura_data['pre_descuento']
                    ]);
                }
            } else {
                if ($factCompra) {
                    $subtotal = 0;
                    $neto = 0;
                    $total = 0;
                    foreach ($articulos_data as $row) {

                        $iv = convertir_a_float($row['peart_proprecio'] + ($row['peart_proprecio'] * ($row['imp_valor'] / 100))) ?? 0;
                        $descuentoprod = convertir_a_float(($row['peart_procantidad'] * $iv) * ($row['peart_prodescuento'] / 100)) ?? 0;
                        $subtotal += convertir_a_float(($row['peart_procantidad'] * $iv) - $descuentoprod);
                        $neto += convertir_a_float(($row['peart_procantidad'] * $iv) - $descuentoprod);
                        $total += convertir_a_float(($row['peart_procantidad'] * $iv) - $descuentoprod);
                    }
                    $descuento = convertir_a_float(($total * ($factura_data['pe_descuento'] / 100))) ?? 0;
                    $html_footer = Vista::viewPDF($url . 'footer', [
                        'div_locale'    => $factura_data['div_locale'],
                        'div_simbolo'  => $factura_data['div_simbolo'],
                        'iva_integrado' => $factCompra,
                        'total'         => $total - $descuento,
                        'iva'           => $factura_data['pe_iva'],
                        'neto'          => $neto,
                        'descuento'     => $factura_data['pe_descuento']
                    ]);
                } else {
                    $html_footer = Vista::viewPDF($url . 'footer', [
                        'div_locale'    => $factura_data['div_locale'],
                        'iva_integrado' => $factCompra,
                        'div_simbolo'  => $factura_data['div_simbolo'],
                        'total'         => $factura_data['pe_total'],
                        'iva'           => $factura_data['pe_iva'],
                        'neto'          => $factura_data['pe_neto'],
                        'descuento'     => $factura_data['pe_descuento']
                    ]);
                }
            }

            $mpdf->SetHTMLFooter($html_footer);
            $mpdf->Output("$mascara.pdf", \Mpdf\Output\Destination::INLINE);
            exit;
        }
    }

    public function enviarFacturapre()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id     = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
            $de     = filter_input(INPUT_POST, 'de', FILTER_SANITIZE_EMAIL);
            $para   = filter_input(INPUT_POST, 'para', FILTER_SANITIZE_EMAIL);
            $copia  = filter_input(INPUT_POST, 'copia', FILTER_SANITIZE_EMAIL);
            $firma  = filter_input(INPUT_POST, 'firma', FILTER_SANITIZE_EMAIL);
            $tipo   = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);

            if (empty($de))
                $this->array_errors[] = 'El campo De es obligatorio.';
            if (empty($para))
                $this->array_errors[] = 'El campo Para es obligatorio.';

            if (empty($this->array_errors) && !empty($id)) {

                if ($tipo == 3) {
                    $this->notas_entrega_model = new Presupuesto();
                    $data_factura = $this->notas_entrega_model->obtener($id);
                    $tipod = 'pre';
                    $articulos_model    = new PresupuestoArticulos();
                    $url = 'pdffacturas/presupuesto/';
                }
                if ($tipo == 4) {
                    $this->notas_entrega_model = new Pedidos();
                    $data_factura = $this->notas_entrega_model->obtener($id);
                    $tipod = 'pe';
                    $articulos_model    = new PedidosArticulos();
                    $url = 'pdffacturas/pedidos/';
                }

                $newVentasHistoricoEmail = new VentasHistoricoEmail();
                $data_factura = $this->notas_entrega_model->obtener($id);
                $factura_data = $this->notas_entrega_model->obtenerFacturaCompleta($id);

                $articulos_data     = $articulos_model->articulos($factura_data[$tipod . '_id']);
                $cliente_data       = $this->carritoVentasEditar->obtenerCliente($factura_data[$tipod . '_cliid']);
                $empresa_data       = $this->carritoVentasEditar->obtenerDatosEmpresa();
                $documento_data     = $this->carritoVentasEditar->obtenerDocumento($tipo);
                // presupuesto
                $mascara = mascara_correlativo($documento_data['doc_prefijo'], $factura_data['ser_impuesto'], $factura_data[$tipod . '_correlativo']);
                $mpdf = new \Mpdf\Mpdf([
                    'mode' => 'utf-8',
                    'margin_left'   => 15,
                    'margin_right'  => 15,
                    'margin_top'    => 35,
                    'margin_bottom' => 30,
                    'margin_header' => 15,
                    'margin_footer' => 30,
                    'format' => 'A4',
                    'orientation' => 'P',
                    'default_font_size' => 8,
                    'default_font' => 'helvetica'
                ]);
                $mpdf->SetTitle($mascara);
                $mpdf->SetAuthor($empresa_data['emp_nombre']);
                $mpdf->SetCreator($empresa_data['emp_nombre']);
                $mpdf->SetSubject($mascara);
                $html_header = Vista::viewPDF('pdffacturas/factura/header', [
                    'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
                    'emp_rif'       => $empresa_data['emp_rif'] ?? '',
                    'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
                    'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
                    'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
                    'emp_estado'    => $empresa_data['emp_estado'] ?? '',
                    'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
                ]);
                $mpdf->SetHTMLHeader($html_header);
                $html_body = Vista::viewPDF($url . 'body', [
                    'factura'       => $mascara,
                    'cliente'       => $cliente_data['cli_razon_social'],
                    'direccion'     => $cliente_data['cli_direccion'],
                    'fecha'         => date('Y-m-d', strtotime($factura_data[$tipod . '_fecha'])),
                    'cedularif'     => $cliente_data['tipodoc_codigo'] . '' . $cliente_data['cli_dni'],
                    'telefono'      => $cliente_data['cli_telefono'],
                    'div_locale'    => $factura_data['div_locale'],
                    'div_simbolo'  => $factura_data['div_simbolo'],
                    'articulos'     => $articulos_data,
                    'observaciones' => $factura_data[$tipod . '_observaciones']
                ]);
                $mpdf->WriteHTML($html_body);
                $html_footer = Vista::viewPDF($url . 'footer', [
                    'div_locale'    => $factura_data['div_locale'],
                    'div_simbolo'  => $factura_data['div_simbolo'],
                    'total'         => $factura_data[$tipod . '_total'],
                    'iva'           => $factura_data[$tipod . '_iva'],
                    'neto'          => $factura_data[$tipod . '_neto'],
                    'descuento'     => $factura_data[$tipod . '_descuento']
                ]);
                $mpdf->SetHTMLFooter($html_footer);
                $content = $mpdf->Output('', 'S');
                $mail = new PHPMailer(true);
                try {

                    $mail->isSMTP();
                    $mail->Host       = "{$empresa_data['emp_host_correo']}";
                    $mail->SMTPAuth   = true;
                    $mail->Username   = "{$empresa_data['emp_email']}";
                    $mail->Password   = "{$empresa_data['emp_email_password']}";
                    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                    $mail->Port       = $empresa_data['emp_port_correo'];

                    $mail->setFrom($de);
                    $mail->addAddress($para);
                    $mail->addReplyTo($de, 'Empresa');

                    if (!empty($copia)) {
                        $mail->addAddress($copia);
                    }

                    $mail->addStringAttachment($content, "$mascara.pdf");

                    $mail->isHTML(true);
                    $mail->Subject = ($tipo == 3) ? 'PRESUPUESTO' : 'PEDIDO';
                    $mail->Body    = "$mascara";

                    $mail->send();

                    if ($tipo == 3) {
                        $newVentasHistoricoEmail->guardar([
                            'venhisemail_idfac' => $id,
                            'venhisemail_cliid' => $data_factura[$tipod . '_cliid'],
                            'venhisemail_descripcion' => "Envio de factura de: $de para: $para tipo: Factura completa",
                            'venhisemail_modulo' => ($tipo == 3) ? 'PRES' : 'PED',
                            'venhisemail_empid' => $_SESSION['user_data']['einfo_id']
                        ]);
                    }

                    header('Content-Type: application/json', true);
                    echo json_encode("Envio de factura exitosa");
                    exit;
                } catch (Exception $e) {
                    $this->array_errors[] = "Message could not be sent. Mailer Error: {$mail->ErrorInfo}.";
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eniviarFactura()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id     = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
            $de     = filter_input(INPUT_POST, 'de', FILTER_SANITIZE_EMAIL);
            $para   = filter_input(INPUT_POST, 'para', FILTER_SANITIZE_EMAIL);
            $copia  = filter_input(INPUT_POST, 'copia', FILTER_SANITIZE_EMAIL);
            $firma  = filter_input(INPUT_POST, 'firma', FILTER_SANITIZE_EMAIL);
            $tipo   = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);

            if (empty($de))
                $this->array_errors[] = 'El campo De es obligatorio.';
            if (empty($para))
                $this->array_errors[] = 'El campo Para es obligatorio.';

            if (empty($this->array_errors)) {

                $newVentasHistoricoEmail = new VentasHistoricoEmail();

                $tipod = '';
                if ($tipo == 1) {
                    $this->notas_entrega_model = new Notasdeentrega();
                    $data_factura = $this->notas_entrega_model->obtener($id);
                    $tipod = 'NOTA DE ENTREGA';
                }
                if ($tipo == 2) {
                    $this->notas_entrega_model = new Pos();
                    $data_factura = $this->notas_entrega_model->obtener($id);
                    $tipod = 'FACTURA';
                }
                $r = 1;

                if (!empty($id)) {

                    switch ($r) {
                        case 1:
                            $pdf_nombre = 'Factura completa';
                            $mpdf = $this->pdfCompleto($id, $tipo);
                            break;
                        case 2:
                            $pdf_nombre = 'Factura media pagina';
                            $mpdf = $this->pdfMediaPagina($id, $tipo);
                            break;
                        case 3:
                            $pdf_nombre = 'Factura mas pagos';
                            $mpdf = $this->pdfPagos($id, $tipo);
                            break;
                    }

                    $content = $mpdf['mpdf']->Output('', 'S');

                    $mail = new PHPMailer(true);

                    try {

                        $mail->isSMTP();
                        $mail->Host       = "{$mpdf['empresa']['emp_host_correo']}";
                        $mail->SMTPAuth   = true;
                        $mail->Username   = "{$mpdf['empresa']['emp_email']}";
                        $mail->Password   = "{$mpdf['empresa']['emp_email_password']}";
                        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                        $mail->Port       = $mpdf['empresa']['emp_port_correo'];

                        $mail->setFrom($de);
                        $mail->addAddress($para);
                        $mail->addReplyTo($de, 'Empresa');

                        if (!empty($copia)) {
                            $mail->addAddress($copia);
                        }

                        $mail->addStringAttachment($content, "{$mpdf['mascara']}");

                        $mail->isHTML(true);
                        $mail->Subject = $tipod;
                        $mail->Body    = "{$mpdf['mascara']}";

                        $mail->send();

                        $newVentasHistoricoEmail->guardar([
                            'venhisemail_idfac' => $id,
                            'venhisemail_cliid' => ($tipo == 1) ? $data_factura['ne_cliid'] : $data_factura['fm_cliid'],
                            'venhisemail_descripcion' => "Envio de factura de: $de para: $para tipo: $pdf_nombre",
                            'venhisemail_modulo' => ($tipo == 1) ? 'NEV' : 'FACV',
                            'venhisemail_empid' => $_SESSION['user_data']['einfo_id']
                        ]);

                        Http::json_response("Envio de factura exitosa");
                    } catch (Exception $e) {
                        $this->array_errors[] = "Message could not be sent. Mailer Error: {$mail->ErrorInfo}.";
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function verFactura()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_GET['factura']))
                $this->array_errors[] = 'No esta definido el id de la factura';
            if (empty($_GET['tipo']))
                $this->array_errors[] = 'Seleccione el tipo de documento';

            $id_factura = filter_var($_GET['factura'], FILTER_SANITIZE_NUMBER_INT);
            $tipo = filter_var($_GET['tipo'], FILTER_SANITIZE_NUMBER_INT);
            $tipod = '';

            if ($tipo == 1) {
                $this->notas_entrega_model = new Notasdeentrega();
                $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                $result = $this->carritoVentasEditar->obtenerFactura('app_notas_de_entrega', 'needitar', $id_factura);
                $ruta_list = $this->notas_entrega_model->obtenerDocServicio($id_factura);
                $tipod = 'ne';
            }
            if ($tipo == 2) {
                $this->notas_entrega_model = new Pos();
                $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                $result = $this->carritoVentasEditar->obtenerFactura('app_factura_master', 'faceditar', $id_factura);
                $ruta_list = $this->notas_entrega_model->obtenerDocServicio($id_factura);
                $tipod = 'fm';
            }
            if ($tipo == 3) {
                $this->notas_entrega_model = new Presupuesto();
                $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                $result = $this->carritoVentasEditar->obtenerFactura('app_presupuesto', 'preeditar', $id_factura);
                $ruta_list = [];
                $tipod = "pre";
            }
            if ($tipo == 4) {
                $this->notas_entrega_model = new Pedidos();
                $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                $result = $this->carritoVentasEditar->obtenerFactura('app_pedidos', 'peeditar', $id_factura);
                $ruta_list = [];
                $tipod = "pe";
            }
            $empresa = $this->notas_entrega_model->consultar("Select * From app_empresas")->row();
            if ($factura) {
                $newVentasHistoricoEmail = new VentasHistoricoEmail();
                $data_factura = [];
                $serie = $this->carritoVentasEditar->obtenerSeriesEmpleado($_SESSION['user_data']['emp_id']);

                if ($tipo == 1 || $tipo == 2) {
                    $ruta_list = $this->notas_entrega_model->obtenerDocServicio($id_factura);

                    $ruta = [];

                    if (is_countable($ruta_list) && count($ruta_list)) {
                        foreach ($ruta_list as $row) {

                            $ruta[] = [
                                'fecha'           => $row['rd_fecha'],
                                'emp_username'    => $row['emp_username'],
                                'rd_observacion'  => $row['rd_observacion'],
                                'doc_prefijo'     => $row['doc_prefijo'],
                                'url'             => ruta_base() . 'servicios/tablista?tablero=' . $row['tab_id'] . '&modalpres=' . $row['tar_id']
                            ];
                        }
                    }

                    $clp = $this->carritoVentasEditar->obtenerCliente($factura[$tipod . '_cliid']);
                    $rt = str_replace('(', '', $clp['cli_telefono']);
                    $rt = str_replace(')', '', $rt);
                    $rt = str_replace('-', '', $rt);
                    $rt = str_replace(' ', '', $rt);

                    $agente_selecc = [];
                    if ($factura[$tipod . '_empagente'] != NULL) {
                        $agente_selecc = $this->notas_entrega_model->consultar("SELECT * FROM app_empleados_agentes WHERE empagent_empid = {$factura[$tipod . '_empagente']} AND empagent_clientid = {$factura[$tipod . '_cliid']} AND empagent_docid={$id_factura} AND empagent_tipo=$tipo")->row();
                    }

                    $data_factura = [
                        'doc_pendientes'        => $this->carritoVentasEditar->totalDocumentosPendientes($factura[$tipod . '_cliid']),
                        'total_doc_pendientes'  => $this->carritoVentasEditar->obtenerDocumentosPendientesPorPagarPorCliente($factura[$tipod . '_cliid']),
                        'impresoras'            => $this->notas_entrega_model->consultar("SELECT imp_id id, imp_descripcion impresora FROM app_impresoras WHERE imp_estatus = 1 AND imp_tipo = 1")->all(),
                        'imp_ticket'            => $this->notas_entrega_model->consultar("SELECT imp_id id, imp_descripcion impresora FROM app_impresoras WHERE imp_estatus = 1 AND imp_tipo = 2")->all(),
                        'historico_email'       => $newVentasHistoricoEmail->obtenerHistorico($id_factura),
                        'ruta'                  => $ruta,
                        'telefono'              => $rt,
                        'ComprarDolares'        => $this->carritoVentasEditar->obtenerBalanceComprarDolares($id_factura, $tipo),
                        'factura'               => $factura,
                        'carrito'               => $result,
                        'empleado'              => $this->carritoVentasEditar->obtenerEmpleado($factura[$tipod . '_empleadoid']),
                        'empresa'               => $this->carritoVentasEditar->obtenerDatosEmpresa(),
                        'cliente'               => $this->carritoVentasEditar->obtenerCliente($factura[$tipod . '_cliid']),
                        'tipos_de_documentos'   => $this->carritoVentasEditar->obternerTiposDeDocumentos(),
                        'impuestos'             => $this->carritoVentasEditar->obtenerImpuestos(),
                        'paises'                => $this->carritoVentasEditar->obtenerPaises(),
                        'almacenes'             => $this->carritoVentasEditar->obtenerAlmacenesEmpleado(),
                        'series'                => $this->carritoVentasEditar->obtenerSeriesEmpleado(),
                        'divisas'               => $this->carritoVentasEditar->obtenerDivisasParaFacturar(),
                        'empleados_agentes'     => $this->carritoVentasEditar->obtenerAgentesdeVenta(),
                        'doc_pendientes'        => $this->carritoVentas->totalDocumentosPendientes($factura[$tipod . '_cliid']),
                        'total_doc_pendientes'  => $this->carritoVentas->obtenerDocumentosPendientesPorPagarPorCliente($factura[$tipod . '_cliid']),
                        'integrar_iva'          => $empresa['emp_iva'],
                        'agente_selecc'         => $agente_selecc

                    ];
                } else {
                    $clp = $this->carritoVentasEditar->obtenerCliente($factura[$tipod . '_cliid']);
                    $rt = str_replace('(', '', $clp['cli_telefono']);
                    $rt = str_replace(')', '', $rt);
                    $rt = str_replace('-', '', $rt);
                    $rt = str_replace(' ', '', $rt);

                    $data_factura = [
                        'doc_pendientes'        => $this->carritoVentasEditar->totalDocumentosPendientes($factura[$tipod . '_cliid']),
                        'total_doc_pendientes'  => $this->carritoVentasEditar->obtenerDocumentosPendientesPorPagarPorCliente($factura[$tipod . '_cliid']),
                        'impresoras'            => [],
                        'imp_ticket'            => [],
                        'ComprarDolares'        => [],
                        'historico_email'       => $newVentasHistoricoEmail->obtenerHistorico($id_factura),
                        'ruta'                  => '',
                        'telefono'              => $rt,
                        'factura'               => $factura,
                        'carrito'               => $result,
                        'empleado'              => $this->carritoVentasEditar->obtenerEmpleado($factura[$tipod . '_empleadoid']),
                        'empresa'               => $this->carritoVentasEditar->obtenerDatosEmpresa(),
                        'cliente'               => $this->carritoVentasEditar->obtenerCliente($factura[$tipod . '_cliid']),
                        'tipos_de_documentos'   => $this->carritoVentasEditar->obternerTiposDeDocumentos(),
                        'impuestos'             => $this->carritoVentasEditar->obtenerImpuestos(),
                        'paises'                => $this->carritoVentasEditar->obtenerPaises(),
                        'almacenes'             => $this->carritoVentasEditar->obtenerAlmacenesEmpleado(),
                        'series'                 => $this->carritoVentasEditar->obtenerSeriesEmpleado(),
                        'divisas'               => $this->carritoVentasEditar->obtenerDivisasParaFacturar(),
                        'empleados_agentes'     => [],
                        'doc_pendientes'        => $this->carritoVentas->totalDocumentosPendientes($factura[$tipod . '_cliid']),
                        'total_doc_pendientes'  => $this->carritoVentas->obtenerDocumentosPendientesPorPagarPorCliente($factura[$tipod . '_cliid']),
                        'integrar_iva'          => $empresa['emp_iva']
                    ];
                }

                return Http::json_response($data_factura);
            }
        }
    }

    public function obtenerSucursalesEmpleado()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $empleado_sucursales = new EmpleadoSucursales();
            $suc = $empleado_sucursales->obtenerSucursales($_SESSION['user_data']['emp_id']);

            $ID = '';
            foreach ($suc as $row) {
                if ($row['sucursal_predeterminado'] == 1) {
                    $ID = $row['sucursal_id'];
                }
            }

            if ($ID == "" && count($suc) > 0) {
                $ID = $suc[0]['empalm_almid'];
            }

            Http::json_response([
                'sucursales' => $suc,
                'id' => ($_SESSION['sucursal']['id'] != 0) ? $_SESSION['sucursal']['id'] : $ID,
                'desactivar' => ($_SESSION['sucursal']['id'] != 0) ? true : false
            ]);
        }
    }

    private function esEditable(int $id_factura, int $tipo)
    {
        if ($tipo == 1) {
            $this->notas_entrega_model = new Notasdeentrega();
            $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
            $tipo = 'ne';
        }
        if ($tipo == 2) {
            $this->notas_entrega_model = new Pos();
            $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
            $tipo = 'fm';
        }
        if ($tipo == 3) {
            $this->notas_entrega_model = new Presupuesto();
            $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
            $tipo = 'pre';
        }
        if ($tipo == 4) {
            $this->notas_entrega_model = new Pedidos();
            $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
            $tipo = 'pe';
        }
        return ($factura[$tipo . '_estatus'] == 1) ? false : true;
    }


    private function pdfCompleto($id_factura, $tipod)
    {
        $tipo = '';
        if ($tipod == 1) {
            $this->notas_entrega_model = new Notasdeentrega();
            $factura_data       = $this->notas_entrega_model->obtenerFacturaCompleta($id_factura);
            $tipo = "ne";
            $articulos_model    = new NotasdeentregaArticulos();
        } else {
            $this->notas_entrega_model = new Pos();
            $factura_data       = $this->notas_entrega_model->obtenerFacturaCompleta($id_factura);
            $tipo = "fm";
            $articulos_model    = new PosArticulos();
        }

        $articulos_data     = $articulos_model->articulos($factura_data[$tipo . '_id']);
        $cliente_data       = $this->carritoVentasEditar->obtenerCliente($factura_data[$tipo . '_cliid']);
        $empresa_data       = $this->carritoVentasEditar->obtenerDatosEmpresa();

        $documento_data     = $this->carritoVentasEditar->obtenerDocumento($tipod);
        $sucursal = $this->notas_entrega_model->obtenerSucursal($factura_data[$tipo . '_surcid']);
        $factCompra = $empresa_data['emp_iva'];

        $mascara = mascara_correlativo($documento_data['doc_prefijo'], $factura_data['ser_impuesto'], $factura_data[$tipo . '_correlativo']);

        $margin_top = 0;
        $margin_footer = 0;

        if ($factura_data['ser_id'] == 1) {
            $margin_top = 50;
            $margin_footer = 30;
        } else {
            $margin_top = 35;
            $margin_footer = 45;
        }

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 15,
            'margin_right'      => 15,
            'margin_top'        => $margin_top,
            'margin_bottom'     => 28,
            'margin_header'     => 15,
            'margin_footer'     => $margin_footer,
            'format'            => 'A4',
            'orientation'       => 'P',
            'default_font_size' => 8,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle($mascara);
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject($mascara);

        $html_header = Vista::viewPDF('pdffacturas/notasdeentrega/header', [
            'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
            'emp_rif'       => $empresa_data['emp_rif'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
            'emp_estado'    => $empresa_data['emp_estado'] ?? '',
            'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
        ]);

        $mpdf->SetHTMLHeader($html_header);

        if ($tipod == 1) {
            $html_body = Vista::viewPDF('pdffacturas/notasdeentrega/body_completo', [
                'factura'       => $mascara,
                'sucursal'      => $sucursal['su_nombre'] . '-' . $sucursal['su_direccion'],
                'iva_integrado' => $factCompra,
                'cliente'       => $cliente_data['cli_razon_social'],
                'direccion'     => $cliente_data['cli_direccion'],
                'fecha'         => date('Y-m-d', strtotime($factura_data[$tipo . '_fecha'])),
                'cedularif'     => $cliente_data['cli_dni'],
                'telefono'      => $cliente_data['cli_telefono'],
                'div_locale'    => $factura_data['div_locale'],
                'div_simbolo'  => $factura_data['div_simbolo'],
                'articulos'     => $articulos_data,
                'observaciones' => $factura_data[$tipo . '_observaciones']
            ]);
        } else {
            $html_body = Vista::viewPDF('pdffacturas/factura/body_completo', [
                'factura'       => $mascara,
                'cliente'       => $cliente_data['cli_razon_social'],
                'direccion'     => $cliente_data['cli_direccion'],
                'fecha'         => date('Y-m-d', strtotime($factura_data['fm_fecha'])),
                'cedularif'     => $cliente_data['cli_dni'],
                'telefono'      => $cliente_data['cli_telefono'],
                'div_locale'    => $factura_data['div_locale'],
                'div_simbolo'  => $factura_data['div_simbolo'],
                'articulos'     => $articulos_data,
                'observaciones' => $factura_data['fm_observaciones']
            ]);
        }


        $mpdf->WriteHTML($html_body);

        if ($tipod == 1) {
            if ($factCompra) {

                $subtotal = 0;
                $neto = 0;
                $total = 0;
                foreach ($articulos_data as $row) {
                    $iv = convertir_a_float($row['neart_proprecio'] + ($row['neart_proprecio'] * ($row['imp_valor'] / 100))) ?? 0;
                    $descuentoprod = convertir_a_float(($row['neart_procantidad'] * $iv) * ($row['neart_prodescuento'] / 100)) ?? 0;
                    $subtotal += convertir_a_float(($row['neart_procantidad'] * $iv) - $descuentoprod);
                    $neto += convertir_a_float(($row['neart_procantidad'] * $iv) - $descuentoprod);
                    $total += convertir_a_float(($row['neart_procantidad'] * $iv) - $descuentoprod);
                }
                $descuento = convertir_a_float(($total * ($factura_data['ne_descuento'] / 100))) ?? 0;
                $html_footer = Vista::viewPDF('pdffacturas/notasdeentrega/footer', [
                    'div_locale'    => $factura_data['div_locale'],
                    'div_simbolo'   => $factura_data['div_simbolo'],
                    'total'         => $total - $descuento,
                    'iva_integrado' => $factCompra,
                    'iva'           => $factura_data['ne_iva'],
                    'neto'          => $neto,
                    'descuento'     => $factura_data['ne_descuento']
                ]);
            } else {
                $html_footer = Vista::viewPDF('pdffacturas/notasdeentrega/footer', [
                    'div_locale'    => $factura_data['div_locale'],
                    'div_simbolo'  => $factura_data['div_simbolo'],
                    'iva_integrado' => $factCompra,
                    'total'         => $factura_data['ne_total'],
                    'iva'           => $factura_data['ne_iva'],
                    'neto'          => $factura_data['ne_neto'],
                    'descuento'     => $factura_data['ne_descuento']
                ]);
            }
        } else {
            $html_footer = Vista::viewPDF('pdffacturas/factura/footer', [
                'div_locale'    => $factura_data['div_locale'],
                'div_simbolo'  => $factura_data['div_simbolo'],
                'total'         => $factura_data['fm_total'],
                'iva'           => $factura_data['fm_iva'],
                'neto'          => $factura_data['fm_neto'],
                'descuento'     => $factura_data['fm_descuento']
            ]);
        }


        $mpdf->SetHTMLFooter($html_footer);

        return [
            'mpdf'      => $mpdf,
            'mascara'   => $mascara . '.pdf',
            'empresa'   => $empresa_data,
        ];
    }

    private function pdfMediaPagina($id_factura, $tipod)
    {
        $tipo = '';
        if ($tipod == 1) {
            $this->notas_entrega_model = new Notasdeentrega();
            $factura_data       = $this->notas_entrega_model->obtenerFacturaCompleta($id_factura);
            $tipo = "ne";
            $articulos_model    = new NotasdeentregaArticulos();
        } else {
            $this->notas_entrega_model = new Pos();
            $factura_data       = $this->notas_entrega_model->obtenerFacturaCompleta($id_factura);
            $tipo = "fm";
            $articulos_model    = new PosArticulos();
        }

        $articulos_data     = $articulos_model->articulos($factura_data[$tipo . '_id']);
        $cliente_data       = $this->carritoVentasEditar->obtenerCliente($factura_data[$tipo . '_cliid']);
        $empresa_data       = $this->carritoVentasEditar->obtenerDatosEmpresa();
        $documento_data     = $this->carritoVentasEditar->obtenerDocumento($tipod);
        $sucursal = $this->notas_entrega_model->obtenerSucursal($factura_data[$tipo . '_surcid']);
        $factCompra = $empresa_data['emp_iva'];

        $mascara = mascara_correlativo($documento_data['doc_prefijo'], $factura_data['ser_impuesto'], $factura_data[$tipo . '_correlativo']);

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 15,
            'margin_right'      => 15,
            'margin_top'        => 35,
            'margin_bottom'     => 30,
            'margin_header'     => 15,
            'margin_footer'     => 30,
            'format'            => [210, 148.5],
            'orientation'       => 'P',
            'default_font_size' => 8,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle($mascara);
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject($mascara);

        $html_header = Vista::viewPDF('pdffacturas/notasdeentrega/header', [
            'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
            'emp_rif'       => $empresa_data['emp_rif'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
            'emp_estado'    => $empresa_data['emp_estado'] ?? '',
            'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
        ]);

        $mpdf->SetHTMLHeader($html_header);

        if ($tipod == 1) {
            $html_body = Vista::viewPDF('pdffacturas/notasdeentrega/body_completo', [
                'factura'       => $mascara,
                'sucursal'      => $sucursal['su_nombre'] . '-' . $sucursal['su_direccion'],
                'iva_integrado' => $factCompra,
                'cliente'       => $cliente_data['cli_razon_social'],
                'direccion'     => $cliente_data['cli_direccion'],
                'fecha'         => date('Y-m-d', strtotime($factura_data[$tipo . '_fecha'])),
                'cedularif'     => $cliente_data['cli_dni'],
                'telefono'      => $cliente_data['cli_telefono'],
                'div_locale'    => $factura_data['div_locale'],
                'div_simbolo'  => $factura_data['div_simbolo'],
                'articulos'     => $articulos_data,
                'observaciones' => $factura_data[$tipo . '_observaciones']
            ]);
        } else {
            $html_body = Vista::viewPDF('pdffacturas/factura/body_completo', [
                'factura'       => $mascara,
                'cliente'       => $cliente_data['cli_razon_social'],
                'direccion'     => $cliente_data['cli_direccion'],
                'fecha'         => date('Y-m-d', strtotime($factura_data['fm_fecha'])),
                'cedularif'     => $cliente_data['cli_dni'],
                'telefono'      => $cliente_data['cli_telefono'],
                'div_locale'    => $factura_data['div_locale'],
                'div_simbolo'  => $factura_data['div_simbolo'],
                'articulos'     => $articulos_data,
                'observaciones' => $factura_data['fm_observaciones']
            ]);
        }

        $mpdf->WriteHTML($html_body);

        if ($tipod == 1) {
            if ($factCompra) {

                $subtotal = 0;
                $neto = 0;
                $total = 0;
                foreach ($articulos_data as $row) {
                    $iv = convertir_a_float($row['neart_proprecio'] + ($row['neart_proprecio'] * ($row['imp_valor'] / 100))) ?? 0;
                    $descuentoprod = convertir_a_float(($row['neart_procantidad'] * $iv) * ($row['neart_prodescuento'] / 100)) ?? 0;
                    $subtotal += convertir_a_float(($row['neart_procantidad'] * $iv) - $descuentoprod);
                    $neto += convertir_a_float(($row['neart_procantidad'] * $iv) - $descuentoprod);
                    $total += convertir_a_float(($row['neart_procantidad'] * $iv) - $descuentoprod);
                }
                $descuento = convertir_a_float(($total * ($factura_data['ne_descuento'] / 100))) ?? 0;
                $html_footer = Vista::viewPDF('pdffacturas/notasdeentrega/footer', [
                    'div_locale'    => $factura_data['div_locale'],
                    'div_simbolo'   => $factura_data['div_simbolo'],
                    'total'         => $total - $descuento,
                    'iva_integrado' => $factCompra,
                    'iva'           => $factura_data['ne_iva'],
                    'neto'          => $neto,
                    'descuento'     => $factura_data['ne_descuento']
                ]);
            } else {
                $html_footer = Vista::viewPDF('pdffacturas/notasdeentrega/footer', [
                    'div_locale'    => $factura_data['div_locale'],
                    'div_simbolo'  => $factura_data['div_simbolo'],
                    'iva_integrado' => $factCompra,
                    'total'         => $factura_data['ne_total'],
                    'iva'           => $factura_data['ne_iva'],
                    'neto'          => $factura_data['ne_neto'],
                    'descuento'     => $factura_data['ne_descuento']
                ]);
            }
        } else {
            $html_footer = Vista::viewPDF('pdffacturas/factura/footer', [
                'div_locale'    => $factura_data['div_locale'],
                'div_simbolo'  => $factura_data['div_simbolo'],
                'total'         => $factura_data['fm_total'],
                'iva'           => $factura_data['fm_iva'],
                'neto'          => $factura_data['fm_neto'],
                'descuento'     => $factura_data['fm_descuento']
            ]);
        }

        $mpdf->SetHTMLFooter($html_footer);

        return [
            'mpdf'      => $mpdf,
            'mascara'   => $mascara . '.pdf',
            'empresa'   => $empresa_data,
        ];
    }

    public function pdfPagos($id_factura, $tipod)
    {
        $tipo = '';
        if ($tipod == 1) {
            $this->notas_entrega_model = new Notasdeentrega();
            $factura_data       = $this->notas_entrega_model->obtenerFacturaCompleta($id_factura);
            $tipo = "ne";
            $articulos_model    = new NotasdeentregaArticulos();
        } else {
            $this->notas_entrega_model = new Pos();
            $articulos_model    = new PosArticulos();
            $factura_data       = $this->notas_entrega_model->obtenerFacturaCompleta($id_factura);
            $tipo = "fm";
        }

        $articulos_data     = $articulos_model->articulos($factura_data[$tipo . '_id']);
        $cliente_data       = $this->carritoVentasEditar->obtenerCliente($factura_data[$tipo . '_cliid']);
        $empresa_data       = $this->carritoVentasEditar->obtenerDatosEmpresa();
        $documento_data     = $this->carritoVentasEditar->obtenerDocumento($tipod);
        $sucursal = $this->notas_entrega_model->obtenerSucursal($factura_data[$tipo . '_surcid']);
        $factCompra = $empresa_data['emp_iva'];

        $mascara = mascara_correlativo($documento_data['doc_prefijo'], $factura_data['ser_impuesto'], $factura_data[$tipo . '_correlativo']);

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 15,
            'margin_right'      => 15,
            'margin_top'        => 35,
            'margin_bottom'     => 30,
            'margin_header'     => 15,
            'margin_footer'     => 20,
            'format'            => [210, 148.5],
            'orientation'       => 'P',
            'default_font_size' => 8,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle($mascara);
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject($mascara);

        if ($tipod == 1) {
            $html_header = Vista::viewPDF('pdffacturas/notasdeentrega/header', [
                'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
                'emp_rif'       => $empresa_data['emp_rif'] ?? '',
                'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
                'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
                'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
                'emp_estado'    => $empresa_data['emp_estado'] ?? '',
                'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
            ]);
        } else {
            $html_header = Vista::viewPDF('pdffacturas/factura/header', [
                'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
                'emp_rif'       => $empresa_data['emp_rif'] ?? '',
                'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
                'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
                'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
                'emp_estado'    => $empresa_data['emp_estado'] ?? '',
                'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
            ]);
        }

        $mpdf->SetHTMLHeader($html_header);

        if ($tipod == 1) {
            $html_body = Vista::viewPDF('pdffacturas/notasdeentrega/body_completo', [
                'factura'       => $mascara,
                'sucursal'      => $sucursal['su_nombre'] . '-' . $sucursal['su_direccion'],
                'iva_integrado' => $factCompra,
                'cliente'       => $cliente_data['cli_razon_social'],
                'direccion'     => $cliente_data['cli_direccion'],
                'fecha'         => date('Y-m-d', strtotime($factura_data[$tipo . '_fecha'])),
                'cedularif'     => $cliente_data['cli_dni'],
                'telefono'      => $cliente_data['cli_telefono'],
                'div_locale'    => $factura_data['div_locale'],
                'div_simbolo'  => $factura_data['div_simbolo'],
                'articulos'     => $articulos_data,
                'observaciones' => $factura_data[$tipo . '_observaciones']
            ]);
        } else {
            $html_body = Vista::viewPDF('pdffacturas/factura/body_completo', [
                'factura'       => $mascara,
                'cliente'       => $cliente_data['cli_razon_social'],
                'direccion'     => $cliente_data['cli_direccion'],
                'fecha'         => date('Y-m-d', strtotime($factura_data['fm_fecha'])),
                'cedularif'     => $cliente_data['cli_dni'],
                'telefono'      => $cliente_data['cli_telefono'],
                'div_locale'    => $factura_data['div_locale'],
                'div_simbolo'  => $factura_data['div_simbolo'],
                'articulos'     => $articulos_data,
                'observaciones' => $factura_data['fm_observaciones']
            ]);
        }

        $mpdf->WriteHTML($html_body);
        $total = 0;
        if ($tipod == 1) {
            if ($factCompra) {

                $subtotal = 0;
                $neto = 0;
                $total = 0;
                foreach ($articulos_data as $row) {
                    $iv = convertir_a_float($row['neart_proprecio'] + ($row['neart_proprecio'] * ($row['imp_valor'] / 100))) ?? 0;
                    $descuentoprod = convertir_a_float(($row['neart_procantidad'] * $iv) * ($row['neart_prodescuento'] / 100)) ?? 0;
                    $subtotal += convertir_a_float(($row['neart_procantidad'] * $iv) - $descuentoprod);
                    $neto += convertir_a_float(($row['neart_procantidad'] * $iv) - $descuentoprod);
                    $total += convertir_a_float(($row['neart_procantidad'] * $iv) - $descuentoprod);
                }
                $descuento = convertir_a_float(($total * ($factura_data['ne_descuento'] / 100))) ?? 0;
                $html_footer = Vista::viewPDF('pdffacturas/notasdeentrega/footer', [
                    'div_locale'    => $factura_data['div_locale'],
                    'div_simbolo'   => $factura_data['div_simbolo'],
                    'total'         => $total - $descuento,
                    'iva_integrado' => $factCompra,
                    'iva'           => $factura_data['ne_iva'],
                    'neto'          => $neto,
                    'descuento'     => $factura_data['ne_descuento']
                ]);
            } else {
                $html_footer = Vista::viewPDF('pdffacturas/notasdeentrega/footer', [
                    'div_locale'    => $factura_data['div_locale'],
                    'div_simbolo'  => $factura_data['div_simbolo'],
                    'iva_integrado' => $factCompra,
                    'total'         => $factura_data['ne_total'],
                    'iva'           => $factura_data['ne_iva'],
                    'neto'          => $factura_data['ne_neto'],
                    'descuento'     => $factura_data['ne_descuento']
                ]);
            }
        } else {
            $html_footer = Vista::viewPDF('pdffacturas/factura/footer', [
                'div_locale'    => $factura_data['div_locale'],
                'div_simbolo'  => $factura_data['div_simbolo'],
                'total'         => $factura_data['fm_total'],
                'iva'           => $factura_data['fm_iva'],
                'neto'          => $factura_data['fm_neto'],
                'descuento'     => $factura_data['fm_descuento']
            ]);
        }

        $mpdf->SetHTMLFooter($html_footer);

        $mpdf->AddPage();

        $array_abonos = [];
        $total_abonos = 0;
        $abonos = $this->notas_entrega_model->abonos($id_factura);
        $this->divisa_master  = $this->notas_entrega_model->obtenerDivisaMaster();

        if (is_countable($abonos) && count($abonos)) {
            foreach ($abonos as $row) {
                $divisa_mov = $this->carritoVentasEditar->obtenerDivisa($row['fab_divisa']);
                $divisa_conv_mov = $this->carritoVentasEditar->obtenerDivisa($row['fab_divid_conversion']);
                $array_abonos[] = [
                    'fab_id'            => $row['fab_id'],
                    'fab_fecha'         => $row['fecha'],
                    'bc_alias'          => $row['bc_alias'],
                    'bc_tipo'           => $row['bc_tipo'],
                    'fab_retiro'        => $row['fab_retiro'],
                    'mp_nombre'         => $row['mp_nombre'],
                    'fab_monto'         => Moneda::moneda($row['fab_monto'], $divisa_mov['div_locale'], $divisa_mov['div_simbolo']),
                    'fab_factor'        => Moneda::decimal($row['fab_factor'], $this->divisa_master['div_locale']),
                    'fab_conversion'    => Moneda::moneda($row['fab_conversion'], $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo'])
                ];

                $total_abonos += $row['fab_conversion'];
            }
        }
        $f = "";
        if ($tipod == 1) {
            $pendiente = abs((($factCompra == true) ? $total : $factura_data['ne_total']) - $total_abonos);
            $f = ($factCompra == true) ? $total : $factura_data['ne_total'];
        } else {
            $pendiente = abs($factura_data[$tipo . '_total'] - $total_abonos);
            $f = $factura_data[$tipo . '_total'];
        }

        if ($tipod == 1) {
            if (is_countable($abonos) && count($abonos)) {
                $html_abonos = Vista::viewPDF('pdffacturas/notasdeentrega/abonos', [
                    'total' => Moneda::moneda($f, $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo']),
                    'pendiente' => Moneda::moneda($pendiente, $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo']),
                    'abonos' => $array_abonos,
                    'abonado' => Moneda::moneda($total_abonos, $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo'])
                ]);
            } else {
                $html_abonos = Vista::viewPDF('pdffacturas/notasdeentrega/abonos', [
                    'total' => Moneda::moneda($f, $factura_data['div_locale'], $factura_data['div_simbolo']),
                    'pendiente' => Moneda::moneda($f, $factura_data['div_locale'], $factura_data['div_simbolo']),
                    'abonos' => $array_abonos,
                    'abonado' => 0
                ]);
            }
        } else {
            if (is_countable($abonos) && count($abonos)) {
                $html_abonos = Vista::viewPDF('pdffacturas/factura/abonos', [
                    'total' => Moneda::moneda($f, $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo']),
                    'pendiente' => Moneda::moneda($pendiente, $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo']),
                    'abonos' => $array_abonos,
                    'abonado' => Moneda::moneda($total_abonos, $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo'])
                ]);
            } else {
                $html_abonos = Vista::viewPDF('pdffacturas/factura/abonos', [
                    'total' => Moneda::moneda($f, $factura_data['div_locale'], $factura_data['div_simbolo']),
                    'pendiente' => Moneda::moneda($f, $factura_data['div_locale'], $factura_data['div_simbolo']),
                    'abonos' => $array_abonos,
                    'abonado' => 0
                ]);
            }
        }

        $mpdf->WriteHTML($html_abonos);

        if ($tipod == 1) {
            $footer = Vista::viewPDF('pdffacturas/notasdeentrega/footerFMP');
        } else {
            $footer = Vista::viewPDF('pdffacturas/factura/footerFMP');
        }

        $mpdf->SetHTMLFooter($footer);

        return [
            'mpdf'      => $mpdf,
            'mascara'   => $mascara . '.pdf',
            'empresa'   => $empresa_data,
        ];
    }

    public function pdf()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD']) {

            $id_factura = filter_var($_GET['factura'], FILTER_SANITIZE_NUMBER_INT);
            $tipo = filter_var($_GET['tipo'], FILTER_SANITIZE_NUMBER_INT);

            if ($tipo == 1) {
                $this->notas_entrega_model = new Notasdeentrega();
                $factura_data = $this->notas_entrega_model->obtenerFacturaCompleta($id_factura);
            } else {
                $this->notas_entrega_model = new Pos();
                $factura_data = $this->notas_entrega_model->obtenerFacturaCompleta($id_factura);
            }

            if (!$factura_data) {
                Http::notFound();
            }

            $mpdf = $this->pdfCompleto($id_factura, $tipo);

            $mpdf['mpdf']->Output("{$mpdf['mascara']}", \Mpdf\Output\Destination::INLINE);
            exit;
        }
    }

    public function pdfMP()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {

            $id_factura = filter_var($_GET['factura'], FILTER_SANITIZE_NUMBER_INT);
            $tipo = filter_var($_GET['tipo'], FILTER_SANITIZE_NUMBER_INT);

            if ($tipo == 1) {
                $this->notas_entrega_model = new Notasdeentrega();
            } else {
                $this->notas_entrega_model = new Pos();
            }
            $factura_data = $this->notas_entrega_model->obtenerFacturaCompleta($id_factura);

            if (!$factura_data) {
                Http::notFound();
            }

            $mpdf = $this->pdfMediaPagina($id_factura, $tipo);

            $mpdf['mpdf']->Output("{$mpdf['mascara']}", \Mpdf\Output\Destination::INLINE);
            exit;
        }
    }

    public function pdfFMP()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {

            $id_factura = filter_var($_GET['factura'], FILTER_SANITIZE_NUMBER_INT);
            $tipo = filter_var($_GET['tipo'], FILTER_SANITIZE_NUMBER_INT);

            if ($tipo == 1) {
                $this->notas_entrega_model = new Notasdeentrega();
            } else {
                $this->notas_entrega_model = new Pos();
            }

            $factura_data = $this->notas_entrega_model->obtenerFacturaCompleta($id_factura);

            if (!$factura_data) {
                Http::notFound();
            }

            $mpdf = $this->pdfPagos($id_factura, $tipo);

            $mpdf['mpdf']->Output("{$mpdf['mascara']}", \Mpdf\Output\Destination::INLINE);
            exit;
        }
    }

    public function agregarProductoBarcode()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_producto']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['id_almacen']))
                $this->array_errors[] = 'El Almacen es obligatorio';
            if (empty($_POST['id_divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';
            if (empty($_POST['id_cliente']))
                $this->array_errors[] = 'El Cliente es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $id_producto        = filter_input(INPUT_POST, 'id_producto', FILTER_VALIDATE_INT);
                $id_almacen         = filter_input(INPUT_POST, 'id_almacen', FILTER_VALIDATE_INT);
                $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_VALIDATE_INT);
                $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);
                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_VALIDATE_INT) ?? 0;

                if ($id_factura > 0 && $id_producto && $id_almacen && $id_divisa) {
                    if ($tipo == 1) {
                        $this->notas_entrega_model = new Notasdeentrega();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->agregarProductoBarcode('app_notas_de_entrega', 'needitar', $id_factura, $data_factura['ne_cliid'], $id_producto, $id_almacen, $id_divisa, $descuento_global);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                    if ($tipo == 3) {
                        $this->notas_entrega_model = new Presupuesto();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->agregarProductoBarcode('app_presupuesto', 'preeditar', $id_factura, $id_producto, $id_almacen, $id_divisa, $descuento_global, false);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                    if ($tipo == 4) {
                        $this->notas_entrega_model = new Pedidos();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->agregarProductoBarcode('app_pedidos', 'peeditar', $id_factura, $data_factura['pe_cliid'], $id_producto, $id_almacen, $id_divisa, $descuento_global);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                } else {
                    if ($id_factura == 0 && $id_cliente && $id_producto && $id_almacen && $id_divisa) {
                        if ($tipo == 2) {
                            $result = $this->carritoVentas->agregarProductoBarcode('app_factura_master', 'factura', $id_cliente, $id_producto, $id_almacen, $id_divisa, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 1) {
                            $result = $this->carritoVentas->agregarProductoBarcode('app_notas_de_entrega', 'ne', $id_cliente, $id_producto, $id_almacen, $id_divisa, 0);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 3) {
                            $result = $this->carritoVentas->agregarProducto('app_presupuesto', 'pre', $id_cliente, $id_producto, $id_almacen, $id_divisa, $descuento_global, false);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 4) {
                            $result = $this->carritoVentas->agregarProductoBarcode('app_pedidos', 'pe', $id_cliente, $id_producto, $id_almacen, $id_divisa, $descuento_global, false);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function agregarProducto()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_producto']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['id_almacen']))
                $this->array_errors[] = 'El Almacen es obligatorio';
            if (empty($_POST['id_divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';
            if (empty($_POST['id_cliente']))
                $this->array_errors[] = 'El Cliente es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $id_producto        = filter_input(INPUT_POST, 'id_producto', FILTER_VALIDATE_INT);
                $id_almacen         = filter_input(INPUT_POST, 'id_almacen', FILTER_VALIDATE_INT);
                $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_VALIDATE_INT);
                $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);
                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_factura > 0 && $id_producto && $id_almacen && $id_divisa) {
                    if ($tipo == 1) {
                        $this->notas_entrega_model = new Notasdeentrega();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->agregarProducto('app_notas_de_entrega', 'needitar', $id_factura, $data_factura['ne_cliid'], $id_producto, $id_almacen, $id_divisa, $descuento_global);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                    if ($tipo == 3) {
                        $this->notas_entrega_model = new Presupuesto();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->agregarProducto('app_presupuesto', 'preeditar', $id_factura, $data_factura['pre_cliid'], $id_producto, $id_almacen, $id_divisa, $descuento_global, false);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                    if ($tipo == 4) {
                        $this->notas_entrega_model = new Pedidos();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->agregarProducto('app_pedidos', 'peeditar', $id_factura, $data_factura['pe_cliid'], $id_producto, $id_almacen, $id_divisa, $descuento_global, false);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                } else {
                    if ($id_factura == 0 && $id_cliente && $id_producto && $id_almacen && $id_divisa) {
                        if ($tipo == 2) {
                            $result = $this->carritoVentas->agregarProducto('app_factura_master', 'factura', $id_cliente, $id_producto, $id_almacen, $id_divisa, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 1) {
                            $result = $this->carritoVentas->agregarProducto('app_notas_de_entrega', 'ne', $id_cliente, $id_producto, $id_almacen, $id_divisa, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 3) {
                            $result = $this->carritoVentas->agregarProducto('app_presupuesto', 'pre', $id_cliente, $id_producto, $id_almacen, $id_divisa, $descuento_global, false);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 4) {
                            $result = $this->carritoVentas->agregarProducto('app_pedidos', 'pe', $id_cliente, $id_producto, $id_almacen, $id_divisa, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function predeterminarDivisa()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_GET['id_divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';
            if (empty($_GET['id_cliente']))
                $this->array_errors[] = 'El Cliente es obligatorio';

            if (empty($this->array_errors)) {

                $id_divisa          = filter_input(INPUT_GET, 'id_divisa', FILTER_VALIDATE_INT);
                $id_factura         = filter_input(INPUT_GET, 'id_factura', FILTER_VALIDATE_INT);
                $tipo               = filter_input(INPUT_GET, 'tipo', FILTER_VALIDATE_INT);
                $id_cliente         = filter_input(INPUT_GET, 'id_cliente', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_GET, 'descuento', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_factura > 0 && $id_divisa && $tipo == 1) {
                    if ($tipo == 1) {
                        $this->notas_entrega_model = new Notasdeentrega();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->predeterminarDivisa('needitar', $id_factura, $data_factura['ne_cliid'], $id_divisa, $descuento_global);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                    if ($tipo == 3) {
                        $this->notas_entrega_model = new Presupuesto();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->predeterminarDivisa('preeditar', $id_factura, $data_factura['pre_cliid'], $id_divisa, $descuento_global);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                    if ($tipo == 4) {
                        $this->notas_entrega_model = new Pedidos();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->predeterminarDivisa('peeditar', $id_factura, $data_factura['pe_cliid'], $id_divisa, $descuento_global);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                } else {
                    if ($id_cliente > 0 && $id_divisa) {
                        if ($tipo == 1) {
                            $result = $this->carritoVentas->predeterminarDivisa('ne', $id_cliente, $id_divisa, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 2) {
                            $result = $this->carritoVentas->predeterminarDivisa('factura', $id_cliente, $id_divisa, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 3) {
                            $result = $this->carritoVentas->predeterminarDivisa('pre', $id_cliente, $id_divisa, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 4) {
                            $result = $this->carritoVentas->predeterminarDivisa('pe', $id_cliente, $id_divisa, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function cambiarCliente()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            $id_cliente     = filter_input(INPUT_GET, 'id_cliente', FILTER_SANITIZE_NUMBER_INT);
            $id_factura     = filter_input(INPUT_GET, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
            $tipo               = filter_input(INPUT_GET, 'tipo', FILTER_VALIDATE_INT);

            if (!empty($id_cliente) && ($id_factura > 0)) {
                if ($this->esEditable($id_factura, $tipo)) {
                    if ($tipo == 1) {
                        $notas_entrega_model = new Notasdeentrega();
                        $factura = $notas_entrega_model->obtenerFactura($id_factura);
                        $cliente_anterior=$notas_entrega_model->consultar("SELECT * FROM app_clientes WHERE cli_id={$factura['ne_cliid']}")->row();
    
                        $result = $this->carritoVentasEditar->cambiarCliente('app_notas_de_entrega', $id_cliente, $id_factura);
                    
                        $cliente_nuevo=$notas_entrega_model->consultar("SELECT * FROM app_clientes WHERE cli_id={$id_cliente}")->row();

                        $notas_entrega_model->guardar([
                            "bitdoc_empid"=>$_SESSION['user_data']['emp_id'],
                            "bitdoc_descripcion"=>"El empleado ".$_SESSION['user_data']['einfo_nombres']." ".$_SESSION['user_data']['einfo_apellidos']." ha cambiado el cliente <b>".$cliente_anterior['cli_razon_social']."</b> a <b>".$cliente_nuevo['cli_razon_social']."</b>.",
                            "bitdoc_doc"=>1,
                            "bitdoc_idgenerico"=>$id_factura,
                        ],true, "app_bitacora_doc");
                    }
                    if ($tipo == 2) {
                        $notas_entrega_model = new Pos();
                        $factura = $notas_entrega_model->obtenerFactura($id_factura);
                        $cliente_anterior=$notas_entrega_model->consultar("SELECT * FROM app_clientes WHERE cli_id={$factura['ne_cliid']}")->row();

                        $result = $this->carritoVentasEditar->cambiarCliente('app_factura_master', $id_cliente, $id_factura);
                        $cliente_nuevo=$notas_entrega_model->consultar("SELECT * FROM app_clientes WHERE cli_id={$id_cliente}")->row();

                        $notas_entrega_model->guardar([
                            "bitdoc_empid"=>$_SESSION['user_data']['emp_id'],
                            "bitdoc_descripcion"=>"El empleado ".$_SESSION['user_data']['einfo_nombres']." ".$_SESSION['user_data']['einfo_apellidos']." ha cambiado el cliente <b>".$cliente_anterior['cli_razon_social']."</b> a <b>".$cliente_nuevo['cli_razon_social']."</b>.",
                            "bitdoc_doc"=>2,
                            "bitdoc_idgenerico"=>$id_factura,
                        ],true, "app_bitacora_doc");
                    }
                    if ($tipo == 3) {
                        $result = $this->carritoVentasEditar->cambiarCliente('app_presupuesto', $id_cliente, $id_factura);
                    }
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response([
                            'url'  => $result
                        ]);
                    }
                } else {
                    $this->array_errors[] = 'Documento no editable';
                }
            } else {
                if (($id_cliente > 0) && ($id_factura == 0)) {
                    if ($tipo == 1) {
                        $_SESSION["ne$id_cliente"] = null;
                        return Http::json_response([
                            'url'  => '',
                            'doc_pendientes'        => $this->carritoVentas->totalDocumentosPendientes($id_cliente),
                            'total_doc_pendientes'  => $this->carritoVentas->obtenerDocumentosPendientesPorPagarPorCliente($id_cliente),
                        ]);
                    }
                    if ($tipo == 2) {
                        $_SESSION["factura$id_cliente"] = null;
                        return Http::json_response([
                            'url'  => '',
                            'doc_pendientes'        => $this->carritoVentas->totalDocumentosPendientes($id_cliente),
                            'total_doc_pendientes'  => $this->carritoVentas->obtenerDocumentosPendientesPorPagarPorCliente($id_cliente),
                        ]);
                    }
                    if ($tipo == 3) {
                        $_SESSION["pre$id_cliente"] = null;
                        return Http::json_response([
                            'url'  => '',
                            'doc_pendientes'        => $this->carritoVentas->totalDocumentosPendientes($id_cliente),
                            'total_doc_pendientes'  => $this->carritoVentas->obtenerDocumentosPendientesPorPagarPorCliente($id_cliente),
                        ]);
                    }
                    if ($tipo == 4) {
                        $_SESSION["pe$id_cliente"] = null;
                        return Http::json_response([
                            'url'  => '',
                            'doc_pendientes'        => $this->carritoVentas->totalDocumentosPendientes($id_cliente),
                            'total_doc_pendientes'  => $this->carritoVentas->obtenerDocumentosPendientesPorPagarPorCliente($id_cliente),
                        ]);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerFactura(int $id_factura)
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            if (empty($_GET['factura']))
                $this->array_errors[] = 'No esta definido el id de la factura';
            if (empty($_GET['tipo']))
                $this->array_errors[] = 'Seleccione el tipo de documento';

            $id_factura = filter_var($_GET['factura'], FILTER_SANITIZE_NUMBER_INT);
            $tipo = filter_var($_GET['tipo'], FILTER_SANITIZE_NUMBER_INT);

            if ($tipo == 1) {
                $result = $this->carritoVentasEditar->obtenerFactura('app_notas_de_entrega', 'needitar', $id_factura);
            }
            if ($tipo == 2) {
                $result = $this->carritoVentasEditar->obtenerFactura('app_factura_master', 'faceditar', $id_factura);
            }
            if ($tipo == 3) {
                $result = $this->carritoVentasEditar->obtenerFactura('app_presupuesto', 'preeditar', $id_factura);
            }
            if ($tipo == 4) {
                $result = $this->carritoVentasEditar->obtenerFactura('app_pedidos', 'peeditar', $id_factura);
            }

            if (isset($result['errors'])) {
                return Http::json_response(['errors' => $result['errors']]);
            } else {
                return Http::json_response($result);
            }
        }
    }

    public function obtenerBalanceComprarDolares()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_GET['id_factura']))
                $this->array_errors[] = 'El id de la factura es obligatorio';
            if (empty($_GET['tipo']))
                $this->array_errors[] = 'El tipo del documento es obligatorio';

            if (empty($this->array_errors)) {

                $factura      = filter_input(INPUT_GET, 'id_factura', FILTER_VALIDATE_INT);
                $tipo     = filter_input(INPUT_GET, 'tipo', FILTER_VALIDATE_INT);

                $result = $this->carritoVentasEditar->obtenerBalanceComprarDolares($factura, $tipo);

                return Http::json_response($result);
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function todosProductos()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_GET['divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';
            if (empty($_GET['almacen']))
                $this->array_errors[] = 'El almacen es obligatorio';

            if (empty($this->array_errors)) {

                $id_divisa      = filter_input(INPUT_GET, 'divisa', FILTER_VALIDATE_INT);
                $id_almacen     = filter_input(INPUT_GET, 'almacen', FILTER_VALIDATE_INT);

                $result = $this->carritoVentas->todosProducto($id_divisa, $id_almacen);
                if (isset($result['errors'])) {
                    return Http::json_response(['errors' => $result['errors']]);
                } else {
                    return Http::json_response($result);
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function busquedaCategoria()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_GET['divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';
            if (empty($_GET['almacen']))
                $this->array_errors[] = 'El almacen es obligatorio';

            if (empty($this->array_errors)) {

                $id_divisa      = filter_input(INPUT_GET, 'divisa', FILTER_VALIDATE_INT);
                $id_almacen     = filter_input(INPUT_GET, 'almacen', FILTER_VALIDATE_INT);
                $producto       = $this->solicitud->sanitize($_GET['buscar'], FILTER_SANITIZE_STRING);

                $result = $this->carritoVentas->buscarCategoria($producto, $id_divisa, $id_almacen);
                if (isset($result['errors'])) {
                    return Http::json_response(['errors' => $result['errors']]);
                } else {
                    return Http::json_response($result);
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function crearFactura()
    {
        $divisa_master      = Moneda::Predeterminada();
        $divisa_facturar    = Moneda::facturarPredeterminada();
        $almacen            = $this->carritoVentas->obtenerAlmacenesEmpleado();

        $serie = $this->carritoVentasEditar->obtenerSeriesEmpleado($_SESSION['user_data']['emp_id']);

        $idserie = '';
        foreach ($serie as $row) {
            if ($row['empser_predeterminado'] == 1) {
                $idserie = $row['empser_serid'];
            }
        }

        $idalm = '';
        foreach ($almacen as $row) {
            if ($row['empalm_predeterminado'] == 1) {
                $idalm = $row['empalm_almid'];
            }
        }
        $this->notas_entrega_model = new Notasdeentrega();
        $empresa = $this->notas_entrega_model->consultar("Select * From app_empresas")->row();

        Http::json_response([
            'almacenes'             => $almacen,
            'series'                => $this->carritoVentas->obtenerSeries(),
            'divisas'               => $this->carritoVentas->obtenerDivisasParaFacturar(),
            'divisa_master'         => $divisa_master,
            'divisa_facturar'       => $divisa_facturar,
            'almacen_master'        => $idalm,
            'serie'                 => $idserie,
            'crear_nota'            => $this->module->has_module_action_permission('ptv', 'crear_nota', $_SESSION['user_data']['emp_id']),
            'crear_factura'            => $this->module->has_module_action_permission('ptv', 'crear_factura', $_SESSION['user_data']['emp_id']),
            'integrar_iva'          => $empresa['emp_iva']
        ]);
    }

    public function cambiarDocumento()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_GET['id_cliente']))
                $this->array_errors[] = 'No esta definido el id de la factura';
            if (empty($_GET['tipo']))
                $this->array_errors[] = 'Seleccione el tipo de documento';

            $id_cliente     = filter_input(INPUT_GET, 'id_cliente', FILTER_SANITIZE_NUMBER_INT);
            $tipo               = filter_input(INPUT_GET, 'tipo', FILTER_VALIDATE_INT);

            if ($tipo == 1) {
                $_SESSION["ne$id_cliente"] = null;
                return Http::json_response(true);
            }
            if ($tipo == 2) {
                $_SESSION["factura$id_cliente"] = null;
                return Http::json_response(true);
            }
            if ($tipo == 3) {
                $_SESSION["pre$id_cliente"] = null;
                return Http::json_response(true);
            }
            if ($tipo == 4) {
                $_SESSION["pe$id_cliente"] = null;
                return Http::json_response(true);
            }
        }
    }

    public function buscarLineas()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_GET['divisa']))
                $this->array_errors[] = 'La Divisa es obligatorio';
            if (empty($_GET['almacen']))
                $this->array_errors[] = 'El almacen es obligatorio';

            if (empty($this->array_errors)) {

                $id_divisa      = filter_input(INPUT_GET, 'divisa', FILTER_VALIDATE_INT);
                $id_almacen     = filter_input(INPUT_GET, 'almacen', FILTER_VALIDATE_INT);
                $producto       = $this->solicitud->sanitize($_GET['buscar'], FILTER_SANITIZE_STRING);

                $result =  $this->carritoVentas->buscarProducto($producto, $id_divisa, $id_almacen, true, true);
                if (isset($result['errors'])) {
                    return Http::json_response(['errors' => $result['errors']]);
                } else {
                    return Http::json_response($result);
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function actualizarCantidad()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_producto']))
                $this->array_errors[] = 'El Producto es obligatorio';
            if (empty($_POST['cantidad']))
                $this->array_errors[] = 'El Cantidad es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $id_producto        = filter_input(INPUT_POST, 'id_producto', FILTER_VALIDATE_INT);
                $cantidad           = filter_input(INPUT_POST, 'cantidad', FILTER_VALIDATE_FLOAT);
                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_SANITIZE_NUMBER_INT);
                $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_factura > 0 && $id_producto && $cantidad) {
                    if ($tipo == 1) {
                        $this->notas_entrega_model = new Notasdeentrega();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->actualizarCantidad('needitar', 'app_notas_de_entrega', $id_factura, $data_factura['ne_cliid'], $id_producto, $cantidad, $descuento_global);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                    if ($tipo == 3) {
                        $this->notas_entrega_model = new Presupuesto();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->actualizarCantidad('preeditar', 'app_presupuesto', $id_factura, $data_factura['pre_cliid'], $id_producto, $cantidad, $descuento_global, false);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                    if ($tipo == 4) {
                        $this->notas_entrega_model = new Pedidos();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->actualizarCantidad('peeditar', 'app_pedidos', $id_factura, $data_factura['pe_cliid'], $id_producto, $cantidad, $descuento_global, false);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                } else {
                    if ($id_cliente > 0 && $id_producto && $cantidad) {
                        if ($tipo == 1) {
                            $result = $this->carritoVentas->actualizarCantidad('ne', $id_cliente, $id_producto, $cantidad, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 2) {
                            $result = $this->carritoVentas->actualizarCantidad('factura', $id_cliente, $id_producto, $cantidad, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 3) {
                            $result = $this->carritoVentas->actualizarCantidad('pre', $id_cliente, $id_producto, $cantidad, $descuento_global, false);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 4) {
                            $result = $this->carritoVentas->actualizarCantidad('pe', $id_cliente, $id_producto, $cantidad, $descuento_global);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function aplicarDescuentoAdicional()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['empleado']))
                $this->array_errors[] = 'El empleado es obligatorio';
            if (empty($_POST['clave']))
                $this->array_errors[] = 'La clave es obligatorio';

            if (empty($this->array_errors)) {
                $id_factura = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $id_cliente = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $descuento_global = filter_input(INPUT_POST, 'descuento', FILTER_SANITIZE_STRING) ?? 0;
                $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);
                $empleado = $this->solicitud->sanitize($_POST['empleado'], FILTER_SANITIZE_STRING);
                $clave = $this->solicitud->sanitize($_POST['clave'], FILTER_SANITIZE_STRING);


                if ($id_factura > 0) {
                    if (empty($this->array_errors)) {
                        $empleado_model = new Empleado();
                        $usuario = $empleado_model->getUserInfo($empleado);

                        if (!isset($usuario['emp_id'])) {
                            $this->array_errors[] = 'Usuario no encontrado';
                        } else {
                            if (!Seguridad::verificar($clave, $usuario['emp_password'])) {
                                $this->array_errors[] = 'Clave incorrecta';
                            }
                        }
                        if (empty($this->array_errors)) {

                            if ($this->esEditable($id_factura, $tipo)) {
                                if ($tipo == 1) {
                                    $this->notas_entrega_model = new Notasdeentrega();
                                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                                    if ($data_factura) {
                                        $result = $this->carritoVentasEditar->aplicarDescuentoAdicional('needitar', $id_factura, $data_factura['ne_cliid'], $descuento_global);
                                    } else {
                                        $this->array_errors[] = 'Acción prohibida';
                                    }
                                }
                                if ($tipo == 3) {
                                    $this->notas_entrega_model = new Presupuesto();
                                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                                    if ($data_factura) {
                                        $result = $this->carritoVentasEditar->aplicarDescuentoAdicional('preeditar', $id_factura, $data_factura['pre_cliid'], $descuento_global);
                                    } else {
                                        $this->array_errors[] = 'Acción prohibida';
                                    }
                                }
                                if ($tipo == 4) {
                                    $this->notas_entrega_model = new Pedidos();
                                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                                    if ($data_factura) {
                                        $result = $this->carritoVentasEditar->aplicarDescuentoAdicional('peeditar', $id_factura, $data_factura['pe_cliid'], $descuento_global);
                                    } else {
                                        $this->array_errors[] = 'Acción prohibida';
                                    }
                                }

                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        }
                    }
                } else {
                    if ($id_cliente > 0 && $tipo > 0 && $id_factura == 0) {
                        if (empty($this->array_errors)) {

                            $cliente = $this->carritoVentas->obtenerCliente($id_cliente);

                            if ($cliente) {

                                $empleado_model = new Empleado();
                                $usuario = $empleado_model->getUserInfo($empleado);

                                if (!isset($usuario['emp_id'])) {
                                    $this->array_errors[] = 'Usuario no encontrado';
                                } else {
                                    if (!Seguridad::verificar($clave, $usuario['emp_password'])) {
                                        $this->array_errors[] = 'Clave incorrecta';
                                    }
                                }

                                if (empty($this->array_errors)) {
                                    if ($tipo == 1) {
                                        $result = $this->carritoVentas->aplicarDescuentoAdicional('ne', $id_cliente, $descuento_global);
                                        if (isset($result['errors'])) {
                                            return Http::json_response(['errors' => $result['errors']]);
                                        } else {
                                            return Http::json_response($result);
                                        }
                                    }
                                    if ($tipo == 2) {
                                        $result = $this->carritoVentas->aplicarDescuentoAdicional('factura', $id_cliente, $descuento_global);
                                        if (isset($result['errors'])) {
                                            return Http::json_response(['errors' => $result['errors']]);
                                        } else {
                                            return Http::json_response($result);
                                        }
                                    }
                                    if ($tipo == 3) {
                                        $result = $this->carritoVentas->aplicarDescuentoAdicional('pre', $id_cliente, $descuento_global);
                                        if (isset($result['errors'])) {
                                            return Http::json_response(['errors' => $result['errors']]);
                                        } else {
                                            return Http::json_response($result);
                                        }
                                    }
                                    if ($tipo == 4) {
                                        $result = $this->carritoVentas->aplicarDescuentoAdicional('pe', $id_cliente, $descuento_global);
                                        if (isset($result['errors'])) {
                                            return Http::json_response(['errors' => $result['errors']]);
                                        } else {
                                            return Http::json_response($result);
                                        }
                                    }
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function autorizarDescuentoProducto()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['empleado']))
                $this->array_errors[] = 'El empleado es obligatorio';
            if (empty($_POST['clave']))
                $this->array_errors[] = 'La clave es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'Acción prohibida';

            if (empty($this->array_errors)) {

                $id_factura = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $id_cliente = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $descuento = filter_input(INPUT_POST, 'descuento', FILTER_SANITIZE_STRING);
                $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);
                $descuento_global = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING);
                $empleado = $this->solicitud->sanitize($_POST['empleado'], FILTER_SANITIZE_STRING);
                $clave = $this->solicitud->sanitize($_POST['clave'], FILTER_SANITIZE_STRING);
                $unique = $_POST['unique'];


                if ($id_factura > 0) {
                    if (empty($this->array_errors)) {
                        $this->notas_entrega_model = new Notasdeentrega();
                        $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        $cliente = $this->carritoVentasEditar->obtenerCliente($factura['ne_cliid']);

                        if ($factura) {

                            $empleado_model = new Empleado();
                            $usuario = $empleado_model->getUserInfo($empleado);

                            if (!isset($usuario['emp_id'])) {
                                $this->array_errors[] = 'Usuario no encontrado';
                            } else {
                                if (!Seguridad::verificar($clave, $usuario['emp_password'])) {
                                    $this->array_errors[] = 'Clave incorrecta';
                                }
                            }

                            if (empty($this->array_errors)) {
                                $result = $this->carritoVentasEditar->aplicarDescuentoProducto('needitar', $id_factura, $cliente['cli_id'], $unique, $descuento, $descuento_global);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                } else {
                    if ($id_cliente > 0 && $tipo > 0 && $id_factura == 0) {
                        if (empty($this->array_errors)) {

                            $cliente = $this->carritoVentas->obtenerCliente($id_cliente);

                            if ($cliente) {

                                $empleado_model = new Empleado();
                                $usuario = $empleado_model->getUserInfo($empleado);

                                if (!isset($usuario['emp_id'])) {
                                    $this->array_errors[] = 'Usuario no encontrado';
                                } else {
                                    if (!Seguridad::verificar($clave, $usuario['emp_password'])) {
                                        $this->array_errors[] = 'Clave incorrecta';
                                    }
                                }

                                if (empty($this->array_errors)) {
                                    if ($tipo == 1) {
                                        $result = $this->carritoVentas->aplicarDescuentoProducto('ne', $id_cliente, $unique, $descuento, $descuento_global);
                                        if (isset($result['errors'])) {
                                            return Http::json_response(['errors' => $result['errors']]);
                                        } else {
                                            return Http::json_response($result);
                                        }
                                    } else {
                                        $result = $this->carritoVentas->aplicarDescuentoProducto('factura', $id_cliente, $unique, $descuento, $descuento_global);
                                        if (isset($result['errors'])) {
                                            return Http::json_response(['errors' => $result['errors']]);
                                        } else {
                                            return Http::json_response($result);
                                        }
                                    }
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function ventaEnEspera()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {
            if (empty($_POST['id_serie']))
                $this->array_errors[] = 'El campo Serie es obligatorio.';
            if (empty($_POST['id_cliente']))
                $this->array_errors[] = 'Acción prohibida';

            if (empty($this->array_errors)) {

                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $id_sucursal           = filter_input(INPUT_POST, 'id_sucursal', FILTER_VALIDATE_INT);
                $id_serie           = filter_input(INPUT_POST, 'id_serie', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;
                $observaciones      = filter_input(INPUT_POST, 'observaciones', FILTER_SANITIZE_STRING) ?? '';
                $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);
                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
                $agente             = filter_input(INPUT_POST, 'agente', FILTER_VALIDATE_INT);

                $desci          = true;

                if (!$id_cliente || !$id_serie)
                    $this->array_errors[] = 'Datos incorrectos, seleccione el cliente y la serie.';

                if (empty($this->array_errors)) {

                    if ($id_factura == 0) {
                        if (constant('EMP_FIGURA_AGENTE')) {
                            if (!$agente) {
                                $this->array_errors[] = 'Datos incorrectos, seleccione un agente.';
                            }
                        }
                        if ($tipo == 1) {
                            $result = $this->carritoVentas->guardarVenta('app_notas_de_entrega', 'ne', $id_cliente, $id_serie, $id_sucursal, $observaciones, true, $agente, $descuento_global, false);

                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                $_SESSION["ne$id_cliente"] = null;

                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 2) {
                            $result = $this->carritoVentas->guardarVenta('app_factura_master', 'factura', $id_cliente, $id_serie, $id_sucursal, $observaciones, true, $agente, $descuento_global, false);

                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                $_SESSION["factura$id_cliente"] = null;
                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 3) {
                            $result = $this->carritoVentas->guardarVenta('app_presupuesto', 'pre', $id_cliente, $id_serie, $id_sucursal, $observaciones, false, 0, $descuento_global);

                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                $_SESSION["pre$id_cliente"] = null;
                                return Http::json_response($result);
                            }
                        }
                        if ($tipo == 4) {
                            $result = $this->carritoVentas->guardarVenta('app_pedidos', 'pe', $id_cliente, $id_serie, $id_sucursal, $observaciones, false, 0, $descuento_global);

                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                $_SESSION["pe$id_cliente"] = null;
                                return Http::json_response($result);
                            }
                        }
                    } else {
                        if ($id_factura > 0 && $tipo == 1) {
                            $cantidad_descontada = 0;

                            if (empty($this->array_errors)) {

                                $notas_entrega_articulos_model = new NotasdeentregaArticulos();
                                $serie = $this->carritoVentasEditar->obtenerSerie($id_serie);

                                $this->notas_entrega_model = new Notasdeentrega();
                                $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                                $cliente = $this->carritoVentasEditar->obtenerCliente($factura['ne_cliid']);

                                $date = date('Y-m-d');
                                $fecha = date('Y-m-d', strtotime($date)) . ' ' . date('H:i:s');
                                $factor = 1;
                                $total_procosto = 0;
                                $total_costo_servicio = 0;

                                if ($cliente && $serie && $factura) {

                                    if ($this->esEditable($id_factura, 1)) {

                                        $articulos = $this->carritoVentas->contenidoCarrito('needitar', $id_factura);
                                        $ne_decontado = $factura['ne_descontado'];

                                        foreach ($articulos as $row) {
                                            if ($row['precio'] == 0 || $row['total'] == 0) {
                                                $this->array_errors[] = "Lo siento el total del producto <strong>{$row['nombre']}</strong> no puede quedar en cero";
                                            }
                                        }

                                        if (empty($this->array_errors) && ($factura['ne_descontado'] == 1 || $desci == true)) {
                                            $ne_decontado = 1;
                                            foreach ($articulos as $row) {
                                                $detalles_producto = $notas_entrega_articulos_model->obtenerDetalleProductoFacturado($id_factura, $row['id'], $row['id_almacen']);
                                                $cantidad = $this->carritoVentasEditar->chuequearStock($row['id'], $row['id_almacen']);
                                                $data_p = $this->carritoVentasEditar->obtenerProducto($row['id']);
                                                if ($data_p['pro_tipo'] != 3) {
                                                    if ($data_p['pro_nostock'] == 0) {
                                                        if ($data_p['pro_tipo'] == 2) {

                                                            $productoCompuesto = new ProductosCompuestos();

                                                            $productos = $productoCompuesto->obtenerProductosCompuesto($row['id']);

                                                            if (is_countable($productos) && count($productos)) {
                                                                foreach ($productos as $row2) {
                                                                    $cantidad = $this->carritoVentasEditar->chuequearStock($row2['pro_id'], $row['id_almacen']);
                                                                    $cantidadp = $this->carritoVentas->chuequearStock($row['id'], $row['id_almacen']);
                                                                    if ($cantidadp) {
                                                                        if ($detalles_producto) {
                                                                            if ($detalles_producto['neart_procantidad'] < convertir_a_float($row['cantidad']) && $cantidadp['ps_cantidad'] < convertir_a_float($row['cantidad'] - $detalles_producto['neart_descontar_inventario'])) {
                                                                                $this->array_errors[] = "Lo siento la cantidad a descontar del producto {$row['nombre']} supera la cantidad existente en Stock";
                                                                            } else {
                                                                                if ($cantidad) {
                                                                                    $cant = $row['cantidad'] * $row2['pro_cccant'];
                                                                                    $desc = $detalles_producto['neart_descontar_inventario'] * $row2['pro_cccant'];
                                                                                    if ($detalles_producto['neart_procantidad'] < $row['cantidad'] && $cantidad['ps_cantidad'] < ($cant - $desc)) {
                                                                                        $this->array_errors[] = "Lo siento la cantidad a descontar del producto {$row2['pro_nombrecorto']} supera la cantidad existente en Stock del producto compuesto";
                                                                                    }
                                                                                } else {
                                                                                    $this->array_errors[] = "Lo siento el producto {$row2['pro_nombrecorto']} no tiene existencia en el almacen seleccionado";
                                                                                }
                                                                            }
                                                                        } else {
                                                                            if ($cantidadp['ps_cantidad'] < convertir_a_float($row['cantidad'])) {
                                                                                $this->array_errors[] = "Lo siento la cantidad a descontar del producto {$row['nombre']} supera la cantidad existente en Stock";
                                                                            } else {
                                                                                if ($cantidad) {
                                                                                    $cant = $row['cantidad'] * $row2['pro_cccant'];
                                                                                    if ($cantidad['ps_cantidad'] < $cant) {
                                                                                        $this->array_errors[] = "Lo siento la cantidad a descontar del producto {$row['nombre']} supera la cantidad existente en Stock";
                                                                                    }
                                                                                } else {
                                                                                    $this->array_errors[] = "Lo siento el producto {$row['nombre']} no tiene existencia en el almacen seleccionado";
                                                                                }
                                                                            }
                                                                        }
                                                                    } else {
                                                                        $this->array_errors[] = "Lo siento el producto {$row['nombre']} no tiene existencia en el almacen seleccionado";
                                                                    }
                                                                }
                                                            }
                                                        } else {
                                                            $cantidad = $this->carritoVentasEditar->chuequearStock($row['id'], $row['id_almacen']);
                                                            if ($detalles_producto) {
                                                                if ($cantidad) {
                                                                    if ($detalles_producto['neart_procantidad'] < $row['cantidad'] && $cantidad['ps_cantidad'] < ($row['cantidad'] - $detalles_producto['neart_descontar_inventario'])) {
                                                                        $this->array_errors[] = "Lo siento la cantidad a descontar del producto {$row['nombre']} supera la cantidad existente en Stock";
                                                                    }
                                                                } else {
                                                                    $this->array_errors[] = "Lo siento el producto {$row['nombre']} no tiene existencia en el almacen seleccionado";
                                                                }
                                                            } else {
                                                                if ($cantidad) {
                                                                    if ($cantidad['ps_cantidad'] < $row['cantidad']) {
                                                                        $this->array_errors[] = "Lo siento la cantidad a descontar del producto {$row['nombre']} supera la cantidad existente en Stock";
                                                                    }
                                                                } else {
                                                                    $this->array_errors[] = "Lo siento el producto {$row['nombre']} no tiene existencia en el almacen seleccionado";
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }

                                        if (empty($this->array_errors)) {
                                            $this->divisa_master  = $this->notas_entrega_model->obtenerDivisaMaster();

                                            if ($this->divisa_master['div_id'] != $_SESSION["needitar$id_factura"]['divisa']) {
                                                $factor_div = $this->notas_entrega_model->obtenerDivisaAlCambio($_SESSION["needitar$id_factura"]['divisa'], $this->divisa_master['div_id']);
                                                $factor = $factor_div['df_factor'];
                                            }

                                            if ($this->notas_entrega_model->editar($id_factura, [
                                                'ne_subtotal'           => $_SESSION["needitar$id_factura"]['subtotal'],
                                                'ne_descuento'          => $_SESSION["needitar$id_factura"]['descuento'],
                                                'ne_neto'               => $_SESSION["needitar$id_factura"]['neto'],
                                                'ne_iva'                => $_SESSION["needitar$id_factura"]['iva'],
                                                'ne_total'              => $_SESSION["needitar$id_factura"]['total'],
                                                'ne_articulos_total'    => $_SESSION["needitar$id_factura"]['articulos_cantidad'],
                                                'ne_divid'              => $_SESSION["needitar$id_factura"]['divisa'],
                                                'ne_serid'              => $serie['ser_id'],
                                                'ne_serie'              => $serie['ser_descripcion'],
                                                'ne_empresaid'          => 1,
                                                'ne_cliid'              => $cliente['cli_id'],
                                                'ne_env_nombres'        => $cliente['cli_razon_social'],
                                                'ne_env_direccion'      => $cliente['cli_direccion'],
                                                'ne_env_pais'           => $cliente['cli_paisid'],
                                                'ne_env_estado'         => $cliente['cli_estado'],
                                                'ne_env_ciudad'         => $cliente['cli_ciudad'],
                                                'ne_env_codigo_postal'  => $cliente['cli_codpostal'],
                                                'ne_estatus'            => 2,
                                                'ne_observaciones'      => $observaciones,
                                                'ne_descontado'         => $ne_decontado,
                                                'factor'                => $factor
                                            ])) {

                                                foreach ($articulos as $row) {

                                                    $detalles_producto = $notas_entrega_articulos_model->obtenerDetalleProductoFacturado($id_factura, $row['id'], $row['id_almacen']);
                                                    $almacen  = $this->carritoVentasEditar->obtenerAlmacen($row['id_almacen']);
                                                    $producto = $this->carritoVentasEditar->obtenerProducto($row['id']);

                                                    if ($detalles_producto) {

                                                        $cantidad_descontada = $detalles_producto['neart_descontar_inventario'];

                                                        if ($producto['pro_tipo'] != 3) {
                                                            if ($producto['pro_tipo'] == 2) {
                                                                $productoCompuesto = new ProductosCompuestos();
                                                                $cantidad_stockp = $this->carritoVentas->chuequearStock($row['id'], $row['id_almacen']);
                                                                $productos = $productoCompuesto->obtenerProductosCompuesto($row['id']);

                                                                if (is_countable($productos) && count($productos)) {
                                                                    foreach ($productos as $row1) {
                                                                        $cantidad_stock = $this->carritoVentasEditar->chuequearStock($row1['pro_id'], $row['id_almacen']);
                                                                        $cant = $row['cantidad'] * $row1['pro_cccant'];
                                                                        if ($detalles_producto['neart_procantidad'] > $row['cantidad'] && $ne_decontado == 1) {
                                                                            $desc = $detalles_producto['neart_procantidad'] * $row1['pro_cccant'];
                                                                            $cantidad = $desc -  $cant;

                                                                            if ($this->notas_entrega_model->restablecerStock($row1['pro_id'], $row['id_almacen'], $cantidad)) {
                                                                                Notifica::stock($row1['pro_id'], $almacen['alm_nombre'], 'ventas', $cantidad_stock['ps_cantidad'] ?? 0, $cantidad, 0, ($cantidad_stock['ps_cantidad']  ?? 0) + $cantidad, $factura['ne_correlativo'], 1);
                                                                            }
                                                                        } else {
                                                                            if (($desci == true || $ne_decontado == 1) && $detalles_producto['neart_descontar_inventario'] < $row['cantidad']) {
                                                                                $cant = $row['cantidad'] * $row1['pro_cccant'];
                                                                                $desc = $detalles_producto['neart_procantidad'] * $row1['pro_cccant'];
                                                                                $cantidad_a_descontar = $cant - $desc;
                                                                                if ($cantidad_a_descontar > 0 && $this->notas_entrega_model->desontardeStock($row1['pro_id'], $row['id_almacen'], $cantidad_a_descontar)) {
                                                                                    Notifica::stock($row1['pro_id'], $almacen['alm_nombre'], 'ventas', $cantidad_stock['ps_cantidad'] ?? 0, 0, $cantidad_a_descontar, ($cantidad_stock['ps_cantidad'] ?? 0) - $cantidad_a_descontar, $factura['ne_correlativo'], 1);
                                                                                    $cantidad_a_desc = $row['cantidad'] - $detalles_producto['neart_descontar_inventario'];
                                                                                    $cantidad_descontada = $detalles_producto['neart_descontar_inventario'] + $cantidad_a_desc;
                                                                                }
                                                                            }
                                                                        }
                                                                        $total_procosto += $row1['pro_costo'] * $cant;
                                                                    }
                                                                }
                                                                if ($detalles_producto['neart_procantidad'] > convertir_a_float($row['cantidad']) && $ne_decontado == 1) {
                                                                    $cantidadp = convertir_a_float($detalles_producto['neart_procantidad'] - $row['cantidad']);
                                                                    if ($this->notas_entrega_model->restablecerStock($row['id'], $row['id_almacen'], $cantidadp)) {
                                                                        Notifica::stock($row['id'], $almacen['alm_nombre'], 'ventas', $cantidad_stockp['ps_cantidad'] ?? 0, $cantidadp, 0, convertir_a_float(($cantidad_stockp['ps_cantidad'] ?? 0) + $cantidadp), $factura['ne_correlativo'], 1);
                                                                        $cantidad_descontada = convertir_a_float($detalles_producto['neart_descontar_inventario'] - $cantidadp);
                                                                    }
                                                                } else {
                                                                    if (($desci == true || $ne_decontado == 1) && $detalles_producto['neart_descontar_inventario'] < $row['cantidad']) {
                                                                        $cantidad_a_descontarp = $row['cantidad'] - $detalles_producto['neart_descontar_inventario'];
                                                                        if ($cantidad_a_descontarp > 0 && $this->notas_entrega_model->desontardeStock($row['id'], $row['id_almacen'], $cantidad_a_descontarp)) {
                                                                            Notifica::stock($row['id'], $almacen['alm_nombre'], 'ventas', $cantidad_stockp['ps_cantidad'] ?? 0, 0, $cantidad_a_descontarp, convertir_a_float(($cantidad_stockp['ps_cantidad'] ?? 0) - $cantidad_a_descontarp), $factura['ne_correlativo'], 1);
                                                                            $cantidad_descontada = convertir_a_float($detalles_producto['neart_descontar_inventario'] + $cantidad_a_descontarp);
                                                                        }
                                                                    }
                                                                }
                                                            } else {
                                                                $cantidad_stock = $this->carritoVentasEditar->chuequearStock($row['id'], $row['id_almacen']);
                                                                if ($detalles_producto['neart_procantidad'] > $row['cantidad'] && $ne_decontado == 1) {
                                                                    $cantidad = $detalles_producto['neart_procantidad'] - $row['cantidad'];
                                                                    if ($this->notas_entrega_model->restablecerStock($row['id'], $row['id_almacen'], $cantidad)) {
                                                                        Notifica::stock($row['id'], $almacen['alm_nombre'], 'ventas', $cantidad_stock['ps_cantidad'] ?? 0, $cantidad, 0, ($cantidad_stock['ps_cantidad']  ?? 0) + $cantidad, $factura['ne_correlativo'], 1);
                                                                        $cantidad_descontada = $detalles_producto['neart_descontar_inventario'] - $cantidad;
                                                                    }
                                                                } else {
                                                                    if (($desci == true || $ne_decontado == 1) && $detalles_producto['neart_descontar_inventario'] < $row['cantidad']) {
                                                                        $cantidad_a_descontar = $row['cantidad'] - $detalles_producto['neart_descontar_inventario'];
                                                                        if ($cantidad_a_descontar > 0 && $this->notas_entrega_model->desontardeStock($row['id'], $row['id_almacen'], $cantidad_a_descontar)) {
                                                                            Notifica::stock($row['id'], $almacen['alm_nombre'], 'ventas', $cantidad_stock['ps_cantidad'] ?? 0, 0, $cantidad_a_descontar, ($cantidad_stock['ps_cantidad'] ?? 0) - $cantidad_a_descontar, $factura['ne_correlativo'], 1);
                                                                            $cantidad_descontada = $detalles_producto['neart_descontar_inventario'] + $cantidad_a_descontar;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }

                                                        if ($notas_entrega_articulos_model->editar($detalles_producto['neart_id'], [
                                                            'neart_procodigo'               => $row['codigo'],
                                                            'neart_propnombre'              => $row['nombre'],
                                                            'neart_procosto'                => $row['costo'],
                                                            'neart_costo_servicio'          => $row['costo_servicio'],
                                                            'neart_proprecio'               => $row['precio'],
                                                            'neart_procantidad'             => $row['cantidad'],
                                                            'neart_prodescuento'            => $row['descuento'],
                                                            'neart_proneto'                 => $row['neto'],
                                                            'neart_idiva'                   => $row['id_iva'],
                                                            'neart_proiva'                  => $row['iva'],
                                                            'neart_ivatotal'                => $row['iva_total'],
                                                            'neart_prototal'                => $row['total'],
                                                            'neart_descontar_inventario'    => $cantidad_descontada,
                                                        ])) {
                                                            if ($producto['pro_tipo'] == 3) {
                                                                $total_costo_servicio += $row['costo_servicio'] * $row['cantidad'];
                                                            } else {
                                                                if ($producto['pro_tipo'] == 1) {
                                                                    $total_procosto += $row['costo'] * $row['cantidad'];
                                                                }
                                                            }
                                                        }
                                                    } else {

                                                        $cantidad_descontada = 0;

                                                        if ($producto['pro_tipo'] == 2) {
                                                            $productoCompuesto = new ProductosCompuestos();

                                                            $productos = $productoCompuesto->obtenerProductosCompuesto($row['id']);

                                                            if (is_countable($productos) && count($productos)) {
                                                                foreach ($productos as $row1) {
                                                                    $cantidad_stock = $this->carritoVentasEditar->chuequearStock($row1['pro_id'], $row['id_almacen']);
                                                                    $cant = $row['cantidad'] * $row1['pro_cccant'];
                                                                    if ($producto['pro_tipo'] == 2 && ($desci == true || $ne_decontado == 1) && $this->notas_entrega_model->desontardeStock($row1['pro_id'], $row['id_almacen'], $cant)) {

                                                                        Notifica::stock($row1['pro_id'], $almacen['alm_nombre'], 'ventas', $cantidad_stock['ps_cantidad'] ?? 0, 0, $cant, ($cantidad_stock['ps_cantidad'] ?? 0) - $cant, $factura['ne_correlativo'], 1);
                                                                    }
                                                                    $total_procosto += $row1['pro_costo'] * $cant;
                                                                }
                                                            }
                                                            $cantidad_stockp = $this->carritoVentas->chuequearStock($row['id'], $row['id_almacen']);
                                                            if ($producto['pro_tipo'] == 2 && ($desci == true || $ne_decontado == 1) && $this->notas_entrega_model->desontardeStock($row['id'], $row['id_almacen'], convertir_a_float($row['cantidad']))) {
                                                                $cantidad_descontada = convertir_a_float($row['cantidad']);
                                                                Notifica::stock($row['id'], $almacen['alm_nombre'], 'ventas', $cantidad_stockp['ps_cantidad'] ?? 0, 0, $row['cantidad'], convertir_a_float(($cantidad_stockp['ps_cantidad'] ?? 0) - $row['cantidad']), $factura['ne_correlativo'], 1);
                                                            }
                                                        } else {
                                                            $cantidad_stock = $this->carritoVentasEditar->chuequearStock($row['id'], $row['id_almacen']);
                                                            if ($producto['pro_tipo'] == 1 && ($desci == true || $ne_decontado == 1) && $this->notas_entrega_model->desontardeStock($row['id'], $row['id_almacen'], $row['cantidad'])) {
                                                                $cantidad_descontada = $row['cantidad'];
                                                                Notifica::stock($row['id'], $almacen['alm_nombre'], 'ventas', $cantidad_stock['ps_cantidad'] ?? 0, 0, $cantidad_descontada, ($cantidad_stock['ps_cantidad'] ?? 0) - $cantidad_descontada, $factura['ne_correlativo'], 1);
                                                            }
                                                        }


                                                        if ($notas_entrega_articulos_model->guardar([
                                                            'neart_neid'                    => $id_factura,
                                                            'neart_proid'                   => $row['id'],
                                                            'neart_procodigo'               => $row['codigo'],
                                                            'neart_propnombre'              => $row['nombre'],
                                                            'neart_procosto'                => $row['costo'],
                                                            'neart_costo_servicio'          => $row['costo_servicio'],
                                                            'neart_proprecio'               => $row['precio'],
                                                            'neart_procantidad'             => $row['cantidad'],
                                                            'neart_prodescuento'            => $row['descuento'],
                                                            'neart_proneto'                 => $row['neto'],
                                                            'neart_idiva'                   => $row['id_iva'],
                                                            'neart_almid'                   => $row['id_almacen'],
                                                            'neart_proiva'                  => $row['iva'],
                                                            'neart_ivatotal'                => $row['iva_total'],
                                                            'neart_prototal'                => $row['total'],
                                                            'neart_descontar_inventario'    => $cantidad_descontada,
                                                        ], true)) {
                                                            if ($producto['pro_tipo'] == 3) {
                                                                $total_costo_servicio += $row['costo_servicio'] * $row['cantidad'];
                                                            } else {
                                                                if ($producto['pro_tipo'] == 1) {
                                                                    $total_procosto += $row['costo'] * $row['cantidad'];
                                                                }
                                                            }
                                                        }
                                                    }
                                                }

                                                $this->notas_entrega_model->editar($id_factura, [
                                                    'total_procosto' => $total_procosto,
                                                    'total_costo_servicio' => $total_costo_servicio,
                                                ]);

                                                $this->carritoVentasEditar->recalcularComisiones($id_factura, 1);

                                                Http::json_response(ruta_base() . 'ptv?factura=' . $id_factura . '&tipo=1');
                                            } else {
                                                $this->array_errors[] = 'Los siento ocurrio un error al guardar la venta';
                                            }
                                        }
                                    } else {
                                        $this->array_errors[] = 'La nota de entrega a sido pagada en su totalidad por lo tanto no puede ser modificada.';
                                    }
                                }
                            }

                            Http::json_response(['errors' => $this->array_errors]);
                        }
                        if ($id_factura > 0 && $tipo == 2) {
                            $this->array_errors[] = 'No se puede editar o guardar la factura';
                        }
                        if ($id_factura > 0 && $tipo == 3) {
                            $this->notas_entrega_model = new Presupuesto();
                            $notas_entrega_articulos_model = new PresupuestoArticulos();

                            $serie = $this->carritoVentasEditar->obtenerSerie($id_serie);
                            $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                            $cliente = $this->carritoVentasEditar->obtenerCliente($factura['pre_cliid']);

                            $date = date('Y-m-d');
                            $fecha = date('Y-m-d', strtotime($date)) . ' ' . date('H:i:s');
                            $factor = 1;
                            $total_procosto = 0;
                            $total_costo_servicio = 0;


                            if ($cliente && $serie && $factura) {
                                if ($this->esEditable($id_factura, 3)) {
                                    $contenido_carrito = $this->carritoVentasEditar->contenidoCarrito('preeditar', $id_factura);

                                    foreach ($contenido_carrito as $row) {
                                        if ($row['precio'] == 0 || $row['total'] == 0) {
                                            $this->array_errors[] = "Lo siento el total del producto <strong>{$row['nombre']}</strong> no puede quedar en cero";
                                        }
                                    }

                                    if (empty($this->array_errors)) {
                                        if ($this->notas_entrega_model->editar($id_factura, [
                                            'pre_subtotal'           => $_SESSION["preeditar$id_factura"]['subtotal'],
                                            'pre_descuento'          => $_SESSION["preeditar$id_factura"]['descuento'],
                                            'pre_neto'               => $_SESSION["preeditar$id_factura"]['neto'],
                                            'pre_iva'                => $_SESSION["preeditar$id_factura"]['iva'],
                                            'pre_total'              => $_SESSION["preeditar$id_factura"]['total'],
                                            'pre_articulos_total'    => $_SESSION["preeditar$id_factura"]['articulos_cantidad'],
                                            'pre_divid'              => $_SESSION["preeditar$id_factura"]['divisa'],
                                            'pre_serid'              => $serie['ser_id'],
                                            'pre_serie'              => $serie['ser_descripcion'],
                                            'pre_empresaid'          => 1,
                                            'pre_cliid'              => $cliente['cli_id'],
                                            'pre_env_nombres'        => $cliente['cli_razon_social'],
                                            'pre_env_direccion'      => $cliente['cli_direccion'],
                                            'pre_env_pais'           => $cliente['cli_paisid'],
                                            'pre_env_estado'         => $cliente['cli_estado'],
                                            'pre_env_ciudad'         => $cliente['cli_ciudad'],
                                            'pre_env_codigo_postal'  => $cliente['cli_codpostal'],
                                            'pre_estatus'            => 2,
                                            'pre_observaciones'      => $observaciones
                                        ])) {

                                            $notas_entrega_articulos_model->eliminarArticulos($id_factura);

                                            foreach ($contenido_carrito as $row) {

                                                $producto = $this->carritoVentasEditar->obtenerProducto($row['id']);

                                                if ($notas_entrega_articulos_model->guardar([
                                                    'preart_preid'                  => $id_factura,
                                                    'preart_proid'                  => $row['id'],
                                                    'preart_procodigo'              => $row['codigo'],
                                                    'preart_propnombre'             => $row['nombre'],
                                                    'preart_procosto'               => $row['costo'],
                                                    'preart_costo_servicio'         => $row['costo_servicio'],
                                                    'preart_proprecio'              => $row['precio'],
                                                    'preart_procantidad'            => $row['cantidad'],
                                                    'preart_prodescuento'           => $row['descuento'],
                                                    'preart_proneto'                => $row['neto'],
                                                    'preart_idiva'                  => $row['id_iva'],
                                                    'preart_almid'                  => $row['id_almacen'],
                                                    'preart_proiva'                 => $row['iva'],
                                                    'preart_ivatotal'               => $row['iva_total'],
                                                    'preart_prototal'               => $row['total']
                                                ], true)) {
                                                    if ($producto['pro_tipo'] == 3) {
                                                        $total_costo_servicio  += $row['costo_servicio'] * $row['cantidad'];
                                                    } else {
                                                        $total_procosto += $row['costo'] * $row['cantidad'];
                                                    }
                                                }
                                            }

                                            $this->notas_entrega_model->editar($id_factura, [
                                                'total_procosto' => $total_procosto,
                                                'total_costo_servicio' => $total_costo_servicio,
                                            ]);

                                            Http::json_response(ruta_base() . 'ptv?factura=' . $id_factura . '&tipo=3');
                                        } else {
                                            $this->array_errors[] = 'Los siento ocurrio un error al guardar el pedido';
                                        }
                                    }
                                } else {
                                    $this->array_errors[] = 'El presupuesto a sido pagada en su totalidad por lo tanto no puede ser modificada.';
                                }
                            }
                        }
                        if ($id_factura > 0 && $tipo == 4) {
                            $this->notas_entrega_model = new Pedidos();
                            $notas_entrega_articulos_model = new PedidosArticulos();

                            $serie = $this->carritoVentasEditar->obtenerSerie($id_serie);
                            $factura = $this->notas_entrega_model->obtenerFactura($id_factura);

                            $cliente = $this->carritoVentasEditar->obtenerCliente($factura['pe_cliid']);

                            if ($factura['pe_estatus'] == 1) {
                                $this->array_errors[] = 'El pedido a sido pagada en su totalidad por lo tanto no puede ser modificada';
                            } else {
                                $contenido_carrito = $this->carritoVentasEditar->contenidoCarrito('peeditar', $id_factura);
                                $date = date('Y-m-d');
                                $fecha = date('Y-m-d', strtotime($date)) . ' ' . date('H:i:s');
                                $total_costo_servicio = 0;
                                $total_procosto = 0;

                                if ($cliente && $serie && $factura) {
                                    if ($this->esEditable($id_factura, 4)) {
                                        foreach ($contenido_carrito as $row) {
                                            if ($row['precio'] == 0 || $row['total'] == 0) {
                                                $this->array_errors[] = "Lo siento el total del producto <strong>{$row['nombre']}</strong> no puede quedar en cero";
                                            }
                                        }

                                        if (empty($this->array_errors)) {

                                            if ($this->notas_entrega_model->editar($id_factura, [
                                                'pe_subtotal'           => $_SESSION["peeditar$id_factura"]['subtotal'],
                                                'pe_descuento'          => $_SESSION["peeditar$id_factura"]['descuento'],
                                                'pe_neto'               => $_SESSION["peeditar$id_factura"]['neto'],
                                                'pe_iva'                => $_SESSION["peeditar$id_factura"]['iva'],
                                                'pe_total'              => $_SESSION["peeditar$id_factura"]['total'],
                                                'pe_articulos_total'    => $_SESSION["peeditar$id_factura"]['articulos_cantidad'],
                                                'pe_divid'              => $_SESSION["peeditar$id_factura"]['divisa'],
                                                'pe_serid'              => $serie['ser_id'],
                                                'pe_serie'              => $serie['ser_descripcion'],
                                                'pe_empresaid'          => 1,
                                                'pe_cliid'              => $cliente['cli_id'],
                                                'pe_env_nombres'        => $cliente['cli_razon_social'],
                                                'pe_env_direccion'      => $cliente['cli_direccion'],
                                                'pe_env_pais'           => $cliente['cli_paisid'],
                                                'pe_env_estado'         => $cliente['cli_estado'],
                                                'pe_env_ciudad'         => $cliente['cli_ciudad'],
                                                'pe_env_codigo_postal'  => $cliente['cli_codpostal'],
                                                'pe_estatus'            => 2,
                                                'pe_observaciones'      => $observaciones
                                            ])) {

                                                $notas_entrega_articulos_model->eliminarArticulos($id_factura);

                                                foreach ($contenido_carrito as $row) {

                                                    $producto = $this->carritoVentasEditar->obtenerProducto($row['id']);

                                                    if ($notas_entrega_articulos_model->guardar([
                                                        'peart_peid'            => $id_factura,
                                                        'peart_proid'           => $row['id'],
                                                        'peart_procodigo'       => $row['codigo'],
                                                        'peart_propnombre'      => $row['nombre'],
                                                        'peart_procosto'        => $row['costo'],
                                                        'peart_costo_servicio'  => $row['costo_servicio'],
                                                        'peart_proprecio'       => $row['precio'],
                                                        'peart_procantidad'     => $row['cantidad'],
                                                        'peart_prodescuento'    => $row['descuento'],
                                                        'peart_proneto'         => $row['neto'],
                                                        'peart_idiva'           => $row['id_iva'],
                                                        'peart_almid'           => $row['id_almacen'],
                                                        'peart_proiva'          => $row['iva'],
                                                        'peart_ivatotal'        => $row['iva_total'],
                                                        'peart_prototal'        => $row['total']
                                                    ], true)) {
                                                        if ($producto['pro_tipo'] == 3) {
                                                            $total_costo_servicio  += $row['costo_servicio'] * $row['cantidad'];
                                                        } else {
                                                            $total_procosto += $row['costo'] * $row['cantidad'];
                                                        }
                                                    }
                                                }

                                                $this->notas_entrega_model->editar($id_factura, [
                                                    'total_procosto' => $total_procosto,
                                                    'total_costo_servicio' => $total_costo_servicio,
                                                ]);

                                                Http::json_response(ruta_base() . 'ptv?factura=' . $id_factura . '&tipo=4');
                                            } else {
                                                $this->array_errors[] = 'Los siento ocurrio un error al guardar la venta';
                                            }
                                        }
                                    } else {
                                        $this->array_errors[] = 'El pedido a sido pagada en su totalidad por lo tanto no puede ser modificada.';
                                    }
                                }
                            }
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarProducto()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_cliente']))
                $this->array_errors[] = 'El Cliente es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';

            if (empty($this->array_errors)) {

                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRING);
                $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);
                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;

                if ($id_factura == 0 && $id_cliente && $tipo > 0) {

                    $result = "";

                    if ($tipo == 1) {
                        $result = $this->carritoVentas->eliminarProducto('ne', $id_cliente, $unique, $descuento_global);
                    }
                    if ($tipo == 2) {
                        $result = $this->carritoVentas->eliminarProducto('factura', $id_cliente, $unique, $descuento_global);
                    }
                    if ($tipo == 3) {
                        $result = $this->carritoVentas->eliminarProducto('pre', $id_cliente, $unique, $descuento_global);
                    }
                    if ($tipo == 4) {
                        $result = $this->carritoVentas->eliminarProducto('pe', $id_cliente, $unique, $descuento_global);
                    }
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    if ($id_factura > 0 && $tipo == 1) {
                        $this->notas_entrega_model = new Notasdeentrega();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->eliminarProducto('needitar', 'app_notas_de_entrega', $id_factura, $data_factura['ne_cliid'], $unique, $descuento_global);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                    if ($id_factura > 0 && $tipo == 2) {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                    if ($id_factura > 0 && $tipo == 3) {
                        $this->notas_entrega_model = new Presupuesto();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->eliminarProducto('preeditar', 'app_presupuesto', $id_factura, $data_factura['pre_cliid'], $unique, $descuento_global);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                    if ($id_factura > 0 && $tipo == 4) {
                        $this->notas_entrega_model = new Pedidos();
                        $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                        if ($data_factura) {
                            if ($this->esEditable($id_factura, $tipo)) {
                                $result = $this->carritoVentasEditar->eliminarProducto('peeditar', 'app_pedidos', $id_factura, $data_factura['pe_cliid'], $unique, $descuento_global);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'Acción prohibida';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function pagomovil()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            $id_factura = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
            $monto              = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING);
            $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);

            $tipod = '';
            if ($tipo == 1) {
                $this->notas_entrega_model = new Notasdeentrega();
                $tipod = 'ne';
            } else {
                $this->notas_entrega_model = new Pos();
                $tipod = 'fm';
            }

            $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
            $factor = 1;
            if ($factura[$tipod . '_divid'] != 2) {
                $divisa_factor = $this->notas_entrega_model->obtenerDivisaAlCambio($factura[$tipod . '_divid'], 2);
                if ($divisa_factor) {
                    $factor = $divisa_factor['df_factor'];
                }
            }

            $movimiento_model = new MovimientoModel();
            $total_pagos = $movimiento_model->totalPagos($factura[$tipod . '_id'], $tipo, 1);
            $montop = convertir_a_float(($factura[$tipod . '_total'] - ($total_pagos['total'] ?? 0)) * $factor);
            $monto = convertir_a_float($monto);

            $total = convertir_a_float(($monto - $montop));
            //$d=$monto - $factura[$tipod . '_total'];
            Http::json_response($total);
        }
    }

    public function obtenerMetodosSegunDivisa()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_divisa  = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_factura = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
            $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);
            $factor = 1;
            $factorBs = 0;

            if (empty($id_divisa))
                $this->array_errors[] = 'Debe seleccionar una divisa';

            if (!empty($id_factura) && empty($this->array_errors) && !empty($tipo)) {
                $tipod = '';
                if ($tipo == 1) {
                    $this->notas_entrega_model = new Notasdeentrega();
                    $tipod = 'ne';
                } else {
                    $this->notas_entrega_model = new Pos();
                    $tipod = 'fm';
                }

                $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                $divisa = Moneda::obtenerDivisa($id_divisa);

                $divisast = $this->carritoVentasEditar->obtenerDivisasParaFacturar();
                $total_divisa = [];

                if (is_countable($divisast) && count($divisast)) {
                    foreach ($divisast as $row) {
                        if ($row['div_id'] != $id_divisa) {
                            $factor_d =  $this->notas_entrega_model->obtenerDivisaAlCambio($id_divisa, $row['div_id']);
                            $total_divisa[] = [
                                'divisa'          => $row['div_id'],
                                'factor'          => $factor_d['df_factor'],
                                'div_locale'      => $row['div_locale'],
                                'div_simbolo'     => $row['div_simbolo'],
                                'div_decimal'     => $row['div_decimal']
                            ];

                            if ($row['div_id'] == 1) {
                                $factorBs = $factor_d['df_factor'];
                            }
                        }
                    }
                }

                if ($divisa && $factura) {

                    $data_metodos   = $this->notas_entrega_model->obtenerMetodosSegunDivisa($id_divisa);

                    if ($data_metodos) {

                        if ($factura[$tipod . '_divid'] != $divisa['id']) {
                            $divisa_factor = $this->notas_entrega_model->obtenerDivisaAlCambio($factura[$tipod . '_divid'], $divisa['id']);
                            if ($divisa_factor) {
                                $factor = $divisa_factor['df_factor'];
                            } else {
                                $this->array_errors[] = 'Lo siento no se encuentra ningun valor de conversión para la moneda que intenta escoger y la moneda en que se realizo la factura';
                            }
                        }

                        if (empty($this->array_errors)) {

                            $movimiento_model = new MovimientoModel();
                            $total_pagos = $movimiento_model->totalPagos($factura[$tipod . '_id'], $tipo, 1);
                            $total = round(($factura[$tipod . '_total'] - ($total_pagos['total'] ?? 0)), 2);

                            Http::json_response([
                                'factor'        => $factor,
                                'divisa'        => $divisa,
                                'total_divisas'  => $total_divisa,
                                'data_metodos'  => $data_metodos,
                                'metodo'        => $data_metodos[0]['md_id'],
                                'restante'      => $total
                            ]);
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerCuentasSegunMetodo()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_metodo_divisa = filter_input(INPUT_POST, 'id_metodo', FILTER_SANITIZE_NUMBER_INT);
            $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);

            if (empty($id_metodo_divisa))
                $this->array_errors[] = 'Debe seleccionar un metodo';

            if (empty($this->array_errors)) {
                if ($tipo == 1) {
                    $this->notas_entrega_model = new Notasdeentrega();
                } else {
                    $this->notas_entrega_model = new Pos();
                }
                $data = $this->notas_entrega_model->obtenerCuentasSegunMetodo($id_metodo_divisa);
                if ($data) {
                    Http::json_response([
                        'data_metodos' => $data,
                        'metodo'       => $data[0]['cmp_id'],
                        'divisa'       => $data[0]['md_divid']
                    ]);
                } else {
                    $this->array_errors[] = 'Lo siento no hay cuentas registradas para este metodo de pago';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function nombreCuenta($id)
    {
        $cuenta = $this->carritoVentasEditar->obtenerCuenta($id);
        Http::json_response([
            'cuenta' => $cuenta['bc_alias'],
            'metodo' => $cuenta['mp_nombre']
        ]);
    }


    public function anularFactura()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            if ($this->module->has_module_action_permission('facturacion', 'anular_doc', $_SESSION['user_data']['emp_id'])) {

                $id_factura     = filter_input(INPUT_GET, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
                $descripcion    = filter_input(INPUT_GET, 'descripcion', FILTER_SANITIZE_STRING);
                $tipo           = filter_input(INPUT_GET, 'tipo', FILTER_VALIDATE_INT);

                $tipod = '';

                if ($tipo == 1) {
                    $this->notas_entrega_model = new Notasdeentrega();
                    $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    $tipod = 'ne';
                    $new_articulos  = new NotasdeentregaArticulos();
                    $new_movimiento = new MovimientoModel();
                    $new_credito = new Notadecredito();
                } else {
                    $this->notas_entrega_model = new Pos();
                    $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    $tipod = 'fm';
                    $new_articulos  = new PosArticulos();
                    $new_movimiento = new MovimientoModel();
                    $new_credito = new Notadecredito();
                }

                if (!$factura) {
                    $this->array_errors[] = 'ACCESO DENEGADO';
                    return Http::json_response(['errors' => $this->array_errors]);
                } else {
                    if ($factura[$tipod . '_estatus'] == 3) {
                        $this->array_errors[] = 'La nota de entrega ya se encuentra anulada.';
                    }
                }

                if (empty($this->array_errors)) {

                    $correlativo = $this->carritoVentasEditar->chuequearCorrelativo($factura[$tipod . '_serid'], 7);
                    $serie = $this->carritoVentasEditar->obtenerSerie($factura[$tipod . '_serid']);

                    if ($correlativo == false) {
                        $this->array_errors[] = "No existe correlativo entre la se serie $serie[ser_descripcion] y el documento Notas de credito por favor dirijase a Modulo Configuración -> correlativos";
                    }

                    if (empty($this->array_errors)) {

                        $articulos = $new_articulos->articulos($factura[$tipod . '_id']);
                        $movimientos = $new_movimiento->obtenerMovimientosDocumento($factura[$tipod . '_id'], $tipo);
                        $total_pagos = 0;
                        $this->divisa_master = $this->notas_entrega_model->obtenerDivisaMaster();

                        if ($this->notas_entrega_model->editar($factura[$tipod . '_id'], [
                            $tipod . '_estatus' => 3,
                            $tipod . '_observaciones' => $factura[$tipod . '_observaciones'] . ' (ANULADO ' . $descripcion . ')'
                        ])) {

                            $art =  ($tipo == 1) ? 'neart' : 'fa';

                            foreach ($articulos as $row) {
                                $almacen  = $this->carritoVentasEditar->obtenerAlmacen($row[$art . '_almid']);

                                $produc = $this->carritoVentas->obtenerProducto($row[$art . '_proid']);

                                if ($produc['pro_tipo'] == 2) {
                                    $productoCompuesto = new ProductosCompuestos();

                                    $productos = $productoCompuesto->obtenerProductosCompuesto($row[$art . '_proid']);

                                    if (is_countable($productos) && count($productos)) {
                                        foreach ($productos as $row1) {
                                            $cantidad_stock = $this->carritoVentas->chuequearStock($row1['pro_id'], $row[$art . '_almid']);

                                            $cant = $row[$art . '_descontar_inventario'] * $row1['pro_cccant'];

                                            if ($row[$art . '_descontar_inventario'] > 0 && $this->notas_entrega_model->restablecerStock($row1['pro_id'], $row[$art . '_almid'], $cant)) {
                                                Notifica::stock($row1['pro_id'], "{$almacen['alm_nombre']}", 'ventas', $cantidad_stock['ps_cantidad'], $cant, 0, $cantidad_stock['ps_cantidad'] + $cant, $factura[$tipod . '_correlativo'], $tipo);
                                            }
                                        }
                                    }
                                    $cantidad_stocks = $this->carritoVentasEditar->chuequearStock($row[$art . '_proid'], $row[$art . '_almid']);
                                    if ($row[$art . '_descontar_inventario'] > 0 && $this->notas_entrega_model->restablecerStock($row[$art . '_proid'], $row[$art . '_almid'], $row[$art . '_descontar_inventario'])) {
                                        $new_articulos->editar($row[$art . '_id'], [$art . '_descontar_inventario' => 0]);
                                        Notifica::stock($row[$art . '_proid'], "{$almacen['alm_nombre']}", 'ventas', $cantidad_stocks['ps_cantidad'], $row[$art . '_descontar_inventario'], 0, $cantidad_stocks['ps_cantidad'] + $row[$art . '_descontar_inventario'], $factura[$tipod . '_correlativo'], $tipo);
                                    }
                                } else {
                                    $cantidad_stock = $this->carritoVentasEditar->chuequearStock($row[$art . '_proid'], $row[$art . '_almid']);
                                    if ($row[$art . '_descontar_inventario'] > 0 && $this->notas_entrega_model->restablecerStock($row[$art . '_proid'], $row[$art . '_almid'], $row[$art . '_descontar_inventario'])) {
                                        $new_articulos->editar($row[$art . '_id'], [$art . '_descontar_inventario' => 0]);
                                        Notifica::stock($row[$art . '_proid'], "{$almacen['alm_nombre']}", 'ventas', $cantidad_stock['ps_cantidad'], $row[$art . '_descontar_inventario'], 0, $cantidad_stock['ps_cantidad'] + $row[$art . '_descontar_inventario'], $factura[$tipod . '_correlativo'], $tipo);
                                    }
                                }
                            }

                            if (is_countable($movimientos) && count($movimientos)) {

                                foreach ($movimientos as $row) {
                                    if ($row['fab_divisa'] == $this->divisa_master['div_id']) {
                                        $total_pagos += $row['fab_monto'];
                                    } else {
                                        $total_pagos += $row['fab_monto'] / $row['fab_factor_master'];
                                    }
                                }

                                if ($new_credito->guardar([
                                    'cre_cliid'         => $factura[$tipod . '_cliid'],
                                    'cre_facid'         => $factura[$tipod . '_id'],
                                    'cre_docid'         => $tipo,
                                    'cre_empleado'      => $_SESSION['user_data']['emp_id'],
                                    'cre_modulo'        => ($tipo == 1) ? 'NEV' : 'FACV',
                                    'cre_descripcion'   => $descripcion,
                                    'cre_correlativo'   => $correlativo['cor_correlativo'] + 1,
                                    'cre_monto'         => $total_pagos
                                ], true)) {
                                    $this->carritoVentas->actualizarCorrelativo($serie['ser_id'], 7, ($correlativo['cor_correlativo'] + 1));
                                }
                            }

                            $new_comisiones = new EmpleadosComisionesEmplAgente();
                            $new_comisiones->eliminarNotaFactId($id_factura, $tipo);

                            return Http::json_response(ruta_base() . 'ptv?factura=' . $id_factura . '&tipo=' . $tipo);
                        } else {
                            Http::json_response(false);
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para anular el documento.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function comprobarFactura()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
            $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);

            if ($tipo == 1) {
                $this->notas_entrega_model = new Notasdeentrega();
                $tipod = 'ne';
            }
            if ($tipo == 2) {
                $this->notas_entrega_model = new Pos();
                $tipod = 'fm';
            }
            if ($tipo == 3) {
                $this->notas_entrega_model = new Presupuesto();
                $tipod = 'pre';
            }
            if ($tipo == 4) {
                $this->notas_entrega_model = new Pedidos();
                $tipod = 'pe';
            }
            $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
            if ($factura[$tipod . '_estatus'] == 1) {
                $this->array_errors[] = 'Ya la factura a sido pagada en su totalidad';
            } else {
                Http::json_response(true);
            }
            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    private function facturaFinalizada($id_factura, $tipo)
    {
        $tipod = '';

        if ($tipo == 1) {
            $this->notas_entrega_model = new Notasdeentrega();
            $tipod = 'ne';
        } else {
            $this->notas_entrega_model = new Pos();
            $tipod = 'fm';
        }
        $movimiento_model = new MovimientoModel();
        $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
        $total_pagos = $movimiento_model->totalPagos($id_factura, $tipo, 1);
        return (round($total_pagos['total'] ?? 0, 2) >= round($factura[$tipod . '_total'], 2)) ? true : false;
    }

    public function pagar()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            $per_pagar = $this->module->has_module_action_permission('facturacion', 'pagar', $_SESSION['user_data']['emp_id']);

            if ($per_pagar) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
                $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
                $id_metodo_divisa   = filter_input(INPUT_POST, 'id_metodo_divisa', FILTER_SANITIZE_NUMBER_INT);
                $id_cuenta_metodo   = filter_input(INPUT_POST, 'id_cuenta_metodo', FILTER_SANITIZE_NUMBER_INT);
                $monto              = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING);
                $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);
                $generar_credito    = ('true' == $_POST['credito']) ? true : false;
                $referencia         = filter_input(INPUT_POST, 'referencia', FILTER_SANITIZE_STRING);
                $compra_dolares    = ('true' == $_POST['compra_dolares']) ? true : false;
                $cuenta_pagod = json_decode($_POST['cuenta_pagod'], true);
                $factor = filter_input(INPUT_POST, 'factor', FILTER_SANITIZE_STRING);
                //$cuenta_pagod   = ($_POST['cuenta_pagod'] == '') ? 0 : filter_input(INPUT_POST, 'cuenta_pagod', FILTER_SANITIZE_NUMBER_INT);

                if (empty($id_divisa))
                    $this->array_errors[] = 'El campo Divisa el obligatorio.';
                if (empty($id_metodo_divisa))
                    $this->array_errors[] = 'El campo Metodo el obligatorio.';
                if (empty($id_cuenta_metodo))
                    $this->array_errors[] = 'El campo Cuenta el obligatorio.';
                if (empty($monto))
                    $this->array_errors[] = 'El campo Monto el obligatorio.';

                if (!(is_countable($cuenta_pagod) && count($cuenta_pagod)) && $compra_dolares == true) {
                    $this->array_errors[] = 'Debe seleccionar una cuenta para realizar el pago de la compra de dolares.';
                }

                if (!empty($id_factura) && empty($this->array_errors)) {
                    $tipod = '';
                    if ($tipo == 1) {
                        $this->notas_entrega_model = new Notasdeentrega();
                        $tipod = 'app_notas_de_entrega';
                    } else {
                        $this->notas_entrega_model = new Pos();
                        $tipod = 'app_factura_master';
                    }

                    $factura    = $this->notas_entrega_model->obtenerFactura($id_factura);

                    if ($factura && !$this->facturaFinalizada($id_factura, $tipo)) {
                        $result = $this->carritoVentasEditar->pagar($tipod, $monto, $id_divisa, $id_factura, $generar_credito, $id_cuenta_metodo, $id_metodo_divisa, $referencia, $compra_dolares, $cuenta_pagod, $factor);
                        if (isset($result['errors'])) {
                            return Http::json_response(['errors' => $result['errors']]);
                        } else {
                            return Http::json_response($result);
                        }
                    }
                }

                Http::json_response(['errors' => $this->array_errors]);
            }
        }
    }

    public function eliminarPago()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            if ($this->module->has_module_action_permission('facturacion', 'eliminar_pagos', $_SESSION['user_data']['emp_id'])) {

                $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                $id_factura = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
                $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);

                if (!empty($id) && !empty($id_factura)) {

                    $tipod = 0;
                    $documt = '';
                    if ($tipo == 1) {
                        $this->notas_entrega_model = new Notasdeentrega();
                        $tipod = 'ne';
                        $documt = 'NEV #';
                    } else {
                        $this->notas_entrega_model = new Pos();
                        $tipod = 'fm';
                        $documt = 'FACV #';
                    }

                    $factura = $this->notas_entrega_model->obtenerFactura($id_factura);

                    $divisa_master  = $this->notas_entrega_model->obtenerDivisaMaster();

                    if ($factura[$tipod . '_estatus'] == 1) {
                        $this->array_errors[] = 'Lo siento no se puede eliminar el pago ya que la factura a sido cancelada en su totalidad';
                    } else {

                        $movimiento_model = new MovimientoModel();

                        $movimiento = $movimiento_model->abtenerMovimiento($id);

                        if ($movimiento && $factura[$tipod . '_id'] == $movimiento['fab_idgenerico']) {

                            if ($movimiento_model->abtenerMovimientoNegativo($id)) {
                                $this->array_errors[] = 'EL pago no se puede eliminar ya que se encuentra en reverso';
                            } else {

                                $cuenta = $this->notas_entrega_model->consultar("SELECT cmp_cueid, cmp_saldo FROM app_cuentas_metodopago WHERE cmp_id = {$movimiento['fab_cmpid']}")->row();
                                $total_saldo_cuenta = $this->notas_entrega_model->consultar("SELECT bc_saldo FROM app_bancos_cuentas WHERE bc_id = {$cuenta['cmp_cueid']}")->row();
                                $divisa_fac_mov = $this->carritoVentasEditar->obtenerDivisa($movimiento['fab_divisa']);
                                $cliente = $this->carritoVentasEditar->obtenerCliente($factura[$tipod . '_cliid']);

                                $movimiento_model->editar($movimiento['fab_id'], [
                                    'fab_retiro' => 1,
                                ]);

                                if ($movimiento_model->guardar([
                                    'fab_idgenerico'        => $movimiento['fab_idgenerico'],
                                    'fab_doc'               => 1,
                                    'fab_divisa'            => $movimiento['fab_divisa'],
                                    'fab_metodo'            => $movimiento['fab_metodo'],
                                    'fab_cmpid'             => $movimiento['fab_cmpid'],
                                    'fab_monto'             => $movimiento['fab_monto'] * -1,
                                    'fab_factor'            => $movimiento['fab_factor'],
                                    'fab_conversion'        => $movimiento['fab_conversion'] * -1,
                                    'fab_divid_conversion'  => $movimiento['fab_divid_conversion'],
                                    'fab_factor_master'     => $movimiento['fab_factor_master'],
                                    'fab_idretiro'          => $movimiento['fab_id'],
                                    'fab_retiro'            => 1,
                                    'fab_empid'             => $movimiento['fab_empid'],
                                    'fab_modulo'            => $movimiento['fab_modulo'],
                                    'fab_descripcion'       => '',
                                    'fab_observacion'       => 'Devolución ' . $documt . $factura[$tipod . '_correlativo'] . ' ' . $cliente['cli_razon_social'] . ' Monto: ' . Moneda::moneda($movimiento['fab_monto'], $divisa_fac_mov['div_locale'], $divisa_fac_mov['div_simbolo']),
                                    'fab_categoria'         => 1,
                                    'fab_saldo_anterior'    => $total_saldo_cuenta['bc_saldo']
                                ])) {

                                    $this->notas_entrega_model->pagoPositivo($cuenta['cmp_cueid'], ($total_saldo_cuenta['bc_saldo'] - $movimiento['fab_monto']));
                                    $tcm = $cuenta['cmp_saldo'] - $movimiento['fab_monto'];
                                    $this->notas_entrega_model->consultar("UPDATE app_cuentas_metodopago SET cmp_saldo = $tcm WHERE cmp_id = {$movimiento['fab_cmpid']}")->run();

                                    $total_pagos = $movimiento_model->totalPagos($factura[$tipod . '_id'], 1, 1);

                                    $array_abonos = [];
                                    $abonos = $this->notas_entrega_model->abonos($factura[$tipod . '_id']);

                                    if (is_countable($abonos) && count($abonos)) {
                                        foreach ($abonos as $row) {
                                            $divisa_mov = $this->carritoVentasEditar->obtenerDivisa($row['fab_divisa']);
                                            $divisa_conv_mov = $this->carritoVentasEditar->obtenerDivisa($row['fab_divid_conversion']);
                                            $array_abonos[] = [
                                                'fab_id'            => $row['fab_id'],
                                                'fab_fecha'         => $row['fecha'],
                                                'bc_alias'          => $row['bc_alias'],
                                                'bc_tipo'           => $row['bc_tipo'],
                                                'fab_retiro'        => $row['fab_retiro'],
                                                'mp_nombre'         => $row['mp_nombre'],
                                                'fab_monto'         => Moneda::moneda($row['fab_monto'], $divisa_mov['div_locale'], $divisa_mov['div_simbolo']),
                                                'fab_factor'        => Moneda::decimal($row['fab_factor'], $divisa_master['div_locale']),
                                                'fab_conversion'    => Moneda::moneda($row['fab_conversion'], $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo'])
                                            ];
                                        }
                                    }

                                    Http::json_response([
                                        'abonos'        => $array_abonos,
                                        'total_factura' => round($factura[$tipod . '_total'], 2),
                                        'restante'      => round(($factura[$tipod . '_total'] - $total_pagos['total']), 2),
                                        'total_pagado'  => round($total_pagos['total'], 2)
                                    ]);
                                }
                            }
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para eliminar los pagos.';
            }

            Http::json_response(['errors' => Moneda::Predeterminada()]);
        }
    }

    public function imprimir()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_GET['id_factura']) && !empty($_GET['impresora'])) {

                $id_factura     = $this->solicitud->sanitize($_GET['id_factura'], FILTER_VALIDATE_INT);
                $id_impresora   = $this->solicitud->sanitize($_GET['impresora'], FILTER_VALIDATE_INT);
                $tipo           = $this->solicitud->sanitize($_GET['tipo'], FILTER_VALIDATE_INT);

                $tabla = '';
                $tipod = '';
                if ($tipo == 1) {
                    $this->notas_entrega_model = new Notasdeentrega();
                    $tabla = 'app_notas_de_entrega';
                    $tipod = 'ne';
                } else {
                    $this->notas_entrega_model = new Pos();
                    $tabla = 'app_factura_master';
                    $tipod = 'fm';
                }

                if ($id_factura && $id_impresora) {

                    if ($this->notas_entrega_model->existe($tipod . '_id', $id_factura)) {
                        $impresora = $this->notas_entrega_model->consultar("SELECT imp_tipo FROM app_impresoras WHERE imp_id = $id_impresora")->row();
                        if ($impresora) {
                            $result = $this->carritoVentasEditar->imprimir($tabla, $id_factura, $id_impresora);
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function buscarFactNot()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $buscar = $this->solicitud->sanitize($_GET['buscar'], FILTER_SANITIZE_STRING);
            $filtro = $this->solicitud->sanitize($_GET['filtro'], FILTER_SANITIZE_NUMBER_INT);
            $sucursal = $this->solicitud->sanitize($_GET['sucursal'], FILTER_SANITIZE_NUMBER_INT);

            $buscar = strtolower($buscar);

            $timeZone = new DateTimeZone('America/Caracas');
            $fecha_desde = (new DateTime(null, $timeZone))->modify('first day of last month')->format('Y-m-d');
            $fecha_hasta = date('Y-m-d');

            $array_lineas = [];
            $notas = $this->carritoVentas->buscarLineasNEV($buscar, $filtro, $fecha_desde, $fecha_hasta, $sucursal);
            $facuras = $this->carritoVentas->buscarLineasFACV($buscar, $filtro, $fecha_desde, $fecha_hasta, $sucursal);
            $pedidos = $this->carritoVentas->buscarLineasPEDV($buscar, $filtro, $fecha_desde, $fecha_hasta, $sucursal);
            $presupuesto = $this->carritoVentas->buscarLineasPRESV($buscar, $filtro, $fecha_desde, $fecha_hasta, $sucursal);


            $crear_nota = $this->module->has_module_action_permission('ptv', 'crear_nota', $_SESSION['user_data']['emp_id']);
            $crear_factura = $this->module->has_module_action_permission('ptv', 'crear_factura', $_SESSION['user_data']['emp_id']);

            if (is_countable($notas) && count($notas) && $crear_nota) {
                foreach ($notas as $row) {
                    $divisa = $this->carritoVentas->obtenerDivisa($row['ne_divid']);
                    $array_lineas[] = [
                        'ruta_documento'    => ruta_base() . 'ptv?factura=' . $row['ne_id'] . '&tipo=1',
                        'correlativo'       => 'NEV' . $row['ne_correlativo'],
                        'cliente'           => $row['cli_razon_social'],
                        'ruta_producto'     => ruta_base() . 'productos/editar/' . $row['neart_proid'],
                        'id_pro'            => $row['neart_proid'],
                        'cantidad'          => $row['neart_procantidad'],
                        'art_codigo'        => $row['neart_procodigo'],
                        'art_nombre'        => $row['neart_propnombre'],
                        'total'             => Moneda::moneda($row['neart_prototal'], $divisa['div_locale'], $divisa['div_simbolo']),
                        'fecha'             => $row['fecha']
                    ];
                }
            }

            if (is_countable($facuras) && count($facuras) && $crear_factura) {
                foreach ($facuras as $row) {
                    $divisa = $this->carritoVentas->obtenerDivisa($row['fm_divid']);
                    $array_lineas[] = [
                        'ruta_documento'    => ruta_base() . 'ptv?factura=' . $row['fm_id'] . '&tipo=2',
                        'correlativo'       => 'FACV' . $row['fm_correlativo'],
                        'cliente'           => $row['cli_razon_social'],
                        'ruta_producto'     => ruta_base() . 'productos/editar/' . $row['fa_proid'],
                        'id_pro'            => $row['fa_proid'],
                        'cantidad'          => $row['fa_procantidad'],
                        'art_codigo'        => $row['fa_procodigo'],
                        'art_nombre'        => $row['fa_propnombre'],
                        'total'             => Moneda::moneda($row['fa_prototal'], $divisa['div_locale'], $divisa['div_simbolo']),
                        'fecha'             => $row['fecha']
                    ];
                }
            }

            if (is_countable($pedidos) && count($pedidos)) {
                foreach ($pedidos as $row) {
                    $divisa = $this->carritoVentas->obtenerDivisa($row['pe_divid']);
                    $array_lineas[] = [
                        'ruta_documento'    => ruta_base() . 'ptv?factura=' . $row['pe_id'] . '&tipo=4',
                        'correlativo'       => 'PEDV' . $row['pe_correlativo'],
                        'cliente'           => $row['cli_razon_social'],
                        'ruta_producto'     => ruta_base() . 'productos/editar/' . $row['peart_proid'],
                        'id_pro'            => $row['peart_proid'],
                        'cantidad'          => $row['peart_procantidad'],
                        'art_codigo'        => $row['peart_procodigo'],
                        'art_nombre'        => $row['peart_propnombre'],
                        'total'             => Moneda::moneda($row['peart_prototal'], $divisa['div_locale'], $divisa['div_simbolo']),
                        'fecha'             => $row['fecha']
                    ];
                }
            }

            if (is_countable($presupuesto) && count($presupuesto)) {
                foreach ($presupuesto as $row) {
                    $divisa = $this->carritoVentas->obtenerDivisa($row['pre_divid']);
                    $array_lineas[] = [
                        'ruta_documento'    => ruta_base() . 'ptv?factura=' . $row['pre_id'] . '&tipo=3',
                        'correlativo'       => 'PRESV' . $row['pre_correlativo'],
                        'cliente'           => $row['cli_razon_social'],
                        'ruta_producto'     => ruta_base() . 'productos/editar/' . $row['preart_proid'],
                        'id_pro'            => $row['preart_proid'],
                        'cantidad'          => $row['preart_procantidad'],
                        'art_codigo'        => $row['preart_procodigo'],
                        'art_nombre'        => $row['preart_propnombre'],
                        'total'             => Moneda::moneda($row['preart_prototal'], $divisa['div_locale'], $divisa['div_simbolo']),
                        'fecha'             => $row['fecha']
                    ];
                }
            }

            Http::json_response($array_lineas);
        }
    }

    public function obtenerCreditosFactura()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
            $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);

            $creditos = $this->carritoVentasEditar->obtenerCreditosFactura($id_factura, $tipo);

            Http::json_response($creditos);
        }
    }

    public function obtenerCreditos(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_cliente = $this->solicitud->sanitize($id_cliente, FILTER_SANITIZE_NUMBER_INT);

            $newNotaDeCredito = new Notadecredito();
            $newNotadeCreditoDetalles = new NotadeCreditoDetalles();

            $lista_creditos = [];

            $creditos = $newNotaDeCredito->obtenerCreditosClientes($id_cliente);

            if (is_countable($creditos) && count($creditos)) {
                foreach ($creditos as $row) {
                    $total_credito = $newNotadeCreditoDetalles->obtenerTotalPagosCreditos($row['cre_id']);
                    $lista_creditos[] = [
                        'id' => $row['cre_id'],
                        'monto' => $row['cre_monto'] - ($total_credito['total']) ?? 0
                    ];
                }
            }

            Http::json_response($lista_creditos);
        }
    }

    public function pagarConCredito()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax() && (!empty($_GET['id_fac']) && !empty($_GET['id_credito']))) {
            $newCreditoaPagos = new Notadecredito();
            $newNotadeCreditoDetalles = new NotadeCreditoDetalles();
            $movimiento_model = new MovimientoModel();

            $tipo           = $this->solicitud->sanitize($_GET['tipo'], FILTER_VALIDATE_INT);
            $id_factura = $this->solicitud->sanitize($_GET['id_fac'], FILTER_SANITIZE_NUMBER_INT);
            $id_credito = $this->solicitud->sanitize($_GET['id_credito'], FILTER_SANITIZE_NUMBER_INT);

            $tabla = '';
            $tipod = '';
            if ($tipo == 1) {
                $this->notas_entrega_model = new Notasdeentrega();
                $tabla = 'notas de entrega';
                $tipod = 'ne';
            } else {
                $this->notas_entrega_model = new Pos();
                $tabla = 'factura';
                $tipod = 'fm';
            }

            $factura    = $this->notas_entrega_model->obtenerFactura($id_factura);
            $this->divisa_master  = $this->notas_entrega_model->obtenerDivisaMaster();
            if ($this->facturaFinalizada($factura[$tipod . '_id'], $tipo)) {
                Http::json_response('pagado');
            } else {

                $factor_master = 1;
                $factor_factura = 1;

                $data_credito = $newCreditoaPagos->obtener($id_credito);
                $total_credito = $newNotadeCreditoDetalles->obtenerTotalPagosCreditos($data_credito['cre_id']);
                $total_disponible = $data_credito['cre_monto'] - ($total_credito['total']) ?? 0;
                $cliente = $this->carritoVentasEditar->obtenerCliente($factura[$tipod . '_cliid']);
                $total_pagos = $movimiento_model->totalPagos($id_factura, 1, 1);
                $restante = $factura[$tipod . '_total'] - $total_pagos['total'] ?? 0;

                if ($factura[$tipod . '_divid'] != $this->divisa_master['div_id']) {
                    $factor = $this->notas_entrega_model->obtenerDivisaAlCambio($factura[$tipod . '_divid'], $this->divisa_master['div_id']);
                    if (!$factor) {
                        $this->array_errors[] = 'No se encuentra el factor de conversion entre la divisa de la factura y la divisa predeterminada.';
                    } else {
                        $total_disponible = round(($total_disponible / $factor['df_factor']), 2);
                    }
                    $data_factor_factura = $this->notas_entrega_model->obtenerDivisaAlCambio($this->divisa_master['div_id'], $factura[$tipod . '_divid']);
                    if (!$data_factor_factura) {
                        $this->array_errors[] = 'No se encuentra el factor de conversion entre la divisa predeterminada y la divisa en que se registró la factura.';
                    } else {
                        $factor_factura = $data_factor_factura['df_factor'];
                        $factor_master = $data_factor_factura['df_factor'];
                    }
                }

                if (empty($this->array_errors)) {

                    if ($total_disponible > round($restante, 2)) {
                        $monto = $restante;
                    } else {
                        $monto = $total_disponible;
                    }

                    $conversion = $monto / $factor_factura;

                    $id_movimiento = $movimiento_model->guardar([
                        'fab_idgenerico'        => $factura[$tipod . '_id'],
                        'fab_doc'               => $tipo,
                        'fab_monto'             => $conversion,
                        'fab_factor'            => $factor_factura,
                        'fab_conversion'        => $monto,
                        'fab_retiro'            => 0,
                        'fab_factor_master'     => $factor_master,
                        'fab_empid'             => $_SESSION['user_data']['emp_id'],
                        'fab_modulo'            => $tabla,
                        'fab_descripcion'       => '',
                        'fab_observacion'       => 'Pago con saldo Credito en NEV #' . $factura[$tipod . '_correlativo'] . ' ' . $cliente['cli_razon_social'] . ' Monto: ' . Moneda::moneda($monto, $this->divisa_master['div_locale'], $this->divisa_master['div_simbolo']),
                        'fab_credito'           => 1,
                        'fab_categoria'         => 1
                    ]);

                    if ($id_movimiento) {

                        $newNotadeCreditoDetalles->guardar([
                            'credet_movid' => $id_movimiento,
                            'credet_creid' => $data_credito['cre_id'],
                            'credet_idfac' => $factura[$tipod . '_id'],
                            'credet_docid' => $tipo,
                            'credet_monto' => $conversion,
                            'credet_descripcion' => "Pago con nota de credito #{$data_credito['cre_correlativo']} por el monto de $monto",
                            'credet_empid' => $_SESSION['user_data']['einfo_id'],
                            'credet_modulo' => ($tipo == 1) ? 'NEV' : 'FACV'
                        ]);

                        $total_credito = $newNotadeCreditoDetalles->obtenerTotalPagosCreditos($data_credito['cre_id']);

                        if (round($data_credito['cre_monto'], 2) == round($total_credito['total'], 2)) {
                            $newCreditoaPagos->editar($data_credito['cre_id'], [
                                'cre_estatus' => 1
                            ]);
                        }

                        $pagado = false;

                        if ($this->facturaFinalizada($factura[$tipod . '_id'], $tipo)) {
                            $this->notas_entrega_model->culminarFactura($id_factura);
                            $pagado = true;
                        }

                        $factura = $this->notas_entrega_model->obtenerFactura($id_factura);

                        $array_abonos = [];

                        $total_pagos = $movimiento_model->totalPagos($factura[$tipod . '_id'], $tipo, 1);
                        $abonos = $this->notas_entrega_model->abonos($factura[$tipod . '_id']);

                        if (is_countable($abonos) && count($abonos)) {

                            foreach ($abonos as $row) {

                                if (is_null($row['fab_divisa'])) {
                                    $divisa_mov = $this->divisa_master;
                                } else {
                                    $divisa_mov = $this->carritoVentasEditar->obtenerDivisa($row['fab_divisa']);
                                }

                                if (is_null($row['fab_divid_conversion'])) {
                                    $divisa_conv_mov = $this->divisa_master;
                                } else {
                                    $divisa_conv_mov = $this->carritoVentasEditar->obtenerDivisa($row['fab_divid_conversion']);
                                }

                                if (is_null($row['fab_factor'])) {
                                    $row['fab_factor'] = 1;
                                }

                                $array_abonos[] = [
                                    'fab_id'            => $row['fab_id'],
                                    'fab_fecha'         => $row['fecha'],
                                    'bc_alias'          => $row['bc_alias'],
                                    'bc_tipo'           => $row['bc_tipo'],
                                    'fab_retiro'        => $row['fab_retiro'],
                                    'mp_nombre'         => $row['mp_nombre'],
                                    'fab_monto'         => Moneda::moneda($row['fab_monto'], $divisa_mov['div_locale'], $divisa_mov['div_simbolo']),
                                    'fab_factor'        => Moneda::decimal($row['fab_factor'], $this->divisa_master['div_locale']),
                                    'fab_conversion'    => Moneda::moneda($row['fab_conversion'], $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo']),
                                    'credito'           => $row['fab_credito']
                                ];
                            }
                        }

                        Http::json_response([
                            'abonos'        => $array_abonos,
                            'total_factura' => round($factura[$tipod . '_total'], 2),
                            'pagado'        => $pagado,
                            'restante'      => round(($factura[$tipod . '_total'] - $total_pagos['total']), 2),
                            'total_pagado'  => round($total_pagos['total'])
                        ]);
                    }
                } else {
                    Http::json_response(['errors' => $this->array_errors]);
                }
            }
        }
    }

    public function obtenerFactor()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax() && (!empty($_GET['id_factura']) && !empty($_GET['id_credito']))) {
            $id_factura = $this->solicitud->sanitize($_GET['id_factura'], FILTER_VALIDATE_INT);
            $id_credito = $this->solicitud->sanitize($_GET['id_credito'], FILTER_VALIDATE_INT);
            $tipo = $this->solicitud->sanitize($_GET['tipo'], FILTER_VALIDATE_INT);

            $tipod = '';
            if ($tipo == 1) {
                $this->notas_entrega_model = new Notasdeentrega();
                $tipod = 'ne';
            } else {
                $this->notas_entrega_model = new Pos();
                $tipod = 'fm';
            }

            if ($this->notas_entrega_model->existe($tipod . '_id', $id_factura)) {

                $data_factura = $this->notas_entrega_model->obtener($id_factura);
                $this->divisa_master = $this->notas_entrega_model->obtenerDivisaMaster();
                $newCreditoa = new Notadecredito();
                $newNotadeCreditoDetalles = new NotadeCreditoDetalles();

                $data_credito = $newCreditoa->obtener($id_credito);
                $total_credito = $newNotadeCreditoDetalles->obtenerTotalPagosCreditos($data_credito['cre_id']);
                $total_disponible = $data_credito['cre_monto'] - ($total_credito['total']) ?? 0;

                if ($data_factura[$tipod . '_divid'] != $this->divisa_master['div_id']) {
                    $factor = $this->notas_entrega_model->obtenerDivisaAlCambio($data_factura[$tipod . '_divid'], $this->divisa_master['div_id']);
                    if (!$factor) {
                        $this->array_errors[] = 'No se encuentra el factor de conversion entre la divisa predeterminada y la divisa en que se registró la factura.';
                    } else {
                        $total_disponible = round(($total_disponible / $factor['df_factor']), 2);
                    }
                }

                if (empty($this->array_errors)) {
                    Http::json_response($total_disponible);
                } else {
                    Http::json_response(0);
                }
            }
        }
    }

    public function guardarCliente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $tipo           = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_STRING);
            $cli_tipodoc    = filter_input(INPUT_POST, 'cli_tipodoc', FILTER_SANITIZE_NUMBER_INT);
            $cli_dni        = filter_input(INPUT_POST, 'cli_dni', FILTER_SANITIZE_STRING);
            $razon_social   = filter_input(INPUT_POST, 'cli_razon_social', FILTER_SANITIZE_STRING);
            $cli_telefono   = filter_input(INPUT_POST, 'cli_telefono', FILTER_SANITIZE_STRING);
            $cli_direccion  = filter_input(INPUT_POST, 'cli_direccion', FILTER_SANITIZE_STRING);
            $cli_natural    = ('true' == filter_input(INPUT_POST, 'cli_natural')) ? 1 : 0;

            if (empty($cli_tipodoc))
                $this->array_errors[] = "El campo cedula de identidad es obligatorio.";
            if (empty($cli_dni))
                $this->array_errors[] = "El campo Tipo de documento es obligatorio.";
            if (empty($razon_social))
                $this->array_errors[] = "El campo Razón social es obligatorio.";
            if (empty($cli_telefono))
                $this->array_errors[] = "El campo Telefono es obligatorio.";
            if (empty($cli_direccion))
                $this->array_errors[] = "El campo Direccion es obligatorio.";

            if (empty($this->array_errors)) {

                $cliente_model = new Cliente();

                if (empty($_POST['cli_email'])) {
                    $cli_email = NULL;
                } else {
                    $cli_email = filter_input(INPUT_POST, 'cli_email', FILTER_VALIDATE_EMAIL);
                    if (!$cli_email)
                        $this->array_errors[] = 'Correo invalido';
                    if ($cliente_model->existe('cli_email', $cli_email))
                        $this->array_errors[] = "El correo electronico $cli_email ya se encuentra en uso";
                }

                if ($cliente_model->existe('cli_dni', $cli_dni))
                    $this->array_errors[] = "La cedula de identidad $cli_dni ya se encuentra en uso";
                if ($cliente_model->existe('cli_email', $cli_email))
                    $this->array_errors[] = "El correo electronico $cli_email ya se encuentra en uso";

                //if (valida_email($cli_email) == false)
                //array_push($this->array_errors, "La correo $cli_email no es correcto");
                if (empty($this->array_errors) && empty($this->array_errors)) {
                    $data_id = $cliente_model->guardar([
                        'cli_tipodocid'     => $cli_tipodoc,
                        'cli_dni'           => $cli_dni,
                        'cli_razon_social'  => $razon_social,
                        'cli_email'         => $cli_email,
                        'cli_telefono'      => $cli_telefono,
                        'cli_direccion'     => $cli_direccion,
                        'cli_contribuyente' => 1,
                        'cli_fecha_reg'     => date('Y-m-d H:i:s'),
                        'cli_natural'       => $cli_natural
                    ]);
                    if ($data_id) {

                        $cliente_direccion_envio_model = new Clientedireccionenvios();

                        $cliente_direccion_envio_model->guardar([
                            'cde_cliid'     => $data_id,
                            'cde_direccion' => $cli_direccion
                        ]);

                        if ($tipo == 1) {
                            $_SESSION["ne$data_id"] = null;
                        }
                        if ($tipo == 2) {
                            $_SESSION["factura$data_id"] = null;
                        }
                        if ($tipo == 3) {
                            $_SESSION["pre$data_id"] = null;
                        }
                        if ($tipo == 4) {
                            $_SESSION["pe$data_id"] = null;
                        }
                        Http::json_response([
                            'id' => $data_id,
                            'cliente' => $razon_social,
                            'dni' => $cli_dni
                        ]);
                    } else {
                        Http::json_response(false);
                    }
                }
            }

            $data['errors'] = $this->array_errors;
            Http::json_response($data);
        }
    }

    public function actualizarPrecio()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_cliente']))
                $this->array_errors[] = 'El Cliente es obligatorio';
            if (empty($_POST['unique']))
                $this->array_errors[] = 'El Producto es obligatorio';

            if (empty($this->array_errors)) {

                $id_cliente         = filter_input(INPUT_POST, 'id_cliente', FILTER_VALIDATE_INT);
                $unique             = filter_input(INPUT_POST, 'unique', FILTER_SANITIZE_STRIPPED);
                $precio             = filter_input(INPUT_POST, 'precio', FILTER_SANITIZE_STRING) ?? 0;
                $descuento_global   = filter_input(INPUT_POST, 'descuento_global', FILTER_SANITIZE_STRING) ?? 0;
                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);

                $empleado           = filter_input(INPUT_POST, 'empleado', FILTER_SANITIZE_STRING);
                $clave              = filter_input(INPUT_POST, 'clave', FILTER_SANITIZE_STRING);

                $empleado_model = new Empleado();
                $usuario = $empleado_model->getUserInfo($empleado);

                if (!isset($usuario['emp_id'])) {
                    $this->array_errors[] = 'Usuario no encontrado';
                } else {
                    if (!Seguridad::verificar($clave, $usuario['emp_password'])) {
                        $this->array_errors[] = 'Clave incorrecta';
                    }
                }
                if (empty($this->array_errors)) {

                    if ($id_factura == 0 && $id_cliente > 0 && $precio > 0) {
                        $result = [];
                        if ($tipo == 1) {
                            $result = $this->carritoVentas->actualizarPrecio('ne', $id_cliente, $unique, $precio, $descuento_global);
                        }
                        if ($tipo == 2) {
                            $result = $this->carritoVentas->actualizarPrecio('factura', $id_cliente, $unique, $precio, $descuento_global);
                        }
                        if ($tipo == 3) {
                            $result = $this->carritoVentas->actualizarPrecio('pre', $id_cliente, $unique, $precio, $descuento_global);
                        }
                        if ($tipo == 4) {
                            $result = $this->carritoVentas->actualizarPrecio('pe', $id_cliente, $unique, $precio, $descuento_global);
                        }
                        if (isset($result['errors'])) {
                            return Http::json_response(['errors' => $result['errors']]);
                        } else {
                            return Http::json_response($result);
                        }
                    } else {
                        if ($id_factura > 0 && $id_cliente > 0 && $precio > 0) {

                            if ($tipo == 1) {
                                $this->notas_entrega_model = new Notasdeentrega();
                                $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);

                                if ($data_factura) {
                                    if ($this->esEditable($id_factura, $tipo)) {
                                        $result = $this->carritoVentasEditar->actualizarPrecio('needitar', $id_factura, $id_cliente, $unique, $precio, $descuento_global);
                                        if (isset($result['errors'])) {
                                            return Http::json_response(['errors' => $result['errors']]);
                                        } else {
                                            return Http::json_response($result);
                                        }
                                    } else {
                                        $this->array_errors[] = 'Acción prohibida';
                                    }
                                } else {
                                    $this->array_errors[] = 'Acción prohibida';
                                }
                            }
                            if ($tipo == 3) {
                                $this->notas_entrega_model = new Presupuesto();
                                $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);

                                if ($data_factura) {
                                    if ($this->esEditable($id_factura, $tipo)) {
                                        $result = $this->carritoVentasEditar->actualizarPrecio('preeditar', $id_factura, $data_factura['pre_cliid'], $unique, $precio, $descuento_global);
                                        if (isset($result['errors'])) {
                                            return Http::json_response(['errors' => $result['errors']]);
                                        } else {
                                            return Http::json_response($result);
                                        }
                                    } else {
                                        $this->array_errors[] = 'Acción prohibida';
                                    }
                                } else {
                                    $this->array_errors[] = 'Acción prohibida';
                                }
                            }
                            if ($tipo == 4) {
                                $this->notas_entrega_model = new Pedidos();
                                $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);

                                if ($data_factura) {
                                    if ($this->esEditable($id_factura, $tipo)) {
                                        $result = $this->carritoVentasEditar->actualizarPrecio('peeditar', $id_factura, $data_factura['pe_cliid'], $unique, $precio, $descuento_global);
                                        if (isset($result['errors'])) {
                                            return Http::json_response(['errors' => $result['errors']]);
                                        } else {
                                            return Http::json_response($result);
                                        }
                                    } else {
                                        $this->array_errors[] = 'Acción prohibida';
                                    }
                                } else {
                                    $this->array_errors[] = 'Acción prohibida';
                                }
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerProductosCompuestos(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            $newComp = new ProductosCompuestos();

            Http::json_response($newComp->obtenerProductosCompuesto($id));
        }
    }

    public function obtnerDocumentos()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_factura = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
            $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);
            $archivo_all = [];

            if (!empty($id_factura)) {
                if ($tipo == 1) {
                    $facturadocumentos_model = new NotasdeentregaDocumentos();

                    $archivos = $facturadocumentos_model->obtenerDocumentos($id_factura);

                    $extenciones = array('jpg', 'jpeg', 'png', 'gif');

                    if (is_countable($archivos) && count($archivos)) {

                        foreach ($archivos as $row) {

                            $fileNameCmps = explode(".", basename($row['nedoc_documento']));
                            $fileExtension = strtolower(end($fileNameCmps));

                            $imagen = (in_array($fileExtension, $extenciones)) ? true : false;
                            $archivo_all[] = [
                                'imagen' => $imagen,
                                'archivo' => $row['nedoc_documento'],
                                'descripcion' => $row['nedoc_descripcion'],
                                'fecha' => $row['nedoc_fecha']
                            ];
                        }
                    }

                    Http::json_response($archivo_all);
                }
                if ($tipo == 2) {
                    $facturadocumentos_model = new FacturaDocumentos();
                    $archivos = $facturadocumentos_model->obtenerDocumentos($id_factura);

                    $extenciones = array('jpg', 'jpeg', 'png', 'gif');

                    if (is_countable($archivos) && count($archivos)) {

                        foreach ($archivos as $row) {

                            $fileNameCmps = explode(".", basename($row['facdoc_documento']));
                            $fileExtension = strtolower(end($fileNameCmps));

                            $imagen = (in_array($fileExtension, $extenciones)) ? true : false;
                            $archivo_all[] = [
                                'imagen' => $imagen,
                                'archivo' => $row['facdoc_documento'],
                                'descripcion' => $row['facdoc_descripcion'],
                                'fecha' => $row['facdoc_fecha']
                            ];
                        }
                    }

                    Http::json_response($archivo_all);
                }
            }
        }
    }

    public function enviarDocumento()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] = 'Acción prohibida';
            if (empty($_POST['descripcion']))
                $this->array_errors[] = 'El campo Descripcion es obligatorio.';
            if (empty($_FILES['documento']))
                $this->array_errors[] = 'El documento es obligatorio.';

            if (empty($this->array_errors)) {

                $id_factura = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
                $descripcion = $this->solicitud->sanitize($_POST['descripcion'], FILTER_SANITIZE_STRING);
                $tipo               = filter_input(INPUT_POST, 'tipo', FILTER_VALIDATE_INT);

                if ($id_factura) {
                    if ($tipo == 1) {
                        $result = $this->carritoVentasEditar->enviarDocumento('app_notas_de_entrega', $id_factura, $_FILES, $descripcion);
                        if (isset($result['errors'])) {
                            return Http::json_response(['errors' => $result['errors']]);
                        } else {
                            return Http::json_response($result);
                        }
                    }
                    if ($tipo == 2) {
                        $result = $this->carritoVentasEditar->enviarDocumento('app_factura_master', $id_factura, $_FILES, $descripcion);
                        if (isset($result['errors'])) {
                            return Http::json_response(['errors' => $result['errors']]);
                        } else {
                            return Http::json_response($result);
                        }
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function guardarDetallesCliente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['cli_dni']))
                $this->array_errors[] = 'El campo Tipo de documento es obligatorio';
            if (empty($_POST['cli_razon_social']))
                $this->array_errors[] = 'El campo Razón social es obligatorio';
            if (empty($_POST['cli_direccion']))
                $this->array_errors[] = 'El campo Dirección es obligatorio';

            if (empty($this->array_errors)) {

                $cli_id             = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                $cli_dni            = $this->solicitud->sanitize($_POST['cli_dni'], FILTER_SANITIZE_STRING);
                $cli_nombres        = $this->solicitud->sanitize($_POST['cli_razon_social'], FILTER_SANITIZE_STRING);
                $cli_direccion      = $this->solicitud->sanitize($_POST['cli_direccion'], FILTER_SANITIZE_STRING);
                $cli_telefono       = $this->solicitud->sanitize($_POST['cli_telefono'], FILTER_SANITIZE_STRING);
                $cli_fecha_nac      = $this->solicitud->sanitize($_POST['cli_fecha_nac'], FILTER_SANITIZE_STRING);
                $cli_email          = $this->solicitud->sanitize($_POST['cli_email'], FILTER_SANITIZE_STRING);

                $agente =  $this->solicitud->sanitize($_POST['id_agente'], FILTER_SANITIZE_NUMBER_INT);
                $captado  = $this->solicitud->sanitize($_POST['id_captado'], FILTER_SANITIZE_STRING);
                $factura  = $this->solicitud->sanitize($_POST['factura'], FILTER_SANITIZE_STRING);
                $tipo  = $this->solicitud->sanitize($_POST['tipo'], FILTER_SANITIZE_NUMBER_INT);

                $result = $this->carritoVentas->editarDetallesCliente($cli_id, [
                    'cli_dni'             => $cli_dni,
                    'cli_razon_social'  => $cli_nombres,
                    'cli_direccion'     => $cli_direccion,
                    'cli_telefono'      => $cli_telefono,
                    'cli_fecha_nac'     => $cli_fecha_nac,
                    'cli_email'         => $cli_email,
                ]);

                if (!empty($agente) && $agente > 0) {
                    $newAgent = new EmpleadoAgente();

                    if ($newAgent->consultar("SELECT * FROM app_empleados_agentes WHERE empagent_empid = {$agente} AND empagent_clientid = {$cli_id} AND empagent_docid={$factura} AND empagent_tipo={$tipo}")->row()) {
                        if ($newAgent->modificarAgente($cli_id, $agente, $captado, $factura, 1)) {
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        } else {
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                    } else {
                        $this->array_errors[] = 'Este cliente no tiene asignado un agente';
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function cne()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['cli_dni']))
                Http::json_response('El numero del documento es obligatorio');
            if (empty($_POST['tipo']))
                Http::json_response('El campo Tipo de documento es obligatorio');

            if (empty($this->array_errors)) {

                $cli_tipo             =  $this->solicitud->sanitize($_POST['tipo'], FILTER_SANITIZE_NUMBER_INT);
                $cli_dni            = $this->solicitud->sanitize($_POST['cli_dni'], FILTER_SANITIZE_STRING);

                $tipo = $dni = '';
                if ($cli_tipo == 2) {
                    $dni = str_replace('V', '', $cli_dni);

                    if (strlen($dni) < 7) {
                        Http::json_response('Verifique los numeros del documento.');
                    }
                    $tipo = 'V';
                } else {
                    $dni = str_replace('J', '', $cli_dni);
                    $tipo = 'J';
                    if (strlen($dni) < 8) {
                        Http::json_response('Verifique los numeros del documento.');
                    }
                }

                $url = "http://www.cne.gob.ve/web/registro_electoral/ce.php?nacionalidad=$tipo&cedula=$dni";
                $resource = self::geUrl($url);
                if ($resource == false) {
                    Http::json_response('No hay repuesta del servidor CNE.');
                }

                $text = strip_tags($resource);
                $findme = 'REGISTRO ELECTORAL'; // Identifica que si es población Votante
                $pos = strpos($text, $findme);

                $findme2 = 'ADVERTENCIA'; // Identifica que si es población Votante
                $pos2 = strpos($text, $findme2);
                $datoJson = [];
                if ($pos == TRUE and $pos2 == FALSE) {
                    // Codigo buscar votante
                    $rempl = array('Cédula:', 'Nombre:', 'Estado:', 'Municipio:', 'Parroquia:', 'Centro:', 'Dirección:', 'SERVICIO ELECTORAL', 'Mesa:');
                    $r = trim(str_replace($rempl, '|', self::limpiarCampo($text)));
                    $resource = explode("|", $r);
                    $datos = explode(" ", self::limpiarCampo($resource[2]));
                    Http::json_response(['error' => 0, 'nacionalidad' => $tipo, 'cedula' => $dni, 'nombres' => $datos[0] . ' ' . $datos[1], 'apellidos' => $datos[2] . ' ' . $datos[3], 'inscrito' => 'SI', 'cvestado' => self::limpiarCampo($resource[3]), 'cvmunicipio' => self::limpiarCampo($resource[4]), 'cvparroquia' => self::limpiarCampo($resource[5]), 'centro' => self::limpiarCampo($resource[6]), 'direccion' => self::limpiarCampo($resource[7])]);
                } elseif ($pos == FALSE and $pos2 == FALSE) {
                    Http::json_response('No inscrito CNE.');
                } elseif ($pos == FALSE and $pos2 == TRUE) {
                    Http::json_response('No inscrito CNE.');
                } else {
                    Http::json_response('No inscrito CNE.');
                }
            }
        }
    }

    public static function geUrl($url)
    {
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true); // almacene en una variable
        curl_setopt($curl, CURLOPT_HEADER, FALSE);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 3000);
        curl_setopt($curl, CURLOPT_TIMEOUT, 3000); //timeout in seconds
        if (curl_exec($curl) === false) {
            //echo 'Curl error: ' . curl_error($curl);
            curl_close($curl);
            $return = false;
        } else {
            $return = curl_exec($curl);
        }
        curl_close($curl);
        return $return;
    }
    public static function limpiarCampo($valor)
    { //Con esto limpiamos los errores de la pagina
        $rempl = array('\n', '\t');
        $r = trim(str_replace($rempl, ' ', $valor));
        return str_replace("\r", "", str_replace("\n", "", str_replace("\t", "", $r)));
    }
}
