<?php

use Core\Helpers\moneda;

?>
<div class="container">
    <div class="page-inner" id="AppProveedoreslista" v-cloak>
        <div class="page-header">
            <h4 class="page-title">Productos por proveedores</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('proveedores') ?>">Lista de productos por proveedores</a>
                </li>
            </ul>
            <div class="ml-md-auto" style="display: flex;">
                <button type="button" class="btn btn-success btn-border btn-round mr-2" @click="modal_producto()"><i class="fa fa-plus"></i> Nuevo producto</button>
                <button type="button" class="btn btn-secondary btn-round mr-2" @click="modal_csv()"><i class="fas fa-question-circle"></i> Subir CSV</button>
            </div>
        </div>
        <div class="card">
            <div class="card-body">
                <div class="table-responsive" :class="cargando_tabla">
                    <table class="display table table-striped table-hover dataTable" id="tabla_lista">
                        <thead>
                            <tr>
                                <th class="text-center">
                                    <label for="checkbox-todos" class="form-check-label">
                                        <input class="form-check-input" type="checkbox" class="checkbox-todos" @change="checktodos($event)">
                                        <span class="form-check-sign"></span>
                                    </label>
                                </th>
                                <th>Fecha</th>
                                <th>Producto</th>
                                <th>Proveedor</th>
                                <th>Precio</th>
                                <th>Estado / Ciudad</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in proveedores">
                                <td class="text-center">
                                    <label :for="'check'+row.pprov_id" class="form-check-label">
                                        <input class="form-check-input" type="checkbox" v-model="row.checked" :id="'part'+row.pprov_id">
                                        <span class="form-check-sign"></span>
                                    </label>
                                </td>
                                <td>{{row.pprov_fecha}}</td>
                                <td>{{row.pprov_producto}}</td>
                                <td>{{row.prov_razonsocial}}</td>
                                <td>{{ moneda(row.pprov_precio, money.locale, money.prefix, money.precision) }}</td>
                                <td>{{row.prov_estado}} / {{row.prov_ciudad}}</td>
                                <td>
                                    <button type="button" id="eliminar" class="eliminar btn btn-icon btn-sm btn-light" @click="eliminar(row.pprov_id,row.pprov_producto)" style="box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;"><i class="fa fa-trash text-danger" style="padding: .65rem;"></i>
                                    </button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col d-flex justify-content-end">
                <a href="#" class="btn btn-danger btn-sm btn-round mr-3" @click.prevent="eliminarProveedores()">Eliminar proveedores seleccionados</a>
                <a href="#" class="btn btn-warning btn-sm btn-round mr-3" @click.prevent="modal_proveedor()">Eliminar por proveedor</a>
            </div>
        </div>
        <?php include 'modal_csv.php'; ?>
        <?php include 'modal_producto.php'; ?>
        <?php include 'modal_proveedor.php'; ?>
    </div>
</div>

<script src="<?= asset('assets/vue-select.js') ?>"></script>
<link rel="stylesheet" href="<?= asset('assets/vue-select.css') ?>">
<script src="<?= ruta_base() ?>public/assets/vue-the-mask.js"></script>
<script src="<?= asset('assets/v-money.js') ?>"></script>
<script src="<?= asset('assets/underscore-min.js') ?>"></script>
<script src="<?= ruta_base() ?>public/assetsvuejs/proveedores/lista.js"></script>