<div class="container">
    <div class="page-inner" id="AppCrearProveedor" v-cloak>
        <div class="page-header">
            <h4 class="page-title">Proveedores</h4>
            <ul class="breadcrumbs">
                <li class="nav-home">
                    <a href="<?= ruta_base() ?>">
                        <i class="flaticon-home"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('proveedores') ?>">Proveedores</a>
                </li>
                <li class="separator">
                    <i class="flaticon-right-arrow"></i>
                </li>
                <li class="nav-item">
                    <a href="<?= url('proveedores/crear') ?>">Crear</a>
                </li>
            </ul>
        </div>
        <form autocomplete="off" @submit.prevent="guardar">
            <div class="card">
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Código</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-hashtag fa-fw"></i></span>
                                    </div>
                                    <input type="text" class="form-control" v-model="dataForm.codigo">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="tipo_documento" class="placeholder">Tipo de documento</label>
                                <select class="form-control" id="tipo_documento" v-model="dataForm.tipoidfiscal" required="">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <?php foreach ($tipo_de_documentos as $row) : ?>
                                        <option value="<?= $row['tipodoc_id'] ?>"><?= $row['tipodoc_codigo'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="cifnif">Núm. fiscal</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-id-card fa-fw"></i></span>
                                    </div>
                                    <input type="text" id="cifnif" class="form-control" maxlength="30" v-model="dataForm.cifnif">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="">Nombre</label>
                                <input type="text" id="nombre" class="form-control" maxlength="100" v-model="dataForm.nombre" @keyup="dataForm.nombre=dataForm.nombre.toUpperCase()">
                                <small class="form-text text-muted">Nombre por el que es conocido el proveedor. Para uso interno.</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="razonsocial">Razón Social</label>
                                <input type="text" name="razonsocial" class="form-control" maxlength="100" v-model="dataForm.razonsocial" @keyup="dataForm.razonsocial=dataForm.razonsocial.toUpperCase()">
                                <small class="form-text text-muted">Descripción nombre de empresa de proveedor</small>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="telefono1">Teléfono</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-phone fa-fw"></i></span>
                                    </div>
                                    <input type="tel" id="telefono1" class="form-control" v-mask="'(####) ###-####'" v-model="dataForm.telefono1">
                                </div>
                            </div>
                            <small class="form-text text-muted">(0000) 000-0000</small>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="telefono2">Teléfono 2</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-mobile-alt fa-fw"></i>
                                        </span>
                                    </div>
                                    <input type="tel" id="telefono2" class="form-control" v-mask="'(####) ###-####'" v-model="dataForm.telefono2">
                                </div>
                                <small class="form-text text-muted">(0000) 000-0000</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="email">Email</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">
                                            <i class="fas fa-envelope fa-fw"></i>
                                        </span>
                                    </div>
                                    <input type="email" id="email" class="form-control" maxlength="100" v-model="dataForm.email">
                                </div>
                                <small class="form-text text-muted">usuario@ejemplo.com</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="web">Web</label>
                                <input type="text" name="web" class="form-control" maxlength="100" v-model="dataForm.web">
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="pais">Pais</label>
                                <select id="pais" class="form-control" v-model="dataForm.pais">
                                    <?php foreach ($pais as $row) : ?>
                                        <option value="<?= $row['pa_id'] ?>"><?= $row['pa_nombre'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="estado">Estado</label>
                                <input type="text" id="estado" class="form-control" v-model="dataForm.estado">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="ciudad">Ciudad</label>
                                <input type="text" id="ciudad" class="form-control" v-model="dataForm.ciudad">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="codigo_postal">Código postal</label>
                                <input type="text" id="codigo_postal" class="form-control" v-model="dataForm.codigo_postal">
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="direccion">Dirección</label>
                        <input type="text" id="direccion" class="form-control" v-model="dataForm.direccion">
                    </div>
                    <?php /*
                    <div class="form-row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="codserie">Serie</label>
                                <select name="codserie" class="form-control" v-model="dataForm.serie">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <?php foreach ($series as $row) : ?>
                                        <option value="<?= $row->ser_id; ?>"><?= $row->ser_descripcion; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="codpago">Forma de pago</label>
                                <select id="codpago" class="form-control" v-model="dataForm.mpid">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <?php foreach ($metodos_pago as $row) : ?>
                                        <option value="<?= $row->mp_id; ?>"><?= $row->mp_descripcion; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="codimpuestoportes">Impuestos del transporte</label>
                                <select id="codimpuestoportes" class="form-control" v-model="dataForm.impid">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <?php foreach ($impuestos as $impuesto) : ?>
                                        <option value="<?= $impuesto['imp_id']; ?>"><?= $impuesto['imp_descripcion']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="subcuenta">Subcuenta</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fas fa-balance-scale fa-fw"></i></span>
                                    </div>
                                    <input type="text" name="subcuenta" class="form-control" maxlength="15" v-model="dataForm.subcuenta">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="regimeniva">Régimen IVA</label>
                                <select id="regimeniva" class="form-control" v-model="dataForm.regimeniva">
                                    <option value="1">Exento</option>
                                    <option value="2" selected="">General</option>
                                    <option value="3">Recargo de equivalencia</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="retencion">Retención</label>
                                <select id="retencion" class="form-control" v-model="dataForm.retencion">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <?php foreach ($retencion as $row) : ?>
                                        <option value="<?= $row['imp_id'] ?>"><?= $row['imp_descripcion'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    */ ?>
                    <div class="form-group">
                        <label for="observaciones">Observaciones</label>
                        <textarea class="form-control" v-model="dataForm.observaciones"></textarea>
                    </div>
                    <div class="form-row">
                        <div class="col-sm-3">
                            <div class="form-check">
                                <label class="form-check-label">
                                    <input class="form-check-input" type="checkbox" value="TRUE" v-model="dataForm.personafisica" id="personafisica">
                                    <span class="form-check-sign">Persona natural (no jurídica)</span>
                                </label>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-check">
                                <label class="form-check-label">
                                    <input class="form-check-input" type="checkbox" value="TRUE" v-model="dataForm.acreedor" id="acreedor">
                                    <span class="form-check-sign">Es acreedor</span>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col text-right">
                            <button class="btn btn-sm btn-secondary" type="reset">
                                <i class="fas fa-undo fa-fw" aria-hidden="true"></i>
                                <span class="d-none d-sm-inline-block">Deshacer</span>
                            </button>
                            <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                                <i class="loader loader-info"></i>
                            </button>
                            <button v-else class="btn btn-sm btn-primary" type="submit">
                                <i class="fas fa-save fa-fw" aria-hidden="true"></i>
                                <span class="d-none d-sm-inline-block">Guardar</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<script src="<?= ruta_base() ?>public/assets/vue-the-mask.js"></script>
<script src="<?= ruta_base() ?>public/assetsvuejs/proveedores/crearproveedores.js"></script>
