<?php

namespace App\Controladores;

use App\Modelos\Cliente;
use App\Modelos\Compras;
use App\Modelos\Impuesto;
use App\Modelos\MetodoPago;
use App\Modelos\Pais;
use App\Modelos\Proveedor;
use App\Modelos\Series;
use App\Modelos\Tipodocumentos;
use Core\Controller;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Helpers\Moneda;
use Core\Vista;
use Exception;

final class ProveedoresControlador extends Controller
{
    private $proveedores;
    private $array_errors = [];
    private $div_master;

    public function __construct()
    {
        parent::__construct();
        $this->module = new Module('proveedores');
        $this->proveedores = new Proveedor();
        $this->div_master               = $this->proveedores->obtenerDivisaMaster();
    }

    public function index()
    {
        return Vista::view('proveedores/index');
    }

    public function proveedores()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $list_proveedores = [];

            $proveedores = $this->proveedores->proveedores();

            if (is_countable($proveedores) && count($proveedores)) {
                foreach ($proveedores as $row) {
                    $list_proveedores[] = [
                        'id' => $row['prov_id'],
                        'codigo' => $row['prov_codigo'],
                        'identificacion' => $row['prov_cifnif'],
                        'proveedor' => $row['prov_nombre'],
                        'telefono' => $row['prov_telefono1'],
                        'correo' => $row['prov_email'],
                        'estatus' =>  $row['prov_estatus'] ? true : false
                    ];
                }
            }

            Http::json_response($list_proveedores);
        }
    }

    public function proveedoresActivos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            Http::json_response($this->proveedores->proveedoresActivos());
        }
    }

    public function lista_proveedores()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $lista = [];
            $proveedores = $this->proveedores->obtenerListaProveedores();

            if (is_countable($proveedores) && count($proveedores)) {
                foreach ($proveedores as $row) {
                    $lista[] = [
                        "pprov_id"           => $row['pprov_id'],
                        "pprov_fecha" => $row['pprov_fecha'],
                        "pprov_producto" => $row['pprov_producto'],
                        "prov_razonsocial" => $row['prov_razonsocial'],
                        "pprov_precio" => $row['pprov_precio'],
                        "prov_estado" => $row['prov_estado'],
                        "prov_ciudad" => $row['prov_ciudad'],
                        'checked'           => false
                    ];
                }
            }

            Http::json_response($lista);
        }
    }

    public function eliminarProveedores($id)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);
            $consulta = $this->proveedores->consultar("SELECT * FROM app_proveedor_lista_productos WHERE pprov_id=$id")->row();
            if ($consulta) {
                if ($this->proveedores->eliminarProv($id)) {
                    Http::json_response([
                        'eliminado' => true,
                        'producto' => $consulta["pprov_producto"]
                    ]);
                } else {
                    Http::json_response([
                        'eliminado' => false,
                        'producto' => $consulta["pprov_producto"]
                    ]);
                }
            } else {
                Http::json_response([
                    'eliminado' => false,
                    'producto' => $consulta["pprov_producto"]
                ]);
            }
        }
    }

    public function guardarCsv()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $this->array_errors = [];

            $prov_id            = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);

            if (!isset($_FILES["file"])) {
                $this->array_errors[] = "Selecciona un archivo CSV válido.";
            }

            $file     = $_FILES["file"];
            $tmp      = $file["tmp_name"];
            $filename = $file["name"];
            $size     = $file["size"];

            if ($size < 0) {
                $this->array_errors[] = "Selecciona un archivo válido por favor.";
            }

            $fp = fopen($_FILES['file']['tmp_name'], "r");
            $linea = [];
            $productos = [];

            while (($data = fgetcsv($fp)) !== FALSE) {
                $linea[] = $data;
            }

            unset($linea[0]);
            $total = count($linea);

            if ($total <= 0) {
                $this->array_errors[] = "El archivo proporcionado está vacio.";
            }

            if (empty($this->array_errors)) {

                $dat = [];

                try {
                    $eliminar = $this->proveedores->consultar("DELETE FROM app_proveedor_lista_productos WHERE pprov_proveedor = $prov_id")->run();

                    if (count($linea) > 0 && $eliminar) {

                        foreach ($linea as $row) {
                            if ($row[0] != null && $row[1] != null) {
                                $guardado = $this->proveedores->guardar([
                                    'pprov_proveedor' => $prov_id,
                                    'pprov_producto' =>  $row[0],
                                    'pprov_precio' =>  $row[1],
                                ], false, "app_proveedor_lista_productos");

                                if ($guardado) {
                                    continue;
                                }
                            }
                        }
                    } else {
                        $this->array_errors[] = "Error archivo vacio";
                    }
                } catch (Exception $e) {
                    $this->array_errors[] = "Error del servidor" . $e;
                }

                if (empty($this->array_errors)) {
                    Http::json_response(true);
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function guardarProducto()
    {

        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $prov_id            =  $this->solicitud->sanitize($_POST['id'], FILTER_SANITIZE_NUMBER_INT);
            // $codigo            =  $this->solicitud->sanitize($_POST['codigo'], FILTER_SANITIZE_STRING);
            $precio            =  $this->solicitud->sanitize($_POST['precio'], FILTER_SANITIZE_STRING);
            $producto = $this->solicitud->sanitize($_POST['producto'], FILTER_SANITIZE_STRING);

            if (empty($producto))
                $this->array_errors[] = "Debe agregar el nombre del producto.";

            //if (empty($codigo))
            //$this->array_errors[] = "Debe agregar el codigo del producto.";

            if (empty($precio))
                $this->array_errors[] = "Debe agregar el precio del producto.";

            if (empty($this->array_errors)) {

                $existe_producto = $this->proveedores->obtenerProveedor($producto);

                //  Http::json_response($this->proveedores->obtenerProveedor($codigo, $producto));

                if ($existe_producto) {
                    if ($existe_producto["pprov_proveedor"] == $prov_id) {
                        Http::json_response($this->proveedores->consultar("UPDATE app_proveedor_lista_productos SET pprov_precio = {$precio} WHERE pprov_proveedor = $prov_id AND pprov_producto='$producto'")->run());
                    } else {
                        Http::json_response($this->proveedores->guardar([
                            'pprov_proveedor' => $prov_id,
                            'pprov_producto' => $producto,
                            'pprov_precio' => round($precio, 2),
                        ], true, "app_proveedor_lista_productos"));
                    }
                } else {
                    Http::json_response($this->proveedores->guardar([
                        'pprov_proveedor' => $prov_id,
                        'pprov_producto' => $producto,
                        'pprov_precio' => round($precio, 2),
                    ], true, "app_proveedor_lista_productos"));
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarProveedor($id)
    {
        $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

        if ($this->proveedores->consultar("SELECT * FROM app_proveedor_lista_productos WHERE pprov_id=$id")->row()) {
            Http::json_response($this->proveedores->eliminarProv($id));
        } else {
            Http::json_response(false);
        }
    }

    public function eliminarPorProveedor($id)
    {

        $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

        if ($this->proveedores->consultar("SELECT * FROM app_proveedor_lista_productos WHERE pprov_proveedor=$id")->row()) {
            Http::json_response($this->proveedores->eliminarProveedor($id));
        } else {
            Http::json_response(false);
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $prov_id            = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $prov_codigo        = filter_input(INPUT_POST, 'codigo', FILTER_SANITIZE_STRING);
            $prov_nombre        = filter_input(INPUT_POST, 'nombre', FILTER_SANITIZE_STRING);
            $prov_razonsocial   = filter_input(INPUT_POST, 'razonsocial', FILTER_SANITIZE_STRING);
            $prov_tipoidfiscal  = filter_input(INPUT_POST, 'tipoidfiscal', FILTER_SANITIZE_STRING);
            $prov_cifnif        = filter_input(INPUT_POST, 'cifnif', FILTER_SANITIZE_STRING);
            $prov_personafisica = ('true' == filter_input(INPUT_POST, 'personafisica')) ? 1 : 0;
            $prov_acreedor      = ('true' == filter_input(INPUT_POST, 'acreedor')) ? 1 : 0;
            $prov_idcontact     = filter_input(INPUT_POST, 'idcontacto', FILTER_SANITIZE_STRING);
            $prov_telefono1     = filter_input(INPUT_POST, 'telefono1', FILTER_SANITIZE_STRING);
            $prov_telefono2     = filter_input(INPUT_POST, 'telefono2', FILTER_SANITIZE_STRING);
            $prov_email         = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);
            $prov_web           = filter_input(INPUT_POST, 'web', FILTER_SANITIZE_URL);
            $prov_serie         = filter_input(INPUT_POST, 'serie', FILTER_SANITIZE_NUMBER_INT);
            $prov_mpid          = filter_input(INPUT_POST, 'mpid', FILTER_SANITIZE_NUMBER_INT);
            $prov_impid         = filter_input(INPUT_POST, 'impid', FILTER_SANITIZE_NUMBER_INT);
            $prov_subcuenta     = filter_input(INPUT_POST, 'subcuenta', FILTER_SANITIZE_STRING);
            $prov_regimeniva    = filter_input(INPUT_POST, 'regimeniva', FILTER_SANITIZE_STRING);
            $prov_retencion     = filter_input(INPUT_POST, 'retencion', FILTER_SANITIZE_NUMBER_INT);
            $prov_observaciones = filter_input(INPUT_POST, 'observaciones', FILTER_SANITIZE_STRING);
            $prov_paisid        = filter_input(INPUT_POST, 'pais', FILTER_SANITIZE_NUMBER_INT);
            $prov_estado        = filter_input(INPUT_POST, 'estado', FILTER_SANITIZE_STRING);
            $prov_ciudad        = filter_input(INPUT_POST, 'ciudad', FILTER_SANITIZE_STRING);
            $prov_codigo_postal = filter_input(INPUT_POST, 'codigo_postal', FILTER_SANITIZE_STRING);
            $prov_direccion     = filter_input(INPUT_POST, 'direccion', FILTER_SANITIZE_STRING);

            if (empty($prov_codigo))
                $this->array_errors[] = "El campo Código es obligatorio.";
            if (empty($prov_nombre))
                $this->array_errors[] = "El campo Nombre es obligatorio.";
            if (empty($prov_razonsocial))
                $this->array_errors[] = "El campo Razon social es obligatorio.";
            if (empty($prov_tipoidfiscal))
                $this->array_errors[] = "El campo tipo id fiscal es obligatorio.";
            if (empty($prov_cifnif))
                $this->array_errors[] = "El campo Numero de documento es obligatorio.";
            if (empty($prov_telefono1))
                $this->array_errors[] = "El campo Teléfono es obligatorio.";
            if (empty($prov_email))
                $this->array_errors[] = "El campo Correo electrónico es obligatorio.";
            if (empty($prov_paisid))
                $this->array_errors[] = "El campo País es obligatorio.";

            if (empty($this->array_errors)) {

                if (empty($prov_id)) {
                    if ($this->proveedores->existe('prov_codigo', $prov_codigo))
                        $this->array_errors[] = "Ya existe el proveedor con el mismo codigo.";
                    if ($this->proveedores->existe('prov_nombre', $prov_nombre))
                        $this->array_errors[] = "Ya existe el proveedor con el mismo nombre.";
                    if ($this->proveedores->existe('prov_cifnif', $prov_cifnif))
                        $this->array_errors[] = "Ya existe el proveedor con el mismo numeo de docuemento.";
                } else {
                    if ($this->proveedores->condicinoal("SELECT * FROM app_proveedores WHERE prov_codigo='$prov_codigo' and prov_id!=$prov_id"))
                        $this->array_errors[] = "Ya existe el proveedor con el mismo codigo.";
                    if ($this->proveedores->condicinoal("SELECT * FROM app_proveedores WHERE prov_nombre='$prov_nombre' and prov_id!=$prov_id"))
                        $this->array_errors[] = "Ya existe el proveedor con el mismo nombre.";
                    if ($this->proveedores->condicinoal("SELECT * FROM app_proveedores WHERE prov_cifnif='$prov_cifnif' and prov_id!=$prov_id"))
                        $this->array_errors[] = "Ya existe el proveedor con el mismo numeo de docuemento.";
                }

                //if (valida_email($prov_email) == false)
                //array_push($this->array_errors, "La correo $prov_email no es correcto");

                if (empty($this->array_errors)) {

                    $data_form = [
                        'prov_codigo'           => $prov_codigo,
                        'prov_nombre'           => $prov_nombre,
                        'prov_razonsocial'      => $prov_razonsocial,
                        'prov_tipoidfiscal'     => $prov_tipoidfiscal,
                        'prov_cifnif'           => $prov_cifnif,
                        'prov_personafisica'    => $prov_personafisica,
                        'prov_acreedor'         => $prov_acreedor,
                        'prov_telefono1'        => $prov_telefono1,
                        'prov_telefono2'        => $prov_telefono2,
                        'prov_email'            => $prov_email,
                        'prov_web'              => $prov_web,
                        'prov_serie'            => $prov_serie,
                        'prov_mpid'             => $prov_mpid,
                        'prov_impid'            => $prov_impid,
                        'prov_subcuenta'        => $prov_subcuenta,
                        'prov_regimeniva'       => $prov_regimeniva,
                        'prov_retencion'        => $prov_retencion,
                        'prov_observaciones'    => $prov_observaciones,
                        'prov_paisid'           => $prov_paisid,
                        'prov_estado'           => $prov_estado,
                        'prov_ciudad'           => $prov_ciudad,
                        'prov_codigo_postal'    => $prov_codigo_postal,
                        'prov_direccion'        => $prov_direccion
                    ];

                    if (empty($prov_id)) {
                        Http::json_response($this->proveedores->guardar($data_form, true));
                    } else {
                        Http::json_response($this->proveedores->editar($prov_id, $data_form));
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function crear()
    {
        $new_pais = new Pais();
        $newImp = new Impuesto();
        $newTipoDoc = new Tipodocumentos();
        $newSerie = new Series();
        $newMP = new MetodoPago();

        return Vista::view('proveedores/crear', [
            'pais'                  => $new_pais->todos(),
            'series'                => $newSerie->todos(),
            'tipo_de_documentos'    => $newTipoDoc->todos(),
            'retencion'             => $newImp->where(['imp_retencion' => 1]),
            'impuestos'             => $newImp->where(['imp_retencion' => 0]),
            'metodos_pago'          => $newMP->where(['mp_estatus' => 1]),
        ]);
    }

    public function lista()
    {

        return Vista::view('proveedores/lista', []);
    }

    public function editar(int $prov_id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && !empty($prov_id)) {
            if (!$this->proveedores->existe('prov_id', $prov_id)) {
                Http::notFound();
            }
            $new_pais = new Pais();
            $newImp = new Impuesto();
            $newSerie =  new Series();
            $newTipoDoc =  new Tipodocumentos();
            $newMP = new MetodoPago();
            return Vista::view('proveedores/editar', [
                'proveedor'             => $prov_id,
                'pais'                  => $new_pais->todos(),
                'series'                => $newSerie->todos(),
                'tipo_de_documentos'    => $newTipoDoc->todos(),
                'retencion'             => $newImp->where(['imp_retencion' => 1]),
                'impuestos'             => $newImp->where(['imp_retencion' => 0]),
                'metodos_pago'          => $newMP->where(['mp_estatus' => 1]),
            ]);
        }
    }

    public function modificarEstatus($id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($this->proveedores->existe('prov_id', $id)) {
                $estatus = $this->proveedores->obtener($id);
                if ($estatus['prov_estatus']) {
                    Http::json_response($this->proveedores->modificarEstatus($id, 0));
                } else {
                    Http::json_response($this->proveedores->modificarEstatus($id, 1));
                }
            }

            Http::json_response(false);
        }
    }

    public function eliminar($id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($this->proveedores->existe('prov_id', $id)) {
                if ($this->proveedores->proveedorForaneo($id)) {
                    $this->array_errors[] = "El proveedor no puede ser eliminado ya que se encuentra relacionado con algun producto";
                } else {
                    Http::json_response($this->proveedores->eliminar($id));
                }
            } else {
                Http::json_response(false);
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function proveedor(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $list_proveedor = [];

            $proveedor = $this->proveedores->obtener($id);

            if (is_countable($proveedor) && count($proveedor)) {

                $list_proveedor = [
                    'id' => $proveedor['prov_id'],
                    'codigo' => $proveedor['prov_codigo'],
                    'identificacion' => $proveedor['prov_cifnif'],
                    'proveedor' => $proveedor['prov_nombre'],
                    'razon_social' => $proveedor['prov_razonsocial'],
                    'tipo_id_fiscal' => $proveedor['prov_tipoidfiscal'],
                    'persona_fisica' => $proveedor['prov_personafisica'] ? true : false,
                    'acreedor' => $proveedor['prov_acreedor'] ? true : false,
                    'telefono1' => $proveedor['prov_telefono1'],
                    'telefono2' => $proveedor['prov_telefono2'],
                    'contacto' => $proveedor['prov_idcontacto'],
                    'correo' => $proveedor['prov_email'],
                    'web' => $proveedor['prov_web'],
                    'serie' => $proveedor['prov_serie'],
                    'mpid' => $proveedor['prov_mpid'],
                    'impid' => $proveedor['prov_impid'],
                    'subcuenta' => $proveedor['prov_subcuenta'],
                    'regimen_iva' => $proveedor['prov_regimeniva'],
                    'retencion' => $proveedor['prov_retencion'],
                    'observaciones' => $proveedor['prov_observaciones'],
                    'pais' => $proveedor['prov_paisid'],
                    'estado' => $proveedor['prov_estado'],
                    'ciudad' => $proveedor['prov_ciudad'],
                    'codigo_postal' => $proveedor['prov_codigo_postal'],
                    'direccion' => $proveedor['prov_direccion'],
                    'estatus' =>  $proveedor['prov_estatus'] ? true : false
                ];
            }

            Http::json_response($list_proveedor);
        }
    }

    public function obtenerFacturas()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax() && (!empty($_GET['proveedor']) && !empty($_GET['anio']))) {
            $id_proveedor = $this->solicitud->sanitize($_GET['proveedor'], FILTER_SANITIZE_NUMBER_INT);
            $anio = $this->solicitud->sanitize($_GET['anio'], FILTER_SANITIZE_NUMBER_INT);
            $array_anuladas     = [];
            $array_pendientes   = [];
            $array_pagas        = [];
            if ($this->proveedores->existe('prov_id', $id_proveedor)) {

                $f_pagas = $this->proveedores->obtenerFacturasAnuales($id_proveedor, $anio);

                if (is_countable($f_pagas) && count($f_pagas)) {
                    foreach ($f_pagas as $row) {
                        $array_pagas[] = [
                            'id'            => $row['cmp_id'],
                            'cliente'       => $row['prov_razonsocial'],
                            'correlativo'   => $row['cmp_correlativo'],
                            'div_locale'    => $row['div_locale'],
                            'div_simbolo'   => $row['div_simbolo'],
                            'total'         => $row['cmp_total'],
                            'fecha'         => $row['cmp_fecha']
                        ];
                    }
                }

                $f_pendientes = $this->proveedores->obtenerFacturasAnualesPendientes($id_proveedor, $anio);

                if (is_countable($f_pendientes) && count($f_pendientes)) {
                    foreach ($f_pendientes as $row) {
                        $acumulado = $this->proveedores->obtenerAcumulado($row['cmp_id'], 8);
                        $acumulado_total = ($acumulado['total']) ?? 0;
                        $array_pendientes[] = [
                            'id'            => $row['cmp_id'],
                            'cliente'       => $row['prov_razonsocial'],
                            'correlativo'   => $row['cmp_correlativo'],
                            'div_locale'    => $row['div_locale'],
                            'div_simbolo'   => $row['div_simbolo'],
                            'total'         => $row['cmp_total'],
                            'fecha'         => $row['cmp_fecha'],
                            'acumulado'     => $acumulado_total * -1,
                            'pendiente'     => $row['cmp_total'] + $acumulado_total
                        ];
                    }
                }

                $f_anuladas = $this->proveedores->obtenerFacturasAnualesAnuladas($id_proveedor, $anio);

                if (is_countable($f_anuladas) && count($f_anuladas)) {
                    foreach ($f_anuladas as $row) {
                        $acumulado = $this->proveedores->obtenerAcumulado($row['cmp_id'], 8);
                        $acumulado_total = ($acumulado['total']) ?? 0;
                        $array_anuladas[] = [
                            'id'            => $row['cmp_id'],
                            'cliente'       => $row['prov_razonsocial'],
                            'correlativo'   => $row['cmp_correlativo'],
                            'div_locale'    => $row['div_locale'],
                            'div_simbolo'   => $row['div_simbolo'],
                            'total'         => $row['cmp_total'],
                            'fecha'         => $row['cmp_fecha'],
                            'acumulado'     => $acumulado_total * -1,
                            'pendiente'     => $row['cmp_total'] + $acumulado_total
                        ];
                    }
                }
            }
            Http::json_response([
                'pagas'         => $array_pagas,
                'pendientes'    => $array_pendientes,
                'anuladas'      => $array_anuladas
            ]);
        }
    }

    public function obtenerNotasdeEntrega()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax() && (!empty($_GET['proveedor']) && !empty($_GET['anio']))) {
            $id_proveedor = $this->solicitud->sanitize($_GET['proveedor'], FILTER_SANITIZE_NUMBER_INT);
            $anio = $this->solicitud->sanitize($_GET['anio'], FILTER_SANITIZE_NUMBER_INT);
            $array_pendientes   = [];
            $array_anuladas     = [];
            $array_anuales      = [];
            if ($this->proveedores->existe('prov_id', $id_proveedor)) {

                $n_pendientes = $this->proveedores->obtenerNotasdeEntregaAnualesPendientes($id_proveedor, $anio);

                if (is_countable($n_pendientes) && count($n_pendientes)) {
                    foreach ($n_pendientes as $row) {
                        $acumulado = $this->proveedores->obtenerAcumulado($row['cmpn_id'], 9);
                        $acumulado_total = ($acumulado['total']) ?? 0;
                        $array_pendientes[] = [
                            'id'            => $row['cmpn_id'],
                            'cliente'       => $row['prov_razonsocial'],
                            'correlativo'   => $row['cmpn_correlativo'],
                            'div_locale'    => $row['div_locale'],
                            'div_simbolo'   => $row['div_simbolo'],
                            'total'         => $row['cmpn_total'],
                            'fecha'         => $row['cmpn_fecha'],
                            'acumulado'     => $acumulado_total * -1,
                            'pendiente'     => $row['cmpn_total'] + $acumulado_total
                        ];
                    }
                }

                $n_anuladas = $this->proveedores->obtenerNotasdeEntregaAnualesAnuladas($id_proveedor, $anio);

                if (is_countable($n_anuladas) && count($n_anuladas)) {
                    foreach ($n_anuladas as $row) {
                        $acumulado = $this->proveedores->obtenerAcumulado($row['cmpn_id'], 9);
                        $acumulado_total = ($acumulado['total']) ?? 0;
                        $array_anuladas[] = [
                            'id'            => $row['cmpn_id'],
                            'cliente'       => $row['prov_razonsocial'],
                            'correlativo'   => $row['cmpn_correlativo'],
                            'div_locale'    => $row['div_locale'],
                            'div_simbolo'   => $row['div_simbolo'],
                            'total'         => $row['cmpn_total'],
                            'fecha'         => $row['cmpn_fecha'],
                            'acumulado'     => $acumulado_total * -1,
                            'pendiente'     => $row['cmpn_total'] + $acumulado_total
                        ];
                    }
                }

                $n_anuales = $this->proveedores->obtenerNotasdeEntregaAnuales($id_proveedor, $anio);

                if (is_countable($n_anuales) && count($n_anuales)) {
                    foreach ($n_anuales as $row) {
                        $array_anuales[] = [
                            'id'            => $row['cmpn_id'],
                            'cliente'       => $row['prov_razonsocial'],
                            'correlativo'   => $row['cmpn_correlativo'],
                            'div_locale'    => $row['div_locale'],
                            'div_simbolo'   => $row['div_simbolo'],
                            'total'         => $row['cmpn_total'],
                            'fecha'         => $row['cmpn_fecha']
                        ];
                    }
                }
            }
            Http::json_response([
                'pagas'         => $array_anuales,
                'pendientes'    => $array_pendientes,
                'anuladas'      => $array_anuladas,
            ]);
        }
    }

    public function cliente($id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id     = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            $proveedor = $this->proveedores->obtener($id);

            $new_cliente = new Cliente();

            if ($proveedor) {

                if (
                    $this->proveedores->chuequearCliente("cli_dni = '{$proveedor['prov_cifnif']}'") ||
                    $this->proveedores->chuequearCliente("cli_razon_social = '{$proveedor['prov_razonsocial']}'")
                ) {
                    $this->array_errors[] = 'El proveedor ya se encuentra como cliente.';
                }

                if (empty($this->array_errors)) {
                    Http::json_response($new_cliente->guardar([
                        'cli_razon_social'  => $proveedor['prov_razonsocial'],
                        'cli_tipodocid'     => $proveedor['prov_tipoidfiscal'],
                        'cli_dni'           => $proveedor['prov_cifnif'],
                        'cli_telefono'      => $proveedor['prov_telefono1'],
                        'cli_telefono_2'    => $proveedor['prov_telefono2'],
                        'cli_email'         => $proveedor['prov_email'],
                        'cli_direccion'     => $proveedor['prov_direccion'],
                        'cli_paisid'       => $proveedor['prov_paisid'],
                        'cli_natural'       => 0,
                        'cli_contribuyente' => 1,
                        'cli_estado'        => $proveedor['prov_estado'],
                        'cli_ciudad'        => $proveedor['prov_ciudad'],
                        'cli_codpostal'     => $proveedor['prov_codigo_postal'],
                        'cli_observaciones' => $proveedor['prov_observaciones']
                    ], true));
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function reporteGeneralMensual()
    {

        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $anio   = filter_input(INPUT_POST, 'anio', FILTER_SANITIZE_NUMBER_INT);
            $prov   = filter_input(INPUT_POST, 'prov', FILTER_SANITIZE_NUMBER_INT);

            $array_notas        = [];
            $array_notas_id     = [];
            $array_documentos_id     = [];
            $artic_total        = 0;
            $costo              = 0;
            $venta              = 0;

            $newcompra = new Compras();
            $facturas = $newcompra->obtenerFacturasAnualesMes("YEAR(cmp.cmp_fecha)=$anio AND cmp.cmp_cliid=$prov");
            $notas = $newcompra->obtenerNotasdeEntregaAnualesMes("YEAR(cmp.cmpn_fecha)=$anio AND cmp.cmpn_cliid=$prov");


            if (is_countable($notas) && count($notas)) {

                foreach ($notas as $row) {

                    if ($row['divisa'] != $this->div_master['div_id']) {
                        $factor = $this->compras->divisaFactor($row['divisa'], $this->div_master['div_id']);
                        $row['total'] = round(($row['total'] * $factor['df_factor']), 2);
                    }

                    if (!in_array($row['mes'], $array_notas_id)) {

                        $array_notas[$row['mes']] = [
                            'mes'  => $row['mes'],
                            'venta'         =>  round($row['total'], 2),
                            'documentos'    => 1
                        ];
                        $array_notas_id[] = $row['mes'];
                    } else {
                        $array_notas[$row['mes']]['venta']      +=  round($row['total'], 2);
                        $array_notas[$row['mes']]['documentos']      += 1;
                    }

                    $artic_total    += 1;
                    $venta          += round($row['total'], 2);
                }
            }

            if (is_countable($facturas) && count($facturas)) {

                foreach ($facturas as $row) {

                    if ($row['divisa'] != $this->div_master['div_id']) {
                        $factor = $this->compras->divisaFactor($row['divisa'], $this->div_master['div_id']);
                        $row['total'] = round(($row['total'] * $factor['df_factor']), 2);
                    }

                    if (!in_array($row['mes'], $array_notas_id)) {
                        $array_notas[$row['mes']] = [
                            'mes'  => $row['mes'],
                            'venta'         =>  round($row['total'], 2),
                            'documentos'    => 1
                        ];
                        $array_notas_id[] = $row['mes'];
                    } else {
                        $array_notas[$row['mes']]['venta']      += round($row['total'], 2);
                        $array_notas[$row['mes']]['documentos']      += 1;
                    }

                    $artic_total    += 1;
                    $venta          +=  round($row['total'], 2);
                }
            }

            Http::json_response([
                'meses'   => $array_notas,
                'total' => $venta,
                'div_locale'    => $this->div_master['div_locale'],
                'div_simbolo'  => $this->div_master['div_simbolo'],
            ]);
        }
    }

    public function abonosProveedores($id)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);
            $facturas = $this->proveedores->obtenerMovimientoFactura($id);
            $notas = $this->proveedores->obtenerMovimientoNota($id);

            $proveedor = [];
            $newcompra = new Compras();

            if (is_countable($notas) && count($notas)) {
                foreach ($notas as $row) {

                    $divisa = $newcompra->obtenerDivisa($row['fab_divisa']);
                    $acumulado = $newcompra->obtenerAcumulado($row['cmpn_id'], 9);
                    $acumulado_total = ($acumulado['total']) ?? 0;
                    $divisaf = $newcompra->obtenerDivisa($row['cmpn_divid']);

                    $proveedor[] = [
                        "prov_id" => $row['prov_id'],
                        'ruta_documento'    => ruta_base() . 'cmpnotaseditar/verFactura/' . $row['cmpn_id'],
                        'correlativo'       => 'NEC' . $row['cmpn_correlativo'],
                        "prov_razonsocial" => $row['prov_razonsocial'],
                        'monto'             => Moneda::moneda($row['fab_monto'] * -1, $divisa['div_locale'], $divisa['div_simbolo']),
                        'fecha'             => $row['fab_fecha'],
                        "prov_direccion" => $row['prov_direccion'],
                        "divisa" =>  $divisa['div_descripcion'],
                        'total'         =>  Moneda::moneda($row['cmpn_total'], $divisaf['div_locale'], $divisaf['div_simbolo']),
                        'acumulado'     =>  Moneda::moneda($acumulado_total * -1,$divisaf['div_locale'], $divisaf['div_simbolo']),
                        'pendiente'     =>  Moneda::moneda($row['cmpn_total'] + $acumulado_total,$divisaf['div_locale'], $divisaf['div_simbolo']),
                    ];
                }
            }

            if (is_countable($facturas) && count($facturas)) {
                foreach ($facturas as $row) {

                    $divisa = $newcompra->obtenerDivisa($row['fab_divisa']);
                    $acumulado = $newcompra->obtenerAcumulado($row['cmp_id'], 8);
                    $acumulado_total = ($acumulado['total']) ?? 0;
                    $divisaf = $newcompra->obtenerDivisa($row['cmp_divid']);

                    $proveedor[] = [
                        "prov_id" => $row['prov_id'],
                        'ruta_documento'    => ruta_base() . 'cmpfacturaeditar/verFactura/' . $row['cmp_id'],
                        'correlativo'       => 'FACC' . $row['cmp_correlativo'],
                        "prov_razonsocial" => $row['prov_razonsocial'],
                        'monto'             => Moneda::moneda($row['fab_monto'] * -1, $divisa['div_locale'], $divisa['div_simbolo']),
                        'fecha'             => $row['fab_fecha'],
                        "prov_direccion" => $row['prov_direccion'],
                        "divisa" =>  $divisa['div_descripcion'],
                        'total'         =>  Moneda::moneda($row['cmp_total'], $divisaf['div_locale'], $divisaf['div_simbolo']),
                        'acumulado'     =>  Moneda::moneda($acumulado_total * -1,$divisaf['div_locale'], $divisaf['div_simbolo']),
                        'pendiente'     =>  Moneda::moneda($row['cmp_total'] + $acumulado_total,$divisaf['div_locale'], $divisaf['div_simbolo']),
                    ];
                }
            }

            Http::json_response($proveedor);
        }
    }
}
