<div class="card">
    <div class="card-body" :class="cargando">
        <div class="row">
            <div class="col-12">
                <form @submit.prevent="obtenerProductosPrecio()">
                    <div class="form-row">
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label>Filtrar por categoria</label>
                                <select id="categoria" v-model="categoriafiltro" class="form-control custom-select">
                                    <option value="0">Todos</option>
                                    <option v-for="row in optionsCategorias" :value="row.id">{{row.label}}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <br>
                            <div class="form-group">
                                <div class="input-group-append">
                                    <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body">
        <div class="tab-content">
            <div class="tab-pane fade show active" role="tabpanel">
                <div class="table-responsive">
                    <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="prec_table">
                        <thead>
                            <tr class="text-center">
                                <th>Referencia</th>
                                <th>Descripción</th>
                                <th>Precio $</th>
                                <th>Precio BSS</th>
                                <th>Precio BSD</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in productosprec">
                                <td class="text-left" width="10%"><a :href="'<?= ruta_base() ?>productos/editar/'+row.pro_id">{{ row.pro_codigo }}</a></td>
                                <td class="text-left">{{ row.pro_descripcion }}</td>
                                <td class="text-right" v-html="row.pro_precio"></td>
                                <td class="text-right" v-html="row.pro_precbss"></td>
                                <td class="text-right" v-html="row.pro_precbsd"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>