<div class="card">
    <div class="card-body" :class="cargando">
        <div class="row">
            <div class="col-12">
                <form @submit.prevent="buscarprecLote($event)">
                    <div class="form-row">
                        <div class="col-sm-4">
                            <div class="form-group">
                                <label>Filtrar por categoria</label>
                                <select id="categoria" v-model="categoria_filtro" class="form-control custom-select">
                                    <option value="0">Todos</option>
                                    <option v-for="row in optionsCategorias" :value="row.id">{{row.label}}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-2">
                            <br>
                            <div class="form-group">
                                <div class="input-group-append">
                                    <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<div class="card">
    <div class="card-body" :class="cargando">
        <div class="table-responsive">
            <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tab_precLote">
                <thead>
                    <tr>
                        <th class="text-center">
                            <label for="checkbox-todos" class="form-check-label">
                                <input class="form-check-input" type="checkbox" class="checkbox-todos" @change="checktodos($event)">
                                <span class="form-check-sign"></span>
                            </label>
                        </th>
                        <th style="width: 15%;" class="text-left">Referencia</th>
                        <th class="text-center">Descripción</th>
                        <th class="text-left">Categoria</th>
                        <th class="text-center">Precio Costo</th>
                        <th class="text-center"> Precio Venta</th>
                    </tr>
                </thead>
                <tbody>
                    <tr v-for="row in productoscategoria" :key="row.id">
                        <td class="text-center">
                            <label :for="'check'+row.id" class="form-check-label">
                                <input class="form-check-input" type="checkbox" v-model="row.checked" :id="'part'+row.id">
                                <span class="form-check-sign"></span>
                            </label>
                        </td>
                        <td class="text-center">{{row.codigo}}</td>
                        <td class="text-left">{{row.descripcion}}</td>
                        <td class="text-center">{{row.categoria}}</td>
                        <td class="text-center" v-html="row.costo"></td>
                        <td class="text-center" v-html="row.precio"></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<div class="col d-flex justify-content-end">
    <a href="#" class="btn btn-info btn-sm btn-round mr-3" @click.prevent="modal_actualizarprecio()">Actualizar precio</a>
</div>