<div class="card p-0 m-0">
    <div class="card-header">
        <div class="card-head-row">
            <div class="card-title">Total en stock {{ stock_fisico_total }}</div>
            <div class="card-tools">
                <a href="#" class="btn btn-info btn-border btn-round btn-sm" data-toggle="collapse" data-target="#formEditStockNewCollapse" aria-expanded="false" aria-controls="collapseExample"><span class="btn-label"><i class="fa fa-save"></i></span>
                    Agregar
                </a>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="collapse" id="formEditStockNewCollapse">
            <form autocomplete="off" @submit.prevent="guardarStock" id="form_stock_guardar">
                <div class="form-row ">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="stock_almacen"> <a href="<?= url('almacenes') ?>"> Almacén</a> </label>
                            <select id="stock_almacen" class="form-control" name="almacen">
                                <option value="" disabled>Seleccione un alamcen</option>
                                <option v-for="row in almacenSinProductoEnStock" :value="row.alm_id">
                                    {{ row.alm_nombre }}
                                </option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="stock_cantidad">Cantidad</label>
                            <input type="number" id="stock_cantidad" class="form-control" step="any" name="cantidad">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="srock_min">Stock mín.</label>
                            <input type="number" id="srock_min" value="0" class="form-control" step="any" name="min">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="stock_max">Stock máx.</label>
                            <input type="number" id="stock_max" value="0" class="form-control" step="any" name="max">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class=" alert alert-warning" role="alert" v-for="row in errorFormStock">
                            {{ row }}
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col text-right">
                        <button class="btn btn-sm btn-secondary" type="reset" @click="obtenerStock">
                            <i class="fas fa-undo fa-fw" aria-hidden="true"></i>
                            <span class="d-none d-sm-inline-block">Reiniciar</span>
                        </button>
                        <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                            <i class="loader loader-info"></i>
                        </button>
                        <button v-else class="btn btn-sm btn-primary" type="submit">
                            <i class="fas fa-save fa-fw" aria-hidden="true"></i>
                            <span class="d-none d-sm-inline-block">Guardar</span>
                        </button>
                    </div>
                </div>
            </form>
        </div>
        <div class="table-responsive">
            <table class="table table-hover table-bordered" id="clientes-table">
                <thead>
                    <tr>
                        <th>Almacen</th>
                        <th>Cantidad</th>
                        <th>Stock min.</th>
                        <th>Stock max.</th>
                        <th>Reservado</th>
                        <th>Pendiente de recepción</th>
                        <th>Disponible</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <tr v-for="row in productos_stock">
                        <td>{{ row.alm_nombre }}</td>
                        <td>{{ row.cantidad }}</td>
                        <td>{{ row.ps_stockmin }}</td>
                        <td>{{ row.ps_stockmax }}</td>
                        <td>{{ row.ps_reservada }}</td>
                        <td>{{ row.ps_pterecibir }}</td>
                        <td>{{ row.cantidad }}</td>
                        <td class="text-center">
                            <div class="form-button-action">
                                <?php if ($opeditar_inventario) : ?>
                                    <button type="button" title="Editar" class="btn btn-link btn-primary" @click="verStock(row.ps_id, row.ps_almid, row.ps_cantidad, row.ps_stockmin, row.ps_stockmax)">
                                        <i class="fa fa-edit"></i>
                                    </button>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
