<div class="card p-0 m-0">
    <input type="hidden" id="tipo" value="<?= $producto['pro_tipo'] ?>">
    <form id="form_editar_productos" autocomplete="off" @submit.prevent="editarProducto">
        <div class="card-body">
            <div class="form-row">
                <div class="col-sm-3">
                    <div class="form-group">
                        <label for="referencia">Referencia</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fas fa-hashtag fa-fw"></i>
                                </span>
                            </div>
                            <input type="text" id="referencia" class="form-control" maxlength="30" value="<?= $producto['pro_codigo'] ?>">
                        </div>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label for="pro_nombre">Nombre corto</label>
                        <input type="text" id="pro_nombre" class="form-control" value="<?= $producto['pro_nombrecorto'] ?>" maxlength="33">
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label for="descripcion">Nombre </label>
                        <input type="text" id="pro_descripcion" class="form-control" value="<?= $producto['pro_descripcion'] ?>">
                    </div>
                </div>
            </div>
            <div class="form-row">
                <div class="col-sm-3">
                    <div class="form-group">
                        <label for="tiposel">Tipo</label>:
                        <select id="tiposel" class="form-control" v-model="tipo_producto">
                            <option value="" disabled>Seleccione un elemento</option>
                            <option value="1" <?= ($producto['pro_tipo'] == 1) ? 'selected' : '' ?>>Producto simple </option>
                            <option value="2" <?= ($producto['pro_tipo'] == 2) ? 'selected' : '' ?>>Producto compuesto </option>
                            <option value="3" <?= ($producto['pro_tipo'] == 3) ? 'selected' : '' ?>>Servicio </option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-3" v-if="tipo_producto==1">
                    <div class="form-group">
                        <label for="numerodeparte">Numero de Parte:</label>
                        <div class="input-group">
                            <span class="input-group-addon">
                                <span class="glyphicon glyphicon-tag" aria-hidden="true"></span>
                            </span>
                            <input class="form-control" type="text" id="numerodeparte" value="<?= $producto['pro_partnumber'] ?>">
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label for="codigodeequivalencia">Código de equivalencia:</label>
                        <input class="form-control" type="text" id="codigodeequivalencia" value="<?= $producto['pro_equivalencia'] ?>">
                        <small class="form-text text-muted">Dos o más artículos son equivalentes si tienen el mismo código de equivalencia.</small>
                    </div>
                </div>
            </div>
            <div class="form-row">
                <div class="col-sm-4" v-if="tipo_producto==1">
                    <div class="form-group">
                        <label for="fabricantes"><a href="<?= url('fabricantes') ?>" target="_blank">Fabricante</a> <i @click="recargarFabricantes" style="cursor: pointer;" class="fas fa-sync-alt"></i></label>
                        <v-select id="fabricantes" v-model="selectedFabid" :options="optionsFabricantes" :reduce="row => row.fa_id" label="fa_nombre" />
                    </div>
                </div>
                <div class="col-sm-4" v-if="tipo_producto==1">
                    <div class="form-group">
                        <label for="provid"><a href="<?php url('proveedores'); ?>" target="_blank">Proveedores</a> <i @click="recargarProveedores" style="cursor: pointer;" class="fas fa-sync-alt"></i> </label>
                        <v-select id="provid" multiple v-model="selectedProvid" :options="optionsProveedores" :reduce="row => row.prov_id" label="prov_nombre" />
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label for="catid"><a href="<?php url('categorias'); ?>" target="_blank">Categorias</a> <i @click="recargarCategorias" style="cursor: pointer;" class="fas fa-sync-alt"></i> </label>
                         <treeselect :multiple="true" :options="optionsCategorias" placeholder="Select your favourite(s)..." v-model="selectedCatid" />
                        <treeselect-value :value="selectedCatid" />
                    </div>
                </div>
            </div>

            <div class="form-row" v-if="tipo_producto==1">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label for="stock">Stock</label>
                        <input type="number" id="stock" class="form-control" v-model="stock_fisico_total" disabled>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label for="fechadeexpedicion">Fecha de Expedicion</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text">
                                    <i class="fas fa-calendar-alt fa-fw"></i>
                                </span>
                            </div>
                            <input type="date" id="fechadeexpedicion" class="form-control" value="<?= (is_null($producto['pro_expedicion'])) ? '' : date('Y-m-d', strtotime($producto['pro_expedicion']));  ?>">
                        </div>
                    </div>
                </div>
                <div class="col-sm-4">
                    <div class="form-group">
                        <label for="fechadevencimiento">Fecha de Vencimiento</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fas fa-calendar-alt fa-fw"></i>
                                </span>
                            </div>
                            <input type="date" id="fechadevencimiento" class="form-control" value="<?= (is_null($producto['pro_vencimiento'])) ? '' : date('Y-m-d', strtotime($producto['pro_vencimiento'])); ?>">
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <label for="observaciones">Descripci&oacute;n</label>
                <textarea id="pro_observaciones" class="form-control"><?= $producto['pro_observaciones'] ?></textarea>
            </div>
            <div class="form-row">
                <div class="col-sm-2" v-if="tipo_producto==1">
                    <div class="form-check">
                        <label class="form-check-label">
                            <input class="form-check-input" type="checkbox" <?= ($producto['pro_nostock'] == 1) ? 'checked' : '' ?> id="pro_nostock">
                            <span class="form-check-sign">No controlar stock</span>
                        </label>
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-check">
                        <label class="form-check-label">
                            <input class="form-check-input" type="checkbox" <?= ($producto['pro_secompra'] == 1) ? 'checked' : '' ?> id="pro_secompra">
                            <span class="form-check-sign">Se compra</span>
                        </label>
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-check">
                        <label class="form-check-label">
                            <input class="form-check-input" type="checkbox" <?= ($producto['pro_sevende'] == 1) ? 'checked' : '' ?> id="pro_sevende">
                            <span class="form-check-sign">Se vende</span>
                        </label>
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-check">
                        <label class="form-check-label">
                            <input class="form-check-input" type="checkbox" <?= ($producto['pro_bloqueado'] == 1) ? 'checked' : '' ?> id="pro_bloqueado">
                            <span class="form-check-sign">Bloqueado</span>
                        </label>
                    </div>
                </div>
                <div class="col-sm-2">
                    <div class="form-check">
                        <label class="form-check-label">
                            <input class="form-check-input" type="checkbox" <?= ($producto['pro_publico'] == 1) ? 'checked' : '' ?> id="pro_publico">
                            <span class="form-check-sign">Público</span>
                        </label>
                    </div>
                </div>
            </div>
            <div class="form-row">
                <div class="col-12">
                    <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                        {{ row }}
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col text-right">
                    <button class="btn btn-sm btn-secondary" type="reset">
                        <i class="fas fa-undo fa-fw" aria-hidden="true"></i>
                        <span class="d-none d-sm-inline-block">Deshacer</span>
                    </button>
                    <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                        <i class="loader loader-info"></i>
                    </button>
                    <button v-else class="btn btn-sm btn-primary" type="submit">
                        <i class="fas fa-save fa-fw" aria-hidden="true"></i>
                        <span class="d-none d-sm-inline-block">Guardar</span>
                    </button>
                </div>
            </div>
        </div>
    </form>
    <div class="card-body" v-if="tipo_producto==2">
        <div class="card-title"> </div>
        <div class="form-row">
            <div class="col-sm-4">
                <div class="form-group">
                    <label>
                        Precio venta
                    </label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text">
                                <i class="fas fa-dollar-sign fa-fw"></i>
                            </span>
                        </div>
                        <input type="number" id="pro_precioc" v-model="precioCompuesto" class="form-control" disabled>
                    </div>
                </div>
            </div>
            <div class="col-sm-8">
                <div class="form-group">
                    <label for="prod"><a href="<?php url('productos'); ?>" target="_blank">Productos</a> <i @click="recargarProductos" style="cursor: pointer;" class="fas fa-sync-alt"></i> </label>
                    <v-select id="tututut" v-model="selectedProd" label="pro_descripcion" :filterable="false" :options="optionsProductos" @search="onSearch" v-on:input="AgregarproductoCompuesto">
                        <template slot="no-options">
                            Escribe para buscar
                        </template>
                        <template slot="option" slot-scope="option">
                            <div class="d-flex ml-0 pl-0">
                                <div class="avatar ml-0 pl-0">
                                    <span class="avatar-title rounded-circle border border-white bg-info ml-0 pl-0" style="width: 40px; height: 40px;">{{ option.pro_descripcion.charAt() }}</span>
                                </div>
                                <div class="flex-1 pt-1 ml-2">
                                    <h6 class="fw-bold mb-1">{{ option.pro_descripcion.toUpperCase() }}</h6>
                                </div>
                            </div>
                        </template>
                    </v-select>
                </div>
            </div>
            <div class="col-sm-12" v-if="tipo_producto==2" style="padding-bottom: 200px;">
                <div class="form-group">
                    <table class="table display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="table-termcompletado">
                        <thead>
                            <tr>
                                <th></th>
                                <th>Producto</th>
                                <th>Stock</th>
                                <th>Precio venta</th>
                                <th>*Precio</th>
                                <th>*Cantidad</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in cheque">
                                <td><a href="#" class="btn btn-link text-danger" @click="eliminarSeleccion(row.pro_cid)"><i class="fa fa-trash"></i></a></td>
                                <td>{{row.pro_descripcion}} - {{row.pro_nombrecorto}}</td>
                                <td><span class="badge badge-success">{{row.total_stock}}</span></td>
                                <td><span class="badge badge-danger">{{row.pro_precio}}</span></td>
                                <td> <input type="number" :value="row.pro_ccprecio" :id="'precio-'+row.pro_cid" min="0" class="form-control" style="width: 120px;" @change="precioTotal(row.pro_cid)"></td>
                                <td> <input type="number" :value="row.pro_cccant" :id="'cantidad-'+row.pro_cid" class="form-control" min="0" style="width: 95px;" @change="cantidadProdCompuesto(row.pro_cid,row.total_stock)"></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>