<form enctype="multipart/form-data" @submit.prevent="enviarImagen">
    <div class="card bg-light mb-2">
        <div class="card-body">
            <div class="row">
                <div class="form-group">
                    <label for="pro_imagen">Buscar imagen</label>
                    <input type="file" class="form-control" id="file" ref="file" v-on:change="handleFileUpload()" accept=".jpg,.jpeg,.png,.pdf">
                    <small class="form-text text-muted">Solo archivos con formato PDF, PNG o JPG y maximo de 1MB</small>
                </div>
            </div>
            <div class="row">
                <div class="col text-right">
                    <button class="btn btn-sm btn-secondary" type="reset">
                        <i class="fas fa-undo fa-fw" aria-hidden="true"></i>
                        <span class="d-none d-sm-inline-block">Deshacer</span>
                    </button>
                    <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                        <i class="loader loader-info"></i>
                    </button>
                    <button v-else class="btn btn-sm btn-primary" type="submit">
                        <i class="fas fa-save fa-fw" aria-hidden="true"></i>
                        <span class="d-none d-sm-inline-block">Guardar</span>
                    </button>
                </div>
            </div>
        </div>
    </div>
</form>

<div class="row row-projects">
    <div class="col-sm-6 col-lg-3" v-for="row in imagenes">
        <div class="card">
            <div class="card-body">
                <div class="p-2">
                    <img class="card-img-top rounded" :src="'<?= constant('IMG_URI') ?>productos/'+row.pi_imagen">
                </div>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="col text-right">
                        <a class="btn btn-xs btn-danger" href="" @click.prevent="eliminarImagen(row.pi_id)">
                            <i class="fas fa-trash" aria-hidden="true"></i>
                            <span class="d-none d-sm-inline-block"></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
