<?php

namespace App\Modelos;

use Core\Database;

class ProductosImagen extends Database
{
    protected $table = 'app_productos_imagen';
    protected $id    = 'pi_id';

    public function obtenerProductoImagenes($pro_id)
    {
        return $this->consultar("SELECT pi_imagen FROM app_productos_imagen WHERE pi_proid=$pro_id")->all();
    }

    public function obtenerProductoImagen($pro_id)
    {
        return $this->consultar("SELECT pi_imagen FROM app_productos_imagen WHERE pi_proid=$pro_id")->row();
    }

    public function obtenerProductosConImagenes($id_categoria)
    {
        return $this->consultar("SELECT pro.pro_id, pro.pro_descripcion, ac.cat_nombre, pro.pro_costo, pro.pro_precio, api.pi_imagen 
        FROM app_productos pro
        JOIN app_productos_stocks ps ON ps.ps_proid=pro.pro_id
        JOIN app_productos_imagen api ON pro.pro_id = api.pi_proid
        JOIN app_productos_categorias apc ON apc.pc_proid  = pro.pro_id
        JOIN app_categorias ac ON ac.cat_id = apc.pc_catid 
        WHERE pro_sevende = 1 AND (ps.ps_cantidad > 0 OR pro_nostock=1) AND ac.cat_id = $id_categoria GROUP BY pro.pro_id ORDER BY pro.pro_descripcion")->all();
    }
    
    public function obtenerProductosConImagenesEnalgunos($id_categoria)
    {
        return $this->consultar("SELECT pro.pro_id, pro.pro_descripcion, ac.cat_nombre, pro.pro_costo, pro.pro_precio, api.pi_imagen 
        FROM app_productos pro
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro.pro_id
        LEFT JOIN app_productos_imagen api ON pro.pro_id = api.pi_proid
        JOIN app_productos_categorias apc ON apc.pc_proid  = pro.pro_id
        JOIN app_categorias ac ON ac.cat_id = apc.pc_catid 
        WHERE pro_sevende = 1 AND (ps.ps_cantidad > 0 OR pro_nostock=1) AND ac.cat_id = $id_categoria GROUP BY pro.pro_id ORDER BY pro.pro_descripcion")->all();
    }

    public function obtenerImagen($id_imagen)
    {
        return $this->consultar("SELECT * FROM app_productos_imagen WHERE pi_id = $id_imagen")->row();
    }
    
    public function obtenerImagenId($id)
    {
        return $this->consultar("SELECT * FROM app_productos_imagen WHERE pi_proid = $id")->all();
    }
}
