<?php

namespace App\Modelos;

use Core\Database;

class Productos extends Database
{
    protected $table = 'app_productos';
    protected $id    = 'pro_id';

    public function obtenerFactoresBitacora(string $fecha)
    {
        return $this->consultar("SELECT bifac_id id, DATE_FORMAT(bifac_fecha, '%d-%m-%Y %h:%i %p') fecha, bifac_factor factor
        FROM app_bitacora_factor 
        WHERE DATE(bifac_fecha) = DATE('$fecha')
        GROUP BY bitfac_relacion")->all();
    }

    public function obtenerBitacoraFactor(int $id_bifac)
    {
        return $this->consultar("SELECT * FROM app_bitacora_factor WHERE bifac_id = $id_bifac")->row();
    }

    public function condicional($condicional)
    {
        return $this->consultar("$condicional")->row(); 
    }

    public function getProductos()
    {
        return $this->consultar('SELECT pro_id, pro_codigo, pro_descripcion, pro_costo, pro_precio, pro_publico
        FROM app_productos
        WHERE pro_tipo != 3  ORDER BY pro_id desc')->all();
    }

    public function obtenerProductos()
    {
        return $this->consultar('SELECT pro_id, pro_codigo, pro_descripcion, fa_nombre, pro_costo, pro_precio, pro_publico, sum(ps_cantidad) as cantidad 
        FROM app_productos pro 
        LEFT JOIN app_fabricantes fa ON fa.fa_id=pro.pro_fabid
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
        GROUP BY pro.pro_id  ORDER BY pro.pro_id desc')->all();
    }

    public function obtenerProductosSinServicio()
    {
        return $this->consultar('SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, fa.fa_nombre, pro.pro_costo, pro.pro_precio, pro.pro_publico, sum(ps.ps_cantidad) as cantidad 
        FROM app_productos pro 
        LEFT JOIN app_fabricantes fa ON fa.fa_id=pro.pro_fabid
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
        LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
        WHERE pro_tipo != 3 
        GROUP BY pro.pro_id  ORDER BY pro.pro_id desc')->all();
    }

    public function obtenerProductosSinServiciot($peticion)
    {
        return $this->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, fa.fa_nombre, pro.pro_costo, pro.pro_precio, pro.pro_publico, sum(ps.ps_cantidad) as cantidad 
        FROM app_productos pro 
        LEFT JOIN app_fabricantes fa ON fa.fa_id=pro.pro_fabid
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
        LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
        WHERE $peticion  
        ORDER BY pro.pro_id DESC")->all();
    }

    public function obtenerProductosSinServicioStock($id)
    {
        return $this->consultar("SELECT pro_id, pro_codigo, pro_descripcion, pro_costo, pro_precio, pro_publico, sum(ps_cantidad) as cantidad 
        FROM app_productos pro 
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
        LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
        WHERE a.alm_garantia=0 AND pro_tipo != 3 AND pro.pro_id=$id  ORDER BY pro.pro_id desc")->row();
    }

    public function obtenerProductosServicios()
    {
        return $this->consultar('SELECT pro_id, pro_codigo, pro_descripcion, pro_precio
        FROM app_productos pro 
        WHERE pro_tipo = 3  ORDER BY pro.pro_id desc')->all();
    }

    public function obtenerProductosServiciost($peticion)
    {
        return $this->consultar("SELECT pro_id, pro_codigo, pro_descripcion, pro_precio
        FROM app_productos pro 
        WHERE $peticion")->all();
    }

    public function obtenerProductosVariantes()
    {
        return $this->consultar('SELECT * FROM app_productos_variantes pv
        LEFT JOIN app_productos p ON p.pro_id=pv.pv_proid
        LEFT JOIN app_productos_atributos pa ON pa.pa_id=pv.pv_atributovalor1
        LEFT JOIN app_productos_atributos_valores pav ON pav.pav_paid=pv.pv_atributovalor1')->all();
    }

    public function obtenerAlmacenesEmpleadoSucursales($sucursal)
    {
        return $this->consultar("SELECT * 
        FROM app_empleados_almacen ea
        JOIN app_almacenes a ON a.alm_id = ea.empalm_almid 
        JOIN app_almacen_sucursal alms ON alms.alsu_almid = a.alm_id 
        JOIN app_sucursales su ON su.su_id = alms.alsu_suid 
        WHERE empalm_empid={$_SESSION['user_data']['emp_id']} AND alms.alsu_suid =$sucursal")->all();
    }

    public function obtenerProductosStockBajom($id_almacen)
    {
        return $this->consultar("SELECT * FROM app_productos pro 
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid = pro.pro_id 
        LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
        LEFT JOIN app_fabricantes fa ON fa.fa_id = pro.pro_fabid 
        WHERE ps.ps_stockmin > ps.ps_cantidad AND a.alm_id = $id_almacen")->all();
    }

    public function obtenerProductosStockAlmacenm($id_almacen)
    {
        return $this->consultar("SELECT * 
            FROM app_productos pro   
            LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro.pro_id
            LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid
            WHERE a.alm_garantia=0 AND ps.ps_cantidad > 0 AND a.alm_id = $id_almacen")->all();
    }

    public function obtenerProductosStockD($peticion)
    {
        return $this->consultar("SELECT * FROM app_productos pro        
        JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
        JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
        WHERE $peticion")->all();
    }

    public function obtenerProductosStockDProv($prov,$peticion)
    {
        return $this->consultar("SELECT * FROM app_productos pro        
        JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
        JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
        JOIN app_productos_proveedores pp ON pro.pro_id=pp.pp_proid AND pp.pp_provid=$prov  
        WHERE $peticion")->all();
    }

    public function obtenerProductosStock()
    {
        return $this->consultar("SELECT * FROM app_productos pro        
        JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
        JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
        WHERE a.alm_garantia=0 AND ps.ps_cantidad > 0")->all();
    }

    public function obtenerProductosVencidos()
    {
        return $this->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, ps.ps_cantidad, DATE_FORMAT(pro.pro_expedicion, '%d-%m-%Y') expedicion, DATE_FORMAT(pro.pro_vencimiento, '%d-%m-%Y') vencimiento, a.alm_nombre 
        FROM app_productos pro
        JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
        JOIN app_almacenes a ON a.alm_id = ps.ps_almid
        WHERE DATE(CURRENT_DATE()) > DATE(pro_vencimiento)")->all();
    }

    public function obtenerProductosVencidost($peticion)
    {
        return $this->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, ps.ps_cantidad, DATE_FORMAT(pro.pro_expedicion, '%d-%m-%Y') expedicion, DATE_FORMAT(pro.pro_vencimiento, '%d-%m-%Y') vencimiento, a.alm_nombre 
        FROM app_productos pro
        JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
        JOIN app_almacenes a ON a.alm_id = ps.ps_almid
        WHERE $peticion")->all();
    }

    public function obtenerProductosSinStock()
    {
        return $this->consultar('SELECT * FROM app_productos pro        
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id        
        WHERE ps.ps_cantidad = 0')->all();
    }

    public function obtenerProductosPublicos()
    {
        return $this->consultar('SELECT * FROM app_productos pro             
        WHERE pro.pro_publico = 1')->all();
    }

    public function obtenerProductosStockBajo()
    {
        return $this->consultar('SELECT * FROM app_productos pro 
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid = pro.pro_id 
        LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
        LEFT JOIN app_fabricantes fa ON fa.fa_id = pro.pro_fabid 
        WHERE ps.ps_stockmin > ps.ps_cantidad')->all();
    }

    public function obtenerProductosStockBajot($peticion)
    {
        return $this->consultar("SELECT * FROM app_productos pro 
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid = pro.pro_id 
        LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
        LEFT JOIN app_fabricantes fa ON fa.fa_id = pro.pro_fabid 
        WHERE $peticion")->all();
    }

    public function obtenerProductosStockBajoProv($prov,$peticion)
    {
        return $this->consultar("SELECT * FROM app_productos pro 
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid = pro.pro_id 
        LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
        LEFT JOIN app_fabricantes fa ON fa.fa_id = pro.pro_fabid 
        JOIN app_productos_proveedores pp ON pro.pro_id=pp.pp_proid AND pp.pp_provid=$prov  
        WHERE $peticion")->all();
    }

    public function obtenerProductosStockBajoComp($prov,$almacen)
    {
        return $this->consultar("SELECT * FROM app_productos pro 
        JOIN app_productos_stocks ps ON ps.ps_proid = pro.pro_id 
        JOIN app_productos_proveedores pp ON pro.pro_id=pp.pp_proid   
        JOIN app_proveedores prov ON prov.prov_id=pp.pp_provid 
        WHERE (ps.ps_stockmin > ps.ps_cantidad) AND pp.pp_provid=$prov AND ps.ps_almid=$almacen")->all();
    }

    public function obtenerProductosVencidosProv($prov,$peticion)
    {
        return $this->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, ps.ps_cantidad, DATE_FORMAT(pro.pro_expedicion, '%d-%m-%Y') expedicion, DATE_FORMAT(pro.pro_vencimiento, '%d-%m-%Y') vencimiento, a.alm_nombre 
        FROM app_productos pro
        JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
        JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
        JOIN app_productos_proveedores pp ON pro.pro_id=pp.pp_proid AND pp.pp_provid=$prov  
        WHERE $peticion")->all();
    }

    public function obtenerProductoPorId($pro_id)
    {
        return $this->consultar("SELECT * FROM app_productos pro WHERE pro.pro_id=$pro_id")->row();
    }

    public function obtenerProductoVariantes($pro_id)
    {
        return $this->consultar("SELECT * FROM app_productos pro
        LEFT JOIN app_productos_variantes pv ON pv.pv_proid=pro.pro_id
        LEFT JOIN app_productos_atributos pa ON pa.pa_id=pv.pv_atributovalor1
        LEFT JOIN app_productos_atributos pa_2 ON pa_2.pa_id=pv.pv_atributovalor2
        LEFT JOIN app_productos_atributos_valores pav on pav.pav_paid=pa.pa_id
        WHERE pro.pro_id=$pro_id AND pv.pv_proid=$pro_id")->all();
    }

    public function obtenerTarifasSinRelacionConProducto($id_producto)
    {
        return $this->consultar("select * from app_tarifas at2 WHERE at2.tar_id NOT IN (select pt.pt_tarid from app_productos_tarifas pt where pt.pt_proid=$id_producto)")->all();
    }

    public function asignar_tarifas($pt_proid, $pt_tarid)
    {
        return $this->consultar("INSERT INTO app_productos_tarifas (pt_proid,pt_tarid,pt_tarprecio) VALUES ($pt_proid, $pt_tarid,0)")->run();
    }

    public function deleter_tarifas($pt_proid, $pt_tarid)
    {
        return $this->consultar("DELETE FROM app_productos_tarifas WHERE pt_proid = $pt_proid AND pt_tarid=$pt_tarid")->run();
    }

    public function obtenerTotalStockProducto($id_producto)
    {
        return $this->consultar("SELECT SUM(ps.ps_cantidad) as total_stock, ps.ps_almid, a.alm_garantia FROM app_productos_stocks ps
        LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
        WHERE ps_proid=$id_producto AND a.alm_garantia=0")->row();
    }

    public function obtenerAlamcen($id_almacen)
    {
        return $this->consultar("SELECT * FROM app_almacenes WHERE alm_id=$id_almacen")->all();
    }

    public function obtenerDatosEmpresa()
    {
        return $this->consultar('SELECT * FROM app_empresas WHERE emp_id=1')->row();
    }

    public function obtenerTarifa($id_tarifa)
    {
        return $this->consultar("SELECT * FROM app_tarifas WHERE tar_id=$id_tarifa")->row();
    }

    public function obtenerTarifasVisibles()
    {
        return $this->consultar("SELECT * FROM app_tarifas WHERE tar_visible = 1")->all();
    }

    public function obtenerDivisaMaster()
    {
        return $this->consultar("SELECT * FROM app_divisas WHERE div_predeterminado = 1")->row();
    }

    public function obtenerCategorias()
    {
        return $this->consultar("SELECT * FROM app_categorias")->all();
    }

    public function obtenerProductosSimples()
    {
        return $this->consultar('SELECT * FROM app_productos WHERE pro_tipo = 1')->all();
    }

    public function obtenerProductosSimplesBuscar(string $buscar)
    {
        $buscar = strtolower($buscar);
        $trozos = explode(" ", $buscar);
        $numero = count($trozos);
        if ($numero == 1) {
            $sql = "SELECT pro_id, pro_codigo, fa_nombre,pro_impid, pro_descripcion, pro_precio, ps.ps_cantidad, pimg.pi_imagen
            FROM app_productos p
            LEFT JOIN app_productos_stocks ps ON p.pro_id = ps.ps_proid
            LEFT JOIN app_productos_imagen pimg ON pimg.pi_proid = p.pro_id
            LEFT JOIN app_fabricantes fa ON fa.fa_id=p.pro_fabid
            WHERE  pro_tipo = 1 AND (LOWER(pro_codigo) LIKE '%$buscar%' OR LOWER(pro_descripcion) LIKE '%$buscar%') GROUP BY pro_id LIMIT 30";
        } elseif ($numero > 1) {

            $sql = "SELECT p.pro_id, MATCH(p.pro_codigo, p.pro_descripcion,p.pro_nombrecorto) AGAINST('$buscar') AS relevancia, p.pro_codigo, fa.fa_nombre,p.pro_impid,p.pro_descripcion, p.pro_precio,p.pro_nombrecorto, ps.ps_cantidad, pimg.pi_imagen
            FROM app_productos p
            LEFT JOIN app_productos_stocks ps ON p.pro_id = ps.ps_proid
            LEFT JOIN app_productos_imagen pimg ON pimg.pi_proid = p.pro_id
            LEFT JOIN app_fabricantes fa ON fa.fa_id=p.pro_fabid
            WHERE p.pro_tipo =1 AND (MATCH(pro_codigo,pro_descripcion,pro_nombrecorto) AGAINST('$buscar')) ORDER BY relevancia";
        }
        return $this->consultar("$sql")->all();
    }

    public function obtenerproImp($pro)
    {
        return $this->consultar("SELECT * FROM app_productos p 
        LEFT JOIN app_impuestos imp ON imp.imp_id=p.pro_impid 
        WHERE p.pro_id = $pro")->row();
    }

    public function obtenerProductosSimplesw($id)
    {
        return $this->consultar("SELECT SUM(ps.ps_cantidad) as total_stock, pro.*,ps.*,a.* FROM app_productos pro
        LEFT JOIN app_productos_stocks ps ON ps.ps_proid =pro.pro_id
        LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
        WHERE pro.pro_id=$id AND pro.pro_tipo = 1 AND a.alm_garantia=0")->row();
    }

    public function obtenerProductosSimplesCompuestos($id)
    {
        return $this->consultar("SELECT * FROM app_productos_compuestos c 
        LEFT JOIN app_productos pro ON pro.pro_id=c.pro_ccproid WHERE c.pro_ccid = $id")->all();
    }

    public function obtenerArticulosDeFACV($fecha_desde, $fecha_hasta, $id)
    {
        return $this->consultar("SELECT fm.fm_id AS id, fm.fm_divid AS divisa,fm.fm_fecha AS fecha, fm.fm_correlativo AS correlativo, art.fa_proid as proid, art.fa_prototal AS total, art.fa_procantidad AS cantidad, art.fa_procosto AS costo, art.fa_proprecio AS precio, art.fa_prodescuento AS descuento, c.*, s.*,d.* 
             FROM app_factura_master fm
             LEFT JOIN app_factura_articulos art ON fm.fm_id = art.fa_fmid 
             LEFT JOIN app_sucursales s ON s.su_id=fm.fm_surcid 
             LEFT JOIN app_clientes c ON c.cli_id = fm.fm_cliid 
             LEFT JOIN app_divisas d ON d.div_id = fm.fm_divid
             WHERE fm_estatus < 3 AND art.fa_proid = $id 
             AND (DATE(fm.fm_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta')")->all();
    }

    public function obtenerArticulosDeNEV($fecha_desde, $fecha_hasta, $id)
    {
        return $this->consultar("SELECT ne.ne_id AS id, ne.ne_divid as divisa,ne.ne_fecha AS fecha,ne.ne_correlativo AS correlativo, ne.ne_cliid as cliente, neart.neart_proid as proid, neart.neart_prototal AS total, neart.neart_procantidad AS cantidad, neart.neart_procosto AS costo, neart.neart_proprecio AS precio, neart.neart_prodescuento AS descuento, c.*, s.*,d.* 
             FROM app_notas_de_entrega ne
             LEFT JOIN app_notas_de_entrega_articulos neart ON ne.ne_id = neart.neart_neid 
             LEFT JOIN app_sucursales s ON s.su_id=ne.ne_surcid 
             LEFT JOIN app_clientes c ON c.cli_id = ne.ne_cliid 
             LEFT JOIN app_divisas d ON d.div_id = ne.ne_divid 
             WHERE neart.neart_proid = $id AND ne_estatus < 3 AND (DATE(ne.ne_fecha) BETWEEN '$fecha_desde' AND '$fecha_hasta') ")->all();
    }
    
    public function obtenerCategoriasPadre()
    {
        return $this->consultar("SELECT * FROM app_categorias WHERE cat_padre is null")->all();
    }
}
