<?php

namespace App\Controladores;

use App\Modelos\AlmacenUbicacion;
use App\Modelos\BitacoraStock;
use App\Modelos\Categorias;
use App\Modelos\Compras;
use App\Modelos\EmpleadoSucursales;
use App\Modelos\Fabricantes;
use App\Modelos\Impuesto;
use App\Modelos\ProductoCategoria;
use App\Modelos\ProductoCodBarra;
use App\Modelos\ProductoFactor;
use App\Modelos\ProductoProveedor;
use App\Modelos\Productos;
use App\Modelos\ProductosCompuestos;
use App\Modelos\ProductosImagen;
use App\Modelos\ProductoUbicacion;
use App\Modelos\Proveedor;
use App\Modelos\Stock;
use App\Modelos\StockTransferencia;
use App\Modelos\Tarifas;
use Automattic\WooCommerce\Client;
use Automattic\WooCommerce\HttpClient\HttpClientException;
use Core\Controller;
use Core\Helpers\Documento;
use Core\Helpers\Moneda;
use Core\Helpers\Notifica;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Vista;
use DateTime;
use DateTimeZone;
use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use Verot\Upload\Upload;

final class ProductosControlador extends Controller
{
    private $array_errors = [];
    private $module;
    private $fabricantes;
    private $productos;
    private $transferencia;
    private $div_master;
    private $woocommerce;

    public function __construct()
    {
        parent::__construct();
        $this->module           = new Module('productos');
        $this->fabricantes      = new Fabricantes();
        $this->productos        = new Productos();
        $this->stock            = new Stock();
        $this->tarifas          = new Tarifas();
        $this->transferencia    = new StockTransferencia();
        $this->div_master       = $this->productos->obtenerDivisaMaster();
    }

    public function obtenerProductos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $ver_precio_compra = $this->module->has_module_action_permission('productos', 'ver_precio_compra', $_SESSION['user_data']['emp_id']);

            $array_productos = [];
            $array_productos_serv = [];

            $tarifas = $this->productos->obtenerTarifasVisibles();
            $productos = $this->productos->obtenerProductosSinServicio();
            $productos_servicios = $this->productos->obtenerProductosServicios();

            $empresa = $this->productos->consultar("SELECT * FROM app_empresas")->row();
            $factCompra = $empresa['emp_iva'];

            if (is_countable($productos) && count($productos)) {

                foreach ($productos as $row) {

                    $list_tarifas = [];
                    $impuesto = $this->productos->obtenerproImp($row['pro_id']);

                    foreach ($tarifas as $tarifa) {
                        $tarifa_data = $this->productos->obtenerTarifa($tarifa['tar_id']);

                        if ('pvp' == $tarifa_data['tar_aplicar'] || 'pvpiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($row['pro_precio'] * ($impuesto['imp_valor'] / 100));
                        }
                        if ('costo' == $tarifa_data['tar_aplicar'] || 'costoiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($row['pro_costo'] * ($impuesto['imp_valor'] / 100));
                        }
                        $precio_total = TarifasControlador::aplicar($row['pro_costo'], $row['pro_precio'], $tarifa_data['tar_aplicar'], $tarifa_data['tar_valorx'], $tarifa_data['tar_valory'], $iva_m);
                        $list_tarifas[] = [
                            'precio' => Moneda::moneda($precio_total, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        ];
                    }


                    $stock = $this->productos->obtenerProductosSinServicioStock($row['pro_id']);

                    $array_productos[] = [
                        'pro_id'            => $row['pro_id'],
                        'pro_codigo'        => $row['pro_codigo'],
                        'pro_descripcion'   => $row['pro_descripcion'],
                        'fa_nombre'         => $row['fa_nombre'],
                        'cantidad'          =>  round($stock['cantidad'], 2),
                        'pro_costo'         => ($ver_precio_compra) ? Moneda::moneda($row['pro_costo'], $this->div_master['div_locale'], $this->div_master['div_simbolo']) : '<span class="text-danger fa fa-ban"></span>',
                        'pro_precio'        => ($factCompra == 1) ?  convertir_a_float($row['pro_precio'] + ($row['pro_precio'] * ($impuesto['imp_valor'] / 100))) : Moneda::moneda($row['pro_precio'], $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'pro_publico'       => $row['pro_publico'],
                        'tarifas'           => $list_tarifas,
                    ];
                }
            }

            if (is_countable($productos_servicios) && count($productos_servicios)) {
                foreach ($productos_servicios as $row) {
                    $array_productos_serv[] = [
                        'pro_id'            => $row['pro_id'],
                        'pro_codigo'        => $row['pro_codigo'],
                        'pro_descripcion'   => $row['pro_descripcion'],
                        'pro_precio'        => Moneda::moneda($row['pro_precio'], $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                    ];
                }
            }

            Http::json_response([
                'productos' => count($array_productos),
                'productos_wooc' => $array_productos,
                'servicios' =>  count($array_productos_serv),
                'tarifas'   => $tarifas,
                'lista' => $array_productos,
                'stock' => count($this->productos->obtenerProductosStock()),
                'stockbajo' =>  count($this->productos->obtenerProductosStockBajo()),
                'stockvencido' =>  count($this->productos->obtenerProductosVencidos()),
                'productos_transferencia'   =>  count($this->transferencia->obtenerListaTransferencias()),
            ]);
        }
    }

    public function obtenerProductosTodosSimples()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $ver_precio_compra = $this->module->has_module_action_permission('productos', 'ver_precio_compra', $_SESSION['user_data']['emp_id']);

            $empresa = $this->productos->consultar("SELECT * FROM app_empresas")->row();
            $factCompra = $empresa['emp_iva'];

            $draw = $_POST['draw'];
            $row = $_POST['start'];
            $rowperpage = $_POST['length']; // Rows display per page
            $columnIndex = $_POST['order'][0]['column']; // Column index
            $columnName = $_POST['columns'][$columnIndex]['data']; // Column name
            $columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
            $searchValue = $_POST['search']['value'];

            $array_productos = [];

            $totalRecordwithFilter = "";
            ## Search 
            $searchQuery = " ";
            if ($searchValue != '') {
                $palabras = explode(' ', $searchValue);

                if (count($palabras) > 1) {
                    $searchQuery .= "AND (";

                    foreach ($palabras as $i => $pal) {
                        if ($i == 0) {
                            $searchQuery .= "(pro.pro_id LIKE '%" . $pal . "%' OR ps.ps_disponible LIKE '%" . $pal . "%' OR a.alm_nombre LIKE '%" . $pal . "%' OR ps_cantidad LIKE '%" . $pal . "%' OR 
                            pro.pro_codigo LIKE '%" . $pal . "%' OR pro.pro_descripcion LIKE '%" . $pal . "%' OR pro.pro_precio LIKE '%" . $pal . "%' OR pro.pro_costo LIKE '%" . $pal . "%' OR fa.fa_nombre LIKE '%" . $pal . "%')";
                        } else {
                            $searchQuery .= " AND (pro.pro_id LIKE '%" . $pal . "%' OR ps.ps_disponible LIKE '%" . $pal . "%' OR a.alm_nombre LIKE '%" . $pal . "%' OR ps_cantidad LIKE '%" . $pal . "%' OR 
                            pro.pro_codigo LIKE '%" . $pal . "%' OR pro.pro_descripcion LIKE '%" . $pal . "%' OR pro.pro_precio LIKE '%" . $pal . "%' OR pro.pro_costo LIKE '%" . $pal . "%' OR fa.fa_nombre LIKE '%" . $pal . "%')";
                        }
                    }

                    $searchQuery .= ")";
                } else {
                    $searchQuery .= "AND (pro.pro_id LIKE '%" . $searchValue . "%' OR ps.ps_disponible LIKE '%" . $searchValue . "%' OR a.alm_nombre LIKE '%" . $searchValue . "%' OR ps_cantidad LIKE '%" . $searchValue . "%' OR 
                    pro.pro_codigo LIKE '%" . $searchValue . "%' OR pro.pro_descripcion LIKE '%" . $searchValue . "%' OR pro.pro_precio LIKE '%" . $searchValue . "%' OR pro.pro_costo LIKE '%" . $searchValue . "%' OR fa.fa_nombre LIKE '%" . $searchValue . "%') ";
                }
            }

            $simple = 'pro.pro_tipo != 3 ';
            $productos_simples =  $this->productos->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, fa.fa_nombre, pro.pro_costo, pro.pro_precio, pro.pro_publico,pro.pro_peso, sum(ps.ps_cantidad) as ps_cantidad 
            FROM app_productos pro 
            LEFT JOIN app_fabricantes fa ON fa.fa_id=pro.pro_fabid
            LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
            LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
            WHERE pro_tipo != 3 
            GROUP BY pro.pro_id ORDER BY pro.pro_id ASC")->count();
            $totalRecords = $productos_simples;

            $searc =  $this->productos->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, fa.fa_nombre, pro.pro_costo, pro.pro_precio, pro.pro_publico,pro.pro_peso, sum(ps.ps_cantidad) as ps_cantidad  
            FROM app_productos pro 
            LEFT JOIN app_fabricantes fa ON fa.fa_id=pro.pro_fabid
            LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
            LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
            WHERE pro_tipo != 3  $searchQuery 
            GROUP BY pro.pro_id ORDER BY pro.pro_id ASC")->count();

            $totalRecordwithFilter = $searc;
            $tarifas = $this->productos->obtenerTarifasVisibles();

            ## Fetch records
            if ($rowperpage > 0) {
                $productos =  $this->productos->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, fa.fa_nombre, pro.pro_costo, pro.pro_precio, pro.pro_publico,pro.pro_peso, sum(ps.ps_cantidad) as ps_cantidad  
                FROM app_productos pro 
                LEFT JOIN app_fabricantes fa ON fa.fa_id=pro.pro_fabid
                LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
                LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
                WHERE pro_tipo != 3 $searchQuery GROUP BY " . $columnName . " ORDER BY pro.pro_id " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();
            } else {
                $productos =  $this->productos->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, fa.fa_nombre, pro.pro_costo, pro.pro_precio, pro.pro_publico,pro.pro_peso, sum(ps.ps_cantidad) as ps_cantidad  
                FROM app_productos pro 
                LEFT JOIN app_fabricantes fa ON fa.fa_id=pro.pro_fabid
                LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
                LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
                WHERE pro_tipo != 3 $searchQuery GROUP BY " . $columnName . " ORDER BY pro.pro_id " . $columnSortOrder . " ")->all();
            }

            if (is_countable($productos) && count($productos)) {

                foreach ($productos as $row) {

                    $list_tarifas = [];
                    $impuesto = $this->productos->obtenerproImp($row['pro_id']);


                    //$iva_m = ($row['pro_precio'] * ($impuesto['imp_valor'] / 100));
                    foreach ($tarifas as $tarifa) {
                        $tarifa_data = $this->productos->obtenerTarifa($tarifa['tar_id']);
                        if ('pvp' == $tarifa_data['tar_aplicar'] || 'pvpiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($row['pro_precio'] * ($impuesto['imp_valor'] / 100));
                        }
                        if ('costo' == $tarifa_data['tar_aplicar'] || 'costoiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($row['pro_costo'] * ($impuesto['imp_valor'] / 100));
                        }
                        $precio_total = TarifasControlador::aplicar($row['pro_costo'], $row['pro_precio'], $tarifa_data['tar_aplicar'], $tarifa_data['tar_valorx'], $tarifa_data['tar_valory'], $iva_m);
                        $list_tarifas[] = [
                            'precio' => Moneda::moneda($precio_total, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        ];
                    }


                    $stock = $this->productos->obtenerProductosSinServicioStock($row['pro_id']);

                    $comp = convertir_a_float($row['pro_precio'] + ($row['pro_precio'] * ($impuesto['imp_valor'] / 100)));
                    
                    $agencias=$this->productos->consultar("SELECT * FROM app_agencias")->all();
                    $envio_venta=0;
                    foreach ($agencias as $agencia) {
                        $precio_venta=($factCompra == 1) ?  $comp : $row['pro_precio'];
                        $total_agencia=0;
                        if($agencia['ag_aplicar']==0 && $row['pro_peso']>0){
                            $total_agencia= round($row['pro_peso']*($agencia['ag_tarifa'])/$agencia['ag_pesomin'],2);
                            $gananc=$precio_venta-$row['pro_costo'];
                            $porcentaje_gan=round(($gananc*100)/$total_agencia,2);
                            if($porcentaje_gan>=$agencia['ag_porcentaje']){
                                $envio_venta=1;
                            }
                        }
                    }

                    $array_productos[] = [
                        'pro_id'            => $row['pro_id'],
                        'pro_codigo'        => $row['pro_codigo'],
                        'pro_descripcion'   => $row['pro_descripcion'],
                        'fa_nombre'         => $row['fa_nombre'],
                        'ps_cantidad'       =>  round($stock['cantidad'], 2),
                        'pro_costo'         => ($ver_precio_compra) ? Moneda::moneda($row['pro_costo'], $this->div_master['div_locale'], $this->div_master['div_simbolo']) : '<span class="text-danger fa fa-ban"></span>',
                        'pro_precio'        => ($factCompra == 1) ?  Moneda::moneda($comp, $this->div_master['div_locale'], $this->div_master['div_simbolo']) : Moneda::moneda($row['pro_precio'], $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'pro_publico'       => $row['pro_publico'],
                        'pro_peso'        => $row['pro_peso'],
                        'envio'             => $envio_venta,
                        'tarifas'           => $list_tarifas
                    ];
                }
            }

            echo json_encode([
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordwithFilter,
                "aaData" => $array_productos
            ]);
        }
    }

    public function obtenerProductosTodosServicios()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $draw = $_POST['draw'];
            $row = $_POST['start'];
            $rowperpage = $_POST['length']; // Rows display per page
            $columnIndex = $_POST['order'][0]['column']; // Column index
            $columnName = $_POST['columns'][$columnIndex]['data']; // Column name
            $columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
            $searchValue = $_POST['search']['value'];

            $array_productos_serv = [];

            $totalRecordwithFilter = "";
            ## Search 
            $searchQuery = " ";
            if ($searchValue != '') {
                $palabras = explode(' ', $searchValue);

                if (count($palabras) > 1) {
                    $searchQuery .= "AND (";

                    foreach ($palabras as $i => $pal) {
                        if ($i == 0) {
                            $searchQuery .= "(pro.pro_id LIKE '%" . $pal . "%' OR 
                            pro.pro_codigo LIKE '%" . $pal . "%' OR pro.pro_descripcion LIKE '%" . $pal . "%' OR pro.pro_precio LIKE '%" . $pal . "%')";
                        } else {
                            $searchQuery .= " AND (pro.pro_id LIKE '%" . $pal . "%' OR 
                            pro.pro_codigo LIKE '%" . $pal . "%' OR pro.pro_descripcion LIKE '%" . $pal . "%' OR pro.pro_precio LIKE '%" . $pal . "%')";
                        }
                    }

                    $searchQuery .= ")";
                } else {
                    $searchQuery .= "AND (pro.pro_id LIKE '%" . $searchValue . "%' OR 
                    pro.pro_codigo LIKE '%" . $searchValue . "%' OR pro.pro_descripcion LIKE '%" . $searchValue . "%' OR pro.pro_precio LIKE '%" . $searchValue . "%')  ";
                }
            }

            $servicio = 'pro.pro_tipo = 3 ';
            $productos_servic =  $this->productos->obtenerProductosServiciost($servicio);
            $totalRecords = count($productos_servic);

            $searc =  $this->productos->obtenerProductosServiciost($servicio . $searchQuery);

            $totalRecordwithFilter = count($searc);

            ## Fetch records
            if ($rowperpage > 0) {
                $productos_servicios =  $this->productos->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, fa.fa_nombre, pro.pro_costo, pro.pro_precio, pro.pro_publico, sum(ps.ps_cantidad) as cantidad 
            FROM app_productos pro 
            LEFT JOIN app_fabricantes fa ON fa.fa_id=pro.pro_fabid
            LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
            LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
            WHERE $servicio $searchQuery GROUP BY " . $columnName . " ORDER BY pro.pro_id " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();
            } else {
                $productos_servicios =  $this->productos->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, fa.fa_nombre, pro.pro_costo, pro.pro_precio, pro.pro_publico, sum(ps.ps_cantidad) as cantidad 
                FROM app_productos pro 
                LEFT JOIN app_fabricantes fa ON fa.fa_id=pro.pro_fabid
                LEFT JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
                LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
                WHERE $servicio $searchQuery GROUP BY " . $columnName . " ORDER BY pro.pro_id " . $columnSortOrder . " ")->all();
            }
            if (is_countable($productos_servicios) && count($productos_servicios)) {
                foreach ($productos_servicios as $row) {
                    $array_productos_serv[] = [
                        'pro_id'            => $row['pro_id'],
                        'pro_codigo'        => $row['pro_codigo'],
                        'pro_descripcion'   => $row['pro_descripcion'],
                        'pro_precio'        => Moneda::moneda($row['pro_precio'], $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                    ];
                }
            }

            echo json_encode([
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordwithFilter,
                "aaData" => $array_productos_serv
            ]);
        }
    }

    public function obtenerProductosStockBajo()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $draw = $_POST['draw'];
            $row = $_POST['start'];
            $rowperpage = $_POST['length']; // Rows display per page
            $columnIndex = $_POST['order'][0]['column']; // Column index
            $columnName = $_POST['columns'][$columnIndex]['data']; // Column name
            $columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
            $searchValue = $_POST['search']['value'];
            $id_proveedor = $this->solicitud->sanitize($_POST['proveedor'], FILTER_SANITIZE_NUMBER_INT);

            $totalRecordwithFilter = "";
            ## Search 
            $searchQuery = " ";

            if ($searchValue != '') {
                $palabras = explode(' ', $searchValue);

                if (count($palabras) > 1) {
                    $searchQuery .= "AND (";

                    foreach ($palabras as $i => $pal) {
                        if ($i == 0) {
                            $searchQuery .= "(pro.pro_id LIKE '%" . $pal . "%' OR 
                            pro.pro_codigo LIKE '%" . $pal . "%' OR pro.pro_descripcion LIKE '%" . $pal . "%' OR pro.pro_precio LIKE '%" . $pal . "%' OR pro.pro_costo LIKE '%" . $pal . "%' OR fa.fa_nombre LIKE '%" . $pal . "%' OR ps.ps_disponible LIKE '%" . $pal . "%' OR ps.ps_stockmax LIKE '%" . $pal . "%' OR ps.ps_stockmin LIKE '%" . $pal . "%' OR ps.ps_cantidad LIKE '%" . $pal . "%' OR a.alm_nombre LIKE '%" . $pal . "%')";
                        } else {
                            $searchQuery .= " AND (pro.pro_id LIKE '%" . $pal . "%' OR 
                            pro.pro_codigo LIKE '%" . $pal . "%' OR pro.pro_descripcion LIKE '%" . $pal . "%' OR pro.pro_precio LIKE '%" . $pal . "%' OR pro.pro_costo LIKE '%" . $pal . "%' OR fa.fa_nombre LIKE '%" . $pal . "%' OR ps.ps_disponible LIKE '%" . $pal . "%' OR ps.ps_stockmax LIKE '%" . $pal . "%' OR ps.ps_stockmin LIKE '%" . $pal . "%' OR ps.ps_cantidad LIKE '%" . $pal . "%' OR a.alm_nombre LIKE '%" . $pal . "%')";
                        }
                    }

                    $searchQuery .= ")";
                } else {
                    $searchQuery .= "AND (pro.pro_id LIKE '%" . $searchValue . "%' OR 
                    pro.pro_codigo LIKE '%" . $searchValue . "%' OR pro.pro_descripcion LIKE '%" . $searchValue . "%' OR pro.pro_precio LIKE '%" . $searchValue . "%' OR pro.pro_costo LIKE '%" . $searchValue . "%' OR fa.fa_nombre LIKE '%" . $searchValue . "%' OR ps.ps_disponible LIKE '%" . $searchValue . "%' OR ps.ps_stockmax LIKE '%" . $searchValue . "%' OR ps.ps_stockmin LIKE '%" . $searchValue . "%' OR ps.ps_cantidad LIKE '%" . $searchValue . "%' OR a.alm_nombre LIKE '%" . $searchValue . "%') ";
                }
            }

            if ($id_proveedor == 0) {
                $servicio = 'ps.ps_stockmin > ps.ps_cantidad ';
                $productos_simple =  $this->productos->obtenerProductosStockBajot($servicio);
                $totalRecords = count($productos_simple);

                $searc =  $this->productos->obtenerProductosStockBajot($servicio . $searchQuery);

                $totalRecordwithFilter = count($searc);

                ## Fetch records
                if ($rowperpage > 0) {
                    $productos_servicios =  $this->productos->consultar("SELECT * FROM app_productos pro 
                LEFT JOIN app_productos_stocks ps ON ps.ps_proid = pro.pro_id 
                LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
                LEFT JOIN app_fabricantes fa ON fa.fa_id = pro.pro_fabid 
                WHERE ps.ps_stockmin > ps.ps_cantidad " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();
                } else {
                    $productos_servicios =  $this->productos->consultar("SELECT * FROM app_productos pro 
                    LEFT JOIN app_productos_stocks ps ON ps.ps_proid = pro.pro_id 
                    LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
                    LEFT JOIN app_fabricantes fa ON fa.fa_id = pro.pro_fabid 
                    WHERE ps.ps_stockmin > ps.ps_cantidad " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " ")->all();
                }
            } else {

                $servicio = 'ps.ps_stockmin > ps.ps_cantidad ';
                $productos_simple =  $this->productos->obtenerProductosStockBajoProv($id_proveedor, $servicio);
                $totalRecords = count($productos_simple);

                $searc =  $this->productos->obtenerProductosStockBajoProv($id_proveedor, $servicio . $searchQuery);

                $totalRecordwithFilter = count($searc);

                ## Fetch records
                if ($rowperpage > 0) {
                    $productos_servicios =  $this->productos->consultar("SELECT * FROM app_productos pro 
                LEFT JOIN app_productos_stocks ps ON ps.ps_proid = pro.pro_id 
                LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
                LEFT JOIN app_fabricantes fa ON fa.fa_id = pro.pro_fabid 
                JOIN app_productos_proveedores pp ON pro.pro_id=pp.pp_proid AND pp.pp_provid=$id_proveedor 
                WHERE ps.ps_stockmin > ps.ps_cantidad " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();
                } else {
                    $productos_servicios =  $this->productos->consultar("SELECT * FROM app_productos pro 
                    LEFT JOIN app_productos_stocks ps ON ps.ps_proid = pro.pro_id 
                    LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
                    LEFT JOIN app_fabricantes fa ON fa.fa_id = pro.pro_fabid 
                    JOIN app_productos_proveedores pp ON pro.pro_id=pp.pp_proid AND pp.pp_provid=$id_proveedor 
                    WHERE ps.ps_stockmin > ps.ps_cantidad " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " ")->all();
                }
            }

            echo json_encode([
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordwithFilter,
                "aaData" => $productos_servicios
            ]);
        }
    }

    public function obtenerProductosStockD()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $draw = $_POST['draw'];
            $row = $_POST['start'];
            $rowperpage = $_POST['length']; // Rows display per page
            $columnIndex = $_POST['order'][0]['column']; // Column index
            $columnName = $_POST['columns'][$columnIndex]['data']; // Column name
            $columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
            $searchValue = $_POST['search']['value'];
            $id_proveedor = $this->solicitud->sanitize($_POST['proveedor'], FILTER_SANITIZE_NUMBER_INT);

            $totalRecordwithFilter = "";
            ## Search 
            $searchQuery = " ";
            if ($searchValue != '') {
                $palabras = explode(' ', $searchValue);

                if (count($palabras) > 1) {
                    $searchQuery .= "AND (";

                    foreach ($palabras as $i => $pal) {
                        if ($i == 0) {
                            $searchQuery .= "(pro.pro_id LIKE '%" . $pal . "%' OR 
                            pro.pro_codigo LIKE '%" . $pal . "%' OR pro.pro_descripcion LIKE '%" . $pal . "%' OR pro.pro_precio LIKE '%" . $pal . "%' OR pro.pro_costo LIKE '%" . $pal . "%' OR ps.ps_disponible LIKE '%" . $pal . "%' OR ps.ps_stockmax LIKE '%" . $pal . "%' OR ps.ps_stockmin LIKE '%" . $pal . "%' OR ps.ps_cantidad LIKE '%" . $pal . "%' OR a.alm_nombre LIKE '%" . $pal . "%')";
                        } else {
                            $searchQuery .= " AND (pro.pro_id LIKE '%" . $pal . "%' OR 
                            pro.pro_codigo LIKE '%" . $pal . "%' OR pro.pro_descripcion LIKE '%" . $pal . "%' OR pro.pro_precio LIKE '%" . $pal . "%' OR pro.pro_costo LIKE '%" . $pal . "%' OR ps.ps_disponible LIKE '%" . $pal . "%' OR ps.ps_stockmax LIKE '%" . $pal . "%' OR ps.ps_stockmin LIKE '%" . $pal . "%' OR ps.ps_cantidad LIKE '%" . $pal . "%' OR a.alm_nombre LIKE '%" . $pal . "%')";
                        }
                    }

                    $searchQuery .= ")";
                } else {
                    $searchQuery .= "AND (pro.pro_id LIKE '%" . $searchValue . "%' OR 
                    pro.pro_codigo LIKE '%" . $searchValue . "%' OR pro.pro_descripcion LIKE '%" . $searchValue . "%' OR pro.pro_precio LIKE '%" . $searchValue . "%' OR pro.pro_costo LIKE '%" . $searchValue . "%' OR ps.ps_disponible LIKE '%" . $searchValue . "%' OR ps.ps_stockmax LIKE '%" . $searchValue . "%' OR ps.ps_stockmin LIKE '%" . $searchValue . "%' OR ps.ps_cantidad LIKE '%" . $searchValue . "%' OR a.alm_nombre LIKE '%" . $searchValue . "%') ";
                }
            }


            if ($id_proveedor == 0) {
                $servicio = 'a.alm_garantia=0 AND ps.ps_cantidad > 0 ';
                $productos_simple =  $this->productos->obtenerProductosStockD($servicio);
                $totalRecords = count($productos_simple);

                $searc =  $this->productos->obtenerProductosStockD($servicio . $searchQuery);

                $totalRecordwithFilter = count($searc);

                ## Fetch records
                if ($rowperpage > 0) {
                    $productos_servicios =  $this->productos->consultar("SELECT * FROM app_productos pro 
                LEFT JOIN app_productos_stocks ps ON ps.ps_proid = pro.pro_id 
                LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
                LEFT JOIN app_fabricantes fa ON fa.fa_id = pro.pro_fabid 
                WHERE a.alm_garantia=0 AND ps.ps_cantidad > 0 " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();
                } else {
                    $productos_servicios =  $this->productos->consultar("SELECT * FROM app_productos pro 
                LEFT JOIN app_productos_stocks ps ON ps.ps_proid = pro.pro_id 
                LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
                LEFT JOIN app_fabricantes fa ON fa.fa_id = pro.pro_fabid 
                WHERE a.alm_garantia=0 AND ps.ps_cantidad > 0 " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " ")->all();
                }
            } else {

                $servicio = 'a.alm_garantia=0 AND ps.ps_cantidad > 0 ';
                $productos_simple =  $this->productos->obtenerProductosStockDProv($id_proveedor, $servicio);
                $totalRecords = count($productos_simple);

                $searc =  $this->productos->obtenerProductosStockDProv($id_proveedor, $servicio . $searchQuery);

                $totalRecordwithFilter = count($searc);

                ## Fetch records
                if ($rowperpage > 0) {
                    $productos_servicios =  $this->productos->consultar("SELECT * FROM app_productos pro 
                LEFT JOIN app_productos_stocks ps ON ps.ps_proid = pro.pro_id 
                LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
                LEFT JOIN app_fabricantes fa ON fa.fa_id = pro.pro_fabid 
                JOIN app_productos_proveedores pp ON pro.pro_id=pp.pp_proid AND pp.pp_provid=$id_proveedor 
                WHERE a.alm_garantia=0 AND ps.ps_cantidad > 0 " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();
                } else {
                    $productos_servicios =  $this->productos->consultar("SELECT * FROM app_productos pro 
                LEFT JOIN app_productos_stocks ps ON ps.ps_proid = pro.pro_id 
                LEFT JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
                LEFT JOIN app_fabricantes fa ON fa.fa_id = pro.pro_fabid 
                JOIN app_productos_proveedores pp ON pro.pro_id=pp.pp_proid AND pp.pp_provid=$id_proveedor 
                WHERE a.alm_garantia=0 AND ps.ps_cantidad > 0 " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " ")->all();
                }
            }

            echo json_encode([
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordwithFilter,
                "aaData" => $productos_servicios
            ]);
        }
    }

    public function obtenerProductosVencido()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $draw = $_POST['draw'];
            $row = $_POST['start'];
            $rowperpage = $_POST['length']; // Rows display per page
            $columnIndex = $_POST['order'][0]['column']; // Column index
            $columnName = $_POST['columns'][$columnIndex]['data']; // Column name
            $columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
            $searchValue = $_POST['search']['value'];
            $id_proveedor = $this->solicitud->sanitize($_POST['proveedor'], FILTER_SANITIZE_NUMBER_INT);

            $totalRecordwithFilter = "";
            ## Search 
            $searchQuery = " ";
            if ($searchValue != '') {
                $palabras = explode(' ', $searchValue);

                if (count($palabras) > 1) {
                    $searchQuery .= "AND (";

                    foreach ($palabras as $i => $pal) {
                        if ($i == 0) {
                            $searchQuery .= "(pro.pro_id LIKE '%" . $pal . "%' OR pro.pro_expedicion LIKE '%" . $pal . "%' OR pro.pro_vencimiento LIKE '%" . $pal . "%' OR ps.ps_cantidad LIKE '%" . $pal . "%' OR a.alm_nombre LIKE '%" . $pal . "%' OR 
                            pro.pro_codigo LIKE '%" . $pal . "%' OR pro.pro_descripcion LIKE '%" . $pal . "%' OR pro.pro_precio LIKE '%" . $pal . "%' OR pro.pro_costo LIKE '%" . $pal . "%') ";
                        } else {
                            $searchQuery .= " AND (pro.pro_id LIKE '%" . $pal . "%' OR pro.pro_expedicion LIKE '%" . $pal . "%' OR pro.pro_vencimiento LIKE '%" . $pal . "%' OR ps.ps_cantidad LIKE '%" . $pal . "%' OR a.alm_nombre LIKE '%" . $pal . "%' OR 
                            pro.pro_codigo LIKE '%" . $pal . "%' OR pro.pro_descripcion LIKE '%" . $pal . "%' OR pro.pro_precio LIKE '%" . $pal . "%' OR pro.pro_costo LIKE '%" . $pal . "%')";
                        }
                    }

                    $searchQuery .= ")";
                } else {
                    $searchQuery .= "AND (pro.pro_id LIKE '%" . $searchValue . "%' OR pro.pro_expedicion LIKE '%" . $searchValue . "%' OR pro.pro_vencimiento LIKE '%" . $searchValue . "%' OR ps.ps_cantidad LIKE '%" . $searchValue . "%' OR a.alm_nombre LIKE '%" . $searchValue . "%' OR 
                    pro.pro_codigo LIKE '%" . $searchValue . "%' OR pro.pro_descripcion LIKE '%" . $searchValue . "%' OR pro.pro_precio LIKE '%" . $searchValue . "%' OR pro.pro_costo LIKE '%" . $searchValue . "%') ";
                }
            }

            if ($id_proveedor == 0) {
                $servicio = 'DATE(CURRENT_DATE()) > DATE(pro_vencimiento) ';

                $productos_simple =  $this->productos->obtenerProductosVencidost($servicio);
                $totalRecords = count($productos_simple);

                $searc =  $this->productos->obtenerProductosVencidost($servicio . $searchQuery);

                $totalRecordwithFilter = count($searc);

                ## Fetch records
                if ($rowperpage > 0) {
                    $productos_servicios =  $this->productos->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, ps.ps_cantidad, DATE_FORMAT(pro.pro_expedicion, '%d-%m-%Y') expedicion, DATE_FORMAT(pro.pro_vencimiento, '%d-%m-%Y') vencimiento, a.alm_nombre 
                FROM app_productos pro
                JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
                JOIN app_almacenes a ON a.alm_id = ps.ps_almid
                WHERE $servicio $searchQuery ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();
                } else {
                    $productos_servicios =  $this->productos->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, ps.ps_cantidad, DATE_FORMAT(pro.pro_expedicion, '%d-%m-%Y') expedicion, DATE_FORMAT(pro.pro_vencimiento, '%d-%m-%Y') vencimiento, a.alm_nombre 
                    FROM app_productos pro
                    JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
                    JOIN app_almacenes a ON a.alm_id = ps.ps_almid
                    WHERE $servicio $searchQuery ORDER BY " . $columnName . " " . $columnSortOrder . " ")->all();
                }
            } else {
                $servicio = "DATE(CURRENT_DATE()) > DATE(pro_vencimiento) ";

                $productos_simple =  $this->productos->obtenerProductosVencidosProv($id_proveedor, $servicio);
                $totalRecords = count($productos_simple);

                $searc =  $this->productos->obtenerProductosVencidosProv($id_proveedor, $servicio . $searchQuery);

                $totalRecordwithFilter = count($searc);

                ## Fetch records
                if ($rowperpage > 0) {
                    $productos_servicios =  $this->productos->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, ps.ps_cantidad, DATE_FORMAT(pro.pro_expedicion, '%d-%m-%Y') expedicion, DATE_FORMAT(pro.pro_vencimiento, '%d-%m-%Y') vencimiento, a.alm_nombre 
                FROM app_productos pro
                JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
                JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
                JOIN app_productos_proveedores pp ON pro.pro_id=pp.pp_proid AND pp.pp_provid=$id_proveedor  
                WHERE $servicio $searchQuery ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();
                } else {
                    $productos_servicios =  $this->productos->consultar("SELECT pro.pro_id, pro.pro_codigo, pro.pro_descripcion, ps.ps_cantidad, DATE_FORMAT(pro.pro_expedicion, '%d-%m-%Y') expedicion, DATE_FORMAT(pro.pro_vencimiento, '%d-%m-%Y') vencimiento, a.alm_nombre 
                FROM app_productos pro
                JOIN app_productos_stocks ps ON ps.ps_proid=pro_id
                JOIN app_almacenes a ON a.alm_id = ps.ps_almid 
                JOIN app_productos_proveedores pp ON pro.pro_id=pp.pp_proid AND pp.pp_provid=$id_proveedor  
                WHERE $servicio $searchQuery ORDER BY " . $columnName . " " . $columnSortOrder . " ")->all();
                }
            }

            echo json_encode([
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordwithFilter,
                "aaData" => $productos_servicios
            ]);
        }
    }

    public function obtenerProductosTransferencia()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $draw = $_POST['draw'];
            $row = $_POST['start'];
            $rowperpage = $_POST['length']; // Rows display per page
            $columnIndex = $_POST['order'][0]['column']; // Column index
            $columnName = $_POST['columns'][$columnIndex]['data']; // Column name
            $columnSortOrder = $_POST['order'][0]['dir']; // asc or desc
            $searchValue = $_POST['search']['value'];

            $totalRecordwithFilter = "";
            ## Search 
            $searchQuery = " ";

            if ($searchValue != '') {
                $palabras = explode(' ', $searchValue);

                if (count($palabras) > 1) {
                    $searchQuery .= "AND (";

                    foreach ($palabras as $i => $pal) {
                        if ($i == 0) {
                            $searchQuery .= "(alm.alm_nombre LIKE '%" . $pal . "%' OR 
                            alm2.alm_nombre LIKE '%" . $pal . "%' OR ptr.ptr_id LIKE '%" . $pal . "%' OR ptr.ptr_estatus LIKE '%" . $pal . "%')";
                        } else {
                            $searchQuery .= " AND (pro.pro_id LIKE '%" . $pal . "%' OR 
                            pro.pro_codigo LIKE '%" . $pal . "%' OR pro.pro_descripcion LIKE '%" . $pal . "%' OR pro.pro_precio LIKE '%" . $pal . "%' OR pro.pro_costo LIKE '%" . $pal . "%' OR ps.ps_disponible LIKE '%" . $pal . "%' OR ps.ps_stockmax LIKE '%" . $pal . "%' OR ps.ps_stockmin LIKE '%" . $pal . "%' OR ps.ps_cantidad LIKE '%" . $pal . "%' OR a.alm_nombre LIKE '%" . $pal . "%')";
                        }
                    }

                    $searchQuery .= ")";
                } else {
                    $searchQuery .= "AND (alm.alm_nombre LIKE '%" . $searchValue . "%' OR 
                    alm2.alm_nombre LIKE '%" . $searchValue . "%' OR ptr.ptr_id LIKE '%" . $searchValue . "%' OR ptr.ptr_estatus LIKE '%" . $searchValue . "%') ";
                }
            }

            $transferencia = '(ptr_estatus=1 OR ptr_estatus=2 OR ptr_estatus=3) ';
            $productos_simple = $this->transferencia->obtenerListaTransferenciast($transferencia);
            $totalRecords = count($productos_simple);

            $searc = $this->transferencia->obtenerListaTransferenciast($transferencia . $searchQuery);

            $totalRecordwithFilter = count($searc);

            ## Fetch records
            if ($rowperpage > 0) {
                $productos_transferencia = $this->transferencia->consultar("SELECT ptr.ptr_id,alm2.alm_nombre as origen, alm.alm_nombre as destino, ptr_estatus
                FROM app_productos_transferencia ptr
                INNER JOIN app_almacenes alm ON alm.alm_id=ptr.ptr_almdestid
                INNER JOIN app_almacenes alm2 ON alm2.alm_id=ptr.ptr_almorigid
                WHERE (ptr_estatus=1 OR ptr_estatus=2 OR ptr_estatus=3) " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " LIMIT " . $row . "," . $rowperpage)->all();
            } else {
                $productos_transferencia = $this->transferencia->consultar("SELECT ptr.ptr_id,alm2.alm_nombre as origen, alm.alm_nombre as destino, ptr_estatus
                FROM app_productos_transferencia ptr
                INNER JOIN app_almacenes alm ON alm.alm_id=ptr.ptr_almdestid
                INNER JOIN app_almacenes alm2 ON alm2.alm_id=ptr.ptr_almorigid
                WHERE (ptr_estatus=1 OR ptr_estatus=2 OR ptr_estatus=3) " . $searchQuery . " ORDER BY " . $columnName . " " . $columnSortOrder . " ")->all();
            }
            echo json_encode([
                "draw" => intval($draw),
                "iTotalRecords" => $totalRecords,
                "iTotalDisplayRecords" => $totalRecordwithFilter,
                "aaData" => $productos_transferencia
            ]);
        }
    }

    public function obtenerProductosprecio($id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $categoria  =   filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            $product = new ProductoCategoria();

            $ver_precio_compra = $this->module->has_module_action_permission('productos', 'ver_precio_compra', $_SESSION['user_data']['emp_id']);

            $array_productos = [];
            $array_productos_serv = [];

            $tarifas = $this->productos->obtenerTarifasVisibles();
            $productos = $product->obtenerProductosSinServiciocateg($categoria);

            $empresa = $this->productos->consultar("SELECT * FROM app_empresas")->row();
            $factCompra = $empresa['emp_iva'];
            if (is_countable($productos) && count($productos)) {

                foreach ($productos as $row) {

                    $list_tarifas = [];

                    $impuesto = $this->productos->obtenerproImp($row['pro_id']);
                    //$iva_m = ($row['pro_precio'] * ($impuesto['imp_valor'] / 100));

                    foreach ($tarifas as $tarifa) {
                        $tarifa_data = $this->productos->obtenerTarifa($tarifa['tar_id']);
                        if ('pvp' == $tarifa_data['tar_aplicar'] || 'pvpiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($row['pro_precio'] * ($impuesto['imp_valor'] / 100));
                        }
                        if ('costo' == $tarifa_data['tar_aplicar'] || 'costoiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($row['pro_costo'] * ($impuesto['imp_valor'] / 100));
                        }
                        $precio_total = TarifasControlador::aplicar($row['pro_costo'], $row['pro_precio'], $tarifa_data['tar_aplicar'], $tarifa_data['tar_valorx'], $tarifa_data['tar_valory'], $iva_m);
                        $list_tarifas[] = [
                            'precio' => Moneda::moneda($precio_total, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        ];
                    }

                    $factor_master = 0;
                    $data_factor = Moneda::obtenerFactor(2, 1);
                    if ($data_factor) {
                        $factor_master = $data_factor['df_factor'];
                    }

                    $precBs = $row['pro_precio'] * $factor_master;
                    $string = float_a_string($precBs);
                    $numero = number_format($string, 2);
                    $numero = str_replace('.', '', $numero);
                    $numero = str_replace(',', '', $numero);
                    $precBsd = $numero . '0000';

                    $stock = $this->productos->obtenerProductosSinServicioStock($row['pro_id']);

                    $array_productos[] = [
                        'pro_id'            => $row['pro_id'],
                        'pro_codigo'        => $row['pro_codigo'],
                        'pro_descripcion'   => $row['pro_descripcion'],
                        'pro_costo'         => ($ver_precio_compra) ? Moneda::moneda($row['pro_costo'], $this->div_master['div_locale'], $this->div_master['div_simbolo']) : '<span class="text-danger fa fa-ban"></span>',
                        'pro_precio'        => Moneda::moneda($row['pro_precio'], $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'pro_precbsd'       => Moneda::moneda($precBs, 'de-DE', 'Bs.D'),
                        'pro_precbss'       => Moneda::moneda($precBsd, 'de-DE', 'Bs.S'),
                    ];
                }
            }

            Http::json_response([
                'productos' => $array_productos,
            ]);
        }
    }

    public function buscarProductos()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax() && !empty($_GET['buscar'])) {
            $buscar = $this->solicitud->sanitize($_GET['buscar']);
            $buscar = strtolower($buscar);
            Http::json_response($this->productos->obtenerProductosSimplesBuscar($buscar));
        }
    }

    public function obtenerSucursalesEmpleado()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $empleado_sucursales = new EmpleadoSucursales();
            $suc = $empleado_sucursales->obtenerSucursales($_SESSION['user_data']['emp_id']);

            $ID = '';
            foreach ($suc as $row) {
                if ($row['sucursal_predeterminado'] == 1) {
                    $ID = $row['sucursal_id'];
                }
            }

            Http::json_response([
                'sucursales' => $suc,
                'id' => ($_SESSION['sucursal']['id'] != 0) ? $_SESSION['sucursal']['id'] : $ID,
                'desactivar' => ($_SESSION['sucursal']['id'] != 0) ? true : false
            ]);
        }
    }

    public function obtenerSeriesAlmacenesEmpleado(int $sucursales)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $sucursales = filter_var($sucursales, FILTER_SANITIZE_NUMBER_INT);

            $almacenes = $this->productos->obtenerAlmacenesEmpleadoSucursales($sucursales);

            $idalm = '';
            $alm_nombre = '';
            foreach ($almacenes as $row) {
                if ($row['empalm_predeterminado'] == 1) {
                    $idalm = $row['empalm_almid'];
                    $alm_nombre = $row['alm_nombre'];
                }
            }

            if ($idalm == "" && count($almacenes) > 0) {
                $idalm = $almacenes[0]['empalm_almid'];
                $alm_nombre = $almacenes[0]['alm_nombre'];
            }

            Http::json_response([
                'almacenes' => $almacenes,
                'id_alm' => $idalm,
                'alm_nombre' => $alm_nombre
            ]);
        }
    }

    public function obtenerStopAlmacen()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $array_productos = [];
            $id_almacen      = filter_input(INPUT_GET, 'almacen');
            $stock      =  ($_GET['stock'] == 0) ? false : true;

            if ($stock == false) {
                $productos = $this->productos->obtenerProductosStockAlmacenm($id_almacen);
            } else {
                $productos = $this->productos->obtenerProductosStockBajom($id_almacen);
            }

            $ver_precio_compra = $this->module->has_module_action_permission('productos', 'ver_precio_compra', $_SESSION['user_data']['emp_id']);

            if (is_countable($productos) &&  count($productos)) {

                foreach ($productos as $row) {

                    $array_productos[] = [
                        'id'            => $row['pro_id'],
                        'descripcion'   => $row['pro_descripcion'],
                        'costo'         => ($ver_precio_compra) ? Moneda::moneda($row['pro_costo'], $this->div_master['div_locale'], $this->div_master['div_simbolo']) : '<span class="text-danger fa fa-ban"></span>',
                        'precio'        => Moneda::moneda($row['pro_precio'], $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        'disponible'    => $row['ps_cantidad'],
                        'reservada'     => $row['ps_reservada'],
                        'max'           => $row['ps_stockmax'],
                        'min'           => $row['ps_stockmin'],
                        'almacen'       => $row['alm_nombre'],
                    ];
                }
            }

            Http::json_response([
                'productos'     => $array_productos,
            ]);
        }
    }

    public function actualizarPrecioProdSelecciondo()
    {

        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $procentaje  = filter_input(INPUT_POST, 'porcentaje', FILTER_SANITIZE_NUMBER_INT);
            $precio  = filter_input(INPUT_POST, 'precio', FILTER_SANITIZE_NUMBER_INT);

            if (empty($procentaje))
                $this->array_errors[] = 'El campo porcentaje el obligatorio.';
            if (empty($precio))
                $this->array_errors[] = 'El campo precio el obligatorio.';

            $productos = json_decode($_POST['productos'], true);

            if (is_countable($productos) && count($productos)) {

                foreach ($productos as $id_producto) {
                    $producto = $this->productos->obtener($id_producto);
                    $preciov = $producto['pro_precio'];
                    $costo = $producto['pro_costo'];

                    if ($precio == 1) {
                        $preciov = $costo + ($costo * ($procentaje / 100));
                    }
                    if ($precio == 2) {
                        $preciov = $producto['pro_precio'] + ($producto['pro_precio'] * ($procentaje / 100));
                    }

                    if ($this->productos->editar($id_producto, [
                        'pro_precio'  => $preciov,
                    ])) {
                        if (defined('WCURL')  && defined('WCKEY') && defined('WCSECRECT') && defined('WCIMG')) {
                            //$this->subirAWoocommerce($id_producto);
                        }
                    }
                }

                if (empty($this->array_errors)) {
                    Http::json_response(true);
                }
            } else {
                Http::json_response(['errors' => ['Debe seleccionar los productos']]);
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerProductoCategoria()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $array_productos = [];
            $categoria      = filter_input(INPUT_GET, 'categoria');

            $producto = new ProductoCategoria();

            $productos = $producto->obtenerProductosCategoriaC($categoria);

            $lista = [];
            $repidos = [];

            $ver_precio_compra = $this->module->has_module_action_permission('productos', 'ver_precio_compra', $_SESSION['user_data']['emp_id']);

            if (is_countable($productos) &&  count($productos)) {

                foreach ($productos as $row) {

                    if (!in_array($row['pro_id'], $repidos)) {
                        $lista[] = [
                            'id'            => $row['pro_id'],
                            'descripcion'   => $row['pro_descripcion'],
                            'costo'         => ($ver_precio_compra) ? Moneda::moneda($row['pro_costo'], $this->div_master['div_locale'], $this->div_master['div_simbolo']) : '<span class="text-danger fa fa-ban"></span>',
                            'precio'        => Moneda::moneda($row['pro_precio'], $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                            'codigo'        => $row['pro_codigo'],
                            'categoria'     => $row['cat_nombre'],
                            'checked'       => false
                        ];
                        $repidos[] = $row['pro_id'];
                    }
                }
            }

            Http::json_response([
                'productos'     => $lista,
            ]);
        }
    }

    public function obtenerProductosStock()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            Http::json_response($this->productos->obtenerProductosStock());
        }
    }

    public function index()
    {
        $newTarifa = new Tarifas();
        return Vista::view('productos/index', [
            'productos_vencidos'        => $this->module->has_module_action_permission('productos', 'vencido', $_SESSION['user_data']['emp_id']),
            'stock_bajo'                => $this->module->has_module_action_permission('productos', 'stock_bajo', $_SESSION['user_data']['emp_id']),
            'productos_sin_stock'       => $this->productos->obtenerProductosSinStock(),
            'productos_publicos'        => $this->productos->obtenerProductosPublicos(),
            'stock_almacen'             => $this->module->has_module_action_permission('productos', 'stock_almacen', $_SESSION['user_data']['emp_id']),
            'precio_lote'               => $this->module->has_module_action_permission('productos', 'precio_lote', $_SESSION['user_data']['emp_id']),
            'lista_precios'             => $this->module->has_module_action_permission('productos', 'lista_precios', $_SESSION['user_data']['emp_id']),
            'protransferencia'          => $this->module->has_module_action_permission('productos', 'transferencia', $_SESSION['user_data']['emp_id']),
            'productos_transferencia'   => $this->transferencia->obtenerListaTransferencias(),
            'tarifas'                   => $newTarifa->todos(),
            'tarifas_visible'           => $this->productos->obtenerTarifasVisibles(),
            'impresoras'                => $this->productos->consultar("SELECT * FROM app_impresoras WHERE imp_estatus = 1 AND imp_tipo = 2")->all(),
            'tarifas_productos'         => $this->module->has_module_action_permission('productos', 'tarifas', $_SESSION['user_data']['emp_id']),
        ]);
    }

    public function buscarFactores(string $fecha)
    {
        if (validateDate($fecha, 'Y-m-d')) {
            Http::json_response($this->productos->obtenerFactoresBitacora($fecha));
        } else {
            $this->array_errors[] = 'Acción prohibida';
        }
    }

    public function agregarFactor()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factor']) || empty($_POST['id_producto']))
                $this->array_errors[] = 'Acción prohibida';

            if (empty($this->array_errors)) {

                $id_factor = filter_var($_POST['id_factor'], FILTER_VALIDATE_INT);
                $id_producto = filter_var($_POST['id_producto'], FILTER_VALIDATE_INT);

                if ($id_factor && $id_producto) {

                    $newPro = new ProductoFactor();

                    $factor = $this->productos->obtenerBitacoraFactor($id_factor);

                    if ($factor) {
                        if ($newPro->consultar("SELECT profac_proid FROM app_producto_factor WHERE profac_proid = $id_producto")->row()) {
                            $elimino = $newPro->consultar("DELETE FROM app_producto_factor WHERE profac_proid = $id_producto")->run();
                            if ($elimino) {
                                Http::json_response($newPro->guardar([
                                    'profac_bifac_serial' => $factor['bitfac_relacion'],
                                    'profac_proid' => $id_producto
                                ]));
                            }
                        } else {
                            Http::json_response($newPro->guardar([
                                'profac_bifac_serial' => $factor['bitfac_relacion'],
                                'profac_proid' => $id_producto
                            ]));
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarFactorProducto(int $id_producto)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newPro = new ProductoFactor();
            Http::json_response($newPro->consultar("DELETE FROM app_producto_factor WHERE profac_proid = $id_producto")->run());
        }
    }

    public function obtenerFactorProducto(int $id_producto)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newPro = new ProductoFactor();
            Http::json_response($newPro->obtenerFactorProducto($id_producto));
        }
    }

    public function crear()
    {
        if ($this->module->has_module_action_permission('productos', 'crear', $_SESSION['user_data']['emp_id'])) {
            return Vista::view('productos/crear', [
                'fabricantes' => $this->fabricantes->obtenerFabricantes()
            ]);
        } else {
            Http::exit_by_forbiden();
        }
    }

    public function obtenerAlmacen(int $id_almacen)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id_almacen = filter_var($id_almacen, FILTER_SANITIZE_NUMBER_INT);
            Http::json_response($this->productos->obtenerAlamcen($id_almacen));
        }
    }

    public function relacionStock(int $id_producto)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $pro_id = filter_var($id_producto, FILTER_SANITIZE_NUMBER_INT);
            $cant = $this->productos->obtenerTotalStockProducto($pro_id);
            Http::json_response([
                'productos_stock' => $this->stock->obtenerProductosStock($pro_id),
                'almacenes' => $this->stock->obtenerAlmacenSinProductoEnStock($pro_id),
                'total_stock' =>  round($cant['total_stock'], 2)
            ]);
        }
    }

    public function productoTarifas()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $pro_id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);
            Http::json_response([
                'tarifas' => $this->productos->obtenerTarifasSinRelacionConProducto($pro_id),
                'tarifas_productos' => $this->tarifas->obtenerTarifasProductos($pro_id)
            ]);
        }
    }

    public function editar(int $pro_id)
    {
        if ($this->module->has_module_action_permission('productos', 'editar', $_SESSION['user_data']['emp_id'])) {

            if (!$this->productos->existe('pro_id', $pro_id)) {
                Http::notFound();
            }
            $opeditar_inventario = $this->module->has_module_action_permission('productos', 'editar_inventario', $_SESSION['user_data']['emp_id']);
            $editar_precio = $this->module->has_module_action_permission('productos', 'editar_precio', $_SESSION['user_data']['emp_id']);
            $cargar_stock = $this->module->has_module_action_permission('productos', 'cargar_inventario', $_SESSION['user_data']['emp_id']);

            $bitacora = $this->productos->consultar("SELECT bit_fecha fecha, b.bit_descripcion descripcion, b.bit_modulo modulo, CONCAT(i.einfo_nombres, ' ', i.einfo_apellidos) empleado
            FROM app_bitacora_productos b 
            JOIN app_productos p ON b.bit_proid = p.pro_id
            JOIN app_empleados_info i ON i.einfo_id = b.bit_empid
            WHERE bit_proid = $pro_id
            ORDER BY bit_fecha DESC")->all();

            $newImp = new Impuesto();

            return Vista::view('productos/editar', [
                'editar_precio'         => $editar_precio,
                'cargar_stock'          => $cargar_stock,
                'producto'              => $this->productos->obtenerProductoPorId($pro_id),
                'fabricantes'           => $this->fabricantes->obtenerFabricantes(),
                'impuestos'             => $newImp->where(['imp_retencion' => 0]),
                //'producto_variantes'    => $this->productos->obtenerProductoVariantes($pro_id),
                'bitacora'              => $bitacora,
                'impresoras'                => $this->productos->consultar("SELECT * FROM app_impresoras WHERE imp_estatus = 1 AND imp_tipo = 2")->all(),
                'opeditar_inventario'   => $opeditar_inventario
            ]);
        } else {
            Http::exit_by_forbiden();
        }
    }

    public function obtenerBitacoraStock(int $pro_id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newBitacoraStock = new BitacoraStock();
            $bitacora_stock = $newBitacoraStock->obtenerBitacoraStockProducto($pro_id);
            $list_bs = [];
            foreach ($bitacora_stock as $row) {
                $documento = '';
                $ruta = '';
                $id = '';
                if ($row['documento'] == '1') {
                    $id = $newBitacoraStock->obtenerNe($row['factura'], $row['almacen'],$pro_id);
                    $documento = Documento::obtener(1);
                    $documento = $documento['prefijo'];
                    $ruta = 'notasdeentregaeditar/';
                } elseif ($row['documento'] == '2') {
                    $id = $newBitacoraStock->obtenerFa($row['factura'], $row['almacen'],$pro_id);
                    $documento = Documento::obtener(2);
                    $documento = $documento['prefijo'];
                    $ruta = 'poseditar/';
                } elseif ($row['documento'] == '8') {
                    $id = $newBitacoraStock->obtenerCmpFac($row['factura']);
                    $row['factura'] = $id['correlativo'];
                    $documento = Documento::obtener(8);
                    $documento = $documento['prefijo'];
                    $ruta = 'cmpfacturaeditar/';
                } elseif ($row['documento'] == '9') {
                    $id = $newBitacoraStock->obtenerCmpNota($row['factura']);
                    $row['factura'] = $id['correlativo'];
                    $documento = Documento::obtener(9);
                    $documento = $documento['prefijo'];
                    $ruta = 'cmpnotaseditar/';
                } elseif ($row['documento'] == '12') {
                    $id = $newBitacoraStock->obtenerOrden($row['factura'], $row['almacen'],$pro_id);
                    $documento = Documento::obtener(12);
                    $documento = $documento['prefijo'];
                    $ruta = 'ordendeentregaeditar/';
                } elseif ($row['documento'] == NULL) {
                    $id = '';
                    $documento = '';
                    $ruta = '';
                }

                if ($id) {
                    if($id['id']>0){
                        $ruta = ruta_base() . $ruta . 'verFactura/' . $id['id'];
                    }else{
                         $ruta = '';
                    }
                } else {
                    $ruta = '';
                }

                $list_bs[] = [
                    'ruta' => $ruta,
                    'documento' => $documento,
                    'fecha' => $row['fecha'],
                    'empleado' => $row['empleado'],
                    'modulo' => $row['modulo'],
                    'almacen' => $row['almacen'],
                    'habia' => round($row['habia'], 3),
                    'sube' => round($row['sube'], 3),
                    'baja' => round($row['baja'], 3),
                    'total' => round($row['total'], 3),
                    'factura' => $row['factura'],
                ];
            }
            Http::json_response([
                'bitacora_stock' => $list_bs
            ]);
        }
    }

    public function obtenerImagenes(int $id_producto)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $pro_id = filter_var($id_producto, FILTER_SANITIZE_NUMBER_INT);
            $pro_imagen = new ProductosImagen();
            Http::json_response([
                'productos_imagenes' => $pro_imagen->where(['pi_proid' => $pro_id])
            ]);
        }
    }

    public function obtenerDatosCrudForaneos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newCat = new Categorias();
            $newProv = new Proveedor();
            $newFab = new Fabricantes();

            $categorias = $newCat->obtenerCategorias();
            $array_categoria = [];

            foreach ($categorias as $row) {

                $subcategorias = [];
                $sub = $newCat->obtenerSubategorias($row['cat_id']);

                foreach ($sub as $row1) {
                    $subcategorias[] = [
                        'id' => $row1['cat_id'],
                        'label' => $row1['cat_nombre'],
                    ];
                }

                $array_categoria[] = [
                    'id' => $row['cat_id'],
                    'label' => $row['cat_nombre'],
                    'children' => $subcategorias
                ];
            }

            Http::json_response([
                'categorias' => $array_categoria,
                'proveedores' => $newProv->proveedoresActivos(),
                'fabricantes' => $newFab->obtenerFabricantes(),
                'productos'   => $this->productos->obtenerProductosSimples()
            ]);
        }
    }

    public function obtenerProductosSimples()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            Http::json_response($this->productos->obtenerProductosSimples());
        }
    }

    public function obtenerCategorias()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newCat = new Categorias();
            $categorias = $newCat->obtenerCategorias();
            $array_categoria = [];

            foreach ($categorias as $row) {
                $subcategorias = [];
                $sub = $newCat->obtenerSubategorias($row['cat_id']);

                foreach ($sub as $row1) {
                    $subcategorias[] = [
                        'id' => $row1['cat_id'],
                        'label' => $row1['cat_nombre'],
                    ];
                }

                $array_categoria[] = [
                    'id' => $row['cat_id'],
                    'label' => $row['cat_nombre'],
                    'children' => $subcategorias
                ];
            }

            Http::json_response($array_categoria);
        }
    }

    public function proveedoresActivos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newProv = new Proveedor();
            Http::json_response($newProv->proveedoresActivos());
        }
    }

    public function productosCompuestos(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $pro_id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            $productoCompuesto = new ProductosCompuestos();

            $array_producto = [];
            $productos = $productoCompuesto->obtenerProductosCompuesto($pro_id);

            foreach ($productos as $row) {
                $array_producto[] = $row['pro_ccproid'];
            }

            Http::json_response($array_producto);
        }
    }

    public function fabricantesActivos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newFab = new Fabricantes();
            Http::json_response($newFab->obtenerFabricantes());
        }
    }

    public function obtenerProductoCategoriasProveedores(int $id_producto)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $pro_categoria = new ProductoCategoria();
            $pro_proveedor = new ProductoProveedor();

            $pro_id = filter_var($id_producto, FILTER_SANITIZE_NUMBER_INT);

            $array_categorias_productos = [];
            $array_proveedores_producto = [];
            $categoriasProductos =  $pro_categoria->where(['pc_proid' => $pro_id]);
            $proveedores_producto = $pro_proveedor->where(['pp_proid' => $pro_id]);

            $fabricante = $this->productos->consultar("SELECT fa_id FROM app_productos p JOIN app_fabricantes f ON f.fa_id = p.pro_fabid WHERE p.pro_id = $pro_id")->row();

            foreach ($categoriasProductos as $row) {
                $array_categorias_productos[] = $row['pc_catid'];
            }

            foreach ($proveedores_producto as $row) {
                $array_proveedores_producto[] = $row['pp_provid'];
            }

            Http::json_response([
                'categorias'    => $array_categorias_productos,
                'proveedores'   => $array_proveedores_producto,
                'fabricante'    => $fabricante
            ]);
        }
    }

    ///actualizarTarifa

    public function tarifasPro(int $id_producto)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $lista_tarifas = [];
            $tarifas = $this->productos->consultar("SELECT * FROM app_tarifas")->all();

            if (is_countable($tarifas) && count($tarifas)) {
                $producto = $this->productos->obtener($id_producto);

                if ($producto) {
                    foreach ($tarifas as $row) {
                        $tarifas_productos = $this->productos->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$id_producto} AND pt_tarid={$row['tar_id']}")->row();

                        $check = 0;
                        $precio = 0;

                        if ($tarifas_productos) {
                            $check = 1;
                            $precio = $tarifas_productos['pt_tarprecio'];
                        }

                        $impuesto = $this->productos->obtenerproImp($producto['pro_id']);
                        $iva_imp = ($producto['pro_precio'] * ($impuesto['imp_valor'] / 100));

                        if ('pvp' == $row['tar_aplicar']) {
                            $formula = "Precio Venta ({$producto['pro_precio']}) - x({$row['tar_valorx']})% - y({$row['tar_valory']})";
                        }
                        if ('pvpiva' == $row['tar_aplicar']) {
                            $formula = "Precio Venta + IVA ({$producto['pro_precio']}+{$iva_imp}) - x({$row['tar_valorx']})% - y({$row['tar_valory']})";
                        }
                        if ('costo' == $row['tar_aplicar']) {
                            $formula = "precio costo({$producto['pro_costo']}) + x({$row['tar_valorx']})%  + y({$row['tar_valory']})";
                        }
                        if ('costoiva' == $row['tar_aplicar']) {
                            $iva_imp = ($producto['pro_costo'] * ($impuesto['imp_valor'] / 100));
                            $formula = "precio costo({$producto['pro_costo']}+{$iva_imp}) + x({$row['tar_valorx']})%  + y({$row['tar_valory']})";
                        }

                        $lista_tarifas[] = [
                            'id'      => $row['tar_id'],
                            'codigo'  => $row['tar_codigo'],
                            'nombre'  => $row['tar_nombre'],
                            'formula' => $formula,
                            'precio'  =>  TarifasControlador::aplicar($producto['pro_costo'], $producto['pro_precio'], $row['tar_aplicar'], $row['tar_valorx'], $row['tar_valory'], $iva_imp),
                            'checked' => ($check == 0) ? false : true,
                            'precio_tarifa' => $precio
                        ];
                    }
                }
            }

            Http::json_response($lista_tarifas);
        }
    }

    public function actualizarCheckTarifas()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_producto']))
                Http::json_response(['errors' => ['Debe seleccionar un producto']]);

            $id_producto  = filter_input(INPUT_POST, 'id_producto', FILTER_SANITIZE_NUMBER_INT);
            $check  = filter_input(INPUT_POST, 'check', FILTER_SANITIZE_STRING);

            $tarifas = $this->productos->consultar("SELECT * FROM app_tarifas")->all();

            if (is_countable($tarifas) && count($tarifas)) {
                $producto = $this->productos->obtener($id_producto);
                if ($producto) {
                    foreach ($tarifas as $row) {
                        $tarifas_productos = $this->productos->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$id_producto} AND pt_tarid={$row['tar_id']}")->row();

                        if ($check != "true") {
                            $this->productos->deleter_tarifas($id_producto, $row['tar_id']);
                        } else {
                            $this->productos->asignar_tarifas($id_producto, $row['tar_id']);
                        }
                    }
                }
            }

            Http::json_response(true);
        }
    }

    public function actualizarCheckTarifaid()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_producto']))
                Http::json_response(['errors' => ['Debe seleccionar un producto']]);

            $id_producto  = filter_input(INPUT_POST, 'id_producto', FILTER_SANITIZE_NUMBER_INT);
            $id_tarifa  = filter_input(INPUT_POST, 'id_tarifa', FILTER_SANITIZE_NUMBER_INT);

            $tarifas_productos = $this->productos->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$id_producto} AND pt_tarid={$id_tarifa}")->row();

            if ($tarifas_productos) {
                $this->productos->deleter_tarifas($id_producto, $id_tarifa);
            } else {
                $this->productos->asignar_tarifas($id_producto, $id_tarifa);
            }
            Http::json_response(true);
        }
    }

    public function actualizarMontTarifas()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_producto']))
                Http::json_response(['errors' => ['Debe seleccionar un producto']]);

            $id_producto  = filter_input(INPUT_POST, 'id_producto', FILTER_SANITIZE_NUMBER_INT);
            $id_tarifa  = filter_input(INPUT_POST, 'id_tarifa', FILTER_SANITIZE_NUMBER_INT);
            $monto  = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING);

            $tarifas_productos = $this->productos->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$id_producto} AND pt_tarid={$id_tarifa}")->row();

            if ($tarifas_productos) {
                $tarifa_productos = $this->productos->consultar("UPDATE app_productos_tarifas SET pt_tarprecio={$monto} WHERE pt_proid={$id_producto} AND pt_tarid={$id_tarifa}")->run();
                if ($tarifa_productos) {
                    Http::json_response(true);
                } else {
                    Http::json_response(false);
                }
            } else {
                Http::json_response(false);
            }
        }
    }

    public function actualizarPreciosProducto()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('productos', 'editar_precio', $_SESSION['user_data']['emp_id'])) {

                $divisa = Moneda::Predeterminada();

                $pro_id     = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                $pro_precio = filter_input(INPUT_POST, 'precio_venta', FILTER_SANITIZE_STRING);
                $pro_costo  = filter_input(INPUT_POST, 'precio_costo', FILTER_SANITIZE_STRING);
                $pro_impid  = filter_input(INPUT_POST, 'impuesto', FILTER_SANITIZE_NUMBER_INT);

                if (empty($pro_precio))
                    $this->array_errors[] = "El campo Precio venta es obligatorio.";

                if (!empty($pro_id) && empty($this->array_errors)) {

                    $data_pro = $this->productos->obtener($pro_id);

                    if (!$data_pro)
                        $this->array_errors[] = "Accion prohibida";

                    if ($data_pro['pro_tipo'] == 3) {
                        if (empty($pro_costo))
                            $pro_costo = 0;
                    } else {
                        if (empty($pro_costo))
                            $this->array_errors[] = "El campo Precio costo es obligatorio.";
                    }

                    if (empty($pro_impid))
                        $this->array_errors[] = "El campo Impuesto es obligatorio.";

                    if (empty($this->array_errors)) {
                        if ($this->productos->editar($pro_id, [
                            'pro_precio'    => round($pro_precio, $divisa['precision']),
                            'pro_costo'     => round($pro_costo, $divisa['precision']),
                            'pro_impid'     => $pro_impid
                        ])) {

                            $venta = Moneda::moneda($pro_precio, $divisa['locale'], $divisa['symbol']);
                            $costo = Moneda::moneda($pro_costo, $divisa['locale'], $divisa['symbol']);

                            if ($data_pro['pro_tipo'] == 3) {
                                Notifica::producto(4, $pro_id, "Ha modificado el precio del servicio a: $venta");
                            } else {

                                Notifica::producto(4, $pro_id, "Ha modificado el precio del producto a <strong>precio costo</strong>: $costo <strong>precio venta</strong>: $venta");

                                //VERIFICAR SI SE ESTA USUANDO WOOCOMMERCE
                                if (defined('WCURL')  && defined('WCKEY') && defined('WCSECRECT') && defined('WCIMG')) {
                                    Http::json_response([
                                        'mensaje' => $this->subirAWoocommerce($pro_id)
                                    ]);
                                }
                            }

                            Http::json_response(true);
                        } else {
                            Http::json_response(false);
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para modificar los precios.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }


    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('productos', 'crear', $_SESSION['user_data']['emp_id'])) {

                $pro_equivalencia  = filter_input(INPUT_POST, 'equivalencia', FILTER_SANITIZE_STRING);
                $pro_partnumber    = filter_input(INPUT_POST, 'partnumber', FILTER_SANITIZE_STRING);
                $pro_expedicion    = filter_input(INPUT_POST, 'expedicion', FILTER_SANITIZE_STRING);
                $pro_tipo          = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);
                $pro_vencimiento   = filter_input(INPUT_POST, 'vencimiento', FILTER_SANITIZE_STRING);
                $pro_bloqueado     = ('true' == filter_input(INPUT_POST, 'bloqueado')) ? 1 : 0;
                $pro_fabid         = filter_input(INPUT_POST, 'fabid', FILTER_SANITIZE_NUMBER_INT);
                $pro_descripcion   = filter_input(INPUT_POST, 'descripcion', FILTER_SANITIZE_STRING);
                $pro_descripcion   = $this->solicitud->sanitize($_POST['descripcion'], FILTER_SANITIZE_STRING);
                $pro_nombrecorto   = $this->solicitud->sanitize($_POST['nombrecorto'], FILTER_SANITIZE_STRING);
                $pro_nostock       = ('true' == filter_input(INPUT_POST, 'nostock')) ? 1 : 0;
                $pro_observaciones = filter_input(INPUT_POST, 'observaciones', FILTER_SANITIZE_STRING);
                $pro_codigo        = filter_input(INPUT_POST, 'codigo', FILTER_SANITIZE_STRING);
                $pro_secompra      = ('true' == filter_input(INPUT_POST, 'secompra')) ? 1 : 0;
                $pro_sevende       = ('true' == filter_input(INPUT_POST, 'sevende')) ? 1 : 0;
                $pro_publico       = ('true' == filter_input(INPUT_POST, 'publico')) ? 1 : 0;

                if (empty($pro_expedicion)) {
                    $pro_expedicion = date('Y-m-d');
                }

                if (empty($pro_vencimiento)) {
                    $pro_vencimiento = '0000-00-00';
                }

                if (empty($pro_tipo))
                    $this->array_errors[] = "El campo Tipo es obligatorio.";
                if (empty($pro_descripcion))
                    $this->array_errors[] = "El campo Descripción es obligatorio.";
                if (empty($pro_codigo))
                    $this->array_errors[] = "El campo Referencia es obligatorio.";

                if (empty($this->array_errors)) {

                    if ($pro_tipo == 1) {

                        if (isset($_POST['provid'])) {
                            $provid = json_decode($_POST['provid']);
                            if (!is_countable($provid)) {
                                $this->array_errors[] = "El campo Proveedor es obligatorio.";
                            }
                        }

                        if (isset($_POST['catid'])) {
                            $catid = json_decode($_POST['catid']);
                            if (!is_countable($catid)) {
                                $this->array_errors[] = "El campo Categoria es obligatorio.";
                            }
                        }

                        if (empty($pro_fabid))
                            $this->array_errors[] = "El campo Fabricante es obligatorio.";
                    }

                    $productoProveedor = new ProductoProveedor();
                    $productoCategoria = new ProductoCategoria();

                    if ($this->productos->existe('pro_codigo', $pro_codigo))
                        $this->array_errors[] = "El producto ya existe";

                    if (empty($this->array_errors)) {

                        $pro_id = $this->productos->guardar([
                            'pro_equivalencia'  => $pro_equivalencia,
                            'pro_partnumber'    => $pro_partnumber,
                            'pro_expedicion'    => $pro_expedicion,
                            'pro_tipo'          => $pro_tipo,
                            'pro_vencimiento'   => $pro_vencimiento,
                            'pro_bloqueado'     => $pro_bloqueado,
                            'pro_fabid'         => ($pro_tipo == 1) ? $pro_fabid : NULL,
                            'pro_descripcion'   => $pro_descripcion,
                            'pro_nombrecorto'   => $pro_nombrecorto,
                            'pro_nostock'       => ($pro_tipo == 3) ? 0 : $pro_nostock,
                            'pro_observaciones' => $pro_observaciones,
                            'pro_codigo'        => $pro_codigo,
                            'pro_secompra'      => ($pro_tipo == 3) ? 0 : $pro_secompra,
                            'pro_sevende'       => $pro_sevende,
                            'pro_publico'       => $pro_publico
                        ]);

                        if ($pro_id) {

                            if ($pro_tipo == 3 || $pro_tipo == 2) {
                                $nomb = ($pro_tipo == 3) ? 'servicio' : 'producto compuesto';
                                Notifica::producto(4, $pro_id, 'Ha creado el ' . $nomb);
                            } else {

                                Notifica::producto(4, $pro_id, 'Ha creado el producto');

                                $productoProveedor->eliminarProvProducto($pro_id);

                                foreach ($provid as $proveedor) {
                                    $productoProveedor->guardar([
                                        'pp_proid'  => $pro_id,
                                        'pp_provid' => $proveedor
                                    ]);
                                }

                                $productoCategoria->eliminarCatProducto($pro_id);

                                foreach ($catid as $categoria) {
                                    $productoCategoria->guardar([
                                        'pc_proid' => $pro_id,
                                        'pc_catid' => $categoria
                                    ]);
                                }
                            }

                            Http::json_response(ruta_base() . 'productos/editar/' . $pro_id);
                        } else {
                            Http::json_response(false);
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para registrar productos.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }


    public function chequearStocks(int $id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $producto =  $this->productos->obtenerProductosSimplesCompuestos($id);

            $product = [];

            if (is_countable($producto) && count($producto)) {
                foreach ($producto as $row) {
                    $stock = $this->productos->obtenerProductosSimplesw($row['pro_id']);
                    $product[] = [
                        'pro_cid' => $row['pro_cid'],
                        'pro_ccid' => $row['pro_ccid'],
                        'pro_ccproid' => $row['pro_ccproid'],
                        'pro_cccant' => $row['pro_cccant'],
                        'pro_ccprecio' => $row['pro_ccprecio'],
                        'pro_descripcion' => $row['pro_descripcion'],
                        'pro_nombrecorto' => $row['pro_nombrecorto'],
                        'pro_precio' => $row['pro_precio'],
                        'total_stock' => $stock['total_stock']
                    ];
                }
            }
            Http::json_response($product);
        }
    }

    public function precioProductoCompuesto()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id            = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $precio            = filter_input(INPUT_POST, 'precio', FILTER_SANITIZE_STRING);

            $divisa = Moneda::Predeterminada();

            if (empty($this->array_errors)) {

                if ($this->productos->existe('pro_id', $id)) {
                    if ($this->productos->editar($id, [
                        'pro_precio' => $precio
                    ])) {
                        $prod = $this->productos->obtener($id);
                        $venta = Moneda::moneda($prod['pro_precio'], $divisa['locale'], $divisa['symbol']);

                        Notifica::producto(4, $id, "Ha modificado el precio del producto a: $venta");
                        Http::json_response(true);
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function actualizarPrecioProCompuesto()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id            = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $precio            = filter_input(INPUT_POST, 'precio', FILTER_SANITIZE_STRING);

            $productoCompuesto = new ProductosCompuestos();

            if (empty($this->array_errors)) {

                if ($productoCompuesto->existe('pro_cid', $id)) {
                    if ($productoCompuesto->editar($id, [
                        'pro_ccprecio' => $precio
                    ])) {
                        Http::json_response(true);
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function actualizarCantidadProCompuesto()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id            = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $cantidad            = filter_input(INPUT_POST, 'cantidad', FILTER_SANITIZE_STRING);

            if (empty($cantidad))
                $this->array_errors[] = "Es necesario agregar la cantidad.";

            $productoCompuesto = new ProductosCompuestos();

            if (empty($this->array_errors)) {

                if ($productoCompuesto->existe('pro_cid', $id)) {
                    $productoCompuesto->editar($id, [
                        'pro_cccant' => $cantidad,
                    ]);
                    Http::json_response(true);
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function editarProducto()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if ($this->module->has_module_action_permission('productos', 'editar', $_SESSION['user_data']['emp_id'])) {

                $pro_id            = filter_input(INPUT_POST, 'id_producto', FILTER_SANITIZE_NUMBER_INT);
                $pro_equivalencia  = filter_input(INPUT_POST, 'equivalencia', FILTER_SANITIZE_STRING);
                $pro_partnumber    = filter_input(INPUT_POST, 'partnumber', FILTER_SANITIZE_STRING);
                $pro_expedicion    = filter_input(INPUT_POST, 'expedicion');
                $pro_tipo          = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT);
                $pro_vencimiento   = filter_input(INPUT_POST, 'vencimiento');
                $pro_bloqueado     = ('true' == filter_input(INPUT_POST, 'bloqueado')) ? 1 : 0;
                $pro_fabid         = filter_input(INPUT_POST, 'fabid', FILTER_SANITIZE_NUMBER_INT);
                $pro_descripcion   = $this->solicitud->sanitize($_POST['descripcion'], FILTER_SANITIZE_STRING);
                $pro_nombrecorto   = $this->solicitud->sanitize($_POST['nombre'], FILTER_SANITIZE_STRING);
                $pro_nostock       = ('true' == filter_input(INPUT_POST, 'nostock')) ? 1 : 0;
                $pro_observaciones = filter_input(INPUT_POST, 'observaciones', FILTER_SANITIZE_STRING);
                $pro_codigo        = filter_input(INPUT_POST, 'codigo', FILTER_SANITIZE_STRING);
                $pro_secompra      = ('true' == filter_input(INPUT_POST, 'secompra')) ? 1 : 0;
                $pro_sevende       = ('true' == filter_input(INPUT_POST, 'sevende')) ? 1 : 0;
                $pro_publico       = ('true' == filter_input(INPUT_POST, 'publico')) ? 1 : 0;

                $data_pro = $this->productos->obtener($pro_id);
                $provid = [];
                $catid = [];
                $prod = [];

                if ($data_pro) {

                    if (empty($pro_expedicion)) {
                        $pro_expedicion = date('Y-m-d');
                    }

                    if (empty($pro_vencimiento)) {
                        $pro_vencimiento = '0000-00-00';
                    }

                    if (empty($pro_tipo))
                        $this->array_errors[] = "El campo Tipo es obligatorio.";
                    if (empty($pro_descripcion))
                        $this->array_errors[] = "El campo Descripción es obligatorio.";
                    if (empty($pro_codigo))
                        $this->array_errors[] = "El campo Referencia es obligatorio.";

                    if ($data_pro['pro_tipo'] == 2) {
                        if (isset($_POST['catid'])) {
                            $catid = json_decode($_POST['catid']);
                            if (!is_countable($catid)) {
                                $this->array_errors[] = "El campo Categoria es obligatorio.";
                            }
                        }
                    }

                    if ($data_pro['pro_tipo'] == 1) {

                        if (empty($pro_fabid))
                            $this->array_errors[] = "El campo Fabricante es obligatorio.";


                        if (isset($_POST['provid'])) {
                            $provid = json_decode($_POST['provid']);
                            if (!is_countable($provid)) {
                                $this->array_errors[] = "El campo Proveedor es obligatorio.";
                            }
                        }

                        if (isset($_POST['catid'])) {
                            $catid = json_decode($_POST['catid']);
                            if (!is_countable($catid)) {
                                $this->array_errors[] = "El campo Categoria es obligatorio.";
                            }
                        }
                    }

                    if (empty($this->array_errors)) {

                        $productoProveedor = new ProductoProveedor();
                        $productoCategoria = new ProductoCategoria();
                        $productoCompuesto = new ProductosCompuestos();

                        if ($this->productos->condicional("SELECT * FROM app_productos WHERE pro_id <> $pro_id AND pro_codigo = '$pro_codigo'"))
                            $this->array_errors[] = "El producto ya existe";

                        if (empty($this->array_errors)) {

                            if ($this->productos->editar($pro_id, [
                                'pro_equivalencia'  => $pro_equivalencia,
                                'pro_partnumber'    => $pro_partnumber,
                                'pro_expedicion'    => $pro_expedicion,
                                'pro_tipo'          => $pro_tipo,
                                'pro_vencimiento'   => $pro_vencimiento,
                                'pro_bloqueado'     => ($data_pro['pro_tipo'] == 3) ? 0 : $pro_bloqueado,
                                'pro_fabid'         => ($data_pro['pro_tipo'] == 3) ? NULL : $pro_fabid,
                                'pro_descripcion'   => $pro_descripcion,
                                'pro_nombrecorto'   => $pro_nombrecorto,
                                'pro_nostock'       => ($data_pro['pro_tipo'] == 3) ? 0 : $pro_nostock,
                                'pro_observaciones' => $pro_observaciones,
                                'pro_codigo'        => $pro_codigo,
                                'pro_secompra'      => ($data_pro['pro_tipo'] == 3) ? 0 : $pro_secompra,
                                'pro_sevende'       => ($data_pro['pro_tipo'] == 3) ? 0 : $pro_sevende,
                                'pro_publico'       => ($data_pro['pro_tipo'] == 3) ? 0 : $pro_publico
                            ])) {

                                if ($data_pro['pro_tipo'] == 3) {
                                    Notifica::producto(4, $pro_id, 'Ha modificados los datos basicos del servicio');
                                }
                                if ($data_pro['pro_tipo'] == 2) {
                                    Notifica::producto(4, $pro_id, 'Ha modificados los datos basicos del producto compuesto');

                                    $productoCategoria->eliminarCatProducto($pro_id);

                                    foreach ($catid as $categoria) {
                                        $productoCategoria->guardar([
                                            'pc_proid' => $pro_id,
                                            'pc_catid' => $categoria
                                        ]);
                                    }
                                }
                                if ($data_pro['pro_tipo'] == 1) {

                                    Notifica::producto(4, $pro_id, 'Ha modificados los datos basicos del producto');

                                    $productoProveedor->eliminarProvProducto($pro_id);

                                    foreach ($provid as $proveedor) {
                                        $productoProveedor->guardar([
                                            'pp_proid'  => $pro_id,
                                            'pp_provid' => $proveedor
                                        ]);
                                    }

                                    $productoCategoria->eliminarCatProducto($pro_id);

                                    foreach ($catid as $categoria) {
                                        $productoCategoria->guardar([
                                            'pc_proid' => $pro_id,
                                            'pc_catid' => $categoria
                                        ]);
                                    }

                                    //VERIFICAR SI SE ESTA USUANDO WOOCOMMERCE
                                    if (defined('WCURL')  && defined('WCKEY') && defined('WCSECRECT') && defined('WCIMG')) {
                                        Http::json_response([
                                            'mensaje' => $this->subirAWoocommerce($pro_id)
                                        ]);
                                    }
                                }

                                Http::json_response(true);
                            } else {
                                Http::json_response(false);
                            }
                        }
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida.';
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para modificar productos.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function agregarproductoCompuesto()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $pro_id            = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $data_pro = $this->productos->obtener($pro_id);

            $prod = [];

            if ($data_pro) {

                $id            = filter_input(INPUT_POST, 'prod', FILTER_SANITIZE_NUMBER_INT);

                if (empty($this->array_errors)) {

                    $productoCompuesto = new ProductosCompuestos();

                    if (empty($this->array_errors)) {

                        //$productoCompuesto->eliminarProCompuesto($pro_id);

                        $stock = $this->productos->obtenerProductosSimplesw($id);
                        if ($stock['total_stock'] > 0) {
                            if (!$productoCompuesto->consultar("SELECT * FROM app_productos_compuestos WHERE pro_ccid=$pro_id AND pro_ccproid=$id")->row()) {
                                $productoCompuesto->guardar([
                                    'pro_ccid'  => $pro_id,
                                    'pro_ccproid' => $id,
                                    'pro_cccant' => 0,
                                    'pro_ccprecio' => $stock['pro_precio']
                                ]);
                                Http::json_response(true);
                            } else {
                                $this->array_errors[] = 'Ya fue agregado este producto ' . $stock['pro_descripcion'];
                            }
                        } else {
                            $this->array_errors[] = 'No existe disponibilidad de stock de este producto ' . $stock['pro_descripcion'];
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Acción prohibida.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarSeleccion($id)
    {

        $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

        $productoCompuesto = new ProductosCompuestos();

        if ($productoCompuesto->existe('pro_cid', $id)) {
            Http::json_response($productoCompuesto->eliminar($id));
        } else {
            Http::json_response(false);
        }
    }

    public function eliminar($id)
    {
        if ($this->module->has_module_action_permission('productos', 'eliminar', $_SESSION['user_data']['emp_id'])) {

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            if ($this->productos->existe('pro_id', $id)) {
                Http::json_response($this->productos->eliminar($id));
            } else {
                Http::json_response(false);
            }
        } else {
            $this->array_errors[] = 'Acceso prohibido no posee permisos para eliminar productos.';
        }

        Http::json_response(['errors' => $this->array_errors]);
    }

    public function asignar_tarifas()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id_producto    = filter_input(INPUT_POST, 'id_producto', FILTER_SANITIZE_NUMBER_INT);
            $id_tarifa      = filter_input(INPUT_POST, 'id_tarifa', FILTER_SANITIZE_NUMBER_INT);
            Http::json_response($this->productos->asignar_tarifas($id_producto, $id_tarifa));
        }
    }

    public function imagen()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD']) {

            if ($this->module->has_module_action_permission('productos', 'editar', $_SESSION['user_data']['emp_id'])) {

                $pro_id = filter_input(INPUT_POST, 'id_producto', FILTER_SANITIZE_NUMBER_INT);

                if (!$this->productos->existe('pro_id', $pro_id))
                    $this->array_errors[] = 'Producto no encontrado';
                if (empty($_FILES['imagen']))
                    $this->array_errors[] = 'La imagen es obligatorio.';

                if (empty($this->array_errors)) {

                    $productoImagen = new ProductosImagen();

                    $fileSize       = $_FILES['imagen']['size'];
                    $extenciones    = ['jpg', 'jpeg', 'png', 'webp'];

                    if ($_FILES['imagen']['error'] === UPLOAD_ERR_OK) {

                        $time  = time();
                        $image                     = new Upload($_FILES['imagen']);
                        $image->file_new_name_body = $time;
                        $file_img                  = $time . '.' . $image->file_src_name_ext;

                        $fileNameCmps = explode(".", basename($_FILES['imagen']['name']));
                        $fileExtension = strtolower(end($fileNameCmps));

                        if ($fileSize < 10000000) {
                            if (in_array($fileExtension, $extenciones)) {
                                if ($image->uploaded) {
                                    if (file_exists(constant('UPLOADS_URI') . 'productos/' . $file_img)) {
                                        unlink(constant('UPLOADS_URI') . 'productos/' . $file_img);
                                    }
                                    $image->process(constant('UPLOADS_URI') . 'productos');
                                    if ($image->processed) {
                                        if ($productoImagen->guardar([
                                            'pi_imagen' => $file_img,
                                            'pi_proid'  => $pro_id
                                        ], true)) {
                                            Notifica::producto(4, $pro_id, 'Ha subido una imagen al producto');
                                            if (defined('WCURL')  && defined('WCKEY') && defined('WCSECRECT') && defined('WCIMG')) {
                                                Http::json_response([
                                                    'mensaje' => $this->subirAWoocommerce($pro_id)
                                                ]);
                                            }
                                            Http::json_response('Imagen subida satisfactoriamente');
                                        } else {
                                            unlink(constant('UPLOADS_URI') . 'productos/' . $file_img);
                                            $this->array_errors = 'Se produjo un error al cargar el archivo';
                                        }
                                    } else {
                                        $this->array_errors[] = 'Se produjo un error al cargar el archivo';
                                    }
                                }
                            } else {
                                $this->array_errors[] = 'Solo archivos con formato PNG o JPG, JPEG';
                            }
                        } else {
                            $this->array_errors[] = 'EL archivo supera el limite de 10MB"';
                        }
                    } else {
                        $this->array_errors[] = 'Se produjo un error al cargar el archivo';
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para editar productos.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function cuadricula_productos_pdf(int $id_tarifa)
    {
        $id_tarifa = filter_var($id_tarifa, FILTER_SANITIZE_NUMBER_INT);

        $tarifa_data = $this->productos->obtenerTarifa($id_tarifa);

        if (!$tarifa_data) {
            Http::notFound();
        }

        $pro_imagen_model   = new ProductosImagen();
        $empresa_data       = $this->productos->obtenerDatosEmpresa();
        $categorias         = $this->productos->obtenerCategorias();
        $array_productos    = [];

        foreach ($categorias as $row) {
            $productos =  $pro_imagen_model->obtenerProductosConImagenes($row['cat_id']);
            foreach ($productos as $pro) {
                $tarifas_productos = $this->productos->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$pro['pro_id']} AND pt_tarid={$id_tarifa}")->row();

                if ($tarifas_productos) {
                    $monto_tarifa = $tarifas_productos['pt_tarprecio'];
                    if ($monto_tarifa > 0) {
                        $precio_total = $monto_tarifa;
                    } else {
                        $impuesto = $this->productos->obtenerproImp($pro['pro_id']);

                        if ('pvp' == $tarifa_data['tar_aplicar'] || 'pvpiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($pro['pro_precio'] * ($impuesto['imp_valor'] / 100));
                        }
                        if ('costo' == $tarifa_data['tar_aplicar'] || 'costoiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($pro['pro_costo'] * ($impuesto['imp_valor'] / 100));
                        }

                        $precio_total = TarifasControlador::aplicar($pro['pro_costo'], $pro['pro_precio'], $tarifa_data['tar_aplicar'], $tarifa_data['tar_valorx'], $tarifa_data['tar_valory'], $iva_m);
                    }
                } else {
                    $precio_total = 0;
                }

                $array_productos[$row['cat_nombre']][] = [
                    'descripcion'   => $pro['pro_descripcion'],
                    'imagen'        => constant('IMG_URI') . 'productos/' . $pro['pi_imagen'],
                    'costo'         => $pro['pro_costo'],
                    'venta'         => $pro['pro_precio'],
                    'ta_nombre'     => $tarifa_data['tar_nombre'],
                    'tarifa'        => Moneda::moneda($precio_total, $this->div_master['div_locale'], $this->div_master['div_simbolo'])
                ];
                
            }
        }

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 15,
            'margin_right'      => 15,
            'margin_top'        => 25,
            'margin_bottom'     => 100,
            'margin_header'     => 15,
            'margin_footer'     => 15,
            'format'            => '',
            'orientation'       => 'P',
            'default_font_size' => 6,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle('Productos');
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject('Productos tarifas');

        $html_header = Vista::viewPDF('productos/pdf/cuadricula_productos/header.php', [
            'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
            'emp_rif'       => $empresa_data['emp_rif'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
            'emp_estado'    => $empresa_data['emp_estado'] ?? '',
            'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
        ]);

        $mpdf->SetHTMLHeader($html_header);

        $html_footer = Vista::viewPDF('productos/pdf/cuadricula_productos/footer.php', [
            'tar_nombre'    => $tarifa_data['tar_nombre'],
        ]);

        $mpdf->SetHTMLFooter($html_footer);

        $html_body = Vista::viewPDF('productos/pdf/cuadricula_productos/body.php', [
            'productos'     => $array_productos,
            'tar_nombre'    => $tarifa_data['tar_nombre'],
        ]);

        $mpdf->WriteHTML($html_body);

        $mpdf->Output("productos_tarifas.pdf", \Mpdf\Output\Destination::INLINE);
        exit;
    }
    
    public function listado_cuadricula_pdfCate()
    {
      if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

        $id_tarifa = filter_input(INPUT_POST, 'tarifa', FILTER_SANITIZE_STRING);

        $tarifa_data = $this->productos->obtenerTarifa($id_tarifa);

        if (!$tarifa_data) {
            Http::notFound();
        }

        $new_pro_categoria  = new ProductoCategoria();
        $proImagen = new ProductosImagen();
        $empresa_data       = $this->productos->obtenerDatosEmpresa();
        $catid= json_decode($_POST['categ'], true);
        $categorias         = $this->productos->obtenerCategoriasPadre();
        $array_productos    = [];
        $array_subcategoria = [];
        $array_lista = [];
        $array_listaca = [];

         foreach ($catid as $categoria) {
            $row = $this->productos->consultar("SELECT * FROM app_categorias WHERE cat_id={$categoria}")->row();
            $array_productos = [];
            $array_subcategoria = [];
            
            //$product=[];
            $productos =  $new_pro_categoria->obtenerProductosCategoria($row['cat_id']);
            $subcategorias = $new_pro_categoria->obtenerSubCategorias($row['cat_id']);

            foreach ($productos as $pro) {
                $tarifas_productos = $this->productos->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$pro['pro_id']} AND pt_tarid={$id_tarifa}")->row();
                $imagens_p = $proImagen->obtenerImagenId($pro['pro_id']);
                if ($tarifas_productos) {
                    $monto_tarifa = $tarifas_productos['pt_tarprecio'];
                    if ($monto_tarifa > 0) {
                        $precio_total = $monto_tarifa;
                    } else {
                        $impuesto = $this->productos->obtenerproImp($pro['pro_id']);

                        if ('pvp' == $tarifa_data['tar_aplicar'] || 'pvpiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($pro['pro_precio'] * ($impuesto['imp_valor'] / 100));
                        }
                        if ('costo' == $tarifa_data['tar_aplicar'] || 'costoiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($pro['pro_costo'] * ($impuesto['imp_valor'] / 100));
                        }
                        $precio_total = TarifasControlador::aplicar($pro['pro_costo'], $pro['pro_precio'], $tarifa_data['tar_aplicar'], $tarifa_data['tar_valorx'], $tarifa_data['tar_valory'], $iva_m);
                    }
                    if (count($imagens_p) > 0) {
                        $images = ($imagens_p[0]['pi_imagen'] != NULL) ? constant('IMG_URI') . 'productos/' . $imagens_p[0]['pi_imagen'] : constant('IMG_URI') . 'productos/150x150.png';
                    }

                    $array_productos[] = [
                        'descripcion'   => $pro['pro_descripcion'],
                        'costo'         => $pro['pro_costo'],
                        'venta'         => $pro['pro_precio'],
                        'imagen'        => $images,
                        'ta_nombre'     => $tarifa_data['tar_nombre'],
                        'tarifa'        => Moneda::moneda($precio_total, $this->div_master['div_locale'], $this->div_master['div_simbolo'])
                    ];
                }
            }

            foreach ($subcategorias as $row2) {
                 if ((!in_array($row2['cat_id'], $array_listaca))) {
                    $productosp =  $new_pro_categoria->obtenerProductosCategoria($row2['cat_id']);
                    $product = [];
                    foreach ($productosp as $pro) {
                        $tarifas_productos = $this->productos->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$pro['pro_id']} AND pt_tarid={$id_tarifa}")->row();
                        $imagens_p = $proImagen->obtenerImagenId($pro['pro_id']);
                        if ($tarifas_productos) {
                            $monto_tarifa = $tarifas_productos['pt_tarprecio'];
                            if ($monto_tarifa > 0) {
                                $precio_total = $monto_tarifa;
                            } else {
                                $impuesto = $this->productos->obtenerproImp($pro['pro_id']);
                                if ('pvp' == $tarifa_data['tar_aplicar'] || 'pvpiva' == $tarifa_data['tar_aplicar']) {
                                    $iva_m = ($pro['pro_precio'] * ($impuesto['imp_valor'] / 100));
                                }
                                if ('costo' == $tarifa_data['tar_aplicar'] || 'costoiva' == $tarifa_data['tar_aplicar']) {
                                    $iva_m = ($pro['pro_costo'] * ($impuesto['imp_valor'] / 100));
                                }
    
                                $precio_total = TarifasControlador::aplicar($pro['pro_costo'], $pro['pro_precio'], $tarifa_data['tar_aplicar'], $tarifa_data['tar_valorx'], $tarifa_data['tar_valory'], $iva_m);
                            }
                            if (count($imagens_p) > 0) {
                                $images = ($imagens_p[0]['pi_imagen'] != NULL) ? constant('IMG_URI') . 'productos/' . $imagens_p[0]['pi_imagen'] : constant('IMG_URI') . 'productos/150x150.png';
                            } else {
                                $images = constant('IMG_URI') . 'productos/150x150.png';
                            }
    
                            $product[] = [
                                'descripcion'   => $pro['pro_descripcion'],
                                'costo'         => $pro['pro_costo'],
                                'venta'         => $pro['pro_precio'],
                                'imagen'        => $images,
                                'ta_nombre'     => $tarifa_data['tar_nombre'],
                                'tarifa'        => Moneda::moneda($precio_total, $this->div_master['div_locale'], $this->div_master['div_simbolo'])
                            ];
                        }
                    }
    
                    if (count($product) > 0) {
                        $array_subcategoria[] = [
                            'subcategoria'   => $row2['cat_nombre'],
                            'productos'     => $product,
                        ];
                    }
                    $array_listaca[] =$row2['cat_id'];
                 }
            }

           if ((!in_array($row['cat_id'], $array_listaca))) {
                if (count($array_subcategoria) > 0 || count($array_productos) > 0) {
                    $array_lista[] = [
                        'nombre'   => $row['cat_nombre'],
                        'productos'      => $array_productos,
                        'subcategorias'  => $array_subcategoria
                    ];
                }
            $array_listaca[] =$row['cat_id'];
           }
           
           //Http::json_response($array_lista);
        }

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 15,
            'margin_right'      => 15,
            'margin_top'        => 35,
            'margin_bottom'     => 20,
            'margin_header'     => 15,
            'margin_footer'     => 15,
            'format'            => 'A4',
            'orientation'       => 'P',
            'default_font_size' => 8,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle('Productos');
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject('Productos tarifas');

        $html_header = Vista::viewPDF('productos/pdf/listado_productos/header.php', [
            'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
            'emp_rif'       => $empresa_data['emp_rif'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
            'emp_estado'    => $empresa_data['emp_estado'] ?? '',
            'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
        ]);

        $mpdf->SetHTMLHeader($html_header);

        $html_footer = Vista::viewPDF('productos/pdf/listado_productos/footer.php', [
            'tar_nombre'    => $tarifa_data['tar_nombre'],
        ]);

        $mpdf->SetHTMLFooter($html_footer);

        $html_body = Vista::viewPDF('productos/pdf/cuadricula_productos/body_cuadricula.php', [
            'productos'     => $array_lista,
            'tar_nombre'    => $tarifa_data['tar_nombre'],
        ]);

        $mpdf->WriteHTML(utf8_encode($html_body));

        $mpdf->Output("productos_tarifas_cuadriculas.pdf", \Mpdf\Output\Destination::INLINE);
        exit;
    }
    }

    public function listadoProductosExcel(int $id_tarifa)
    {
        $tarifa_data = $this->productos->obtenerTarifa($id_tarifa);

        if (!$tarifa_data) {
            Http::notFound();
        }

        $new_pro_categoria  = new ProductoCategoria();
        $empresa_data       = $this->productos->obtenerDatosEmpresa();
        $categorias         = $this->productos->obtenerCategorias();
        $array_productos    = [];

        foreach ($categorias as $row) {
            $productos = $new_pro_categoria->obtenerProductosCategoria($row['cat_id']);
            foreach ($productos as $pro) {
                $tarifas_productos = $this->productos->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$pro['pro_id']} AND pt_tarid={$id_tarifa}")->row();

                if ($tarifas_productos) {

                    $monto_tarifa = $tarifas_productos['pt_tarprecio'];
                    if ($monto_tarifa > 0) {
                        $precio_total = $monto_tarifa;
                    } else {
                        $impuesto = $this->productos->obtenerproImp($pro['pro_id']);

                        if ('pvp' == $tarifa_data['tar_aplicar'] || 'pvpiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($pro['pro_precio'] * ($impuesto['imp_valor'] / 100));
                        }
                        if ('costo' == $tarifa_data['tar_aplicar'] || 'costoiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($pro['pro_costo'] * ($impuesto['imp_valor'] / 100));
                        }

                        $precio_total = TarifasControlador::aplicar($pro['pro_costo'], $pro['pro_precio'], $tarifa_data['tar_aplicar'], $tarifa_data['tar_valorx'], $tarifa_data['tar_valory'], $iva_m);
                    }

                    $array_productos[$row['cat_nombre']][] = [
                        'descripcion'   => $pro['pro_descripcion'],
                        'costo'         => $pro['pro_costo'],
                        'venta'         => $pro['pro_precio'],
                        'ta_nombre'     => $tarifa_data['tar_nombre'],
                        'tarifa'        => $precio_total
                    ];
                }
            }
        }

        $spreadsheet = new Spreadsheet();

        $spreadsheet->getProperties()->setCreator($empresa_data['emp_nombre'])->setLastModifiedBy('Firma Digital')->setTitle('Listado de productos')->setSubject('Office 2007 XLSX Test Document')->setDescription('Test document for Office 2007 XLSX, generated using PHP classes.')->setKeywords('producto tarifa office 2007 openxml php')->setCategory('Listado de productos');

        $spreadsheet->getActiveSheet(0)->setCellValue("A1", 'Descripción')->setCellValue('B1', 'Precio');

        $i = 2;

        foreach ($array_productos as $row => $value) {

            $spreadsheet->getActiveSheet()->setCellValue("A$i", $row);

            $spreadsheet->getActiveSheet()->mergeCells("A$i:B$i")->getStyle("A$i:B$i")
                ->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
                ->getStartColor()->setARGB('cccccc');

            foreach ($value as $pro) {
                $i++;
                $spreadsheet->getActiveSheet()->setCellValue("A$i", $pro['descripcion'])->setCellValue("B$i", $pro['tarifa']);
            }

            $i++;
        }


        $spreadsheet->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
        $spreadsheet->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

        $spreadsheet->getActiveSheet()->setTitle('Listado de productos');
        //$spreadsheet->getActiveSheet()->getProtection()->setSheet(true);

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $spreadsheet->setActiveSheetIndex(0);

        // Redirect output to a client’s web browser (Xlsx)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="Listado de productos.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
        $writer->save('php://output');
        exit;
    }

    public function listado_productos_pdf(int $id_tarifa)
    {
        $id_tarifa = filter_var($id_tarifa, FILTER_SANITIZE_NUMBER_INT);

        $tarifa_data = $this->productos->obtenerTarifa($id_tarifa);

        if (!$tarifa_data) {
            Http::notFound();
        }

        $new_pro_categoria  = new ProductoCategoria();
        $empresa_data       = $this->productos->obtenerDatosEmpresa();
        $categorias         = $this->productos->obtenerCategoriasPadre();
        $array_productos    = [];
        $array_subcategoria = [];
        $array_lista = [];

        foreach ($categorias as $row) {
            $array_productos = [];
            $array_subcategoria = [];
            //$product=[];
            $productos =  $new_pro_categoria->obtenerProductosCategoria($row['cat_id']);
            $subcategorias = $new_pro_categoria->obtenerSubCategorias($row['cat_id']);

            foreach ($productos as $pro) {
                $tarifas_productos = $this->productos->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$pro['pro_id']} AND pt_tarid={$id_tarifa}")->row();

                if ($tarifas_productos) {
                    $monto_tarifa = $tarifas_productos['pt_tarprecio'];
                    if ($monto_tarifa > 0) {
                        $precio_total = $monto_tarifa;
                    } else {
                        $impuesto = $this->productos->obtenerproImp($pro['pro_id']);

                        if ('pvp' == $tarifa_data['tar_aplicar'] || 'pvpiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($pro['pro_precio'] * ($impuesto['imp_valor'] / 100));
                        }
                        if ('costo' == $tarifa_data['tar_aplicar'] || 'costoiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($pro['pro_costo'] * ($impuesto['imp_valor'] / 100));
                        }

                        $precio_total = TarifasControlador::aplicar($pro['pro_costo'], $pro['pro_precio'], $tarifa_data['tar_aplicar'], $tarifa_data['tar_valorx'], $tarifa_data['tar_valory'], $iva_m);
                    }


                    $array_productos[] = [
                        'descripcion'   => $pro['pro_descripcion'],
                        'costo'         => $pro['pro_costo'],
                        'venta'         => $pro['pro_precio'],
                        'ta_nombre'     => $tarifa_data['tar_nombre'],
                        'tarifa'        => Moneda::moneda($precio_total, $this->div_master['div_locale'], $this->div_master['div_simbolo'])
                    ];
                }
            }

            foreach ($subcategorias as $row2) {
                $productosp =  $new_pro_categoria->obtenerProductosCategoria($row2['cat_id']);
                $product = [];
                foreach ($productosp as $pro) {
                    $tarifas_productos = $this->productos->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$pro['pro_id']} AND pt_tarid={$id_tarifa}")->row();

                    if ($tarifas_productos) {
                        $monto_tarifa = $tarifas_productos['pt_tarprecio'];
                        if ($monto_tarifa > 0) {
                            $precio_total = $monto_tarifa;
                        } else {
                            $impuesto = $this->productos->obtenerproImp($pro['pro_id']);
                            if ('pvp' == $tarifa_data['tar_aplicar'] || 'pvpiva' == $tarifa_data['tar_aplicar']) {
                                $iva_m = ($pro['pro_precio'] * ($impuesto['imp_valor'] / 100));
                            }
                            if ('costo' == $tarifa_data['tar_aplicar'] || 'costoiva' == $tarifa_data['tar_aplicar']) {
                                $iva_m = ($pro['pro_costo'] * ($impuesto['imp_valor'] / 100));
                            }
                            $precio_total = TarifasControlador::aplicar($pro['pro_costo'], $pro['pro_precio'], $tarifa_data['tar_aplicar'], $tarifa_data['tar_valorx'], $tarifa_data['tar_valory'], $iva_m);
                        }

                        $product[] = [
                            'descripcion'   => $pro['pro_descripcion'],
                            'costo'         => $pro['pro_costo'],
                            'venta'         => $pro['pro_precio'],
                            'ta_nombre'     => $tarifa_data['tar_nombre'],
                            'tarifa'        => Moneda::moneda($precio_total, $this->div_master['div_locale'], $this->div_master['div_simbolo'])
                        ];
                    }
                }

                if (count($product) > 0) {
                    $array_subcategoria[] = [
                        'subcategoria'   => $row2['cat_nombre'],
                        'productos'     => $product,
                    ];
                }
            }

            if (count($array_subcategoria) > 0 || count($array_productos) > 0) {
                $array_lista[] = [
                    'nombre'   => $row['cat_nombre'],
                    'productos'      => $array_productos,
                    'subcategorias'  => $array_subcategoria
                ];
            }
        }

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 15,
            'margin_right'      => 15,
            'margin_top'        => 35,
            'margin_bottom'     => 20,
            'margin_header'     => 15,
            'margin_footer'     => 15,
            'format'            => 'A4',
            'orientation'       => 'P',
            'default_font_size' => 8,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle('Productos');
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject('Productos tarifas');

        $html_header = Vista::viewPDF('productos/pdf/listado_productos/header.php', [
            'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
            'emp_rif'       => $empresa_data['emp_rif'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
            'emp_estado'    => $empresa_data['emp_estado'] ?? '',
            'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
        ]);

        $mpdf->SetHTMLHeader($html_header);

        $html_footer = Vista::viewPDF('productos/pdf/listado_productos/footer.php', [
            'tar_nombre'    => $tarifa_data['tar_nombre'],
        ]);

        $mpdf->SetHTMLFooter($html_footer);

        $html_body = Vista::viewPDF('productos/pdf/listado_productos/body.php', [
            'productos'     => $array_lista,
            'tar_nombre'    => $tarifa_data['tar_nombre'],
        ]);

        $mpdf->WriteHTML(utf8_encode($html_body));

        $mpdf->Output("productos_tarifas.pdf", \Mpdf\Output\Destination::INLINE);
        exit;
    }

    public function listado_productosImagen_pdf(int $id_tarifa)
    {
        $id_tarifa = filter_var($id_tarifa, FILTER_SANITIZE_NUMBER_INT);

        $tarifa_data = $this->productos->obtenerTarifa($id_tarifa);

        if (!$tarifa_data) {
            Http::notFound();
        }

        $new_pro_categoria  = new ProductoCategoria();
        $proImagen = new ProductosImagen();
        $empresa_data       = $this->productos->obtenerDatosEmpresa();
        $categorias         = $this->productos->obtenerCategoriasPadre();
        $array_productos    = [];
        $array_subcategoria = [];
        $array_lista = [];

        foreach ($categorias as $row) {
            $array_productos = [];
            $array_subcategoria = [];
            //$product=[];
            $productos =  $new_pro_categoria->obtenerProductosCategoria($row['cat_id']);
            $subcategorias = $new_pro_categoria->obtenerSubCategorias($row['cat_id']);

            foreach ($productos as $pro) {
                $tarifas_productos = $this->productos->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$pro['pro_id']} AND pt_tarid={$id_tarifa}")->row();
                $imagens_p = $proImagen->obtenerImagenId($pro['pro_id']);
                if ($tarifas_productos) {
                    $monto_tarifa = $tarifas_productos['pt_tarprecio'];
                    if ($monto_tarifa > 0) {
                        $precio_total = $monto_tarifa;
                    } else {
                        $impuesto = $this->productos->obtenerproImp($pro['pro_id']);

                        if ('pvp' == $tarifa_data['tar_aplicar'] || 'pvpiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($pro['pro_precio'] * ($impuesto['imp_valor'] / 100));
                        }
                        if ('costo' == $tarifa_data['tar_aplicar'] || 'costoiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($pro['pro_costo'] * ($impuesto['imp_valor'] / 100));
                        }
                        $precio_total = TarifasControlador::aplicar($pro['pro_costo'], $pro['pro_precio'], $tarifa_data['tar_aplicar'], $tarifa_data['tar_valorx'], $tarifa_data['tar_valory'], $iva_m);
                    }
                    if (count($imagens_p) > 0) {
                        $images = ($imagens_p[0]['pi_imagen'] != NULL) ? constant('IMG_URI') . 'productos/' . $imagens_p[0]['pi_imagen'] : constant('IMG_URI') . 'productos/150x150.png';
                    }

                    $array_productos[] = [
                        'descripcion'   => $pro['pro_descripcion'],
                        'costo'         => $pro['pro_costo'],
                        'venta'         => $pro['pro_precio'],
                        'imagen'        => $images,
                        'ta_nombre'     => $tarifa_data['tar_nombre'],
                        'tarifa'        => Moneda::moneda($precio_total, $this->div_master['div_locale'], $this->div_master['div_simbolo'])
                    ];
                }
            }

            foreach ($subcategorias as $row2) {
                $productosp =  $new_pro_categoria->obtenerProductosCategoria($row2['cat_id']);
                $product = [];
                foreach ($productosp as $pro) {
                    $tarifas_productos = $this->productos->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$pro['pro_id']} AND pt_tarid={$id_tarifa}")->row();
                    $imagens_p = $proImagen->obtenerImagenId($pro['pro_id']);
                    if ($tarifas_productos) {
                        $monto_tarifa = $tarifas_productos['pt_tarprecio'];
                        if ($monto_tarifa > 0) {
                            $precio_total = $monto_tarifa;
                        } else {
                            $impuesto = $this->productos->obtenerproImp($pro['pro_id']);
                            if ('pvp' == $tarifa_data['tar_aplicar'] || 'pvpiva' == $tarifa_data['tar_aplicar']) {
                                $iva_m = ($pro['pro_precio'] * ($impuesto['imp_valor'] / 100));
                            }
                            if ('costo' == $tarifa_data['tar_aplicar'] || 'costoiva' == $tarifa_data['tar_aplicar']) {
                                $iva_m = ($pro['pro_costo'] * ($impuesto['imp_valor'] / 100));
                            }

                            $precio_total = TarifasControlador::aplicar($pro['pro_costo'], $pro['pro_precio'], $tarifa_data['tar_aplicar'], $tarifa_data['tar_valorx'], $tarifa_data['tar_valory'], $iva_m);
                        }
                        if (count($imagens_p) > 0) {
                            $images = ($imagens_p[0]['pi_imagen'] != NULL) ? constant('IMG_URI') . 'productos/' . $imagens_p[0]['pi_imagen'] : constant('IMG_URI') . 'productos/150x150.png';
                        } else {
                            $images = constant('IMG_URI') . 'productos/150x150.png';
                        }

                        $product[] = [
                            'descripcion'   => $pro['pro_descripcion'],
                            'costo'         => $pro['pro_costo'],
                            'venta'         => $pro['pro_precio'],
                            'imagen'        => $images,
                            'ta_nombre'     => $tarifa_data['tar_nombre'],
                            'tarifa'        => Moneda::moneda($precio_total, $this->div_master['div_locale'], $this->div_master['div_simbolo'])
                        ];
                    }
                }

                if (count($product) > 0) {
                    $array_subcategoria[] = [
                        'subcategoria'   => $row2['cat_nombre'],
                        'productos'     => $product,
                    ];
                }
            }

            if (count($array_subcategoria) > 0 || count($array_productos) > 0) {
                $array_lista[] = [
                    'nombre'   => $row['cat_nombre'],
                    'productos'      => $array_productos,
                    'subcategorias'  => $array_subcategoria
                ];
            }
        }

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 15,
            'margin_right'      => 15,
            'margin_top'        => 35,
            'margin_bottom'     => 20,
            'margin_header'     => 15,
            'margin_footer'     => 15,
            'format'            => 'A4',
            'orientation'       => 'P',
            'default_font_size' => 8,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle('Productos');
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject('Productos tarifas');

        $html_header = Vista::viewPDF('productos/pdf/listado_productos/header.php', [
            'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
            'emp_rif'       => $empresa_data['emp_rif'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
            'emp_estado'    => $empresa_data['emp_estado'] ?? '',
            'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
        ]);

        $mpdf->SetHTMLHeader($html_header);

        $html_footer = Vista::viewPDF('productos/pdf/listado_productos/footer.php', [
            'tar_nombre'    => $tarifa_data['tar_nombre'],
        ]);

        $mpdf->SetHTMLFooter($html_footer);

        $html_body = Vista::viewPDF('productos/pdf/listado_productos/body_imagen.php', [
            'productos'     => $array_lista,
            'tar_nombre'    => $tarifa_data['tar_nombre'],
        ]);

        $mpdf->WriteHTML(utf8_encode($html_body));

        $mpdf->Output("productos_tarifas.pdf", \Mpdf\Output\Destination::INLINE);
        exit;
    }
    
     public function listado_productosImagen_pdfCate()
    {
      if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

        $id_tarifa = filter_input(INPUT_POST, 'tarifa', FILTER_SANITIZE_STRING);

        $tarifa_data = $this->productos->obtenerTarifa($id_tarifa);

        if (!$tarifa_data) {
            Http::notFound();
        }

        $new_pro_categoria  = new ProductoCategoria();
        $proImagen = new ProductosImagen();
        $empresa_data       = $this->productos->obtenerDatosEmpresa();
        $catid= json_decode($_POST['categ'], true);
        $categorias         = $this->productos->obtenerCategoriasPadre();
        $array_productos    = [];
        $array_subcategoria = [];
        $array_lista = [];
        $array_listaca = [];

         foreach ($catid as $categoria) {
            $row = $this->productos->consultar("SELECT * FROM app_categorias WHERE cat_id={$categoria}")->row();
            $array_productos = [];
            $array_subcategoria = [];
            
            //$product=[];
            $productos =  $new_pro_categoria->obtenerProductosCategoria($row['cat_id']);
            $subcategorias = $new_pro_categoria->obtenerSubCategorias($row['cat_id']);

            foreach ($productos as $pro) {
                $tarifas_productos = $this->productos->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$pro['pro_id']} AND pt_tarid={$id_tarifa}")->row();
                $imagens_p = $proImagen->obtenerImagenId($pro['pro_id']);
                if ($tarifas_productos) {
                    $monto_tarifa = $tarifas_productos['pt_tarprecio'];
                    if ($monto_tarifa > 0) {
                        $precio_total = $monto_tarifa;
                    } else {
                        $impuesto = $this->productos->obtenerproImp($pro['pro_id']);

                        if ('pvp' == $tarifa_data['tar_aplicar'] || 'pvpiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($pro['pro_precio'] * ($impuesto['imp_valor'] / 100));
                        }
                        if ('costo' == $tarifa_data['tar_aplicar'] || 'costoiva' == $tarifa_data['tar_aplicar']) {
                            $iva_m = ($pro['pro_costo'] * ($impuesto['imp_valor'] / 100));
                        }
                        $precio_total = TarifasControlador::aplicar($pro['pro_costo'], $pro['pro_precio'], $tarifa_data['tar_aplicar'], $tarifa_data['tar_valorx'], $tarifa_data['tar_valory'], $iva_m);
                    }
                    if (count($imagens_p) > 0) {
                        $images = ($imagens_p[0]['pi_imagen'] != NULL) ? constant('IMG_URI') . 'productos/' . $imagens_p[0]['pi_imagen'] : constant('IMG_URI') . 'productos/150x150.png';
                    }

                    $array_productos[] = [
                        'descripcion'   => $pro['pro_descripcion'],
                        'costo'         => $pro['pro_costo'],
                        'venta'         => $pro['pro_precio'],
                        'imagen'        => $images,
                        'ta_nombre'     => $tarifa_data['tar_nombre'],
                        'tarifa'        => Moneda::moneda($precio_total, $this->div_master['div_locale'], $this->div_master['div_simbolo'])
                    ];
                }
            }

            foreach ($subcategorias as $row2) {
                 if ((!in_array($row2['cat_id'], $array_listaca))) {
                    $productosp =  $new_pro_categoria->obtenerProductosCategoria($row2['cat_id']);
                    $product = [];
                    foreach ($productosp as $pro) {
                        $tarifas_productos = $this->productos->consultar("SELECT * FROM app_productos_tarifas WHERE pt_proid={$pro['pro_id']} AND pt_tarid={$id_tarifa}")->row();
                        $imagens_p = $proImagen->obtenerImagenId($pro['pro_id']);
                        if ($tarifas_productos) {
                            $monto_tarifa = $tarifas_productos['pt_tarprecio'];
                            if ($monto_tarifa > 0) {
                                $precio_total = $monto_tarifa;
                            } else {
                                $impuesto = $this->productos->obtenerproImp($pro['pro_id']);
                                if ('pvp' == $tarifa_data['tar_aplicar'] || 'pvpiva' == $tarifa_data['tar_aplicar']) {
                                    $iva_m = ($pro['pro_precio'] * ($impuesto['imp_valor'] / 100));
                                }
                                if ('costo' == $tarifa_data['tar_aplicar'] || 'costoiva' == $tarifa_data['tar_aplicar']) {
                                    $iva_m = ($pro['pro_costo'] * ($impuesto['imp_valor'] / 100));
                                }
    
                                $precio_total = TarifasControlador::aplicar($pro['pro_costo'], $pro['pro_precio'], $tarifa_data['tar_aplicar'], $tarifa_data['tar_valorx'], $tarifa_data['tar_valory'], $iva_m);
                            }
                            if (count($imagens_p) > 0) {
                                $images = ($imagens_p[0]['pi_imagen'] != NULL) ? constant('IMG_URI') . 'productos/' . $imagens_p[0]['pi_imagen'] : constant('IMG_URI') . 'productos/150x150.png';
                            } else {
                                $images = constant('IMG_URI') . 'productos/150x150.png';
                            }
    
                            $product[] = [
                                'descripcion'   => $pro['pro_descripcion'],
                                'costo'         => $pro['pro_costo'],
                                'venta'         => $pro['pro_precio'],
                                'imagen'        => $images,
                                'ta_nombre'     => $tarifa_data['tar_nombre'],
                                'tarifa'        => Moneda::moneda($precio_total, $this->div_master['div_locale'], $this->div_master['div_simbolo'])
                            ];
                        }
                    }
    
                    if (count($product) > 0) {
                        $array_subcategoria[] = [
                            'subcategoria'   => $row2['cat_nombre'],
                            'productos'     => $product,
                        ];
                    }
                    $array_listaca[] =$row2['cat_id'];
                 }
            }

           if ((!in_array($row['cat_id'], $array_listaca))) {
                if (count($array_subcategoria) > 0 || count($array_productos) > 0) {
                    $array_lista[] = [
                        'nombre'   => $row['cat_nombre'],
                        'productos'      => $array_productos,
                        'subcategorias'  => $array_subcategoria
                    ];
                }
            $array_listaca[] =$row['cat_id'];
           }
        }

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 15,
            'margin_right'      => 15,
            'margin_top'        => 35,
            'margin_bottom'     => 20,
            'margin_header'     => 15,
            'margin_footer'     => 15,
            'format'            => 'A4',
            'orientation'       => 'P',
            'default_font_size' => 8,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle('Productos');
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject('Productos tarifas');
     
        $mpdf->SetCompression(true);

        $html_header = Vista::viewPDF('productos/pdf/listado_productos/header.php', [
            'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
            'emp_rif'       => $empresa_data['emp_rif'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
            'emp_estado'    => $empresa_data['emp_estado'] ?? '',
            'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
        ]);

        $mpdf->SetHTMLHeader($html_header);

        $html_footer = Vista::viewPDF('productos/pdf/listado_productos/footer.php', [
            'tar_nombre'    => $tarifa_data['tar_nombre'],
        ]);

        $mpdf->SetHTMLFooter($html_footer);

        $html_body = Vista::viewPDF('productos/pdf/listado_productos/body_imagen.php', [
            'productos'     => $array_lista,
            'tar_nombre'    => $tarifa_data['tar_nombre'],
        ]);

        $mpdf->WriteHTML(utf8_encode($html_body));

        $mpdf->Output("productos_tarifas.pdf", \Mpdf\Output\Destination::INLINE);
        exit;
    }
    }

    public function listado_productos_pdfPrec()
    {
        $productos = $this->productos->obtenerProductosSinServicio();

        $empresa = $this->productos->consultar("SELECT * FROM app_empresas")->row();
        $array_productos = [];
        if (is_countable($productos) && count($productos)) {

            foreach ($productos as $row) {

                $factor_master = 0;
                $data_factor = Moneda::obtenerFactor(2, 1);
                if ($data_factor) {
                    $factor_master = $data_factor['df_factor'];
                }

                $precBs = $row['pro_precio'] * $factor_master;
                $string = float_a_string($precBs);
                $numero = number_format($string, 2);
                $numero = str_replace('.', '', $numero);
                $numero = str_replace(',', '', $numero);
                $precBsd = $numero . '0000';
                $impuesto = $this->productos->obtenerproImp($row['pro_id']);
                $stock = $this->productos->obtenerProductosSinServicioStock($row['pro_id']);

                $array_productos[] = [
                    'pro_id'            => $row['pro_id'],
                    'pro_codigo'        => $row['pro_codigo'],
                    'pro_descripcion'   => $row['pro_descripcion'],
                    'pro_costo'         => Moneda::moneda($row['pro_costo'], $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                    'pro_precio'        => Moneda::moneda($row['pro_precio'], $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                    'pro_precbss'       => Moneda::moneda($precBs, 'de-DE', 'BsS'),
                    'pro_precbsd'       => Moneda::moneda($precBsd, 'de-DE', 'BsD'),
                ];
            }
        }

        if (!$productos) {
            Http::notFound();
        }

        $empresa_data       = $this->productos->obtenerDatosEmpresa();

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 15,
            'margin_right'      => 15,
            'margin_top'        => 35,
            'margin_bottom'     => 20,
            'margin_header'     => 15,
            'margin_footer'     => 15,
            'format'            => 'A4',
            'orientation'       => 'P',
            'default_font_size' => 8,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle('Productos');
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject('Productos tarifas');

        $html_header = Vista::viewPDF('productos/pdf/listado_productos/header.php', [
            'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
            'emp_rif'       => $empresa_data['emp_rif'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
            'emp_estado'    => $empresa_data['emp_estado'] ?? '',
            'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
        ]);

        $mpdf->SetHTMLHeader($html_header);

        $html_footer = Vista::viewPDF('productos/pdf/listado_productos/footer.php', [
            'tar_nombre'    => 'Listado de productos',
        ]);

        $mpdf->SetHTMLFooter($html_footer);

        $html_body = Vista::viewPDF('productos/pdf/listado_productos/body_precio.php', [
            'productos'     => $array_productos,
        ]);

        $mpdf->WriteHTML($html_body);

        $mpdf->Output("listado_prodcutos_precios.pdf", \Mpdf\Output\Destination::INLINE);
        exit;
    }

    public function eliminarImagen()
    {
        if ($this->module->has_module_action_permission('productos', 'eliminar', $_SESSION['user_data']['emp_id'])) {

            $pi_id = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);

            $pro_imagen = new ProductosImagen();
            $imagen = $pro_imagen->obtenerImagen($pi_id);

            $ruta = constant('UPLOADS_URI') . 'productos/' .  $imagen['pi_imagen'];

            if ($pro_imagen->eliminar($pi_id)) {
                unlink($ruta);

                Http::json_response(true);
            } else {
                Http::json_response(false);
            }
        } else {
            $this->array_errors[] = 'Acceso prohibido no posee permisos para eliminar productos.';
        }

        Http::json_response(['errors' => $this->array_errors]);
    }

    public function buscarLineas()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $buscar = filter_input(INPUT_GET, 'buscar', FILTER_SANITIZE_STRING);
            $filtro = filter_input(INPUT_GET, 'filtro', FILTER_SANITIZE_NUMBER_INT);
            $buscar = strtolower($buscar);

            $timeZone = new DateTimeZone('America/Caracas');
            $fecha_desde = (new DateTime(null, $timeZone))->modify('first day of last month')->format('Y-m-d');
            $fecha_hasta = date('Y-m-d');

            $array_lineas = [];
            $notas = $this->transferencia->buscarLineas(trim($buscar), $filtro, $fecha_desde, $fecha_hasta);

            foreach ($notas as $row) {
                $array_lineas[] = [
                    'id'                => $row['ptr_id'],
                    'ruta'              => ruta_base() . 'stock/detalle_transferencia/' . $row['ptr_id'],
                    'origen'            => $row['origen'],
                    'destino'           => $row['destino'],
                    'ruta_producto'     => ruta_base() . 'productos/editar/' . $row['pro_id'],
                    'cantidad'          => $row['ptd_cantidad'],
                    'art_codigo'        => $row['pro_codigo'],
                    'art_nombre'        => $row['pro_descripcion'],
                    'fecha'             => $row['fecha'],
                    'estatus'           => $row['ptr_estatus']
                ];
            }

            Http::json_response($array_lineas);
        }
    }

    public function obtenerCodigosDeBarra(int $id_producto)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newCodBarra = new ProductoCodBarra();
            Http::json_response($newCodBarra->obtenerCodigosDeBarra($id_producto));
        }
    }

    public function guardarCodBarra()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax() && (!empty($_GET['id']) && !empty($_GET['codbarra']))) {
            $id_producto = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
            $cod_barra = $this->solicitud->sanitize($_GET['codbarra'], FILTER_SANITIZE_STRING);
            if ($id_producto && $cod_barra) {

                if (strlen($cod_barra) > 13) {
                    $this->array_errors[] = 'El codigo de barra supera la cantidad de numeros permitidos';
                }

                if (empty($this->array_errors)) {
                    if ($this->productos->existe('pro_id', $id_producto)) {
                        $newCodBarra = new ProductoCodBarra();
                        try {
                            if ($newCodBarra->codBarraExiste($cod_barra)) {
                                $this->array_errors[] = 'Lo siento el código de barras que intenta guardar ya se encuentra registrado.';
                            } else {
                                Http::json_response($newCodBarra->guardar([
                                    'pc_codigo' => $cod_barra,
                                    'pc_proid' => $id_producto
                                ], true));
                            }
                        } catch (\Throwable $th) {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                }
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }
            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eliminarCodBarra(int $id_codbarra)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id_codbarra = filter_var($id_codbarra, FILTER_SANITIZE_NUMBER_INT);
            $newCodBarra = new ProductoCodBarra();
            if ($newCodBarra->existe('pc_id', $id_codbarra)) {
                Http::json_response($newCodBarra->eliminar($id_codbarra));
            }
        }
    }

    public function obtenerAlmacenesSegunProducto(int $id_producto)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $newStock = new Stock();
            Http::json_response($newStock->obtenerAlmacenesSegunProducto($id_producto));
        }
    }

    public function guardarUbicacion()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_producto = filter_input(INPUT_POST, 'id_producto', FILTER_SANITIZE_NUMBER_INT);
            $id_ubicacion = filter_input(INPUT_POST, 'id_ubicacion', FILTER_SANITIZE_NUMBER_INT);
            $id_almacen = filter_input(INPUT_POST, 'id_almacen', FILTER_SANITIZE_NUMBER_INT);

            $newProUbi = new ProductoUbicacion();

            Http::json_response($newProUbi->guardar([
                'pu_almid' => $id_almacen,
                'pu_proid' => $id_producto,
                'pu_auid' => $id_ubicacion,
                'pu_empid' => $_SESSION['user_data']['emp_id']
            ], true));
        }
    }

    public function obtenerUbicacionesProducto(int $id_producto)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newProUbi = new ProductoUbicacion();
            $newAU = new AlmacenUbicacion();
            $tipo_de_escalon = [];
            $lista = [];
            $ubicacion = $newProUbi->obtenerubicacionProducto($id_producto);

            $array_tipo = [
                'Zonas' => 'Zona',
                'Pasillos' => 'Pasillo',
                'Armarios' => 'Armario',
                'Secciones' => 'Sección',
                'Cajones' => 'Cajón'
            ];

            if (is_countable($ubicacion) && count($ubicacion)) {

                foreach ($ubicacion as $row) {

                    $tipo_de_escalon = [];
                    $padre = $row['au_padre'];

                    $tipo_de_escalon[] = [
                        'id' => $row['au_id'],
                        'tipo' => $array_tipo[$row['au_tipo']],
                        'descripcion' => $row['au_descripcion']
                    ];

                    while ($padre != 0) {
                        $escalon = $newAU->obtenerUbicacion($padre);
                        if ($escalon) {
                            $tipo_de_escalon[] = [
                                'id' => $escalon['au_id'],
                                'tipo' => $array_tipo[$escalon['au_tipo']],
                                'descripcion' => $escalon['au_descripcion']
                            ];
                            $padre = $escalon['au_padre'];
                        } else {
                            $padre = 0;
                        }
                    }

                    $lista[] = [
                        'almacen' => [
                            'id' => $row['alm_id'],
                            'descripcion' => $row['alm_nombre']
                        ],
                        'ubicacion' => $tipo_de_escalon
                    ];
                }
            }

            Http::json_response($lista);
        }
    }

    //WOOCOMMERCE
    private function subirAWoocommerce($pro_id)
    {
        $array_mensajes = [];

        $this->woocommerce = new Client(
            constant('WCURL'),
            constant('WCKEY'),
            constant('WCSECRECT'),
            [
                'wp_api'    => true,
                'version'   => 'wc/v3',
                'timeout'   => 30
            ]
        );

        $woocor = $this->productos->consultar("SELECT * FROM app_wc")->row();

        $productoImagen     = new ProductosImagen();
        $productoCategoria  = new ProductoCategoria();

        $producto       = $this->productos->obtenerproImp($pro_id);
        $pro_imagenes   = $productoImagen->obtenerProductoImagenes($pro_id);
        $pro_categorias = $productoCategoria->obtenerCategoriasProducto($pro_id);

        $data_form = [
            'slug'          => $producto['pro_descripcion'],
            'sku'           => $producto['pro_id'],
            'name'          => $producto['pro_descripcion'],
            'type'          => 'simple',
            'price'         => ($woocor['wc_precio'] == 1) ? float_a_string($producto['pro_precio'] + ($producto['pro_precio'] * ($producto['imp_valor'] / 100))) : $producto['pro_precio'],
            'regular_price' => ($woocor['wc_precio'] == 1) ? float_a_string($producto['pro_precio'] + ($producto['pro_precio'] * ($producto['imp_valor'] / 100))) : $producto['pro_precio'],
            'status'        => 'private'
        ];
        // 'description'   => $producto['pro_observaciones'],
        if (defined('WCDESCRIPTION') && constant('WCDESCRIPTION') == 0) {
            // $data_form['short_description'] = $producto['pro_observaciones'];
        }

        if (is_countable($pro_categorias) && count($pro_categorias)) {
            foreach ($pro_categorias as $row) {
                $data_form['categories'][] = [
                    'id' => $row['cat_wooc']
                ];
            }
        }

        if (is_countable($pro_imagenes) && count($pro_imagenes)) {
            $i = 0;
            foreach ($pro_imagenes as $item) {
                $i++;
                $img = constant('WCIMG') . $item['pi_imagen'];
                $data_form['images'][] = [
                    "src" => $img,
                    "position" => $i
                ];
            }
        }

        if ($producto['pro_nostock'] == 1 && $producto['pro_publico'] == 1) {
            $data_form['status'] = 'publish';
        } elseif ($producto['pro_nostock'] == 0 && $producto['pro_publico'] == 1) {
            $total_stock = $this->productos->obtenerTotalStockProducto($pro_id);
            if ($total_stock['total_stock'] > 0) {
                $data_form['status'] = 'publish';
            } else {
                $data_form['status'] = 'private';
            }
        }

        try {
            $wcproducto = $this->woocommerce->get('products', ['sku' => $pro_id]);

            if ($wcproducto !== []) {
                //ACTUALIZA
                try {
                    //unset($data_form['slug']);
                    $this->woocommerce->put('products/' . $wcproducto[0]->id, $data_form);
                    if ($data_form['status'] == 'publish') {
                        $array_mensajes[] = 'Producto publicado en woocommerce';
                    } else {
                        $array_mensajes[] = 'Producto no publicado en woocommerce ya que no cuenta con stock o el status ha sido modificado a privado';
                    }
                } catch (HttpClientException $e) {
                    $array_mensajes[] = $e->getMessage();
                }
                return $array_mensajes;
            } else {
                //CREA
                if ($data_form['status'] == 'publish' && is_countable($pro_imagenes) && count($pro_imagenes) && is_countable($pro_categorias) && count($pro_categorias)) {
                    try {
                        $this->woocommerce->post('products', $data_form);
                        $array_mensajes[] = 'Producto publicado en woocommerce';
                    } catch (HttpClientException $e) {
                        $array_mensajes[] = $e->getMessage();
                    }
                    return $array_mensajes;
                } else {
                    $array_mensajes[] = 'Lo siento el producto debe tener precio, imagen, categoria y stock para poder subirlo a woocommerce';
                    return $array_mensajes;
                }
            }
        } catch (HttpClientException $e) {
            $array_mensajes[] = $e->getMessage();
        }

        return $array_mensajes;
    }

    public function obtenerClientesporProductos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $fecha_desde    = filter_input(INPUT_GET, 'fecha_desde', FILTER_SANITIZE_STRING);
            $fecha_hasta    = filter_input(INPUT_GET, 'fecha_hasta', FILTER_SANITIZE_STRING);
            $id      = filter_input(INPUT_GET, 'id');

            if (empty($fecha_desde))
                $fecha_desde = (new DateTime(null, $this->timeZone))->modify('first day of this month')->format('Y-m-d');

            if (empty($fecha_hasta))
                $fecha_hasta = date('Y-m-d');

            if (empty($this->array_errors)) {

                if (!validateDate($fecha_desde, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha desde es incorrecta.';
                if (!validateDate($fecha_hasta, 'Y-m-d'))
                    $this->array_errors[] = 'La Fecha hasta es incorrecta.';

                if (empty($this->array_errors)) {


                    $totales_productos  = [];

                    $total_notas = $this->productos->obtenerArticulosDeNEV($fecha_desde, $fecha_hasta, $id);
                    $total_facv = $this->productos->obtenerArticulosDeFACV($fecha_desde, $fecha_hasta, $id);

                    if (is_countable($total_notas) && count($total_notas)) {
                        foreach ($total_notas as $row) {

                            $pro =  $this->productos->obtener($row['proid']);


                            $descuento = ($row['precio'] * $row['descuento']) / 100;

                            $totales_productos[] = [
                                'cliente'   => $row['cli_razon_social'],
                                'dni'   => $row['cli_dni'],
                                'email'   => $row['cli_email'],
                                'telefono'   => $row['cli_telefono'] . ' / ' . $row['cli_telefono_2'],
                                'uri_clients'   => ruta_base() . 'clientes/ver/' . $row['cli_id'],
                                'precio_venta'      => Moneda::moneda($pro['pro_precio'], $row['div_locale'], $row['div_simbolo']),
                                'precio_factura'    => Moneda::moneda($row['precio'], $row['div_locale'], $row['div_simbolo']),
                                'precio_desc'       => $descuento,
                                'descuento'         => $row['descuento'],
                                'cantidad'          => $row['cantidad'],
                                'costo_total'       => $pro['pro_costo'] * $row['cantidad'],
                                'total'             => Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']),
                                'tipo'              => 'NEV',
                                'correlativo'       => $row['correlativo'],
                                'fecha'             => $row['fecha'],
                                'sucursal'          => $row['su_nombre'],
                                'url'               =>  ruta_base() . 'notasdeentregaeditar/verFactura/' . $row['id']
                            ];
                        }
                    }

                    if (is_countable($total_facv) && count($total_facv)) {

                        foreach ($total_facv as $row_dos) {

                            $pro =  $this->productos->obtener($row['proid']);

                            $descuento = ($row['precio'] * $row['descuento']) / 100;

                            $totales_productos[] = [
                                'cliente'   => $row['cli_razon_social'],
                                'dni'   => $row['cli_dni'],
                                'email'   => $row['cli_email'],
                                'telefono'   => $row['cli_telefono'] . ' / ' . $row['cli_telefono_2'],
                                'uri_clients'   => ruta_base() . 'clientes/ver/' . $row['cli_id'],
                                'precio_venta'      => Moneda::moneda($pro['pro_precio'], $row['div_locale'], $row['div_simbolo']),
                                'precio_factura'    => Moneda::moneda($row['precio'], $row['div_locale'], $row['div_simbolo']),
                                'precio_desc'       => $descuento,
                                'descuento'         => $row['descuento'],
                                'cantidad'          => $row['cantidad'],
                                'costo_total'       => $pro['pro_costo'] * $row['cantidad'],
                                'total'             => Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']),
                                'tipo'              => 'FACV',
                                'correlativo'       => $row['correlativo'],
                                'fecha'             => $row['fecha'],
                                'sucursal'          => $row['su_nombre'],
                                'url'               => ruta_base() . 'poseditar/verFactura/' . $row['id']
                            ];
                        }
                    }


                    Http::json_response([
                        'productos'     => $totales_productos
                    ]);
                }
            }

            Http::json_response([
                'errors'   => $this->array_errors,
            ]);
        }
    }

    public function obtenerPrecioCompra(int $id)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $compras = new Compras();
            $notas = $compras->obtenerHistoriaNotasCompras($id);
            $facturas = $compras->obtenerHistoriaFacturasCompras($id);
            $historial = [];

            if (is_countable($notas) && count($notas) > 0) {
                foreach ($notas as $row) {
                    // if (!in_array($row['prov_id'], $proveedor)) {
                    $precio = 0;

                    if ($row['cmpn_divid'] != $this->div_master['div_id']) {
                        $factor_master = 0;
                        $data_factor = Moneda::obtenerFactor($row['cmpn_divid'], $this->div_master['div_id']);
                        if ($data_factor) {
                            $factor_master = $data_factor['df_factor'];
                            $precio = $row['cmpnart_proprecio'] * $factor_master;
                        }
                    } else {
                        $precio = $row['cmpnart_proprecio'];
                    }

                    $historial[] = [
                        "id" => $row['cmpn_id'],
                        "documento" => "NEC" . $row['cmpn_correlativo'],
                        "precio" => Moneda::moneda($precio, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        "fecha" => $row['cmpn_fecha'],
                        "proveedor" => $row['prov_razonsocial'],
                        "uri" => ruta_base() . 'cmpnotaseditar/verFactura/' . $row['cmpn_id']
                    ];
                }
            }

            if (is_countable($facturas) && count($facturas) > 0) {
                foreach ($facturas as $row) {
                    // if (!in_array($row['prov_id'], $proveedor)) {
                    $precio = 0;

                    if ($row['cmp_divid'] != $this->div_master['div_id']) {
                        $factor_master = 0;
                        $data_factor = Moneda::obtenerFactor($row['cmp_divid'], $this->div_master['div_id']);
                        if ($data_factor) {
                            $factor_master = $data_factor['df_factor'];
                            $precio = $row['cmpart_proprecio'] * $factor_master;
                        }
                    } else {
                        $precio = $row['cmpart_proprecio'];
                    }

                    $historial[] = [
                        "id" => $row['cmp_id'],
                        "documento" => "FACC" . $row['cmp_correlativo'],
                        "precio" => Moneda::moneda($precio, $this->div_master['div_locale'], $this->div_master['div_simbolo']),
                        "fecha" => $row['cmp_fecha'],
                        "proveedor" => $row['prov_razonsocial'],
                        "uri" => ruta_base() . 'cmpfactura/verFactura/' . $row['cmp_id']
                    ];
                }
            }



            Http::json_response($historial);
        }
    }

    public function sticket_productos_pdf(int $id_categoria)
    {
        $categ = new ProductoCategoria();

        $id_categoria = filter_var($id_categoria, FILTER_SANITIZE_NUMBER_INT);

        $productos = $categ->obtenerProductosCategoriaSticket($id_categoria);

        $empresa = $this->productos->consultar("SELECT * FROM app_empresas")->row();
        $factCompra = $empresa['emp_iva'];

        if (!$productos) {
            Http::notFound();
        }

        $array_productos = [];

        if (is_countable($productos) && count($productos)) {

            foreach ($productos as $row) {

                $impuesto = $this->productos->obtenerproImp($row['pro_id']);
                $stock = $this->productos->obtenerProductosSinServicioStock($row['pro_id']);

                $array_productos[] = [
                    'pro_id'            => $row['pro_id'],
                    'pro_codigo'        => $row['pro_codigo'],
                    'pro_descripcion'   => $row['pro_descripcion'],
                    'fa_nombre'         => $row['fa_nombre'],
                    'cantidad'          =>  round($stock['cantidad'], 2),
                    'pro_precio'        => Moneda::moneda(round(convertir_a_float($row['pro_precio'] + ($row['pro_precio'] * ($impuesto['imp_valor'] / 100))), 2), 'de-DE', ' '),
                    'pro_publico'       => $row['pro_publico']
                ];
            }
        }

        $empresa_data       = $this->productos->obtenerDatosEmpresa();
        $categorias         = $this->productos->obtenerCategorias();

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 15,
            'margin_right'      => 15,
            'margin_top'        => 10,
            'margin_bottom'     => 20,
            'margin_header'     => 15,
            'margin_footer'     => 15,
            'format'            => 'A4',
            'orientation'       => 'P',
            'default_font_size' => 8,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle('Productos');
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject('Productos el');


        $html_body = Vista::viewPDF('productos/pdf/sticket/body.php', [
            'productos'     => $array_productos,
            'tar_nombre'    => "",
        ]);

        $mpdf->WriteHTML($html_body);

        $mpdf->Output("productos_sticket.pdf", \Mpdf\Output\Destination::INLINE);
        exit;
    }

    public function sticket_unproducto_pdf(int $id)
    {
        $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

        $productos = $this->productos->obtener($id);

        $empresa = $this->productos->consultar("SELECT * FROM app_empresas")->row();
        $factCompra = $empresa['emp_iva'];

        if (!$productos) {
            Http::notFound();
        }

        $array_productos = [];

        if ($productos) {

            $impuesto = $this->productos->obtenerproImp($productos['pro_id']);
            $stock = $this->productos->obtenerProductosSinServicioStock($productos['pro_id']);
            $barra= $newCodBarra = new ProductoCodBarra();
            $Barra=$barra->obtenerCodigosDeBarra($productos['pro_id']);
            $barrac=$Barra[0]['codigo'];
            $array_productos[] = [
                'pro_id'            => $productos['pro_id'],
                'pro_codigo'        => $productos['pro_codigo'],
                'pro_descripcion'   => $productos['pro_descripcion'],
                'fa_nombre'         => $productos['fa_nombre'],
                'cantidad'          =>  round($stock['cantidad'], 2),
                'pro_precio'        => Moneda::moneda(round(convertir_a_float($productos['pro_precio'] + ($productos['pro_precio'] * ($impuesto['imp_valor'] / 100))), 2), 'de-DE', ' '),
                'pro_publico'       => $productos['pro_publico'],
                'pro_barra'         =>$barrac
            ];
        }

        $empresa_data       = $this->productos->obtenerDatosEmpresa();
        $categorias         = $this->productos->obtenerCategorias();

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 1,
            'margin_right'      => 1,
            'margin_top'        => 0,
            'format'            => [80, 150],
            'orientation'       => 'P',
            'default_font_size' => 10,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle('Productos');
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject('Productos el');


        $html_body = Vista::viewPDF('productos/pdf/sticket/body_sticket.php', [
            'productos'     => $array_productos,
            'tar_nombre'    => "",
        ]);

        $mpdf->WriteHTML($html_body);

        $mpdf->Output("productos_sticket.pdf", \Mpdf\Output\Destination::INLINE);
        exit;
    }
    public function sticket_unproducto_pdf_etiqueta(int $id)
    {
        $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

        $productos = $this->productos->obtener($id);

        $empresa = $this->productos->consultar("SELECT * FROM app_empresas")->row();
        $factCompra = $empresa['emp_iva'];

        if (!$productos) {
            Http::notFound();
        }

        $array_productos = [];

        if ($productos) {

            $impuesto = $this->productos->obtenerproImp($productos['pro_id']);
            $stock = $this->productos->obtenerProductosSinServicioStock($productos['pro_id']);
            $barra= $newCodBarra = new ProductoCodBarra();
            $Barra=$barra->obtenerCodigosDeBarra($productos['pro_id']);
            $barrac=$Barra[0]['codigo'];
            $array_productos[] = [
                'pro_id'            => $productos['pro_id'],
                'pro_codigo'        => $productos['pro_codigo'],
                'pro_descripcion'   => $productos['pro_descripcion'],
               // 'fa_nombre'         => $productos['fa_nombre'],
                'cantidad'          =>  round($stock['cantidad'], 2),
                'pro_precio'        => Moneda::moneda(round(convertir_a_float($productos['pro_precio'] + ($productos['pro_precio'] * ($impuesto['imp_valor'] / 100))), 2), 'de-DE', ' '),
                'pro_publico'       => $productos['pro_publico'],
                'pro_barra'         =>$barrac
            ];
        }

        $empresa_data       = $this->productos->obtenerDatosEmpresa();
        $categorias         = $this->productos->obtenerCategorias();

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 0,
            'margin_right'      => 0,
            'margin_top'        => -3,
            
            'format'            => [60, 53],
            'orientation'       => 'P',
            'default_font_size' => 8,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle('Productos');
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject('Productos el');


        $html_body = Vista::viewPDF('productos/pdf/sticket/body_sticket.php', [
            'productos'     => $array_productos,
            'tar_nombre'    => "",
        ]);

        $mpdf->WriteHTML($html_body);

        $mpdf->Output("productos_sticket.pdf", \Mpdf\Output\Destination::INLINE);
        exit;
    }
    
    
    public function imprimir_sticket()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_GET['prod']) && !empty($_GET['id_impresora'])) {

                $prod    = $this->solicitud->sanitize($_GET['prod'], FILTER_SANITIZE_STRING);
                $id_impresora   = $this->solicitud->sanitize($_GET['id_impresora'], FILTER_VALIDATE_INT);

                if (empty($this->array_errors)) {

                    $product = $this->productos->obtener($prod);
                    $array_productos = [];

                    $impuesto = $this->productos->obtenerproImp($product['pro_id']);
                    $stock = $this->productos->obtenerProductosSinServicioStock($product['pro_id']);

                    $data_final = [
                        'command'           => 'generate_sticket',
                        'args' => [[
                            'pro_id'            => $product['pro_id'],
                            'pro_codigo'        => $product['pro_codigo'],
                            'pro_descripcion'   => $product['pro_descripcion'],
                            'cantidad'          =>  round($stock['cantidad'], 2),
                            'pro_precio'        => round(convertir_a_float($product['pro_precio'] + ($product['pro_precio'] * ($impuesto['imp_valor'] / 100))), 2),
                            'pro_publico'       => $product['pro_publico']
                        ]]
                    ];

                    $impresora = $this->productos->consultar("SELECT imp_tipo,imp_codigo, CONCAT(imp_ip, ':', imp_puerto) ip_puerto,imp_limite,imp_redondear, imp_usd,imp_descripcion_final      
                    FROM app_impresoras WHERE imp_id = $id_impresora")->row();

                    if ($impresora) {

                        Http::json_response([
                            'ip_puerto' => protocolo() . $impresora['ip_puerto'],
                            'data'      => $data_final
                        ]);
                    }
                } else {
                    Http::json_response(['errors' => $this->array_errors]);
                }
            } else {
                $this->array_errors[] = 'Accion prohibida';
            }
        }
    }

    public function actualizarPesos()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $divisa = Moneda::Predeterminada();

            $pro_id     = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $peso = filter_input(INPUT_POST, 'peso', FILTER_SANITIZE_STRING);
            $alto  = filter_input(INPUT_POST, 'alto', FILTER_SANITIZE_STRING);
            $largo  = filter_input(INPUT_POST, 'largo', FILTER_SANITIZE_STRING);
            $ancho  = filter_input(INPUT_POST, 'ancho', FILTER_SANITIZE_STRING);

            if (empty($peso))
                $this->array_errors[] = "El campo Peso es obligatorio.";

            if (!empty($pro_id) && empty($this->array_errors)) {

                $data_pro = $this->productos->obtener($pro_id);

                if (!$data_pro)
                    $this->array_errors[] = "Accion prohibida";

                if ($data_pro['pro_tipo'] == 3) {
                    $this->array_errors[] = "Accion prohibida";
                } else {
                    if (empty($peso))
                        $this->array_errors[] = "El campo Peso es obligatorio.";
                }

                if (empty($this->array_errors)) {
                    if ($this->productos->editar($pro_id, [
                        'pro_peso'    => $peso,
                        'pro_alto'     => $alto,
                        'pro_largo'     => $largo,
                        'pro_ancho'     => $ancho
                    ])) {

                        Http::json_response(true);
                    } else {
                        Http::json_response(false);
                    }
                }
            }
        } else {
            $this->array_errors[] = 'Acceso prohibido no posee permisos para modificar los precios.';
        }

        Http::json_response(['errors' => $this->array_errors]);
    }
}
