<?php

use Core\Helpers\Moneda;

?>
<div class="container" id="appCarritoVer" v-cloak>
    <input type="hidden" value="2" id="modulo">
    <input type="hidden" value="<?= $cliente['cli_id'] ?>" id="id_cliente_fac">
    <input type="hidden" value="<?= $factura['fm_id'] ?>" id="id_fac">
    <input type="hidden" id="ruta_documento" value="poseditar">
    <input type="hidden" value="<?= $empresa['emp_nombre'] ?>" id="nombEmpresa">
    <input type="hidden" value="<?= $doc_pendientes ?>" id="cant_pend">
    <input type="hidden" value="<?= $pagot ?>" id="pagot">
    <input type="hidden" value="<?= $telefonocli ?>" id="telcli">
    <div class="page-inner">
        <div class="row">
            <div class="col">
                <div class="d-flex justify-content-between">
                    <div class="col-5 pl-0 row-card-no-pd mr-3" style="margin-bottom: 0; padding-top: 0; padding-bottom: 0">
                        <div class="list-group list-group-messages list-group-flush">
                            <div class="list-group-item unread">
                                <div class="list-group-item-figure">
                                    <div class="avatar">
                                        <span class="avatar-title rounded-circle border border-white bg-info"><?= strtoupper($cliente['cli_razon_social'][0]); ?></span>
                                    </div>
                                </div>
                                <div class="list-group-item-body pl-3 pl-md-4">
                                    <div class="row">
                                        <div class="col-12 col-lg-10">
                                            <h4 class="list-group-item-title">
                                                <span id="cabecera_cliente"><?= $cliente['cli_razon_social'] ?> <?= $cliente['cli_dni'] ?></span>
                                                <a href="#" data-toggle="modal" data-target="#modal_buscar_cliente_generico"><span class="fa fa-edit"></span></a>
                                                <span title="<?= ($factura['fm_descontado']) ? 'DESCONTADA' : 'SIN DESCONTAR'  ?>" class="fa-2x <?= ($factura['fm_descontado']) ? 'fas fa-cart-arrow-down' : 'fas fa-shopping-cart' ?>"></span>
                                            </h4>
                                        </div>
                                        <div class="col-12 col-lg-10">
                                            <h5 class="list-group-item-title text-warning">
                                                VENTAS - FACTURA
                                                <div class="<?= ($doc_pendientes > 1) ? 'text-danger' : 'text-dark' ?>">
                                                    <span class="text-success" @click="modal_whatsapp()"><i class="fa-2x fab fa-whatsapp"></i></span>
                                                    <small>Pendientes: <?= $doc_pendientes ?></small>
                                                    <?php foreach ($total_doc_pendientes['divisas_totales'] as $row) : ?>
                                                        <small><?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?></small>
                                                    <?php endforeach; ?>
                                                    <?php if ($cliente['grup_id']) : ?>
                                                        <small> Venta Al <?= $cliente['grup_nombre'] ?> <?= $cliente['grup_descuento'] ?>%</small>
                                                    <?php endif; ?>
                                                </div>
                                                <?php if ($total_costo) : ?>
                                                    <small class="badge badge-warning ml-2">Total Costo: {{costo}}</small>
                                                <?php endif; ?>
                                            </h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-7 p-0">
                        <div class="row">
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="fecha">Fecha</label>
                                    <input type="date" id="fecha" class="form-control" value="<?= date('Y-m-d', strtotime($factura['fm_fecha'])) ?>" disabled>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="divisa">Divisa</label>
                                    <select id="divisa" class="form-control" disabled>
                                        <option value="div_nombre_master">{{ div_nombre_master }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="sucursal">Sucursal</label>
                                    <select id="sucursal" v-model="sucursal_predeterminada" class="form-control" disabled>
                                        <option disabled value="">Seleccione un elemento</option>
                                        <option v-for="row in sucursales_empleado" :value="row.su_id">{{row.su_nombre}}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="serie">Serie</label>
                                    <select id="serie" v-model="serie_predeterminada" class="form-control" disabled>
                                        <option disabled value="">Seleccione un elemento</option>
                                        <option v-for="row in series_empleado" :value="row.ser_id">{{row.ser_descripcion}}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="almacen">Almacén</label>
                                    <select id="almacen" v-model="almacen_predeterminado" class="form-control" disabled>
                                        <option disabled value="">Seleccione un elemento</option>
                                        <?php foreach ($almacenes as $row) : ?>
                                            <option value="<?= $row['alm_id'] ?>" <?= ($factura['fm_almid'] == $row['alm_id']) ? 'selected' : '' ?>><?= $row['alm_nombre'] ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-8">
                                <div class="form-group text-left" style="margin-top: 30px;">
                                    <a href="#" class="btn btn-info btn-round btn-border btn-sm mr-2" data-toggle="modal" data-target="#modal-precio-global"> <span class="fas fa-question-circle"></span> Consultar Precio</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 mt-3">
                <nav>
                    <div class="nav nav-tabs" role="tablist">
                        <a class="nav-item nav-link active" data-toggle="tab" href="#nav-lista" role="tab" aria-controls="nav-home" aria-selected="true">Factura <span class="badge badge-info ml-2"> #<?= $factura['fm_correlativo'] ?></span></a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-detalles" role="tab" aria-controls="nav-profile" aria-selected="false"><i class="fas fa-user-friends"></i> Detalles</a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-envio" role="tab" aria-controls="nav-contact" aria-selected="false"><i class="fas fa-shipping-fast"></i> Envíos</a>
                        <?php if ($per_pagar) : ?>
                            <a class="nav-item nav-link" data-toggle="tab" href="#nav-pagos" role="tab" aria-controls="nav-pagos" aria-selected="false"><i class="fas fa-file-invoice-dollar"></i> Pagos</a>
                        <?php endif; ?>
                        <a class="nav-item nav-link" href="#" @click.prevent="modalCorreo">
                            <i class="far fa-envelope"></i> Enviar Factura
                        </a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-documentos" role="tab" aria-controls="nav-documentos" aria-selected="false"><i class="fas fa-file-contract"></i> Documentos</a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-rutadocumento" role="tab" aria-controls="nav-rutadocumento" aria-selected="false"><i class="flaticon-stopwatch"></i> Historial</a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-ubicacion" role="tab" aria-controls="nav-ubicacion" aria-selected="false">Ubicación</a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-comisiones" role="tab" aria-controls="nav-comisiones" aria-selected="false" @click="obtenerComisionFactNotaPendiente()">Comisiones</a>
                        <a class="nav-item nav-link" data-toggle="tab" href="#nav-licencias" role="tab" aria-controls="nav-licencias" aria-selected="false" v-if="clientes_lista.length>0"> Licencias</a>
                    </div>
                </nav>
                <div class="tab-content mt-2">
                    <div class="tab-pane fade show active" id="nav-lista" role="tabpanel" aria-labelledby="nav-home-tab">
                        <div class="row row-card-no-pd">
                            <div class="col-12 mt-2 mb-2 p-0">
                                <div class="d-flex justify-content-end">
                                    <a class="btn btn-info btn-round btn-border btn-sm mr-2" href="<?= url('facturacion') ?>" target="_blank" style="max-height: 2rem;"><i class="fas fa-reply"></i> Ventas</a>
                                    <a class="btn btn-info btn-round btn-border btn-sm mr-2" href="<?= url('productos') ?>" target="_blank" style="max-height: 2rem;">Productos <i class="far fa-share-square"></i></a>
                                    <button type="button" class="btn btn-info btn-round btn-border btn-sm mr-2" @click="modalImprimir" style="max-height: 2rem;"><i class="fa fa-print"></i> Imprimir</button>
                                    <button type="button" class="btn btn-info btn-round btn-sm mr-2" disabled style="max-height: 2rem;">Guardar</button>
                                    <?php if ($anular_doc) : ?>
                                        <button type="button" class="btn btn-danger btn-round btn-sm mr-2" @click="modalAnular" style="max-height: 2rem;">Anular</button>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-6">
                            </div>
                            <div class="col-12 mt-2">
                                <div class="scroll" style="height: 300px;width: 100%;padding: 0;margin: 0;overflow-y: scroll;overflow-x: hidden;">
                                    <div class="table-responsive">
                                        <table class="bg-white table-bordered-bd-black table-head-bg-primary table-bordered-bd-primary" cellspacing="1" cellpadding="1" width="100%" tabindex="2">
                                            <thead>
                                                <tr class="text-center">
                                                    <th></th>
                                                    <th>Código</th>
                                                    <th>Descripción</th>
                                                    <th>Precio</th>
                                                    <th>Cantidad</th>
                                                    <th>Dto. %</th>
                                                    <th>Neto</th>
                                                    <th>IVA</th>
                                                    <th>Total</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="(row, index) in carrito" class="text-right">
                                                    <td class="text-center">
                                                        <a href="#" v-if="row.tipo==2" @click="comboProductosCompuestos(row)">
                                                            <i class="fa fa-cubes text-success"></i>
                                                        </a>
                                                    </td>
                                                    <td width="8%" class="text-center">{{ row.codigo }} <small class="badge badge-danger ml-2" v-if="row.tarifa!=''">Tarifa: {{row.tarifa}}</small></td>
                                                    <td class="text-left" style="padding-left:5px;">{{ row.nombre }}</td>
                                                    <td width="12%">{{ moneda(row.precio, money.locale, money.prefix, money.precision) }}</td>
                                                    <td width="7%">{{ row.cantidad }}</td>
                                                    <td width="7%">{{ row.descuento }}</td>
                                                    <td width="12%">{{ moneda(row.neto, money.locale, money.prefix, money.precision) }}</td>
                                                    <td width="7%">
                                                        <select id="impuestos" class="form-control text-center input-border-bottom" v-model="row.id_iva" disabled>
                                                            <?php foreach ($impuestos as $row) : ?>
                                                                <option value="<?= $row['imp_id'] ?>"><?= $row['imp_descripcion'] ?></option>
                                                            <?php endforeach; ?>
                                                        </select>
                                                    </td>
                                                    <td width="10%" class="text-right">{{ moneda(row.total, money.locale, money.prefix, money.precision) }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row row-card-no-pd">
                            <div class="col-12" style="padding-left: 30%;">
                                <div class="table-responsive ">
                                    <table class="bg-white table-bordered-bd-black table-head-bg-primary table-bordered-bd-primary" cellspacing="1" cellpadding="2" width="100%" tabindex="2">
                                        <thead>
                                            <tr class="text-center">
                                                <th>Subtotal</th>
                                                <th width="10%">Dto. %</th>
                                                <th>Neto</th>
                                                <th>IVA</th>
                                                <th>Total</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr class="text-right">
                                                <td width="20%">{{ moneda(subtotal, money.locale, money.prefix, money.precision) }}</td>
                                                <td width="20%">{{ descuento }}</td>
                                                <td width="20%">{{ moneda(neto, money.locale, money.prefix, money.precision) }}</td>
                                                <td width="20%">{{ iva }}</td>
                                                <td width="20%">{{ moneda(total, money.locale, money.prefix, money.precision) }}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="card-category"> <i class="fa fa-user-tie"></i> Empleado</div>
                        <div class="separator-solid"></div>
                        <div class="form-row">
                            <div class="col-sm-6">
                                <label for="empleado">Empleado</label>
                                <input type="text" id="empleado" class="form-control" disabled value="<?= $empleado['einfo_apellidos']; ?> - <?= $empleado['einfo_email']; ?>">
                            </div>

                        </div>
                        <div class="row mt-3 row-card-no-pd">
                            <div class="col">
                                <div class="form-group form-group-default">
                                    <label>Observaciones</label>
                                    <textarea class="form-control" rows="3" disabled><?= $factura['fm_observaciones'] ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-detalles" role="tabpanel" aria-labelledby="nav-detalles-tab">
                        <form action="#" autocomplete="off" @submit.prevent="actualizarDetalles">
                            <div class="card">
                                <div class="card-body">
                                    <div class="card-category"> <i class="fa fa-user"></i> Cliente</div>
                                    <div class="separator-solid"></div>
                                    <div class="form-row">
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_tipodoc">Tipo de documento:</label>
                                                <select id="cli_tipodoc" class="form-control">
                                                    <?php foreach ($tipos_de_documentos as $row) : ?>
                                                        <option value="<?= $row['tipodoc_id'] ?>" <?= ($cliente['tipodoc_codigo'] == $row['tipodoc_id']) ? 'selected' : '' ?>><?= $row['tipodoc_codigo']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_dni"># Documento:</label>
                                                <input type="text" id="cli_dni" class="form-control" value="<?= $cliente['cli_dni'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="form-group form-group-default">
                                                <label for="cli_razon_social">Razón social:</label>
                                                <input type="text" id="cli_razon_social" class="form-control" value="<?= $cliente['cli_razon_social'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_pais">País:</label>
                                                <select id="cli_pais" class="form-control">
                                                    <?php foreach ($paises as $row) : ?>
                                                        <option value="<?= $row['pa_id'] ?>" <?= ($cliente['cli_paisid'] == $row['pa_id']) ? 'selected' : '' ?>><?= $row['pa_nombre']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_estado">Estado:</label>
                                                <input type="text" id="cli_estado" class="form-control" value="<?= $cliente['cli_estado'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_ciudad">Ciudad:</label>
                                                <input type="text" id="cli_ciudad" class="form-control" value="<?= $cliente['cli_ciudad'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_codigopostal">Código postal:</label>
                                                <input type="text" id="cli_codigopostal" class="form-control" value="<?= $cliente['cli_codpostal'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-lg-6">
                                            <div class="form-group form-group-default">
                                                <label for="cli_direccion">Dirección:</label>
                                                <input type="text" id="cli_direccion" class="form-control" value="<?= $cliente['cli_direccion'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="row">
                                                <div class="col-lg-6">
                                                    <label for="latitude">
                                                        Lat.
                                                    </label>
                                                    <input id="txtLat" class="form-control controls" type="text" style="color:red" value="<?= ($cliente['cli_lat']) == null ? '8.6226100' : $cliente['cli_lat'] ?>" disabled />
                                                </div>
                                                <div class="col-lg-6">
                                                    <label for="longitude">
                                                        Long.
                                                    </label>
                                                    <input id="txtLng" class="form-control controls" type="text" style="color:red" value="<?= ($cliente['cli_lng']) == null ? '-70.2074900' : $cliente['cli_lng'] ?>" disabled />
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-12 mb-2">
                                            <div id="map_canvas" style="width: auto; height: 200px;">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_direccion">Fecha de nacimiento:</label>
                                                <input type="date" id="cli_fecha_nac" class="form-control" value="<?= $cliente['cli_fecha_nac'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_direccion">Email:</label>
                                                <input type="text" id="cli_email" class="form-control" value="<?= $cliente['cli_email'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-3">
                                            <div class="form-group form-group-default">
                                                <label for="cli_direccion">Telefono:</label>
                                                <input type="text" id="cli_telefono" class="form-control" value="<?= $cliente['cli_telefono'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-3">
                                            <div class="form-group form-group-default">
                                                <label for="captado">Captado por:</label>
                                                <select id="captado" class="form-control" v-model="captado.nombre">
                                                    <option value="">Seleccione una opcion</option>
                                                    <option value="Empresa">Empresa</option>
                                                    <option value="Instagram">Instagram</option>
                                                    <option value="Facebook">Facebook</option>
                                                    <option value="Twitter">Twitter</option>
                                                    <option value="Woocommerce">Woocommerce</option>
                                                    <option value="Tik-Tok">Tik-Tok</option>
                                                    <option value="Whatsapp">Whatsapp</option>
                                                    <option value="Telegram">Telegram</option>
                                                    <option value="E-mail">E-mail</option>
                                                    <option value="Wechat">Wechat</option>
                                                    <option value="Otros">Otros</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-12 text-right">
                                            <a href="#" class="btn btn-success btn-sm btn-round mr-3" @click="modal_redes()"><i class="fab fa-whatsapp"></i> Enviar al whatsapp</a>
                                            <a href="#" class="btn btn-secondary btn-sm btn-round mr-3" role="tab" aria-selected="false" data-toggle="modal" data-target="#modal-redes"><i class="fab fa-facebook-f"></i> Redes sociales</a>
                                            <button type="button" class="btn btn-info btn-border btn-round btn-sm" disabled v-if="cargando">
                                                <span class="btn-label"><i class="loader loader-info"></i></span>
                                            </button>
                                            <button type="submit" class="btn btn-info btn-border btn-round btn-sm" v-else>
                                                <span class="btn-label"><i class="fa fa-edit"></i></span> Actualizar
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="tab-pane" id="nav-envio" role="tabpanel" aria-labelledby="nav-envio-tab">
                        <form action="#" autocomplete="off" @submit.prevent="actualizarEnvio">
                            <div class="card">
                                <div class="card-body">
                                    <div class="form-row">
                                        <div class="col-sm-6">
                                            <div class="form-group form-group-default">
                                                <label for="env_nombre_opcional">Nombres:</label>
                                                <input type="text" id="env_nombre_opcional" class="form-control" placeholder="opcional" value="<?= $factura['fm_env_nombres'] ?>" required>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_agencia_transporte">Agencia de transporte:</label>
                                                <select id="env_agencia_transporte" class="form-control" value="<?= $factura['fm_env_agencia_transporte'] ?>" required>
                                                    <option value="V">V</option>
                                                    <option value="R">R</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_codigo_seguimiento">Código de Sequimiento:</label>
                                                <input type="text" id="env_codigo_seguimiento" class="form-control" value="<?= $factura['fm_env_codigo_seguimiento'] ?>" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_pais">País:</label>
                                                <select id="env_pais" class="form-control">
                                                    <?php foreach ($paises as $row) : ?>
                                                        <option value="<?= $row['pa_id'] ?>" <?= ($factura['fm_env_pais'] == $row['pa_id']) ? 'selected' : '' ?>><?= $row['pa_nombre']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_estado">Estado:</label>
                                                <input type="text" id="env_estado" class="form-control" value="<?= $factura['fm_env_estado'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_ciudad">Ciudad:</label>
                                                <input type="text" id="env_ciudad" class="form-control" value="<?= $factura['fm_env_ciudad'] ?>">
                                            </div>
                                        </div>
                                        <div class="col-sm-3">
                                            <div class="form-group form-group-default">
                                                <label for="env_codigopostal">Código Postal:</label>
                                                <input type="text" id="env_codigopostal" class="form-control" value="<?= $factura['fm_env_codigo_postal'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="col">
                                            <div class="form-group form-group-default">
                                                <label for="env_direccion">Dirección:</label>
                                                <input type="text" id="env_direccion" class="form-control" value="<?= $factura['fm_env_direccion'] ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-check">
                                        <label class="form-check-label">
                                            <input class="form-check-input" type="checkbox" <?= $factura['fm_env_asegurado'] ? 'checked' : '' ?> id="env_asegurado">
                                            <span class="form-check-sign">Envío asegurado SI/NO</span>
                                        </label>
                                    </div>
                                    <div class="form-row">
                                        <div class="col-12 text-right">
                                            <button type="button" class="btn btn-info btn-border btn-round btn-sm" disabled v-if="cargando">
                                                <span class="btn-label"><i class="loader loader-info"></i></span>
                                            </button>
                                            <button type="submit" class="btn btn-info btn-border btn-round btn-sm" v-else>
                                                <span class="btn-label"><i class="fa fa-edit"></i></span> Actualizar
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="tab-pane" id="nav-pagos" role="tabpanel" aria-labelledby="nav-pagos-tab">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <?php if ($per_pagar) : ?>
                                            <div class="row d-flex justify-content-end ">
                                                <a class="btn btn-secondary btn-sm  btn-border btn-round mr-3" href="#" @click.prevent="modalCrearCredito">Crédito</a>
                                                <a class="btn btn-info btn-sm btn-round mr-3" href="#" @click.prevent="modalPagar">Pagar</a>
                                            </div>
                                        <?php endif; ?>
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-bordered-bd-black table-head-bg-primary table-bordered-bd-primary mt-3">
                                                <thead>
                                                    <tr>
                                                        <th>Fecha</th>
                                                        <th>Divisa</th>
                                                        <th>Total</th>
                                                        <th>Restante</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>{{ factura.fecha }}</td>
                                                        <td>{{ div_nombre_master }}</td>
                                                        <td>{{ moneda(total, money.locale, money.prefix, money.precision) }}</td>
                                                        <td>{{ moneda(restante_original, money.locale, money.prefix, money.precision) }}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-bordered table-bordered-bd-black table-head-bg-primary table-bordered-bd-primary mt-3">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th>Fecha</th>
                                                <th>Cuenta</th>
                                                <th>Método</th>
                                                <th>Monto</th>
                                                <th>Factor</th>
                                                <th>Conversión</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="row in abonos" :class="[row.fab_retiro == 1 ? 'bg-danger': '', row.credito == '1' ? 'bg-secondary': '']">
                                                <td class="text-center">
                                                    <?php if ($eliminar_pago) : ?>
                                                        <a v-if="row.fab_retiro==0 && row.credito != '1'" href="#" @click.prevent="eliminarPago(row.fab_id)">
                                                            <i class="fa fa-trash text-danger"></i>
                                                        </a>
                                                    <?php endif; ?>
                                                </td>
                                                <td>{{ row.fab_fecha }}</td>
                                                <td>{{ row.bc_alias }} {{ row.bc_tipo }} {{row.referencia}}</td>
                                                <td>{{ row.mp_nombre }}</td>
                                                <td>{{ row.fab_monto }}</td>
                                                <td>{{ row.fab_factor }}</td>
                                                <td>{{ row.fab_conversion }}</td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th></th>
                                                <th class="text-right">Total</th>
                                                <th>{{ moneda(total_pagado, money.locale, money.prefix, money.precision) }}</th>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                                <div class="row mb-2" v-if='pago_movil.length > 0'>
                                    <div class="mt-2 col-lg-12">
                                        <div class="card-category"><i class="fa fa-money"></i>$ Compra de dolares</div>
                                    </div>
                                    <div class="separator-solid"></div>
                                    <div class="col-lg-12 mt-2" style="margin: 0 auto;">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-bordered-bd-black table-head-bg-primary table-bordered-bd-primary mt-3">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center">Fecha</th>
                                                        <th class="text-center">Pago</th>
                                                        <th class="text-center">Monto</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="row in pago_movil">
                                                        <td class="text-center">{{ row.fab_fecha }}</td>
                                                        <td><small>{{ row.bc_alias }}</small></td>
                                                        <td class="text-center">{{ moneda(row.fab_monto, row.div_locale, row.div_simbolo, row.div_decimal) }}</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-documentos" role="tabpanel" aria-labelledby="nav-documentos">
                        <form action="#" enctype="multipart/form-data" autocomplete="off" @submit.prevent="enviarDocumento">
                            <div class="form-group">
                                <label for="doc_descripcion">Descripción</label>
                                <input type="text" class="form-control" placeholder="Descripcion" maxlength="50" v-model="formDocumentos.descripcion">
                            </div>
                            <div class="form-group">
                                <label for="doc_archivo">Documento</label>
                                <input type="file" class="form-control" id="file" ref="file" v-on:change="handleFileUpload()" accept=".jpg,.png,.pdf">
                                <small class="form-text text-muted">Solo archivos con formato PDF, PNG o JPG y maximo de 1MB</small>
                            </div>
                            <div class="form-group">
                                <button type="button" class="btn btn-info btn-border" disabled v-if="cargando_documento">
                                    <span class="btn-label"><i class="loader loader-info"></i></span>
                                </button>
                                <button v-else type="submit" class="btn btn-info btn-border">Enviar</button>
                            </div>
                        </form>
                        <div class="row">
                            <table class="table table-head-bg-primary table-bordered-bd-primary">
                                <thead>
                                    <tr>
                                        <th>Descripción</th>
                                        <th>Documento</th>
                                        <th>Fecha</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in documentos">
                                        <td>{{ row.descripcion }}</td>
                                        <td>
                                            <a :href="'<?= constant('IMG_URI') ?>documentos_ventas/facturas/' + row.archivo" :download="row.archivo">
                                                <img v-if="row.imagen" :src="'<?= constant('IMG_URI') ?>documentos_ventas/facturas/' + row.archivo" alt="" class="rounded-circle border border-white" width="50" height="50">
                                                <span v-else class="text-info"><span class="far fa-file-archive"></span></span>
                                                {{row.archivo}}
                                            </a>
                                        </td>
                                        <td>{{ row.fecha }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-rutadocumento" role="tabpanel" aria-labelledby="nav-documentos">
                        <div class="card">
                            <div class="card-body">
                                <ul class="list-group">
                                    <li class="list-group-item">Creditos</li>
                                </ul>
                                <table class="table table-head-bg-primary table-bordered-bd-primary">
                                    <thead>
                                        <tr>
                                            <th>Estatus</th>
                                            <th>Documento</th>
                                            <th>Fecha</th>
                                            <th>Monto</th>
                                            <th>Observaciones</th>
                                            <th>Imprimir</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row in creditosFactura">
                                            <td>
                                                <i :title="row.estatus ? 'Finalizado' : 'Activo'" :class="row.estatus ? 'text-warning fas fa-info-circle' : 'text-success fas fa-check-circle'"></i>
                                            </td>
                                            <td>{{ row.correlativo }}</td>
                                            <td>{{ row.fecha }}</td>
                                            <td>{{ row.monto }}</td>
                                            <td>{{ row.observaciones }}</td>
                                            <td>
                                                <a href="" @click.prevent="modalImprimirCredito(row.id)" title="Imprimir"><i class="fas fa-print btn" style="padding: .65rem;"></i></a>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <ul class="list-group">
                                    <li class="list-group-item">Conversion documento</li>
                                </ul>
                                <?php if (is_countable($ruta)) : ?>
                                    <table class="table table-head-bg-primary table-bordered-bd-primary">
                                        <thead>
                                            <tr>
                                                <th>Fecha</th>
                                                <th>Tipo de documento</th>
                                                <th>Usuario</th>
                                                <th>Descripción</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($ruta as $row) : ?>
                                                <tr>
                                                    <td><?= $row['fecha'] ?></td>
                                                    <td><a href="<?= $row['url'] ?>" target="_blank"><?= $row['doc_prefijo'] ?></a></td>
                                                    <td><?= $row['emp_username'] ?></td>
                                                    <td><?= $row['rd_observacion'] ?></td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                <?php endif; ?>
                                <ul class="list-group">
                                    <li class="list-group-item">Envios de email</li>
                                </ul>
                                <?php if (is_countable($historico_email)) : ?>
                                    <table class="table table-head-bg-primary table-bordered-bd-primary">
                                        <thead>
                                            <tr>
                                                <th>Fecha</th>
                                                <th>Empleado</th>
                                                <th>Descripción</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($historico_email as $row) : ?>
                                                <tr>
                                                    <td><?= date('d/m/Y h:i A', strtotime($row['venhisemail_fecha'])) ?></td>
                                                    <td><?= $row['einfo_nombres'] ?> <?= $row['einfo_apellidos'] ?></td>
                                                    <td><?= $row['venhisemail_descripcion'] ?></td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                <?php endif; ?>
                                <ul class="list-group">
                                    <li class="list-group-item">Historial general</li>
                                </ul>
                                <?php if (is_countable($historial_general)) : ?>
                                    <table class="table table-head-bg-primary table-bordered-bd-primary">
                                        <thead>
                                            <tr>
                                                <th>Fecha</th>
                                                <th>Empleado</th>
                                                <th>Descripción</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($historial_general as $row) : ?>
                                                <tr>
                                                    <td><?= date('d/m/Y h:i A', strtotime($row['bitdoc_fecha'])) ?></td>
                                                    <td><?= $row['einfo_nombres'] . " " . $row['einfo_apellidos']; ?></td>
                                                    <td><?= $row['bitdoc_descripcion']; ?></td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-ubicacion" role="tabpanel" aria-labelledby="nav-ubicacion-tab">
                        <div class="card" v-for="row in ubicacionProductos">
                            <div class="card-header">
                                <strong>Almacen:</strong> {{ row.almacen.descripcion }}
                            </div>
                            <div class="card-body">
                                <span><strong>{{ row.producto.descripcion.toUpperCase() }}</strong></span>
                                <span v-for="row_dos in row.ubicacion">
                                    -> <strong>{{ row_dos.tipo }}:</strong> {{ row_dos.descripcion }}
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-comisiones" role="tabpanel" aria-labelledby="nav-comisiones-tab">
                        <div class="card">
                            <div class="card-body">
                                <div class="card-category"> <i class="fa fa-user"></i> Agentes</div>
                                <div class="separator-solid"></div>
                                <div class="form-row">
                                    <div class="col">
                                        <div class="row d-flex justify-content-end" v-if="<?= ($factura['fm_estatus']); ?>==2">
                                            <?php if (constant('EMP_FIGURA_AGENTE') == true) : ?>
                                                <a href="#" class="btn btn-border btn-success btn-sm btn-round mr-3" @click.prevent="modalAgregarAgente()">Agregar un agente</a>
                                            <?php endif; ?>
                                        </div>
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-bordered-bd-black table-head-bg-primary table-bordered-bd-primary mt-3">
                                                <thead>
                                                    <tr>
                                                        <th>Estatus</th>
                                                        <th>Agente</th>
                                                        <th>Total en venta</th>
                                                        <th>Comision</th>
                                                        <th>Porcentaje</th>
                                                        <th>Monto por Comision</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody v-for="com in comisiones_por_agentes">
                                                    <tr>
                                                        <td>{{com.estatus}}</td>
                                                        <td>{{com.agente_nombre}}</td>
                                                        <td>{{com.total_moneda}}</td>
                                                        <td>{{com.comision}}</td>
                                                        <td>{{com.porcentaje}} %</td>
                                                        <td>{{com.monto_moneda}}</td>
                                                        <td>
                                                            <button type="button" title="Eliminar" class="btn btn-link btn-danger" v-if="com.estatus=='Pendiente'" @click.prevent="eliminarComisionPendiente(com.id)"><i class="fa fa-trash"></i></button>
                                                            <button type="button" title="Editar" class="btn btn-link btn-primary" v-if="com.estatus=='Pendiente'" @click="modalPendienteeditar(com.id,com.porcentaje,com.monto,com.total,div_simbolo)"><i class="fa fa-edit"></i></button>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane" id="nav-licencias" role="tabpanel" aria-labelledby="nav-licencias-tab">
                        <div class="card">
                            <div class="card-body">
                                <ul class="list-group">
                                    <li class="list-group-item">Licencias</li>
                                </ul>
                                <table class="table table-head-bg-primary table-bordered-bd-primary">
                                    <thead>
                                        <tr>
                                            <th>Codigo</th>
                                            <th>Producto</th>
                                            <th>Fecha de vencimiento</th>
                                            <th>Serial</th>
                                            <th>Comentario</th>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr v-for="row in clientes_lista">
                                            <td>{{ row.codigo }}</td>
                                            <td>{{ row.producto }}</td>
                                            <td v-if="row.fecha!=null">{{ row.fecha }}</td>
                                            <td v-else>Sin Definir</td>
                                            <td v-if="row.serial!=null">{{ row.serial }}</td>
                                            <td v-else>Sin Definir</td>
                                            <td v-if="row.comentario!=null">{{ row.comentario }}</td>
                                            <td v-else>Sin Definir</td>
                                            <td>
                                                <a href="" @click.prevent="modalLicencia(row)" title="editar"><i class="fas fa-edit btn" style="padding: .65rem;"></i></a>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php if ($per_pagar) : ?>
        <?php include 'app/notasdeentregaeditar/vista/modalpagar.php'; ?>
    <?php endif; ?>
    <?php include 'app/notasdeentregaeditar/vista/modalcorreo.php'; ?>
    <?php if ($anular_doc) : ?>
        <?php include 'modal_anular.php' ?>
    <?php endif; ?>
    <?php include 'app/notasdeentregaeditar/vista/modal_licencias.php' ?>
    <?php include 'app/notasdeentrega/vista/modalproductoscompuestos.php' ?>
    <?php include 'app/notasdeentregaeditar/vista/modal_whatsapp.php' ?>
    <?php include 'modal_imprimir.php' ?>
    <?php include 'app/clientes/vista/modal_redes.php' ?>
    <?php include 'modal_imprimir_anular.php' ?>
    <?php include 'modal_imprimir_credito.php' ?>
    <?php include 'modal_reimprimir.php' ?>
    <?php include 'modal_num.php' ?>
    <?php include 'app/notasdeentregaeditar/vista/modal_nuevo_credito.php' ?>
    <?php if (constant('EMP_FIGURA_AGENTE') == true) : ?>
        <?php include 'app/notasdeentregaeditar/vista/modal_agregar_agente.php' ?>
    <?php endif; ?>
    <?php include 'app/notasdeentregaeditar/vista/modal_editar_con_agente.php' ?>
</div>
<link rel="stylesheet" href="<?= asset('assets/vue-select.css') ?>">
<script src="<?= asset('assets/vue-select.js') ?>"></script>
<script src="<?= asset('assets/underscore-min.js') ?>"></script>
<script src="<?= asset('assets/vue-the-mask.js') ?>"></script>
<script src="<?= asset('assets/v-money.js') ?>"></script>
<script src="<?= asset('assetsvuejs/factura/ver.js') ?>"></script>
<?php include 'app/notasdeentrega/vista/guardar_cambiar_cliente_editar.php' ?>