<?php

namespace App\Controladores;

use App\Modelos\EmpleadoAgente;
use App\Modelos\EmpleadosComisionesEmplAgente;
use App\Modelos\FacturaDocumentos;
use App\Modelos\MovimientoModel;
use App\Modelos\Notadecredito;
use App\Modelos\NotadeCreditoDetalles;
use App\Modelos\Pos;
use App\Modelos\PosArticulos;
use App\Modelos\ProductosCompuestos;
use App\Modelos\VentasHistoricoEmail;
use Core\Controller;
use Core\Helpers\Moneda;
use Core\Helpers\Notifica;
use Core\Librerias\CarritoVentasEditar;
use Core\Librerias\Http;
use Core\Librerias\Module;
use Core\Vista;
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

final class PoseditarControlador extends Controller
{
    private $array_errors = [];
    private $notas_entrega_model;
    private $divisa_master;
    private $module;
    private $carritoVentas;

    public function __construct()
    {
        parent::__construct();
        $this->module = new Module('facturacion');
        $this->notas_entrega_model = new Pos();
        $this->carritoVentas = new CarritoVentasEditar();
        $this->divisa_master = $this->notas_entrega_model->obtenerDivisaMaster();
    }

    public function verFactura(int $id_factura)
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET') {

            $id_factura = filter_var($id_factura, FILTER_SANITIZE_NUMBER_INT);
            $factura = $this->notas_entrega_model->obtenerFactura($id_factura);

            if ($factura) {

                $newVentasHistoricoEmail = new VentasHistoricoEmail();

                $ruta_list = $this->notas_entrega_model->obtenerDocServicio($id_factura);

                $ruta = [];

                if (is_countable($ruta_list) && count($ruta_list)) {
                    foreach ($ruta_list as $row) {

                        if ($row['rd_docid_procedencia'] == 1) {
                            $ruta[] = [
                                'fecha'           => $row['rd_fecha'],
                                'emp_username'    => $row['emp_username'],
                                'rd_observacion'  => $row['rd_observacion'],
                                'doc_prefijo'     => $row['doc_prefijo'],
                                'url'             => ruta_base() . 'notasdeentregaeditar/verFactura/' . $row['rd_facid_procedencia']
                            ];
                        }
                        if ($row['rd_docid_procedencia'] == 2) {
                            $ruta[] = [
                                'fecha'           => $row['rd_fecha'],
                                'emp_username'    => $row['emp_username'],
                                'rd_observacion'  => $row['rd_observacion'],
                                'doc_prefijo'     => $row['doc_prefijo'],
                                'url'             => ruta_base() . 'poseditar/verFactura/' . $row['rd_facid_procedencia']
                            ];
                        }
                        if ($row['rd_docid_procedencia'] == 3) {
                            $ruta[] = [
                                'fecha'           => $row['rd_fecha'],
                                'emp_username'    => $row['emp_username'],
                                'rd_observacion'  => $row['rd_observacion'],
                                'doc_prefijo'     => $row['doc_prefijo'],
                                'url'             => ruta_base() . 'presupuestoeditar/verFactura/' . $row['rd_facid_procedencia']
                            ];
                        }
                        if ($row['rd_docid_procedencia'] == 13) {
                            $ruta[] = [
                                'fecha'           => $row['rd_fecha'],
                                'emp_username'    => $row['emp_username'],
                                'rd_observacion'  => $row['rd_observacion'],
                                'doc_prefijo'     => $row['doc_prefijo'],
                                'url'             => ruta_base() . 'servicios/tablista?tablero=' . $row['tab_id'] . '&modalpres=' . $row['tar_id']
                            ];
                        }

                        if ($row['rd_docid_procedencia'] == 12) {
                            $ruta[] = [
                                'fecha'           => $row['rd_fecha'],
                                'emp_username'    => $row['emp_username'],
                                'rd_observacion'  => $row['rd_observacion'],
                                'doc_prefijo'     => $row['doc_prefijo'],
                                'url'             => ruta_base() . 'ordendeentregaeditar/verFactura/' .  $row['rd_facid_procedencia']
                            ];
                        }

                        if ($row['rd_docid_procedencia'] == 4) {
                            $ruta[] = [
                                'fecha'           => $row['rd_fecha'],
                                'emp_username'    => $row['emp_username'],
                                'rd_observacion'  => $row['rd_observacion'],
                                'doc_prefijo'     => $row['doc_prefijo'],
                                'url'             => ruta_base() . 'pedidoseditar/verFactura/' .  $row['rd_facid_procedencia']
                            ];
                        }
                    }
                }

                $doc = $this->carritoVentas->obtenerDocumentosPendientesPorPagarPorCliente($factura['fm_cliid']);
                $pagot = Moneda::moneda($doc['total'], $this->divisa_master['div_locale'], $this->divisa_master['div_simbolo']);


                $clp = $this->carritoVentas->obtenerCliente($factura['fm_cliid']);
                $rt = str_replace('(', '', $clp['cli_telefono']);
                $rt = str_replace(')', '', $rt);
                $rt = str_replace('-', '', $rt);
                $rt = str_replace(' ', '', $rt);

                $data_factura = [
                    'doc_pendientes'        => $this->carritoVentas->totalDocumentosPendientes($factura['fm_cliid']),
                    'total_doc_pendientes'  => $this->carritoVentas->obtenerDocumentosPendientesPorPagarPorCliente($factura['fm_cliid']),
                    'pagot'                 => $pagot,
                    'telefonocli'           => $rt,
                    'historial_general'     => $this->notas_entrega_model->consultar("SELECT * FROM app_bitacora_doc rd LEFT JOIN app_empleados emp ON emp.emp_id = rd.bitdoc_empid LEFT JOIN app_empleados_info info ON emp.emp_edatosid=info.einfo_id WHERE rd.bitdoc_idgenerico = $id_factura AND rd.bitdoc_doc = 2")->all(),
                    'editar_comision'       => $this->module->has_module_action_permission('facturacion', 'edit_comision', $_SESSION['user_data']['emp_id']),
                    'eliminar_comision'     => $this->module->has_module_action_permission('facturacion', 'delete_comision', $_SESSION['user_data']['emp_id']),
                    'recalcular_comision'   => $this->module->has_module_action_permission('facturacion', 'recalcular_comision', $_SESSION['user_data']['emp_id']),
                    'cambiar_factor'        => $this->module->has_module_action_permission('facturacion', 'cambiar_factor', $_SESSION['user_data']['emp_id']),
                    'per_pagar'             => $this->module->has_module_action_permission('facturacion', 'pagar', $_SESSION['user_data']['emp_id']),
                    'impresoras'            => $this->notas_entrega_model->consultar("SELECT imp_id id, imp_descripcion impresora FROM app_impresoras WHERE imp_estatus = 1 AND imp_tipo = 1")->all(),
                    'imp_ticket'            => $this->notas_entrega_model->consultar("SELECT imp_id id, imp_descripcion impresora FROM app_impresoras WHERE imp_estatus = 1 AND imp_tipo = 2")->all(),
                    'historico_email'       => $newVentasHistoricoEmail->obtenerHistorico($id_factura),
                    'ruta'                  => $ruta,
                    'anular_doc'            => $this->module->has_module_action_permission('facturacion', 'anular_doc', $_SESSION['user_data']['emp_id']),
                    'eliminar_pago'         => $this->module->has_module_action_permission('facturacion', 'eliminar_pagos', $_SESSION['user_data']['emp_id']),
                    'total_costo'           => $this->module->has_module_action_permission('facturacion', 'total_costo', $_SESSION['user_data']['emp_id']),
                    'factura'               => $factura,
                    'empleado'              => $this->carritoVentas->obtenerEmpleado($factura['fm_empleadoid']),
                    'empresa'               => $this->carritoVentas->obtenerDatosEmpresa(),
                    'cliente'               => $this->carritoVentas->obtenerCliente($factura['fm_cliid']),
                    'tipos_de_documentos'   => $this->carritoVentas->obternerTiposDeDocumentos(),
                    'impuestos'             => $this->carritoVentas->obtenerImpuestos(),
                    'paises'                => $this->carritoVentas->obtenerPaises(),
                    'almacenes'             => $this->carritoVentas->obtenerAlmacenesEmpleado($_SESSION['user_data']['emp_id']),
                    'series'                => $this->carritoVentas->obtenerSeriesEmpleado($_SESSION['user_data']['emp_id']),
                    'divisas'               => $this->carritoVentas->obtenerDivisasParaFacturar(),
                    'empleados_agentes'     => $this->carritoVentas->obtenerAgentesdeVenta(),
                    'cuentaCompraBolivares' => $this->notas_entrega_model->obtenerCuentasDiferenteUsd()
                ];

                if ($factura['fm_estatus'] < 3) {
                    return Vista::view('poseditar/ver', $data_factura);
                } elseif ($factura['fm_estatus'] == 3) {
                    return Vista::view('poseditar/anulado', $data_factura);
                }
            } else {
                header('Location: ' . ruta_base() . 'facturacion');
            }
        }
    }

    public function obtenerCreditosFactura(int $id_factura)
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {
            Http::json_response($this->carritoVentas->obtenerCreditosFactura($id_factura, 2));
        }
    }

    public function pagomovil()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            $id_factura = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
            $monto              = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING);

            $this->notas_entrega_model = new Pos();

            $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
            $factord = 1;
            if ($factura['fm_divid'] != 2) {
                $divisa_factor = $this->notas_entrega_model->obtenerDivisaAlCambio($factura['fm_divid'], 2);
                if ($divisa_factor) {
                    $factord = $divisa_factor['df_factor'];
                }
            }
            $monto = convertir_a_float($monto);

            $factor = $this->notas_entrega_model->obtenerDivisaAlCambio(2, 1);
            $divisa = Moneda::obtenerDivisa(1);

            $movimiento_model = new MovimientoModel();
            $total_pagos = $movimiento_model->totalPagos($factura['fm_id'], 2, 1);
            $montop = convertir_a_float(($factura['fm_total'] - ($total_pagos['total'] ?? 0)) * $factord);
            $monto = convertir_a_float($monto - $montop);
            $total = convertir_a_float($monto * $factor['df_factor']);


            Http::json_response("$" . $monto . '= ' . Moneda::moneda($total, $divisa['locale'], $divisa['symbol']));
        }
    }

    public function obtenerAgente(int $id)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $newAgent = new EmpleadoAgente();

            Http::json_response($newAgent->consultar("SELECT * FROM app_empleados_agentes WHERE empagent_docid=$id AND empagent_tipo=2")->row());
        }
    }

    public function imprimirCredito()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {
            $id_credito = filter_input(INPUT_GET, 'id_credito', FILTER_SANITIZE_NUMBER_INT);
            $id_impresora = filter_input(INPUT_GET, 'id_impresora', FILTER_SANITIZE_NUMBER_INT);
            $result = $this->carritoVentas->imprimirCredito($id_credito, $id_impresora);
            if (isset($result['errors'])) {
                return Http::json_response(['errors' => $result['errors']]);
            } else {
                return Http::json_response($result);
            }
        }
    }

    public function obtenerFactura(int $id_factura)
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            $result = $this->carritoVentas->obtenerFactura('app_factura_master', 'faceditar', $id_factura);

            if (isset($result['errors'])) {
                return Http::json_response(['errors' => $result['errors']]);
            } else {
                return Http::json_response($result);
            }
        }
    }

    public function guardarDetallesCliente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['cli_tipodoc']))
                $this->array_errors[] = 'El campo Cedula de identidad es obligatorio';
            if (empty($_POST['cli_dni']))
                $this->array_errors[] = 'El campo Tipo de documento es obligatorio';
            if (empty($_POST['cli_razon_social']))
                $this->array_errors[] = 'El campo Razón social es obligatorio';
            if (empty($_POST['cli_direccion']))
                $this->array_errors[] = 'El campo Dirección es obligatorio';

            if (empty($this->array_errors)) {

                $cli_id             = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                $cli_tipodoc        = filter_input(INPUT_POST, 'cli_tipodoc', FILTER_SANITIZE_NUMBER_INT);
                $cli_dni            = filter_input(INPUT_POST, 'cli_dni', FILTER_SANITIZE_STRING);
                $cli_nombres        = $this->solicitud->sanitize($_POST['cli_razon_social'], FILTER_SANITIZE_STRING);
                $cli_direccion      = $this->solicitud->sanitize($_POST['cli_direccion'], FILTER_SANITIZE_STRING);
                $cli_pais           = filter_input(INPUT_POST, 'cli_paisid', FILTER_SANITIZE_NUMBER_INT);
                $cli_estado         = $this->solicitud->sanitize($_POST['cli_estado'], FILTER_SANITIZE_STRING);
                $cli_ciudad         = $this->solicitud->sanitize($_POST['cli_ciudad'], FILTER_SANITIZE_STRING);
                $cli_telefono       = filter_input(INPUT_POST, 'cli_telefono', FILTER_SANITIZE_STRING);
                $cli_fecha_nac      = $this->solicitud->sanitize($_POST['cli_fecha_nac'], FILTER_SANITIZE_STRING);
                $cli_codigopostal   = filter_input(INPUT_POST, 'cli_codigopostal', FILTER_SANITIZE_STRING);
                $cli_email          = filter_input(INPUT_POST, 'cli_email', FILTER_SANITIZE_STRING);

                $agente = filter_input(INPUT_POST, 'id_agente', FILTER_SANITIZE_NUMBER_INT);
                $captado  = $this->solicitud->sanitize($_POST['id_captado'], FILTER_SANITIZE_STRING);
                $factura  = $this->solicitud->sanitize($_POST['factura'], FILTER_SANITIZE_STRING);

                $result = $this->carritoVentas->editarDetallesCliente($cli_id, [
                    'cli_tipodocid'     => $cli_tipodoc,
                    'cli_dni'           => $cli_dni,
                    'cli_razon_social'  => $cli_nombres,
                    'cli_direccion'     => $cli_direccion,
                    'cli_paisid'        => $cli_pais,
                    'cli_estado'        => $cli_estado,
                    'cli_ciudad'        => $cli_ciudad,
                    'cli_codpostal'     => $cli_codigopostal,
                    'cli_telefono'      => $cli_telefono,
                    'cli_fecha_nac'     => $cli_fecha_nac,
                    'cli_email'         => $cli_email,
                ]);

                if (!empty($agente) && $agente > 0) {
                    $newAgent = new EmpleadoAgente();
                    if ($newAgent->existe('empagent_clientid', $cli_id)) {
                        if ($newAgent->modificarAgente($cli_id, $agente, $captado, $factura, 2)) {
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        } else {
                            if (isset($result['errors'])) {
                                return Http::json_response(['errors' => $result['errors']]);
                            } else {
                                return Http::json_response($result);
                            }
                        }
                    } else {
                        $this->array_errors[] = 'Este cliente no tiene asignado un agente';
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function enviarDocumento()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] = 'Acción prohibida';
            if (empty($_POST['descripcion']))
                $this->array_errors[] = 'El campo Descripcion es obligatorio.';
            if (empty($_FILES['documento']))
                $this->array_errors[] = 'El documento es obligatorio.';

            if (empty($this->array_errors)) {

                $id_factura = filter_var($_POST['id_factura'], FILTER_VALIDATE_INT);
                $descripcion = $this->solicitud->sanitize($_POST['descripcion'], FILTER_SANITIZE_STRING);

                if ($id_factura) {
                    $result = $this->carritoVentas->enviarDocumento('app_factura_master', $id_factura, $_FILES, $descripcion);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function guardarEnvioCliente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_factura             = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
            $env_nombre_opcional    = filter_input(INPUT_POST, 'env_nombre_opcional', FILTER_SANITIZE_STRING);
            $env_agencia_transporte = filter_input(INPUT_POST, 'env_agencia_transporte', FILTER_SANITIZE_STRING);
            $env_codigo_seguimiento = filter_input(INPUT_POST, 'env_codigo_seguimiento', FILTER_SANITIZE_STRING);
            $env_direccion          = filter_input(INPUT_POST, 'env_direccion', FILTER_SANITIZE_STRING);
            $env_pais               = filter_input(INPUT_POST, 'env_pais', FILTER_SANITIZE_NUMBER_INT);
            $env_estado             = filter_input(INPUT_POST, 'env_estado', FILTER_SANITIZE_STRING);
            $env_ciudad             = filter_input(INPUT_POST, 'env_ciudad', FILTER_SANITIZE_STRING);
            $env_codigopostal       = filter_input(INPUT_POST, 'env_codigopostal', FILTER_SANITIZE_STRING);
            $env_asegurado          = ('true' == filter_input(INPUT_POST, 'env_asegurado')) ? 1 : 0;

            if (!empty($id_factura)) {

                if (empty($env_agencia_transporte))
                    $this->array_errors[] = 'El campo Agencia de tranporte es obligatorio.';
                if (empty($env_codigo_seguimiento))
                    $this->array_errors[] = 'El campo Codigo de seguimiento es obligatorio.';
                if (empty($env_direccion))
                    $this->array_errors[] = 'El campo Dirección obligatorio.';
                if (empty($env_pais))
                    $this->array_errors[] = 'El campo País es obligatorio.';
                if (empty($env_estado))
                    $this->array_errors[] = 'El campo Estado es obligatorio.';
                if (empty($env_ciudad))
                    $this->array_errors[] = 'El campo Ciudad es obligatorio.';
                if (empty($env_codigopostal))
                    $this->array_errors[] = 'El campo Codigo postal es obligatorio.';

                if (empty($this->array_errors)) {

                    $data_factura = $this->notas_entrega_model->obtenerFactura($id_factura);

                    if ($data_factura['fm_estatus'] != 1) {
                        Http::json_response($this->notas_entrega_model->editar($id_factura, [
                            'fm_env_nombres'            => $env_nombre_opcional ?? $data_factura['fm_env_nombres'],
                            'fm_env_direccion'          => $env_direccion,
                            'fm_env_pais'               => $env_pais,
                            'fm_env_estado'             => $env_estado,
                            'fm_env_ciudad'             => $env_ciudad,
                            'fm_env_codigo_postal'      => $env_codigopostal,
                            'fm_env_agencia_transporte' => $env_agencia_transporte,
                            'fm_env_codigo_seguimiento' => $env_codigo_seguimiento,
                            'fm_env_asegurado'          => $env_asegurado,
                        ]));
                    } else {
                        $this->array_errors[] = 'La factura no se puede editar ya que ha sigo pagada en su totalidad.';
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function comprobarFactura($id_factura)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id_factura     = filter_var($id_factura, FILTER_SANITIZE_NUMBER_INT);
            $factura        = $this->notas_entrega_model->obtenerFactura($id_factura);
            if ($factura['fm_estatus'] == 1) {
                $this->array_errors[] = 'Ya la factura a sido pagada en su totalidad';
            } else {
                Http::json_response(true);
            }
            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerMetodosSegunDivisa()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_divisa  = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
            $id_factura = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
            $factor = 1;

            if (empty($id_divisa))
                $this->array_errors[] = 'Debe seleccionar una divisa';

            if (!empty($id_factura) && empty($this->array_errors)) {

                $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                $divisa = Moneda::obtenerDivisa($id_divisa);

                if ($divisa && $factura) {

                    $data_metodos   = $this->notas_entrega_model->obtenerMetodosSegunDivisa($id_divisa);

                    if ($data_metodos) {

                        if ($factura['fm_divid'] != $divisa['id']) {
                            $divisa_factor = $this->notas_entrega_model->obtenerDivisaAlCambio($factura['fm_divid'], $divisa['id']);
                            if ($divisa_factor) {
                                $factor = $divisa_factor['df_factor'];
                            } else {
                                $this->array_errors[] = 'Lo siento no se encuentra ningun valor de conversión para la moneda que intenta escoger y la moneda en que se realizo la factura';
                            }
                        }

                        if (empty($this->array_errors)) {

                            $movimiento_model = new MovimientoModel();
                            $total_pagos = $movimiento_model->totalPagos($factura['fm_id'], 2, 1);
                            $total = round(($factura['fm_total'] - ($total_pagos['total'] ?? 0)), 2);

                            Http::json_response([
                                'factor'            => $factor,
                                'divisa'            => $divisa,
                                'data_metodos'      => $data_metodos,
                                'restante'          => $total
                            ]);
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerCuentasSegunMetodo($id_metodo_divisa)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_metodo_divisa = filter_var($id_metodo_divisa, FILTER_SANITIZE_NUMBER_INT);

            if (empty($id_metodo_divisa))
                $this->array_errors[] = 'Debe seleccionar un metodo';

            if (empty($this->array_errors)) {
                $data = $this->notas_entrega_model->obtenerCuentasSegunMetodo($id_metodo_divisa);
                if ($data) {
                    Http::json_response($data);
                } else {
                    $this->array_errors[] = 'Lo siento no hay cuentas registradas para este metoto de pago';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    private function facturaFinalizada($id_factura)
    {
        $movimiento_model = new MovimientoModel();
        $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
        $total_pagos = $movimiento_model->totalPagos($id_factura, 2, 1);
        return (round($total_pagos['total'], 2) >= round($factura['fm_total'], 2)) ? true : false;
    }

    public function pagar()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            $per_pagar = $this->module->has_module_action_permission('facturacion', 'pagar', $_SESSION['user_data']['emp_id']);

            if ($per_pagar) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
                $id_divisa          = filter_input(INPUT_POST, 'id_divisa', FILTER_SANITIZE_NUMBER_INT);
                $id_metodo_divisa   = filter_input(INPUT_POST, 'id_metodo_divisa', FILTER_SANITIZE_NUMBER_INT);
                $id_cuenta_metodo   = filter_input(INPUT_POST, 'id_cuenta_metodo', FILTER_SANITIZE_NUMBER_INT);
                $monto              = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING);
                $generar_credito    = ('true' == $_POST['credito']) ? true : false;
                $compra_dolares    = ('true' == $_POST['compra_dolares']) ? true : false;
                $cuenta_pagod = json_decode($_POST['cuenta_pagod'], true);
                $referencia         = filter_input(INPUT_POST, 'referencia', FILTER_SANITIZE_STRING);
                $factor = filter_input(INPUT_POST, 'factor', FILTER_SANITIZE_STRING);

                if (empty($id_divisa))
                    $this->array_errors[] = 'El campo Divisa el obligatorio.';
                if (empty($id_metodo_divisa))
                    $this->array_errors[] = 'El campo Metodo el obligatorio.';
                if (empty($id_cuenta_metodo))
                    $this->array_errors[] = 'El campo Cuenta el obligatorio.';
                if (empty($monto))
                    $this->array_errors[] = 'El campo Monto el obligatorio.';

                if (!(is_countable($cuenta_pagod) && count($cuenta_pagod)) && $compra_dolares == true) {
                    $this->array_errors[] = 'Debe seleccionar una cuenta para realizar el pago de la compra de dolares.';
                }

                if (!empty($id_factura) && empty($this->array_errors)) {

                    $factura    = $this->notas_entrega_model->obtenerFactura($id_factura);

                    if ($factura && !$this->facturaFinalizada($factura['fm_id'])) {
                        $result = $this->carritoVentas->pagar('app_factura_master', $monto, $id_divisa, $id_factura, $generar_credito, $id_cuenta_metodo, $id_metodo_divisa, $compra_dolares, $cuenta_pagod, $referencia, true, $factor);
                        if (isset($result['errors'])) {
                            return Http::json_response(['errors' => $result['errors']]);
                        } else {
                            return Http::json_response($result);
                        }
                    }
                }

                Http::json_response(['errors' => $this->array_errors]);
            }
        }
    }

    public function eliminarPago()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'POST' && isAjax()) {

            if ($this->module->has_module_action_permission('facturacion', 'eliminar_pagos', $_SESSION['user_data']['emp_id'])) {

                $id         = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                $id_factura = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);

                if (!empty($id) && !empty($id_factura)) {

                    $factura = $this->notas_entrega_model->obtenerFactura($id_factura);

                    if ($factura['fm_estatus'] == 1) {
                        $this->array_errors[] = 'Lo siento no se puede eliminar el pago ya que la factura a sido cancelada en su totalidad';
                    } else {

                        $movimiento_model = new MovimientoModel();

                        $movimiento = $movimiento_model->abtenerMovimiento($id);

                        if ($movimiento && $factura['fm_id'] == $movimiento['fab_idgenerico']) {

                            if ($movimiento_model->abtenerMovimientoNegativo($id)) {
                                $this->array_errors[] = 'EL pago no se puede eliminar ya que se encuentra en reverso';
                            } else {

                                $cuenta = $this->notas_entrega_model->consultar("SELECT cmp_cueid, cmp_saldo FROM app_cuentas_metodopago WHERE cmp_id = {$movimiento['fab_cmpid']}")->row();
                                $total_saldo_cuenta = $this->notas_entrega_model->consultar("SELECT bc_saldo FROM app_bancos_cuentas WHERE bc_id = {$cuenta['cmp_cueid']}")->row();
                                $divisa_fac_mov = $this->carritoVentas->obtenerDivisa($movimiento['fab_divisa']);
                                $cliente = $this->carritoVentas->obtenerCliente($factura['fm_cliid']);

                                $movimiento_model->editar($movimiento['fab_id'], [
                                    'fab_retiro' => 1,
                                ]);

                                if ($movimiento_model->guardar([
                                    'fab_idgenerico'        => $movimiento['fab_idgenerico'],
                                    'fab_doc'               => 2,
                                    'fab_divisa'            => $movimiento['fab_divisa'],
                                    'fab_metodo'            => $movimiento['fab_metodo'],
                                    'fab_cmpid'             => $movimiento['fab_cmpid'],
                                    'fab_monto'             => $movimiento['fab_monto'] * -1,
                                    'fab_factor'            => $movimiento['fab_factor'],
                                    'fab_conversion'        => $movimiento['fab_conversion'] * -1,
                                    'fab_divid_conversion'  => $movimiento['fab_divid_conversion'],
                                    'fab_factor_master'     => $movimiento['fab_factor_master'],
                                    'fab_idretiro'          => $movimiento['fab_id'],
                                    'fab_retiro'            => 1,
                                    'fab_empid'             => $movimiento['fab_empid'],
                                    'fab_modulo'            => $movimiento['fab_modulo'],
                                    'fab_descripcion'       => '',
                                    'fab_observacion'       => 'Devolución FACV #' . $factura['fm_correlativo'] . ' ' . $cliente['cli_razon_social'] . ' Monto: ' . Moneda::moneda($movimiento['fab_monto'], $divisa_fac_mov['div_locale'], $divisa_fac_mov['div_simbolo']),
                                    'fab_categoria'         => 1,
                                    'fab_saldo_anterior'    => $total_saldo_cuenta['bc_saldo']
                                ])) {

                                    $this->notas_entrega_model->pagoPositivo($cuenta['cmp_cueid'], ($total_saldo_cuenta['bc_saldo'] - $movimiento['fab_monto']));
                                    $tcm = $cuenta['cmp_saldo'] - $movimiento['fab_monto'];
                                    $this->notas_entrega_model->consultar("UPDATE app_cuentas_metodopago SET cmp_saldo = $tcm WHERE cmp_id = {$movimiento['fab_cmpid']}")->run();

                                    $total_pagos = $movimiento_model->totalPagos($factura['fm_id'], 2, 1);

                                    $array_abonos = [];
                                    $abonos = $this->notas_entrega_model->abonos($factura['fm_id']);

                                    if (is_countable($abonos) && count($abonos)) {
                                        foreach ($abonos as $row) {
                                            $divisa_mov = $this->carritoVentas->obtenerDivisa($row['fab_divisa']);
                                            $divisa_conv_mov = $this->carritoVentas->obtenerDivisa($row['fab_divid_conversion']);
                                            $array_abonos[] = [
                                                'fab_id'            => $row['fab_id'],
                                                'fab_fecha'         => $row['fecha'],
                                                'bc_alias'          => $row['bc_alias'],
                                                'bc_tipo'           => $row['bc_tipo'],
                                                'fab_retiro'        => $row['fab_retiro'],
                                                'mp_nombre'         => $row['mp_nombre'],
                                                'fab_monto'         => Moneda::moneda($row['fab_monto'], $divisa_mov['div_locale'], $divisa_mov['div_simbolo']),
                                                'fab_factor'        => Moneda::decimal($row['fab_factor'], $this->divisa_master['div_locale']),
                                                'fab_conversion'    => Moneda::moneda($row['fab_conversion'], $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo'])
                                            ];
                                        }
                                    }

                                    Http::json_response([
                                        'abonos'        => $array_abonos,
                                        'total_factura' => round($factura['fm_total'], 2),
                                        'restante'      => round(($factura['fm_total'] - $total_pagos['total']), 2),
                                        'total_pagado'  => round($total_pagos['total'], 2)
                                    ]);
                                }
                            }
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para eliminar los pagos.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function eniviarFactura()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id     = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
            $de     = filter_input(INPUT_POST, 'de', FILTER_SANITIZE_EMAIL);
            $para   = filter_input(INPUT_POST, 'para', FILTER_SANITIZE_EMAIL);
            $copia  = filter_input(INPUT_POST, 'copia', FILTER_SANITIZE_EMAIL);
            $firma  = filter_input(INPUT_POST, 'firma', FILTER_SANITIZE_EMAIL);
            $tipo   = filter_input(INPUT_POST, 'tipo', FILTER_SANITIZE_NUMBER_INT) ?? 1;

            if (empty($de))
                $this->array_errors[] = 'El campo De es obligatorio.';
            if (empty($para))
                $this->array_errors[] = 'El campo Para es obligatorio.';

            if (empty($this->array_errors)) {

                $newVentasHistoricoEmail = new VentasHistoricoEmail();
                $data_factura = $this->notas_entrega_model->obtener($id);

                if (!empty($id)) {

                    switch ($tipo) {
                        case 1:
                            $pdf_nombre = 'Factura completa';
                            $mpdf = $this->pdfCompleto($id);
                            break;
                        case 2:
                            $pdf_nombre = 'Factura media pagina';
                            $mpdf = $this->pdfMediaPagina($id);
                            break;
                        case 3:
                            $pdf_nombre = 'Factura mas pagos';
                            $mpdf = $this->pdfPagos($id);
                            break;
                    }

                    $content = $mpdf['mpdf']->Output('', 'S');

                    $mail = new PHPMailer(true);

                    try {

                        $mail->isSMTP();
                        $mail->Host       = "{$mpdf['empresa']['emp_host_correo']}";
                        $mail->SMTPAuth   = true;
                        $mail->Username   = "{$mpdf['empresa']['emp_email']}";
                        $mail->Password   = "{$mpdf['empresa']['emp_email_password']}";
                        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
                        $mail->Port       = $mpdf['empresa']['emp_port_correo'];

                        $mail->setFrom($de);
                        $mail->addAddress($para);
                        $mail->addReplyTo($de, 'Empresa');

                        if (!empty($copia)) {
                            $mail->addAddress($copia);
                        }

                        $mail->addStringAttachment($content, "{$mpdf['mascara']}");

                        $mail->isHTML(true);
                        $mail->Subject = 'FACTURA';
                        $mail->Body    = "{$mpdf['mascara']}";

                        $mail->send();

                        $newVentasHistoricoEmail->guardar([
                            'venhisemail_idfac' => $id,
                            'venhisemail_cliid' => $data_factura['fm_cliid'],
                            'venhisemail_descripcion' => "Envio de factura de: $de para: $para tipo: $pdf_nombre",
                            'venhisemail_modulo' => 'NEV',
                            'venhisemail_empid' => $_SESSION['user_data']['einfo_id']
                        ]);

                        Http::json_response("Envio de factura exitosa");
                    } catch (Exception $e) {
                        $this->array_errors[] = "Message could not be sent. Mailer Error: {$mail->ErrorInfo}.";
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    private function pdfCompleto($id_factura)
    {
        $factura_data       = $this->notas_entrega_model->obtenerFacturaCompleta($id_factura);

        $articulos_model    = new PosArticulos();
        $articulos_data     = $articulos_model->articulos($factura_data['fm_id']);
        $cliente_data       = $this->carritoVentas->obtenerCliente($factura_data['fm_cliid']);
        $empresa_data       = $this->carritoVentas->obtenerDatosEmpresa();
        $documento_data     = $this->carritoVentas->obtenerDocumento(2);

        $mascara = mascara_correlativo('', $factura_data['ser_impuesto'], $factura_data['fm_correlativo']);

        $margin_top = 0;
        $margin_footer = 0;

        if ($factura_data['ser_id'] == 1) {
            $margin_top = 50;
            $margin_footer = 28;
        } else {
            $margin_top = 35;
            $margin_footer = 45;
        }

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 15,
            'margin_right'      => 15,
            'margin_top'        => $margin_top,
            'margin_bottom'     => 28,
            'margin_header'     => 50,
            'margin_footer'     => $margin_footer,
            'format'            => 'Letter',
            'orientation'       => 'P',
            'default_font_size' => 8,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle($mascara);
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject($mascara);
        /*
        $html_header = Vista::viewPDF('pdffacturas/factura/header', [
            'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
            'emp_rif'       => $empresa_data['emp_rif'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
            'emp_estado'    => $empresa_data['emp_estado'] ?? '',
            'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
        ]);

        $mpdf->SetHTMLHeader($html_header);*/

        $html_body = Vista::viewPDF('pdffacturas/factura/body_completo', [
            'factura'       => $mascara,
            'cliente'       => $cliente_data['cli_razon_social'],
            'direccion'     => $cliente_data['cli_direccion'],
            'fecha'         => date('Y-m-d', strtotime($factura_data['fm_fecha'])),
            'cedularif'     => $cliente_data['cli_dni'],
            'telefono'      => $cliente_data['cli_telefono'],
            'div_locale'    => $factura_data['div_locale'],
            'div_simbolo'  => $factura_data['div_simbolo'],
            'articulos'     => $articulos_data,
            'observaciones' => $factura_data['fm_observaciones']
        ]);

        $mpdf->WriteHTML($html_body);

        $html_footer = Vista::viewPDF('pdffacturas/factura/footer', [
            'div_locale'    => $factura_data['div_locale'],
            'div_simbolo'  => $factura_data['div_simbolo'],
            'total'         => $factura_data['fm_total'],
            'iva'           => $factura_data['fm_iva'],
            'neto'          => $factura_data['fm_neto'],
            'descuento'     => $factura_data['fm_descuento']
        ]);

        $mpdf->SetHTMLFooter($html_footer);

        return [
            'mpdf'      => $mpdf,
            'mascara'   => $mascara . '.pdf',
            'empresa'   => $empresa_data,
        ];
    }

    private function pdfMediaPagina($id_factura)
    {
        $factura_data = $this->notas_entrega_model->obtenerFacturaCompleta($id_factura);

        $articulos_model    = new PosArticulos();
        $articulos_data     = $articulos_model->articulos($factura_data['fm_id']);
        $cliente_data       = $this->carritoVentas->obtenerCliente($factura_data['fm_cliid']);
        $empresa_data       = $this->carritoVentas->obtenerDatosEmpresa();
        $documento_data     = $this->carritoVentas->obtenerDocumento(2); // FACTURA

        $mascara = mascara_correlativo($documento_data['doc_prefijo'], $factura_data['ser_impuesto'], $factura_data['fm_correlativo']);

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 15,
            'margin_right'      => 15,
            'margin_top'        => 45,
            'margin_bottom'     => 18,
            'margin_header'     => 40,
            'margin_footer'     => 10,
            'format'            => [210, 148.5],
            'orientation'       => 'P',
            'default_font_size' => 8,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle($mascara);
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject($mascara);

        /*
        $html_header = Vista::viewPDF('pdffacturas/factura/header', [
            'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
            'emp_rif'       => $empresa_data['emp_rif'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
            'emp_estado'    => $empresa_data['emp_estado'] ?? '',
            'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
        ]);

        $mpdf->SetHTMLHeader($html_header);

         */

        $html_body = Vista::viewPDF('pdffacturas/factura/body_completo', [
            'factura'       => $mascara,
            'cliente'       => $cliente_data['cli_razon_social'],
            'direccion'     => $cliente_data['cli_direccion'],
            'fecha'         => date('Y-m-d', strtotime($factura_data['fm_fecha'])),
            'cedularif'     => $cliente_data['cli_dni'],
            'telefono'      => $cliente_data['cli_telefono'],
            'div_locale'    => $factura_data['div_locale'],
            'div_simbolo'  => $factura_data['div_simbolo'],
            'articulos'     => $articulos_data,
            'observaciones' => $factura_data['fm_observaciones']
        ]);

        $mpdf->WriteHTML($html_body);

        $html_footer = Vista::viewPDF('pdffacturas/factura/footer', [
            'div_locale'    => $factura_data['div_locale'],
            'div_simbolo'  => $factura_data['div_simbolo'],
            'total'         => $factura_data['fm_total'],
            'iva'           => $factura_data['fm_iva'],
            'neto'          => $factura_data['fm_neto'],
            'descuento'     => $factura_data['fm_descuento']
        ]);

        $mpdf->SetHTMLFooter($html_footer);

        return [
            'mpdf'      => $mpdf,
            'mascara'   => $mascara . '.pdf',
            'empresa'   => $empresa_data,
        ];
    }

    public function pdfPagos($id_factura)
    {
        $factura_data = $this->notas_entrega_model->obtenerFacturaCompleta($id_factura);

        $articulos_model    = new PosArticulos();
        $articulos_data     = $articulos_model->articulos($factura_data['fm_id']);
        $cliente_data       = $this->carritoVentas->obtenerCliente($factura_data['fm_cliid']);
        $empresa_data       = $this->carritoVentas->obtenerDatosEmpresa();
        $documento_data     = $this->carritoVentas->obtenerDocumento(2); // FACTURA

        $mascara = mascara_correlativo($documento_data['doc_prefijo'], $factura_data['ser_impuesto'], $factura_data['fm_correlativo']);

        $mpdf = new \Mpdf\Mpdf([
            'mode'              => 'utf-8',
            'margin_left'       => 15,
            'margin_right'      => 15,
            'margin_top'        => 35,
            'margin_bottom'     => 30,
            'margin_header'     => 15,
            'margin_footer'     => 20,
            'format'            => [210, 148.5],
            'orientation'       => 'P',
            'default_font_size' => 8,
            'default_font'      => 'helvetica'
        ]);

        $mpdf->SetTitle($mascara);
        $mpdf->SetAuthor($empresa_data['emp_nombre']);
        $mpdf->SetCreator($empresa_data['emp_nombre']);
        $mpdf->SetSubject($mascara);

        $html_header = Vista::viewPDF('pdffacturas/factura/header', [
            'emp_nombre'    => $empresa_data['emp_nombre'] ?? '',
            'emp_rif'       => $empresa_data['emp_rif'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_direccion' => $empresa_data['emp_direccion'] ?? '',
            'emp_codpostal' => $empresa_data['emp_codpostal'] ?? '',
            'emp_estado'    => $empresa_data['emp_estado'] ?? '',
            'emp_ciudad'    => $empresa_data['emp_ciudad'] ?? '',
        ]);

        $mpdf->SetHTMLHeader($html_header);

        $html_body = Vista::viewPDF('pdffacturas/factura/body_completo', [
            'factura'       => $mascara,
            'cliente'       => $cliente_data['cli_razon_social'],
            'direccion'     => $cliente_data['cli_direccion'],
            'fecha'         => date('Y-m-d', strtotime($factura_data['fm_fecha'])),
            'cedularif'     => $cliente_data['cli_dni'],
            'telefono'      => $cliente_data['cli_telefono'],
            'div_locale'    => $factura_data['div_locale'],
            'div_simbolo'  => $factura_data['div_simbolo'],
            'articulos'     => $articulos_data,
            'observaciones' => $factura_data['fm_observaciones']
        ]);

        $mpdf->WriteHTML($html_body);

        $html_footer = Vista::viewPDF('pdffacturas/factura/footer', [
            'div_locale'    => $factura_data['div_locale'],
            'div_simbolo'  => $factura_data['div_simbolo'],
            'total'         => $factura_data['fm_total'],
            'iva'           => $factura_data['fm_iva'],
            'neto'          => $factura_data['fm_neto'],
            'descuento'     => $factura_data['fm_descuento']
        ]);

        $mpdf->SetHTMLFooter($html_footer);

        $mpdf->AddPage();

        $array_abonos = [];
        $total_abonos = 0;
        $abonos = $this->notas_entrega_model->abonos($id_factura);

        if (is_countable($abonos) && count($abonos)) {
            foreach ($abonos as $row) {
                $divisa_mov = $this->carritoVentas->obtenerDivisa($row['fab_divisa']);
                $divisa_conv_mov = $this->carritoVentas->obtenerDivisa($row['fab_divid_conversion']);
                $array_abonos[] = [
                    'fab_id'            => $row['fab_id'],
                    'fab_fecha'         => $row['fecha'],
                    'bc_alias'          => $row['bc_alias'],
                    'bc_tipo'           => $row['bc_tipo'],
                    'fab_retiro'        => $row['fab_retiro'],
                    'mp_nombre'         => $row['mp_nombre'],
                    'fab_monto'         => Moneda::moneda($row['fab_monto'], $divisa_mov['div_locale'], $divisa_mov['div_simbolo']),
                    'fab_factor'        => Moneda::decimal($row['fab_factor'], $this->divisa_master['div_locale']),
                    'fab_conversion'    => Moneda::moneda($row['fab_conversion'], $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo'])
                ];

                $total_abonos += $row['fab_conversion'];
            }
        }

        $pendiente = abs($factura_data['fm_total'] - $total_abonos);

        if (is_countable($abonos) && count($abonos)) {
            $html_abonos = Vista::viewPDF('pdffacturas/factura/abonos', [
                'total' => Moneda::moneda($factura_data['fm_total'], $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo']),
                'pendiente' => Moneda::moneda($pendiente, $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo']),
                'abonos' => $array_abonos,
                'abonado' => Moneda::moneda($total_abonos, $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo'])
            ]);
        } else {
            $html_abonos = Vista::viewPDF('pdffacturas/factura/abonos', [
                'total' => Moneda::moneda($factura_data['fm_total'], $factura_data['div_locale'], $factura_data['div_simbolo']),
                'pendiente' => Moneda::moneda($factura_data['fm_total'], $factura_data['div_locale'], $factura_data['div_simbolo']),
                'abonos' => $array_abonos,
                'abonado' => 0
            ]);
        }

        $mpdf->WriteHTML($html_abonos);

        $footer = Vista::viewPDF('pdffacturas/factura/footerFMP');

        $mpdf->SetHTMLFooter($footer);

        return [
            'mpdf'      => $mpdf,
            'mascara'   => $mascara . '.pdf',
            'empresa'   => $empresa_data,
        ];
    }

    public function pdf($id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            $factura_data = $this->notas_entrega_model->obtenerFacturaCompleta($id);

            if (!$factura_data) {
                Http::notFound();
            }

            $mpdf = $this->pdfCompleto($id);

            $mpdf['mpdf']->Output("{$mpdf['mascara']}", \Mpdf\Output\Destination::INLINE);
            exit;
        }
    }

    public function pdfMP($id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            $factura_data = $this->notas_entrega_model->obtenerFacturaCompleta($id);

            if (!$factura_data) {
                Http::notFound();
            }

            $mpdf = $this->pdfMediaPagina($id);

            $mpdf['mpdf']->Output("{$mpdf['mascara']}", \Mpdf\Output\Destination::INLINE);
            exit;
        }
    }

    public function pdfFMP($id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD']) {

            $id = filter_var($id, FILTER_SANITIZE_NUMBER_INT);

            $factura_data = $this->notas_entrega_model->obtenerFacturaCompleta($id);

            if (!$factura_data) {
                Http::notFound();
            }

            $mpdf = $this->pdfPagos($id);

            $mpdf['mpdf']->Output("{$mpdf['mascara']}", \Mpdf\Output\Destination::INLINE);
            exit;
        }
    }

    public function obtnerDocumentos($id_factura)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $facturadocumentos_model = new FacturaDocumentos();
            $id_factura = filter_var($id_factura, FILTER_SANITIZE_NUMBER_INT);
            $archivo_all = [];

            if (!empty($id_factura)) {
                $archivos = $facturadocumentos_model->obtenerDocumentos($id_factura);

                $extenciones = array('jpg', 'jpeg', 'png', 'gif');

                if (is_countable($archivos) && count($archivos)) {

                    foreach ($archivos as $row) {

                        $fileNameCmps = explode(".", basename($row['facdoc_documento']));
                        $fileExtension = strtolower(end($fileNameCmps));

                        $imagen = (in_array($fileExtension, $extenciones)) ? true : false;
                        $archivo_all[] = [
                            'imagen' => $imagen,
                            'archivo' => $row['facdoc_documento'],
                            'descripcion' => $row['facdoc_descripcion'],
                            'fecha' => $row['facdoc_fecha']
                        ];
                    }
                }

                Http::json_response($archivo_all);
            }
        }
    }

    private function esEditable($id_factura)
    {
        $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
        return ($factura['fm_estatus'] == 1) ? false : true;
    }

    public function guardarClienteCambiar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] = 'Acción prohibida';
            if (empty($_POST['cli_tipodoc']))
                $this->array_errors[] = 'El campo Cedula de identidad es obligatorio';
            if (empty($_POST['cli_dni']))
                $this->array_errors[] = 'El campo Tipo de documento es obligatorio';
            if (empty($_POST['cli_razon_social']))
                $this->array_errors[] = 'El campo Razón social es obligatorio';
            if (empty($_POST['cli_direccion']))
                $this->array_errors[] = 'El campo Dirección es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura         = filter_input(INPUT_POST, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
                $cli_id             = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
                $cli_tipodoc        = filter_input(INPUT_POST, 'cli_tipodoc', FILTER_SANITIZE_NUMBER_INT);
                $cli_dni            = filter_input(INPUT_POST, 'cli_dni', FILTER_SANITIZE_STRING);
                $cli_email          = filter_input(INPUT_POST, 'cli_email', FILTER_SANITIZE_STRING);
                $cli_telefono       = filter_input(INPUT_POST, 'cli_telefono', FILTER_SANITIZE_STRING);
                $cli_nombres        = $this->solicitud->sanitize($_POST['cli_razon_social'], FILTER_SANITIZE_STRING);
                $cli_direccion      = $this->solicitud->sanitize($_POST['cli_direccion'], FILTER_SANITIZE_STRING);
                $cli_natural        = ('true' == filter_input(INPUT_POST, 'cli_natural')) ? 1 : 0;

                if ($this->esEditable($id_factura)) {
                    $result = $this->carritoVentas->guardarClienteCambiar('app_factura_master', $id_factura, [
                        'cli_tipodocid'     => $cli_tipodoc,
                        'cli_dni'           => $cli_dni,
                        'cli_razon_social'  => $cli_nombres,
                        'cli_direccion'     => $cli_direccion,
                        'cli_natural'       => $cli_natural,
                        'cli_email'         => $cli_email,
                        'cli_telefono'      => $cli_telefono
                    ]);
                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Documento no editable';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function cambiarCliente()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            $id_cliente     = filter_input(INPUT_GET, 'id_cliente', FILTER_SANITIZE_NUMBER_INT);
            $id_factura     = filter_input(INPUT_GET, 'id_factura', FILTER_SANITIZE_NUMBER_INT);

            if (!empty($id_cliente) && !empty($id_factura)) {
                if ($this->esEditable($id_factura)) {
                    $factura = $this->notas_entrega_model->obtenerFactura($id_factura);
                    $cliente_anterior = $this->notas_entrega_model->consultar("SELECT * FROM app_clientes WHERE cli_id={$factura['ne_cliid']}")->row();

                    $result = $this->carritoVentas->cambiarCliente('app_factura_master', $id_cliente, $id_factura);
                    $cliente_nuevo = $this->notas_entrega_model->consultar("SELECT * FROM app_clientes WHERE cli_id={$id_cliente}")->row();

                    $this->notas_entrega_model->guardar([
                        "bitdoc_empid" => $_SESSION['user_data']['emp_id'],
                        "bitdoc_descripcion" => "El empleado " . $_SESSION['user_data']['einfo_nombres'] . " " . $_SESSION['user_data']['einfo_apellidos'] . " ha cambiado el cliente <b>" . $cliente_anterior['cli_razon_social'] . "</b> a <b>" . $cliente_nuevo['cli_razon_social'] . "</b>.",
                        "bitdoc_doc" => 2,
                        "bitdoc_idgenerico" => $id_factura,
                    ], true, "app_bitacora_doc");

                    if (isset($result['errors'])) {
                        return Http::json_response(['errors' => $result['errors']]);
                    } else {
                        return Http::json_response($result);
                    }
                } else {
                    $this->array_errors[] = 'Documento no editable';
                }
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function anularFactura()
    {
        if ($_SERVER['REQUEST_METHOD'] == 'GET' && isAjax()) {

            if ($this->module->has_module_action_permission('facturacion', 'anular_doc', $_SESSION['user_data']['emp_id'])) {

                $id_factura     = filter_input(INPUT_GET, 'id_factura', FILTER_SANITIZE_NUMBER_INT);
                $descripcion    = filter_input(INPUT_GET, 'descripcion', FILTER_SANITIZE_STRING);

                $factura = $this->notas_entrega_model->obtenerFactura($id_factura);

                if (!$factura) {
                    $this->array_errors[] = 'ACCESO DENEGADO';
                    return Http::json_response(['errors' => $this->array_errors]);
                }

                if ($factura['fm_estatus'] == 3) {
                    $this->array_errors[] = 'La factura ya se encuentra anulada.';
                }

                if (empty($this->array_errors)) {

                    $correlativo = $this->carritoVentas->chuequearCorrelativo($factura['fm_serid'], 7);
                    $serie      = $this->carritoVentas->obtenerSerie($factura['fm_serid']);

                    if ($correlativo == false) {
                        $this->array_errors[] = "No existe correlativo entre la se serie $serie[ser_descripcion] y el documento Notas de credito por favor dirijase a Modulo Configuración -> correlativos";
                    }

                    if (empty($this->array_errors)) {

                        $new_articulos  = new PosArticulos();
                        $new_movimiento = new MovimientoModel();
                        $new_credito = new Notadecredito();
                        $articulos = $new_articulos->articulos($factura['fm_id']);
                        $movimientos = $new_movimiento->obtenerMovimientosDocumento($factura['fm_id'], 2);
                        $total_pagos = 0;

                        if ($this->notas_entrega_model->editar($factura['fm_id'], [
                            'fm_estatus' => 3,
                            'fm_observaciones' => $factura['fm_observaciones'] . ' (ANULADO ' . $descripcion . ')'
                        ])) {

                            foreach ($articulos as $row) {
                                $almacen  = $this->carritoVentas->obtenerAlmacen($row['fa_almid']);

                                $produc = $this->carritoVentas->obtenerProducto($row['fa_proid']);

                                if ($produc['pro_tipo'] == 2) {
                                    $productoCompuesto = new ProductosCompuestos();

                                    $productos = $productoCompuesto->obtenerProductosCompuesto($row['fa_proid']);

                                    if (is_countable($productos) && count($productos)) {
                                        foreach ($productos as $row1) {
                                            $cantidad_stock = $this->carritoVentas->chuequearStock($row1['pro_id'], $row['fa_almid']);

                                            $cant = $row['fa_descontar_inventario'] * $row1['pro_cccant'];

                                            if ($row['fa_descontar_inventario'] > 0 && $this->notas_entrega_model->restablecerStock($row1['pro_id'], $row['fa_almid'], $cant)) {
                                                Notifica::stock($row1['pro_id'], "{$almacen['alm_nombre']}", 'ventas', $cantidad_stock['ps_cantidad'], $cant, 0, $cantidad_stock['ps_cantidad'] + $cant, $factura['fm_correlativo'], 2);
                                            }
                                        }
                                    }
                                    $cantidad_stocks = $this->carritoVentasEditar->chuequearStock($row['fa_proid'], $row['fa_almid']);
                                    if ($row['fa_descontar_inventario'] > 0 && $this->notas_entrega_model->restablecerStock($row['fa_proid'], $row['fa_almid'], $row['fa_descontar_inventario'])) {
                                        $new_articulos->editar($row['fa_id'], ['fa_descontar_inventario' => 0]);
                                        Notifica::stock($row['fa_proid'], "{$almacen['alm_nombre']}", 'ventas', $cantidad_stocks['ps_cantidad'], $row['fa_descontar_inventario'], 0, $cantidad_stocks['ps_cantidad'] + $row['fa_descontar_inventario'], $factura['fm_correlativo'], 2);
                                    }
                                } else {
                                    $cantidad_stock = $this->carritoVentas->chuequearStock($row['fa_proid'], $row['fa_almid']);
                                    if ($row['fa_descontar_inventario'] > 0 && $this->notas_entrega_model->restablecerStock($row['fa_proid'], $row['fa_almid'], $row['fa_descontar_inventario'])) {
                                        $new_articulos->editar($row['fa_id'], ['fa_descontar_inventario' => 0]);
                                        Notifica::stock($row['fa_proid'], "{$almacen['alm_nombre']}", 'ventas', $cantidad_stock['ps_cantidad'], $row['fa_descontar_inventario'], 0, $cantidad_stock['ps_cantidad'] + $row['fa_descontar_inventario'], $factura['fm_correlativo'], 2);
                                    }
                                }
                            }

                            if (is_countable($movimientos) && count($movimientos)) {

                                foreach ($movimientos as $row) {
                                    if ($row['fab_divisa'] == $this->divisa_master['div_id']) {
                                        $total_pagos += $row['fab_monto'];
                                    } else {
                                        $total_pagos += $row['fab_monto'] / $row['fab_factor_master'];
                                    }
                                }

                                if ($new_credito->guardar([
                                    'cre_cliid'         => $factura['fm_cliid'],
                                    'cre_facid'         => $factura['fm_id'],
                                    'cre_docid'         => 2,
                                    'cre_empleado'      => $_SESSION['user_data']['emp_id'],
                                    'cre_modulo'        => 'FACV',
                                    'cre_descripcion'   => $descripcion,
                                    'cre_correlativo'   => $correlativo['cor_correlativo'] + 1,
                                    'cre_monto'         => $total_pagos
                                ], true)) {
                                    $this->carritoVentas->actualizarCorrelativo($serie['ser_id'], 7, ($correlativo['cor_correlativo'] + 1));
                                }
                            }

                            $new_comisiones = new EmpleadosComisionesEmplAgente();
                            $new_comisiones->eliminarNotaFactId($id_factura, 2);

                            return Http::json_response(ruta_base() . 'poseditar/verFactura/' . $id_factura);
                        } else {
                            Http::json_response(false);
                        }
                    }
                }
            } else {
                $this->array_errors[] = 'Acceso prohibido no posee permisos para anular el documento.';
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerCreditos(int $id_cliente)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_cliente = $this->solicitud->sanitize($id_cliente, FILTER_SANITIZE_NUMBER_INT);

            $newNotaDeCredito = new Notadecredito();
            $newNotadeCreditoDetalles = new NotadeCreditoDetalles();

            $lista_creditos = [];

            $creditos = $newNotaDeCredito->obtenerCreditosClientes($id_cliente);

            if (is_countable($creditos) && count($creditos)) {
                foreach ($creditos as $row) {
                    $total_credito = $newNotadeCreditoDetalles->obtenerTotalPagosCreditos($row['cre_id']);
                    $lista_creditos[] = [
                        'id' => $row['cre_id'],
                        'monto' => $row['cre_monto'] - ($total_credito['total']) ?? 0
                    ];
                }
            }

            Http::json_response($lista_creditos);
        }
    }

    public function pagarConCredito()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax() && (!empty($_GET['id_fac']) && !empty($_GET['id_credito']))) {
            $newCreditoaPagos = new Notadecredito();
            $newNotadeCreditoDetalles = new NotadeCreditoDetalles();
            $movimiento_model = new MovimientoModel();
            $id_factura = $this->solicitud->sanitize($_GET['id_fac'], FILTER_SANITIZE_NUMBER_INT);
            $id_credito = $this->solicitud->sanitize($_GET['id_credito'], FILTER_SANITIZE_NUMBER_INT);
            $factura    = $this->notas_entrega_model->obtenerFactura($id_factura);
            if ($this->facturaFinalizada($factura['fm_id'])) {
                Http::json_response('pagado');
            } else {

                $factor_master = 1;
                $factor_factura = 1;

                $data_credito = $newCreditoaPagos->obtener($id_credito);
                $total_credito = $newNotadeCreditoDetalles->obtenerTotalPagosCreditos($data_credito['cre_id']);
                $total_disponible = $data_credito['cre_monto'] - ($total_credito['total']) ?? 0;
                $cliente = $this->carritoVentas->obtenerCliente($factura['fm_cliid']);
                $total_pagos = $movimiento_model->totalPagos($id_factura, 2, 1);
                $restante = $factura['fm_total'] - $total_pagos['total'] ?? 0;

                if ($factura['fm_divid'] != $this->divisa_master['div_id']) {
                    $factor = $this->notas_entrega_model->obtenerDivisaAlCambio($factura['fm_divid'], $this->divisa_master['div_id']);
                    if (!$factor) {
                        $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa de la factura y la divisa predeterminada.';
                    } else {
                        $total_disponible = round(($total_disponible / $factor['df_factor']), 2);
                    }
                    $data_factor_factura = $this->notas_entrega_model->obtenerDivisaAlCambio($this->divisa_master['div_id'], $factura['fm_divid']);
                    if (!$data_factor_factura) {
                        $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa predeterminada y la divisa en que se registró la factura.';
                    } else {
                        $factor_factura = $data_factor_factura['df_factor'];
                        $factor_master = $data_factor_factura['df_factor'];
                    }
                }

                if (empty($this->array_errors)) {

                    if ($total_disponible > round($restante, 2)) {
                        $monto = $restante;
                    } else {
                        $monto = $total_disponible;
                    }

                    $conversion = $monto / $factor_factura;

                    $id_movimiento = $movimiento_model->guardar([
                        'fab_idgenerico'        => $factura['fm_id'],
                        'fab_doc'               => 2,
                        'fab_monto'             => $conversion,
                        'fab_factor'            => $factor_factura,
                        'fab_conversion'        => $monto,
                        'fab_retiro'            => 0,
                        'fab_factor_master'     => $factor_master,
                        'fab_empid'             => $_SESSION['user_data']['emp_id'],
                        'fab_modulo'            => 'factura',
                        'fab_descripcion'       => '',
                        'fab_observacion'       => 'Pago con saldo Credito en FAV #' . $factura['fm_correlativo'] . ' ' . $cliente['cli_razon_social'] . ' Monto: ' . Moneda::moneda($monto, $this->divisa_master['div_locale'], $this->divisa_master['div_simbolo']),
                        'fab_credito'           => 1,
                        'fab_categoria'         => 1
                    ]);

                    if ($id_movimiento) {

                        $newNotadeCreditoDetalles->guardar([
                            'credet_movid' => $id_movimiento,
                            'credet_creid' => $data_credito['cre_id'],
                            'credet_idfac' => $factura['fm_id'],
                            'credet_docid' => 2,
                            'credet_monto' => $conversion,
                            'credet_descripcion' => "Pago con nota de credito #{$data_credito['cre_correlativo']} por el monto de $monto",
                            'credet_empid' => $_SESSION['user_data']['einfo_id'],
                            'credet_modulo' => 'FACV'
                        ]);

                        $total_credito = $newNotadeCreditoDetalles->obtenerTotalPagosCreditos($data_credito['cre_id']);

                        if (round($data_credito['cre_monto'], 2) == round($total_credito['total'], 2)) {
                            $newCreditoaPagos->editar($data_credito['cre_id'], [
                                'cre_estatus' => 1
                            ]);
                        }

                        $pagado = false;

                        if ($this->facturaFinalizada($factura['fm_id'])) {
                            $this->notas_entrega_model->culminarFactura($id_factura);
                            $pagado = true;
                        }

                        $factura = $this->notas_entrega_model->obtenerFactura($id_factura);

                        $array_abonos = [];

                        $total_pagos = $movimiento_model->totalPagos($factura['fm_id'], 2, 1);
                        $abonos = $this->notas_entrega_model->abonos($factura['fm_id']);

                        if (is_countable($abonos) && count($abonos)) {

                            foreach ($abonos as $row) {

                                if (is_null($row['fab_divisa'])) {
                                    $divisa_mov = $this->divisa_master;
                                } else {
                                    $divisa_mov = $this->carritoVentas->obtenerDivisa($row['fab_divisa']);
                                }

                                if (is_null($row['fab_divid_conversion'])) {
                                    $divisa_conv_mov = $this->divisa_master;
                                } else {
                                    $divisa_conv_mov = $this->carritoVentas->obtenerDivisa($row['fab_divid_conversion']);
                                }

                                if (is_null($row['fab_factor'])) {
                                    $row['fab_factor'] = 1;
                                }

                                $array_abonos[] = [
                                    'fab_id'            => $row['fab_id'],
                                    'fab_fecha'         => $row['fecha'],
                                    'bc_alias'          => $row['bc_alias'],
                                    'bc_tipo'           => $row['bc_tipo'],
                                    'fab_retiro'        => $row['fab_retiro'],
                                    'mp_nombre'         => $row['mp_nombre'],
                                    'fab_monto'         => Moneda::moneda($row['fab_monto'], $divisa_mov['div_locale'], $divisa_mov['div_simbolo']),
                                    'fab_factor'        => Moneda::decimal($row['fab_factor'], $this->divisa_master['div_locale']),
                                    'fab_conversion'    => Moneda::moneda($row['fab_conversion'], $divisa_conv_mov['div_locale'], $divisa_conv_mov['div_simbolo']),
                                    'credito'           => $row['fab_credito']
                                ];
                            }
                        }

                        Http::json_response([
                            'abonos'        => $array_abonos,
                            'total_factura' => round($factura['fm_total'], 2),
                            'pagado'        => $pagado,
                            'restante'      => round(($factura['fm_total'] - $total_pagos['total']), 2),
                            'total_pagado'  => round($total_pagos['total'], 2)
                        ]);
                    }
                } else {
                    Http::json_response(['errors' => $this->array_errors]);
                }
            }
        }
    }

    public function obtenerFactor()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax() && (!empty($_GET['id_factura']) && !empty($_GET['id_credito']))) {
            $id_factura = $this->solicitud->sanitize($_GET['id_factura'], FILTER_VALIDATE_INT);
            $id_credito = $this->solicitud->sanitize($_GET['id_credito'], FILTER_VALIDATE_INT);
            if ($this->notas_entrega_model->existe('fm_id', $id_factura)) {

                $data_factura = $this->notas_entrega_model->obtener($id_factura);
                $newCreditoa = new Notadecredito();
                $newNotadeCreditoDetalles = new NotadeCreditoDetalles();

                $data_credito = $newCreditoa->obtener($id_credito);
                $total_credito = $newNotadeCreditoDetalles->obtenerTotalPagosCreditos($data_credito['cre_id']);
                $total_disponible = $data_credito['cre_monto'] - ($total_credito['total']) ?? 0;

                if ($data_factura['fm_divid'] != $this->divisa_master['div_id']) {
                    $factor = $this->notas_entrega_model->obtenerDivisaAlCambio($data_factura['fm_divid'], $this->divisa_master['div_id']);
                    if (!$factor) {
                        $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa predeterminada y la divisa en que se registró la factura.';
                    } else {
                        $total_disponible = round(($total_disponible / $factor['df_factor']), 2);
                    }
                }

                if (empty($this->array_errors)) {
                    Http::json_response($total_disponible);
                } else {
                    Http::json_response(0);
                }
            }
        }
    }

    public function reimprimirFactura()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            if (!empty($_GET['id_factura']) && !empty($_GET['impresora'])) {
                $id_factura     = $this->solicitud->sanitize($_GET['id_factura'], FILTER_VALIDATE_INT);
                $id_impresora   = $this->solicitud->sanitize($_GET['impresora'], FILTER_VALIDATE_INT);

                if ($id_factura && $id_impresora) {
                    if ($this->notas_entrega_model->existe('fm_id', $id_factura)) {
                        $impresora = $this->notas_entrega_model->consultar("SELECT imp_tipo FROM app_impresoras WHERE imp_id = $id_impresora")->row();
                        if ($impresora) {
                            if ($impresora['imp_tipo'] == 1) {
                                $result = $this->carritoVentas->reimprimirFactura($id_factura, $id_impresora);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'No puede imprimir  una factura en un ticket';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }
            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function imprimir()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_GET['id_factura']) && !empty($_GET['impresora'])) {

                $id_factura     = $this->solicitud->sanitize($_GET['id_factura'], FILTER_VALIDATE_INT);
                $id_impresora   = $this->solicitud->sanitize($_GET['impresora'], FILTER_VALIDATE_INT);

                if ($id_factura && $id_impresora) {
                    if ($this->notas_entrega_model->existe('fm_id', $id_factura)) {
                        $impresora = $this->notas_entrega_model->consultar("SELECT imp_tipo FROM app_impresoras WHERE imp_id = $id_impresora")->row();
                        if ($impresora) {
                            if ($impresora['imp_tipo'] == 1) {
                                $result = $this->carritoVentas->imprimir('app_factura_master', $id_factura, $id_impresora);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'No puede imprimir  una factura en un ticket';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function imprimirAnular()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (!empty($_GET['id_factura']) && !empty($_GET['impresora'])) {

                $id_factura     = $this->solicitud->sanitize($_GET['id_factura'], FILTER_VALIDATE_INT);
                $id_impresora   = $this->solicitud->sanitize($_GET['impresora'], FILTER_VALIDATE_INT);
                $numero   = $this->solicitud->sanitize($_GET['numero'], FILTER_VALIDATE_INT);

                if ($id_factura && $id_impresora) {
                    if ($this->notas_entrega_model->existe('fm_id', $id_factura)) {
                        $impresora = $this->notas_entrega_model->consultar("SELECT imp_tipo FROM app_impresoras WHERE imp_id = $id_impresora")->row();
                        if ($impresora) {
                            if ($impresora['imp_tipo'] == 1) {
                                $result = $this->carritoVentas->imprimirAnular('app_factura_master', $id_factura, $id_impresora, $numero);
                                if (isset($result['errors'])) {
                                    return Http::json_response(['errors' => $result['errors']]);
                                } else {
                                    return Http::json_response($result);
                                }
                            } else {
                                $this->array_errors[] = 'No puede imprimir una factura en un ticket';
                            }
                        } else {
                            $this->array_errors[] = 'Acción prohibida';
                        }
                    } else {
                        $this->array_errors[] = 'Acción prohibida';
                    }
                } else {
                    $this->array_errors[] = 'Acción prohibida';
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function obtenerubicacionProductos(int $id_factura)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            $id_factura = filter_var($id_factura, FILTER_SANITIZE_NUMBER_INT);
            Http::json_response($this->carritoVentas->obtenerUbicacionesProducto('faceditar', $id_factura));
        }
    }

    public function guardarCredito()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] =  'El campo Factura es obligatorio.';
            if (empty($_POST['monto']))
                $this->array_errors[] =  'El campo Monto es obligatorio.';
            if (empty($_POST['id_divisa']))
                $this->array_errors[] =  'El campo Divisa es obligatorio';
            if (empty($_POST['id_metodo_divisa']))
                $this->array_errors[] =  'El campo Metodo es obligatorio';
            if (empty($_POST['id_cuenta_metodo']))
                $this->array_errors[] =  'El campo Cuenta es obligatorio';
            if (empty($_POST['id_serie']))
                $this->array_errors[] =  'El campo Serie es obligatorio';

            if (empty($this->array_errors)) {

                $id_factura = $_POST['id_factura'];
                $id_cuenta_metodo = $_POST['id_cuenta_metodo'];
                $observacion = $_POST['observacion'];
                $id_serie = $_POST['id_serie'];

                $monto = $this->solicitud->sanitize($_POST['monto'], FILTER_SANITIZE_STRING);

                $result = $this->carritoVentas->guardarCredito('app_factura_master', $id_factura, $monto, $id_cuenta_metodo, $id_serie, $observacion);

                if (isset($result['errors'])) {
                    return Http::json_response(['errors' => $result['errors']]);
                } else {
                    return Http::json_response($result);
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }

    public function ActualizarNumFactura()
    {

        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['id_factura']))
                $this->array_errors[] =  'El campo Factura es obligatorio.';

            $id_factura = $this->solicitud->sanitize($_POST['id_factura'], FILTER_SANITIZE_NUMBER_INT);
            $num = $this->solicitud->sanitize($_POST['num'], FILTER_SANITIZE_NUMBER_INT);

            if ($this->notas_entrega_model->editar($id_factura, ['fm_nfactura' => $num])) {
                Http::json_response(true);
            } else {
                Http::json_response(['errors' => $this->array_errors]);
            }
        }
    }

    public function facturaImpresa(int $id_factura)
    {
        if ($this->notas_entrega_model->editar($id_factura, ['fm_impreso' => 1])) {
            Http::json_response('Factura guardada com impresa');
        } else {
            Http::json_response('La factura no se ha guardado como impresa');
        }
    }

    public function obtenerComisionesPendiente(int $id_factura)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_factura = filter_var($id_factura, FILTER_SANITIZE_NUMBER_INT);

            $result = $this->carritoVentas->obtenerComisionesPendiente($id_factura, 2);

            if (isset($result['errors'])) {
                return Http::json_response(['errors' => $result['errors']]);
            } else {
                return Http::json_response($result);
            }
        }
    }

    public function agregaragente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_factura     = filter_input(INPUT_POST, 'id_factura', FILTER_VALIDATE_INT);
            $id_agente      = filter_input(INPUT_POST, 'id_agente', FILTER_VALIDATE_INT);
            $id_comision    = filter_input(INPUT_POST, 'id_comision', FILTER_VALIDATE_INT);
            $monto          = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING);
            $id_divisa      = filter_input(INPUT_POST, 'id_divisa', FILTER_VALIDATE_INT);

            if ($id_factura && $id_agente && $id_comision && $id_divisa && $monto) {
                $result = $this->carritoVentas->agregaragente($id_factura, $id_agente, $id_comision, $monto, 2, $id_divisa);
                if (isset($result['errors'])) {
                    return Http::json_response(['errors' => $result['errors']]);
                } else {
                    return Http::json_response($result);
                }
            }

            Http::json_response(['errors' => ['Acción prohibida']]);
        }
    }

    public function editarpendiente()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id             = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
            $porcentaje     = filter_input(INPUT_POST, 'porcentaje', FILTER_SANITIZE_STRING ?? 0);
            $monto          = filter_input(INPUT_POST, 'monto', FILTER_SANITIZE_STRING ?? 0);

            $result = $this->carritoVentas->editarComisionPendiente($id, $porcentaje, $monto);

            if (isset($result['errors'])) {
                return Http::json_response(['errors' => $result['errors']]);
            } else {
                return Http::json_response($result);
            }
        }
    }

    public function GuardarLicencias()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id_factura = filter_input(INPUT_POST, 'factura', FILTER_SANITIZE_NUMBER_INT);
            $serial = filter_input(INPUT_POST, 'serial', FILTER_SANITIZE_STRING);
            $id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_STRING);
            $fecha = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
            $comentario = filter_input(INPUT_POST, 'comentario', FILTER_SANITIZE_STRING);

            if (empty($_POST['serial']))
                $this->array_errors[] = "El serial es obligatorio.";

            if (!validateDate($fecha, 'Y-m-d'))
                $this->array_errors[] = 'La Fecha es incorrecta.';

            $art = new PosArticulos();

            if (empty($this->array_errors)) {
                if ($art->editar($id, [
                    'fa_licencia_serial' => $serial,
                    'fa_licencia_fecha_expiracion' => $fecha,
                    'fa_licencia_comentario' => $comentario
                ], true)) {
                    Http::json_response(true);
                } else {
                    Http::json_response(false);
                }
            }
            Http::json_response(['errors' => $this->array_errors]);
        }
    }
}
