<div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal-servicios">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header mh">
                <h4 class="modal-title">Servicios</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="s_motor">Motores</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text">
                                <i class="flaticon-mark-1"></i>
                            </span>
                        </div>
                        <select name="s_motor" id="s_motor" class="form-control custom-select" style="padding: .4rem 1rem;" @change="obtenerCategoriasSegunMotor($event)">
                            <option value="" selected></option>
                            <option v-if="motor_id" :value="motor_id">{{ motor_nombre }}</option>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label for="s_categoria">Categorías</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text">
                                <i class="flaticon-mark-1"></i>
                            </span>
                        </div>
                        <select name="s_categoria" id="s_categoria" class="form-control" @change="selectCategoriaServicio($event)">
                            <option value="" disabled selected>Seleccionar categoría</option>
                            <option :value="row.id" v-for="row in categorias">
                                {{ row.categoria }}
                            </option>
                        </select>
                    </div>
                </div>
                <div class="form-group" v-if="catser===true">
                    <label for="s_categoria">Buscar</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text">
                                <i class="flaticon-search-2"></i>
                            </span>
                        </div>
                        <input type="text" class="form-control" v-model="searc">
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                            {{ row }}
                        </div>
                    </div>
                </div>
                <div class="row" v-show="Object.keys(servicios).length > 0">
                    <div class="col mt-3">
                        <table class="table table-striped table-hover" id="tabla_servicios_">
                            <thead>
                                <tr>
                                    <th>Parte</th>
                                    <th>Cantidad</th>
                                    <th class="text-center">
                                        <div class="form-check">
                                            <label for="checkbox-todos-servicios" class="form-check-label">
                                                <input class="form-check-input" type="checkbox" id="checkbox-todos-servicios" @change="checktodosServicios">
                                                <span class="form-check-sign"></span>
                                            </label>
                                        </div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="row_serv in filteredServicios" :key="row_serv.id">
                                    <td style="width: 60%;">{{ row_serv.servicio }}</td>
                                    <td class="text-center">
                                        <div class="form-gruop">
                                            <input type="text" class="form-control" v-model="row_serv.cantidad">
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="form-check">
                                            <label :for="'serv'+row_serv.id" class="form-check-label">
                                                <input class="form-check-input" type="checkbox" v-model="row_serv.checked" :id="'serv'+row_serv.id">
                                                <span class="form-check-sign"></span>
                                            </label>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary  btn-sm" data-dismiss="modal">Cerrar</button>
                <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                    <i class="loader loader-info"></i>
                </button>
                <button v-else type="button" class="btn btn-primary btn-sm" @click="guardarServiciosPreOrden">Registrar</button>
            </div>
        </div>
    </div>
</div>