<div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal-partes">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header mh">
                <h4 class="modal-title">Partes</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="p_categoria">Categorias</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text">
                                <i class="flaticon-mark-1"></i>
                            </span>
                        </div>
                        <select name="p_categoria" id="p_categoria" class="form-control custom-select" @change="selectCategoria($event)">
                            <option value="" disabled selected>Seleccionar categoria</option>
                            <?php foreach ($categorias as $row) : ?>
                                <option value="<?= $row['id'] ?>">
                                    <?= $row['categoria'] ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="form-group" v-if="catpart===true">
                    <label for="s_categoria">Buscar</label>
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text">
                                <i class="flaticon-search-2"></i>
                            </span>
                        </div>
                        <input type="text" class="form-control" v-model="searcp">
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                            {{ row }}
                        </div>
                    </div>
                </div>
                <div class="row" v-show="Object.keys(partes).length > 0">
                    <div class="col">
                        <table class="display table table-striped table-hover dataTable" id="tabla_partes">
                            <thead>
                                <tr>
                                    <th>Parte</th>
                                    <th>Cantidad</th>
                                    <th>
                                        <div class="form-check">
                                            <label for="checkbox-todos" class="form-check-label">
                                                <input class="form-check-input" type="checkbox" id="checkbox-todos" @change="checktodos">
                                                <span class="form-check-sign"></span>
                                            </label>
                                        </div>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="row in filteredPartes">
                                    <td style="width: 65%;">{{ row.parte }}</td>
                                    <td>
                                        <div class="form-gruop">
                                            <input type="text" class="form-control" v-model="row.cantidad">
                                        </div>
                                    </td>
                                    <td class="text-center">
                                        <div class="form-check">
                                            <label :for="'part'+row.id" class="form-check-label">
                                                <input class="form-check-input" type="checkbox" v-model="row.checked" :id="'part'+row.id">
                                                <span class="form-check-sign"></span>
                                            </label>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary  btn-sm" data-dismiss="modal">Cerrar</button>
                <button v-if="cargando" class="btn btn-sm btn-primary" disabled>
                    <i class="loader loader-info"></i>
                </button>
                <button v-else type="button" class="btn btn-primary btn-sm" @click="guardarPartes">Registrar</button>
            </div>
        </div>
    </div>
</div>