<div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal-motores">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header mh">
                <h4 class="modal-title">Motores</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="card">
                    <div class="card-header collapsed" data-toggle="collapse" data-target="#form_" aria-expanded="false">
                        <div class="card-head-row">
                            Agregar Motor
                        </div>
                    </div>
                    <div id="form_" class="collapse">
                        <form id="form_motor" @submit.prevent="guardarMotores">
                            <div class="form-row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="m_marca">Marcas</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="fas fa-trademark"></i>
                                                </span>
                                            </div>
                                            <select name="m_marca" id="m_marca" class="form-control">
                                                <option value="" disabled>Seleccionar marca</option>
                                                <option :value="row.id" v-for="row in marcas">
                                                    {{ row.marca }}
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="motor">Motor</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="flaticon-settings"></i>
                                                </span>
                                            </div>
                                            <input type="text" id="motor" name="motor" maxlength="100" class="form-control" onkeyup="this.value=this.value.toUpperCase()">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="modelo">Modelo</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="fas fa-tag"></i>
                                                </span>
                                            </div>
                                            <input type="text" id="modelo" name="modelo" maxlength="100" class="form-control" onkeyup="this.value=this.value.toUpperCase()">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label for="m_tipo">Tipo</label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">
                                                    <i class="fas fa-trademark"></i>
                                                </span>
                                            </div>
                                            <select name="m_tipo" id="m_tipo" class="form-control">
                                                <option value="" selected disabled>Seleccionar tipo de motor</option>
                                                <option :value="row.id" v-for="row in tipos">
                                                    {{ row.tipo }}
                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group pull-right">
                                <button type="submit" class="btn btn-sm boton-primario-p">Registrar</button>
                            </div>
                        </form>
                        <div class="row">
                            <div class="col-12" style="margin: 0 auto; max-width: 97%;">
                                <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                    {{ row }}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col">
                        <table class="display table table-striped table-hover dataTable" id="tabla_motores">
                            <thead>
                                <tr>
                                    <th>Motor</th>
                                    <th>Marca</th>
                                    <th>Modelo</th>
                                    <th>Tipo</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-for="row in motores">
                                    <td>{{ row.motor }}</td>
                                    <td>{{ row.marca.marca }}</td>
                                    <td>{{ row.modelo }}</td>
                                    <td style="height: inherit;">{{ row.tipo.tipo }}</td>
                                    <td class="text-center">
                                        <div class="form-button-action">
                                            <button type="button" title="Seleccionar" class="btn btn-sm btn-icon btn-round btn-border btn-info" @click="establecerMotor(row)">
                                                <i class="fa fa-plus text-info"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>