<div id="appTipoMotor">
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal-tipo-motor">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header mh">
                    <h4 class="modal-title">Registrar Tipo de motores</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col">
                            <form id="form_tipo_motor" @submit.prevent="guardarTipoMotor">
                                <div class="form-group">
                                    <label for="tipomotor">Nombre</label>
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text">
                                                <i class="flaticon-mark-1"></i>
                                            </span>
                                        </div>
                                        <input type="text" id="tipomotor" name="tipomotor" maxlength="100" class="form-control" onkeyup="this.value=this.value.toUpperCase()">
                                    </div>
                                </div>
                                <div class="form-group text-right">
                                    <button type="submit" class="btn btn-sm boton-primario-p">Registrar</button>
                                </div>
                            </form>
                            <div class="row">
                                <div class="col-12">
                                    <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                        {{ row }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col" style="margin: 0 auto; max-width: 97%;">
                            <table class="display table table-striped table-hover dataTable" id="tabla_tipo_motor">
                                <thead>
                                    <tr>
                                        <th style="height: inherit;">Nombre</th>
                                        <th class="text-center" style="height: inherit; width: 20%">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in tipos">
                                        <td style="height: inherit;">{{ row.tipo }}</td>
                                        <td class="text-center" style="height: inherit; width: 20%">
                                            <div class="form-button-action">
                                                <button type="button" title="Editar" class="btn btn-link btn-primary" @click="obtenerTIpo(row)">
                                                    <i class="fa fa-edit text-info"></i>
                                                </button>
                                                <button type="button" title="Eliminar" class="btn btn-link btn-primary" @click="eliminarCategoria(row)">
                                                    <i class="fa fa-trash text-dark"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#appTipoMotor',
        data: {
            id_tipo: '',
            tipos: [],
            errorForm: [],
            cargando: false
        },
        created() {
            this.obtenerTIposMotores();
        },
        mounted() {
            $('#modal-tipo-motor').on('shown.bs.modal', function(e) {
                $('#tipomotor').trigger('focus');
            });
        },
        methods: {
            eliminarTabla() {
                if ($.fn.DataTable.isDataTable('#tabla_tipo_motor')) {
                    $('#tabla_tipo_motor').DataTable().destroy();
                }
            },
            resetearFormulario() {
                this.errorForm = [];
                this.id_tipo = '';
                document.getElementById('form_tipo_motor').reset();
            },
            guardarTipoMotor() {

                this.errorForm = [];
                let form_tipo_motor = document.getElementById('form_tipo_motor');
                let formData = new FormData(form_tipo_motor);

                if (!formData.get('tipomotor'))
                    this.errorForm.push('EL campo Categoria es obligatorio');

                if (this.id_tipo) {
                    formData.append('id', this.id_tipo);
                }

                if (this.errorForm.length == 0) {
                    this.cargando = true;
                    axios({
                        method: 'post',
                        url: 'planilla/guardarTipoMotor',
                        data: formData
                    }).then(response => {
                        if (response.data.errors == null) {
                            this.obtenerTIposMotores();
                            notificacion('fa fa-check', 'Guardado', 'Registro exitoso', 'success');
                        } else {
                            this.errorForm = response.data.errors;
                        }
                    }).catch(e => notificacion()).finally(() => {
                        this.cargando = false;
                    });
                }
            },
            obtenerTIpo(tipo) {
                this.id_tipo = tipo.id;
                document.getElementById('tipomotor').value = tipo.tipo;
            },
            obtenerTIposMotores() {
                this.resetearFormulario();
                axios.get('planilla/obtenerTipoMotor').then(response => {
                    this.tipos = response.data;
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            },
            eliminarCategoria(tipo) {
                axios.get('planilla/eliminarTipoMotor/' + tipo.id).then(response => {
                    if (response.data == true) {
                        let posicion = this.tipos.findIndex((item) => item.id == tipo.id);
                        this.tipos.splice(posicion, 1);
                        notificacion('fa fa-trash', 'Eliminado', tipo.tipo.toUpperCase(), 'danger');
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            }
        }
    })
</script>