<div id="appServicios">
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal-servicios">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header mh">
                    <h4 class="modal-title">Servicios</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <form id="form_servicio" @submit.prevent="guardarServicios">
                                <div class="form-row">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label for="s_categoria">Categorías</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">
                                                        <i class="flaticon-mark-1"></i>
                                                    </span>
                                                </div>
                                                <select name="s_categoria" id="s_categoria" class="form-control custom-select" style="padding: .4rem 1rem;" @click="obtenerProductosTipoServicio($event)">
                                                    <option value="" disabled>Seleccionar categoría</option>
                                                    <option :value="row.id" v-for="row in categorias">
                                                        {{ row.categoria }}
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-8">
                                        <div class="form-group">
                                            <label for="select_servicio">Servicios</label>
                                            <v-select id="select_servicio" v-model="select_servicio" :options="productos" :reduce="row => row.id" label="descripcion" />
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group pull-right">
                                    <button type="submit" class="btn btn-sm boton-primario-p">Registrar</button>
                                </div>
                            </form>
                            <div class="row">
                                <div class="col-12">
                                    <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                        {{ row }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col table-responsive">
                            <table class="display table table-striped table-hover dataTable" id="tabla_servicios">
                                <thead>
                                    <tr>
                                        <th>Categoria</th>
                                        <th>Servicio</th>
                                        <th class="text-center">Precio</th>
                                        <th class="text-center">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in servicios">
                                        <td style="height: inherit; width: 12%">{{ row.categoria.categoria }}</td>
                                        <td style="height: inherit; ">{{ row.servicio.servicio }}</td>
                                        <td style="height: inherit; width: 20%" class="text-right">{{ row.servicio.precio }}</td>
                                        <td class="text-center" style="height: inherit; width: 12%">
                                            <div class="form-button-action">
                                                <button type="button" title="Eliminar" class="btn btn-link btn-primary" @click="eliminarServicio(row)">
                                                    <i class="fa fa-trash text-dark"></i>
                                                </button>
                                                <button type="button" title="Editar" class="btn btn-link btn-primary" @click="editarServicio(row)">
                                                    <i class="fa fa-trash text-dark"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    Vue.component('v-select', VueSelect.VueSelect)

    new Vue({
        el: '#appServicios',
        data: {
            id_servicio: '',
            motores: [],
            categorias: [],
            select_servicio: null,
            productos: [],
            servicios: [],
            errorForm: [],
            cargando: false,
            editar: ''
        },
        mounted() {

            var self = this;

            self.resetear();

            $('#modal-servicios').on('shown.bs.modal', function(e) {
                self.obtenerCategorias();
                self.obtenerMotores();
                self.obtenerServicios();
            });

            $('#modal-servicios').on('hidden.bs.modal', function(e) {
                self.resetear();
            });
        },
        methods: {
            eliminarTabla() {
                if ($.fn.DataTable.isDataTable('#tabla_servicios')) {
                    $('#tabla_servicios').DataTable().destroy();
                }
            },
            redibujarTabla() {
                $(document).ready(function() {
                    $("#tabla_servicios").DataTable({
                        retrieve: true,
                        dom: 'Bfrtip',
                        buttons: [{
                            title: 'Motores',
                            extend: 'excelHtml5',
                            exportOptions: {
                                columns: [0, 1, 2]
                            }
                        }]
                    });
                });
            },
            resetear() {
                this.errorForm = [];
                this.id_servicio = '';
                this.editar = '';
                this.select_servicio = null;
                document.getElementById('form_servicio').reset();
                document.getElementById('s_categoria').selectedIndex = 0;
            },
            guardarServicios() {

                this.errorForm = [];
                let form_servicio = document.getElementById('form_servicio');
                let formData = new FormData(form_servicio);

                if (!formData.get('s_categoria'))
                    this.errorForm.push('EL campo Categoria es obligatorio');
                if (!this.select_servicio) {
                    this.errorForm.push('EL campo Servicio es obligatorio');
                } else {
                    if (this.id_servicio) {
                        formData.append('servicio', this.editar);
                    } else {
                        formData.append('servicio', this.select_servicio);
                    }

                }

                if (this.id_servicio) {
                    formData.append('id', this.id_servicio);
                }

                if (this.errorForm.length == 0) {
                    this.cargando = true;
                    axios({
                        method: 'post',
                        url: 'planilla/guardarServicios',
                        data: formData
                    }).then(response => {
                        if (response.data.errors == null) {
                            this.eliminarTabla();
                            this.obtenerServicios();
                        } else {
                            this.errorForm = response.data.errors;
                        }
                    }).catch(e => notificacion()).finally(() => {
                        this.cargando = false;
                    });
                }
            },
            obtenerServicios() {
                this.resetear();
                this.eliminarTabla();
                axios.get('planilla/obtenerServicios').then(response => {
                    this.servicios = response.data;
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    this.redibujarTabla();
                });
            },
            eliminarServicio(servicio) {
                axios.get('planilla/eliminarServicio/' + servicio.id).then(response => {
                    if (response.data == true) {
                        let posicion = this.servicios.findIndex((item) => item.id == servicio.id);
                        this.servicios.splice(posicion, 1);
                        this.eliminarTabla();
                        this.redibujarTabla();
                        notificacion('fa fa-trash', 'Eliminado', servicio.servicio.servicio, 'danger');
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            },
            editarServicio(servicio) {
                document.getElementById('s_categoria').value = servicio.categoria.id;
                this.select_servicio = servicio.servicio.servicio;
                this.id_servicio = servicio.id;
                this.editar = servicio.servicio.id;
            },
            async obtenerMotores() {
                axios.get('planilla/obtenerMotores').then(response => {
                    this.motores = response.data;
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            },
            async obtenerCategorias() {
                axios.get('planilla/obtenerCategorias').then(response => {
                    this.categorias = response.data;
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            },
            obtenerProductosTipoServicio(event) {
                if (event.target.value) {
                    axios.get('planilla/obtenerProductosTipoServicio').then(response => {
                        this.productos = response.data;
                    }).catch(e => notificacion()).finally(() => {
                        this.cargando = false;
                    });
                }
            }
        }
    })
</script>