<div id="appPartes">
    <div class="modal fade" tabindex="-1" role="dialog" aria-hidden="true" id="modal-partes">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header" style="border: 0px ;">
                    <h4 class="modal-title">Registrar Partes</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col">
                            <form id="form_parte" @submit.prevent="guardarPartes">
                                <div class="form-row">
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="p_categoria">Categoría</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">
                                                        <i class="flaticon-mark-1"></i>
                                                    </span>
                                                </div>
                                                <select name="p_categoria" id="p_categoria" class="form-control ">
                                                    <option value="" disabled>Seleccionar categoría</option>
                                                    <option :value="row.id" v-for="row in categorias">
                                                        {{ row.categoria }}
                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label for="parte">Parte</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">
                                                        <i class="flaticon-mark"></i>
                                                    </span>
                                                </div>
                                                <input type="text" id="parte" name="parte" maxlength="100" class="form-control" onkeyup="this.value=this.value.toUpperCase()">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group pull-right">
                                    <button type="submit" class="btn btn-sm boton-primario-p">Registrar</button>
                                </div>
                            </form>
                            <div class="row">
                                <div class="col-12">
                                    <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                        {{ row }}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col" style="margin: 0 auto; max-width: 97%;">
                            <table class="display table table-striped table-hover dataTable" id="tabla_partes">
                                <thead>
                                    <tr>
                                        <th style="height: inherit;">Categoría</th>
                                        <th style="height: inherit;">Parte</th>
                                        <th class="text-center" style="height: inherit; width: 20%">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="row in partes">
                                        <td style="height: inherit;">{{ row.categoria.categoria }}</td>
                                        <td style="height: inherit;">{{ row.parte }}</td>
                                        <td class="text-center" style="height: inherit; width: 20%">
                                            <div class="form-button-action">
                                                <button type="button" title="Editar" class="btn btn-link btn-primary" @click="editarParte(row)">
                                                    <i class="fa fa-edit text-info"></i>
                                                </button>
                                                <button type="button" title="Eliminar" class="btn btn-link btn-primary" @click="eliminarParte(row)">
                                                    <i class="fa fa-trash text-dark"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#appPartes',
        data: {
            id_parte: '',
            categorias: [],
            partes: [],
            errorForm: [],
            cargando: false
        },
        created() {
            this.obtenerPartes();
        },
        mounted() {

            var self = this;

            self.resetear();

            $('#modal-partes').on('shown.bs.modal', function(e) {
                $('#p_categoria').trigger('focus');
                self.obtenerCategorias();
            });

            $('#modal-partes').on('hidden.bs.modal', function(e) {
                self.resetear();
            });
        },
        methods: {
            resetear() {
                this.errorForm = [];
                this.id_parte = '';
                document.getElementById('form_parte').reset();
                document.getElementById('p_categoria').selectedIndex = 0;
            },
            eliminarTabla() {
                if ($.fn.DataTable.isDataTable('#tabla_partes')) {
                    $('#tabla_partes').DataTable().destroy();
                }
            },
            /* redibujarTabla() {
                $(document).ready(function() {
                    $("#tabla_partes").DataTable({
                        info: false,
                        retrieve: true,
                        dom: 'Bfrtip',
                        buttons: [{
                            title: 'Partes',
                            extend: 'excelHtml5',
                            exportOptions: {
                                columns: [0, 1]
                            }
                        }]
                    });
                });
            }, */
            guardarPartes() {

                this.errorForm = [];
                let form_parte = document.getElementById('form_parte');
                let formData = new FormData(form_parte);

                if (!formData.get('p_categoria'))
                    this.errorForm.push('EL campo Categoria es obligatorio');
                if (!formData.get('parte'))
                    this.errorForm.push('EL campo Parte es obligatorio');

                if (this.id_parte) {
                    formData.append('id', this.id_parte);
                }

                if (this.errorForm.length == 0) {
                    this.cargando = true;
                    axios({
                        method: 'post',
                        url: 'planilla/guardarPartes',
                        data: formData
                    }).then(response => {
                        if (response.data.errors == null) {
                            this.eliminarTabla();
                            this.obtenerPartes();
                        } else {
                            this.errorForm = response.data.errors;
                        }
                    }).catch(e => notificacion()).finally(() => {
                        this.cargando = false;
                    });
                }
            },
            editarParte(parte) {
                this.id_parte = parte.id;
                document.getElementById('p_categoria').value = parte.categoria.id;
                document.getElementById('parte').value = parte.parte;
            },
            obtenerPartes() {
                this.resetear();
                axios.get('planilla/obtenerPartes').then(response => {
                    this.partes = response.data;
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    //this.redibujarTabla();
                });
            },
            eliminarParte(parte) {
                axios.get('planilla/eliminarParte/' + parte.id).then(response => {
                    if (response.data == true) {
                        let posicion = this.partes.findIndex((item) => item.id == parte.id);
                        this.partes.splice(posicion, 1);
                        this.eliminarTabla();
                        //this.redibujarTabla();
                        notificacion('fa fa-trash', 'Eliminado', parte.parte.toUpperCase(), 'danger');
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            },
            obtenerCategorias() {
                axios.get('planilla/obtenerCategorias').then(response => {
                    this.categorias = response.data;
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                });
            },
        }
    })
</script>