<?php

namespace App\Modelos;

use Core\Database;

class PlanillaPreOrdenServiciosEmpleado extends Database
{
    protected $table = 'app_preorden_master_servicios_empleados';
    protected $id = 'preemp_id';

    public function obtenerEmpleadosServicios(int $id_preorden)
    {
        return $this->consultar("SELECT preemp_id, preemp_empid, preemp_preid,preemp_estatus, CONCAT(einfo_nombres, einfo_apellidos) empleado, preserv_id, preserv_cantidad, pro_id, pro_descripcion, pro_precio precio, DATE_FORMAT(preemp_fecha, '%d-%m-%Y') fecha
        FROM app_preorden_master_servicios_empleados preemp
        JOIN app_preorden_master_servicios apms ON preemp.preemp_preservid = apms.preserv_id
        JOIN app_planillas_servicios aps ON aps.serv_id = apms.preserv_servid 
        JOIN app_productos ap ON ap.pro_id = aps.serv_proid
        JOIN app_empleados_info aei ON aei.einfo_id = preemp.preemp_empid 
        WHERE preemp_preid = $id_preorden")->all();
    }

    public function obtenerPrecioPresupuesto(int $id_preorden, int $id_producto)
    {
        return $this->consultar("SELECT nart_proneto precio
        FROM app_planilla_orden_de_entrega
        JOIN app_orden_de_entrega_articulos ON nart_nid = po_nid
        WHERE po_preid = $id_preorden AND nart_proid = $id_producto")->row();
    }
}
