<?php

namespace App\Modelos;

use Core\Database;

class PlanillaPreOrdenServicios extends Database
{
    protected $table = 'app_preorden_master_servicios';
    protected $id = 'preserv_id';

    public function obtenerServicios(int $id_preorden)
    {
        return $this->consultar("SELECT preserv_id, preserv_cantidad, pro_descripcion, preserv_estatus, cat_id, cat_categorias
        FROM app_preorden_master_servicios ms
        JOIN app_planillas_servicios s ON s.serv_id = ms.preserv_servid
        JOIN app_planilla_categorias c ON c.cat_id = s.serv_catid
        JOIN app_productos p ON p.pro_id = s.serv_proid 
        WHERE preserv_preid = $id_preorden")->all();
    }

    public function obtenerEmpleadosServicios(int $id_preorden_servicio)
    {
        return $this->consultar("SELECT CONCAT(einfo_nombres, ' ', einfo_apellidos) empleado
        FROM app_preorden_master_servicios_empleados  se
        LEFT JOIN app_empleados_info ei ON ei.einfo_id = se.preemp_empid
        WHERE preemp_preservid = $id_preorden_servicio")->all();
    }

    public function obtenerServiciosSimple(int $id_preorden)
    {
        return $this->consultar("SELECT pro_id, pro_impid,pro_costo, pro_precio, preserv_cantidad, pro_codigo, pro_descripcion
        FROM app_preorden_master_servicios ms
        JOIN app_planillas_servicios s ON s.serv_id = ms.preserv_servid
        JOIN app_productos p ON p.pro_id = s.serv_proid
        WHERE preserv_preid = $id_preorden")->all();
    }

    public function obtenerServicioSimple(int $preserv_id)
    {
        return $this->consultar("SELECT * 
        FROM app_preorden_master_servicios ms
        JOIN app_planillas_servicios s ON s.serv_id = ms.preserv_servid
        JOIN app_productos p ON p.pro_id = s.serv_proid 
        JOIN app_planilla_orden_de_entrega pl ON pl.po_preid=ms.preserv_preid 
        JOIN app_orden_de_entrega_articulos ord ON ord.nart_nid=pl.po_nid AND ord.nart_proid=p.pro_id 
        WHERE preserv_id = $preserv_id")->row();
    }

    public function obtenerServicio(int $id_valor)
    {
        return $this->consultar("SELECT pre_correlativo, cli_dni, cli_razon_social, pre_motid

        JOIN app_planillas_servicios s ON s.serv_id = ms.preserv_servid
        JOIN app_preorden_master_servicios orden ON orden.pre_id = preserv_preid
        JOIN app_clientes c ON c.cli_id = orden.pre_cliid
        WHERE preserv_id = $id_valor")->row();
    }

    public function obtenerServicioSegunCategoriaYOrden(int $id_orden, int $id_categoria)
    {
        return $this->consultar("SELECT preserv_cantidad, pro_descripcion
        FROM app_preorden_master_servicios ms
        JOIN app_planillas_servicios s ON s.serv_id = ms.preserv_servid
        JOIN app_productos p ON p.pro_id = s.serv_proid
        WHERE ms.preserv_preid = $id_orden AND s.serv_catid=$id_categoria")->all();
    }
}
