<style>
    .table,
    .td,
    .th {
        border: 1px solid black;
        text-align: left;
    }

    .table {
        border-collapse: collapse;
        width: 100%;
    }

    .th,
    .td {
        padding: 5px;
    }
</style>

<?php

use Core\Helpers\Moneda; ?>

<div style="display:block; width: 100%;">
    <table width="100%" border="0">
        <tr>
            <th style="width: 10%; text-align: left">Factura:</th>
            <td style="width: 60%; text-align: left"><?= $factura ?></td>
            <th style="text-align: right">Fecha:</th>
            <td style="text-align: right"><?= date('d-m-Y', strtotime($fecha)) ?></td>
        </tr>
        <tr>
            <th style="text-align: left">Cliente:</th>
            <td style="text-align: left"><?= $cliente ?></td>
            <th style="text-align: right">Cedula/Rif:</th>
            <td style="text-align: right"><?= $cedularif ?></td>
        </tr>
        <tr>
            <th style="text-align: left">Dirección:</th>
            <td style="text-align: left"><?= $direccion ?></td>
            <th style="text-align: right">Telefóno:</th>
            <td style="text-align: right"><?= $telefono ?></td>
        </tr>
    </table>
</div>

<div style="display:block; width: 100%; padding:10px"></div>

<div style="display:block; width: 100%;">
    <table class="table">
        <thead>
            <tr>
                <th class="th" style="text-align: left">Ref. + Descripción</th>
                <th class="th" style="text-align: right">Cant.</th>
                <th class="th" style="text-align: right">Dto %.</th>
                <th class="th" style="text-align: right">Precio</th>
                <th class="th" style="text-align: right">Importe</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($articulos as $row) : ?>
                <tr>
                    <td class="td" style="text-align: left"><strong><?= $row['fa_procodigo'] ?></strong> <?= $row['fa_propnombre'] ?></td>
                    <td class="td" style="text-align: right"><?= $row['fa_procantidad'] ?></td>
                    <td class="td" style="text-align: right"><?= $row['fa_prodescuento'] ?></td>
                    <td class="td" style="text-align: right"><?= Moneda::moneda($row['fa_proprecio'], $div_locale, $div_simbolo) ?></td>
                    <td class="td" style="text-align: right"><?= Moneda::moneda($row['fa_prototal'], $div_locale, $div_simbolo) ?></td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>
