<?php

namespace App\Modelos;

use Core\Database;

class Ordendeentrega extends Database
{
    protected $table = 'app_orden_de_entrega';
    protected $id = 'n_id';

    public function obtenerSaldoCuenta($id_cuenta)
    {
        return $this->consultar("SELECT cmp_saldo FROM app_cuentas_metodopago WHERE cmp_id=$id_cuenta")->row();
    }

    public function pagoPositivo($id_cuenta, $monto)
    {
        return $this->consultar("UPDATE app_bancos_cuentas SET bc_saldo = $monto WHERE bc_id = $id_cuenta")->run();
    }

    public function obtenerDivisaMaster()
    {
        return $this->consultar("SELECT * FROM app_divisas WHERE div_predeterminado = 1")->row();
    }

    public function verificarProductoEnStock($id_producto, $id_almacen)
    {
        return $this->consultar("SELECT ps_cantidad, ps_stockmin FROM app_productos_stocks ps WHERE ps.ps_proid=$id_producto and ps_almid=$id_almacen")->row();
    }

    public function obtenerDivisaAlCambio($id_divisa_master, $id_divisa_buscada)
    {
        return $this->consultar("SELECT * FROM app_divisas_factor WHERE df_divid_master=$id_divisa_master and df_divid=$id_divisa_buscada")->row();
    }

    public function obtenerDescuento($id_cliente)
    {
        return $this->consultar("SELECT cli_descuento FROM app_clientes WHERE cli_id=$id_cliente")->row();
    }

    public function obtenerFactura($id_factura)
    {
        return $this->consultar("SELECT * FROM app_orden_de_entrega WHERE n_id=$id_factura")->row();
    }

    public function obtenerMetodosSegunDivisa($id_divisa)
    {
        return $this->consultar("SELECT md_id, md.md_divid, md.md_mpid, m.mp_codigo, m.mp_nombre
        FROM app_metodopago_divisa md
        JOIN app_metodopago m ON m.mp_id = md.md_mpid
        WHERE md.md_divid=$id_divisa and m.mp_estatus = 1")->all();
    }

    public function obtenerCuentasSegunMetodo($id_metodo_divisa)
    {
        return $this->consultar("SELECT cmp_id, bc_cuenta, bc_tipo, bc_alias, b.ban_codigo, b.ban_descripcion
        FROM app_metodopago_divisa md
        JOIN app_cuentas_metodopago cmp ON cmp.cmp_mdid = md.md_id
        JOIN app_bancos_cuentas bc ON bc.bc_id = cmp.cmp_cueid
        JOIN app_bancos b ON b.ban_id = bc.bc_banid
        WHERE cmp.cmp_mdid=$id_metodo_divisa AND ban_estatus = 1 AND cmp_cueid IN (SELECT ec_bcid FROM app_empleados_cuentas WHERE ec_empid = {$_SESSION['user_data']['emp_id']})")->all();
    }

    public function obtenerCuenta($id_cuenta)
    {
        return $this->consultar("SELECT cm.cmp_id, md.md_divid, md.md_mpid
        FROM app_cuentas_metodopago cm
        JOIN app_metodopago_divisa md ON md.md_id = cmp_mdid
        WHERE cmp_id=$id_cuenta")->row();
    }

    public function abonosSinDetalles($id_factura)
    {
        return $this->consultar("SELECT SUM(fa.fab_monto) as total, fa.fab_idgenerico
        FROM app_movimientos fa
        JOIN app_orden_de_entrega fm ON fm.n_id = fa.fab_idgenerico        
        WHERE fab_idgenerico=$id_factura AND fa.fab_doc = 12 AND fab_categoria=1")->row();
    }

    public function abonos($id_factura)
    {
        return $this->consultar("SELECT *, DATE_FORMAT(fab_fecha, '%d-%m-%Y') as fecha 
        FROM app_movimientos fa
        JOIN app_orden_de_entrega fm ON fm.n_id = fa.fab_idgenerico
        LEFT JOIN app_cuentas_metodopago cm ON cm.cmp_id = fa.fab_cmpid
        LEFT JOIN app_bancos_cuentas bc ON bc.bc_id = cm.cmp_cueid
        LEFT JOIN app_metodopago_divisa md ON  md.md_id = cm.cmp_mdid
        LEFT JOIN app_metodopago m ON m.mp_id = md.md_mpid
        LEFT JOIN app_divisas d ON d.div_id = md.md_divid
        WHERE fab_idgenerico=$id_factura AND fa.fab_doc = 12 AND fab_categoria=1 ORDER BY fab_fecha DESC")->all();
    }

    public function culminarFactura($id_factura)
    {
        return $this->consultar("UPDATE app_orden_de_entrega SET n_estatus = 1 WHERE n_id = $id_factura")->run();
    }

    public function correlativo(int $id_serie, int $id_documento)
    {
        return $this->consultar("SELECT c.cor_id, c.cor_serid, c.cor_docid, s.ser_descripcion, s.ser_impuesto, d.doc_prefijo, c.cor_correlativo
        FROM app_correlativos c
        JOIN app_series s ON s.ser_id = c.cor_serid
        JOIN app_documentos d ON d.doc_id = c.cor_docid
        WHERE c.cor_serid = $id_serie AND c.cor_docid = $id_documento")->row();
    }

    public function obtenerFacturaCompleta($id_factura)
    {
        return $this->consultar("SELECT * 
        FROM app_orden_de_entrega fm 
        JOIN app_series s ON s.ser_id = fm.n_serid
        JOIN app_divisas d ON d.div_id = fm.n_divid
        WHERE fm.n_id=$id_factura")->row();
    }

    public function desontardeStock($id_producto, $id_alamcen, $cantidad)
    {
        return $this->consultar("UPDATE app_productos_stocks SET ps_cantidad = ps_cantidad - $cantidad WHERE ps_proid=$id_producto AND ps_almid=$id_alamcen")->run();
    }

    public function restablecerStock($id_producto, $id_alamcen, $cantidad)
    {
        return $this->consultar("UPDATE app_productos_stocks SET ps_cantidad = ps_cantidad + $cantidad WHERE ps_proid=$id_producto AND ps_almid=$id_alamcen")->run();
    }

    public function rutaDocumento($id_factura)
    {
        return $this->consultar("SELECT d.doc_prefijo, emp.emp_username, rd.rd_observacion, DATE_FORMAT(rd.rd_fecha, '%d-%m-%Y') as fecha
        FROM app_ruta_documento rd 
        JOIN app_documentos d ON d.doc_id = rd.rd_docid_procedencia
        JOIN app_empleados emp ON emp.emp_id = rd.rd_empleadoid
        WHERE rd.rd_facid_conversion = $id_factura AND rd_docid_conversion = 1")->row();
    }
}
