<form autocomplete="off" @submit.prevent="pagarCredito">
    <div class="modal fade" id="modal_crear_credito" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header border-top-0 border-bottom-0">
                    Nuevo Credito
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body border-top-0">
                    <div class="form-row">
                        <div class="col-sm-12">
                            <div class="form-group form-floating-label">
                                <select class="form-control input-border-bottom" v-model="divisa_pagar_credito" id="divisa_pagar_credito" @change="obtenerMetodosSegunDivisa">
                                    <option disabled value="">&nbsp;</option>
                                    <?php foreach ($divisas as $row) : ?>
                                        <option value="<?= $row['div_id'] ?>"><?= $row['div_nombre'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="divisa_pagar_credito" class="placeholder">Divisa</label>
                            </div>
                            <div class="form-group form-floating-label">
                                <select class="form-control input-border-bottom" v-model="metodo_pagar_credito" id="metodo_pagar_credito" @change="obtenerCuentasSegunMetodo">
                                    <option disabled value="">&nbsp;</option>
                                    <option v-for="row in metodos_de_pagos" :value="row.md_id">{{ row.mp_nombre }}</option>
                                </select>
                                <label for="metodo_pagar_credito" class="placeholder">Metodo de pago</label>
                            </div>
                            <div class="form-group form-floating-label">
                                <select class="form-control input-border-bottom" v-model="cuenta_pagar_credito" id="cuenta_pagar_credito">
                                    <option disabled value="">&nbsp;</option>
                                    <option v-for="row in cuentas" :value="row.cmp_id">{{ row.bc_alias }} - {{ row.bc_tipo }} - {{ row.ban_codigo }}</option>
                                </select>
                                <label for="cuenta_pagar_credito" class="placeholder">Cuenta</label>
                            </div>
                            <div class="form-group">
                                <input id="pagar_monto_credito" type="text" class="form-control input-border-bottom" v-money="moneyPagar" v-model="diferencia_credito">
                                <label for="pagar_monto_credito" class="placeholder">Monto</label>
                            </div>
                            <div class="form-group">
                                <label for="pagar_descripcion_credito" class="placeholder">Descripción</label>
                                <textarea id="pagar_descripcion_credito" class="form-control" v-model="pagar_descripcion_credito"></textarea>
                            </div>
                            <div class="col mt-3">
                                <button class="btn btn-primary btn-round btn-block" disabled v-if="cargando">
                                    <i class="loader loader-info"></i>
                                </button>
                                <button type="submit" id="btn_pagar_credito" class="btn btn-primary btn-round btn-block" v-else>pagar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
