<?php

namespace App\Modelos;

use Core\Database;

class Notadecredito extends Database
{
    protected $table    = 'app_nota_de_credito';
    protected $id       = 'cre_id';

    public function obtenerNotasdeCreditos()
    {
        return $this->consultar('SELECT * 
        FROM app_notas_de_credito')->all();
    }

    public function obtenerCreditosClientes(int $id_cliente)
    {
        return $this->consultar("SELECT * FROM app_nota_de_credito WHERE cre_cliid = $id_cliente AND cre_estatus = 0")->all();
    }

    public function obtenerMetodosSegunDivisa(int $id_divisa)
    {
        return $this->consultar("SELECT md_id, md.md_divid, md.md_mpid, m.mp_codigo, m.mp_nombre
        FROM app_metodopago_divisa md
        JOIN app_metodopago m ON m.mp_id = md.md_mpid
        WHERE md.md_divid=$id_divisa and m.mp_estatus = 1")->all();
    }

    public function obtenerCuentasSegunMetodo(int $id_metodo_divisa)
    {
        return $this->consultar("SELECT cmp_id, bc_cuenta, bc_tipo, bc_alias, b.ban_codigo, b.ban_descripcion
        FROM app_metodopago_divisa md
        JOIN app_cuentas_metodopago cmp ON cmp.cmp_mdid = md.md_id
        JOIN app_bancos_cuentas bc ON bc.bc_id = cmp.cmp_cueid
        JOIN app_bancos b ON b.ban_id = bc.bc_banid
        WHERE cmp.cmp_mdid=$id_metodo_divisa AND cmp_cueid IN (SELECT ec_bcid FROM app_empleados_cuentas WHERE ec_empid = {$_SESSION['user_data']['emp_id']})")->all();
    }

    public function actualizarCorrelativo(int $id_serie, $id_documento, int $correlartivo)
    {
        return $this->consultar("UPDATE app_correlativos SET cor_correlativo = $correlartivo WHERE cor_serid = $id_serie AND cor_docid=$id_documento")->run();
    }

    //SI SOLO HAY UNA PALABRA DE BUSQUEDA SE ESTABLECE UNA INSTRUCION CON LIKE
    //SI HAY UNA FRASE SE UTILIZA EL ALGORTIMO DE BUSQUEDA AVANZADO DE MATCH AGAINST
    //BUSQUEDA DE FRASES CON MAS DE UNA PALABRA Y UN ALGORITMO ESPECIALIZADO
    public function buscarCliente($buscar)
    { 
        $trozos = explode(" ", $buscar);
        $numero = count($trozos);
        if ($numero == 1) {
            $sql = "SELECT c.cli_id id, c.cli_dni dni, c.cli_razon_social cliente,c.cli_grupid,cg.grup_nombre,cg.grup_descuento FROM app_clientes c
            LEFT JOIN app_clientes_grupos cg ON c.cli_grupid=cg.grup_id 
            WHERE cli_estatus = 1 AND (LOWER(cli_dni) LIKE '%$buscar%' OR LOWER(cli_razon_social) LIKE '%$buscar%') LIMIT 50";
        } elseif ($numero > 1) {
            $sql = "SELECT c.cli_id id, c.cli_dni dni, c.cli_razon_social cliente, c.cli_grupid,cg.grup_nombre,cg.grup_descuento,MATCH(c.cli_razon_social) AGAINST('$buscar') AS puntuacion 
            FROM app_clientes c  LEFT JOIN app_clientes_grupos cg ON c.cli_grupid=cg.grup_id 
            WHERE cli_estatus = 1 AND MATCH(cli_razon_social) AGAINST('$buscar') ORDER BY puntuacion DESC LIMIT 50";
        }
        return $this->consultar("$sql")->all();
    }
    public function obtenerDivisaAlCambio($id_divisa_master, $id_divisa_buscada)
    {
        return $this->consultar("SELECT * FROM app_divisas_factor WHERE df_divid_master=$id_divisa_master and df_divid=$id_divisa_buscada")->row();
    }
}
