<?php

namespace App\Controladores;

use App\Modelos\MovimientoModel;
use App\Modelos\Notadecredito;
use Core\Controller;
use Core\Helpers\Moneda;
use Core\Librerias\Http;

final class NotadecreditoControlador extends Controller
{
    private $array_errors = [];
    private $new_nota_credito;
    private $divisa_master;

    public function __construct()
    {
        parent::__construct();
        $this->new_nota_credito = new Notadecredito();
        $this->divisa_master = $this->new_nota_credito->consultar("SELECT * FROM app_divisas WHERE div_predeterminado = 1")->row();
    }

    public function buscarCliente()
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax() && !empty($_GET['buscar'])) {
            $buscar = $this->solicitud->sanitize($_GET['buscar']);
            $buscar = strtolower($buscar);
            Http::json_response($this->new_nota_credito->buscarCliente($buscar));
        }
    }

    public function obtenerMetodosSegunDivisa(int $id_divisa)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax() && !empty($id_divisa)) {
            $list_metodos = [];
            $divisa = $this->new_nota_credito->consultar("SELECT div_id FROM app_divisas WHERE div_id = $id_divisa")->row();
            if ($divisa) {

                $data_metodos = $this->new_nota_credito->obtenerMetodosSegunDivisa($id_divisa);

                if (is_countable($data_metodos) && count($data_metodos)) {
                    foreach ($data_metodos as $row) {
                        $list_metodos[] = [
                            'id' => $row['md_id'],
                            'metodo' => $row['mp_nombre']
                        ];
                    }
                }

                Http::json_response([
                    'divisa' => Moneda::obtenerDivisa($id_divisa),
                    'metodos' => $list_metodos
                ]);
            }
        }
    }

    public function obtenerCuentasSegunMetodo(int $id_metodo_divisa)
    {
        if ('GET' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $list_cuentas = [];

            if (!empty($id_metodo_divisa)) {

                $data_cuentas = $this->new_nota_credito->obtenerCuentasSegunMetodo($id_metodo_divisa);

                if (is_countable($data_cuentas) && count($data_cuentas)) {
                    foreach ($data_cuentas as $row) {
                        $list_cuentas[] = [
                            'id' => $row['cmp_id'],
                            'cuenta' => $row['bc_alias'] . ' - ' . $row['bc_tipo']
                        ];
                    }
                }
            }

            Http::json_response($list_cuentas);
        }
    }

    public function guardar()
    {
        if ('POST' == $_SERVER['REQUEST_METHOD'] && isAjax()) {

            if (empty($_POST['cliente']))
                $this->array_errors[] =  'El campo Cliente es obligatorio.';
            if (empty($_POST['monto']))
                $this->array_errors[] =  'El campo Monto es obligatorio.';
            if (empty($_POST['id_divisa']))
                $this->array_errors[] =  'El campo Divisa es obligatorio';
            if (empty($_POST['id_metodo_divisa']))
                $this->array_errors[] =  'El campo Metodo es obligatorio';
            if (empty($_POST['id_cuenta_metodo']))
                $this->array_errors[] =  'El campo Cuenta es obligatorio';

            if (empty($this->array_errors)) {

                $monto = $this->solicitud->sanitize($_POST['monto'], FILTER_SANITIZE_STRING);

                if ($monto <= 0) {
                    $this->array_errors[] = "El campo Monto debe ser mayor que 0";
                }

                if (empty($this->array_errors)) {

                    $id_cliente     = $this->solicitud->sanitize($_POST['cliente'], FILTER_VALIDATE_INT);
                    $id_divisa      = $this->solicitud->sanitize($_POST['id_divisa'], FILTER_VALIDATE_INT);
                    $id_metodo      = $this->solicitud->sanitize($_POST['id_metodo_divisa'], FILTER_VALIDATE_INT);
                    $id_cuenta      = $this->solicitud->sanitize($_POST['id_cuenta_metodo'], FILTER_VALIDATE_INT);
                    $id_serie       = $this->solicitud->sanitize($_POST['serie'], FILTER_VALIDATE_INT);
                    $observacion    = empty($_POST['observacion']) ? $_POST['observacion'] : $this->solicitud->sanitize($_POST['observacion'], FILTER_SANITIZE_STRING);

                    if ($id_cliente && $id_divisa && $id_metodo && $id_cuenta && $id_serie) {

                        $monto = convertir_a_float($monto);

                        $cliente    = $this->new_nota_credito->consultar("SELECT * FROM app_clientes WHERE cli_id=$id_cliente")->row();
                        $serie      = $this->new_nota_credito->consultar("SELECT * FROM app_series WHERE ser_id=$id_serie")->row();

                        if ($cliente && $serie) {

                            $correlativo =  $this->new_nota_credito->consultar("SELECT * FROM app_correlativos WHERE cor_serid = $id_serie AND cor_docid = 7")->row();

                            if ($correlativo == false) {
                                $this->array_errors[] = "No existe correlativo entre la se serie {$serie['ser_descripcion']} y el documento Notas de credito por favor dirijase a Modulo Configuración -> correlativos";
                            }

                            if (empty($this->array_errors)) {

                                $cuenta = $this->new_nota_credito->consultar("SELECT cmp_cueid, cmp_mdid FROM app_cuentas_metodopago WHERE cmp_id=$id_cuenta")->row();
                                $divisa_factura = $this->new_nota_credito->consultar("SELECT md_divid FROM app_metodopago_divisa WHERE md_id={$cuenta['cmp_mdid']}")->row();

                                if ($divisa_factura['md_divid'] != $this->divisa_master['div_id']) {
                                    $data_factor_factura = $this->new_nota_credito->obtenerDivisaAlCambio($this->divisa_master['div_id'], $divisa_factura['md_divid']);
                                    if (!$data_factor_factura) {
                                        $this->array_errors[] = 'No se ecuentra el factor de conversion entre la divisa seleccionada y la divisa master.';
                                    } else {
                                        $factor_factura = $data_factor_factura['df_factor'];
                                    }
                                } else {
                                    $factor_factura = 1;
                                }

                                $conversion = round($monto / $factor_factura, 2);

                                if (empty($this->array_errors)) {

                                    $id_credito = $this->new_nota_credito->guardar([
                                        'cre_cliid'         => $id_cliente,
                                        'cre_empleado'      => $_SESSION['user_data']['emp_id'],
                                        'cre_modulo'        => 'VENTAS',
                                        'cre_descripcion'   => 'Creado como nota de credito',
                                        'cre_observacion'   => $observacion,
                                        'cre_correlativo'   => $correlativo['cor_correlativo'] + 1,
                                        'cre_monto'         => $conversion
                                    ]);

                                    if ($id_credito) {

                                        $newMovimiento = new MovimientoModel();

                                        $div = Moneda::obtenerDivisa($divisa_factura['md_divid']);

                                        $cuenta = $newMovimiento->consultar("SELECT cmp_saldo, cmp_cueid, cmp_mdid FROM app_cuentas_metodopago WHERE cmp_id=$id_cuenta")->row();
                                        $saldo = $newMovimiento->consultar("SELECT bc_saldo FROM app_bancos_cuentas WHERE bc_id = {$cuenta['cmp_cueid']}")->row();
                                        $total = $saldo['bc_saldo'] + $monto;
                                        $total_cuenta_metodo = $cuenta['cmp_saldo'] + $monto;

                                        if ($newMovimiento->guardar([
                                            'fab_idgenerico'        => $id_credito,
                                            'fab_doc'               => 7,
                                            'fab_divisa'            => $divisa_factura['md_divid'],
                                            'fab_metodo'            => $cuenta['cmp_mdid'],
                                            'fab_cmpid'             => $id_cuenta,
                                            'fab_monto'             => $monto,
                                            'fab_conversion'        => $conversion,
                                            'fab_retiro'            => 0,
                                            'fab_factor_master'     => $factor_factura,
                                            'fab_factor'            => $factor_factura,
                                            'fab_empid'             => $_SESSION['user_data']['emp_id'],
                                            'fab_modulo'            => 'Nota de credito ventas',
                                            'fab_descripcion'       => '',
                                            'fab_observacion'       => "Pago creado en nota de credito ventas a {$cliente['cli_razon_social']} Monto: " . Moneda::moneda($monto, $div['locale'], $div['symbol']),
                                            'fab_credito'           => 1,
                                            'fab_categoria'         => 1,
                                            'fab_saldo_anterior'    => $saldo['bc_saldo'],
                                        ], true)) {
                                            $this->new_nota_credito->actualizarCorrelativo($serie['ser_id'], 7, ($correlativo['cor_correlativo'] + 1));
                                            $this->new_nota_credito->consultar("UPDATE app_bancos_cuentas SET bc_saldo = $total WHERE bc_id = {$cuenta['cmp_cueid']}")->run();
                                            $this->new_nota_credito->consultar("UPDATE app_cuentas_metodopago SET cmp_saldo = $total_cuenta_metodo WHERE cmp_id = $id_cuenta")->run();
                                            Http::json_response(true);
                                        }
                                    } else {
                                        Http::json_response(false);
                                    }
                                }
                            }
                        }
                    }
                }
            }

            Http::json_response(['errors' => $this->array_errors]);
        }
    }
}
