<?php

namespace App\Controladores;

use App\Modelos\MetodoPago;
use Core\Controller;
use Core\Vista;

final class MetodospagoControlador extends Controller
{
    private $metodopago;
    private $array_errors = [];

    public function __construct()
    {
        parent::__construct();
        $this->metodopago = new MetodoPago();
    }

    public function index()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            return Vista::viewAJAX('metodospago/index');
        }
    }

    public function obtenerMetodoPagoComisiones($divisa)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            echo json_encode($this->metodopago->obtenerMetodoPagoComisiones($divisa));
            exit;
        }
    }

    public function obtenerMetodosPagoActivos()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->metodopago->obtenerMetodosPagoActivos());
            exit;
        }
    }

    public function obtenerMetodosPago()
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {
            header('Content-Type: application/json', true);
            echo json_encode($this->metodopago->obtenerMetodosPago());
            exit;
        }
    }

    public function guardar()
    {
        if ('POST' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $mp_codigo = filter_input(INPUT_POST, 'cmp', FILTER_SANITIZE_STRING);
            $mp_nombre = filter_input(INPUT_POST, 'nmp', FILTER_SANITIZE_STRIPPED);
            $mp_descripcion = filter_input(INPUT_POST, 'dmp', FILTER_SANITIZE_STRING);

            if (empty($mp_codigo))
                $this->array_errors[] = "El campo Codigo es obligatorio.";
            if (empty($mp_nombre))
                $this->array_errors[] = "El campo Nombre es obligatorio.";
            if (empty($mp_descripcion))
                $this->array_errors[] = "El campo Descripcion es obligatorio.";

            if (empty($this->array_errors)) {

                if (empty($_POST['idmp'])) {
                    if ($this->metodopago->where(['mp_codigo' => $mp_codigo], true))
                        $this->array_errors[] = "El código $mp_codigo ya se encuentra en uso";
                } else {
                    $mp_id = filter_input(INPUT_POST, 'idmp', FILTER_SANITIZE_NUMBER_INT);
                    if ($this->metodopago->where(['mp_codigo' => $mp_codigo, 'mp_id!=', $mp_id], true))
                        $this->array_errors[] = "El código $mp_codigo ya se encuentra en uso";
                }

                if (empty($this->array_errors)) {
                    if (empty($_POST['idmp'])) {
                        header('Content-Type: application/json', true);
                        echo json_encode($this->metodopago->guardar([
                            'mp_codigo' => $mp_codigo,
                            'mp_nombre' => $mp_nombre,
                            'mp_descripcion' => $mp_descripcion
                        ], true));
                        exit;
                    } else {
                        header('Content-Type: application/json', true);
                        echo json_encode($this->metodopago->editar($mp_id, [
                            'mp_codigo' => $mp_codigo,
                            'mp_nombre' => $mp_nombre,
                            'mp_descripcion' => $mp_descripcion
                        ]));
                        exit;
                    }
                }
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $$this->array_errors]);
            exit;
        }
    }

    public function modificarEstatus(int $mp_id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $mp_id = filter_var($mp_id, FILTER_SANITIZE_NUMBER_INT);

            if ($this->metodopago->existe('mp_id', $mp_id)) {
                $estatus = $this->metodopago->obtener($mp_id);
                header('Content-Type: application/json', true);
                echo json_encode($this->metodopago->editar($mp_id, [
                    'mp_estatus' => $estatus['mp_estatus'] == 1 ? 0 : 1
                ]));
                exit;
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }

    public function eliminar(int $mp_id)
    {
        if ('GET' === $_SERVER['REQUEST_METHOD'] && isAjax()) {

            $id = filter_var($mp_id, FILTER_SANITIZE_NUMBER_INT);

            if ($this->metodopago->existe('mp_id', $id)) {
                if ($this->metodopago->chequearForanero($id)) {
                    $this->array_errors[] = "El metodo de pago no puede ser ELIMINADO ya que se encuentra relacionado con una divisa";
                } else {
                    header('Content-Type: application/json', true);
                    echo json_encode($this->metodopago->eliminar($id));
                    exit;
                }
            } else {
                $this->array_errors[] = 'Acción prohibida';
            }

            header('Content-Type: application/json', true);
            echo json_encode(['errors' => $this->array_errors]);
            exit;
        }
    }
}
