<?php

namespace App\Controladores;

use Core\Librerias\Solicitud;
use Core\ManejadorSession;
use Core\Vista;
use Automattic\WooCommerce\Client;
use Automattic\WooCommerce\HttpClient\HttpClientException;

final class LoginControlador
{
    public function index()
    {
        $url='';
        if (defined('WCURL') && defined('WCKEY') && defined('WCSECRECT') && defined('WCIMG')) {
            $url= constant('WCURL');
        }

        (isset($_SESSION['logueado'])) ? header('Location: ' . ruta_base()) : '/login';
        exit(Vista::viewAJAX('login/login',[
            'WooCommerce'=>$url
        ]));
    }

    public function acceso()
    {
        $solicitud = new Solicitud();
        $user = $solicitud->sanitize($_POST['user'], FILTER_SANITIZE_STRING);
        $pass = $solicitud->sanitize($_POST['pass'], FILTER_SANITIZE_STRING);

        return ManejadorSession::procesarLogin($user, $pass);
    }

    public function salir()
    {
        return ManejadorSession::destruirSession();
    }
}
