<div class="row" id="AppTabVenDia" v-cloak>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form @submit.prevent="buscar($event)" id="form_proven_busqueda">
                    <div class="form-row">
                        <div class="col-sm-4">
                            <div class="form-group form-floating-label">
                                <input id="vdfecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                                <label for="vdfecha_desde" class="placeholder">Fecha desde</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <input id="vdfecha_hasta" type="date" class="form-control input-border-bottom" v-model="fecha_hasta">
                                <label for="vdfecha_hasta" class="placeholder">Fecha hasta</label>
                                <div class="input-group-append">
                                    <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="sucursal" v-model="sucursal_predeterminada" class="form-control input-border-bottom" :disabled="disabled">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <?php if ($todosucursales) : ?>
                                        <option value="0">Todas</option>
                                    <?php endif; ?>
                                    <option v-for="row in sucursales_empleado" :value="row.su_id"><span v-if="disabled==false">Sucursal: </span>{{row.su_nombre}}</option>
                                </select>
                                <label for="sucursal" class="placeholder" v-if="disabled===false">Sucursal</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="vddivisas" class="form-control input-border-bottom" v-model="divisa">
                                    <option value="" disabled>Seleccionar divisa</option>
                                    <option value="0">Todas</option>
                                    <?php foreach ($divisas as $row) : ?>
                                        <option value="<?= $row['div_id'] ?>"><?= $row['div_descripcion'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="vddivisas" class="placeholder">Divisa</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="vddocumento" class="form-control input-border-bottom" v-model="documento">
                                    <option value="0">Todas</option>
                                    <option value="2">Facturas</option>
                                    <option value="1">Notas de Entrega</option>
                                    <option value="12">Orden de Entrega</option>
                                </select>
                                <label for="vddocumento" class="placeholder">Documento</label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="row row-card-no-pd">
            <div class="col-sm-6 col-md-2">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-success">
                            <br>
                        </div>
                        <div class="h2 m-0 text-primary">
                            <i class="loader loader-success" v-if="cargando"></i>
                            <span v-else> {{ artic_total }} </span>
                        </div>
                        <div class="text-primary mb-3">Articulos</div>
                    </div>
                </div>
            </div>
			 <div class="col-sm-6 col-md-2">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-success">
                            <br>
                        </div>
                        <div class="h2 m-0">
                            <i class="loader loader-success" v-if="cargando"></i>
                            <span v-else> {{ cantidad_art }} </span>
                        </div>
                        <div class="mb-3">Articulos vendidos</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-2">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            <br>
                        </div>
                        <div class="h2 m-0">
                            <i class="loader loader-success" v-if="cargando"></i>
                            <span v-else>{{ acumulado }}</span>
                        </div>
                        <div class="mb-3">Total acumulado</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            <br>
                        </div>
                        <div class="h2 m-0">
                            <i class="loader loader-success" v-if="cargando"></i>
                            <span v-else>{{ pendiente }}</span>
                        </div>
                        <div class="mb-3">Total pendiente</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            <br>
                        </div>
                        <div class="h2 m-0">
                            <i class="loader loader-success" v-if="cargando"></i>
                            <span v-else>{{ total }}</span>
                        </div>
                        <div class="mb-3">Total</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-body" :class="cargando_tabla">
                <div class="table-responsive">
                    <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tab_venta_dia">
                        <thead>
                            <tr class="text-center">
                                <th style="width: 10%;">Código</th>
                                <th style="width: 20%;">Cliente</th>
                                <th>Acumulado</th>
                                <th>Pendiente</th>
                                <th>Total</th>
                                <th>Fecha</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in productos">
                                <td class="text-center"><a :href="row.uri">{{ row.documento }}{{ row.correlativo }}</a></td>
                                <td class="text-left">{{ row.cliente }}</td>
                                <td class="text-right">{{ moneda(row.acumulado, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.pendiente, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ fechaNormal(row.fecha) }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#AppTabVenDia',
        data: {
            productos: [],
            pendiente: 0,
            acumulado: 0,
            artic_total: 0,
            total: 0,
            divisa: 1,
            documento: 0,
            fecha_desde: moment().format('YYYY-MM-DD'),
            fecha_hasta: moment().format('YYYY-MM-DD'),
            errorForm: [],
            cargando: false,
            cargando_tabla: '',
            cantidad_art:0,
            sucursal_predeterminada: '',
            sucursales_empleado: [],
            sucursals: '',
            disabled: false
        },
        created() {
           this.obtenerSucursalesEmpleado();
        },
        methods: {
            obtenerSucursalesEmpleado() {
                axios
                    .get("ingresosegresos/obtenerSucursalesEmpleado")
                    .then((response) => {
                        this.sucursales_empleado = response.data.sucursales;
                        this.sucursal_predeterminada = response.data.id;
                        if (response.data.desactivar == true) {
                            this.disabled = true
                        }
                    })
                    .catch((e) => notificacion());
            },
            resetearFormulario() {
                document.getElementById('form_proven_busqueda').reset();
                this.fecha_desde = moment().format('YYYY-MM-DD');
                this.fecha_hasta = moment().format('YYYY-MM-DD');
                this.errorForm = [];
            },
            buscar: function(event) {

                let select_documento = document.getElementById('vddocumento');
                let select_divisa = document.getElementById('vddivisas');

                let selectedOptionDoc = select_documento.options[select_documento.selectedIndex];
                let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

                this.errorForm = [];
                this.cargando = true;
                this.cargando_tabla = 'is-loading is-loading-lg';
                $("#tab_venta_dia").DataTable().destroy();

                axios.get('ingresosegresos/obtenerDocumentosVentaDia', {
                    params: {
                        fecha_desde: this.fecha_desde,
                        fecha_hasta: this.fecha_hasta,
                        divisa: this.divisa,
                        documento: this.documento,
                        sucursal: this.sucursal_predeterminada
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        this.productos = response.data.documentos;
                        this.pendiente = response.data.pendiente;
                        this.acumulado = response.data.acumulado;
                        this.artic_total = response.data.artic_total;
                        this.total = response.data.total;
                        this.cantidad_art=response.data.cantidad_art;
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    this.cargando_tabla = '';

                    let buttonCommon = {
                        exportOptions: {
                            format: {
                                body: function(data, row, column, node) {
                                    if (column === 2 || column === 3 || column === 4) {
                                        return convertir_a_float(data)
                                    } else {
                                        return data.replace(/<[^>]*>?/g, '');
                                    }
                                }
                            }
                        }
                    };

                    $("#tab_venta_dia").DataTable({
                        order: [],
                        dom: 'Bfrtip',
                        buttons: [
                            $.extend(true, {}, buttonCommon, {
                                extend: 'excelHtml5',
                                title: 'Ventas del dia ' +
                                    moment(this.fecha_desde).format('DD-MM-YYYY') +
                                    ' hasta ' +
                                    moment(this.fecha_hasta).format('DD-MM-YYYY') +
                                    ' Documento (' + selectedOptionDoc.text + ')' +
                                    ' Divisa (' + selectedOptionDiv.text + ')',
                            }),
                        ]
                    });
                });
            },
            moneda(num, div_locale, div_simbolo, decimal = 2) {
                return monedaMoneda(num, div_locale, div_simbolo, decimal);
            },
            decimal(num, div_locale, decimal = 2) {
                return monedaDecimal(num, div_locale, decimal);
            },
            fechaNormal: (value) => {
                return moment(value).format('DD/MM/YYYY, h:mm A');
            }
        }
    });
</script>