<div class="row" id="appTransferenciasEspera" v-cloak>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form @submit.prevent="obtenerTransferencias()" id="form_proven_busqueda">
                    <div class="form-row">
                        <div class="col-sm-4">
                            <div class="form-group form-floating-label">
                                <input id="pvfecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                                <label for="pvfecha_desde" class="placeholder">Fecha desde</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <input id="pvfecha_hasta" type="date" class="form-control input-border-bottom" v-model="fecha_hasta">
                                <label for="pvfecha_hasta" class="placeholder">Fecha hasta</label>
                                <div class="input-group-append">
                                    <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="pvdivisas" class="form-control input-border-bottom" v-model="divisa">
                                    <?php foreach ($divisas as $row) : ?>
                                        <option value="<?= $row['div_id'] ?>" <?= ($row['div_predeterminado'] == 1) ? 'selected' : '' ?>><?= $row['div_descripcion'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="pvdivisas" class="placeholder">Divisa</label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_transferencias">
                        <thead>
                            <tr>
                                <th>Fecha</th>
                                <th>Empleado</th>
                                <th>Descripción</th>
                                <th>Cuenta</th>
                                <th>Categoria</th>
                                <th>Divisa</th>
                                <th class="text-right">Monto</th>
                                <th>Sucursal</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in balance">
                                <td style="width: 12%;">{{ row.fecha }}</td>
                                <td>{{ row.empleado }}</td>
                                <td>{{ row.descripcion }}</td>
                                <td>{{ row.cuenta }}</td>
                                <td>{{ row.categoria }}</td>
                                <td>{{ row.divisa }}</td>
                                <td class="text-right">{{ row.monto }}</td>
                                <td>{{row.sucursal}}</td>
                                <td>
                                    <button type="button" id="procesar" class="procesar btn btn-icon btn-sm btn-light mb-3" style="box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;" @click="Validar_transferencia(row.id)"><i class="fa fa-check text-success" style="padding: .65rem;"></i></button>
                                    <button type="button" id="eliminar" class="eliminar btn btn-icon btn-sm btn-light mb-3" style="box-shadow: rgb(221, 221, 221) 2px 6px 15px 0px;" @click="eliminar_transferenciaEnEspera(row.id)"><i class="fa fa-trash text-danger" style="padding: .65rem;"></i></button>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#appTransferenciasEspera',
        data: {
            div_locale: '',
            div_simbolo: '',
            div_decimal: 2,
            fecha_desde: moment().format('YYYY-MM-DD'),
            fecha_hasta: moment().format('YYYY-MM-DD'),
            b_categoria: '',
            tipo: '',
            cuentas: [],
            metodos_de_pagos: [],
            balance_creditos: [],
            balance: [],
            divisa: 2,
            total_credito: 0,
            errorForm: [],
            cargando: false,
            cargando_tabla: '',
        },
        created() {
            this.obtenerTransferencias();
        },
        methods: {
            obtenerTransferencias() {
                this.cargando_tabla = 'is-loading is-loading-lg';
                $("#tabla_transferencias").DataTable().destroy();
                axios({
                    method: 'post',
                    url: 'ingresosegresos/obtenerTransferenciasespera',
                    data: {
                        fecha_desde: this.fecha_desde,
                        fecha_hasta: this.fecha_hasta,
                        id_divisa: this.divisa,
                    },
                    transformRequest: serializar(),
                }).then(response => {
                    this.balance = response.data;
                }).catch(e => notificacion()).finally(() => {
                    $("#tabla_transferencias").DataTable({
                        order: [],
                    });
                });
            },
            Validar_transferencia(id){
                Swal.fire({
                        title: 'Validar transferencia',
                        text: "¿Estás seguro de querer validar esta transferencia?",
                        icon: 'success',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#aaa',
                        confirmButtonText: 'Confirmar'
                    }).then((result) => {
                        if (result.value) {
                            axios
                                .get("ingresosegresos/Validar_transferencia/"+id)
                                .then((response) => {
                                    if (response.data.errors == null) {
                                        if (response.data == true) {
                                            notificacion('fa fa-coins', 'Transferencia', 'Transferencia exitosa', 'success');
                                            this.obtenerTransferencias();
                                        }
                                    } else {
                                        let total_errores = response.data.errors.length
                                        for (let i = 0; i < total_errores; i++) {
                                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                                        }
                                    }
                                })
                                .catch((e) => notificacion());
                        }
                    });
            },
            eliminar_transferenciaEnEspera(id){
                Swal.fire({
                        title: 'Eliminar',
                        text: "¿Estás seguro de querer eliminar esta transferencia ?",
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#aaa',
                        confirmButtonText: 'Eliminar'
                    }).then((result) => {
                        if (result.value) {
                            axios
                                .get("ingresosegresos/eliminar_transferenciaEnEspera/"+id)
                                .then((response) => {
                                        if (response.data == true) {
                                            notificacion('fa fa-ban', 'Transferencia', 'Transferencia eliminada', 'warning');
                                        }else{
                                            notificacion('fa fa-ban', 'Error', 'Error al eliminar la transferencia', 'warning');
                                        }
                                })
                                .catch((e) => notificacion());
                         }
                    });
            }
        }
    });
</script>