<div class="row" id="AppTabProveeVen" v-cloak>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form @submit.prevent="buscarVentaProvee()" id="form_proven_busqueda">
                    <div class="form-row">
                        <div class="col-sm-4">
                            <div class="form-group form-floating-label">
                                <input id="pvfecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                                <label for="pvfecha_desde" class="placeholder">Fecha desde</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <input id="pvfecha_hasta" type="date" class="form-control input-border-bottom" v-model="fecha_hasta">
                                <label for="pvfecha_hasta" class="placeholder">Fecha hasta</label>
                                <div class="input-group-append">
                                    <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="sucursal" v-model="sucursal_predeterminada" class="form-control input-border-bottom" :disabled="disabled">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <?php if ($todosucursales) : ?>
                                        <option value="0">Todas</option>
                                    <?php endif; ?>
                                    <option v-for="row in sucursales_empleado" :value="row.su_id"><span v-if="disabled==false">Sucursal: </span>{{row.su_nombre}}</option>
                                </select>
                                <label for="sucursal" class="placeholder" v-if="disabled===false">Sucursal</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="proveedor" v-model="proveedor" class="form-control input-border-bottom">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <option value="0">Todos</option>
                                    <option v-for="row in proveedores" :value="row.prov_id">{{row.prov_razonsocial}}</option>
                                </select>
                                <label for="proveedor" class="placeholder">Proveedor</label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-body" :class="cargando_tabla">
                <div class="table-responsive">
                    <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tab_provee">
                        <thead>
                            <tr>
                                <th style="width: 25%;" class="text-left">Proveedor</th>
                                <th class="text-right">Costo</th>
                                <th class="text-right">Venta</th>
                                <th class="text-right">Ganancia</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in totalproveedores.proveedores">
                                <td class="text-left">{{ row.proveedor }}</td>
                                <td class="text-right">{{ moneda(row.costo, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.venta, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.ganancia, row.div_locale, row.div_simbolo) }}</td>
                                <td>
                                    <button class="btn btn-border btn-info btn-sm btn-round" type="button" @click="lists_productos(row.proveedor_id)"><i class="fa fa-cubes"></i> Productos</button>
                                </td>
                            </tr>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="text-center">Total</th>
                                <th class="text-right">{{ moneda(totalproveedores.costo, totalproveedores.div_locale, totalproveedores.div_simbolo) }}</th>
                                <th class="text-right">{{ moneda(totalproveedores.venta, totalproveedores.div_locale, totalproveedores.div_simbolo) }}</th>
                                <th class="text-right">{{ moneda(totalproveedores.ganancia, totalproveedores.div_locale, totalproveedores.div_simbolo) }}</th>
                                <th class="text-right"></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php include 'app/ingresosegresos/vista/modal_prodProv.php' ?>
</div>

<script>
    new Vue({
        el: '#AppTabProveeVen',
        data: {
            proveedores: [],
            sucursales_empleado: [],
            sucursal_predeterminada: '',
            fecha_desde: moment().format('YYYY-MM-DD'),
            fecha_hasta: moment().format('YYYY-MM-DD'),
            errorForm: [],
            totalproveedores: [],
            cargando: false,
            proveedor: 0,
            cargando_tabla: 'is-loading is-loading-lg',
            disabled: false,
            productos: []
        },
        created() {
            this.obtenerSucursalesEmpleado();
            this.proveedoresActivos();
            this.buscarVentaProvee();
        },
        methods: {
            obtenerSucursalesEmpleado() {
                axios
                    .get("ingresosegresos/obtenerSucursalesEmpleado")
                    .then((response) => {
                        this.sucursales_empleado = response.data.sucursales;
                        this.sucursal_predeterminada = response.data.id;
                        if (response.data.desactivar == true) {
                            this.disabled = true
                        }
                    })
                    .catch((e) => notificacion());
            },
            proveedoresActivos() {
                axios
                    .get("proveedores/proveedoresActivos")
                    .then((response) => {
                        this.proveedores = response.data;
                    })
                    .catch((e) => notificacion());
            },
            buscarVentaProvee() {

                this.errorForm = [];
                this.cargando = true;
                this.cargando_tabla = 'is-loading is-loading-lg';
                $("#tab_provee").DataTable().destroy();

                axios.get('ingresosegresos/proveedoresReportes', {
                    params: {
                        fecha_desde: this.fecha_desde,
                        fecha_hasta: this.fecha_hasta,
                        proveedor: this.proveedor,
                        sucursal: this.sucursal_predeterminada
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        this.totalproveedores = response.data;
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    this.cargando_tabla = '';

                    let buttonCommon = {
                        exportOptions: {
                            format: {
                                body: function(data, row, column, node) {
                                    if (column === 2 || column === 3 || column === 4) {
                                        return convertir_a_float(data)
                                    } else {
                                        return data.replace(/<[^>]*>?/g, '');
                                    }
                                }
                            }
                        }
                    };

                    $("#tab_provee").DataTable({
                        retrieve: true,
                        order: [],
                        dom: 'Blfrtip',
                        buttons: [
                            $.extend(true, {}, buttonCommon, {
                                extend: 'excelHtml5',
                                title: 'Ventas por proveedores' +
                                    moment(this.fecha_desde).format('DD-MM-YYYY') +
                                    ' hasta ' +
                                    moment(this.fecha_desde).format('DD-MM-YYYY')
                            }),
                            'pdf'
                        ]
                    });
                });
            },
            moneda(num, div_locale, div_simbolo, decimal = 2) {
                return monedaMoneda(num, div_locale, div_simbolo, decimal);
            },
            lists_productos(id) {
                $("#tab_pp").DataTable().destroy();
                axios.get('ingresosegresos/productosProvReportes', {
                    params: {
                        fecha_desde: this.fecha_desde,
                        fecha_hasta: this.fecha_hasta,
                        proveedor: id,
                        sucursal: this.sucursal_predeterminada
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        this.productos = response.data;
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    $("#tab_pp").DataTable({
                        order: [],
                        dom: 'Blfrtip',
                        buttons:[
                            'pdf'
                        ]
                    });
                    $('#modal_pp').modal('show');
                });
            },
        }
    });
</script>