<div class="row" id="AppTabProVend" v-cloak>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form @submit.prevent="buscar($event)" id="form_proven_busqueda">
                    <div class="form-row">
                        <div class="col-sm-4">
                            <div class="form-group form-floating-label">
                                <input id="pvfecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                                <label for="pvfecha_desde" class="placeholder">Fecha desde</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <input id="pvfecha_hasta" type="date" class="form-control input-border-bottom" v-model="fecha_hasta">
                                <label for="pvfecha_hasta" class="placeholder">Fecha hasta</label>
                                <div class="input-group-append">
                                    <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="pvdivisas" class="form-control input-border-bottom" v-model="divisa">
                                    <option value="0">Todas</option>
                                    <?php foreach ($divisas as $row) : ?>
                                        <option value="<?= $row['div_id'] ?>" <?= ($row['div_predeterminado'] == 1) ? 'selected' : '' ?>><?= $row['div_descripcion'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="pvdivisas" class="placeholder">Divisa</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="sucursal" v-model="sucursal_predeterminada" class="form-control input-border-bottom" :disabled="disabled">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <?php if ($todosucursales) : ?>
                                        <option value="0">Todas</option>
                                    <?php endif; ?>
                                    <option v-for="row in sucursales_empleado" :value="row.su_id"><span v-if="disabled==false">Sucursal: </span>{{row.su_nombre}}</option>
                                </select>
                                <label for="sucursal" class="placeholder" v-if="disabled===false">Sucursal</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="pvdivisas" class="form-control input-border-bottom" v-model="estatus">
                                    <option value="0">Todas</option>
                                    <option value="2">Pendientes</option>
                                    <option value="1">Pagados</option>
                                </select>
                                <label for="pvdivisas" class="placeholder">Estatus del Documento</label>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="form-group input-group form-floating-label">
                                <select id="vdagente" class="form-control input-border-bottom" v-model="agente">
                                    <option value="0">Todos</option>
                                    <?php foreach ($agentes as $row) : ?>
                                        <option value="<?= $row['einfo_id'] ?>"><?= $row['einfo_nombres'] . ' ' . $row['einfo_apellidos'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="vdagente" class="placeholder">Agente</label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="row row-card-no-pd">
            <div class="col-sm-6 col-md-2">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-success">
                            <br>
                        </div>
                        <div class="h2 m-0 text-primary">
                            <i class="loader loader-success" v-if="cargando"></i>
                            <span v-else> {{ cantidad_articulos }} </span>
                        </div>
                        <div class="text-primary mb-3">Articulos</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-2">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-success">
                            <br>
                        </div>
                        <div class="h2 m-0">
                            <i class="loader loader-success" v-if="cargando"></i>
                            <span v-else> {{ artic_total }}</span>
                        </div>
                        <div class="mb-3">Articulos vendidos</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-2">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            <br>
                        </div>
                        <div class="h2 m-0">
                            <i class="loader loader-success" v-if="cargando"></i>
                            <span v-else>{{ costo_total }}</span>
                        </div>
                        <div class="mb-3">Total costo</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            <br>
                        </div>
                        <div class="h2 m-0">
                            <i class="loader loader-success" v-if="cargando"></i>
                            <span v-else>{{ venta_total }}</span>
                        </div>
                        <div class="mb-3">Total venta</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            {{ ganancia_porc }}%
                            <i class="fa fa-chevron-up"></i>
                        </div>
                        <div class="h2 m-0">
                            <i class="loader loader-success" v-if="cargando"></i>
                            <span v-else>{{ ganancia }}</span>
                        </div>
                        <div class="mb-3">Ganancia</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-body" :class="cargando_tabla">
                <div class="table-responsive">
                    <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tab_pro_vend">
                        <thead>
                            <tr>
                                <th class="text-left">Fecha</th>
                                <th class="text-left">Documento</th>
                                <th style="width: 15px;" class="text-left">Producto</th>
                                <th class="text-left">Empleado</th>
                                <th class="text-left">ID Cliente</th>
                                <th class="text-left">Cliente</th>
                                <th class="text-left">ID Grupo</th>
                                <th class="text-left">Grupo</th>
                                <th class="text-left">Agente</th>
                                <th class="text-center">Divisa</th>
                                <th class="text-center">Cantidad</th>
                                <th class="text-right">Pcosto</th>
                                <th class="text-right">Pventa</th>
                                <th class="text-right">Ganancia</th>
                                <th class="text-right">Porcentaje</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in productos">
                                <td class="text-left">{{ row.fecha }}</td>
                                <td class="text-left"><a :href="row.uri">{{ row.documento }}</a></td>
                                <td style="width: 15px;" class="text-left">{{ row.pro_descripcion }}</td>
                                <td class="text-left">{{ row.empleado }}</td>
                                <td class="text-left">{{ row.cliente_id }}</td>
                                <td class="text-left">{{ row.cliente }}</td>
                                <td class="text-left">{{ row.grupo_id }}</td>
                                <td class="text-left">{{ row.grupo }}</td>
                                <td class="text-left">{{ row.agente }}</td>
                                <td class="text-left">{{ row.div_nombre }}</td>
                                <td class="text-center">{{ row.cantidad }}</td>
                                <td class="text-right">{{ moneda(row.costo_total, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.total, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.ganancia, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ decimal(row.ganancia_porct, row.div_locale) }} %</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#AppTabProVend',
        data: {
            productos: [],
            costo_total: 0,
            venta_total: 0,
            artic_total: 0,
            ganancia: 0,
            ganancia_porc: 0,
            fecha_desde: moment().format('YYYY-MM-DD'),
            divisa: 0,
            fecha_hasta: moment().format('YYYY-MM-DD'),
            errorForm: [],
            cargando: false,
            cargando_tabla: 'is-loading is-loading-lg',
            cantidad_articulos: 0,
            sucursal_predeterminada: '',
            sucursales_empleado: [],
            sucursals: '',
            disabled: false,
            estatus: 0,
            agente: 0,
        },
        created() {
            this.obtenerSucursalesEmpleado();
        },
        mounted() {

        },
        methods: {
            obtenerProductos() {

                let select_divisa = document.getElementById('pvdivisas');
                let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

                axios.get('ingresosegresos/obtenerProductosVendidosdocumentos', {
                    params: {
                        fecha_desde: this.fecha_desde,
                        fecha_hasta: this.fecha_hasta,
                        divisa: null,
                        sucursal: this.sucursal_predeterminada,
                        estatus: this.estatus,
                        agente:this.agente
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        if (Object.keys(response.data.productos).length > 0) {
                            this.productos = response.data.productos;
                            this.costo_total = response.data.costo_total;
                            this.venta_total = response.data.venta_total;
                            this.artic_total = response.data.artic_total;
                            this.ganancia = response.data.ganancia;
                            this.ganancia_porc = response.data.ganancia_porc;
                            this.cantidad_articulos = response.data.cantidad_articulos;
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando_tabla = '';

                    let buttonCommon = {
                        exportOptions: {
                            format: {
                                body: function(data, row, column, node) {
                                    if (column === 11 || column === 12 || column === 13 || column === 14 || column === 15) {
                                        return convertir_a_float(data)
                                    } else {
                                        return data.replace(/<[^>]*>?/g, '');
                                    }
                                }
                            }
                        }
                    };

                    $("#tab_pro_vend").DataTable({
                        order: [],
                        dom: 'Bfrtip',
                        buttons: [
                            $.extend(true, {}, buttonCommon, {
                                extend: 'excelHtml5',
                                title: 'Productos vendidos desde ' +
                                    moment(this.fecha_desde).format('DD-MM-YYYY') +
                                    ' hasta ' +
                                    moment(this.fecha_desde).format('DD-MM-YYYY') +
                                    ' Divisa (' + selectedOptionDiv.text + ')',
                            }),
                        ]
                    });
                });
            },
            obtenerSucursalesEmpleado() {
                axios
                    .get("ingresosegresos/obtenerSucursalesEmpleado")
                    .then((response) => {
                        this.sucursales_empleado = response.data.sucursales;
                        this.sucursal_predeterminada = response.data.id;
                        if (response.data.desactivar == true) {
                            this.disabled = true
                        }
                        this.obtenerProductos();
                    })
                    .catch((e) => notificacion());
            },
            resetearFormulario() {
                document.getElementById('form_proven_busqueda').reset();
                this.fecha_desde = '';
                this.fecha_hasta = moment().format('YYYY-MM-DD');
                this.errorForm = [];
            },
            buscar: function(event) {

                let select_divisa = document.getElementById('pvdivisas');
                let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

                this.errorForm = [];
                this.cargando = true;
                this.cargando_tabla = 'is-loading is-loading-lg';
                $("#tab_pro_vend").DataTable().destroy();

                axios.get('ingresosegresos/obtenerProductosVendidosdocumentos', {
                    params: {
                        fecha_desde: this.fecha_desde,
                        fecha_hasta: this.fecha_hasta,
                        divisa: this.divisa,
                        sucursal: this.sucursal_predeterminada,
                        estatus: this.estatus,
                        agente:this.agente
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        this.productos = response.data.productos;
                        this.costo_total = response.data.costo_total;
                        this.venta_total = response.data.venta_total;
                        this.artic_total = response.data.artic_total;
                        this.ganancia = response.data.ganancia;
                        this.ganancia_porc = response.data.ganancia_porc;
                        this.cantidad_articulos = response.data.cantidad_articulos;
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    this.cargando_tabla = '';

                    let buttonCommon = {
                        exportOptions: {
                            format: {
                                body: function(data, row, column, node) {
                                    if (column === 11 || column === 12 || column === 13 || column === 14 || column === 15) {
                                        return convertir_a_float(data)
                                    } else {
                                        return data.replace(/<[^>]*>?/g, '');
                                    }
                                }
                            }
                        }
                    };

                    $("#tab_pro_vend").DataTable({
                        order: [],
                        dom: 'Bfrtip',
                        buttons: [
                            $.extend(true, {}, buttonCommon, {
                                extend: 'excelHtml5',
                                title: 'Productos vendidos desde ' +
                                    moment(this.fecha_desde).format('DD-MM-YYYY') +
                                    ' hasta ' +
                                    moment(this.fecha_desde).format('DD-MM-YYYY') +
                                    ' Divisa (' + selectedOptionDiv.text + ')',
                            }),
                        ]
                    });
                });
            },
            moneda(num, div_locale, div_simbolo, decimal = 2) {
                return monedaMoneda(num, div_locale, div_simbolo, decimal);
            },
            decimal(num, div_locale, decimal = 2) {
                return monedaDecimal(num, div_locale, decimal);
            }
        }
    });
</script>