<div class="row" id="AppInversion" v-cloak>
    <div class="col-12">
        <div class="row row-card-no-pd" :class="cargando">
            <div class="col-sm-6 col-md-3">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            <br>
                        </div>
                        <div class="h1 m-0 text-primary">{{ cantidad }}</div>
                        <div class="text-primary mb-3">Cantidad de articulos</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            <br>
                        </div>
                        <div class="h1 m-0">
                            {{ tcosto }}
                        </div>
                        <div class="mb-3">Precio costo</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            <br>
                        </div>
                        <div class="h1 m-0">
                            {{ tventa }}
                        </div>
                        <div class="mb-3">Precio venta</div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6 col-md-3">
                <div class="card">
                    <div class="card-body p-3 text-center">
                        <div class="text-right text-success">
                            {{ porcentaje }}%
                            <i class="fa fa-chevron-up"></i>
                        </div>
                        <div class="h1 m-0">
                            {{ ganancia }}
                        </div>
                        <div class="mb-3">Ganancia</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="form-group">
                <div class="form-group form-floating-label">
                    <select class="form-control input-border-bottom" id="almacenes" v-model="almacen" @change="buscarPorAlmacen($event)">
                        <option value="">Todos</option>
                        <?php foreach ($almacenes as $row) : ?>
                            <option value="<?= $row['alm_id'] ?>"><?= $row['alm_nombre'] ?></option>
                        <?php endforeach; ?>
                    </select>
                    <label for="almacenes" class="placeholder">Almacenes</label>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-body" :class="cargando">
                <div class="table-responsive">
                    <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tab_tabla_pro">
                        <thead>
                            <tr>
                                <th style="width: 25%;">Descripcion</th>
                                <th class="text-right">Precio costo</th>
                                <th class="text-right">Precio venta</th>
                                <th class="text-right">Cantidad</th>
                                <th class="text-center">Almacen</th>
                                <th class="text-right">Ganancia</th>
                                <th class="text-right">Porcentaje</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in productos">
                                <td>{{ row.descripcion }}</td>
                                <td class="text-right">{{ row.costo }}</td>
                                <td class="text-right">{{ row.precio }}</td>
                                <td class="text-right">{{ row.cantidad }}</td>
                                <td class="text-center">{{ row.almacen }}</td>
                                <td class="text-right">{{ row.ganancia }}</td>
                                <td class="text-right">{{ row.porcentaje }}%</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#AppInversion',
        data: {
            almacen: '',
            productos: '',
            tcosto: 0,
            tventa: 0,
            cantidad: 0,
            ganancia: 0,
            porcentaje: 0,
            cargando: false,
            errorForm: [],
        },
        created() {
            axios.get('ingresosegresos/obtenerInversion/' + Number(this.almacen)).then(response => {
                if (response.data.errors == null) {
                    this.productos = response.data.productos;
                    this.tcosto = response.data.tcosto;
                    this.tventa = response.data.tventa;
                    this.cantidad = response.data.cantidad;
                    this.ganancia = response.data.ganancia;
                    this.porcentaje = response.data.porcentaje;
                } else {
                    let total_errores = response.data.errors.length
                    for (let i = 0; i < total_errores; i++) {
                        notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                    }
                }
            }).catch(e => notificacion()).finally(() => {
                this.cargando = '';

                let buttonCommon = {
                    exportOptions: {
                        format: {
                            body: function(data, row, column, node) {
                                if (column === 1 || column === 2 || column === 5 || column === 6) {
                                    return convertir_a_float(data)
                                } else {
                                    return data.replace(/<[^>]*>?/g, '');
                                }
                            }
                        }
                    }
                };

                $("#tab_tabla_pro").DataTable({
                    retrieve: true,
                    order: [],
                    dom: 'Bfrtip',
                    buttons: [
                        $.extend(true, {}, buttonCommon, {
                            extend: 'excelHtml5',
                            title: 'Inversión (PRODUCTOS) Almacen (Todos)' + moment().format('DD-MM-YYYY'),
                        }),
                    ]
                });
            });
        },
        methods: {
            buscarPorAlmacen(event) {

                let selectedOption = event.target.options[event.target.selectedIndex];

                this.errorForm = [];
                this.cargando = 'is-loading is-loading-lg';
                $('#tab_tabla_pro').DataTable().destroy();

                axios.get('ingresosegresos/obtenerInversion/' + Number(event.target.value)).then(response => {
                    if (response.data.errors == null) {
                        this.productos = response.data.productos;
                        this.tcosto = response.data.tcosto;
                        this.tventa = response.data.tventa;
                        this.cantidad = response.data.cantidad;
                        this.ganancia = response.data.ganancia;
                        this.porcentaje = response.data.porcentaje;
                    } else {
                        let total_errores = response.data.errors.length
                        for (let i = 0; i < total_errores; i++) {
                            notificacion('fa fa-ban', 'Advertencia', response.data.errors[i], 'warning');
                        }
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = '';

                    let buttonCommon = {
                        exportOptions: {
                            format: {
                                body: function(data, row, column, node) {
                                    if (column === 1 || column === 2 || column === 5 || column === 6) {
                                        return convertir_a_float(data)
                                    } else {
                                        return data.replace(/<[^>]*>?/g, '');
                                    }
                                }
                            }
                        }
                    };

                    $("#tab_tabla_pro").DataTable({
                        retrieve: true,
                        order: [],
                        dom: 'Bfrtip',
                        buttons: [
                            $.extend(true, {}, buttonCommon, {
                                extend: 'excelHtml5',
                                title: 'Inversión (PRODUCTOS) Almacen (' + selectedOption.text + ') ' + moment().format('DD-MM-YYYY'),
                            }),
                        ]
                    });
                });
            }
        }
    });
</script>
