<div class="row" id="AppTabPrecioVen" v-cloak>
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <form @submit.prevent="buscar($event)" id="form_proven_busqueda">
                    <div class="form-row">
                        <div class="col-sm-3">
                            <div class="form-group form-floating-label">
                                <input id="pvfecha_desde" type="date" class="form-control input-border-bottom" v-model="fecha_desde">
                                <label for="pvfecha_desde" class="placeholder">Fecha desde</label>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group input-group form-floating-label">
                                <input id="pvfecha_hasta" type="date" class="form-control input-border-bottom" v-model="fecha_hasta">
                                <label for="pvfecha_hasta" class="placeholder">Fecha hasta</label>
                                <div class="input-group-append">
                                    <button class="btn btn-border" type="submit"> <span class="fa fa-search"></span> </button>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group input-group form-floating-label">
                                <select id="sucursal" v-model="sucursal_predeterminada" class="form-control input-border-bottom" :disabled="disabled">
                                    <option disabled value="">Seleccione un elemento</option>
                                    <?php if ($todosucursales) : ?>
                                        <option value="0">Todas</option>
                                    <?php endif; ?>
                                    <option v-for="row in sucursales_empleado" :value="row.su_id"><span v-if="disabled==false">Sucursal: </span>{{row.su_nombre}}</option>
                                </select>
                                <label for="sucursal" class="placeholder" v-if="disabled===false">Sucursal</label>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group input-group form-floating-label">
                                <select id="pvdivisas" class="form-control input-border-bottom" v-model="divisa">
                                    <option value="0">Todas</option>
                                    <?php foreach ($divisas as $row) : ?>
                                        <option value="<?= $row['div_id'] ?>" <?= ($row['div_predeterminado'] == 1) ? 'selected' : '' ?>><?= $row['div_descripcion'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <label for="pvdivisas" class="placeholder">Divisa</label>
                            </div>
                        </div>
                        <div class="col-sm-3">
                            <div class="form-group input-group form-floating-label">
                                <select id="pvdivisas" class="form-control input-border-bottom" v-model="filtro">
                                    <option value="1">> Mayor</option>
                                    <option value="2">
                                        < Menor</option>
                                </select>
                                <label for="pvdivisas" class="placeholder">Filtrar por precio venta</label>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class=" alert alert-warning" role="alert" v-for="row in errorForm">
                                {{ row }}
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-body" :class="cargando_tabla">
                <div class="table-responsive">
                    <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tab_precio_ven">
                        <thead>
                            <tr>
                                <th class="text-center">Documento</th>
                                <th style="width: 25%;" class="text-left">Producto</th>
                                <th class="text-center">Divisa</th>
                                <th class="text-center">Cantidad</th>
                                <th class="text-right">PCosto</th>
                                <th class="text-right">PVenta</th>
                                <th class="text-right">PFact/Nota</th>
                                <th class="text-right">PDescuento</th>
                                <th class="text-right">Descuento</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr v-for="row in productos">
                                <td class="text-center"><a :href="row.url" target="_blank">{{ row.tipo }}{{ row.id }}</a></td>
                                <td class="text-left">{{ row.pro_descripcion }}</td>
                                <td class="text-center">{{ row.div_nombre }}</td>
                                <td class="text-center">{{ row.cantidad }}</td>
                                <td class="text-right">{{ moneda(row.pro_costo, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.precio_venta, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.precio_factura, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ moneda(row.precio_desc, row.div_locale, row.div_simbolo) }}</td>
                                <td class="text-right">{{ decimal(row.descuento, row.div_locale) }} %</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#AppTabPrecioVen',
        data: {
            productos: [],
            costo_total: 0,
            venta_total: 0,
            artic_total: 0,
            ganancia: 0,
            ganancia_porc: 0,
            fecha_desde: moment().format('YYYY-MM-DD'),
            divisa: 1,
            fecha_hasta: moment().format('YYYY-MM-DD'),
            errorForm: [],
            cargando: false,
            cargando_tabla: 'is-loading is-loading-lg',
            cantidad_articulos: 0,
            filtro: 1,
            sucursal_predeterminada: '',
            sucursales_empleado: [],
            sucursals: '',
            disabled: false
        },
        created() {
            this.obtenerSucursalesEmpleado();
        },
        mounted() {},
        methods: {
            obtenerProductos() {
                let select_divisa = document.getElementById('pvdivisas');
                let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

                axios.get('ingresosegresos/obtenerPrecioProductoVendidos', {
                    params: {
                        fecha_desde: this.fecha_desde,
                        fecha_hasta: this.fecha_hasta,
                        divisa: this.divisa,
                        filtro: this.filtro,
                        sucursal: this.sucursal_predeterminada
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        if (Object.keys(response.data.productos).length > 0) {
                            this.productos = response.data.productos;
                        }
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando_tabla = '';

                    let buttonCommon = {
                        exportOptions: {
                            format: {
                                body: function(data, row, column, node) {
                                    if (column === 2 || column === 3 || column === 4 || column === 5 || column === 6) {
                                        return convertir_a_float(data)
                                    } else {
                                        return data.replace(/<[^>]*>?/g, '');
                                    }
                                }
                            }
                        }
                    };

                    $("#tab_precio_ven").DataTable({
                        order: [],
                        dom: 'Bfrtip',
                        buttons: [
                            $.extend(true, {}, buttonCommon, {
                                extend: 'excelHtml5',
                                title: 'Productos vendidos desde ' +
                                    moment(this.fecha_desde).format('DD-MM-YYYY') +
                                    ' hasta ' +
                                    moment(this.fecha_desde).format('DD-MM-YYYY') +
                                    ' Divisa (' + selectedOptionDiv.text + ')',
                            }),
                        ]
                    });
                });
            },
            obtenerSucursalesEmpleado() {
                axios
                    .get("ingresosegresos/obtenerSucursalesEmpleado")
                    .then((response) => {
                        this.sucursales_empleado = response.data.sucursales;
                        this.sucursal_predeterminada = response.data.id;
                        if (response.data.desactivar == true) {
                            this.disabled = true
                        }
                        this.obtenerProductos();
                    })
                    .catch((e) => notificacion());
            },
            resetearFormulario() {
                document.getElementById('form_proven_busqueda').reset();
                this.fecha_desde = '';
                this.fecha_hasta = moment().format('YYYY-MM-DD');
                this.errorForm = [];
            },
            buscar: function(event) {

                let select_divisa = document.getElementById('pvdivisas');
                let selectedOptionDiv = select_divisa.options[select_divisa.selectedIndex];

                this.errorForm = [];
                this.cargando = true;
                this.cargando_tabla = 'is-loading is-loading-lg';
                $("#tab_precio_ven").DataTable().destroy();

                axios.get('ingresosegresos/obtenerPrecioProductoVendidos', {
                    params: {
                        fecha_desde: this.fecha_desde,
                        fecha_hasta: this.fecha_hasta,
                        divisa: this.divisa,
                        filtro: this.filtro,
                        sucursal: this.sucursal_predeterminada
                    }
                }).then(response => {
                    if (response.data.errors == null) {
                        this.productos = response.data.productos;
                    } else {
                        this.errorForm = response.data.errors;
                    }
                }).catch(e => notificacion()).finally(() => {
                    this.cargando = false;
                    this.cargando_tabla = '';

                    let buttonCommon = {
                        exportOptions: {
                            format: {
                                body: function(data, row, column, node) {
                                    if (column === 2 || column === 3 || column === 4 || column === 5 || column === 6) {
                                        return convertir_a_float(data)
                                    } else {
                                        return data.replace(/<[^>]*>?/g, '');
                                    }
                                }
                            }
                        }
                    };

                    $("#tab_precio_ven").DataTable({
                        order: [],
                        dom: 'Bfrtip',
                        buttons: [
                            $.extend(true, {}, buttonCommon, {
                                extend: 'excelHtml5',
                                title: 'Productos vendidos desde ' +
                                    moment(this.fecha_desde).format('DD-MM-YYYY') +
                                    ' hasta ' +
                                    moment(this.fecha_desde).format('DD-MM-YYYY') +
                                    ' Divisa (' + selectedOptionDiv.text + ')',
                            }),
                        ]
                    });
                });
            },
            moneda(num, div_locale, div_simbolo, decimal = 2) {
                return monedaMoneda(num, div_locale, div_simbolo, decimal);
            },
            decimal(num, div_locale, decimal = 2) {
                return monedaDecimal(num, div_locale, decimal);
            }
        }
    });
</script>