<div class="row mt-2">
    <div class="col-lg-4">
        <div class="row row-card-no-pd">
            <?php

            use Core\Helpers\Moneda;

            foreach ($monedas as $row) : ?>
                <div class="col-sm-6 col-md-12">
                    <div class="card card-stats card-round">
                        <div class="card-body ">
                            <div class="row">
                                <div class="col-3">
                                    <div class="icon-big text-center">
                                        <i class="flaticon-coins text-success"></i>
                                    </div>
                                </div>
                                <div class="col-9 col-stats">
                                    <div class="numbers">
                                        <p class="card-category"><?= $row['divisa']['divisa'] ?></p>
                                        <h4 class="card-title">
                                            <?= Moneda::moneda($row['total'], $row['divisa']['locale'], $row['divisa']['symbol'], $row['divisa']['precision']) ?>
                                        </h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <div class="col-lg-8">
        <div class="card">
            <div class="card-body">
                <div class="card-title">
                    <h5>Total segun bancos</h5>
                </div>
                <div class="table-responsive">
                    <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_total_bancos">
                        <thead>
                            <tr>
                                <th style="width: 15px;" >Banco/Divisa</th>
                                <th style="width: 15%;">Cuenta</th>
                                <th style="width: 15px;">Tipo</th>
                                <th style="width: 15px;">Monto</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($bancos as $row) : ?>
                                <tr>
                                    <td style="width: 15px;"><?= $row['banco'] ?><b class="text-success"> (<?= $row['divisa'] ?>)</b></td>
                                    <td style="width: 15px;"><?= $row['cuenta'] ?></td>
                                    <td style="width: 15px;"><?= $row['tipo'] ?></td>
                                    <td style="width: 15px;" class="text-right"><?= $row['total'] ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(function() {

        let buttonCommon = {
            exportOptions: {
                columns: [0, 1, 2, 3, 4],
                format: {
                    body: function(data, row, column, node) {
                        if (column === 4) {
                            return convertir_a_float(data)
                        } else {
                            return data.replace(/<[^>]*>?/g, '');
                        }
                    }
                }
            }
        };

        $("#tabla_total_bancos").DataTable({
            order: [],
            dom: 'Bfrtip',
            buttons: [
                $.extend(true, {}, buttonCommon, {
                    extend: 'excelHtml5',
                    title: 'Total segun bancos ' + moment().format('DD-MM-YYYY'),
                }),
            ]
        });
    });
</script>
