<?php

use Core\Helpers\Documento;
use Core\Helpers\Moneda;

$doc_ = Documento::obtener(12);

?>
<div class="row">
    <div class="col-12">
        <div class="row row-card-no-pd">
            <?php foreach ($cli_pendiente['divisas_totales'] as $row) : ?>
                <div class="col-sm-6 col-md-3">
                    <div class="card card-stats card-round">
                        <div class="card-body ">
                            <div class="row">
                                <div class="col-4">
                                    <div class="icon-big text-center">
                                        <i class="flaticon-coins text-success"></i>
                                    </div>
                                </div>
                                <div class="col-8 col-stats">
                                    <div class="numbers">
                                        <p class="card-category">Total pendiente</p>
                                        <h4 class="card-title">
                                            <?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?>
                                        </h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Notas de entrega pendientes</div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="display table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_notas_pendientes">
                        <thead>
                            <tr>
                                <th class="text-left">Documento</th>
                                <th class="text-left">Agente</th>
                                <th class="text-left">ID Cliente</th>
                                <th class="text-left">Cliente</th>
                                <th class="text-left">ID Grupo</th>
                                <th class="text-left">Grupo</th>
                                <th class="text-left">Divisa</th>
                                <th class="text-right">Total</th>
                                <th class="text-right">Acumulado</th>
                                <th class="text-right">Pendiente</th>
                                <th>Fecha</th>
                                <th>Sucursal</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($cli_pendiente['notas_pendiente'] as $row) : ?>
                                <tr>
                                    <td class="text-left"><a href="<?= ruta_base().$row['url'] ?>"><?= $row['tipo'] ?></a></td>
                                    <td class="text-left"><?= $row['agente'] ?></td>
                                    <td class="text-left"><?= $row['id_cliente'] ?></td>
                                    <td class="text-left"><?= $row['nombrecompl'] ?></td>
                                    <td class="text-left"><?= $row['id_grupo'] ?></td>
                                    <td class="text-left"><?= $row['grupo'] ?></td>
                                    <td class="text-left"><?= $row['divisa'] ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['acumulado'], $row['div_locale'], $row['div_simbolo'])  ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['pendiente'], $row['div_locale'], $row['div_simbolo'])  ?></td>
                                    <td><?= $row['fecha'] ?></td>
                                    <td><?= $row['sucursal'] ?></td>
                                    <td class="text-center">
                                        <div class="form-button-action">
                                            <div class="input-group-append">
                                                <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>notasdeentregaeditar/verFactura/<?= $row['id'] ?>" target="_blank">ver</a>
                                                    <div role="separator" class="dropdown-divider"></div>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>notasdeentregaeditar/pdf/<?= $row['id'] ?>" target="_blank">PDF completo</a>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>notasdeentregaeditar/pdfMP/<?= $row['id'] ?>" target="_blank">PDF media pagina</a>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>notasdeentregaeditar/pdfFMP/<?= $row['id'] ?>" target="_blank">PDF pagos</a>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="row row-card-no-pd">
            <?php foreach ($cli_pendiente['totales_divisas_not'] as $row) : ?>
                <div class="col-sm-6 col-md-3">
                    <div class="card card-stats card-round">
                        <div class="card-body ">
                            <div class="row">
                                <div class="col-4">
                                    <div class="icon-big text-center">
                                        <i class="flaticon-coins text-success"></i>
                                    </div>
                                </div>
                                <div class="col-8 col-stats">
                                    <div class="numbers">
                                        <p class="card-category">Nota total pendiente</p>
                                        <h4 class="card-title">
                                            <?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?>
                                        </h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Facturas pendientes</div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_factura_pendientes">
                        <thead>
                            <tr>
                                <th class="text-left">Documento</th>
                                <th class="text-left">Agente</th>
                                <th class="text-left">ID Cliente</th>
                                <th class="text-left">Cliente</th>
                                <th class="text-left">ID Grupo</th>
                                <th class="text-left">Grupo</th>
                                <th class="text-left">Divisa</th>
                                <th class="text-right">Total</th>
                                <th class="text-right">Acumulado</th>
                                <th class="text-right">Pendiente</th>
                                <th>Fecha</th>
                                <th>Sucursal</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($cli_pendiente['facturas_pendiente'] as $row) : ?>
                                <tr>
                                     <td class="text-left"><a href="<?= ruta_base().$row['url'] ?>"><?= $row['tipo'] ?></a></td>
                                    <td class="text-left"><?= $row['agente'] ?></td>
                                    <td class="text-left"><?= $row['id_cliente'] ?></td>
                                    <td class="text-left"><?= $row['nombrecompl'] ?></td>
                                    <td class="text-left"><?= $row['id_grupo'] ?></td>
                                    <td class="text-left"><?= $row['grupo'] ?></td>
                                    <td class="text-left"><?= $row['divisa'] ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['acumulado'], $row['div_locale'], $row['div_simbolo'])  ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['pendiente'], $row['div_locale'], $row['div_simbolo'])  ?></td>
                                    <td><?= $row['fecha'] ?></td>
                                    <td><?= $row['sucursal'] ?></td>
                                    <td class="text-center">
                                        <div class="form-button-action">
                                            <div class="input-group-append">
                                                <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>poseditar/verFactura/<?= $row['id'] ?>" target="_blank">ver</a>
                                                    <div role="separator" class="dropdown-divider"></div>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>poseditar/pdf/<?= $row['id'] ?>" target="_blank">PDF completo</a>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>poseditar/pdfMP/<?= $row['id'] ?>" target="_blank">PDF media pagina</a>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>poseditar/pdfFMP/<?= $row['id'] ?>" target="_blank">PDF pagos</a>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="row row-card-no-pd">
            <?php foreach ($cli_pendiente['totales_divisas_fac'] as $row) : ?>
                <div class="col-sm-6 col-md-3">
                    <div class="card card-stats card-round">
                        <div class="card-body ">
                            <div class="row">
                                <div class="col-4">
                                    <div class="icon-big text-center">
                                        <i class="flaticon-coins text-success"></i>
                                    </div>
                                </div>
                                <div class="col-8 col-stats">
                                    <div class="numbers">
                                        <p class="card-category">Factura total pendiente</p>
                                        <h4 class="card-title">
                                            <?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?>
                                        </h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title"><?= $doc_['descripcion']  ?> pendientes</div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="display nowrap table table-striped table-hover dataTable table-head-bg-primary table-bordered-bd-primary" id="tabla_ordenes_pendientes">
                        <thead>
                            <tr>
                                <th class="text-left">Documento</th>
                                <th class="text-left">Agente</th>
                                <th class="text-left">ID Cliente</th>
                                <th class="text-left">Cliente</th>
                                <th class="text-left">ID Grupo</th>
                                <th class="text-left">Grupo</th>
                                <th class="text-left">Divisa</th>
                                <th class="text-right">Total</th>
                                <th class="text-right">Acumulado</th>
                                <th class="text-right">Pendiente</th>
                                <th>Fecha</th>
                                <th>Sucursal</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($cli_pendiente['ordenes_pendientes'] as $row) : ?>
                                <tr>
                                    <td class="text-left"><a href="<?= ruta_base().$row['url'] ?>"><?= $row['tipo'] ?></a></td>
                                    <td class="text-left"><?= $row['agente'] ?></td>
                                    <td class="text-left"><?= $row['id_cliente'] ?></td>
                                    <td class="text-left"><?= $row['nombrecompl'] ?></td>
                                    <td class="text-left"><?= $row['id_grupo'] ?></td>
                                    <td class="text-left"><?= $row['grupo'] ?></td>
                                    <td class="text-left"><?= $row['divisa'] ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['acumulado'], $row['div_locale'], $row['div_simbolo'])  ?></td>
                                    <td class="text-right"><?= Moneda::moneda($row['pendiente'], $row['div_locale'], $row['div_simbolo'])  ?></td>
                                    <td><?= $row['fecha'] ?></td>
                                    <td><?= $row['sucursal'] ?></td>
                                    <td class="text-center">
                                        <div class="form-button-action">
                                            <div class="input-group-append">
                                                <button class="btn btn-sm btn-primary btn-border dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Acciones</button>
                                                <div class="dropdown-menu" x-placement="top-start" style="position: absolute; transform: translate3d(227px, -146px, 0px); top: 0px; left: 0px; will-change: transform;">
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>poseditar/verFactura/<?= $row['id'] ?>" target="_blank">ver</a>
                                                    <div role="separator" class="dropdown-divider"></div>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>poseditar/pdf/<?= $row['id'] ?>" target="_blank">PDF completo</a>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>poseditar/pdfMP/<?= $row['id'] ?>" target="_blank">PDF media pagina</a>
                                                    <a class="dropdown-item" href="<?= ruta_base() ?>poseditar/pdfFMP/<?= $row['id'] ?>" target="_blank">PDF pagos</a>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12">
        <div class="row row-card-no-pd">
            <?php foreach ($cli_pendiente['totales_divisas_ord'] as $row) : ?>
                <div class="col-sm-6 col-md-3">
                    <div class="card card-stats card-round">
                        <div class="card-body ">
                            <div class="row">
                                <div class="col-4">
                                    <div class="icon-big text-center">
                                        <i class="flaticon-coins text-success"></i>
                                    </div>
                                </div>
                                <div class="col-8 col-stats">
                                    <div class="numbers">
                                        <p class="card-category">Orden total pendiente</p>
                                        <h4 class="card-title">
                                            <?= Moneda::moneda($row['total'], $row['div_locale'], $row['div_simbolo']); ?>
                                        </h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>
<script>
    $(function() {

        var buttonCommon = {
            exportOptions: {
                columns: [0, 1, 2, 3, 4, 5,6,7,8,9,10,11],
                format: {
                    body: function(data, row, column, node) {
                        if (column === 7 || column === 8 || column === 9) {
                            return convertir_a_float(data)
                        } else {
                            return data.replace(/<[^>]*>?/g, '');
                        }
                    }
                }
            }
        };

        $("#tabla_factura_pendientes").DataTable({
            order: [],
            dom: 'Bfrtip',
            buttons: [
                $.extend(true, {}, buttonCommon, {
                    extend: 'excelHtml5',
                    title: 'Clientes con FACTURA pendientes por cobrar ' + moment().format('DD-MM-YYYY'),
                }),
            ]
        });
        $("#tabla_notas_pendientes").DataTable({
            order: [],
            dom: 'Bfrtip',
            buttons: [
                $.extend(true, {}, buttonCommon, {
                    extend: 'excelHtml5',
                    title: 'Clientes con NOTA DE ENTREGA pendientes por cobrar ' + moment().format('DD-MM-YYYY'),
                }),
            ]
        });
        $("#tabla_ordenes_pendientes").DataTable({
            order: [],
            dom: 'Bfrtip',
            buttons: [
                $.extend(true, {}, buttonCommon, {
                    extend: 'excelHtml5',
                    title: 'Clientes con ORDEN DE ENTREGA pendientes por cobrar ' + moment().format('DD-MM-YYYY'),
                }),
            ]
        });
    });
</script>
