<div class="row" id="AppGeneraling" v-cloak>
    <div class="col-lg-12">
        <div class="card">
            <div class="card-title">
                <div class="row m-2">
                    <div class="col-lg-2">
                        <div class="form-group form-group-default">
                            <label for="mes_divisas" class="placeholder">Año</label>
                            <select id="anioingres" name="mes_anio" class="form-control input-border-bottom" onchange="obtenerIngresosEgreso()">
                                <?php for ($m = date('o'); $m >= 2018; $m--) {
                                    if ($m == date('o')) {
                                        echo '<option value="' . $m . '">' . $m . '</option>';
                                    } else {
                                        echo '<option value="' . $m . '">' . $m . '</option>';
                                    }
                                }
                                ?>
                            </select>

                        </div>
                    </div>
                    <div class="col-lg-2 form-group form-group-default">
                        <label for="mes_divisas" class="placeholder">Mes</label>
                        <select id="mes_ingreso_egreso" class="form-control input-border-bottom" onchange="obtenerIngresosEgreso()">
                            <option value="0">Todos</option>
                            <option value="01">Enero</option>
                            <option value="02">Febrero</option>
                            <option value="03">Marzo</option>
                            <option value="04">Abril</option>
                            <option value="05">Mayo</option>
                            <option value="06">Junio</option>
                            <option value="07">Julio</option>
                            <option value="08">Agosto</option>
                            <option value="09">Septiembre</option>
                            <option value="10">Octubre</option>
                            <option value="11">Noviembre</option>
                            <option value="12">Diciembre</option>
                        </select>
                    </div>
                    <div class="col-lg-2">
                        <div class="form-group form-group-default">
                            <label for="tipo_ingreso_egreso" class="placeholder">Ingreso/Egreso</label>
                            <select id="tipo_ingreso_egreso" name="tipo_ingreso_egreso" class="form-control input-border-bottom" onchange="obtenerIngresosEgreso()">
                                <option value="0">Ingreso</option>
                                <option value="1">Egreso</option>
                            </select>

                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="form-group form-group-default">
                            <label for="mes_divisas" class="placeholder">Divisa</label>
                            <select id="divisas_ingreso_egreso" class="form-control input-border-bottom" ref="divisa" onchange="obtenerIngresosEgreso()">
                                <option value="0">Todas</option>
                                <?php foreach ($divisas as $row) : ?>
                                    <option value="<?= $row['div_id'] ?>" <?= ($row['div_predeterminado'] == 1) ? 'selected' : '' ?>><?= $row['div_descripcion'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-lg-3">
                        <div class="form-group form-group-default">
                            <label for="sucursal" class="placeholder">Sucursal</label>
                            <select id="sucursal_ingreso_egreso" v-model="sucursal_predeterminada" class="form-control input-border-bottom" :disabled="disabled" onchange="obtenerIngresosEgreso()">
                                <option disabled value="">Seleccione un elemento</option>
                                <?php if ($todosucursales) : ?>
                                    <option value="0">Todas</option>
                                <?php endif; ?>
                                <option v-for="row in sucursales_empleado" :value="row.su_id"><span v-if="disabled==false"></span>{{row.su_nombre}}</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <canvas id="ingresosegresosmes" height="325"></canvas>
            </div>
        </div>
    </div>
</div>
<script>
    new Vue({
        el: '#AppGeneraling',
        data: {
            meses: [],
            errorForm: [],
            cargando: false,
            cargando_tabla: 'is-loading is-loading-lg',
            sucursal_predeterminada: '',
            sucursales_empleado: [],
            sucursals: '',
            disabled: false
        },
        created() {
            this.obtenerSucursalesEmpleado();
        },
        methods: {
            obtenerSucursalesEmpleado() {
                axios
                    .get("ingresosegresos/obtenerSucursalesEmpleado")
                    .then((response) => {
                        this.sucursales_empleado = response.data.sucursales;
                        this.sucursal_predeterminada = response.data.id;
                        if (response.data.desactivar == true) {
                            this.disabled = true
                        }
                    })
                    .catch((e) => notificacion());
            }
        }
    });
    var chartIngresoEgresomes = '';
    var ingresoegresoMes = document.getElementById('ingresosegresosmes').getContext('2d');

    function obtenerIngresosEgreso() {
        chartIngresoEgresomes.destroy();

        _ingresosEgreso();
        //}
    }

    function _ingresosEgreso() {

        let anio = document.getElementById("anioingres").value;
        let mes = document.getElementById("mes_ingreso_egreso").value;
        let tipo = document.getElementById("tipo_ingreso_egreso").value;
        let sucursal = document.getElementById("sucursal_ingreso_egreso").value;
        let divisa = document.getElementById("divisas_ingreso_egreso").value;

        axios({
            method: 'post',
            url: 'ingresosegresos/buscarBalanceGrafica',
            data: {
                anio: anio,
                mes: mes,
                tipo: tipo,
                sucursal: sucursal,
                divisa:divisa
            },
            transformRequest: serializar(),
        }).then(response => {
            let ingreso_dsm = response.data.balance;

            let color = (tipo == 1) ? '#e4ea24' : '#34df34';
            let borcolor = (tipo == 1) ? '#e4ea2482' : '#34df3480';
            let label = (tipo == 1) ? 'Egresos' : 'Ingresos';
            let dsm_montos = [0];
            let dsm_label = [0];
            let i = 0;
            Object.keys(ingreso_dsm).forEach(function(k) {
                dsm_montos[i] = ingreso_dsm[k].monto;
                dsm_label[i] = ingreso_dsm[k].categoria;
                i += 1;
            });

            chartIngresoEgresomes = new Chart(ingresoegresoMes, {
                type: 'line',
                data: {
                    labels: dsm_label,
                    datasets: [{
                        label: label,
                        data: dsm_montos,
                        backgroundColor: color,
                        borderColor: borcolor,
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    title: {
                        display: true,
                        text: 'Reporte de ingreso/Egreso por categoria'
                    },
                    tooltips: {
                        callbacks: {
                            label: function(tooltipItem, chart) {
                                var datasetLabel = chart.datasets[tooltipItem.datasetIndex].label || '';
                                return datasetLabel + ' ' + monedaMoneda(tooltipItem.yLabel, response.data.div_locale, response.data.div_simbolo);

                            },
                        }
                    },
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true,
                                callback: function(value, index, values) {
                                    return value;
                                }
                            }
                        }]
                    }
                }
            });

        });
    }
    window.onload = _ingresosEgreso();
    ///     });
</script>